const { expect } = require('chai');

const Client = require('../src/Client');

describe('Client', () => {
  it('should throw an error if options are missing', () => {
    expect(() => new Client()).to.throw('Options are required.');
  });
  it('should throw an error if missing host', () => {
    expect(() => new Client({})).to.throw('"host" is required');
  });
  it('should set default options if not included', () => {
    const client = new Client({
      host: '192.168.1.10',
    });
    expect(client.options).to.have.property('hostPort', 1812);
    expect(client.options).to.have.property('timeout', 2500);
    expect(client.options).to.have.property('retries', 3);
  });
});
