const dictionaries = require('./dictionaries.json');

/**
  * Converts an object of attribute / values into an array of arrays for use with radius.encode.
  * @param {object} attributeObj - An object of attribute / values.
  * @returns {array} array - An array of arrays
*/
function attributesToArray(attributeObj) {
  return Object
    .keys(attributeObj)
    .reduce((attributesArr, attribute) => {
      attributesArr.push([attribute, attributeObj[attribute]]);
      return attributesArr;
    }, []);
}

module.exports = {
  dictionaries,
  attributesToArray,
};
