"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// event.ts
var event_exports = {};
__export(event_exports, {
  Kind: () => Kind,
  finishEvent: () => finishEvent,
  getBlankEvent: () => getBlankEvent,
  getEventHash: () => getEventHash,
  getSignature: () => getSignature,
  serializeEvent: () => serializeEvent,
  signEvent: () => signEvent,
  validateEvent: () => validateEvent,
  verifiedSymbol: () => verifiedSymbol,
  verifySignature: () => verifySignature
});
module.exports = __toCommonJS(event_exports);
var import_secp256k12 = require("@noble/curves/secp256k1");
var import_sha256 = require("@noble/hashes/sha256");
var import_utils2 = require("@noble/hashes/utils");

// keys.ts
var import_secp256k1 = require("@noble/curves/secp256k1");
var import_utils = require("@noble/hashes/utils");
function getPublicKey(privateKey) {
  return (0, import_utils.bytesToHex)(import_secp256k1.schnorr.getPublicKey(privateKey));
}

// utils.ts
var utf8Decoder = new TextDecoder("utf-8");
var utf8Encoder = new TextEncoder();

// event.ts
var verifiedSymbol = Symbol("verified");
var Kind = /* @__PURE__ */ ((Kind2) => {
  Kind2[Kind2["Metadata"] = 0] = "Metadata";
  Kind2[Kind2["Text"] = 1] = "Text";
  Kind2[Kind2["RecommendRelay"] = 2] = "RecommendRelay";
  Kind2[Kind2["Contacts"] = 3] = "Contacts";
  Kind2[Kind2["EncryptedDirectMessage"] = 4] = "EncryptedDirectMessage";
  Kind2[Kind2["EventDeletion"] = 5] = "EventDeletion";
  Kind2[Kind2["Repost"] = 6] = "Repost";
  Kind2[Kind2["Reaction"] = 7] = "Reaction";
  Kind2[Kind2["BadgeAward"] = 8] = "BadgeAward";
  Kind2[Kind2["ChannelCreation"] = 40] = "ChannelCreation";
  Kind2[Kind2["ChannelMetadata"] = 41] = "ChannelMetadata";
  Kind2[Kind2["ChannelMessage"] = 42] = "ChannelMessage";
  Kind2[Kind2["ChannelHideMessage"] = 43] = "ChannelHideMessage";
  Kind2[Kind2["ChannelMuteUser"] = 44] = "ChannelMuteUser";
  Kind2[Kind2["Blank"] = 255] = "Blank";
  Kind2[Kind2["Report"] = 1984] = "Report";
  Kind2[Kind2["ZapRequest"] = 9734] = "ZapRequest";
  Kind2[Kind2["Zap"] = 9735] = "Zap";
  Kind2[Kind2["RelayList"] = 10002] = "RelayList";
  Kind2[Kind2["ClientAuth"] = 22242] = "ClientAuth";
  Kind2[Kind2["NwcRequest"] = 23194] = "NwcRequest";
  Kind2[Kind2["HttpAuth"] = 27235] = "HttpAuth";
  Kind2[Kind2["ProfileBadge"] = 30008] = "ProfileBadge";
  Kind2[Kind2["BadgeDefinition"] = 30009] = "BadgeDefinition";
  Kind2[Kind2["Article"] = 30023] = "Article";
  Kind2[Kind2["FileMetadata"] = 1063] = "FileMetadata";
  return Kind2;
})(Kind || {});
function getBlankEvent(kind = 255 /* Blank */) {
  return {
    kind,
    content: "",
    tags: [],
    created_at: 0
  };
}
function finishEvent(t, privateKey) {
  const event = t;
  event.pubkey = getPublicKey(privateKey);
  event.id = getEventHash(event);
  event.sig = getSignature(event, privateKey);
  event[verifiedSymbol] = true;
  return event;
}
function serializeEvent(evt) {
  if (!validateEvent(evt))
    throw new Error("can't serialize event with wrong or missing properties");
  return JSON.stringify([0, evt.pubkey, evt.created_at, evt.kind, evt.tags, evt.content]);
}
function getEventHash(event) {
  let eventHash = (0, import_sha256.sha256)(utf8Encoder.encode(serializeEvent(event)));
  return (0, import_utils2.bytesToHex)(eventHash);
}
var isRecord = (obj) => obj instanceof Object;
function validateEvent(event) {
  if (!isRecord(event))
    return false;
  if (typeof event.kind !== "number")
    return false;
  if (typeof event.content !== "string")
    return false;
  if (typeof event.created_at !== "number")
    return false;
  if (typeof event.pubkey !== "string")
    return false;
  if (!event.pubkey.match(/^[a-f0-9]{64}$/))
    return false;
  if (!Array.isArray(event.tags))
    return false;
  for (let i = 0; i < event.tags.length; i++) {
    let tag = event.tags[i];
    if (!Array.isArray(tag))
      return false;
    for (let j = 0; j < tag.length; j++) {
      if (typeof tag[j] === "object")
        return false;
    }
  }
  return true;
}
function verifySignature(event) {
  if (typeof event[verifiedSymbol] === "boolean")
    return event[verifiedSymbol];
  const hash = getEventHash(event);
  if (hash !== event.id) {
    return event[verifiedSymbol] = false;
  }
  try {
    return event[verifiedSymbol] = import_secp256k12.schnorr.verify(event.sig, hash, event.pubkey);
  } catch (err) {
    return event[verifiedSymbol] = false;
  }
}
function signEvent(event, key) {
  console.warn(
    "nostr-tools: `signEvent` is deprecated and will be removed or changed in the future. Please use `getSignature` instead."
  );
  return getSignature(event, key);
}
function getSignature(event, key) {
  return (0, import_utils2.bytesToHex)(import_secp256k12.schnorr.sign(getEventHash(event), key));
}
