// keys.ts
import { schnorr } from "@noble/curves/secp256k1";
import { bytesToHex } from "@noble/hashes/utils";
function generatePrivateKey() {
  return bytesToHex(schnorr.utils.randomPrivateKey());
}
function getPublicKey(privateKey) {
  return bytesToHex(schnorr.getPublicKey(privateKey));
}
export {
  generatePrivateKey,
  getPublicKey
};
