// kinds.ts
function isRegularKind(kind) {
  return 1e3 <= kind && kind < 1e4 || [1, 2, 4, 5, 6, 7, 8, 16, 40, 41, 42, 43, 44].includes(kind);
}
function isReplaceableKind(kind) {
  return 1e4 <= kind && kind < 2e4 || [0, 3].includes(kind);
}
function isEphemeralKind(kind) {
  return 2e4 <= kind && kind < 3e4;
}
function isParameterizedReplaceableKind(kind) {
  return 3e4 <= kind && kind < 4e4;
}
function classifyKind(kind) {
  if (isRegularKind(kind))
    return "regular";
  if (isReplaceableKind(kind))
    return "replaceable";
  if (isEphemeralKind(kind))
    return "ephemeral";
  if (isParameterizedReplaceableKind(kind))
    return "parameterized";
  return "unknown";
}
export {
  classifyKind,
  isEphemeralKind,
  isParameterizedReplaceableKind,
  isRegularKind,
  isReplaceableKind
};
