import { Event } from './event.ts';
export type Filter<K extends number = number> = {
    ids?: string[];
    kinds?: K[];
    authors?: string[];
    since?: number;
    until?: number;
    limit?: number;
    search?: string;
    [key: `#${string}`]: string[] | undefined;
};
export declare function matchFilter(filter: Filter<number>, event: Event<number>): boolean;
export declare function matchFilters(filters: Filter<number>[], event: Event<number>): boolean;
export declare function mergeFilters(...filters: Filter<number>[]): Filter<number>;
