/** Events are **regular**, which means they're all expected to be stored by relays. */
declare function isRegularKind(kind: number): boolean;
/** Events are **replaceable**, which means that, for each combination of `pubkey` and `kind`, only the latest event is expected to (SHOULD) be stored by relays, older versions are expected to be discarded. */
declare function isReplaceableKind(kind: number): boolean;
/** Events are **ephemeral**, which means they are not expected to be stored by relays. */
declare function isEphemeralKind(kind: number): boolean;
/** Events are **parameterized replaceable**, which means that, for each combination of `pubkey`, `kind` and the `d` tag, only the latest event is expected to be stored by relays, older versions are expected to be discarded. */
declare function isParameterizedReplaceableKind(kind: number): boolean;
/** Classification of the event kind. */
type KindClassification = 'regular' | 'replaceable' | 'ephemeral' | 'parameterized' | 'unknown';
/** Determine the classification of this kind of event if known, or `unknown`. */
declare function classifyKind(kind: number): KindClassification;
export { classifyKind, isEphemeralKind, isParameterizedReplaceableKind, isRegularKind, isReplaceableKind, type KindClassification, };
