export declare const utils: {
    v2: {
        maxPlaintextSize: number;
        minCiphertextSize: number;
        maxCiphertextSize: number;
        getConversationKey(privkeyA: string, pubkeyB: string): Uint8Array;
        getMessageKeys(conversationKey: Uint8Array, salt: Uint8Array): {
            encryption: Uint8Array;
            nonce: Uint8Array;
            auth: Uint8Array;
        };
        calcPadding(len: number): number;
        pad(unpadded: string): Uint8Array;
        unpad(padded: Uint8Array): string;
    };
};
export declare function encrypt(key: Uint8Array, plaintext: string, options?: {
    salt?: Uint8Array;
    version?: number;
}): string;
export declare function decrypt(key: Uint8Array, ciphertext: string): string;
