import { Event, EventTemplate } from './event';
/**
 * Generate token for NIP-98 flow.
 *
 * @example
 * const sign = window.nostr.signEvent
 * await nip98.getToken('https://example.com/login', 'post', (e) => sign(e), true)
 */
export declare function getToken(loginUrl: string, httpMethod: string, sign: <K extends number = number>(e: EventTemplate<K>) => Promise<Event<K>> | Event<K>, includeAuthorizationScheme?: boolean): Promise<string>;
/**
 * Validate token for NIP-98 flow.
 *
 * @example
 * await nip98.validateToken('Nostr base64token', 'https://example.com/login', 'post')
 */
export declare function validateToken(token: string, url: string, method: string): Promise<boolean>;
export declare function unpackEventFromToken(token: string): Promise<Event>;
export declare function validateEvent(event: Event, url: string, method: string): Promise<boolean>;
