"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _bitn = _interopRequireDefault(require("./bitn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x01]);
const NULL_LENGTH = Buffer.from([0x00]);
const Bit = {
  id: 0x32,
  type: 'BIT',
  name: 'Bit',
  declaration: function () {
    return 'bit';
  },

  generateTypeInfo() {
    return Buffer.from([_bitn.default.id, 0x01]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield parameter.value ? Buffer.from([0x01]) : Buffer.from([0x00]);
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (value) {
      return true;
    } else {
      return false;
    }
  }
};
var _default = Bit;
exports.default = _default;
module.exports = Bit;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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