"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _intn = _interopRequireDefault(require("./intn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x01]);
const NULL_LENGTH = Buffer.from([0x00]);
const TinyInt = {
  id: 0x30,
  type: 'INT1',
  name: 'TinyInt',
  declaration: function () {
    return 'tinyint';
  },

  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x01]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(1);
    buffer.writeUInt8(Number(parameter.value), 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'number') {
      value = Number(value);
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    if (value < 0 || value > 255) {
      throw new TypeError('Value must be between 0 and 255, inclusive.');
    }

    return value | 0;
  }
};
var _default = TinyInt;
exports.default = _default;
module.exports = TinyInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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