"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _metadataParser = _interopRequireDefault(require("../metadata-parser"));

var _token = require("./token");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function readTableName(parser, options, metadata, callback) {
  if (metadata.type.hasTableName) {
    if (options.tdsVersion >= '7_2') {
      parser.readUInt8(numberOfTableNameParts => {
        const tableName = [];
        let i = 0;

        function next(done) {
          if (numberOfTableNameParts === i) {
            return done();
          }

          parser.readUsVarChar(part => {
            tableName.push(part);
            i++;
            next(done);
          });
        }

        next(() => {
          callback(tableName);
        });
      });
    } else {
      parser.readUsVarChar(callback);
    }
  } else {
    callback(undefined);
  }
}

function readColumnName(parser, options, index, metadata, callback) {
  parser.readBVarChar(colName => {
    if (options.columnNameReplacer) {
      callback(options.columnNameReplacer(colName, index, metadata));
    } else if (options.camelCaseColumns) {
      callback(colName.replace(/^[A-Z]/, function (s) {
        return s.toLowerCase();
      }));
    } else {
      callback(colName);
    }
  });
}

function readColumn(parser, options, index, callback) {
  (0, _metadataParser.default)(parser, options, metadata => {
    readTableName(parser, options, metadata, tableName => {
      readColumnName(parser, options, index, metadata, colName => {
        callback({
          userType: metadata.userType,
          flags: metadata.flags,
          type: metadata.type,
          collation: metadata.collation,
          precision: metadata.precision,
          scale: metadata.scale,
          udtInfo: metadata.udtInfo,
          dataLength: metadata.dataLength,
          schema: metadata.schema,
          colName: colName,
          tableName: tableName
        });
      });
    });
  });
}

async function colMetadataParser(parser) {
  while (parser.buffer.length - parser.position < 2) {
    await parser.streamBuffer.waitForChunk();
  }

  const columnCount = parser.buffer.readUInt16LE(parser.position);
  parser.position += 2;
  const columns = [];

  for (let i = 0; i < columnCount; i++) {
    let column;
    readColumn(parser, parser.options, i, c => {
      column = c;
    });

    while (parser.suspended) {
      await parser.streamBuffer.waitForChunk();
      parser.suspended = false;
      const next = parser.next;
      next();
    }

    columns.push(column);
  }

  return new _token.ColMetadataToken(columns);
}

var _default = colMetadataParser;
exports.default = _default;
module.exports = colMetadataParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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