"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

const FEATURE_ID = {
  SESSIONRECOVERY: 0x01,
  FEDAUTH: 0x02,
  COLUMNENCRYPTION: 0x04,
  GLOBALTRANSACTIONS: 0x05,
  AZURESQLSUPPORT: 0x08,
  UTF8_SUPPORT: 0x0A,
  TERMINATOR: 0xFF
};

function featureExtAckParser(parser, _options, callback) {
  let fedAuth;
  let utf8Support;

  function next() {
    parser.readUInt8(featureId => {
      if (featureId === FEATURE_ID.TERMINATOR) {
        return callback(new _token.FeatureExtAckToken(fedAuth, utf8Support));
      }

      parser.readUInt32LE(featureAckDataLen => {
        parser.readBuffer(featureAckDataLen, featureData => {
          switch (featureId) {
            case FEATURE_ID.FEDAUTH:
              fedAuth = featureData;
              break;

            case FEATURE_ID.UTF8_SUPPORT:
              utf8Support = !!featureData[0];
              break;
          }

          next();
        });
      });
    });
  }

  next();
}

var _default = featureExtAckParser;
exports.default = _default;
module.exports = featureExtAckParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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