"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

const FEDAUTHINFOID = {
  STSURL: 0x01,
  SPN: 0x02
};

function fedAuthInfoParser(parser, _options, callback) {
  parser.readUInt32LE(tokenLength => {
    parser.readBuffer(tokenLength, data => {
      let spn, stsurl;
      let offset = 0;
      const countOfInfoIDs = data.readUInt32LE(offset);
      offset += 4;

      for (let i = 0; i < countOfInfoIDs; i++) {
        const fedauthInfoID = data.readUInt8(offset);
        offset += 1;
        const fedAuthInfoDataLen = data.readUInt32LE(offset);
        offset += 4;
        const fedAuthInfoDataOffset = data.readUInt32LE(offset);
        offset += 4;

        switch (fedauthInfoID) {
          case FEDAUTHINFOID.SPN:
            spn = data.toString('ucs2', fedAuthInfoDataOffset, fedAuthInfoDataOffset + fedAuthInfoDataLen);
            break;

          case FEDAUTHINFOID.STSURL:
            stsurl = data.toString('ucs2', fedAuthInfoDataOffset, fedAuthInfoDataOffset + fedAuthInfoDataLen);
            break;
          // ignoring unknown fedauthinfo options

          default:
            break;
        }
      }

      callback(new _token.FedAuthInfoToken(spn, stsurl));
    });
  });
}

var _default = fedAuthInfoParser;
exports.default = _default;
module.exports = fedAuthInfoParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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