"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorParser = errorParser;
exports.infoParser = infoParser;

var _token = require("./token");

function parseToken(parser, options, callback) {
  // length
  parser.readUInt16LE(() => {
    parser.readUInt32LE(number => {
      parser.readUInt8(state => {
        parser.readUInt8(clazz => {
          parser.readUsVarChar(message => {
            parser.readBVarChar(serverName => {
              parser.readBVarChar(procName => {
                (options.tdsVersion < '7_2' ? parser.readUInt16LE : parser.readUInt32LE).call(parser, lineNumber => {
                  callback({
                    'number': number,
                    'state': state,
                    'class': clazz,
                    'message': message,
                    'serverName': serverName,
                    'procName': procName,
                    'lineNumber': lineNumber
                  });
                });
              });
            });
          });
        });
      });
    });
  });
}

function infoParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.InfoMessageToken(data));
  });
}

function errorParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.ErrorMessageToken(data));
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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