"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

var _tdsVersions = require("../tds-versions");

const interfaceTypes = {
  0: 'SQL_DFLT',
  1: 'SQL_TSQL'
};

function loginAckParser(parser, _options, callback) {
  // length
  parser.readUInt16LE(() => {
    parser.readUInt8(interfaceNumber => {
      const interfaceType = interfaceTypes[interfaceNumber];
      parser.readUInt32BE(tdsVersionNumber => {
        const tdsVersion = _tdsVersions.versionsByValue[tdsVersionNumber];
        parser.readBVarChar(progName => {
          parser.readUInt8(major => {
            parser.readUInt8(minor => {
              parser.readUInt8(buildNumHi => {
                parser.readUInt8(buildNumLow => {
                  callback(new _token.LoginAckToken({
                    interface: interfaceType,
                    tdsVersion: tdsVersion,
                    progName: progName,
                    progVersion: {
                      major: major,
                      minor: minor,
                      buildNumHi: buildNumHi,
                      buildNumLow: buildNumLow
                    }
                  }));
                });
              });
            });
          });
        });
      });
    });
  });
}

var _default = loginAckParser;
exports.default = _default;
module.exports = loginAckParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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