"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

var _valueParser = _interopRequireDefault(require("../value-parser"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// s2.2.7.13 (introduced in TDS 7.3.B)
function nullHandler(_parser, _columnMetadata, _options, callback) {
  callback(null);
}

async function nbcRowParser(parser) {
  const colMetadata = parser.colMetadata;
  const bitmapByteLength = Math.ceil(colMetadata.length / 8);
  const columns = [];
  const bitmap = [];

  while (parser.buffer.length - parser.position < bitmapByteLength) {
    await parser.streamBuffer.waitForChunk();
  }

  const bytes = parser.buffer.slice(parser.position, parser.position + bitmapByteLength);
  parser.position += bitmapByteLength;

  for (let i = 0, len = bytes.length; i < len; i++) {
    const byte = bytes[i];
    bitmap.push(byte & 0b1 ? true : false);
    bitmap.push(byte & 0b10 ? true : false);
    bitmap.push(byte & 0b100 ? true : false);
    bitmap.push(byte & 0b1000 ? true : false);
    bitmap.push(byte & 0b10000 ? true : false);
    bitmap.push(byte & 0b100000 ? true : false);
    bitmap.push(byte & 0b1000000 ? true : false);
    bitmap.push(byte & 0b10000000 ? true : false);
  }

  for (let i = 0; i < colMetadata.length; i++) {
    const currColMetadata = colMetadata[i];
    let value;
    (bitmap[i] ? nullHandler : _valueParser.default)(parser, currColMetadata, parser.options, v => {
      value = v;
    });

    while (parser.suspended) {
      await parser.streamBuffer.waitForChunk();
      parser.suspended = false;
      const next = parser.next;
      next();
    }

    columns.push({
      value,
      metadata: currColMetadata
    });
  }

  if (parser.options.useColumnNames) {
    const columnsMap = {};
    columns.forEach(column => {
      const colName = column.metadata.colName;

      if (columnsMap[colName] == null) {
        columnsMap[colName] = column;
      }
    });
    return new _token.NBCRowToken(columnsMap);
  } else {
    return new _token.NBCRowToken(columns);
  }
}

var _default = nbcRowParser;
exports.default = _default;
module.exports = nbcRowParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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