"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

// s2.2.7.14
function orderParser(parser, _options, callback) {
  parser.readUInt16LE(length => {
    const columnCount = length / 2;
    const orderColumns = [];
    let i = 0;

    function next(done) {
      if (i === columnCount) {
        return done();
      }

      parser.readUInt16LE(column => {
        orderColumns.push(column);
        i++;
        next(done);
      });
    }

    next(() => {
      callback(new _token.OrderToken(orderColumns));
    });
  });
}

var _default = orderParser;
exports.default = _default;
module.exports = orderParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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