"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

var _metadataParser = _interopRequireDefault(require("../metadata-parser"));

var _valueParser = _interopRequireDefault(require("../value-parser"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// s2.2.7.16
function returnParser(parser, options, callback) {
  parser.readUInt16LE(paramOrdinal => {
    parser.readBVarChar(paramName => {
      if (paramName.charAt(0) === '@') {
        paramName = paramName.slice(1);
      } // status


      parser.readUInt8(() => {
        (0, _metadataParser.default)(parser, options, metadata => {
          (0, _valueParser.default)(parser, metadata, options, value => {
            callback(new _token.ReturnValueToken({
              paramOrdinal: paramOrdinal,
              paramName: paramName,
              metadata: metadata,
              value: value
            }));
          });
        });
      });
    });
  });
}

var _default = returnParser;
exports.default = _default;
module.exports = returnParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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