"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

function parseChallenge(buffer) {
  const challenge = {};
  challenge.magic = buffer.slice(0, 8).toString('utf8');
  challenge.type = buffer.readInt32LE(8);
  challenge.domainLen = buffer.readInt16LE(12);
  challenge.domainMax = buffer.readInt16LE(14);
  challenge.domainOffset = buffer.readInt32LE(16);
  challenge.flags = buffer.readInt32LE(20);
  challenge.nonce = buffer.slice(24, 32);
  challenge.zeroes = buffer.slice(32, 40);
  challenge.targetLen = buffer.readInt16LE(40);
  challenge.targetMax = buffer.readInt16LE(42);
  challenge.targetOffset = buffer.readInt32LE(44);
  challenge.oddData = buffer.slice(48, 56);
  challenge.domain = buffer.slice(56, 56 + challenge.domainLen).toString('ucs2');
  challenge.target = buffer.slice(56 + challenge.domainLen, 56 + challenge.domainLen + challenge.targetLen);
  return challenge;
}

function sspiParser(parser, _options, callback) {
  parser.readUsVarByte(buffer => {
    callback(new _token.SSPIToken(parseChallenge(buffer), buffer));
  });
}

var _default = sspiParser;
exports.default = _default;
module.exports = sspiParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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