"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Parser = void 0;

var _events = require("events");

var _streamParser = _interopRequireDefault(require("./stream-parser"));

var _stream = require("stream");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Parser extends _events.EventEmitter {
  constructor(message, debug, handler, options) {
    super();
    this.debug = void 0;
    this.options = void 0;
    this.parser = void 0;
    this.debug = debug;
    this.options = options;
    this.parser = _stream.Readable.from(_streamParser.default.parseTokens(message, this.debug, this.options));
    this.parser.on('data', token => {
      handler[token.handlerName](token);
    });
    this.parser.on('drain', () => {
      this.emit('drain');
    });
    this.parser.on('end', () => {
      this.emit('end');
    });
  }

  pause() {
    return this.parser.pause();
  }

  resume() {
    return this.parser.resume();
  }

}

exports.Parser = Parser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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