# Security Policy

## Reporting a Vulnerability

1. Please report security issues to
   <https://github.com/louislam/uptime-kuma/security/advisories/new>.
2. Please also create an empty security issue to alert me, as GitHub Advisories
   do not send a notification, I probably will miss it without this.
   <https://github.com/louislam/uptime-kuma/issues/new?assignees=&labels=help&template=security.md>

- Do not report any upstream dependency issues / scan result by any tools. It will be closed immediately without explanations. Unless you have PoC to prove that the upstream issue affected Uptime Kuma.
- Do not use the public issue tracker or discuss it in public as it will cause
  more damage.

## Do you accept other 3rd-party bug bounty platforms?

At this moment, I DO NOT accept other bug bounty platforms, because I am not
familiar with these platforms and someone has tried to send a phishing link to
me by doing this already. To minimize my own risk, please report through GitHub
Advisories only. I will ignore all 3rd-party bug bounty platforms emails.

## Supported Versions

### Uptime Kuma Versions

You should use or upgrade to the latest version of Uptime Kuma.
All versions are upgradable to the latest version.

### Upgradable Docker Tags

| Tag             | Supported                                                                             |
| --------------- | ------------------------------------------------------------------------------------- |
| 2               | :white_check_mark:                                                                    |
| 2-slim          | :white_check_mark:                                                                    |
| next            | :white_check_mark:                                                                    |
| next-slim       | :white_check_mark:                                                                    |
| 2-rootless      | :white_check_mark:                                                                    |
| 2-slim-rootless | :white_check_mark:                                                                    |
| 1               | [⚠️ Deprecated](https://github.com/louislam/uptime-kuma/wiki/Migration-From-v1-To-v2) |
| 1-debian        | [⚠️ Deprecated](https://github.com/louislam/uptime-kuma/wiki/Migration-From-v1-To-v2) |
| latest          | [⚠️ Deprecated](https://github.com/louislam/uptime-kuma/wiki/Migration-From-v1-To-v2) |
| debian          | [⚠️ Deprecated](https://github.com/louislam/uptime-kuma/wiki/Migration-From-v1-To-v2) |
| All other tags  | ❌                                                                                    |
