import type { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CognitoIdentityServiceException as __BaseException } from "./CognitoIdentityServiceException";
/**
 * <p>Thrown when the service encounters an error during processing the request.</p>
 * @public
 */
export declare class InternalErrorException extends __BaseException {
    readonly name: "InternalErrorException";
    readonly $fault: "server";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InternalErrorException, __BaseException>);
}
/**
 * <p>Thrown for missing or bad input parameter(s).</p>
 * @public
 */
export declare class InvalidParameterException extends __BaseException {
    readonly name: "InvalidParameterException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidParameterException, __BaseException>);
}
/**
 * <p>Thrown when the total number of user pools has exceeded a preset limit.</p>
 * @public
 */
export declare class LimitExceededException extends __BaseException {
    readonly name: "LimitExceededException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<LimitExceededException, __BaseException>);
}
/**
 * <p>Thrown when a user is not authorized to access the requested resource.</p>
 * @public
 */
export declare class NotAuthorizedException extends __BaseException {
    readonly name: "NotAuthorizedException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NotAuthorizedException, __BaseException>);
}
/**
 * <p>Thrown when a user tries to use a login which is already linked to another
 *          account.</p>
 * @public
 */
export declare class ResourceConflictException extends __BaseException {
    readonly name: "ResourceConflictException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceConflictException, __BaseException>);
}
/**
 * <p>Thrown when a request is throttled.</p>
 * @public
 */
export declare class TooManyRequestsException extends __BaseException {
    readonly name: "TooManyRequestsException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyRequestsException, __BaseException>);
}
/**
 * <p>Thrown when the requested resource (for example, a dataset or record) does not
 *          exist.</p>
 * @public
 */
export declare class ResourceNotFoundException extends __BaseException {
    readonly name: "ResourceNotFoundException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>);
}
/**
 * <p>An exception thrown when a dependent service such as Facebook or Twitter is not
 *          responding</p>
 * @public
 */
export declare class ExternalServiceException extends __BaseException {
    readonly name: "ExternalServiceException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ExternalServiceException, __BaseException>);
}
/**
 * <p>If you provided authentication information in the request, the identity pool has no
 *          authenticated role configured, or STS returned an error response to the
 *          request to assume the authenticated role from the identity pool. If you provided no
 *          authentication information in the request, the identity pool has no unauthenticated role
 *          configured, or STS returned an error response to the request to assume the
 *          unauthenticated role from the identity pool.</p>
 *          <p>Your role trust policy must grant <code>AssumeRoleWithWebIdentity</code> permissions to <code>cognito-identity.amazonaws.com</code>.</p>
 * @public
 */
export declare class InvalidIdentityPoolConfigurationException extends __BaseException {
    readonly name: "InvalidIdentityPoolConfigurationException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidIdentityPoolConfigurationException, __BaseException>);
}
/**
 * <p>The provided developer user identifier is already registered with Cognito under a
 *          different identity ID.</p>
 * @public
 */
export declare class DeveloperUserAlreadyRegisteredException extends __BaseException {
    readonly name: "DeveloperUserAlreadyRegisteredException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<DeveloperUserAlreadyRegisteredException, __BaseException>);
}
/**
 * <p>Thrown if there are parallel requests to modify a resource.</p>
 * @public
 */
export declare class ConcurrentModificationException extends __BaseException {
    readonly name: "ConcurrentModificationException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ConcurrentModificationException, __BaseException>);
}
