import type { TokenCredential } from "@azure/core-auth";
import type { DefaultAzureCredentialClientIdOptions, DefaultAzureCredentialOptions, DefaultAzureCredentialResourceIdOptions } from "./defaultAzureCredentialOptions.js";
/**
 * Creates a {@link BrokerCredential} instance with the provided options.
 * This credential uses the Windows Authentication Manager (WAM) broker for authentication.
 * It will only attempt to authenticate silently using the default broker account
 *
 * @param options - Options for configuring the credential.
 *
 * @internal
 */
export declare function createDefaultBrokerCredential(options?: DefaultAzureCredentialOptions): TokenCredential;
/**
 * Creates a {@link VisualStudioCodeCredential} from the provided options.
 * @param options - Options to configure the credential.
 *
 * @internal
 */
export declare function createDefaultVisualStudioCodeCredential(options?: DefaultAzureCredentialOptions): TokenCredential;
/**
 * Creates a {@link ManagedIdentityCredential} from the provided options.
 * @param options - Options to configure the credential.
 *
 * @internal
 */
export declare function createDefaultManagedIdentityCredential(options?: (DefaultAzureCredentialOptions | DefaultAzureCredentialResourceIdOptions | DefaultAzureCredentialClientIdOptions) & {
    sendProbeRequest?: boolean;
}): TokenCredential;
/**
 * Creates a {@link WorkloadIdentityCredential} from the provided options.
 * @param options - Options to configure the credential.
 *
 * @internal
 */
export declare function createDefaultWorkloadIdentityCredential(options?: DefaultAzureCredentialOptions | DefaultAzureCredentialClientIdOptions): TokenCredential;
/**
 * Creates a {@link AzureDeveloperCliCredential} from the provided options.
 * @param options - Options to configure the credential.
 *
 * @internal
 */
export declare function createDefaultAzureDeveloperCliCredential(options?: DefaultAzureCredentialOptions): TokenCredential;
/**
 * Creates a {@link AzureCliCredential} from the provided options.
 * @param options - Options to configure the credential.
 *
 * @internal
 */
export declare function createDefaultAzureCliCredential(options?: DefaultAzureCredentialOptions): TokenCredential;
/**
 * Creates a {@link AzurePowerShellCredential} from the provided options.
 * @param options - Options to configure the credential.
 *
 * @internal
 */
export declare function createDefaultAzurePowershellCredential(options?: DefaultAzureCredentialOptions): TokenCredential;
/**
 * Creates an {@link EnvironmentCredential} from the provided options.
 * @param options - Options to configure the credential.
 *
 * @internal
 */
export declare function createDefaultEnvironmentCredential(options?: DefaultAzureCredentialOptions): TokenCredential;
//# sourceMappingURL=defaultAzureCredentialFunctions.d.ts.map