/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { AuthFlowStateBase } from "../../AuthFlowState.js";
import { MFA_COMPLETED_STATE_TYPE } from "../../AuthFlowStateTypes.js";

/**
 * State indicating that the MFA flow has completed successfully.
 */
export class MfaCompletedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = MFA_COMPLETED_STATE_TYPE;
}
