"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const node_path_1 = __importDefault(require("node:path"));
const vitest_1 = require("vitest");
const index_1 = require("../index");
(0, vitest_1.describe)("getResolvedInput", () => {
    (0, vitest_1.it)("handles url", async () => {
        const pathOrUrlOrSchema = "https://foo.com";
        const resolvedInput = await (0, index_1.getResolvedInput)({ pathOrUrlOrSchema });
        (0, vitest_1.expect)(resolvedInput.type).toBe("url");
        (0, vitest_1.expect)(resolvedInput.schema).toBeUndefined();
        (0, vitest_1.expect)(resolvedInput.path).toBe("https://foo.com/");
    });
    (0, vitest_1.it)("handles file", async () => {
        const pathOrUrlOrSchema = "./path/to/openapi.json";
        const resolvedInput = await (0, index_1.getResolvedInput)({ pathOrUrlOrSchema });
        (0, vitest_1.expect)(resolvedInput.type).toBe("file");
        (0, vitest_1.expect)(resolvedInput.schema).toBeUndefined();
        (0, vitest_1.expect)(node_path_1.default.normalize(resolvedInput.path).toLowerCase()).toBe(node_path_1.default.normalize(node_path_1.default.resolve("./path/to/openapi.json")).toLowerCase());
    });
    (0, vitest_1.it)("handles raw spec", async () => {
        const pathOrUrlOrSchema = {
            info: {
                version: "1.0.0",
            },
            openapi: "3.1.0",
            paths: {},
        };
        const resolvedInput = await (0, index_1.getResolvedInput)({ pathOrUrlOrSchema });
        (0, vitest_1.expect)(resolvedInput.type).toBe("json");
        (0, vitest_1.expect)(resolvedInput.schema).toEqual({
            info: {
                version: "1.0.0",
            },
            openapi: "3.1.0",
            paths: {},
        });
        (0, vitest_1.expect)(resolvedInput.path).toBe("");
    });
});
