# How to contribute

We'd love to accept your patches and contributions to this project. There are a just a few small guidelines you need to follow.

## Submitting a patch

1. It's generally best to start by opening a new issue describing the bug or
   feature you're intending to fix. Even if you think it's relatively minor,
   it's helpful to know what people are working on. Mention in the initial
   issue that you are planning to work on that bug or feature so that it can
   be assigned to you.

2. Considering each syndication client seem to have their own specificities, make
   sure you provide enough information about the client in question if you want
   to add new elements or update existing ones. Link to their official documentation
   and provide examples.

3. Create and run tests. Your new addition must be covered by unit tests.

4. Follow the normal process of [forking][] the project, and setup a new
   branch to work in.

5. Do your best to have [well-formed commit messages][] for each change.
   This provides consistency throughout the project, and ensures that commit
   messages are able to be formatted properly by various git tools.

6. Finally, push the commits to your fork and submit a [pull request][].

[forking]: https://help.github.com/articles/fork-a-repo
[well-formed commit messages]: http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html
[squash]: http://git-scm.com/book/en/Git-Tools-Rewriting-History#Squashing-Commits
[pull request]: https://help.github.com/articles/creating-a-pull-request
