import { CallResult, SuccessCallResult, KnownResponseTypes, TypedMeasurementRequest, TypedMeasurementResponse, TypedMeasurementResponses, FinishedMeasurementResponse, NoResponseTypes } from '../types.js';
import { CreateMeasurementResponses, CreateMeasurementErrors, GetLimitsResponses, GetMeasurementErrors, ListProbesResponses, MeasurementResponse, MeasurementType } from '../openapi-ts/index.js';
type GlobalpingOptions<ThrowOnKnownErrors> = {
    auth?: string;
    userAgent?: string;
    throwApiErrors?: ThrowOnKnownErrors;
    timeout?: number;
};
export declare class Globalping<ThrowApiErrors extends boolean> {
    private readonly auth;
    private readonly client;
    private readonly userAgent;
    private readonly throwApiErrors;
    private readonly timeout;
    constructor({ auth, userAgent, throwApiErrors, timeout }?: GlobalpingOptions<ThrowApiErrors>);
    /**
     * @see {@link sdk.createMeasurement} for the API docs
     */
    createMeasurement(measurement: TypedMeasurementRequest): Promise<(ThrowApiErrors extends true ? never : CallResult<CreateMeasurementResponses, CreateMeasurementErrors>) | SuccessCallResult<CreateMeasurementResponses>>;
    /**
     * @see {@link sdk.getMeasurement} for the API docs
     */
    getMeasurement(id: string): Promise<(ThrowApiErrors extends true ? never : CallResult<TypedMeasurementResponses<MeasurementType>, GetMeasurementErrors>) | SuccessCallResult<TypedMeasurementResponses<MeasurementType>>>;
    /**
     * @see {@link sdk.getMeasurement} for the API docs
     */
    awaitMeasurement(id: string): Promise<(ThrowApiErrors extends true ? never : CallResult<TypedMeasurementResponses<MeasurementType>, GetMeasurementErrors>) | {
        data: FinishedMeasurementResponse<MeasurementType>;
        ok: true;
        request: Request;
        response: Response;
    }>;
    /**
     * @see {@link sdk.listProbes} for the API docs
     */
    listProbes(): Promise<(ThrowApiErrors extends true ? never : CallResult<ListProbesResponses, NoResponseTypes>) | SuccessCallResult<ListProbesResponses>>;
    /**
     * @see {@link sdk.getLimits} for the API docs
     */
    getLimits(): Promise<(ThrowApiErrors extends true ? never : CallResult<GetLimitsResponses, NoResponseTypes>) | SuccessCallResult<GetLimitsResponses>>;
    private request;
    private transformResult;
    static assertHttpStatus<S extends number, R1 extends KnownResponseTypes, R2 extends KnownResponseTypes>(status: S, result: CallResult<R1, R2>): asserts result is CallResult<R1, R2, S, S>;
    static assertMeasurementFinished(measurement: MeasurementResponse): asserts measurement is FinishedMeasurementResponse<MeasurementType>;
    static assertMeasurementType<T extends MeasurementType>(type: T, measurement: MeasurementResponse): asserts measurement is TypedMeasurementResponse<T>;
    static isHttpStatus<S extends number, R1 extends KnownResponseTypes, R2 extends KnownResponseTypes>(status: S, result: CallResult<R1, R2>): result is CallResult<R1, R2, S, S>;
    static isMeasurementFinished(measurement: MeasurementResponse): measurement is FinishedMeasurementResponse<MeasurementType>;
    static isMeasurementType<T extends MeasurementType>(type: T, measurement: MeasurementResponse): measurement is TypedMeasurementResponse<T>;
}
export default Globalping;
