// This file is auto-generated by @hey-api/openapi-ts

/**
 * The transport protocol to use.
 */
export type PingProtocol = 'ICMP' | 'TCP';

/**
 * The transport protocol to use.
 */
export const PingProtocol = {
	ICMP: 'ICMP',
	TCP: 'TCP',
} as const;

/**
 * EXPERIMENTAL: The IP version to use. Only allowed if the target is a hostname.
 *
 */
export type IpVersion = 4 | 6;

/**
 * EXPERIMENTAL: The IP version to use. Only allowed if the target is a hostname.
 *
 */
export const IpVersion = {
	4: 4,
	6: 6,
} as const;

export type MeasurementPingOptions = {

	/**
     * The number of packets to send.
     */
	packets?: number;
	protocol?: PingProtocol;

	/**
     * The destination port for the packets. Applies only for the `TCP` protocol.
     *
     */
	port?: number;
	ipVersion?: IpVersion;
};

/**
 * The transport protocol to use.
 */
export type TracerouteProtocol = 'ICMP' | 'TCP' | 'UDP';

/**
 * The transport protocol to use.
 */
export const TracerouteProtocol = {
	ICMP: 'ICMP',
	TCP: 'TCP',
	UDP: 'UDP',
} as const;

export type MeasurementTracerouteOptions = {
	protocol?: TracerouteProtocol;

	/**
     * The destination port for the packets. Applies only for the `TCP` protocol.
     *
     */
	port?: number;
	ipVersion?: IpVersion;
};

/**
 * The type of DNS query.
 */
export type DnsQueryType = 'A' | 'AAAA' | 'ANY' | 'CNAME' | 'DNSKEY' | 'DS' | 'HTTPS' | 'MX' | 'NS' | 'NSEC' | 'PTR' | 'RRSIG' | 'SOA' | 'TXT' | 'SRV' | 'SVCB';

/**
 * The type of DNS query.
 */
export const DnsQueryType = {
	A: 'A',
	AAAA: 'AAAA',
	ANY: 'ANY',
	CNAME: 'CNAME',
	DNSKEY: 'DNSKEY',
	DS: 'DS',
	HTTPS: 'HTTPS',
	MX: 'MX',
	NS: 'NS',
	NSEC: 'NSEC',
	PTR: 'PTR',
	RRSIG: 'RRSIG',
	SOA: 'SOA',
	TXT: 'TXT',
	SRV: 'SRV',
	SVCB: 'SVCB',
} as const;

/**
 * The IPv4 address of the resolver.
 */
export type MeasurementResolver = string;

/**
 * The protocol to use for the DNS query.
 */
export type DnsProtocol = 'TCP' | 'UDP';

/**
 * The protocol to use for the DNS query.
 */
export const DnsProtocol = {
	TCP: 'TCP',
	UDP: 'UDP',
} as const;

export type MeasurementDnsOptions = {

	/**
     * The DNS query properties.
     */
	query?: {
		type?: DnsQueryType;
	};
	resolver?: MeasurementResolver;
	protocol?: DnsProtocol;

	/**
     * The port number to send the query to.
     */
	port?: number;
	ipVersion?: IpVersion;

	/**
     * Toggles tracing of the delegation path from the root servers down to the target domain name.
     *
     */
	trace?: boolean;
};

/**
 * The transport protocol to use.
 */
export type MtrProtocol = 'ICMP' | 'TCP' | 'UDP';

/**
 * The transport protocol to use.
 */
export const MtrProtocol = {
	ICMP: 'ICMP',
	TCP: 'TCP',
	UDP: 'UDP',
} as const;

export type MeasurementMtrOptions = {
	protocol?: MtrProtocol;

	/**
     * The destination port for the packets. Applies only for the `TCP` and `UDP` protocols.
     *
     */
	port?: number;
	ipVersion?: IpVersion;

	/**
     * The number of packets to send to each hop.
     */
	packets?: number;
};

/**
 * The HTTP method to use.
 */
export type HttpRequestMethod = 'HEAD' | 'GET' | 'OPTIONS';

/**
 * The HTTP method to use.
 */
export const HttpRequestMethod = {
	HEAD: 'HEAD',
	GET: 'GET',
	OPTIONS: 'OPTIONS',
} as const;

export type HttpProtocol = 'HTTP' | 'HTTPS' | 'HTTP2';

export const HttpProtocol = {
	HTTP: 'HTTP',
	HTTPS: 'HTTPS',
	HTTP2: 'HTTP2',
} as const;

export type MeasurementHttpOptions = {

	/**
     * The HTTP request properties.
     */
	request?: {

		/**
         * An optional override for the `Host` header. The default value is based on the `target`.
         *
         */
		host?: string;

		/**
         * The path portion of the URL.
         */
		path?: string;

		/**
         * The query string portion of the URL.
         */
		query?: string;
		method?: HttpRequestMethod;

		/**
         * Additional request headers. Note that the `Host` and `User-Agent` are reserved and internally overridden.
         *
         */
		headers?: {
			[key: string]: string;
		};
	};
	resolver?: MeasurementResolver;

	/**
     * The port number to use.
     */
	port?: number;
	protocol?: HttpProtocol;
	ipVersion?: IpVersion;
};

export type MeasurementOptionsConditions = unknown;

/**
 * The measurement type.
 */
export type MeasurementType = 'ping' | 'traceroute' | 'dns' | 'mtr' | 'http';

/**
 * The measurement type.
 */
export const MeasurementType = {
	PING: 'ping',
	TRACEROUTE: 'traceroute',
	DNS: 'dns',
	MTR: 'mtr',
	HTTP: 'http',
} as const;

/**
 * A publicly reachable measurement target.
 * Typically a hostname, an IPv4 address, or IPv6 address, depending on the measurement `type`.
 * Support for IPv6 targets is currently considered experimental.
 *
 */
export type MeasurementTarget = string;

/**
 * A two-letter continent code.
 */
export type ContinentCode = 'AF' | 'AN' | 'AS' | 'EU' | 'NA' | 'OC' | 'SA';

/**
 * A two-letter continent code.
 */
export const ContinentCode = {
	AF: 'AF',
	AN: 'AN',
	AS: 'AS',
	EU: 'EU',
	NA: 'NA',
	OC: 'OC',
	SA: 'SA',
} as const;

/**
 * A geographic region name based on UN [Standard Country or Area Codes for Statistical Use (M49)](https://unstats.un.org/unsd/methodology/m49/).
 *
 */
export type RegionName = 'Northern Africa' | 'Eastern Africa' | 'Middle Africa' | 'Southern Africa' | 'Western Africa' | 'Caribbean' | 'Central America' | 'South America' | 'Northern America' | 'Central Asia' | 'Eastern Asia' | 'South-eastern Asia' | 'Southern Asia' | 'Western Asia' | 'Eastern Europe' | 'Northern Europe' | 'Southern Europe' | 'Western Europe' | 'Australia and New Zealand' | 'Melanesia' | 'Micronesia' | 'Polynesia';

/**
 * A geographic region name based on UN [Standard Country or Area Codes for Statistical Use (M49)](https://unstats.un.org/unsd/methodology/m49/).
 *
 */
export const RegionName = {
	NORTHERN_AFRICA: 'Northern Africa',
	EASTERN_AFRICA: 'Eastern Africa',
	MIDDLE_AFRICA: 'Middle Africa',
	SOUTHERN_AFRICA: 'Southern Africa',
	WESTERN_AFRICA: 'Western Africa',
	CARIBBEAN: 'Caribbean',
	CENTRAL_AMERICA: 'Central America',
	SOUTH_AMERICA: 'South America',
	NORTHERN_AMERICA: 'Northern America',
	CENTRAL_ASIA: 'Central Asia',
	EASTERN_ASIA: 'Eastern Asia',
	SOUTH_EASTERN_ASIA: 'South-eastern Asia',
	SOUTHERN_ASIA: 'Southern Asia',
	WESTERN_ASIA: 'Western Asia',
	EASTERN_EUROPE: 'Eastern Europe',
	NORTHERN_EUROPE: 'Northern Europe',
	SOUTHERN_EUROPE: 'Southern Europe',
	WESTERN_EUROPE: 'Western Europe',
	AUSTRALIA_AND_NEW_ZEALAND: 'Australia and New Zealand',
	MELANESIA: 'Melanesia',
	MICRONESIA: 'Micronesia',
	POLYNESIA: 'Polynesia',
} as const;

/**
 * A two-letter country code based on [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements).
 */
export type CountryCode = string;

/**
 * A two-letter [US state code](https://www.faa.gov/air_traffic/publications/atpubs/cnt_html/appendix_a.html).
 */
export type StateCode = string | null;

/**
 * A city name in English.
 */
export type CityName = string;

/**
 * An autonomous system number (ASN).
 */
export type AsnCode = number;

/**
 * A network name, such as "Google LLC" or "DigitalOcean, LLC".
 */
export type NetworkName = string;

/**
 * An array of additional values to fine-tune probe selection:
 * - Probes hosted in [AWS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions) and [Google Cloud](https://cloud.google.com/compute/docs/regions-zones#available) are automatically assigned the service region code. For example: `aws-eu-west-1` and `gcp-us-south1`.
 * - Probes are automatically assigned `datacenter-network` and `eyeball-network` tags to distinguish between datacenter and end-user locations.
 *
 */
export type Tags = Array<string>;

export type MeasurementLocationOption = {
	continent?: ContinentCode;
	region?: RegionName;
	country?: CountryCode;
	state?: StateCode;
	city?: CityName;
	asn?: AsnCode;
	network?: NetworkName;
	tags?: Tags;

	/**
     * Locations defined in a single string instead of the respective location properties.
     * The API performs fuzzy matching on the `country`, `city`, `state`, `continent`, `region`, `asn` (using `AS` prefix, e.g., `AS123`), `tags`, and `network` values.
     * Supports full names, ISO codes (where applicable), and common aliases.
     * Multiple conditions can be combined using the `+` character, which behaves like a logical `AND`.
     *
     */
	magic?: string;

	/**
     * The maximum number of probes that should run the measurement in this location.
     * The result count might be lower if there aren't enough probes available in this location.
     * Mutually exclusive with the global `limit` property.
     *
     */
	limit?: number;
};

export type MeasurementLocations = Array<MeasurementLocationOption> | string;

/**
 * The maximum number of probes that should run the measurement.
 * The result count might be lower if there aren't enough probes available in the specified locations.
 * Mutually exclusive with the `limit` property that can be set for individual locations.
 *
 */
export type MeasurementLimit = number;

/**
 * Additional optional fields depending on the measurement `type`.
 */
export type MeasurementOptions = MeasurementPingOptions | MeasurementTracerouteOptions | MeasurementDnsOptions | MeasurementMtrOptions | MeasurementHttpOptions;

export type MeasurementRequest = MeasurementOptionsConditions & {
	type: MeasurementType;
	target: MeasurementTarget;

	/**
     * Indicates whether you want to get partial results while the measurement is still running:
     * - If `true`, partial results are returned as soon as they are available, and you can present them to the user in real time. Note that only the first 5 tests from the `results` array will update in real time.
     * - If `false`, the result of each test is updated only after the test finishes.
     *
     */
	inProgressUpdates?: boolean;
	locations?: MeasurementLocations;
	limit?: MeasurementLimit;
	measurementOptions?: MeasurementOptions;
};

/**
 * The actual number of probes that performed the measurement tests.
 * Smaller or equal to `limit`, depending on probe availability.
 *
 */
export type MeasurementProbesCount = number;

/**
 * Contains information about the newly created measurement.
 */
export type CreateMeasurementResponse = {

	/**
     * The measurement ID.
     * > **Tip**: You can use the ID to create a new measurement request, reusing the same probes.
     *
     */
	id: string;
	probesCount: MeasurementProbesCount;
};

/**
 * The current test status. Any value other than `in-progress` is final.
 */
export type BaseTestStatus = string;

export type FinishedTestStatus = BaseTestStatus & 'finished';

/**
 * The raw output of the test. Can be presented to users but is not meant to be parsed by clients.
 * Please use the individual values provided in other fields for automated processing.
 *
 */
export type TestRawOutput = string;

export type BaseFinishedTestResult = {
	status: FinishedTestStatus;
	rawOutput: TestRawOutput;
};

/**
 * The resolved IP address of the `target`.
 */
export type ResolvedAddress = string | null;

/**
 * The resolved hostname of the `target`.
 */
export type ResolvedHostname = string | null;

export type NullableNumber = number | null;

export type StatsRttMinNullable = NullableNumber & unknown;

export type StatsRttAvgNullable = NullableNumber & unknown;

export type StatsRttMaxNullable = NullableNumber & unknown;

/**
 * The number of packets sent.
 */
export type StatsPacketsTotal = number;

/**
 * The number of received packets.
 */
export type StatsPacketsRcv = number;

/**
 * The number of dropped packets (`total` - `rcv`).
 */
export type StatsPacketsDrop = number;

/**
 * The percentage of dropped packets.
 */
export type StatsPacketsLoss = number;

/**
 * The round-trip time for this packet.
 */
export type TimingPacketRtt = number;

/**
 * The time-to-live value of this packet.
 */
export type TimingPacketTtl = number;

export type IcmpPingTiming = {
	rtt: TimingPacketRtt;
	ttl: TimingPacketTtl;
};

export type TcpPingTiming = {
	rtt: TimingPacketRtt;
};

/**
 * Represents a `finished` ping test.
 */
export type FinishedPingTestResult = BaseFinishedTestResult & {
	resolvedAddress: ResolvedAddress;
	resolvedHostname: ResolvedHostname;

	/**
     * Summary `rtt` and packet loss statistics.
     * All times are in milliseconds.
     *
     */
	stats: {
		min: StatsRttMinNullable;
		avg: StatsRttAvgNullable;
		max: StatsRttMaxNullable;
		total: StatsPacketsTotal;
		rcv: StatsPacketsRcv;
		drop: StatsPacketsDrop;
		loss: StatsPacketsLoss;
	};

	/**
     * An array containing details for each packet.
     * All times are in milliseconds.
     *
     */
	timings: Array<IcmpPingTiming | TcpPingTiming>;
};

/**
 * Represents a `finished` traceroute test.
 */
export type FinishedTracerouteTestResult = BaseFinishedTestResult & {
	resolvedAddress: ResolvedAddress;
	resolvedHostname: ResolvedHostname;

	/**
     * An array containing details about each hop.
     */
	hops: Array<{
		resolvedAddress: ResolvedAddress;
		resolvedHostname: ResolvedHostname;

		/**
         * An array containing details for each packet.
         * All times are in milliseconds.
         *
         */
		timings: Array<{
			rtt: TimingPacketRtt;
		}>;
	}>;
};

/**
 * The DNS [response code](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#table-dns-parameters-6).
 */
export type DnsStatusCode = number;

/**
 * The DNS [response code name](https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#table-dns-parameters-6).
 */
export type DnsStatusCodeName = string;

export type DnsTestAnswer = {

	/**
     * The record domain name.
     */
	name: string;

	/**
     * The record type.
     */
	type: string;

	/**
     * The record time-to-live value in seconds.
     */
	ttl: number;

	/**
     * The record class.
     */
	class: string;

	/**
     * The record value.
     */
	value: string;
};

export type DnsTestHopResult = {

	/**
     * The hostname or IP of the resolver that answered the query.
     */
	resolver: string;

	/**
     * An array of the received resource records.
     */
	answers: Array<DnsTestAnswer>;

	/**
     * Details about the query times.
     * All times are in milliseconds.
     *
     */
	timings: {

		/**
         * The total query time.
         */
		total: number;
	};
};

/**
 * Represents a `finished` DNS test with `trace` disabled.
 */
export type FinishedSimpleDnsTestResult = BaseFinishedTestResult & {
	statusCode: DnsStatusCode;
	statusCodeName: DnsStatusCodeName;
} & DnsTestHopResult;

/**
 * Represents a `finished` DNS test with `trace` enabled.
 */
export type FinishedTraceDnsTestResult = BaseFinishedTestResult & {

	/**
     * An array containing details about each hop.
     */
	hops: Array<DnsTestHopResult>;
};

export type FinishedDnsTestResult = FinishedSimpleDnsTestResult | FinishedTraceDnsTestResult;

/**
 * The lowest `rtt` value.
 */
export type StatsRttMin = number;

/**
 * The average `rtt` value.
 */
export type StatsRttAvg = number;

/**
 * The highest `rtt` value.
 */
export type StatsRttMax = number;

/**
 * The standard deviation of the `rtt` values.
 */
export type StatsStDev = number;

/**
 * The lowest jitter value.
 */
export type StatsJitterMin = number;

/**
 * The average jitter value.
 */
export type StatsJitterAvg = number;

/**
 * The highest jitter value.
 */
export type StatsJitterMax = number;

/**
 * Represents a `finished` MTR test.
 */
export type FinishedMtrTestResult = BaseFinishedTestResult & {
	resolvedAddress: ResolvedAddress;
	resolvedHostname: ResolvedHostname;

	/**
     * An array containing details about each hop.
     */
	hops: Array<{
		resolvedAddress: ResolvedAddress & unknown;
		resolvedHostname: ResolvedHostname & unknown;

		/**
         * An array containing the ASNs assigned to this hop.
         */
		asn: Array<number>;

		/**
         * Summary `rtt` and packet loss statistics.
         * All times are in milliseconds.
         *
         */
		stats: {
			min: StatsRttMin;
			avg: StatsRttAvg;
			max: StatsRttMax;
			stDev: StatsStDev;
			jMin: StatsJitterMin;
			jAvg: StatsJitterAvg;
			jMax: StatsJitterMax;
			total: StatsPacketsTotal;
			rcv: StatsPacketsRcv;
			drop: StatsPacketsDrop;
			loss: StatsPacketsLoss;
		};

		/**
         * An array containing details for each packet.
         * All times are in milliseconds.
         *
         */
		timings: Array<{
			rtt: TimingPacketRtt;
		}>;
	}>;
};

/**
 * The HTTP response status code.
 */
export type HttpStatusCode = number;

/**
 * The HTTP response status code name.
 */
export type HttpStatusCodeName = string;

export type NullableInteger = number | null;

export type TimingHttpTotalNullable = NullableInteger & unknown;

export type TimingHttpDnsNullable = NullableInteger & unknown;

export type TimingHttpTcpNullable = NullableInteger & unknown;

export type TimingHttpTlsNullable = NullableInteger & unknown;

export type TimingHttpFirstByteNullable = NullableInteger & unknown;

export type TimingHttpDownloadNullable = NullableInteger & unknown;

/**
 * Information about the certificate subject.
 */
export type TlsCertificateSubject = {

	/**
     * The subject's common name.
     */
	CN?: string;

	/**
     * The subject's alternative names.
     */
	alt?: string;
};

/**
 * Information about the certificate issuer.
 */
export type TlsCertificateIssuer = {

	/**
     * The issuer's country.
     */
	C?: string;

	/**
     * The issuer's organization.
     */
	O?: string;

	/**
     * The issuer's common name.
     */
	CN?: string;
};

/**
 * The type of the used key, or `null` for unrecognized types.
 */
export type TlsKeyType = 'RSA' | 'EC' | 'null';

/**
 * The type of the used key, or `null` for unrecognized types.
 */
export const TlsKeyType = {
	RSA: 'RSA',
	EC: 'EC',
	NULL: 'null',
} as const;

export type TlsCertificate = {

	/**
     * The negotiated SSL/TLS protocol version.
     *
     */
	protocol: string;

	/**
     * The OpenSSL name of the cipher suite.
     *
     */
	cipherName: string;

	/**
     * Indicates whether a trusted authority signed the certificate.
     *
     */
	authorized: boolean;

	/**
     * The reason for rejecting the certificate if `authorized` is `false`.
     *
     */
	error?: string;

	/**
     * The creation date and time of the certificate.
     */
	createdAt: string;

	/**
     * The expiration date and time of the certificate.
     */
	expiresAt: string;
	subject: TlsCertificateSubject;
	issuer: TlsCertificateIssuer;
	keyType: TlsKeyType;

	/**
     * The size of the used key, or `null` for unrecognized types.
     */
	keyBits: number | null;

	/**
     * The certificate serial number as a : separated HEX string.
     *
     */
	serialNumber: string;

	/**
     * The SHA-256 digest of the DER-encoded certificate as a : separated HEX string.
     *
     */
	fingerprint256: string;

	/**
     * The public key as a : separated HEX string, or `null` for unrecognized types.
     *
     */
	publicKey: string | null;
};

/**
 * Represents a `finished` HTTP test.
 */
export type FinishedHttpTestResult = BaseFinishedTestResult & {

	/**
     * The raw HTTP response headers.
     */
	rawHeaders: string;

	/**
     * The raw HTTP response body or `null` if there was no body in response.
     * Note that only the first 10 kb are returned.
     *
     */
	rawBody: string | null;

	/**
     * Indicates whether the `rawBody` value was truncated due to being too big.
     *
     */
	truncated: boolean;

	/**
     * The HTTP response headers. The value may be an array of strings for headers with multiple values, e.g., `Set-Cookie`.
     */
	headers: {
		[key: string]: string | Array<string>;
	};
	statusCode: HttpStatusCode;
	statusCodeName: HttpStatusCodeName;
	resolvedAddress: ResolvedAddress;

	/**
     * Details about the HTTP request times.
     * All times are in milliseconds.
     *
     */
	timings: {
		total: TimingHttpTotalNullable;
		dns: TimingHttpDnsNullable;
		tcp: TimingHttpTcpNullable;
		tls: TimingHttpTlsNullable;
		firstByte: TimingHttpFirstByteNullable;
		download: TimingHttpDownloadNullable;
	};

	/**
     * Information about the TLS certificate or `null` if no TLS certificate is available.
     */
	tls: TlsCertificate | null;
};

export type MeasurementResultsConditions = unknown;

/**
 * The current measurement status. Any value other than `in-progress` is final.
 */
export type MeasurementStatus = 'in-progress' | 'finished';

/**
 * The current measurement status. Any value other than `in-progress` is final.
 */
export const MeasurementStatus = {
	IN_PROGRESS: 'in-progress',
	FINISHED: 'finished',
} as const;

/**
 * The latitude of probe location.
 */
export type Latitude = number;

/**
 * The longitude of probe location.
 */
export type Longitude = number;

/**
 * The probe location information.
 */
export type ProbeLocation = {
	continent: ContinentCode;
	region: RegionName;
	country: CountryCode;
	state: StateCode;
	city: CityName;
	asn: AsnCode;
	network: NetworkName;
	latitude: Latitude;
	longitude: Longitude;
};

export type ProbeResolver = string | 'private';

/**
 * An array of the default resolvers configured on the probe.
 */
export type ProbeResolvers = Array<ProbeResolver>;

export type InProgressTestStatus = BaseTestStatus & 'in-progress';

/**
 * Represents an `in-progress` test where most fields are not yet available.
 *
 */
export type InProgressTestResult = {
	status: InProgressTestStatus;
	rawOutput: TestRawOutput;
};

export type FailedTestStatus = BaseTestStatus & 'failed';

/**
 * Represents a `failed` test where most fields are not available.
 *
 */
export type FailedTestResult = {
	status: FailedTestStatus;
	rawOutput: TestRawOutput;
};

export type OfflineTestStatus = BaseTestStatus & 'offline';

/**
 * Represents an `offline` test where the requested probe was not available to run the test and most fields are not available.
 * Only possible when you pass the `id` of a previous measurement in the `locations` field.
 *
 */
export type OfflineTestResult = {
	status: OfflineTestStatus;
	rawOutput: TestRawOutput;
};

export type TestResult = InProgressTestResult | FailedTestResult | OfflineTestResult | FinishedPingTestResult | FinishedTracerouteTestResult | FinishedDnsTestResult | FinishedMtrTestResult | FinishedHttpTestResult;

export type MeasurementResultItem = {
	probe: ProbeLocation & {
		tags: Tags;
		resolvers: ProbeResolvers;
	};
	result: TestResult;
};

export type MeasurementResponse = {

	/**
     * The measurement ID.
     */
	id: string;
	type: MeasurementType;
	target: MeasurementTarget;
	status: MeasurementStatus;

	/**
     * The date and time when the measurement was created.
     */
	createdAt: string;

	/**
     * The date and time when the measurement was last updated.
     */
	updatedAt: string;
	probesCount: MeasurementProbesCount;

	/**
     * The locations you specified when creating the measurement.
     * If you passed in an `id` of a previous measurement, the value will be filled in from that measurement.
     *
     */
	locations?: Array<MeasurementLocationOption>;
	limit?: MeasurementLimit & unknown;
	measurementOptions?: MeasurementOptions & unknown;

	/**
     * An array containing the measurement results.
     */
	results: Array<MeasurementResultItem>;
};

export type Probe = {

	/**
     * The probe version.
     */
	version: string;
	location: ProbeLocation;
	tags: Tags;
	resolvers: ProbeResolvers;
};

export type Probes = Array<Probe>;

/**
 * Type of the rate limit.
 */
export type RateLimitType = 'ip' | 'user';

/**
 * Type of the rate limit.
 */
export const RateLimitType = {
	IP: 'ip',
	USER: 'user',
} as const;

export type RateLimitDetails = {
	type: RateLimitType;

	/**
     * The number of rate limit points available in a given time window.
     */
	limit: number;

	/**
     * The number of rate limit points remaining in the current time window.
     */
	remaining: number;

	/**
     * The number of seconds until the limit resets.
     */
	reset: number;
};

export type Limits = {

	/**
     * Object containing rate limits information.
     */
	rateLimit: {

		/**
         * Measurements rate limits.
         */
		measurements: {
			create: RateLimitDetails & unknown;
		};
	};

	/**
     * Object containing credits information (only for authenticated requests).
     */
	credits?: {

		/**
         * The number of user's remaining credits.
         */
		remaining?: number;
	};
};

/**
 * The ID of the measurement you want to retrieve.
 */
export type MeasurementId = string;

export type CreateMeasurementData = {

	/**
     * Use the request body to set the measurement parameters.
     */
	body?: MeasurementRequest;
	path?: never;
	query?: never;
	url: '/v1/measurements';
};

export type CreateMeasurementErrors = {

	/**
     * If the API couldn't process the request due to malformed parameters or other client errors, it returns status `400 Bad Request`
     * and a body with more information about the error. Please modify your request before trying again.
     *
     */
	400: {

		/**
         * Information about the error.
         */
		error: {

			/**
             * The type of the error.
             */
			type: string;

			/**
             * A human-readable description of the error.
             */
			message: string;

			/**
             * Additional information that might be present if the error is related to a specific parameter or payload field.
             */
			params?: {
				[key: string]: string;
			};
		};
	};

	/**
     * If the API couldn't find suitable probes for your request, it returns status `422 Unprocessable Content` and a body with more
     * information about the error. Please modify your request before trying again.
     *
     */
	422: {
		error: {
			type: string;
			message: string;
		};
	};

	/**
     * If you've exceeded the API rate limit, you'll receive status `429 Too Many Requests` and a body containing more information about the error.
     *
     */
	429: {
		error: {
			type: string;
			message: string;
		};
	};
};

export type CreateMeasurementError = CreateMeasurementErrors[keyof CreateMeasurementErrors];

export type CreateMeasurementResponses = {

	/**
     * If the API accepted the request for processing, it returns status `202 Accepted` and a body containing the ID of the newly created measurement.
     * You can use the URL from the `Location` header to retrieve the measurement status.
     *
     */
	202: CreateMeasurementResponse;
};

export type CreateMeasurementResponse2 = CreateMeasurementResponses[keyof CreateMeasurementResponses];

export type GetMeasurementData = {
	body?: never;
	path: {

		/**
         * The ID of the measurement you want to retrieve.
         */
		id: string;
	};
	query?: never;
	url: '/v1/measurements/{id}';
};

export type GetMeasurementErrors = {

	/**
     * If the API couldn't find the requested resource, it returns status `404 Not Found`
     * and a body containing more information about the error.
     *
     */
	404: {
		error: {
			type: string;
			message: string;
		};
	};

	/**
     * If you've exceeded the API rate limit, you'll receive status `429 Too Many Requests` and a body containing more information about the error.
     *
     */
	429: {
		error: {
			type: string;
			message: string;
		};
	};
};

export type GetMeasurementError = GetMeasurementErrors[keyof GetMeasurementErrors];

export type GetMeasurementResponses = {

	/**
     * A successful request returns status `200 OK` and a body containing the requested measurement results.
     *
     */
	200: MeasurementOptionsConditions & MeasurementResponse;
};

export type GetMeasurementResponse = GetMeasurementResponses[keyof GetMeasurementResponses];

export type ListProbesData = {
	body?: never;
	path?: never;
	query?: never;
	url: '/v1/probes';
};

export type ListProbesResponses = {

	/**
     * A successful request returns status `200 OK` and a body containing a list of all probes currently online and their metadata.
     *
     */
	200: Probes;
};

export type ListProbesResponse = ListProbesResponses[keyof ListProbesResponses];

export type GetLimitsData = {
	body?: never;
	path?: never;
	query?: never;
	url: '/v1/limits';
};

export type GetLimitsResponses = {

	/**
     * A successful request returns status `200 OK` and a body containing information about the current rate limits and user credits.
     *
     */
	200: Limits;
};

export type GetLimitsResponse = GetLimitsResponses[keyof GetLimitsResponses];

export type ClientOptions = {
	baseUrl: 'https://api.globalping.io' | (string & {});
};
