import { Knex } from "knex";
import { Bean } from "./bean";
import { LooseObject } from "./helper/helper";
import dayjs from "dayjs";
import { BeanModel } from "./bean-model";
import BeanConverterStream from "./bean-converter-stream";
import AwaitLock from "await-lock";
import StaticConnectionConfig = Knex.StaticConnectionConfig;
import PoolConfig = Knex.PoolConfig;
import RawBinding = Knex.RawBinding;
import QueryBuilder = Knex.QueryBuilder;
export declare class RedBeanNode {
    devDebug: boolean;
    protected _debug: boolean;
    protected _freeze: boolean;
    protected _transaction: any;
    protected _knex: Knex;
    dbType: string;
    private _modelList;
    protected schemaLock: AwaitLock;
    get knex(): any;
    isTransaction(): boolean;
    setup(dbType?: string | Knex, connection?: StaticConnectionConfig, pool?: PoolConfig): void;
    dispense(type: string): Bean;
    protected createBean(type: string, isDispense?: boolean): Bean;
    freeze(v?: boolean): void;
    debug(v: boolean): void;
    concurrent(promiseList: Promise<any>[]): Promise<any[]>;
    storeAll(beans: Bean[], changedFieldsOnly?: boolean): Promise<any[]>;
    store(bean: Bean, changedFieldsOnly?: boolean): Promise<number>;
    protected storeCore(bean: Bean, changedFieldsOnly?: boolean): Promise<number>;
    protected updateTableSchema(bean: Bean, changedFieldsOnly?: boolean): Promise<void>;
    protected updateTableSchemaCore(bean: Bean): Promise<void>;
    getDataType(value: any, fieldName?: string): "integer" | "boolean" | "date" | "bigInteger" | "float" | "text" | "datetime" | "datetimemillis" | "time" | "timemillis" | "varchar";
    isValidType(columnType: any, valueType: any): boolean;
    close(): Promise<void>;
    load(type: string, id: number): Promise<Bean | null>;
    protected normalizeErrorMsg(error: any): any;
    protected checkError(error: any, allowedErrorList: (string | string[])[]): void;
    checkAllowedError(error: any): void;
    checkAllowedSchemaError(error: any): void;
    trash(bean: Bean): Promise<void>;
    trashAll(beans: Bean[]): Promise<void>;
    protected findCore(type: string, clause: string, data?: readonly RawBinding[]): QueryBuilder;
    find(type: string, clause?: string, data?: readonly RawBinding[]): Promise<Bean[]>;
    findStream(type: string, clause?: string, data?: readonly RawBinding[]): BeanConverterStream;
    protected findAllCore(type: string, clause: string, data?: readonly RawBinding[]): Knex.QueryBuilder<any, any>;
    findAll(type: string, clause?: string, data?: readonly RawBinding[]): Promise<Bean[]>;
    findAllStream(type: string, clause: string, data?: readonly RawBinding[]): BeanConverterStream;
    findOne(type: string, clause?: string, data?: readonly RawBinding[]): Promise<Bean | null>;
    convertToBean(type: string, obj: any): Bean;
    convertToBeans(type: string, objList: any): Bean[];
    exec(sql: string, data?: RawBinding[]): Promise<void>;
    getAll(sql: string, data?: readonly RawBinding[]): Promise<LooseObject<any>[]>;
    getAllStream(sql: string, data?: RawBinding[]): any;
    getRow(sql: string, data?: RawBinding[], autoLimit?: boolean): Promise<LooseObject<any> | null>;
    protected normalizeRawCore(sql: any, data: any): any;
    normalizeRaw(sql: any, data: any): Promise<LooseObject[]>;
    getCol(sql: string, data?: readonly RawBinding[]): Promise<any[]>;
    getCell(sql: string, data?: RawBinding[], autoLimit?: boolean): Promise<any>;
    getAssoc(sql: string, data?: RawBinding[]): Promise<{}>;
    count(type: string, clause?: string, data?: RawBinding[], autoLimit?: boolean): Promise<any>;
    inspect(type: any): any;
    begin(): Promise<RedBeanNode>;
    commit(): Promise<void>;
    rollback(): Promise<void>;
    transaction(callback: (trx: RedBeanNode) => void): Promise<void>;
    protected devLog(...params: any[]): void;
    protected debugLog(...params: any[]): void;
    queryLog(queryPromise: string | Promise<any>): void;
    duplicate(targetBean: Bean, deepCopy?: boolean): Bean;
    hasTable(tableName: string): any;
    isFrozen(): boolean;
    isDebug(): boolean;
    isoDateTime(dateTime?: dayjs.Dayjs | Date | undefined): string;
    isoDateTimeMillis(dateTime?: dayjs.Dayjs | Date | undefined): string;
    isoDate(date?: dayjs.Dayjs | Date | undefined): string;
    isoTime(date?: dayjs.Dayjs | Date | undefined): any;
    isoTimeMillis(date?: dayjs.Dayjs | Date | undefined): any;
    isDate(value: string): boolean;
    isDateTime(value: string): boolean;
    isDateTimeMillis(value: string): boolean;
    isTime(value: string): boolean;
    isTimeMillis(value: string): boolean;
    autoloadModels(dir: string, lang: undefined | "ts" | "js"): void;
    get modelList(): LooseObject<new (type: any, R: any) => BeanModel>;
}
export declare let R: RedBeanNode;
