"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _intn = _interopRequireDefault(require("./intn"));
var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DATA_LENGTH = Buffer.from([0x08]);
const NULL_LENGTH = Buffer.from([0x00]);
const MAX_SAFE_BIGINT = 9223372036854775807n;
const MIN_SAFE_BIGINT = -9223372036854775808n;
const BigInt = {
  id: 0x7F,
  type: 'INT8',
  name: 'BigInt',
  declaration: function () {
    return 'bigint';
  },
  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x08]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    return DATA_LENGTH;
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const buffer = new _writableTrackingBuffer.default(8);
    buffer.writeBigInt64LE(typeof parameter.value === 'bigint' ? parameter.value : globalThis.BigInt(parameter.value));
    yield buffer.data;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    if (typeof value !== 'bigint') {
      value = globalThis.BigInt(value);
    }
    if (value < MIN_SAFE_BIGINT || value > MAX_SAFE_BIGINT) {
      throw new TypeError(`Value must be between ${MIN_SAFE_BIGINT} and ${MAX_SAFE_BIGINT}, inclusive.`);
    }
    return value;
  }
};
var _default = exports.default = BigInt;
module.exports = BigInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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