"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _datetimen = _interopRequireDefault(require("./datetimen"));
var _core = require("@js-joda/core");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const EPOCH_DATE = _core.LocalDate.ofYearDay(1900, 1);
const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x08]);
const DateTime = {
  id: 0x3D,
  type: 'DATETIME',
  name: 'DateTime',
  declaration: function () {
    return 'datetime';
  },
  generateTypeInfo() {
    return Buffer.from([_datetimen.default.id, 0x08]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    return DATA_LENGTH;
  },
  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const value = parameter.value; // Temporary solution. Remove 'any' later.

    let date;
    if (options.useUTC) {
      date = _core.LocalDate.of(value.getUTCFullYear(), value.getUTCMonth() + 1, value.getUTCDate());
    } else {
      date = _core.LocalDate.of(value.getFullYear(), value.getMonth() + 1, value.getDate());
    }
    let days = EPOCH_DATE.until(date, _core.ChronoUnit.DAYS);
    let milliseconds, threeHundredthsOfSecond;
    if (options.useUTC) {
      let seconds = value.getUTCHours() * 60 * 60;
      seconds += value.getUTCMinutes() * 60;
      seconds += value.getUTCSeconds();
      milliseconds = seconds * 1000 + value.getUTCMilliseconds();
    } else {
      let seconds = value.getHours() * 60 * 60;
      seconds += value.getMinutes() * 60;
      seconds += value.getSeconds();
      milliseconds = seconds * 1000 + value.getMilliseconds();
    }
    threeHundredthsOfSecond = milliseconds / (3 + 1 / 3);
    threeHundredthsOfSecond = Math.round(threeHundredthsOfSecond);

    // 25920000 equals one day
    if (threeHundredthsOfSecond === 25920000) {
      days += 1;
      threeHundredthsOfSecond = 0;
    }
    const buffer = Buffer.alloc(8);
    buffer.writeInt32LE(days, 0);
    buffer.writeUInt32LE(threeHundredthsOfSecond, 4);
    yield buffer;
  },
  // TODO: type 'any' needs to be revisited.
  validate: function (value, collation, options) {
    if (value == null) {
      return null;
    }
    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }
    value = value;
    let year;
    if (options && options.useUTC) {
      year = value.getUTCFullYear();
    } else {
      year = value.getFullYear();
    }
    if (year < 1753 || year > 9999) {
      throw new TypeError('Out of range.');
    }
    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }
    return value;
  }
};
var _default = exports.default = DateTime;
module.exports = DateTime;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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