"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _numericn = _interopRequireDefault(require("./numericn"));
var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NULL_LENGTH = Buffer.from([0x00]);
const Numeric = {
  id: 0x3F,
  type: 'NUMERIC',
  name: 'Numeric',
  declaration: function (parameter) {
    return 'numeric(' + this.resolvePrecision(parameter) + ', ' + this.resolveScale(parameter) + ')';
  },
  resolvePrecision: function (parameter) {
    if (parameter.precision != null) {
      return parameter.precision;
    } else if (parameter.value === null) {
      return 1;
    } else {
      return 18;
    }
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else {
      return 0;
    }
  },
  generateTypeInfo(parameter) {
    let precision;
    if (parameter.precision <= 9) {
      precision = 0x05;
    } else if (parameter.precision <= 19) {
      precision = 0x09;
    } else if (parameter.precision <= 28) {
      precision = 0x0D;
    } else {
      precision = 0x11;
    }
    return Buffer.from([_numericn.default.id, precision, parameter.precision, parameter.scale]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    const precision = parameter.precision;
    if (precision <= 9) {
      return Buffer.from([0x05]);
    } else if (precision <= 19) {
      return Buffer.from([0x09]);
    } else if (precision <= 28) {
      return Buffer.from([0x0D]);
    } else {
      return Buffer.from([0x11]);
    }
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const sign = parameter.value < 0 ? 0 : 1;
    const value = Math.round(Math.abs(parameter.value * Math.pow(10, parameter.scale)));
    if (parameter.precision <= 9) {
      const buffer = Buffer.alloc(5);
      buffer.writeUInt8(sign, 0);
      buffer.writeUInt32LE(value, 1);
      yield buffer;
    } else if (parameter.precision <= 19) {
      const buffer = new _writableTrackingBuffer.default(10);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      yield buffer.data;
    } else if (parameter.precision <= 28) {
      const buffer = new _writableTrackingBuffer.default(14);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      buffer.writeUInt32LE(0x00000000);
      yield buffer.data;
    } else {
      const buffer = new _writableTrackingBuffer.default(18);
      buffer.writeUInt8(sign);
      buffer.writeUInt64LE(value);
      buffer.writeUInt32LE(0x00000000);
      buffer.writeUInt32LE(0x00000000);
      yield buffer.data;
    }
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    value = parseFloat(value);
    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }
    return value;
  }
};
var _default = exports.default = Numeric;
module.exports = Numeric;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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