"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _iconvLite = _interopRequireDefault(require("iconv-lite"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF]);
const Text = {
  id: 0x23,
  type: 'TEXT',
  name: 'Text',
  hasTableName: true,
  declaration: function () {
    return 'text';
  },
  resolveLength: function (parameter) {
    const value = parameter.value;
    if (value != null) {
      return value.length;
    } else {
      return -1;
    }
  },
  generateTypeInfo(parameter, _options) {
    const buffer = Buffer.alloc(10);
    buffer.writeUInt8(this.id, 0);
    buffer.writeInt32LE(parameter.length, 1);
    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 5, 0, 5);
    }
    return buffer;
  },
  generateParameterLength(parameter, options) {
    const value = parameter.value;
    if (value == null) {
      return NULL_LENGTH;
    }
    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(value.length, 0);
    return buffer;
  },
  generateParameterData: function* (parameter, options) {
    const value = parameter.value;
    if (value == null) {
      return;
    }
    yield value;
  },
  validate: function (value, collation) {
    if (value == null) {
      return null;
    }
    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }
    if (!collation) {
      throw new Error('No collation was set by the server for the current connection.');
    }
    if (!collation.codepage) {
      throw new Error('The collation set by the server has no associated encoding.');
    }
    return _iconvLite.default.encode(value, collation.codepage);
  }
};
var _default = exports.default = Text;
module.exports = Text;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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