"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const NULL_LENGTH = Buffer.from([0x00]);
const Time = {
  id: 0x29,
  type: 'TIMEN',
  name: 'Time',
  declaration: function (parameter) {
    return 'time(' + this.resolveScale(parameter) + ')';
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else if (parameter.value === null) {
      return 0;
    } else {
      return 7;
    }
  },
  generateTypeInfo(parameter) {
    return Buffer.from([this.id, parameter.scale]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    switch (parameter.scale) {
      case 0:
      case 1:
      case 2:
        return Buffer.from([0x03]);
      case 3:
      case 4:
        return Buffer.from([0x04]);
      case 5:
      case 6:
      case 7:
        return Buffer.from([0x05]);
      default:
        throw new Error('invalid scale');
    }
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const buffer = new _writableTrackingBuffer.default(16);
    const time = parameter.value;
    let timestamp;
    if (options.useUTC) {
      timestamp = ((time.getUTCHours() * 60 + time.getUTCMinutes()) * 60 + time.getUTCSeconds()) * 1000 + time.getUTCMilliseconds();
    } else {
      timestamp = ((time.getHours() * 60 + time.getMinutes()) * 60 + time.getSeconds()) * 1000 + time.getMilliseconds();
    }
    timestamp = timestamp * Math.pow(10, parameter.scale - 3);
    timestamp += (parameter.value.nanosecondDelta != null ? parameter.value.nanosecondDelta : 0) * Math.pow(10, parameter.scale);
    timestamp = Math.round(timestamp);
    switch (parameter.scale) {
      case 0:
      case 1:
      case 2:
        buffer.writeUInt24LE(timestamp);
        break;
      case 3:
      case 4:
        buffer.writeUInt32LE(timestamp);
        break;
      case 5:
      case 6:
      case 7:
        buffer.writeUInt40LE(timestamp);
    }
    yield buffer.data;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }
    if (isNaN(value)) {
      throw new TypeError('Invalid time.');
    }
    return value;
  }
};
var _default = exports.default = Time;
module.exports = Time;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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