"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _intn = _interopRequireDefault(require("./intn"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DATA_LENGTH = Buffer.from([0x01]);
const NULL_LENGTH = Buffer.from([0x00]);
const TinyInt = {
  id: 0x30,
  type: 'INT1',
  name: 'TinyInt',
  declaration: function () {
    return 'tinyint';
  },
  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x01]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    return DATA_LENGTH;
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const buffer = Buffer.alloc(1);
    buffer.writeUInt8(Number(parameter.value), 0);
    yield buffer;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    if (typeof value !== 'number') {
      value = Number(value);
    }
    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }
    if (value < 0 || value > 255) {
      throw new TypeError('Value must be between 0 and 255, inclusive.');
    }
    return value | 0;
  }
};
var _default = exports.default = TinyInt;
module.exports = TinyInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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