"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _iconvLite = _interopRequireDefault(require("iconv-lite"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const MAX = (1 << 16) - 1;
const UNKNOWN_PLP_LEN = Buffer.from([0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff]);
const PLP_TERMINATOR = Buffer.from([0x00, 0x00, 0x00, 0x00]);
const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const MAX_NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF]);
const VarChar = {
  id: 0xA7,
  type: 'BIGVARCHR',
  name: 'VarChar',
  maximumLength: 8000,
  declaration: function (parameter) {
    const value = parameter.value;
    let length;
    if (parameter.length) {
      length = parameter.length;
    } else if (value != null) {
      length = value.length || 1;
    } else if (value === null && !parameter.output) {
      length = 1;
    } else {
      length = this.maximumLength;
    }
    if (length <= this.maximumLength) {
      return 'varchar(' + length + ')';
    } else {
      return 'varchar(max)';
    }
  },
  resolveLength: function (parameter) {
    const value = parameter.value;
    if (parameter.length != null) {
      return parameter.length;
    } else if (value != null) {
      return value.length || 1;
    } else {
      return this.maximumLength;
    }
  },
  generateTypeInfo(parameter) {
    const buffer = Buffer.alloc(8);
    buffer.writeUInt8(this.id, 0);
    if (parameter.length <= this.maximumLength) {
      buffer.writeUInt16LE(parameter.length, 1);
    } else {
      buffer.writeUInt16LE(MAX, 1);
    }
    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 3, 0, 5);
    }
    return buffer;
  },
  generateParameterLength(parameter, options) {
    const value = parameter.value;
    if (value == null) {
      if (parameter.length <= this.maximumLength) {
        return NULL_LENGTH;
      } else {
        return MAX_NULL_LENGTH;
      }
    }
    if (parameter.length <= this.maximumLength) {
      const buffer = Buffer.alloc(2);
      buffer.writeUInt16LE(value.length, 0);
      return buffer;
    } else {
      return UNKNOWN_PLP_LEN;
    }
  },
  *generateParameterData(parameter, options) {
    const value = parameter.value;
    if (value == null) {
      return;
    }
    if (parameter.length <= this.maximumLength) {
      yield value;
    } else {
      if (value.length > 0) {
        const buffer = Buffer.alloc(4);
        buffer.writeUInt32LE(value.length, 0);
        yield buffer;
        yield value;
      }
      yield PLP_TERMINATOR;
    }
  },
  validate: function (value, collation) {
    if (value == null) {
      return null;
    }
    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }
    if (!collation) {
      throw new Error('No collation was set by the server for the current connection.');
    }
    if (!collation.codepage) {
      throw new Error('The collation set by the server has no associated encoding.');
    }
    return _iconvLite.default.encode(value, collation.codepage);
  }
};
var _default = exports.default = VarChar;
module.exports = VarChar;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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