"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _token = require("./token");
var _metadataParser = require("../metadata-parser");
var _valueParser = require("../value-parser");
var _helpers = require("./helpers");
var iconv = _interopRequireWildcard(require("iconv-lite"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function (e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != typeof e && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (const t in e) "default" !== t && {}.hasOwnProperty.call(e, t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, t)) && (i.get || i.set) ? o(f, t, i) : f[t] = e[t]); return f; })(e, t); }
// s2.2.7.16

async function returnParser(parser) {
  let paramName;
  let paramOrdinal;
  let metadata;
  while (true) {
    const buf = parser.buffer;
    let offset = parser.position;
    try {
      ({
        offset,
        value: paramOrdinal
      } = (0, _helpers.readUInt16LE)(buf, offset));
      ({
        offset,
        value: paramName
      } = (0, _helpers.readBVarChar)(buf, offset));
      // status
      ({
        offset
      } = (0, _helpers.readUInt8)(buf, offset));
      ({
        offset,
        value: metadata
      } = (0, _metadataParser.readMetadata)(buf, offset, parser.options));
      if (paramName.charAt(0) === '@') {
        paramName = paramName.slice(1);
      }
    } catch (err) {
      if (err instanceof _helpers.NotEnoughDataError) {
        await parser.waitForChunk();
        continue;
      }
      throw err;
    }
    parser.position = offset;
    break;
  }
  let value;
  while (true) {
    const buf = parser.buffer;
    let offset = parser.position;
    if ((0, _valueParser.isPLPStream)(metadata)) {
      const chunks = await (0, _valueParser.readPLPStream)(parser);
      if (chunks === null) {
        value = chunks;
      } else if (metadata.type.name === 'NVarChar' || metadata.type.name === 'Xml') {
        value = Buffer.concat(chunks).toString('ucs2');
      } else if (metadata.type.name === 'VarChar') {
        value = iconv.decode(Buffer.concat(chunks), metadata.collation?.codepage ?? 'utf8');
      } else if (metadata.type.name === 'VarBinary' || metadata.type.name === 'UDT') {
        value = Buffer.concat(chunks);
      }
    } else {
      try {
        ({
          value,
          offset
        } = (0, _valueParser.readValue)(buf, offset, metadata, parser.options));
      } catch (err) {
        if (err instanceof _helpers.NotEnoughDataError) {
          await parser.waitForChunk();
          continue;
        }
        throw err;
      }
      parser.position = offset;
    }
    break;
  }
  return new _token.ReturnValueToken({
    paramOrdinal: paramOrdinal,
    paramName: paramName,
    metadata: metadata,
    value: value
  });
}
var _default = exports.default = returnParser;
module.exports = returnParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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