"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Parser = void 0;
var _events = require("events");
var _streamParser = _interopRequireDefault(require("./stream-parser"));
var _stream = require("stream");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
class Parser extends _events.EventEmitter {
  constructor(message, debug, handler, options) {
    super();
    this.debug = debug;
    this.options = options;
    this.parser = _stream.Readable.from(_streamParser.default.parseTokens(message, this.debug, this.options));
    this.parser.on('data', token => {
      debug.token(token);
      handler[token.handlerName](token);
    });
    this.parser.on('drain', () => {
      this.emit('drain');
    });
    this.parser.on('end', () => {
      this.emit('end');
    });
  }
  pause() {
    return this.parser.pause();
  }
  resume() {
    return this.parser.resume();
  }
}
exports.Parser = Parser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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