/*!--------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

export function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

export var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

export function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

export function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

export function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

export function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

export function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

export function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

export function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

export function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

export function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

export function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

export var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

export function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

export function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

export function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
export function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
export function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

export function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

export function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

export function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

export function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

export function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

export function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

export function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

export function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

export function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

export function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

export function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

export function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
            if (async) inner = dispose;
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;

}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

export function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

export default {
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
};

var sv=Object.defineProperty;var av=Object.getOwnPropertyDescriptor;var T=(i,t,e,r)=>{for(var n=r>1?void 0:r?av(t,e):t,o=i.length-1,s;o>=0;o--)(s=i[o])&&(n=(r?s(t,e,n):s(n))||n);return r&&n&&sv(t,e,n),n},I=(i,t)=>(e,r)=>t(e,r,i);import{setDefaultResultOrder as xb}from"dns";import*as nv from"fs";import{hostname as bb,release as Sb}from"os";function lp(i,t){let e=Object.create(null);for(let r of i){let n=t(r),o=e[n];o||(o=e[n]=[]),o.push(r)}return e}var sp,ap,op=class{constructor(t,e){this.toKey=e;this._map=new Map;this[sp]="SetWithKey";for(let r of t)this.add(r)}get size(){return this._map.size}add(t){let e=this.toKey(t);return this._map.set(e,t),this}delete(t){return this._map.delete(this.toKey(t))}has(t){return this._map.has(this.toKey(t))}*entries(){for(let t of this._map.values())yield[t,t]}keys(){return this.values()}*values(){for(let t of this._map.values())yield t}clear(){this._map.clear()}forEach(t,e){this._map.forEach(r=>t.call(e,r,r,this))}[(ap=Symbol.iterator,sp=Symbol.toStringTag,ap)](){return this.values()}};var Sc=class{constructor(){this.listeners=[],this.unexpectedErrorHandler=function(t){setTimeout(()=>{throw t.stack?Ir.isErrorNoTelemetry(t)?new Ir(t.message+`

`+t.stack):new Error(t.message+`

`+t.stack):t},0)}}addListener(t){return this.listeners.push(t),()=>{this._removeListener(t)}}emit(t){this.listeners.forEach(e=>{e(t)})}_removeListener(t){this.listeners.splice(this.listeners.indexOf(t),1)}setUnexpectedErrorHandler(t){this.unexpectedErrorHandler=t}getUnexpectedErrorHandler(){return this.unexpectedErrorHandler}onUnexpectedError(t){this.unexpectedErrorHandler(t),this.emit(t)}onUnexpectedExternalError(t){this.unexpectedErrorHandler(t)}},up=new Sc;function dp(i){up.setUnexpectedErrorHandler(i)}function pp(i){if(!i||typeof i!="object")return!1;let t=i;return t.code==="EPIPE"&&t.syscall?.toUpperCase()==="WRITE"}function Ke(i){or(i)||up.onUnexpectedError(i)}var Ws="Canceled";function or(i){return i instanceof Ie?!0:i instanceof Error&&i.name===Ws&&i.message===Ws}var Ie=class extends Error{constructor(){super(Ws),this.name=this.message}},cp=class i extends Error{static{this._name="PendingMigrationError"}static is(t){return t instanceof i||t instanceof Error&&t.name===i._name}constructor(t){super(t),this.name=i._name}};function Bs(){let i=new Error(Ws);return i.name=i.message,i}function Ec(i){return i?new Error(`Illegal argument: ${i}`):new Error("Illegal argument")}function Gs(i){return i?new Error(`Illegal state: ${i}`):new Error("Illegal state")}function G(i){return i?i.message?i.message:i.stack?i.stack.split(`
`)[0]:String(i):"Error"}var Ir=class i extends Error{constructor(t){super(t),this.name="CodeExpectedError"}static fromError(t){if(t instanceof i)return t;let e=new i;return e.message=t.message,e.stack=t.stack,e}static isErrorNoTelemetry(t){return t.name==="CodeExpectedError"}},nn=class i extends Error{constructor(t){super(t||"An unexpected bug occurred."),Object.setPrototypeOf(this,i.prototype)}};function qs(i,t){let e=this,r=!1,n;return function(){if(r)return n;if(r=!0,t)try{n=i.apply(e,arguments)}finally{t()}else n=i.apply(e,arguments);return n}}function lv(i,t,e=0,r=i.length){let n=e,o=r;for(;n<o;){let s=Math.floor((n+o)/2);t(i[s])?n=s+1:o=s}return n-1}var mp=class i{constructor(t){this._array=t;this._findLastMonotonousLastIdx=0}static{this.assertInvariants=!1}findLastMonotonous(t){if(i.assertInvariants){if(this._prevFindLastPredicate){for(let r of this._array)if(this._prevFindLastPredicate(r)&&!t(r))throw new Error("MonotonousArray: current predicate must be weaker than (or equal to) the previous predicate.")}this._prevFindLastPredicate=t}let e=lv(this._array,t,this._findLastMonotonousLastIdx);return this._findLastMonotonousLastIdx=e+1,e===-1?void 0:this._array[e]}};function xr(i,t,e=(r,n)=>r===n){if(i===t)return!0;if(!i||!t||i.length!==t.length)return!1;for(let r=0,n=i.length;r<n;r++)if(!e(i[r],t[r]))return!1;return!0}function Ks(i,t,e){if(i=i|0,i>=t.length)throw new TypeError("invalid index");let r=t[Math.floor(t.length*Math.random())],n=[],o=[],s=[];for(let a of t){let l=e(a,r);l<0?n.push(a):l>0?o.push(a):s.push(a)}return i<n.length?Ks(i,n,e):i<n.length+s.length?s[0]:Ks(i-(n.length+s.length),o,e)}function br(i){return i.filter(t=>!!t)}function wc(i){return Array.isArray(i)&&i.length>0}function Mt(i,t=e=>e){let e=new Set;return i.filter(r=>{let n=t(r);return e.has(n)?!1:(e.add(n),!0)})}function Pc(i,t){return i.push(t),()=>cv(i,t)}function cv(i,t){let e=i.indexOf(t);if(e>-1)return i.splice(e,1),t}function Tc(i,t){let e;if(typeof t=="number"){let r=t;e=()=>{let n=Math.sin(r++)*179426549;return n-Math.floor(n)}}else e=Math.random;for(let r=i.length-1;r>0;r-=1){let n=Math.floor(e()*(r+1)),o=i[r];i[r]=i[n],i[n]=o}}var hp;(a=>{function i(l){return l<0}a.isLessThan=i;function t(l){return l<=0}a.isLessThanOrEqual=t;function e(l){return l>0}a.isGreaterThan=e;function r(l){return l===0}a.isNeitherLessOrGreaterThan=r,a.greaterThan=1,a.lessThan=-1,a.neitherLessOrGreaterThan=0})(hp||={});function vp(i,t){return(e,r)=>t(i(e),i(r))}var yp=(i,t)=>i-t;var gp=class i{constructor(t){this.iterate=t}static{this.empty=new i(t=>{})}forEach(t){this.iterate(e=>(t(e),!0))}toArray(){let t=[];return this.iterate(e=>(t.push(e),!0)),t}filter(t){return new i(e=>this.iterate(r=>t(r)?e(r):!0))}map(t){return new i(e=>this.iterate(r=>e(t(r))))}some(t){let e=!1;return this.iterate(r=>(e=t(r),!e)),e}findFirst(t){let e;return this.iterate(r=>t(r)?(e=r,!1):!0),e}findLast(t){let e;return this.iterate(r=>(t(r)&&(e=r),!0)),e}findLastMaxBy(t){let e,r=!0;return this.iterate(n=>((r||hp.isGreaterThan(t(n,e)))&&(r=!1,e=n),!0)),e}};var Rc=class{constructor(t,e){this.uri=t;this.value=e}};function uv(i){return Array.isArray(i)}var xp,be=class i{constructor(t,e){this[xp]="ResourceMap";if(t instanceof i)this.map=new Map(t.map),this.toKey=e??i.defaultToKey;else if(uv(t)){this.map=new Map,this.toKey=e??i.defaultToKey;for(let[r,n]of t)this.set(r,n)}else this.map=new Map,this.toKey=t??i.defaultToKey}static{this.defaultToKey=t=>t.toString()}set(t,e){return this.map.set(this.toKey(t),new Rc(t,e)),this}get(t){return this.map.get(this.toKey(t))?.value}has(t){return this.map.has(this.toKey(t))}get size(){return this.map.size}clear(){this.map.clear()}delete(t){return this.map.delete(this.toKey(t))}forEach(t,e){typeof e<"u"&&(t=t.bind(e));for(let[r,n]of this.map)t(n.value,n.uri,this)}*values(){for(let t of this.map.values())yield t.value}*keys(){for(let t of this.map.values())yield t.uri}*entries(){for(let t of this.map.values())yield[t.uri,t.value]}*[(xp=Symbol.toStringTag,Symbol.iterator)](){for(let[,t]of this.map)yield[t.uri,t.value]}},bp,on=class{constructor(t,e){this[bp]="ResourceSet";!t||typeof t=="function"?this._map=new be(t):(this._map=new be(e),t.forEach(this.add,this))}get size(){return this._map.size}add(t){return this._map.set(t,t),this}clear(){this._map.clear()}delete(t){return this._map.delete(t)}forEach(t,e){this._map.forEach((r,n)=>t.call(e,n,n,this))}has(t){return this._map.has(t)}entries(){return this._map.entries()}keys(){return this._map.keys()}values(){return this._map.keys()}[(bp=Symbol.toStringTag,Symbol.iterator)](){return this.keys()}};var Sp,Cc=class{constructor(){this[Sp]="LinkedMap";this._map=new Map,this._head=void 0,this._tail=void 0,this._size=0,this._state=0}clear(){this._map.clear(),this._head=void 0,this._tail=void 0,this._size=0,this._state++}isEmpty(){return!this._head&&!this._tail}get size(){return this._size}get first(){return this._head?.value}get last(){return this._tail?.value}has(t){return this._map.has(t)}get(t,e=0){let r=this._map.get(t);if(r)return e!==0&&this.touch(r,e),r.value}set(t,e,r=0){let n=this._map.get(t);if(n)n.value=e,r!==0&&this.touch(n,r);else{switch(n={key:t,value:e,next:void 0,previous:void 0},r){case 0:this.addItemLast(n);break;case 1:this.addItemFirst(n);break;case 2:this.addItemLast(n);break;default:this.addItemLast(n);break}this._map.set(t,n),this._size++}return this}delete(t){return!!this.remove(t)}remove(t){let e=this._map.get(t);if(e)return this._map.delete(t),this.removeItem(e),this._size--,e.value}shift(){if(!this._head&&!this._tail)return;if(!this._head||!this._tail)throw new Error("Invalid list");let t=this._head;return this._map.delete(t.key),this.removeItem(t),this._size--,t.value}forEach(t,e){let r=this._state,n=this._head;for(;n;){if(e?t.bind(e)(n.value,n.key,this):t(n.value,n.key,this),this._state!==r)throw new Error("LinkedMap got modified during iteration.");n=n.next}}keys(){let t=this,e=this._state,r=this._head,n={[Symbol.iterator](){return n},next(){if(t._state!==e)throw new Error("LinkedMap got modified during iteration.");if(r){let o={value:r.key,done:!1};return r=r.next,o}else return{value:void 0,done:!0}}};return n}values(){let t=this,e=this._state,r=this._head,n={[Symbol.iterator](){return n},next(){if(t._state!==e)throw new Error("LinkedMap got modified during iteration.");if(r){let o={value:r.value,done:!1};return r=r.next,o}else return{value:void 0,done:!0}}};return n}entries(){let t=this,e=this._state,r=this._head,n={[Symbol.iterator](){return n},next(){if(t._state!==e)throw new Error("LinkedMap got modified during iteration.");if(r){let o={value:[r.key,r.value],done:!1};return r=r.next,o}else return{value:void 0,done:!0}}};return n}[(Sp=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}trimOld(t){if(t>=this.size)return;if(t===0){this.clear();return}let e=this._head,r=this.size;for(;e&&r>t;)this._map.delete(e.key),e=e.next,r--;this._head=e,this._size=r,e&&(e.previous=void 0),this._state++}trimNew(t){if(t>=this.size)return;if(t===0){this.clear();return}let e=this._tail,r=this.size;for(;e&&r>t;)this._map.delete(e.key),e=e.previous,r--;this._tail=e,this._size=r,e&&(e.next=void 0),this._state++}addItemFirst(t){if(!this._head&&!this._tail)this._tail=t;else if(this._head)t.next=this._head,this._head.previous=t;else throw new Error("Invalid list");this._head=t,this._state++}addItemLast(t){if(!this._head&&!this._tail)this._head=t;else if(this._tail)t.previous=this._tail,this._tail.next=t;else throw new Error("Invalid list");this._tail=t,this._state++}removeItem(t){if(t===this._head&&t===this._tail)this._head=void 0,this._tail=void 0;else if(t===this._head){if(!t.next)throw new Error("Invalid list");t.next.previous=void 0,this._head=t.next}else if(t===this._tail){if(!t.previous)throw new Error("Invalid list");t.previous.next=void 0,this._tail=t.previous}else{let e=t.next,r=t.previous;if(!e||!r)throw new Error("Invalid list");e.previous=r,r.next=e}t.next=void 0,t.previous=void 0,this._state++}touch(t,e){if(!this._head||!this._tail)throw new Error("Invalid list");if(!(e!==1&&e!==2)){if(e===1){if(t===this._head)return;let r=t.next,n=t.previous;t===this._tail?(n.next=void 0,this._tail=n):(r.previous=n,n.next=r),t.previous=void 0,t.next=this._head,this._head.previous=t,this._head=t,this._state++}else if(e===2){if(t===this._tail)return;let r=t.next,n=t.previous;t===this._head?(r.previous=void 0,this._head=r):(r.previous=n,n.next=r),t.next=void 0,t.previous=this._tail,this._tail.next=t,this._tail=t,this._state++}}}toJSON(){let t=[];return this.forEach((e,r)=>{t.push([r,e])}),t}fromJSON(t){this.clear();for(let[e,r]of t)this.set(e,r)}},_c=class extends Cc{constructor(t,e=1){super(),this._limit=t,this._ratio=Math.min(Math.max(0,e),1)}get limit(){return this._limit}set limit(t){this._limit=t,this.checkTrim()}get ratio(){return this._ratio}set ratio(t){this._ratio=Math.min(Math.max(0,t),1),this.checkTrim()}get(t,e=2){return super.get(t,e)}peek(t){return super.get(t,0)}set(t,e){return super.set(t,e,2),this}checkTrim(){this.size>this._limit&&this.trim(Math.round(this._limit*this._ratio))}},Sr=class extends _c{constructor(t,e=1){super(t,e)}trim(t){this.trimOld(t)}set(t,e){return super.set(t,e),this.checkTrim(),this}};var zs=class{constructor(){this.map=new Map}add(t,e){let r=this.map.get(t);r||(r=new Set,this.map.set(t,r)),r.add(e)}delete(t,e){let r=this.map.get(t);r&&(r.delete(e),r.size===0&&this.map.delete(t))}forEach(t,e){let r=this.map.get(t);r&&r.forEach(e)}get(t){let e=this.map.get(t);return e||new Set}};function $s(i,t){if(!i)throw new Error(t?`Assertion failed (${t})`:"Assertion Failed")}function kc(i,t="Unreachable"){throw new Error(t)}function si(i,t="unexpected state"){if(!i)throw typeof t=="string"?new nn(`Assertion Failed: ${t}`):t}function te(i){return typeof i=="string"}function he(i){return typeof i=="object"&&i!==null&&!Array.isArray(i)&&!(i instanceof RegExp)&&!(i instanceof Date)}function Ep(i){let t=Object.getPrototypeOf(Uint8Array);return typeof i=="object"&&i instanceof t}function sn(i){return typeof i=="number"&&!isNaN(i)}function wp(i){return!!i&&typeof i[Symbol.iterator]=="function"}function Tt(i){return i===!0||i===!1}function ut(i){return typeof i>"u"}function js(i){return!Oe(i)}function Oe(i){return ut(i)||i===null}function Dc(i){return si(i!=null,"Argument is `undefined` or `null`."),i}var pv=Object.prototype.hasOwnProperty;function Hs(i){if(!he(i))return!1;for(let t in i)if(pv.call(i,t))return!1;return!0}function Lc(i){return typeof i=="function"}var Er;(Fe=>{function i(L){return!!L&&typeof L=="object"&&typeof L[Symbol.iterator]=="function"}Fe.is=i;let t=Object.freeze([]);function e(){return t}Fe.empty=e;function*r(L){yield L}Fe.single=r;function n(L){return i(L)?L:r(L)}Fe.wrap=n;function o(L){return L??t}Fe.from=o;function*s(L){for(let j=L.length-1;j>=0;j--)yield L[j]}Fe.reverse=s;function a(L){return!L||L[Symbol.iterator]().next().done===!0}Fe.isEmpty=a;function l(L){return L[Symbol.iterator]().next().value}Fe.first=l;function c(L,j){let F=0;for(let xe of L)if(j(xe,F++))return!0;return!1}Fe.some=c;function u(L,j){let F=0;for(let xe of L)if(!j(xe,F++))return!1;return!0}Fe.every=u;function p(L,j){for(let F of L)if(j(F))return F}Fe.find=p;function*f(L,j){for(let F of L)j(F)&&(yield F)}Fe.filter=f;function*g(L,j){let F=0;for(let xe of L)yield j(xe,F++)}Fe.map=g;function*v(L,j){let F=0;for(let xe of L)yield*j(xe,F++)}Fe.flatMap=v;function*h(...L){for(let j of L)wp(j)?yield*j:yield j}Fe.concat=h;function y(L,j,F){let xe=F;for(let Et of L)xe=j(xe,Et);return xe}Fe.reduce=y;function E(L){let j=0;for(let F of L)j++;return j}Fe.length=E;function*b(L,j,F=L.length){for(j<-L.length&&(j=0),j<0&&(j+=L.length),F<0?F+=L.length:F>L.length&&(F=L.length);j<F;j++)yield L[j]}Fe.slice=b;function C(L,j=Number.POSITIVE_INFINITY){let F=[];if(j===0)return[F,L];let xe=L[Symbol.iterator]();for(let Et=0;Et<j;Et++){let st=xe.next();if(st.done)return[F,Fe.empty()];F.push(st.value)}return[F,{[Symbol.iterator](){return xe}}]}Fe.consume=C;async function N(L){let j=[];for await(let F of L)j.push(F);return j}Fe.asyncToArray=N;async function oe(L){let j=[];for await(let F of L)j=j.concat(F);return j}Fe.asyncToArrayFlat=oe})(Er||={});var fv=!1,li=null;var Pp=class i{constructor(){this.livingDisposables=new Map}static{this.idx=0}getDisposableData(t){let e=this.livingDisposables.get(t);return e||(e={parent:null,source:null,isSingleton:!1,value:t,idx:i.idx++},this.livingDisposables.set(t,e)),e}trackDisposable(t){let e=this.getDisposableData(t);e.source||(e.source=new Error().stack)}setParent(t,e){let r=this.getDisposableData(t);r.parent=e}markAsDisposed(t){this.livingDisposables.delete(t)}markAsSingleton(t){this.getDisposableData(t).isSingleton=!0}getRootParent(t,e){let r=e.get(t);if(r)return r;let n=t.parent?this.getRootParent(this.getDisposableData(t.parent),e):t;return e.set(t,n),n}getTrackedDisposables(){let t=new Map;return[...this.livingDisposables.entries()].filter(([,r])=>r.source!==null&&!this.getRootParent(r,t).isSingleton).flatMap(([r])=>r)}computeLeakingDisposables(t=10,e){let r;if(e)r=e;else{let l=new Map,c=[...this.livingDisposables.values()].filter(p=>p.source!==null&&!this.getRootParent(p,l).isSingleton);if(c.length===0)return;let u=new Set(c.map(p=>p.value));if(r=c.filter(p=>!(p.parent&&u.has(p.parent))),r.length===0)throw new Error("There are cyclic diposable chains!")}if(!r)return;function n(l){function c(p,f){for(;p.length>0&&f.some(g=>typeof g=="string"?g===p[0]:p[0].match(g));)p.shift()}let u=l.source.split(`
`).map(p=>p.trim().replace("at ","")).filter(p=>p!=="");return c(u,["Error",/^trackDisposable \(.*\)$/,/^DisposableTracker.trackDisposable \(.*\)$/]),u.reverse()}let o=new zs;for(let l of r){let c=n(l);for(let u=0;u<=c.length;u++)o.add(c.slice(0,u).join(`
`),l)}r.sort(vp(l=>l.idx,yp));let s="",a=0;for(let l of r.slice(0,t)){a++;let c=n(l),u=[];for(let p=0;p<c.length;p++){let f=c[p];f=`(shared with ${o.get(c.slice(0,p+1).join(`
`)).size}/${r.length} leaks) at ${f}`;let v=o.get(c.slice(0,p).join(`
`)),h=lp([...v].map(y=>n(y)[p]),y=>y);delete h[c[p]];for(let[y,E]of Object.entries(h))E&&u.unshift(`    - stacktraces of ${E.length} other leaks continue with ${y}`);u.unshift(f)}s+=`


==================== Leaking disposable ${a}/${r.length}: ${l.value.constructor.name} ====================
${u.join(`
`)}
============================================================

`}return r.length>t&&(s+=`


... and ${r.length-t} more leaking disposables

`),{leaks:r,details:s}}};function mv(i){li=i}if(fv){let i="__is_disposable_tracked__";mv(new class{trackDisposable(t){let e=new Error("Potentially leaked disposable").stack;setTimeout(()=>{t[i]||console.log(e)},3e3)}setParent(t,e){if(t&&t!==_.None)try{t[i]=!0}catch{}}markAsDisposed(t){if(t&&t!==_.None)try{t[i]=!0}catch{}}markAsSingleton(t){}})}function Po(i){return li?.trackDisposable(i),i}function To(i){li?.markAsDisposed(i)}function Cn(i,t){li?.setParent(i,t)}function gv(i,t){if(li)for(let e of i)li.setParent(e,t)}function Qs(i){return typeof i=="object"&&i!==null&&typeof i.dispose=="function"&&i.dispose.length===0}function dt(i){if(Er.is(i)){let t=[];for(let e of i)if(e)try{e.dispose()}catch(r){t.push(r)}if(t.length===1)throw t[0];if(t.length>1)throw new AggregateError(t,"Encountered errors while disposing of store");return Array.isArray(i)?[]:i}else if(i)return i.dispose(),i}function Js(...i){let t=ue(()=>dt(i));return gv(i,t),t}var Ac=class{constructor(t){this._isDisposed=!1,this._fn=t,Po(this)}dispose(){if(!this._isDisposed){if(!this._fn)throw new Error("Unbound disposable context: Need to use an arrow function to preserve the value of this");this._isDisposed=!0,To(this),this._fn()}}};function ue(i){return new Ac(i)}var Pe=class i{constructor(){this._toDispose=new Set;this._isDisposed=!1;Po(this)}static{this.DISABLE_DISPOSED_WARNING=!1}dispose(){this._isDisposed||(To(this),this._isDisposed=!0,this.clear())}get isDisposed(){return this._isDisposed}clear(){if(this._toDispose.size!==0)try{dt(this._toDispose)}finally{this._toDispose.clear()}}add(t){if(!t||t===_.None)return t;if(t===this)throw new Error("Cannot register a disposable on itself!");return Cn(t,this),this._isDisposed?i.DISABLE_DISPOSED_WARNING||console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack):this._toDispose.add(t),t}delete(t){if(t){if(t===this)throw new Error("Cannot dispose a disposable on itself!");this._toDispose.delete(t),t.dispose()}}deleteAndLeak(t){t&&this._toDispose.delete(t)&&Cn(t,null)}assertNotDisposed(){this._isDisposed&&Ke(new nn("Object disposed"))}},_=class{constructor(){this._store=new Pe;Po(this),Cn(this._store,this)}static{this.None=Object.freeze({dispose(){}})}dispose(){To(this),this._store.dispose()}_register(t){if(t===this)throw new Error("Cannot register a disposable on itself!");return this._store.add(t)}},Zt=class{constructor(){this._isDisposed=!1;Po(this)}get value(){return this._isDisposed?void 0:this._value}set value(t){this._isDisposed||t===this._value||(this._value?.dispose(),t&&Cn(t,this),this._value=t)}clear(){this.value=void 0}dispose(){this._isDisposed=!0,To(this),this._value?.dispose(),this._value=void 0}clearAndLeak(){let t=this._value;return this._value=void 0,t&&Cn(t,null),t}};var wr=class{constructor(t=new Map){this._isDisposed=!1;this._store=t,Po(this)}dispose(){To(this),this._isDisposed=!0,this.clearAndDisposeAll()}clearAndDisposeAll(){if(this._store.size)try{dt(this._store.values())}finally{this._store.clear()}}has(t){return this._store.has(t)}get size(){return this._store.size}get(t){return this._store.get(t)}set(t,e,r=!1){this._isDisposed&&console.warn(new Error("Trying to add a disposable to a DisposableMap that has already been disposed of. The added object will be leaked!").stack),r||this._store.get(t)?.dispose(),this._store.set(t,e),Cn(e,this)}deleteAndDispose(t){this._store.get(t)?.dispose(),this._store.delete(t)}deleteAndLeak(t){let e=this._store.get(t);return e&&Cn(e,null),this._store.delete(t),e}keys(){return this._store.keys()}values(){return this._store.values()}[Symbol.iterator](){return this._store[Symbol.iterator]()}};function Tp(i,t){return i.then(e=>(t.isDisposed?e.dispose():t.add(e),e))}var Le=class i{static{this.Undefined=new i(void 0)}constructor(t){this.element=t,this.next=i.Undefined,this.prev=i.Undefined}},ci=class{constructor(){this._first=Le.Undefined;this._last=Le.Undefined;this._size=0}get size(){return this._size}isEmpty(){return this._first===Le.Undefined}clear(){let t=this._first;for(;t!==Le.Undefined;){let e=t.next;t.prev=Le.Undefined,t.next=Le.Undefined,t=e}this._first=Le.Undefined,this._last=Le.Undefined,this._size=0}unshift(t){return this._insert(t,!1)}push(t){return this._insert(t,!0)}_insert(t,e){let r=new Le(t);if(this._first===Le.Undefined)this._first=r,this._last=r;else if(e){let o=this._last;this._last=r,r.prev=o,o.next=r}else{let o=this._first;this._first=r,r.next=o,o.prev=r}this._size+=1;let n=!1;return()=>{n||(n=!0,this._remove(r))}}shift(){if(this._first!==Le.Undefined){let t=this._first.element;return this._remove(this._first),t}}pop(){if(this._last!==Le.Undefined){let t=this._last.element;return this._remove(this._last),t}}peek(){if(this._last!==Le.Undefined)return this._last.element}_remove(t){if(t.prev!==Le.Undefined&&t.next!==Le.Undefined){let e=t.prev;e.next=t.next,t.next.prev=e}else t.prev===Le.Undefined&&t.next===Le.Undefined?(this._first=Le.Undefined,this._last=Le.Undefined):t.next===Le.Undefined?(this._last=this._last.prev,this._last.next=Le.Undefined):t.prev===Le.Undefined&&(this._first=this._first.next,this._first.prev=Le.Undefined);this._size-=1}*[Symbol.iterator](){let t=this._first;for(;t!==Le.Undefined;)yield t.element,t=t.next}};var hv=globalThis.performance.now.bind(globalThis.performance),an=class i{static create(t){return new i(t)}constructor(t){this._now=t===!1?Date.now:hv,this._startTime=this._now(),this._stopTime=-1}stop(){this._stopTime=this._now()}reset(){this._startTime=this._now(),this._stopTime=-1}elapsed(){return this._stopTime!==-1?this._stopTime-this._startTime:this._now()-this._startTime}};var Rp=!1,vv=!1,J;(hr=>{hr.None=()=>_.None;function t(M){if(vv){let{onDidAddListener:k}=M,A=Ro.create(),D=0;M.onDidAddListener=()=>{++D===2&&(console.warn("snapshotted emitter LIKELY used public and SHOULD HAVE BEEN created with DisposableStore. snapshotted here"),A.print()),k?.()}}}function e(M,k,A){return g(M,()=>{},0,void 0,k??!0,void 0,A)}hr.defer=e;function r(M){return(k,A=null,D)=>{let O=!1,Q;return Q=M(se=>{if(!O)return Q?Q.dispose():O=!0,k.call(A,se)},null,D),O&&Q.dispose(),Q}}hr.once=r;function n(M,k){return hr.once(hr.filter(M,k))}hr.onceIf=n;function o(M,k,A){return p((D,O=null,Q)=>M(se=>D.call(O,k(se)),null,Q),A)}hr.map=o;function s(M,k,A){return p((D,O=null,Q)=>M(se=>{k(se),D.call(O,se)},null,Q),A)}hr.forEach=s;function a(M,k,A){return p((D,O=null,Q)=>M(se=>k(se)&&D.call(O,se),null,Q),A)}hr.filter=a;function l(M){return M}hr.signal=l;function c(...M){return(k,A=null,D)=>{let O=Js(...M.map(Q=>Q(se=>k.call(A,se))));return f(O,D)}}hr.any=c;function u(M,k,A,D){let O=A;return o(M,Q=>(O=k(O,Q),O),D)}hr.reduce=u;function p(M,k){let A,D={onWillAddFirstListener(){A=M(O.fire,O)},onDidRemoveLastListener(){A?.dispose()}};k||t(D);let O=new R(D);return k?.add(O),O.event}function f(M,k){return k instanceof Array?k.push(M):k&&k.add(M),M}function g(M,k,A=100,D=!1,O=!1,Q,se){let De,we,at,vt=0,zt,wt={leakWarningThreshold:Q,onWillAddFirstListener(){De=M(xo=>{vt++,we=k(we,xo),D&&!at&&(vr.fire(we),we=void 0),zt=()=>{let bo=we;we=void 0,at=void 0,(!D||vt>1)&&vr.fire(bo),vt=0},typeof A=="number"?(at&&clearTimeout(at),at=setTimeout(zt,A)):at===void 0&&(at=null,queueMicrotask(zt))})},onWillRemoveListener(){O&&vt>0&&zt?.()},onDidRemoveLastListener(){zt=void 0,De.dispose()}};se||t(wt);let vr=new R(wt);return se?.add(vr),vr.event}hr.debounce=g;function v(M,k=0,A,D){return hr.debounce(M,(O,Q)=>O?(O.push(Q),O):[Q],k,void 0,A??!0,void 0,D)}hr.accumulate=v;function h(M,k,A=100,D=!0,O=!0,Q,se){let De,we,at,vt=0,zt={leakWarningThreshold:Q,onWillAddFirstListener(){De=M(vr=>{vt++,we=k(we,vr),at===void 0&&(D&&(wt.fire(we),we=void 0,vt=0),typeof A=="number"?at=setTimeout(()=>{O&&vt>0&&wt.fire(we),we=void 0,at=void 0,vt=0},A):(at=0,queueMicrotask(()=>{O&&vt>0&&wt.fire(we),we=void 0,at=void 0,vt=0})))})},onDidRemoveLastListener(){De.dispose()}};se||t(zt);let wt=new R(zt);return se?.add(wt),wt.event}hr.throttle=h;function y(M,k=(D,O)=>D===O,A){let D=!0,O;return a(M,Q=>{let se=D||!k(Q,O);return D=!1,O=Q,se},A)}hr.latch=y;function E(M,k,A){return[hr.filter(M,k,A),hr.filter(M,D=>!k(D),A)]}hr.split=E;function b(M,k=!1,A=[],D){let O=A.slice(),Q=M(we=>{O?O.push(we):De.fire(we)});D&&D.add(Q);let se=()=>{O?.forEach(we=>De.fire(we)),O=null},De=new R({onWillAddFirstListener(){Q||(Q=M(we=>De.fire(we)),D&&D.add(Q))},onDidAddFirstListener(){O&&(k?setTimeout(se):se())},onDidRemoveLastListener(){Q&&Q.dispose(),Q=null}});return D&&D.add(De),De.event}hr.buffer=b;function C(M,k){return(D,O,Q)=>{let se=k(new oe);return M(function(De){let we=se.evaluate(De);we!==N&&D.call(O,we)},void 0,Q)}}hr.chain=C;let N=Symbol("HaltChainable");class oe{constructor(){this.steps=[]}map(k){return this.steps.push(k),this}forEach(k){return this.steps.push(A=>(k(A),A)),this}filter(k){return this.steps.push(A=>k(A)?A:N),this}reduce(k,A){let D=A;return this.steps.push(O=>(D=k(D,O),D)),this}latch(k=(A,D)=>A===D){let A=!0,D;return this.steps.push(O=>{let Q=A||!k(O,D);return A=!1,D=O,Q?O:N}),this}evaluate(k){for(let A of this.steps)if(k=A(k),k===N)break;return k}}function Fe(M,k,A=D=>D){let D=(...De)=>se.fire(A(...De)),O=()=>M.on(k,D),Q=()=>M.removeListener(k,D),se=new R({onWillAddFirstListener:O,onDidRemoveLastListener:Q});return se.event}hr.fromNodeEventEmitter=Fe;function L(M,k,A=D=>D){let D=(...De)=>se.fire(A(...De)),O=()=>M.addEventListener(k,D),Q=()=>M.removeEventListener(k,D),se=new R({onWillAddFirstListener:O,onDidRemoveLastListener:Q});return se.event}hr.fromDOMEventEmitter=L;function j(M,k){let A,D,O=new Promise(Q=>{D=r(M)(Q),Vc(D,k),A=()=>{_p(D,k)}});return O.cancel=A,k&&O.finally(()=>_p(D,k)),O}hr.toPromise=j;function F(M,k){return M(A=>k.fire(A))}hr.forward=F;function xe(M,k,A){return k(A),M(D=>k(D))}hr.runAndSubscribe=xe;class Et{constructor(k,A){this._observable=k;this._counter=0;this._hasChanged=!1;let D={onWillAddFirstListener:()=>{k.addObserver(this),this._observable.reportChanges()},onDidRemoveLastListener:()=>{k.removeObserver(this)}};A||t(D),this.emitter=new R(D),A&&A.add(this.emitter)}beginUpdate(k){this._counter++}handlePossibleChange(k){}handleChange(k,A){this._hasChanged=!0}endUpdate(k){this._counter--,this._counter===0&&(this._observable.reportChanges(),this._hasChanged&&(this._hasChanged=!1,this.emitter.fire(this._observable.get())))}}function st(M,k){return new Et(M,k).emitter.event}hr.fromObservable=st;function rn(M){return(k,A,D)=>{let O=0,Q=!1,se={beginUpdate(){O++},endUpdate(){O--,O===0&&(M.reportChanges(),Q&&(Q=!1,k.call(A)))},handlePossibleChange(){},handleChange(){Q=!0}};M.addObserver(se),M.reportChanges();let De={dispose(){M.removeObserver(se)}};return Vc(De,D),De}}hr.fromObservableLight=rn})(J||={});var Uc=class i{constructor(t){this.listenerCount=0;this.invocationCount=0;this.elapsedOverall=0;this.durations=[];this.name=`${t}_${i._idPool++}`,i.all.add(this)}static{this.all=new Set}static{this._idPool=0}start(t){this._stopWatch=new an,this.listenerCount=t}stop(){if(this._stopWatch){let t=this._stopWatch.elapsed();this.durations.push(t),this.elapsedOverall+=t,this.invocationCount+=1,this._stopWatch=void 0}}},Cp=-1;var Mc=class i{constructor(t,e,r=(i._idPool++).toString(16).padStart(3,"0")){this._errorHandler=t;this.threshold=e;this.name=r;this._warnCountdown=0}static{this._idPool=1}dispose(){this._stacks?.clear()}check(t,e){let r=this.threshold;if(r<=0||e<r)return;this._stacks||(this._stacks=new Map);let n=this._stacks.get(t.value)||0;if(this._stacks.set(t.value,n+1),this._warnCountdown-=1,this._warnCountdown<=0){this._warnCountdown=r*.5;let[o,s]=this.getMostFrequentStack(),a=`[${this.name}] potential listener LEAK detected, having ${e} listeners already. MOST frequent listener (${s}):`;console.warn(a),console.warn(o);let l=new Fc(a,o);this._errorHandler(l)}return()=>{let o=this._stacks.get(t.value)||0;this._stacks.set(t.value,o-1)}}getMostFrequentStack(){if(!this._stacks)return;let t,e=0;for(let[r,n]of this._stacks)(!t||e<n)&&(t=[r,n],e=n);return t}},Ro=class i{constructor(t){this.value=t}static create(){let t=new Error;return new i(t.stack??"")}print(){console.warn(this.value.split(`
`).slice(2).join(`
`))}},Fc=class extends Error{constructor(t,e){super(t),this.name="ListenerLeakError",this.stack=e}},Oc=class extends Error{constructor(t,e){super(t),this.name="ListenerRefusalError",this.stack=e}},yv=0,ui=class{constructor(t){this.value=t;this.id=yv++}},Iv=2,xv=(i,t)=>{if(i instanceof ui)t(i);else for(let e=0;e<i.length;e++){let r=i[e];r&&t(r)}},R=class{constructor(t){this._size=0;this._options=t,this._leakageMon=Cp>0||this._options?.leakWarningThreshold?new Mc(t?.onListenerError??Ke,this._options?.leakWarningThreshold??Cp):void 0,this._perfMon=this._options?._profName?new Uc(this._options._profName):void 0,this._deliveryQueue=this._options?.deliveryQueue}dispose(){if(!this._disposed){if(this._disposed=!0,this._deliveryQueue?.current===this&&this._deliveryQueue.reset(),this._listeners){if(Rp){let t=this._listeners;queueMicrotask(()=>{xv(t,e=>e.stack?.print())})}this._listeners=void 0,this._size=0}this._options?.onDidRemoveLastListener?.(),this._leakageMon?.dispose()}}get event(){return this._event??=(t,e,r)=>{if(this._leakageMon&&this._size>this._leakageMon.threshold**2){let l=`[${this._leakageMon.name}] REFUSES to accept new listeners because it exceeded its threshold by far (${this._size} vs ${this._leakageMon.threshold})`;console.warn(l);let c=this._leakageMon.getMostFrequentStack()??["UNKNOWN stack",-1],u=new Oc(`${l}. HINT: Stack shows most frequent listener (${c[1]}-times)`,c[0]);return(this._options?.onListenerError||Ke)(u),_.None}if(this._disposed)return _.None;e&&(t=t.bind(e));let n=new ui(t),o,s;this._leakageMon&&this._size>=Math.ceil(this._leakageMon.threshold*.2)&&(n.stack=Ro.create(),o=this._leakageMon.check(n.stack,this._size+1)),Rp&&(n.stack=s??Ro.create()),this._listeners?this._listeners instanceof ui?(this._deliveryQueue??=new Nc,this._listeners=[this._listeners,n]):this._listeners.push(n):(this._options?.onWillAddFirstListener?.(this),this._listeners=n,this._options?.onDidAddFirstListener?.(this)),this._options?.onDidAddListener?.(this),this._size++;let a=ue(()=>{o?.(),this._removeListener(n)});return Vc(a,r),a},this._event}_removeListener(t){if(this._options?.onWillRemoveListener?.(this),!this._listeners)return;if(this._size===1){this._listeners=void 0,this._options?.onDidRemoveLastListener?.(this),this._size=0;return}let e=this._listeners,r=e.indexOf(t);if(r===-1)throw console.log("disposed?",this._disposed),console.log("size?",this._size),console.log("arr?",JSON.stringify(this._listeners)),new Error("Attempted to dispose unknown listener");this._size--,e[r]=void 0;let n=this._deliveryQueue.current===this;if(this._size*Iv<=e.length){let o=0;for(let s=0;s<e.length;s++)e[s]?e[o++]=e[s]:n&&o<this._deliveryQueue.end&&(this._deliveryQueue.end--,o<this._deliveryQueue.i&&this._deliveryQueue.i--);e.length=o}}_deliver(t,e){if(!t)return;let r=this._options?.onListenerError||Ke;if(!r){t.value(e);return}try{t.value(e)}catch(n){r(n)}}_deliverQueue(t){let e=t.current._listeners;for(;t.i<t.end;)this._deliver(e[t.i++],t.value);t.reset()}fire(t){if(this._deliveryQueue?.current&&(this._deliverQueue(this._deliveryQueue),this._perfMon?.stop()),this._perfMon?.start(this._size),this._listeners)if(this._listeners instanceof ui)this._deliver(this._listeners,t);else{let e=this._deliveryQueue;e.enqueue(this,t,this._listeners.length),this._deliverQueue(e)}this._perfMon?.stop()}hasListeners(){return this._size>0}};var Nc=class{constructor(){this.i=-1;this.end=0}enqueue(t,e,r){this.i=0,this.end=r,this.current=t,this.value=e}reset(){this.i=this.end,this.current=void 0,this.value=void 0}};var _n=class extends R{constructor(e){super(e);this._isPaused=0;this._eventQueue=new ci;this._mergeFn=e?.merge}get isPaused(){return this._isPaused!==0}pause(){this._isPaused++}resume(){if(this._isPaused!==0&&--this._isPaused===0)if(this._mergeFn){if(this._eventQueue.size>0){let e=Array.from(this._eventQueue);this._eventQueue.clear(),super.fire(this._mergeFn(e))}}else for(;!this._isPaused&&this._eventQueue.size!==0;)super.fire(this._eventQueue.shift())}fire(e){this._size&&(this._isPaused!==0?this._eventQueue.push(e):super.fire(e))}};var Xs=class{constructor(){this.listening=!1;this.inputEvent=J.None;this.inputEventListener=_.None;this.emitter=new R({onDidAddFirstListener:()=>{this.listening=!0,this.inputEventListener=this.inputEvent(this.emitter.fire,this.emitter)},onDidRemoveLastListener:()=>{this.listening=!1,this.inputEventListener.dispose()}});this.event=this.emitter.event}set input(t){this.inputEvent=t,this.listening&&(this.inputEventListener.dispose(),this.inputEventListener=t(this.emitter.fire,this.emitter))}dispose(){this.inputEventListener.dispose(),this.emitter.dispose()}};function Vc(i,t){t instanceof Pe?t.add(i):Array.isArray(t)&&t.push(i)}function _p(i,t){if(t instanceof Pe)t.delete(i);else if(Array.isArray(t)){let e=t.indexOf(i);e!==-1&&t.splice(e,1)}i.dispose()}var kp=Object.freeze(function(i,t){let e=setTimeout(i.bind(t),0);return{dispose(){clearTimeout(e)}}}),re;(r=>{function i(n){return n===r.None||n===r.Cancelled||n instanceof di?!0:!n||typeof n!="object"?!1:typeof n.isCancellationRequested=="boolean"&&typeof n.onCancellationRequested=="function"}r.isCancellationToken=i,r.None=Object.freeze({isCancellationRequested:!1,onCancellationRequested:J.None}),r.Cancelled=Object.freeze({isCancellationRequested:!0,onCancellationRequested:kp})})(re||={});var di=class{constructor(){this._isCancelled=!1;this._emitter=null}cancel(){this._isCancelled||(this._isCancelled=!0,this._emitter&&(this._emitter.fire(void 0),this.dispose()))}get isCancellationRequested(){return this._isCancelled}get onCancellationRequested(){return this._isCancelled?kp:(this._emitter||(this._emitter=new R),this._emitter.event)}dispose(){this._emitter&&(this._emitter.dispose(),this._emitter=null)}},pt=class{constructor(t){this._token=void 0;this._parentListener=void 0;this._parentListener=t&&t.onCancellationRequested(this.cancel,this)}get token(){return this._token||(this._token=new di),this._token}cancel(){this._token?this._token instanceof di&&this._token.cancel():this._token=re.Cancelled}dispose(t=!1){t&&this.cancel(),this._parentListener?.dispose(),this._token?this._token instanceof di&&this._token.dispose():this._token=re.None}};function bv(){return globalThis._VSCODE_NLS_MESSAGES}function Wc(){return globalThis._VSCODE_NLS_LANGUAGE}var Sv=Wc()==="pseudo"||typeof document<"u"&&document.location&&typeof document.location.hash=="string"&&document.location.hash.indexOf("pseudo=true")>=0;function Ys(i,t){let e;return t.length===0?e=i:e=i.replace(/\{(\d+)\}/g,(r,n)=>{let o=n[0],s=t[o],a=r;return typeof s=="string"?a=s:(typeof s=="number"||typeof s=="boolean"||s===void 0||s===null)&&(a=String(s)),a}),Sv&&(e="\uFF3B"+e.replace(/[aouei]/g,"$&$&")+"\uFF3D"),e}function m(i,t,...e){return Ys(typeof i=="number"?Dp(i,t):t,e)}function Dp(i,t){let e=bv()?.[i];if(typeof e!="string"){if(typeof t=="string")return t;throw new Error(`!!! NLS MISSING: ${i} !!!`)}return e}function Bc(i,t,...e){let r;typeof i=="number"?r=Dp(i,t):r=t;let n=Ys(r,e);return{value:n,original:t===r?n:Ys(t,e)}}var kn="en",_o=!1,ko=!1,Co=!1,Ap=!1,Up=!1,Gc=!1,Ev=!1,Mp=!1,wv=!1,Pv=!1,Zs,ea=kn,Lp=kn,Fp,Gr,qr=globalThis,Ft;typeof qr.vscode<"u"&&typeof qr.vscode.process<"u"?Ft=qr.vscode.process:typeof process<"u"&&typeof process?.versions?.node=="string"&&(Ft=process);var Op=typeof Ft?.versions?.electron=="string",Tv=Op&&Ft?.type==="renderer";if(typeof Ft=="object"){_o=Ft.platform==="win32",ko=Ft.platform==="darwin",Co=Ft.platform==="linux",Ap=Co&&!!Ft.env.SNAP&&!!Ft.env.SNAP_REVISION,Ev=Op,wv=!!Ft.env.CI||!!Ft.env.BUILD_ARTIFACTSTAGINGDIRECTORY||!!Ft.env.GITHUB_WORKSPACE,Zs=kn,ea=kn;let i=Ft.env.VSCODE_NLS_CONFIG;if(i)try{let t=JSON.parse(i);Zs=t.userLocale,Lp=t.osLocale,ea=t.resolvedLanguage||kn,Fp=t.languagePack?.translationsConfigFile}catch{}Up=!0}else typeof navigator=="object"&&!Tv?(Gr=navigator.userAgent,_o=Gr.indexOf("Windows")>=0,ko=Gr.indexOf("Macintosh")>=0,Mp=(Gr.indexOf("Macintosh")>=0||Gr.indexOf("iPad")>=0||Gr.indexOf("iPhone")>=0)&&!!navigator.maxTouchPoints&&navigator.maxTouchPoints>0,Co=Gr.indexOf("Linux")>=0,Pv=Gr?.indexOf("Mobi")>=0,Gc=!0,ea=Wc()||kn,Zs=navigator.language.toLowerCase(),Lp=Zs):console.error("Unable to resolve platform.");function Np(i){switch(i){case 0:return"Web";case 1:return"Mac";case 2:return"Linux";case 3:return"Windows"}}var ta=0;ko?ta=1:_o?ta=3:Co&&(ta=2);var pe=_o,ft=ko,Te=Co,Vp=Ap,Wp=Up;var Je=Gc,Rv=Gc&&typeof qr.importScripts=="function",Bp=Rv?qr.origin:void 0;var Dn=ta,Tr=Gr,er=ea,Cv;(r=>{function i(){return er}r.value=i;function t(){return er.length===2?er==="en":er.length>=3?er[0]==="e"&&er[1]==="n"&&er[2]==="-":!1}r.isDefaultVariant=t;function e(){return er==="en"}r.isDefault=e})(Cv||={});var qc=Fp,_v=typeof qr.postMessage=="function"&&!qr.importScripts,Gp=(()=>{if(_v){let i=[];qr.addEventListener("message",e=>{if(e.data&&e.data.vscodeScheduleAsyncWork)for(let r=0,n=i.length;r<n;r++){let o=i[r];if(o.id===e.data.vscodeScheduleAsyncWork){i.splice(r,1),o.callback();return}}});let t=0;return e=>{let r=++t;i.push({id:r,callback:e}),qr.postMessage({vscodeScheduleAsyncWork:r},"*")}}return i=>setTimeout(i)})();var Do=ko||Mp?2:_o?1:3;var Kc=!!(Tr&&Tr.indexOf("Chrome")>=0),qp=!!(Tr&&Tr.indexOf("Firefox")>=0),Kp=!!(!Kc&&Tr&&Tr.indexOf("Safari")>=0),zp=!!(Tr&&Tr.indexOf("Edg/")>=0),oS=!!(Tr&&Tr.indexOf("Android")>=0);var Ln,zc=globalThis.vscode;if(typeof zc<"u"&&typeof zc.process<"u"){let i=zc.process;Ln={get platform(){return i.platform},get arch(){return i.arch},get env(){return i.env},cwd(){return i.cwd()}}}else typeof process<"u"&&typeof process?.versions?.node=="string"?Ln={get platform(){return process.platform},get arch(){return process.arch},get env(){return process.env},cwd(){return process.env.VSCODE_CWD||process.cwd()}}:Ln={get platform(){return pe?"win32":ft?"darwin":"linux"},get arch(){},get env(){return{}},cwd(){return"/"}};var ln=Ln.cwd,Ot=Ln.env,ra=Ln.platform,na=Ln.arch;var kv=65,Dv=97,Lv=90,Av=122,An=46,rt=47,Nt=92,Kr=58,Uv=63,ia=class extends Error{constructor(t,e,r){let n;typeof e=="string"&&e.indexOf("not ")===0?(n="must not be",e=e.replace(/^not /,"")):n="must be";let o=t.indexOf(".")!==-1?"property":"argument",s=`The "${t}" ${o} ${n} of type ${e}`;s+=`. Received type ${typeof r}`,super(s),this.code="ERR_INVALID_ARG_TYPE"}};function Mv(i,t){if(i===null||typeof i!="object")throw new ia(t,"Object",i)}function We(i,t){if(typeof i!="string")throw new ia(t,"string",i)}var Vt=ra==="win32";function ne(i){return i===rt||i===Nt}function $c(i){return i===rt}function zr(i){return i>=kv&&i<=Lv||i>=Dv&&i<=Av}function oa(i,t,e,r){let n="",o=0,s=-1,a=0,l=0;for(let c=0;c<=i.length;++c){if(c<i.length)l=i.charCodeAt(c);else{if(r(l))break;l=rt}if(r(l)){if(!(s===c-1||a===1))if(a===2){if(n.length<2||o!==2||n.charCodeAt(n.length-1)!==An||n.charCodeAt(n.length-2)!==An){if(n.length>2){let u=n.lastIndexOf(e);u===-1?(n="",o=0):(n=n.slice(0,u),o=n.length-1-n.lastIndexOf(e)),s=c,a=0;continue}else if(n.length!==0){n="",o=0,s=c,a=0;continue}}t&&(n+=n.length>0?`${e}..`:"..",o=2)}else n.length>0?n+=`${e}${i.slice(s+1,c)}`:n=i.slice(s+1,c),o=c-s-1;s=c,a=0}else l===An&&a!==-1?++a:a=-1}return n}function Fv(i){return i?`${i[0]==="."?"":"."}${i}`:""}function jp(i,t){Mv(t,"pathObject");let e=t.dir||t.root,r=t.base||`${t.name||""}${Fv(t.ext)}`;return e?e===t.root?`${e}${r}`:`${e}${i}${r}`:r}var Be={resolve(...i){let t="",e="",r=!1;for(let n=i.length-1;n>=-1;n--){let o;if(n>=0){if(o=i[n],We(o,`paths[${n}]`),o.length===0)continue}else t.length===0?o=ln():(o=Ot[`=${t}`]||ln(),(o===void 0||o.slice(0,2).toLowerCase()!==t.toLowerCase()&&o.charCodeAt(2)===Nt)&&(o=`${t}\\`));let s=o.length,a=0,l="",c=!1,u=o.charCodeAt(0);if(s===1)ne(u)&&(a=1,c=!0);else if(ne(u))if(c=!0,ne(o.charCodeAt(1))){let p=2,f=p;for(;p<s&&!ne(o.charCodeAt(p));)p++;if(p<s&&p!==f){let g=o.slice(f,p);for(f=p;p<s&&ne(o.charCodeAt(p));)p++;if(p<s&&p!==f){for(f=p;p<s&&!ne(o.charCodeAt(p));)p++;(p===s||p!==f)&&(l=`\\\\${g}\\${o.slice(f,p)}`,a=p)}}}else a=1;else zr(u)&&o.charCodeAt(1)===Kr&&(l=o.slice(0,2),a=2,s>2&&ne(o.charCodeAt(2))&&(c=!0,a=3));if(l.length>0)if(t.length>0){if(l.toLowerCase()!==t.toLowerCase())continue}else t=l;if(r){if(t.length>0)break}else if(e=`${o.slice(a)}\\${e}`,r=c,c&&t.length>0)break}return e=oa(e,!r,"\\",ne),r?`${t}\\${e}`:`${t}${e}`||"."},normalize(i){We(i,"path");let t=i.length;if(t===0)return".";let e=0,r,n=!1,o=i.charCodeAt(0);if(t===1)return $c(o)?"\\":i;if(ne(o))if(n=!0,ne(i.charCodeAt(1))){let a=2,l=a;for(;a<t&&!ne(i.charCodeAt(a));)a++;if(a<t&&a!==l){let c=i.slice(l,a);for(l=a;a<t&&ne(i.charCodeAt(a));)a++;if(a<t&&a!==l){for(l=a;a<t&&!ne(i.charCodeAt(a));)a++;if(a===t)return`\\\\${c}\\${i.slice(l)}\\`;a!==l&&(r=`\\\\${c}\\${i.slice(l,a)}`,e=a)}}}else e=1;else zr(o)&&i.charCodeAt(1)===Kr&&(r=i.slice(0,2),e=2,t>2&&ne(i.charCodeAt(2))&&(n=!0,e=3));let s=e<t?oa(i.slice(e),!n,"\\",ne):"";if(s.length===0&&!n&&(s="."),s.length>0&&ne(i.charCodeAt(t-1))&&(s+="\\"),!n&&r===void 0&&i.includes(":")){if(s.length>=2&&zr(s.charCodeAt(0))&&s.charCodeAt(1)===Kr)return`.\\${s}`;let a=i.indexOf(":");do if(a===t-1||ne(i.charCodeAt(a+1)))return`.\\${s}`;while((a=i.indexOf(":",a+1))!==-1)}return r===void 0?n?`\\${s}`:s:n?`${r}\\${s}`:`${r}${s}`},isAbsolute(i){We(i,"path");let t=i.length;if(t===0)return!1;let e=i.charCodeAt(0);return ne(e)||t>2&&zr(e)&&i.charCodeAt(1)===Kr&&ne(i.charCodeAt(2))},join(...i){if(i.length===0)return".";let t,e;for(let o=0;o<i.length;++o){let s=i[o];We(s,"path"),s.length>0&&(t===void 0?t=e=s:t+=`\\${s}`)}if(t===void 0)return".";let r=!0,n=0;if(typeof e=="string"&&ne(e.charCodeAt(0))){++n;let o=e.length;o>1&&ne(e.charCodeAt(1))&&(++n,o>2&&(ne(e.charCodeAt(2))?++n:r=!1))}if(r){for(;n<t.length&&ne(t.charCodeAt(n));)n++;n>=2&&(t=`\\${t.slice(n)}`)}return Be.normalize(t)},relative(i,t){if(We(i,"from"),We(t,"to"),i===t)return"";let e=Be.resolve(i),r=Be.resolve(t);if(e===r||(i=e.toLowerCase(),t=r.toLowerCase(),i===t))return"";if(e.length!==i.length||r.length!==t.length){let v=e.split("\\"),h=r.split("\\");v[v.length-1]===""&&v.pop(),h[h.length-1]===""&&h.pop();let y=v.length,E=h.length,b=y<E?y:E,C;for(C=0;C<b&&v[C].toLowerCase()===h[C].toLowerCase();C++);return C===0?r:C===b?E>b?h.slice(C).join("\\"):y>b?"..\\".repeat(y-1-C)+"..":"":"..\\".repeat(y-C)+h.slice(C).join("\\")}let n=0;for(;n<i.length&&i.charCodeAt(n)===Nt;)n++;let o=i.length;for(;o-1>n&&i.charCodeAt(o-1)===Nt;)o--;let s=o-n,a=0;for(;a<t.length&&t.charCodeAt(a)===Nt;)a++;let l=t.length;for(;l-1>a&&t.charCodeAt(l-1)===Nt;)l--;let c=l-a,u=s<c?s:c,p=-1,f=0;for(;f<u;f++){let v=i.charCodeAt(n+f);if(v!==t.charCodeAt(a+f))break;v===Nt&&(p=f)}if(f!==u){if(p===-1)return r}else{if(c>u){if(t.charCodeAt(a+f)===Nt)return r.slice(a+f+1);if(f===2)return r.slice(a+f)}s>u&&(i.charCodeAt(n+f)===Nt?p=f:f===2&&(p=3)),p===-1&&(p=0)}let g="";for(f=n+p+1;f<=o;++f)(f===o||i.charCodeAt(f)===Nt)&&(g+=g.length===0?"..":"\\..");return a+=p,g.length>0?`${g}${r.slice(a,l)}`:(r.charCodeAt(a)===Nt&&++a,r.slice(a,l))},toNamespacedPath(i){if(typeof i!="string"||i.length===0)return i;let t=Be.resolve(i);if(t.length<=2)return i;if(t.charCodeAt(0)===Nt){if(t.charCodeAt(1)===Nt){let e=t.charCodeAt(2);if(e!==Uv&&e!==An)return`\\\\?\\UNC\\${t.slice(2)}`}}else if(zr(t.charCodeAt(0))&&t.charCodeAt(1)===Kr&&t.charCodeAt(2)===Nt)return`\\\\?\\${t}`;return t},dirname(i){We(i,"path");let t=i.length;if(t===0)return".";let e=-1,r=0,n=i.charCodeAt(0);if(t===1)return ne(n)?i:".";if(ne(n)){if(e=r=1,ne(i.charCodeAt(1))){let a=2,l=a;for(;a<t&&!ne(i.charCodeAt(a));)a++;if(a<t&&a!==l){for(l=a;a<t&&ne(i.charCodeAt(a));)a++;if(a<t&&a!==l){for(l=a;a<t&&!ne(i.charCodeAt(a));)a++;if(a===t)return i;a!==l&&(e=r=a+1)}}}}else zr(n)&&i.charCodeAt(1)===Kr&&(e=t>2&&ne(i.charCodeAt(2))?3:2,r=e);let o=-1,s=!0;for(let a=t-1;a>=r;--a)if(ne(i.charCodeAt(a))){if(!s){o=a;break}}else s=!1;if(o===-1){if(e===-1)return".";o=e}return i.slice(0,o)},basename(i,t){t!==void 0&&We(t,"suffix"),We(i,"path");let e=0,r=-1,n=!0,o;if(i.length>=2&&zr(i.charCodeAt(0))&&i.charCodeAt(1)===Kr&&(e=2),t!==void 0&&t.length>0&&t.length<=i.length){if(t===i)return"";let s=t.length-1,a=-1;for(o=i.length-1;o>=e;--o){let l=i.charCodeAt(o);if(ne(l)){if(!n){e=o+1;break}}else a===-1&&(n=!1,a=o+1),s>=0&&(l===t.charCodeAt(s)?--s===-1&&(r=o):(s=-1,r=a))}return e===r?r=a:r===-1&&(r=i.length),i.slice(e,r)}for(o=i.length-1;o>=e;--o)if(ne(i.charCodeAt(o))){if(!n){e=o+1;break}}else r===-1&&(n=!1,r=o+1);return r===-1?"":i.slice(e,r)},extname(i){We(i,"path");let t=0,e=-1,r=0,n=-1,o=!0,s=0;i.length>=2&&i.charCodeAt(1)===Kr&&zr(i.charCodeAt(0))&&(t=r=2);for(let a=i.length-1;a>=t;--a){let l=i.charCodeAt(a);if(ne(l)){if(!o){r=a+1;break}continue}n===-1&&(o=!1,n=a+1),l===An?e===-1?e=a:s!==1&&(s=1):e!==-1&&(s=-1)}return e===-1||n===-1||s===0||s===1&&e===n-1&&e===r+1?"":i.slice(e,n)},format:jp.bind(null,"\\"),parse(i){We(i,"path");let t={root:"",dir:"",base:"",ext:"",name:""};if(i.length===0)return t;let e=i.length,r=0,n=i.charCodeAt(0);if(e===1)return ne(n)?(t.root=t.dir=i,t):(t.base=t.name=i,t);if(ne(n)){if(r=1,ne(i.charCodeAt(1))){let p=2,f=p;for(;p<e&&!ne(i.charCodeAt(p));)p++;if(p<e&&p!==f){for(f=p;p<e&&ne(i.charCodeAt(p));)p++;if(p<e&&p!==f){for(f=p;p<e&&!ne(i.charCodeAt(p));)p++;p===e?r=p:p!==f&&(r=p+1)}}}}else if(zr(n)&&i.charCodeAt(1)===Kr){if(e<=2)return t.root=t.dir=i,t;if(r=2,ne(i.charCodeAt(2))){if(e===3)return t.root=t.dir=i,t;r=3}}r>0&&(t.root=i.slice(0,r));let o=-1,s=r,a=-1,l=!0,c=i.length-1,u=0;for(;c>=r;--c){if(n=i.charCodeAt(c),ne(n)){if(!l){s=c+1;break}continue}a===-1&&(l=!1,a=c+1),n===An?o===-1?o=c:u!==1&&(u=1):o!==-1&&(u=-1)}return a!==-1&&(o===-1||u===0||u===1&&o===a-1&&o===s+1?t.base=t.name=i.slice(s,a):(t.name=i.slice(s,o),t.base=i.slice(s,a),t.ext=i.slice(o,a))),s>0&&s!==r?t.dir=i.slice(0,s-1):t.dir=t.root,t},sep:"\\",delimiter:";",win32:null,posix:null},Ov=(()=>{if(Vt){let i=/\\/g;return()=>{let t=ln().replace(i,"/");return t.slice(t.indexOf("/"))}}return()=>ln()})(),ce={resolve(...i){let t="",e=!1;for(let r=i.length-1;r>=0&&!e;r--){let n=i[r];We(n,`paths[${r}]`),n.length!==0&&(t=`${n}/${t}`,e=n.charCodeAt(0)===rt)}if(!e){let r=Ov();t=`${r}/${t}`,e=r.charCodeAt(0)===rt}return t=oa(t,!e,"/",$c),e?`/${t}`:t.length>0?t:"."},normalize(i){if(We(i,"path"),i.length===0)return".";let t=i.charCodeAt(0)===rt,e=i.charCodeAt(i.length-1)===rt;return i=oa(i,!t,"/",$c),i.length===0?t?"/":e?"./":".":(e&&(i+="/"),t?`/${i}`:i)},isAbsolute(i){return We(i,"path"),i.length>0&&i.charCodeAt(0)===rt},join(...i){if(i.length===0)return".";let t=[];for(let e=0;e<i.length;++e){let r=i[e];We(r,"path"),r.length>0&&t.push(r)}return t.length===0?".":ce.normalize(t.join("/"))},relative(i,t){if(We(i,"from"),We(t,"to"),i===t||(i=ce.resolve(i),t=ce.resolve(t),i===t))return"";let e=1,r=i.length,n=r-e,o=1,s=t.length-o,a=n<s?n:s,l=-1,c=0;for(;c<a;c++){let p=i.charCodeAt(e+c);if(p!==t.charCodeAt(o+c))break;p===rt&&(l=c)}if(c===a)if(s>a){if(t.charCodeAt(o+c)===rt)return t.slice(o+c+1);if(c===0)return t.slice(o+c)}else n>a&&(i.charCodeAt(e+c)===rt?l=c:c===0&&(l=0));let u="";for(c=e+l+1;c<=r;++c)(c===r||i.charCodeAt(c)===rt)&&(u+=u.length===0?"..":"/..");return`${u}${t.slice(o+l)}`},toNamespacedPath(i){return i},dirname(i){if(We(i,"path"),i.length===0)return".";let t=i.charCodeAt(0)===rt,e=-1,r=!0;for(let n=i.length-1;n>=1;--n)if(i.charCodeAt(n)===rt){if(!r){e=n;break}}else r=!1;return e===-1?t?"/":".":t&&e===1?"//":i.slice(0,e)},basename(i,t){t!==void 0&&We(t,"suffix"),We(i,"path");let e=0,r=-1,n=!0,o;if(t!==void 0&&t.length>0&&t.length<=i.length){if(t===i)return"";let s=t.length-1,a=-1;for(o=i.length-1;o>=0;--o){let l=i.charCodeAt(o);if(l===rt){if(!n){e=o+1;break}}else a===-1&&(n=!1,a=o+1),s>=0&&(l===t.charCodeAt(s)?--s===-1&&(r=o):(s=-1,r=a))}return e===r?r=a:r===-1&&(r=i.length),i.slice(e,r)}for(o=i.length-1;o>=0;--o)if(i.charCodeAt(o)===rt){if(!n){e=o+1;break}}else r===-1&&(n=!1,r=o+1);return r===-1?"":i.slice(e,r)},extname(i){We(i,"path");let t=-1,e=0,r=-1,n=!0,o=0;for(let s=i.length-1;s>=0;--s){let a=i[s];if(a==="/"){if(!n){e=s+1;break}continue}r===-1&&(n=!1,r=s+1),a==="."?t===-1?t=s:o!==1&&(o=1):t!==-1&&(o=-1)}return t===-1||r===-1||o===0||o===1&&t===r-1&&t===e+1?"":i.slice(t,r)},format:jp.bind(null,"/"),parse(i){We(i,"path");let t={root:"",dir:"",base:"",ext:"",name:""};if(i.length===0)return t;let e=i.charCodeAt(0)===rt,r;e?(t.root="/",r=1):r=0;let n=-1,o=0,s=-1,a=!0,l=i.length-1,c=0;for(;l>=r;--l){let u=i.charCodeAt(l);if(u===rt){if(!a){o=l+1;break}continue}s===-1&&(a=!1,s=l+1),u===An?n===-1?n=l:c!==1&&(c=1):n!==-1&&(c=-1)}if(s!==-1){let u=o===0&&e?1:o;n===-1||c===0||c===1&&n===s-1&&n===o+1?t.base=t.name=i.slice(u,s):(t.name=i.slice(u,n),t.base=i.slice(u,s),t.ext=i.slice(n,s))}return o>0?t.dir=i.slice(0,o-1):e&&(t.dir="/"),t},sep:"/",delimiter:":",win32:null,posix:null};ce.win32=Be.win32=Be;ce.posix=Be.posix=ce;var Wt=Vt?Be.normalize:ce.normalize,pi=Vt?Be.isAbsolute:ce.isAbsolute,q=Vt?Be.join:ce.join,Rr=Vt?Be.resolve:ce.resolve,sa=Vt?Be.relative:ce.relative,Rt=Vt?Be.dirname:ce.dirname,nt=Vt?Be.basename:ce.basename,jc=Vt?Be.extname:ce.extname,lS=Vt?Be.format:ce.format,cS=Vt?Be.parse:ce.parse,uS=Vt?Be.toNamespacedPath:ce.toNamespacedPath,je=Vt?Be.sep:ce.sep,Nv=Vt?Be.delimiter:ce.delimiter;function Vv(i){return i}var aa=class{constructor(t,e){this.lastCache=void 0;this.lastArgKey=void 0;typeof t=="function"?(this._fn=t,this._computeKey=Vv):(this._fn=e,this._computeKey=t.getCacheKey)}get(t){let e=this._computeKey(t);return this.lastArgKey!==e&&(this.lastArgKey=e,this.lastCache=this._fn(t)),this.lastCache}};var Ct=class{constructor(t){this.executor=t;this._state=0}get hasValue(){return this._state===2}get value(){if(this._state===0){this._state=1;try{this._value=this.executor()}catch(t){this._error=t}finally{this._state=2}}else if(this._state===1)throw new Error("Cannot read the value of a lazy that is being initialized");if(this._error)throw this._error;return this._value}get rawValue(){return this._value}};function Yp(i){return!i||typeof i!="string"?!0:i.trim().length===0}var Wv=/{([^}]+)}/g;function $t(i,t){return Object.keys(t).length===0?i:i.replace(Wv,(e,r)=>t[r]??e)}function Cr(i){return i.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g,"\\$&")}function Hc(i,t){if(!i||!t)return i;let e=t.length,r=0;if(e===1){let n=t.charCodeAt(0);for(;r<i.length&&i.charCodeAt(r)===n;)r++}else for(;i.startsWith(t,r);)r+=e;return i.substring(r)}function Ao(i,t){if(!i||!t)return i;let e=t.length,r=i.length;if(e===1){let o=r,s=t.charCodeAt(0);for(;o>0&&i.charCodeAt(o-1)===s;)o--;return i.substring(0,o)}let n=r;for(;n>0&&i.endsWith(t,n);)n-=e;return i.substring(0,n)}function Uo(i,t){return i<t?-1:i>t?1:0}function la(i,t,e=0,r=i.length,n=0,o=t.length){for(;e<r&&n<o;e++,n++){let l=i.charCodeAt(e),c=t.charCodeAt(n);if(l<c)return-1;if(l>c)return 1}let s=r-e,a=o-n;return s<a?-1:s>a?1:0}function fi(i,t){return Un(i,t,0,i.length,0,t.length)}function Un(i,t,e=0,r=i.length,n=0,o=t.length){for(;e<r&&n<o;e++,n++){let l=i.charCodeAt(e),c=t.charCodeAt(n);if(l===c)continue;if(l>=128||c>=128)return la(i.toLowerCase(),t.toLowerCase(),e,r,n,o);Hp(l)&&(l-=32),Hp(c)&&(c-=32);let u=l-c;if(u!==0)return u}let s=r-e,a=o-n;return s<a?-1:s>a?1:0}function Hp(i){return i>=97&&i<=122}function Qc(i){return i>=65&&i<=90}function Bt(i,t){return i.length===t.length&&Un(i,t)===0}function Mn(i,t){let e=t.length;return e<=i.length&&Un(i,t,0,e)===0}function Zp(i,t){let e=i.length,r=e-t.length;return r>=0&&Un(i,t,r,e)===0}function ef(i){return 55296<=i&&i<=56319}function Jc(i){return 56320<=i&&i<=57343}function tf(i,t){return(i-55296<<10)+(t-56320)+65536}var Bv=/(?:\x1b\[|\x9b)[=?>!]?[\d;:]*["$#'* ]?[a-zA-Z@^`{}|~]/,Gv=/(?:\x1b\]|\x9d).*?(?:\x1b\\|\x07|\x9c)/,qv=/\x1b(?:[ #%\(\)\*\+\-\.\/]?[a-zA-Z0-9\|}~@])/,bS=new RegExp("(?:"+[Bv.source,Gv.source,qv.source].join("|")+")","g");var SS=String.fromCharCode(65279);function Xc(i){return i.charAt(0).toUpperCase()+i.slice(1)}var Qp=class i{static{this._INSTANCE=null}static getInstance(){return i._INSTANCE||(i._INSTANCE=new i),i._INSTANCE}constructor(){this._data=Kv()}getGraphemeBreakType(t){if(t<32)return t===10?3:t===13?2:4;if(t<127)return 0;let e=this._data,r=e.length/3,n=1;for(;n<=r;)if(t<e[3*n])n=2*n;else if(t>e[3*n+1])n=2*n+1;else return e[3*n+2];return 0}};function Kv(){return JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]")}var Jp=class i{constructor(t){this.confusableDictionary=t}static{this.ambiguousCharacterData=new Ct(()=>JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,1523,96,8242,96,1370,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,118002,50,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,118003,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,118004,52,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,118005,53,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,118006,54,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,118007,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,118008,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,118009,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,117974,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,117975,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71913,67,71922,67,65315,67,8557,67,8450,67,8493,67,117976,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,117977,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,117978,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,117979,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,117980,71,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,117981,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,117983,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,117984,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,118001,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,117982,108,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,117985,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,117986,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,117987,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,118000,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,117988,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,117989,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,117990,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,117991,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,117992,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,117993,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,117994,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,117995,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71910,87,71919,87,117996,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,117997,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,117998,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,71909,90,66293,90,65338,90,8484,90,8488,90,117999,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65283,35,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"cs":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"es":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"fr":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"it":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ja":[8211,45,8218,44,65281,33,8216,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65292,44,65297,49,65307,59],"ko":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pt-BR":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ru":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"zh-hans":[160,32,65374,126,8218,44,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65297,49],"zh-hant":[8211,45,65374,126,8218,44,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89]}'))}static{this.cache=new aa(t=>{let e=t.split(",");function r(p){let f=new Map;for(let g=0;g<p.length;g+=2)f.set(p[g],p[g+1]);return f}function n(p,f){let g=new Map(p);for(let[v,h]of f)g.set(v,h);return g}function o(p,f){if(!p)return f;let g=new Map;for(let[v,h]of p)f.has(v)&&g.set(v,h);return g}let s=this.ambiguousCharacterData.value,a=e.filter(p=>!p.startsWith("_")&&Object.hasOwn(s,p));a.length===0&&(a=["_default"]);let l;for(let p of a){let f=r(s[p]);l=o(l,f)}let c=r(s._common),u=n(c,l);return new i(u)})}static getInstance(t){return i.cache.get(Array.from(t).join(","))}static{this._locales=new Ct(()=>Object.keys(i.ambiguousCharacterData.value).filter(t=>!t.startsWith("_")))}static getLocales(){return i._locales.value}isAmbiguous(t){return this.confusableDictionary.has(t)}containsAmbiguousCharacter(t){for(let e=0;e<t.length;e++){let r=t.codePointAt(e);if(typeof r=="number"&&this.isAmbiguous(r))return!0}return!1}getPrimaryConfusable(t){return this.confusableDictionary.get(t)}getConfusableCodePoints(){return new Set(this.confusableDictionary.keys())}},Xp=class i{static getRawData(){return JSON.parse('{"_common":[11,12,13,127,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999],"cs":[173,8203,12288],"de":[173,8203,12288],"es":[8203,12288],"fr":[173,8203,12288],"it":[160,173,12288],"ja":[173],"ko":[173,12288],"pl":[173,8203,12288],"pt-BR":[173,8203,12288],"qps-ploc":[160,173,8203,12288],"ru":[173,12288],"tr":[160,173,8203,12288],"zh-hans":[160,173,8203,12288],"zh-hant":[173,12288]}')}static{this._data=void 0}static getData(){return this._data||(this._data=new Set([...Object.values(i.getRawData())].flat())),this._data}static isInvisibleCharacter(t){return i.getData().has(t)}static containsInvisibleCharacter(t){for(let e=0;e<t.length;e++){let r=t.codePointAt(e);if(typeof r=="number"&&(i.isInvisibleCharacter(r)||r===32))return!0}return!1}static get codePoints(){return i.getData()}};function dn(i){return i===47||i===92}function Yc(i){return i.replace(/[\\/]/g,ce.sep)}function rf(i){return i.indexOf("/")===-1&&(i=Yc(i)),/^[a-zA-Z]:(\/|$)/.test(i)&&(i="/"+i),i}function Zc(i,t=ce.sep){if(!i)return"";let e=i.length,r=i.charCodeAt(0);if(dn(r)){if(dn(i.charCodeAt(1))&&!dn(i.charCodeAt(2))){let o=3,s=o;for(;o<e&&!dn(i.charCodeAt(o));o++);if(s!==o&&!dn(i.charCodeAt(o+1))){for(o+=1;o<e;o++)if(dn(i.charCodeAt(o)))return i.slice(0,o+1).replace(/[\\/]/g,t)}}return t}else if(nf(r)&&i.charCodeAt(1)===58)return dn(i.charCodeAt(2))?i.slice(0,2)+t:i.slice(0,2);let n=i.indexOf("://");if(n!==-1){for(n+=3;n<e;n++)if(dn(i.charCodeAt(n)))return i.slice(0,n+1)}return""}function mi(i,t,e){let r=i===t;return!e||r?r:!i||!t?!1:Bt(i,t)}function $r(i,t,e,r=je){if(i===t)return!0;if(!i||!t||t.length>i.length)return!1;if(e){if(!Mn(i,t))return!1;if(t.length===i.length)return!0;let o=t.length;return t.charAt(t.length-1)===r&&o--,i.charAt(o)===r}return t.charAt(t.length-1)!==r&&(t+=r),i.indexOf(t)===0}function nf(i){return i>=65&&i<=90||i>=97&&i<=122}function of(i){return pe?(i=Ao(i,je),i.endsWith(":")&&(i+=je)):(i=Ao(i,je),i||(i=je)),i}function eu(i){let t=Wt(i);return pe?i.length>3?!1:zv(t)&&(i.length===2||t.charCodeAt(2)===92):t===ce.sep}function zv(i,t=pe){return t?nf(i.charCodeAt(0))&&i.charCodeAt(1)===58:!1}var $v="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",jv="BDEFGHIJKMOQRSTUVWXYZbdefghijkmoqrstuvwxyz0123456789";function sf(i,t,e=8){let r="";for(let o=0;o<e;o++){let s;o===0&&pe&&!t&&(e===3||e===4)?s=jv:s=$v,r+=s.charAt(Math.floor(Math.random()*s.length))}let n;return t?n=`${t}-${r}`:n=r,i?q(i,n):n}var Jv=/^\w[\w\d+.-]*$/,Xv=/^\//,Yv=/^\/\//;function Zv(i,t){if(!i.scheme&&t)throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${i.authority}", path: "${i.path}", query: "${i.query}", fragment: "${i.fragment}"}`);if(i.scheme&&!Jv.test(i.scheme)){let e=[...i.scheme.matchAll(/[^\w\d+.-]/gu)],r=e.length>0?` Found '${e[0][0]}' at index ${e[0].index} (${e.length} total)`:"";throw new Error(`[UriError]: Scheme contains illegal characters.${r} (len:${i.scheme.length})`)}if(i.path){if(i.authority){if(!Xv.test(i.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(Yv.test(i.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}}function ey(i,t){return!i&&!t?"file":i}function ty(i,t){switch(i){case"https":case"http":case"file":t?t[0]!==sr&&(t=sr+t):t=sr;break}return t}var _e="",sr="/",ry=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/,P=class i{static isUri(t){return t instanceof i?!0:!t||typeof t!="object"?!1:typeof t.authority=="string"&&typeof t.fragment=="string"&&typeof t.path=="string"&&typeof t.query=="string"&&typeof t.scheme=="string"&&typeof t.fsPath=="string"&&typeof t.with=="function"&&typeof t.toString=="function"}constructor(t,e,r,n,o,s=!1){typeof t=="object"?(this.scheme=t.scheme||_e,this.authority=t.authority||_e,this.path=t.path||_e,this.query=t.query||_e,this.fragment=t.fragment||_e):(this.scheme=ey(t,s),this.authority=e||_e,this.path=ty(this.scheme,r||_e),this.query=n||_e,this.fragment=o||_e,Zv(this,s))}get fsPath(){return Fo(this,!1)}with(t){if(!t)return this;let{scheme:e,authority:r,path:n,query:o,fragment:s}=t;return e===void 0?e=this.scheme:e===null&&(e=_e),r===void 0?r=this.authority:r===null&&(r=_e),n===void 0?n=this.path:n===null&&(n=_e),o===void 0?o=this.query:o===null&&(o=_e),s===void 0?s=this.fragment:s===null&&(s=_e),e===this.scheme&&r===this.authority&&n===this.path&&o===this.query&&s===this.fragment?this:new pn(e,r,n,o,s)}static parse(t,e=!1){let r=ry.exec(t);return r?new pn(r[2]||_e,ca(r[4]||_e),ca(r[5]||_e),ca(r[7]||_e),ca(r[9]||_e),e):new pn(_e,_e,_e,_e,_e)}static file(t){let e=_e;if(pe&&(t=t.replace(/\\/g,sr)),t[0]===sr&&t[1]===sr){let r=t.indexOf(sr,2);r===-1?(e=t.substring(2),t=sr):(e=t.substring(2,r),t=t.substring(r)||sr)}return new pn("file",e,t,_e,_e)}static from(t,e){return new pn(t.scheme,t.authority,t.path,t.query,t.fragment,e)}static joinPath(t,...e){if(!t.path)throw new Error("[UriError]: cannot call joinPath on URI without path");let r;return pe&&t.scheme==="file"?r=i.file(Be.join(Fo(t,!0),...e)).path:r=ce.join(t.path,...e),t.with({path:r})}toString(t=!1){return tu(this,t)}toJSON(){return this}static revive(t){if(t){if(t instanceof i)return t;{let e=new pn(t);return e._formatted=t.external??null,e._fsPath=t._sep===cf?t.fsPath??null:null,e}}else return t}[Symbol.for("debug.description")](){return`URI(${this.toString()})`}};var cf=pe?1:void 0,pn=class extends P{constructor(){super(...arguments);this._formatted=null;this._fsPath=null}get fsPath(){return this._fsPath||(this._fsPath=Fo(this,!1)),this._fsPath}toString(e=!1){return e?tu(this,!0):(this._formatted||(this._formatted=tu(this,!1)),this._formatted)}toJSON(){let e={$mid:1};return this._fsPath&&(e.fsPath=this._fsPath,e._sep=cf),this._formatted&&(e.external=this._formatted),this.path&&(e.path=this.path),this.scheme&&(e.scheme=this.scheme),this.authority&&(e.authority=this.authority),this.query&&(e.query=this.query),this.fragment&&(e.fragment=this.fragment),e}},uf={58:"%3A",47:"%2F",63:"%3F",35:"%23",91:"%5B",93:"%5D",64:"%40",33:"%21",36:"%24",38:"%26",39:"%27",40:"%28",41:"%29",42:"%2A",43:"%2B",44:"%2C",59:"%3B",61:"%3D",32:"%20"};function af(i,t,e){let r,n=-1;for(let o=0;o<i.length;o++){let s=i.charCodeAt(o);if(s>=97&&s<=122||s>=65&&s<=90||s>=48&&s<=57||s===45||s===46||s===95||s===126||t&&s===47||e&&s===91||e&&s===93||e&&s===58)n!==-1&&(r+=encodeURIComponent(i.substring(n,o)),n=-1),r!==void 0&&(r+=i.charAt(o));else{r===void 0&&(r=i.substr(0,o));let a=uf[s];a!==void 0?(n!==-1&&(r+=encodeURIComponent(i.substring(n,o)),n=-1),r+=a):n===-1&&(n=o)}}return n!==-1&&(r+=encodeURIComponent(i.substring(n))),r!==void 0?r:i}function ny(i){let t;for(let e=0;e<i.length;e++){let r=i.charCodeAt(e);r===35||r===63?(t===void 0&&(t=i.substr(0,e)),t+=uf[r]):t!==void 0&&(t+=i[e])}return t!==void 0?t:i}function Fo(i,t){let e;return i.authority&&i.path.length>1&&i.scheme==="file"?e=`//${i.authority}${i.path}`:i.path.charCodeAt(0)===47&&(i.path.charCodeAt(1)>=65&&i.path.charCodeAt(1)<=90||i.path.charCodeAt(1)>=97&&i.path.charCodeAt(1)<=122)&&i.path.charCodeAt(2)===58?t?e=i.path.substr(1):e=i.path[1].toLowerCase()+i.path.substr(2):e=i.path,pe&&(e=e.replace(/\//g,"\\")),e}function tu(i,t){let e=t?ny:af,r="",{scheme:n,authority:o,path:s,query:a,fragment:l}=i;if(n&&(r+=n,r+=":"),(o||n==="file")&&(r+=sr,r+=sr),o){let c=o.indexOf("@");if(c!==-1){let u=o.substr(0,c);o=o.substr(c+1),c=u.lastIndexOf(":"),c===-1?r+=e(u,!1,!1):(r+=e(u.substr(0,c),!1,!1),r+=":",r+=e(u.substr(c+1),!1,!0)),r+="@"}o=o.toLowerCase(),c=o.lastIndexOf(":"),c===-1?r+=e(o,!1,!0):(r+=e(o.substr(0,c),!1,!0),r+=o.substr(c))}if(s){if(s.length>=3&&s.charCodeAt(0)===47&&s.charCodeAt(2)===58){let c=s.charCodeAt(1);c>=65&&c<=90&&(s=`/${String.fromCharCode(c+32)}:${s.substr(3)}`)}else if(s.length>=2&&s.charCodeAt(1)===58){let c=s.charCodeAt(0);c>=65&&c<=90&&(s=`${String.fromCharCode(c+32)}:${s.substr(2)}`)}r+=e(s,!0,!1)}return a&&(r+="?",r+=e(a,!1,!1)),l&&(r+="#",r+=t?l:af(l,!1,!1)),r}function df(i){try{return decodeURIComponent(i)}catch{return i.length>3?i.substr(0,3)+df(i.substr(3)):i}}var lf=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function ca(i){return i.match(lf)?i.replace(lf,t=>df(t)):i}var $;(K=>(K.inMemory="inmemory",K.vscode="vscode",K.internal="private",K.walkThrough="walkThrough",K.walkThroughSnippet="walkThroughSnippet",K.http="http",K.https="https",K.file="file",K.mailto="mailto",K.untitled="untitled",K.data="data",K.command="command",K.vscodeRemote="vscode-remote",K.vscodeRemoteResource="vscode-remote-resource",K.vscodeManagedRemoteResource="vscode-managed-remote-resource",K.vscodeUserData="vscode-userdata",K.vscodeCustomEditor="vscode-custom-editor",K.vscodeNotebookCell="vscode-notebook-cell",K.vscodeNotebookCellMetadata="vscode-notebook-cell-metadata",K.vscodeNotebookCellMetadataDiff="vscode-notebook-cell-metadata-diff",K.vscodeNotebookCellOutput="vscode-notebook-cell-output",K.vscodeNotebookCellOutputDiff="vscode-notebook-cell-output-diff",K.vscodeNotebookMetadata="vscode-notebook-metadata",K.vscodeInteractiveInput="vscode-interactive-input",K.vscodeSettings="vscode-settings",K.vscodeWorkspaceTrust="vscode-workspace-trust",K.vscodeTerminal="vscode-terminal",K.vscodeChatCodeBlock="vscode-chat-code-block",K.vscodeChatCodeCompareBlock="vscode-chat-code-compare-block",K.vscodeChatEditor="vscode-chat-editor",K.vscodeChatInput="chatSessionInput",K.vscodeLocalChatSession="vscode-chat-session",K.webviewPanel="webview-panel",K.vscodeWebview="vscode-webview",K.vscodeBrowser="vscode-browser",K.extension="extension",K.vscodeFileResource="vscode-file",K.tmp="tmp",K.vsls="vsls",K.vscodeSourceControl="vscode-scm",K.commentsInput="comment",K.codeSetting="code-setting",K.outputChannel="output",K.accessibleView="accessible-view",K.chatEditingSnapshotScheme="chat-editing-snapshot-text-model",K.chatEditingModel="chat-editing-text-model",K.copilotPr="copilot-pr"))($||={});var iy="tkn",ru=class{constructor(){this._hosts=Object.create(null);this._ports=Object.create(null);this._connectionTokens=Object.create(null);this._preferredWebSchema="http";this._delegate=null;this._serverRootPath="/"}setPreferredWebSchema(t){this._preferredWebSchema=t}setDelegate(t){this._delegate=t}setServerRootPath(t,e){this._serverRootPath=ce.join(e??"/",sy(t))}getServerRootPath(){return this._serverRootPath}get _remoteResourcesPath(){return ce.join(this._serverRootPath,$.vscodeRemoteResource)}set(t,e,r){this._hosts[t]=e,this._ports[t]=r}setConnectionToken(t,e){this._connectionTokens[t]=e}getPreferredWebSchema(){return this._preferredWebSchema}rewrite(t){if(this._delegate)try{return this._delegate(t)}catch(a){return Ke(a),t}let e=t.authority,r=this._hosts[e];r&&r.indexOf(":")!==-1&&r.indexOf("[")===-1&&(r=`[${r}]`);let n=this._ports[e],o=this._connectionTokens[e],s=`path=${encodeURIComponent(t.path)}`;return typeof o=="string"&&(s+=`&${iy}=${encodeURIComponent(o)}`),P.from({scheme:Je?this._preferredWebSchema:$.vscodeRemoteResource,authority:`${r}:${n}`,path:this._remoteResourcesPath,query:s})}},oy=new ru;function sy(i){return`${i.quality??"oss"}-${i.commit??"dev"}`}var pf="vs/../../node_modules",ff="vs/../../node_modules.asar";var iu="vscode-app",nu=class i{static{this.FALLBACK_AUTHORITY=iu}asBrowserUri(t){let e=this.toUri(t);return this.uriToBrowserUri(e)}uriToBrowserUri(t){return t.scheme===$.vscodeRemote?oy.rewrite(t):t.scheme===$.file&&(Wp||Bp===`${$.vscodeFileResource}://${i.FALLBACK_AUTHORITY}`)?t.with({scheme:$.vscodeFileResource,authority:t.authority||i.FALLBACK_AUTHORITY,query:null,fragment:null}):t}asFileUri(t){let e=this.toUri(t);return this.uriToFileUri(e)}uriToFileUri(t){return t.scheme===$.vscodeFileResource?t.with({scheme:$.file,authority:t.authority!==i.FALLBACK_AUTHORITY?t.authority:null,query:null,fragment:null}):t}toUri(t){if(P.isUri(t))return t;if(globalThis._VSCODE_FILE_ROOT){let e=globalThis._VSCODE_FILE_ROOT;if(/^\w[\w\d+.-]*:\/\//.test(e))return P.joinPath(P.parse(e,!0),t);let r=q(e,t);return P.file(r)}throw new Error("Cannot determine URI for module id!")}},_r=new nu,MS=Object.freeze({"Cache-Control":"no-cache, no-store"}),FS=Object.freeze({"Document-Policy":"include-js-call-stacks-in-crash-reports"}),ay;(o=>{let i=new Map([["1",{"Cross-Origin-Opener-Policy":"same-origin"}],["2",{"Cross-Origin-Embedder-Policy":"require-corp"}],["3",{"Cross-Origin-Opener-Policy":"same-origin","Cross-Origin-Embedder-Policy":"require-corp"}]]);o.CoopAndCoep=Object.freeze(i.get("3"));let e="vscode-coi";function r(s){let a;typeof s=="string"?a=new URL(s).searchParams:s instanceof URL?a=s.searchParams:P.isUri(s)&&(a=new URL(s.toString(!0)).searchParams);let l=a?.get(e);if(l)return i.get(l)}o.getHeadersFromQuery=r;function n(s,a,l){if(!globalThis.crossOriginIsolated)return;let c=a&&l?"3":l?"2":"1";s instanceof URLSearchParams?s.set(e,c):s[e]=c}o.addSearchParam=n})(ay||={});function jr(i){return Fo(i,!0)}var Fn=class{constructor(t){this._ignorePathCasing=t}compare(t,e,r=!1){return t===e?0:Uo(this.getComparisonKey(t,r),this.getComparisonKey(e,r))}isEqual(t,e,r=!1){return t===e?!0:!t||!e?!1:this.getComparisonKey(t,r)===this.getComparisonKey(e,r)}getComparisonKey(t,e=!1){return t.with({path:this._ignorePathCasing(t)?t.path.toLowerCase():void 0,fragment:e?null:void 0}).toString()}ignorePathCasing(t){return this._ignorePathCasing(t)}isEqualOrParent(t,e,r=!1){if(t.scheme===e.scheme){if(t.scheme===$.file)return $r(jr(t),jr(e),this._ignorePathCasing(t))&&t.query===e.query&&(r||t.fragment===e.fragment);if(mf(t.authority,e.authority))return $r(t.path,e.path,this._ignorePathCasing(t),"/")&&t.query===e.query&&(r||t.fragment===e.fragment)}return!1}joinPath(t,...e){return P.joinPath(t,...e)}basenameOrAuthority(t){return kr(t)||t.authority}basename(t){return ce.basename(t.path)}extname(t){return ce.extname(t.path)}dirname(t){if(t.path.length===0)return t;let e;return t.scheme===$.file?e=P.file(Rt(jr(t))).path:(e=ce.dirname(t.path),t.authority&&e.length&&e.charCodeAt(0)!==47&&(console.error(`dirname("${t.toString})) resulted in a relative path`),e="/")),t.with({path:e})}normalizePath(t){if(!t.path.length)return t;let e;return t.scheme===$.file?e=P.file(Wt(jr(t))).path:e=ce.normalize(t.path),t.with({path:e})}relativePath(t,e){if(t.scheme!==e.scheme||!mf(t.authority,e.authority))return;if(t.scheme===$.file){let o=sa(jr(t),jr(e));return pe?Yc(o):o}let r=t.path||"/",n=e.path||"/";if(this._ignorePathCasing(t)){let o=0;for(let s=Math.min(r.length,n.length);o<s&&!(r.charCodeAt(o)!==n.charCodeAt(o)&&r.charAt(o).toLowerCase()!==n.charAt(o).toLowerCase());o++);r=n.substr(0,o)+r.substr(o)}return ce.relative(r,n)}resolvePath(t,e){if(t.scheme===$.file){let r=P.file(Rr(jr(t),e));return t.with({authority:r.authority,path:r.path})}return e=rf(e),t.with({path:ce.resolve(t.path,e)})}isAbsolutePath(t){return!!t.path&&t.path[0]==="/"}isEqualAuthority(t,e){return t===e||t!==void 0&&e!==void 0&&Bt(t,e)}hasTrailingPathSeparator(t,e=je){if(t.scheme===$.file){let r=jr(t);return r.length>Zc(r).length&&r[r.length-1]===e}else{let r=t.path;return r.length>1&&r.charCodeAt(r.length-1)===47&&!/^[a-zA-Z]:(\/$|\\$)/.test(t.fsPath)}}removeTrailingPathSeparator(t,e=je){return gf(t,e)?t.with({path:t.path.substr(0,t.path.length-1)}):t}addTrailingPathSeparator(t,e=je){let r=!1;if(t.scheme===$.file){let n=jr(t);r=n!==void 0&&n.length===Zc(n).length&&n[n.length-1]===e}else{e="/";let n=t.path;r=n.length===1&&n.charCodeAt(n.length-1)===47}return!r&&!gf(t,e)?t.with({path:t.path+"/"}):t}},de=new Fn(()=>!1),On=new Fn(i=>i.scheme===$.file?!Te:!0),hf=new Fn(i=>!0),ua=de.isEqual.bind(de),ou=de.isEqualOrParent.bind(de),qS=de.getComparisonKey.bind(de),ly=de.basenameOrAuthority.bind(de),kr=de.basename.bind(de),cy=de.extname.bind(de),vf=de.dirname.bind(de),z=de.joinPath.bind(de),yf=de.normalizePath.bind(de),KS=de.relativePath.bind(de),zS=de.resolvePath.bind(de),If=de.isAbsolutePath.bind(de),mf=de.isEqualAuthority.bind(de),gf=de.hasTrailingPathSeparator.bind(de),$S=de.removeTrailingPathSeparator.bind(de),jS=de.addTrailingPathSeparator.bind(de);var uy;(o=>{o.META_DATA_LABEL="label",o.META_DATA_DESCRIPTION="description",o.META_DATA_SIZE="size",o.META_DATA_MIME="mime";function n(s){let a=new Map;s.path.substring(s.path.indexOf(";")+1,s.path.lastIndexOf(";")).split(";").forEach(u=>{let[p,f]=u.split(":");p&&f&&a.set(p,f)});let c=s.path.substring(0,s.path.indexOf(";"));return c&&a.set(o.META_DATA_MIME,c),a}o.parseMetaData=n})(uy||={});var xf=Symbol("MicrotaskDelay");function ga(i){return!!i&&typeof i.then=="function"}function Ht(i){let t=new pt,e=i(t.token),r=!1,n=new Promise((o,s)=>{let a=t.token.onCancellationRequested(()=>{r=!0,a.dispose(),s(new Ie)});Promise.resolve(e).then(l=>{a.dispose(),t.dispose(),r?Qs(l)&&l.dispose():o(l)},l=>{a.dispose(),t.dispose(),s(l)})});return new class{cancel(){t.cancel(),t.dispose()}then(o,s){return n.then(o,s)}catch(o){return this.then(void 0,o)}finally(o){return n.finally(o)}}}function Ef(i,t,e){let r,n=setTimeout(()=>{r?.(void 0),e?.()},t);return Promise.race([i.finally(()=>clearTimeout(n)),new Promise(o=>r=o)])}var Oo=class{constructor(){this.activePromise=null,this.queuedPromise=null,this.queuedPromiseFactory=null,this.cancellationTokenSource=new pt}queue(t){if(this.cancellationTokenSource.token.isCancellationRequested)return Promise.reject(new Error("Throttler is disposed"));if(this.activePromise){if(this.queuedPromiseFactory=t,!this.queuedPromise){let e=()=>{if(this.queuedPromise=null,this.cancellationTokenSource.token.isCancellationRequested)return;let r=this.queue(this.queuedPromiseFactory);return this.queuedPromiseFactory=null,r};this.queuedPromise=new Promise(r=>{this.activePromise.then(e,e).then(r)})}return new Promise((e,r)=>{this.queuedPromise.then(e,r)})}return this.activePromise=t(this.cancellationTokenSource.token),new Promise((e,r)=>{this.activePromise.then(n=>{this.activePromise=null,e(n)},n=>{this.activePromise=null,r(n)})})}dispose(){this.cancellationTokenSource.cancel()}},pa=class{constructor(){this.current=Promise.resolve(null)}queue(t){return this.current=this.current.then(()=>t(),()=>t())}};var dy=(i,t)=>{let e=!0,r=setTimeout(()=>{e=!1,t()},i);return{isTriggered:()=>e,dispose:()=>{clearTimeout(r),e=!1}}},py=i=>{let t=!0;return queueMicrotask(()=>{t&&(t=!1,i())}),{isTriggered:()=>t,dispose:()=>{t=!1}}},No=class{constructor(t){this.defaultDelay=t;this.deferred=null,this.completionPromise=null,this.doResolve=null,this.doReject=null,this.task=null}trigger(t,e=this.defaultDelay){this.task=t,this.cancelTimeout(),this.completionPromise||(this.completionPromise=new Promise((n,o)=>{this.doResolve=n,this.doReject=o}).then(()=>{if(this.completionPromise=null,this.doResolve=null,this.task){let n=this.task;return this.task=null,n()}}));let r=()=>{this.deferred=null,this.doResolve?.(null)};return this.deferred=e===xf?py(r):dy(e,r),this.completionPromise}isTriggered(){return!!this.deferred?.isTriggered()}cancel(){this.cancelTimeout(),this.completionPromise&&(this.doReject?.(new Ie),this.completionPromise=null)}cancelTimeout(){this.deferred?.dispose(),this.deferred=null}dispose(){this.cancel()}},_t=class{constructor(t){this.delayer=new No(t),this.throttler=new Oo}trigger(t,e){return this.delayer.trigger(()=>this.throttler.queue(t),e)}isTriggered(){return this.delayer.isTriggered()}cancel(){this.delayer.cancel()}dispose(){this.delayer.dispose(),this.throttler.dispose()}},gi=class{constructor(){this._isOpen=!1,this._promise=new Promise((t,e)=>{this._completePromise=t})}isOpen(){return this._isOpen}open(){this._isOpen=!0,this._completePromise(!0)}wait(){return this._promise}};function Hr(i,t){return t?new Promise((e,r)=>{let n=setTimeout(()=>{o.dispose(),e()},i),o=t.onCancellationRequested(()=>{clearTimeout(n),o.dispose(),r(new Ie)})}):Ht(e=>Hr(i,e))}var Vo=class{constructor(t){this._size=0;this._isDisposed=!1;this.maxDegreeOfParalellism=t,this.outstandingPromises=[],this.runningPromises=0,this._onDrained=new R}whenIdle(){return this.size>0?J.toPromise(this.onDrained):Promise.resolve()}get onDrained(){return this._onDrained.event}get size(){return this._size}queue(t){if(this._isDisposed)throw new Error("Object has been disposed");return this._size++,new Promise((e,r)=>{this.outstandingPromises.push({factory:t,c:e,e:r}),this.consume()})}consume(){for(;this.outstandingPromises.length&&this.runningPromises<this.maxDegreeOfParalellism;){let t=this.outstandingPromises.shift();this.runningPromises++;let e=t.factory();e.then(t.c,t.e),e.then(()=>this.consumed(),()=>this.consumed())}}consumed(){this._isDisposed||(this.runningPromises--,--this._size===0&&this._onDrained.fire(),this.outstandingPromises.length>0&&this.consume())}clear(){if(this._isDisposed)throw new Error("Object has been disposed");this.outstandingPromises.length=0,this._size=this.runningPromises}dispose(){this._isDisposed=!0,this.outstandingPromises.length=0,this._size=0,this._onDrained.dispose()}},jt=class extends Vo{constructor(){super(1)}};var hi=class{constructor(){this.queues=new Map;this.drainers=new Set;this.drainListeners=void 0;this.drainListenerCount=0}async whenDrained(){if(this.isDrained())return;let t=new fn;return this.drainers.add(t),t.p}isDrained(){for(let[,t]of this.queues)if(t.size>0)return!1;return!0}queueSize(t,e=de){let r=e.getComparisonKey(t);return this.queues.get(r)?.size??0}queueFor(t,e,r=de){let n=r.getComparisonKey(t),o=this.queues.get(n);if(!o){o=new jt;let s=this.drainListenerCount++,a=J.once(o.onDrained)(()=>{o?.dispose(),this.queues.delete(n),this.onDidQueueDrain(),this.drainListeners?.deleteAndDispose(s),this.drainListeners?.size===0&&(this.drainListeners.dispose(),this.drainListeners=void 0)});this.drainListeners||(this.drainListeners=new wr),this.drainListeners.set(s,a),this.queues.set(n,o)}return o.queue(e)}onDidQueueDrain(){this.isDrained()&&this.releaseDrainers()}releaseDrainers(){for(let t of this.drainers)t.complete();this.drainers.clear()}dispose(){for(let[,t]of this.queues)t.dispose();this.queues.clear(),this.releaseDrainers(),this.drainListeners?.dispose()}};var Dr=class{constructor(t,e){this.timeoutToken=void 0,this.runner=t,this.timeout=e,this.timeoutHandler=this.onTimeout.bind(this)}dispose(){this.cancel(),this.runner=null}cancel(){this.isScheduled()&&(clearTimeout(this.timeoutToken),this.timeoutToken=void 0)}schedule(t=this.timeout){this.cancel(),this.timeoutToken=setTimeout(this.timeoutHandler,t)}get delay(){return this.timeout}set delay(t){this.timeout=t}isScheduled(){return this.timeoutToken!==void 0}flush(){this.isScheduled()&&(this.cancel(),this.doRun())}onTimeout(){this.timeoutToken=void 0,this.runner&&this.doRun()}doRun(){this.runner?.()}};var fa=class extends Dr{constructor(e,r){super(e,r);this.units=[]}work(e){this.units.push(e),this.isScheduled()||this.schedule()}doRun(){let e=this.units;this.units=[],this.runner?.(e)}dispose(){this.units=[],super.dispose()}},vi=class extends _{constructor(e,r){super();this.options=e;this.handler=r;this.pendingWork=[];this.throttler=this._register(new Zt);this.disposed=!1;this.lastExecutionTime=0}get pending(){return this.pendingWork.length}work(e){if(this.disposed)return!1;if(typeof this.options.maxBufferedWork=="number"){if(this.throttler.value){if(this.pending+e.length>this.options.maxBufferedWork)return!1}else if(this.pending+e.length-this.options.maxWorkChunkSize>this.options.maxBufferedWork)return!1}for(let n of e)this.pendingWork.push(n);let r=Date.now()-this.lastExecutionTime;return!this.throttler.value&&(!this.options.waitThrottleDelayBetweenWorkUnits||r>=this.options.throttleDelay)?this.doWork():!this.throttler.value&&this.options.waitThrottleDelayBetweenWorkUnits&&this.scheduleThrottler(Math.max(this.options.throttleDelay-r,0)),!0}doWork(){this.lastExecutionTime=Date.now(),this.handler(this.pendingWork.splice(0,this.options.maxWorkChunkSize)),this.pendingWork.length>0&&this.scheduleThrottler()}scheduleThrottler(e=this.options.throttleDelay){this.throttler.value=new Dr(()=>{this.throttler.clear(),this.doWork()},e),this.throttler.value.schedule()}dispose(){super.dispose(),this.pendingWork.length=0,this.disposed=!0}},lu,da;(function(){let i=globalThis;typeof i.requestIdleCallback!="function"||typeof i.cancelIdleCallback!="function"?da=(t,e,r)=>{Gp(()=>{if(n)return;let o=Date.now()+15;e(Object.freeze({didTimeout:!0,timeRemaining(){return Math.max(0,o-Date.now())}}))});let n=!1;return{dispose(){n||(n=!0)}}}:da=(t,e,r)=>{let n=t.requestIdleCallback(e,typeof r=="number"?{timeout:r}:void 0),o=!1;return{dispose(){o||(o=!0,t.cancelIdleCallback(n))}}},lu=(t,e)=>da(globalThis,t,e)})();var su=class{constructor(t,e){this._didRun=!1;this._executor=()=>{try{this._value=e()}catch(r){this._error=r}finally{this._didRun=!0}},this._handle=da(t,()=>this._executor())}dispose(){this._handle.dispose()}get value(){if(this._didRun||(this._handle.dispose(),this._executor()),this._error)throw this._error;return this._value}get isInitialized(){return this._didRun}},ma=class extends su{constructor(t){super(globalThis,t)}};async function wf(i,t,e){let r;for(let n=0;n<e;n++)try{return await i()}catch(o){r=o,await Hr(t)}throw r}var fn=class i{static fromPromise(t){let e=new i;return e.settleWith(t),e}get isRejected(){return this.outcome?.outcome===1}get isResolved(){return this.outcome?.outcome===0}get isSettled(){return!!this.outcome}get value(){return this.outcome?.outcome===0?this.outcome?.value:void 0}constructor(){this.p=new Promise((t,e)=>{this.completeCallback=t,this.errorCallback=e})}complete(t){return this.isSettled?Promise.resolve():new Promise(e=>{this.completeCallback(t),this.outcome={outcome:0,value:t},e()})}error(t){return this.isSettled?Promise.resolve():new Promise(e=>{this.errorCallback(t),this.outcome={outcome:1,value:t},e()})}settleWith(t){return t.then(e=>this.complete(e),e=>this.error(e))}cancel(){return this.error(new Ie)}},He;(e=>{async function i(r){let n,o=await Promise.all(r.map(s=>s.then(a=>a,a=>{n||(n=a)})));if(typeof n<"u")throw n;return o}e.settled=i;function t(r){return new Promise(async(n,o)=>{try{await r(n,o)}catch(s){o(s)}})}e.withAsyncBody=t})(He||={});var bf=class i{static fromArray(t){return new i(e=>{e.emitMany(t)})}static fromPromise(t){return new i(async e=>{e.emitMany(await t)})}static fromPromisesResolveOrder(t){return new i(async e=>{await Promise.all(t.map(async r=>e.emitOne(await r)))})}static merge(t){return new i(async e=>{await Promise.all(t.map(async r=>{for await(let n of r)e.emitOne(n)}))})}static{this.EMPTY=i.fromArray([])}constructor(t,e){this._state=0,this._results=[],this._error=null,this._onReturn=e,this._onStateChanged=new R,queueMicrotask(async()=>{let r={emitOne:n=>this.emitOne(n),emitMany:n=>this.emitMany(n),reject:n=>this.reject(n)};try{await Promise.resolve(t(r)),this.resolve()}catch(n){this.reject(n)}finally{r.emitOne=void 0,r.emitMany=void 0,r.reject=void 0}})}[Symbol.asyncIterator](){let t=0;return{next:async()=>{do{if(this._state===2)throw this._error;if(t<this._results.length)return{done:!1,value:this._results[t++]};if(this._state===1)return{done:!0,value:void 0};await J.toPromise(this._onStateChanged.event)}while(!0)},return:async()=>(this._onReturn?.(),{done:!0,value:void 0})}}static map(t,e){return new i(async r=>{for await(let n of t)r.emitOne(e(n))})}map(t){return i.map(this,t)}static filter(t,e){return new i(async r=>{for await(let n of t)e(n)&&r.emitOne(n)})}filter(t){return i.filter(this,t)}static coalesce(t){return i.filter(t,e=>!!e)}coalesce(){return i.coalesce(this)}static async toPromise(t){let e=[];for await(let r of t)e.push(r);return e}toPromise(){return i.toPromise(this)}emitOne(t){this._state===0&&(this._results.push(t),this._onStateChanged.fire())}emitMany(t){this._state===0&&(this._results=this._results.concat(t),this._onStateChanged.fire())}resolve(){this._state===0&&(this._state=1,this._onStateChanged.fire())}reject(t){this._state===0&&(this._state=2,this._error=t,this._onStateChanged.fire())}};var au=class{constructor(){this._unsatisfiedConsumers=[];this._unconsumedValues=[]}get hasFinalValue(){return!!this._finalValue}produce(t){if(this._ensureNoFinalValue(),this._unsatisfiedConsumers.length>0){let e=this._unsatisfiedConsumers.shift();this._resolveOrRejectDeferred(e,t)}else this._unconsumedValues.push(t)}produceFinal(t){this._ensureNoFinalValue(),this._finalValue=t;for(let e of this._unsatisfiedConsumers)this._resolveOrRejectDeferred(e,t);this._unsatisfiedConsumers.length=0}_ensureNoFinalValue(){if(this._finalValue)throw new nn("ProducerConsumer: cannot produce after final value has been set")}_resolveOrRejectDeferred(t,e){e.ok?t.complete(e.value):t.error(e.error)}consume(){if(this._unconsumedValues.length>0||this._finalValue){let t=this._unconsumedValues.length>0?this._unconsumedValues.shift():this._finalValue;return t.ok?Promise.resolve(t.value):Promise.reject(t.error)}else{let t=new fn;return this._unsatisfiedConsumers.push(t),t.p}}},Sf=class i{constructor(t,e){this._onReturn=e;this._producerConsumer=new au;this._iterator={next:()=>this._producerConsumer.consume(),return:()=>(this._onReturn?.(),Promise.resolve({done:!0,value:void 0})),throw:async t=>(this._finishError(t),{done:!0,value:void 0})};queueMicrotask(async()=>{let r=t({emitOne:n=>this._producerConsumer.produce({ok:!0,value:{done:!1,value:n}}),emitMany:n=>{for(let o of n)this._producerConsumer.produce({ok:!0,value:{done:!1,value:o}})},reject:n=>this._finishError(n)});if(!this._producerConsumer.hasFinalValue)try{await r,this._finishOk()}catch(n){this._finishError(n)}})}static fromArray(t){return new i(e=>{e.emitMany(t)})}static fromPromise(t){return new i(async e=>{e.emitMany(await t)})}static fromPromisesResolveOrder(t){return new i(async e=>{await Promise.all(t.map(async r=>e.emitOne(await r)))})}static merge(t){return new i(async e=>{await Promise.all(t.map(async r=>{for await(let n of r)e.emitOne(n)}))})}static{this.EMPTY=i.fromArray([])}static map(t,e){return new i(async r=>{for await(let n of t)r.emitOne(e(n))})}static tee(t){let e,r,n=new fn,o=async()=>{if(!(!e||!r))try{for await(let l of t)e.emitOne(l),r.emitOne(l)}catch(l){e.reject(l),r.reject(l)}finally{n.complete()}},s=new i(async l=>(e=l,o(),n.p)),a=new i(async l=>(r=l,o(),n.p));return[s,a]}map(t){return i.map(this,t)}static coalesce(t){return i.filter(t,e=>!!e)}coalesce(){return i.coalesce(this)}static filter(t,e){return new i(async r=>{for await(let n of t)e(n)&&r.emitOne(n)})}filter(t){return i.filter(this,t)}_finishOk(){this._producerConsumer.hasFinalValue||this._producerConsumer.produceFinal({ok:!0,value:{done:!0,value:void 0}})}_finishError(t){this._producerConsumer.hasFinalValue||this._producerConsumer.produceFinal({ok:!1,error:t})}[Symbol.asyncIterator](){return this._iterator}};function cu(i,t){return t&&(i.stack||i.stacktrace)?m(114,null,Tf(i),Pf(i.stack)||Pf(i.stacktrace)):Tf(i)}function Pf(i){return Array.isArray(i)?i.join(`
`):i}function Tf(i){return i.code==="ERR_UNC_HOST_NOT_ALLOWED"?`${i.message}. Please update the 'security.allowedUNCHosts' setting if you want to allow this host.`:typeof i.code=="string"&&typeof i.errno=="number"&&typeof i.syscall=="string"?m(113,null,i.message):i.message||m(111,null)}function ar(i=null,t=!1){if(!i)return m(111,null);if(Array.isArray(i)){let e=br(i),r=ar(e[0],t);return e.length>1?m(112,null,r,e.length):r}if(te(i))return i;if(i.detail){let e=i.detail;if(e.error)return cu(e.error,t);if(e.exception)return cu(e.exception,t)}return i.stack?cu(i,t):i.message?i.message:m(111,null)}var lr;(n=>{n.serviceIds=new Map,n.DI_TARGET="$di$target",n.DI_DEPENDENCIES="$di$dependencies";function r(o){return o[n.DI_DEPENDENCIES]||[]}n.getServiceDependencies=r})(lr||={});var Lr=B("instantiationService");function fy(i,t,e){t[lr.DI_TARGET]===t?t[lr.DI_DEPENDENCIES].push({id:i,index:e}):(t[lr.DI_DEPENDENCIES]=[{id:i,index:e}],t[lr.DI_TARGET]=t)}function B(i){if(lr.serviceIds.has(i))return lr.serviceIds.get(i);let t=function(e,r,n){if(arguments.length!==3)throw new Error("@IServiceName-decorator can only be used to decorate a parameter");fy(t,e,n)};return t.toString=()=>i,lr.serviceIds.set(i,t),t}var It=B("configurationService");function ha(i){let t=i;return t&&typeof t=="object"&&(!t.overrideIdentifier||typeof t.overrideIdentifier=="string")&&(!t.resource||t.resource instanceof P)}function Rf(i){let t=i;return t&&typeof t=="object"&&(!t.overrideIdentifiers||Array.isArray(t.overrideIdentifiers))&&!t.overrideIdentifier&&(!t.resource||t.resource instanceof P)}function Cf(i){switch(i){case 1:return"APPLICATION";case 2:return"USER";case 3:return"USER_LOCAL";case 4:return"USER_REMOTE";case 5:return"WORKSPACE";case 6:return"WORKSPACE_FOLDER";case 7:return"DEFAULT";case 8:return"MEMORY"}}function va(i,t){let e=Object.create(null);for(let r in i)uu(e,r,i[r],t);return e}function uu(i,t,e,r){let n=t.split("."),o=n.pop(),s=i;for(let a=0;a<n.length;a++){let l=n[a],c=s[l];switch(typeof c){case"undefined":c=s[l]=Object.create(null);break;case"object":if(c===null){r(`Ignoring ${t} as ${n.slice(0,a+1).join(".")} is null`);return}break;default:r(`Ignoring ${t} as ${n.slice(0,a+1).join(".")} is ${JSON.stringify(c)}`);return}s=c}if(typeof s=="object"&&s!==null)try{s[o]=e}catch{r(`Ignoring ${t} as ${n.join(".")} is ${JSON.stringify(s)}`)}else r(`Ignoring ${t} as ${n.join(".")} is ${JSON.stringify(s)}`)}function _f(i,t){let e=t.split(".");kf(i,e)}function kf(i,t){if(!i)return;let e=i,r=t.shift();if(t.length===0){delete e[r];return}if(Object.keys(e).indexOf(r)!==-1){let n=e[r];typeof n=="object"&&!Array.isArray(n)&&(kf(n,t),Object.keys(n).length===0&&delete e[r])}}function Wo(i,t,e){function r(s,a){let l=s;for(let c of a){if(typeof l!="object"||l===null)return;l=l[c]}return l}let n=t.split("."),o=r(i,n);return typeof o>"u"?e:o}function Df(i){return i.replace(/^\[/,"").replace(/]$/g,"").replace(/\]\[/g,", ")}function Bo(i){let t=i;return t?[t.on,t.pause,t.resume,t.destroy].every(e=>typeof e=="function"):!1}function ya(i){let t=i;return t?Bo(t.stream)&&Array.isArray(t.buffer)&&typeof t.ended=="boolean":!1}function Nn(i,t){return new du(i,t)}var du=class{constructor(t,e){this.reducer=t;this.options=e;this.state={flowing:!1,ended:!1,destroyed:!1};this.buffer={data:[],error:[]};this.listeners={data:[],error:[],end:[]};this.pendingWritePromises=[]}pause(){this.state.destroyed||(this.state.flowing=!1)}resume(){this.state.destroyed||this.state.flowing||(this.state.flowing=!0,this.flowData(),this.flowErrors(),this.flowEnd())}write(t){if(!this.state.destroyed){if(this.state.flowing)this.emitData(t);else if(this.buffer.data.push(t),typeof this.options?.highWaterMark=="number"&&this.buffer.data.length>this.options.highWaterMark)return new Promise(e=>this.pendingWritePromises.push(e))}}error(t){this.state.destroyed||(this.state.flowing?this.emitError(t):this.buffer.error.push(t))}end(t){this.state.destroyed||(typeof t<"u"&&this.write(t),this.state.flowing?(this.emitEnd(),this.destroy()):this.state.ended=!0)}emitData(t){this.listeners.data.slice(0).forEach(e=>e(t))}emitError(t){this.listeners.error.length===0?Ke(t):this.listeners.error.slice(0).forEach(e=>e(t))}emitEnd(){this.listeners.end.slice(0).forEach(t=>t())}on(t,e){if(!this.state.destroyed)switch(t){case"data":this.listeners.data.push(e),this.resume();break;case"end":this.listeners.end.push(e),this.state.flowing&&this.flowEnd()&&this.destroy();break;case"error":this.listeners.error.push(e),this.state.flowing&&this.flowErrors();break}}removeListener(t,e){if(this.state.destroyed)return;let r;switch(t){case"data":r=this.listeners.data;break;case"end":r=this.listeners.end;break;case"error":r=this.listeners.error;break}if(r){let n=r.indexOf(e);n>=0&&r.splice(n,1)}}flowData(){if(this.buffer.data.length===0)return;if(typeof this.reducer=="function"){let e=this.reducer(this.buffer.data);this.emitData(e)}else for(let e of this.buffer.data)this.emitData(e);this.buffer.data.length=0;let t=[...this.pendingWritePromises];this.pendingWritePromises.length=0,t.forEach(e=>e())}flowErrors(){if(this.listeners.error.length>0){for(let t of this.buffer.error)this.emitError(t);this.buffer.error.length=0}}flowEnd(){return this.state.ended?(this.emitEnd(),this.listeners.end.length>0):!1}destroy(){this.state.destroyed||(this.state.destroyed=!0,this.state.ended=!0,this.buffer.data.length=0,this.buffer.error.length=0,this.listeners.data.length=0,this.listeners.error.length=0,this.listeners.end.length=0,this.pendingWritePromises.length=0)}};function Lf(i,t){let e=[],r;for(;(r=i.read())!==null;)e.push(r);return t(e)}function Af(i,t,e){let r=[],n;for(;(n=i.read())!==null&&r.length<e;)r.push(n);return n===null&&r.length>0?t(r):{read:()=>{if(r.length>0)return r.shift();if(typeof n<"u"){let o=n;return n=void 0,o}return i.read()}}}function Ia(i,t){return new Promise((e,r)=>{let n=[];xa(i,{onData:o=>{t&&n.push(o)},onError:o=>{t?r(o):e(void 0)},onEnd:()=>{e(t?t(n):void 0)}})})}function xa(i,t,e){i.on("error",r=>{e?.isCancellationRequested||t.onError(r)}),i.on("end",()=>{e?.isCancellationRequested||t.onEnd()}),i.on("data",r=>{e?.isCancellationRequested||t.onData(r)})}function Uf(i,t){return new Promise((e,r)=>{let n=new Pe,o=[],s=c=>{if(o.push(c),o.length>t)return n.dispose(),i.pause(),e({stream:i,buffer:o,ended:!1})},a=c=>(n.dispose(),r(c)),l=()=>(n.dispose(),e({stream:i,buffer:o,ended:!0}));n.add(ue(()=>i.removeListener("error",a))),i.on("error",a),n.add(ue(()=>i.removeListener("end",l))),i.on("end",l),n.add(ue(()=>i.removeListener("data",s))),i.on("data",s)})}function Mf(i){let t=!1;return{read:()=>t?null:(t=!0,i)}}function ba(i,t,e){let r=Nn(e);return xa(i,{onData:n=>r.write(t.data(n)),onError:n=>r.error(t.error?t.error(n):n),onEnd:()=>r.end()}),r}var Go=typeof Buffer<"u",gy=new Ct(()=>new Uint8Array(256)),pu,fu,U=class i{static alloc(t){return Go?new i(Buffer.allocUnsafe(t)):new i(new Uint8Array(t))}static wrap(t){return Go&&!Buffer.isBuffer(t)&&(t=Buffer.from(t.buffer,t.byteOffset,t.byteLength)),new i(t)}static fromString(t,e){return!(e?.dontUseNodeBuffer||!1)&&Go?new i(Buffer.from(t)):(pu||(pu=new TextEncoder),new i(pu.encode(t)))}static fromByteArray(t){let e=i.alloc(t.length);for(let r=0,n=t.length;r<n;r++)e.buffer[r]=t[r];return e}static concat(t,e){if(typeof e>"u"){e=0;for(let o=0,s=t.length;o<s;o++)e+=t[o].byteLength}let r=i.alloc(e),n=0;for(let o=0,s=t.length;o<s;o++){let a=t[o];r.set(a,n),n+=a.byteLength}return r}static isNativeBuffer(t){return Go&&Buffer.isBuffer(t)}constructor(t){this.buffer=t,this.byteLength=this.buffer.byteLength}clone(){let t=i.alloc(this.byteLength);return t.set(this),t}toString(){return Go?this.buffer.toString():(fu||(fu=new TextDecoder(void 0,{ignoreBOM:!0})),fu.decode(this.buffer))}slice(t,e){return new i(this.buffer.subarray(t,e))}set(t,e){if(t instanceof i)this.buffer.set(t.buffer,e);else if(t instanceof Uint8Array)this.buffer.set(t,e);else if(t instanceof ArrayBuffer)this.buffer.set(new Uint8Array(t),e);else if(ArrayBuffer.isView(t))this.buffer.set(new Uint8Array(t.buffer,t.byteOffset,t.byteLength),e);else throw new Error("Unknown argument 'array'")}readUInt32BE(t){return vy(this.buffer,t)}writeUInt32BE(t,e){yy(this.buffer,t,e)}readUInt32LE(t){return Iy(this.buffer,t)}writeUInt32LE(t,e){xy(this.buffer,t,e)}readUInt8(t){return by(this.buffer,t)}writeUInt8(t,e){Sy(this.buffer,t,e)}indexOf(t,e=0){return hy(this.buffer,t instanceof i?t.buffer:t,e)}equals(t){return this===t?!0:this.byteLength!==t.byteLength?!1:this.buffer.every((e,r)=>e===t.buffer[r])}};function hy(i,t,e=0){let r=t.byteLength,n=i.byteLength;if(r===0)return 0;if(r===1)return i.indexOf(t[0],e);if(r>n-e)return-1;let o=gy.value;o.fill(t.length);for(let c=0;c<t.length;c++)o[t[c]]=t.length-c-1;let s=e+t.length-1,a=s,l=-1;for(;s<n;)if(i[s]===t[a]){if(a===0){l=s;break}s--,a--}else s+=Math.max(t.length-a,o[i[s]]),a=t.length-1;return l}function vy(i,t){return i[t]*2**24+i[t+1]*2**16+i[t+2]*2**8+i[t+3]}function yy(i,t,e){i[e+3]=t,t=t>>>8,i[e+2]=t,t=t>>>8,i[e+1]=t,t=t>>>8,i[e]=t}function Iy(i,t){return i[t+0]<<0>>>0|i[t+1]<<8>>>0|i[t+2]<<16>>>0|i[t+3]<<24>>>0}function xy(i,t,e){i[e+0]=t&255,t=t>>>8,i[e+1]=t&255,t=t>>>8,i[e+2]=t&255,t=t>>>8,i[e+3]=t&255}function by(i,t){return i[t]}function Sy(i,t,e){i[e]=t}function Of(i){return Lf(i,t=>U.concat(t))}function Nf(i){return Mf(i)}function Ar(i){return Ia(i,t=>U.concat(t))}async function Vf(i){return i.ended?U.concat(i.buffer):U.concat([...i.buffer,await Ar(i.stream)])}function Wf(i){return ba(i,{data:t=>typeof t=="string"?U.fromString(t):U.wrap(t)},t=>U.concat(t))}function Bf(i){return Nn(t=>U.concat(t),i)}var Ff="0123456789abcdef";function Gf({buffer:i}){let t="";for(let e=0;e<i.length;e++){let r=i[e];t+=Ff[r>>>4],t+=Ff[r&15]}return t}var Ea;(t=>t.DEFAULT={allowTrailingComma:!0})(Ea||={});function gu(i,t=!1){let e=0,r=i.length,n="",o=0,s=16,a=0;function l(h){let y=0,E=0;for(;y<h;){let b=i.charCodeAt(e);if(b>=48&&b<=57)E=E*16+b-48;else if(b>=65&&b<=70)E=E*16+b-65+10;else if(b>=97&&b<=102)E=E*16+b-97+10;else break;e++,y++}return y<h&&(E=-1),E}function c(h){e=h,n="",o=0,s=16,a=0}function u(){let h=e;if(i.charCodeAt(e)===48)e++;else for(e++;e<i.length&&yi(i.charCodeAt(e));)e++;if(e<i.length&&i.charCodeAt(e)===46)if(e++,e<i.length&&yi(i.charCodeAt(e)))for(e++;e<i.length&&yi(i.charCodeAt(e));)e++;else return a=3,i.substring(h,e);let y=e;if(e<i.length&&(i.charCodeAt(e)===69||i.charCodeAt(e)===101))if(e++,(e<i.length&&i.charCodeAt(e)===43||i.charCodeAt(e)===45)&&e++,e<i.length&&yi(i.charCodeAt(e))){for(e++;e<i.length&&yi(i.charCodeAt(e));)e++;y=e}else a=3;return i.substring(h,y)}function p(){let h="",y=e;for(;;){if(e>=r){h+=i.substring(y,e),a=2;break}let E=i.charCodeAt(e);if(E===34){h+=i.substring(y,e),e++;break}if(E===92){if(h+=i.substring(y,e),e++,e>=r){a=2;break}switch(i.charCodeAt(e++)){case 34:h+='"';break;case 92:h+="\\";break;case 47:h+="/";break;case 98:h+="\b";break;case 102:h+="\f";break;case 110:h+=`
`;break;case 114:h+="\r";break;case 116:h+="	";break;case 117:{let C=l(4);C>=0?h+=String.fromCharCode(C):a=4;break}default:a=5}y=e;continue}if(E>=0&&E<=31)if(Sa(E)){h+=i.substring(y,e),a=2;break}else a=6;e++}return h}function f(){if(n="",a=0,o=e,e>=r)return o=r,s=17;let h=i.charCodeAt(e);if(mu(h)){do e++,n+=String.fromCharCode(h),h=i.charCodeAt(e);while(mu(h));return s=15}if(Sa(h))return e++,n+=String.fromCharCode(h),h===13&&i.charCodeAt(e)===10&&(e++,n+=`
`),s=14;switch(h){case 123:return e++,s=1;case 125:return e++,s=2;case 91:return e++,s=3;case 93:return e++,s=4;case 58:return e++,s=6;case 44:return e++,s=5;case 34:return e++,n=p(),s=10;case 47:{let y=e-1;if(i.charCodeAt(e+1)===47){for(e+=2;e<r&&!Sa(i.charCodeAt(e));)e++;return n=i.substring(y,e),s=12}if(i.charCodeAt(e+1)===42){e+=2;let E=r-1,b=!1;for(;e<E;){if(i.charCodeAt(e)===42&&i.charCodeAt(e+1)===47){e+=2,b=!0;break}e++}return b||(e++,a=1),n=i.substring(y,e),s=13}return n+=String.fromCharCode(h),e++,s=16}case 45:if(n+=String.fromCharCode(h),e++,e===r||!yi(i.charCodeAt(e)))return s=16;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return n+=u(),s=11;default:for(;e<r&&g(h);)e++,h=i.charCodeAt(e);if(o!==e){switch(n=i.substring(o,e),n){case"true":return s=8;case"false":return s=9;case"null":return s=7}return s=16}return n+=String.fromCharCode(h),e++,s=16}}function g(h){if(mu(h)||Sa(h))return!1;switch(h){case 125:case 93:case 123:case 91:case 34:case 58:case 44:case 47:return!1}return!0}function v(){let h;do h=f();while(h>=12&&h<=15);return h}return{setPosition:c,getPosition:()=>e,scan:t?v:f,getToken:()=>s,getTokenValue:()=>n,getTokenOffset:()=>o,getTokenLength:()=>e-o,getTokenError:()=>a}}function mu(i){return i===32||i===9||i===11||i===12||i===160||i===5760||i>=8192&&i<=8203||i===8239||i===8287||i===12288||i===65279}function Sa(i){return i===10||i===13||i===8232||i===8233}function yi(i){return i>=48&&i<=57}function Ur(i,t=[],e=Ea.DEFAULT){let r=null,n=[],o=[];function s(l){Array.isArray(n)?n.push(l):r!==null&&(n[r]=l)}return Ii(i,{onObjectBegin:()=>{let l={};s(l),o.push(n),n=l,r=null},onObjectProperty:l=>{r=l},onObjectEnd:()=>{n=o.pop()},onArrayBegin:()=>{let l=[];s(l),o.push(n),n=l,r=null},onArrayEnd:()=>{n=o.pop()},onLiteralValue:s,onError:(l,c,u)=>{t.push({error:l,offset:c,length:u})}},e),n[0]}function qf(i,t=[],e=Ea.DEFAULT){let r={type:"array",offset:-1,length:-1,children:[],parent:void 0};function n(l){r.type==="property"&&(r.length=l-r.offset,r=r.parent)}function o(l){return r.children.push(l),l}Ii(i,{onObjectBegin:l=>{r=o({type:"object",offset:l,length:-1,parent:r,children:[]})},onObjectProperty:(l,c,u)=>{r=o({type:"property",offset:c,length:-1,parent:r,children:[]}),r.children.push({type:"string",value:l,offset:c,length:u,parent:r})},onObjectEnd:(l,c)=>{r.length=l+c-r.offset,r=r.parent,n(l+c)},onArrayBegin:(l,c)=>{r=o({type:"array",offset:l,length:-1,parent:r,children:[]})},onArrayEnd:(l,c)=>{r.length=l+c-r.offset,r=r.parent,n(l+c)},onLiteralValue:(l,c,u)=>{o({type:xi(l),offset:c,length:u,parent:r,value:l}),n(c+u)},onSeparator:(l,c,u)=>{r.type==="property"&&(l===":"?r.colonOffset=c:l===","&&n(c))},onError:(l,c,u)=>{t.push({error:l,offset:c,length:u})}},e);let a=r.children[0];return a&&delete a.parent,a}function hu(i,t){if(!i)return;let e=i;for(let r of t)if(typeof r=="string"){if(e.type!=="object"||!Array.isArray(e.children))return;let n=!1;for(let o of e.children)if(Array.isArray(o.children)&&o.children[0].value===r){e=o.children[1],n=!0;break}if(!n)return}else{let n=r;if(e.type!=="array"||n<0||!Array.isArray(e.children)||n>=e.children.length)return;e=e.children[n]}return e}function Ii(i,t,e=Ea.DEFAULT){let r=gu(i,!1);function n(F){return F?()=>F(r.getTokenOffset(),r.getTokenLength()):()=>!0}function o(F){return F?xe=>F(xe,r.getTokenOffset(),r.getTokenLength()):()=>!0}let s=n(t.onObjectBegin),a=o(t.onObjectProperty),l=n(t.onObjectEnd),c=n(t.onArrayBegin),u=n(t.onArrayEnd),p=o(t.onLiteralValue),f=o(t.onSeparator),g=n(t.onComment),v=o(t.onError),h=e&&e.disallowComments,y=e&&e.allowTrailingComma;function E(){for(;;){let F=r.scan();switch(r.getTokenError()){case 4:b(14);break;case 5:b(15);break;case 3:b(13);break;case 1:h||b(11);break;case 2:b(12);break;case 6:b(16);break}switch(F){case 12:case 13:h?b(10):g();break;case 16:b(1);break;case 15:case 14:break;default:return F}}}function b(F,xe=[],Et=[]){if(v(F),xe.length+Et.length>0){let st=r.getToken();for(;st!==17;){if(xe.indexOf(st)!==-1){E();break}else if(Et.indexOf(st)!==-1)break;st=E()}}}function C(F){let xe=r.getTokenValue();return F?p(xe):a(xe),E(),!0}function N(){switch(r.getToken()){case 11:{let F=0;try{F=JSON.parse(r.getTokenValue()),typeof F!="number"&&(b(2),F=0)}catch{b(2)}p(F);break}case 7:p(null);break;case 8:p(!0);break;case 9:p(!1);break;default:return!1}return E(),!0}function oe(){return r.getToken()!==10?(b(3,[],[2,5]),!1):(C(!1),r.getToken()===6?(f(":"),E(),j()||b(4,[],[2,5])):b(5,[],[2,5]),!0)}function Fe(){s(),E();let F=!1;for(;r.getToken()!==2&&r.getToken()!==17;){if(r.getToken()===5){if(F||b(4,[],[]),f(","),E(),r.getToken()===2&&y)break}else F&&b(6,[],[]);oe()||b(4,[],[2,5]),F=!0}return l(),r.getToken()!==2?b(7,[2],[]):E(),!0}function L(){c(),E();let F=!1;for(;r.getToken()!==4&&r.getToken()!==17;){if(r.getToken()===5){if(F||b(4,[],[]),f(","),E(),r.getToken()===4&&y)break}else F&&b(6,[],[]);j()||b(4,[],[4,5]),F=!0}return u(),r.getToken()!==4?b(8,[4],[]):E(),!0}function j(){switch(r.getToken()){case 3:return L();case 1:return Fe();case 10:return C(!0);default:return N()}}return E(),r.getToken()===17?e.allowEmptyContent?!0:(b(4,[],[]),!1):j()?(r.getToken()!==17&&b(9,[],[]),!0):(b(4,[],[]),!1)}function xi(i){switch(typeof i){case"boolean":return"boolean";case"number":return"number";case"string":return"string";case"object":{if(i){if(Array.isArray(i))return"array"}else return"null";return"object"}default:return"null"}}function zf(i,t,e){let r,n,o,s,a;if(t){for(s=t.offset,a=s+t.length,o=s;o>0&&!qo(i,o-1);)o--;let C=a;for(;C<i.length&&!qo(i,C);)C++;n=i.substring(o,C),r=Ey(n,e)}else n=i,r=0,o=0,s=0,a=i.length;let l=wy(e,i),c=!1,u=0,p;e.insertSpaces?p=vu(" ",e.tabSize||4):p="	";let f=gu(n,!1),g=!1;function v(){return l+vu(p,r+u)}function h(){let C=f.scan();for(c=!1;C===15||C===14;)c=c||C===14,C=f.scan();return g=C===16||f.getTokenError()!==0,C}let y=[];function E(C,N,oe){!g&&N<a&&oe>s&&i.substring(N,oe)!==C&&y.push({offset:N,length:oe-N,content:C})}let b=h();if(b!==17){let C=f.getTokenOffset()+o,N=vu(p,r);E(N,o,C)}for(;b!==17;){let C=f.getTokenOffset()+f.getTokenLength()+o,N=h(),oe="";for(;!c&&(N===12||N===13);){let L=f.getTokenOffset()+o;E(" ",C,L),C=f.getTokenOffset()+f.getTokenLength()+o,oe=N===12?v():"",N=h()}if(N===2)b!==1&&(u--,oe=v());else if(N===4)b!==3&&(u--,oe=v());else{switch(b){case 3:case 1:u++,oe=v();break;case 5:case 12:oe=v();break;case 13:c?oe=v():oe=" ";break;case 6:oe=" ";break;case 10:if(N===6){oe="";break}case 7:case 8:case 9:case 11:case 2:case 4:N===12||N===13?oe=" ":N!==5&&N!==17&&(g=!0);break;case 16:g=!0;break}c&&(N===12||N===13)&&(oe=v())}let Fe=f.getTokenOffset()+o;E(oe,C,Fe),b=N}return y}function vu(i,t){let e="";for(let r=0;r<t;r++)e+=i;return e}function Ey(i,t){let e=0,r=0,n=t.tabSize||4;for(;e<i.length;){let o=i.charAt(e);if(o===" ")r++;else if(o==="	")r+=n;else break;e++}return Math.floor(r/n)}function wy(i,t){for(let e=0;e<t.length;e++){let r=t.charAt(e);if(r==="\r")return e+1<t.length&&t.charAt(e+1)===`
`?`\r
`:"\r";if(r===`
`)return`
`}return i&&i.eol||`
`}function qo(i,t){return`\r
`.indexOf(i.charAt(t))!==-1}function $f(i,t,e,r,n){let o=t.slice(),a=qf(i,[]),l,c;for(;o.length>0&&(c=o.pop(),l=hu(a,o),l===void 0&&e!==void 0);)typeof c=="string"?e={[c]:e}:e=[e];if(l)if(l.type==="object"&&typeof c=="string"&&Array.isArray(l.children)){let u=hu(l,[c]);if(u!==void 0)if(e===void 0){if(!u.parent)throw new Error("Malformed AST");let p=l.children.indexOf(u.parent),f,g=u.parent.offset+u.parent.length;if(p>0){let v=l.children[p-1];f=v.offset+v.length}else f=l.offset+1,l.children.length>1&&(g=l.children[1].offset);return bi(i,{offset:f,length:g-f,content:""},r)}else return bi(i,{offset:u.offset,length:u.length,content:JSON.stringify(e)},r);else{if(e===void 0)return[];let p=`${JSON.stringify(c)}: ${JSON.stringify(e)}`,f=n?n(l.children.map(v=>v.children[0].value)):l.children.length,g;if(f>0){let v=l.children[f-1];g={offset:v.offset+v.length,length:0,content:","+p}}else l.children.length===0?g={offset:l.offset+1,length:0,content:p}:g={offset:l.offset+1,length:0,content:p+","};return bi(i,g,r)}}else if(l.type==="array"&&typeof c=="number"&&Array.isArray(l.children))if(e!==void 0){let u=`${JSON.stringify(e)}`,p;if(l.children.length===0||c===0)p={offset:l.offset+1,length:0,content:l.children.length===0?u:u+","};else{let f=c===-1||c>l.children.length?l.children.length:c,g=l.children[f-1];p={offset:g.offset+g.length,length:0,content:","+u}}return bi(i,p,r)}else{let u=c,p=l.children[u],f;if(l.children.length===1)f={offset:l.offset+1,length:l.length-2,content:""};else if(l.children.length-1===u){let g=l.children[u-1],v=g.offset+g.length,h=l.offset+l.length;f={offset:v,length:h-2-v,content:""}}else f={offset:p.offset,length:l.children[u+1].offset-p.offset,content:""};return bi(i,f,r)}else throw new Error(`Can not add ${typeof c!="number"?"index":"property"} to parent of type ${l.type}`);else return e===void 0?[]:bi(i,{offset:a?a.offset:0,length:a?a.length:0,content:JSON.stringify(e)},r)}function bi(i,t,e){let r=yu(i,t),n=t.offset,o=t.offset+t.content.length;if(t.length===0||t.content.length===0){for(;n>0&&!qo(r,n-1);)n--;for(;o<r.length&&!qo(r,o);)o++}let s=zf(r,{offset:n,length:o-n},e);for(let l=s.length-1;l>=0;l--){let c=s[l];r=yu(r,c),n=Math.min(n,c.offset),o=Math.max(o,c.offset+c.length),o+=c.content.length-c.length}let a=i.length-(r.length-o)-n;return[{offset:n,length:a,content:r.substring(n,o)}]}function yu(i,t){return i.substring(0,t.offset)+t.content+i.substring(t.offset+t.length)}function jf(i,t){let e=t.slice(0).sort((n,o)=>{let s=n.offset-o.offset;return s===0?n.length-o.length:s}),r=i.length;for(let n=e.length-1;n>=0;n--){let o=e[n];if(o.offset+o.length<=r)i=yu(i,o);else throw new Error("Overlapping edit");r=o.offset}return i}function tr(i){if(!i||typeof i!="object"||i instanceof RegExp)return i;let t=Array.isArray(i)?[]:{};return Object.entries(i).forEach(([e,r])=>{t[e]=r&&typeof r=="object"?tr(r):r}),t}function Hf(i){if(!i||typeof i!="object")return i;let t=[i];for(;t.length>0;){let e=t.shift();Object.freeze(e);for(let r in e)if(Qf.call(e,r)){let n=e[r];typeof n=="object"&&!Object.isFrozen(n)&&!Ep(n)&&t.push(n)}}return i}var Qf=Object.prototype.hasOwnProperty;function Jf(i,t){return Iu(i,t,new Set)}function Iu(i,t,e){if(Oe(i))return i;let r=t(i);if(typeof r<"u")return r;if(Array.isArray(i)){let n=[];for(let o of i)n.push(Iu(o,t,e));return n}if(he(i)){if(e.has(i))throw new Error("Cannot clone recursive data-structure");e.add(i);let n={};for(let o in i)Qf.call(i,o)&&(n[o]=Iu(i[o],t,e));return e.delete(i),n}return i}function Si(i,t,e=!0){return he(i)?(he(t)&&Object.keys(t).forEach(r=>{r in i?e&&(he(i[r])&&he(t[r])?Si(i[r],t[r],e):i[r]=t[r]):i[r]=t[r]}),i):t}function xt(i,t){if(i===t)return!0;if(i==null||t===null||t===void 0||typeof i!=typeof t||typeof i!="object"||Array.isArray(i)!==Array.isArray(t))return!1;let e,r;if(Array.isArray(i)){if(i.length!==t.length)return!1;for(e=0;e<i.length;e++)if(!xt(i[e],t[e]))return!1}else{let n=[];for(r in i)n.push(r);n.sort();let o=[];for(r in t)o.push(r);if(o.sort(),!xt(n,o))return!1;for(e=0;e<n.length;e++)if(!xt(i[n[e]],t[n[e]]))return!1}return!0}function xu(i){let t=new Set;return JSON.stringify(i,(e,r)=>{if(he(r)||Array.isArray(r)){if(t.has(r))return"[Circular]";t.add(r)}return typeof r=="bigint"?`[BigInt ${r.toString()}]`:r})}function Yf(i){let t=!1,e=new Map,r=new Map;if(Py(i,u=>{if(i===u)return!0;let p=JSON.stringify(u);if(p.length<30)return!0;let f=e.get(p);if(!f){let g={schemas:[u]};return e.set(p,g),r.set(u,g),!0}return f.schemas.push(u),r.set(u,f),t=!0,!1}),e.clear(),!t)return JSON.stringify(i);let o="$defs";for(;i.hasOwnProperty(o);)o+="_";let s=[];function a(u){return JSON.stringify(u,(p,f)=>{if(f!==u){let g=r.get(f);if(g&&g.schemas.length>1)return g.id||(g.id=`_${s.length}`,s.push(g.schemas[0])),{$ref:`#/${o}/${g.id}`}}return f})}let l=a(i),c=[];for(let u=0;u<s.length;u++)c.push(`"_${u}":${a(s[u])}`);return c.length?`${l.substring(0,l.length-1)},"${o}":{${c.join(",")}}}`:l}function Ei(i){return typeof i=="object"&&i!==null}function Py(i,t){if(!i||typeof i!="object")return;let e=(...l)=>{for(let c of l)Ei(c)&&s.push(c)},r=(...l)=>{for(let c of l)if(Ei(c))for(let u in c){let p=c[u];Ei(p)&&s.push(p)}},n=(...l)=>{for(let c of l)if(Array.isArray(c))for(let u of c)Ei(u)&&s.push(u)},o=l=>{if(Array.isArray(l))for(let c of l)Ei(c)&&s.push(c);else Ei(l)&&s.push(l)},s=[i],a=s.pop();for(;a;)t(a)&&(e(a.additionalItems,a.additionalProperties,a.not,a.contains,a.propertyNames,a.if,a.then,a.else,a.unevaluatedItems,a.unevaluatedProperties),r(a.definitions,a.$defs,a.properties,a.patternProperties,a.dependencies,a.dependentSchemas),n(a.anyOf,a.allOf,a.oneOf,a.prefixItems),o(a.items)),a=s.pop()}var bu=class{constructor(){this.data=new Map}add(t,e){$s(te(t)),$s(he(e)),$s(!this.data.has(t),"There is already an extension with this id"),this.data.set(t,e)}knows(t){return this.data.has(t)}as(t){return this.data.get(t)||null}dispose(){this.data.forEach(t=>{Lc(t.dispose)&&t.dispose()}),this.data.clear()}},it=new bu;var Eu={JSONContribution:"base.contributions.json"};function Zf(i){return i.length>0&&i.charAt(i.length-1)==="#"?i.substring(0,i.length-1):i}var Su=class extends _{constructor(){super(...arguments);this.schemasById={};this.schemaAssociations={};this._onDidChangeSchema=this._register(new R);this.onDidChangeSchema=this._onDidChangeSchema.event;this._onDidChangeSchemaAssociations=this._register(new R);this.onDidChangeSchemaAssociations=this._onDidChangeSchemaAssociations.event}registerSchema(e,r,n){let o=Zf(e);this.schemasById[o]=r,this._onDidChangeSchema.fire(e),n&&n.add(ue(()=>{delete this.schemasById[o],this._onDidChangeSchema.fire(e)}))}registerSchemaAssociation(e,r){let n=Zf(e);return this.schemaAssociations[n]||(this.schemaAssociations[n]=[]),this.schemaAssociations[n].includes(r)||(this.schemaAssociations[n].push(r),this._onDidChangeSchemaAssociations.fire()),ue(()=>{let o=this.schemaAssociations[n];if(o){let s=o.indexOf(r);s!==-1&&(o.splice(s,1),o.length===0&&delete this.schemaAssociations[n],this._onDidChangeSchemaAssociations.fire())}})}notifySchemaChanged(e){this._onDidChangeSchema.fire(e)}getSchemaContributions(){return{schemas:this.schemasById}}getSchemaContent(e){let r=this.schemasById[e];return r?Yf(r):void 0}hasSchemaContent(e){return!!this.schemasById[e]}getSchemaAssociations(){return this.schemaAssociations}},Ry=new Su;it.add(Eu.JSONContribution,Ry);var Gt,wu=globalThis.vscode;if(typeof wu<"u"&&typeof wu.context<"u"){let i=wu.context.configuration();if(i)Gt=i.product;else throw new Error("Sandbox: unable to resolve product configuration from preload script.")}else if(globalThis._VSCODE_PRODUCT_JSON&&globalThis._VSCODE_PACKAGE_JSON){if(Gt=globalThis._VSCODE_PRODUCT_JSON,Ot.VSCODE_DEV&&Object.assign(Gt,{nameShort:`${Gt.nameShort} Dev`,nameLong:`${Gt.nameLong} Dev`,dataFolderName:`${Gt.dataFolderName}-dev`,serverDataFolderName:Gt.serverDataFolderName?`${Gt.serverDataFolderName}-dev`:void 0}),!Gt.version){let i=globalThis._VSCODE_PACKAGE_JSON;Object.assign(Gt,{version:i.version})}}else Gt={nameShort:"Code - Insiders",nameLong:"Visual Studio Code - Insiders",applicationName:"code-insiders",win32x64AppId:"{{1287CAD5-7C8D-410D-88B9-0D1EE4A83FF2}",win32arm64AppId:"{{0AEDB616-9614-463B-97D7-119DD86CCA64}",win32x64UserAppId:"{{217B4C08-948D-4276-BFBB-BEE930AE5A2C}",win32arm64UserAppId:"{{69BD8F7B-65EB-4C6F-A14E-44CFA83712C0}",win32NameVersion:"Microsoft Visual Studio Code Insiders",win32DirName:"Microsoft VS Code Insiders",win32SetupExeBasename:"VSCodeInsidersSetup",win32AppUserModelId:"Microsoft.VisualStudioCodeInsiders",win32ShellNameShort:"Code Insiders",win32MutexName:"vscodeinsiders",win32RegValueName:"VSCodeInsiders",win32VersionedUpdate:!0,darwinCredits:"resources/darwin/Credits.rtf",darwinBundleIdentifier:"com.microsoft.VSCodeInsiders",darwinProfileUUID:"7CC2F939-3A89-4A22-B9DA-E5B81C0F6C03",darwinProfilePayloadUUID:"BEA6A398-BD82-4EEC-B626-8464DBB73561",darwinExecutable:"VSCodeInsiders",linuxIconName:"vscode-insiders",licenseFileName:"LICENSE.rtf",licenseName:"Multiple, see https://code.visualstudio.com/license",serverGreeting:[],serverLicense:["*","* Visual Studio Code Server","*","* By using the software, you agree to","* the Visual Studio Code Server License Terms (https://aka.ms/vscode-server-license) and","* the Microsoft Privacy Statement (https://privacy.microsoft.com/en-US/privacystatement).","*"],serverLicensePrompt:"Do you accept the terms in the License Agreement (Y/n)?",serverApplicationName:"code-server-insiders",urlProtocol:"vscode-insiders",dataFolderName:".vscode-insiders",serverDataFolderName:".vscode-server-insiders",downloadUrl:"https://code.visualstudio.com/insiders",updateUrl:"https://update.code.visualstudio.com",webUrl:"https://insiders.vscode.dev",webEndpointUrl:"https://main.vscode-cdn.net",webEndpointUrlTemplate:"https://{{uuid}}.vscode-cdn.net/{{quality}}/{{commit}}",nlsCoreBaseUrl:"https://www.vscode-unpkg.net/nls/",webviewContentExternalBaseUrlTemplate:"https://{{uuid}}.vscode-cdn.net/{{quality}}/{{commit}}/out/vs/workbench/contrib/webview/browser/pre/",quality:"insider",embedded:{nameShort:"Sessions - Insiders",nameLong:"Visual Studio Code Sessions - Insiders",applicationName:"sessions-insiders",darwinBundleIdentifier:"com.microsoft.VSCodeSessionsInsiders",dataFolderName:".vscode-sessions-insiders",urlProtocol:"vscode-sessions-insiders"},extensionsGallery:{nlsBaseUrl:"https://www.vscode-unpkg.net/_lp/",serviceUrl:"https://marketplace.visualstudio.com/_apis/public/gallery",itemUrl:"https://marketplace.visualstudio.com/items",publisherUrl:"https://marketplace.visualstudio.com/publishers",resourceUrlTemplate:"https://{publisher}.vscode-unpkg.net/{publisher}/{name}/{version}/{path}",extensionUrlTemplate:"https://www.vscode-unpkg.net/_gallery/{publisher}/{name}/latest",controlUrl:"https://main.vscode-cdn.net/extensions/marketplace.json",mcpUrl:"https://main.vscode-cdn.net/mcp/servers.json",accessSKUs:["copilot_enterprise_seat","copilot_enterprise_seat_quota","copilot_enterprise_seat_multi_quota","copilot_enterprise_seat_assignment","copilot_enterprise_seat_assignment_quota","copilot_enterprise_seat_assignment_multi_quota","copilot_enterprise_trial_seat","copilot_enterprise_trial_seat_quota","copilot_for_business_seat","copilot_for_business_seat_quota","copilot_for_business_seat_multi_quota","copilot_for_business_seat_assignment","copilot_for_business_seat_assignment_quota","copilot_for_business_seat_assignment_multi_quota","copilot_for_business_trial_seat","copilot_for_business_trial_seat_quota"]},extensionProperties:{"github.copilot-chat":{excludeVersionRange:"<=0.16.1"},"github.copilot":{hasPrereleaseVersion:!0}},extensionsForceVersionByQuality:["github.copilot-chat","github.copilot"],mcpGallery:{serviceUrl:"https://api.mcp.github.com",itemWebUrl:"https://github.com/mcp/{name}",publisherUrl:"https://github.com/{name}",supportUrl:"https://support.github.com",privacyPolicyUrl:"https://docs.github.com/site-policy/privacy-policies/github-general-privacy-statement",termsOfServiceUrl:"https://docs.github.com/site-policy/github-terms/github-terms-of-service",reportUrl:"https://docs.github.com/communities/maintaining-your-safety-on-github/reporting-abuse-or-spam"},profileTemplatesUrl:"https://main.vscode-cdn.net/core/profile-templates.json",emergencyAlertUrl:"https://main.vscode-cdn.net/core/insiders.json",extensionPublisherOrgs:["microsoft"],trustedExtensionPublishers:["microsoft","github","openai"],extensionRecommendations:{"ms-dotnettools.csdevkit":{onFileOpen:[{pathGlob:"{**/*.cs,**/global.json,**/*.csproj,**/*.cshtml,**/*.sln}",important:!0},{languages:["csharp"],important:!0},{pathGlob:"{**/project.json,**/appsettings.json}"}]},"ms-python.python":{onFileOpen:[{pathGlob:"{**/*.py}",important:!0},{languages:["python"],important:!0},{pathGlob:"{**/*.ipynb}"}]},"ms-toolsai.jupyter":{onFileOpen:[{pathGlob:"{**/*.py}",contentPattern:"^#\\s*%%$",important:!0,whenInstalled:["ms-python.python"]},{pathGlob:"{**/*.ipynb}"}]},"ms-toolsai.datawrangler":{onFileOpen:[{pathGlob:"{**/*.ipynb}",contentPattern:"import\\s*pandas|from\\s*pandas",whenInstalled:["ms-toolsai.jupyter"]}]},"golang.Go":{onFileOpen:[{pathGlob:"**/*.go",important:!0},{languages:["go"],important:!0}]},"vscjava.vscode-java-pack":{onFileOpen:[{pathGlob:"{**/*.java}",important:!0,whenNotInstalled:["ASF.apache-netbeans-java","Oracle.oracle-java"]},{languages:["java"],important:!0,whenNotInstalled:["ASF.apache-netbeans-java","Oracle.oracle-java"]}]},"ms-vscode.PowerShell":{onFileOpen:[{pathGlob:"{**/*.ps1,**/*.psd1,**/*.psm1}",important:!0},{languages:["powershell"],important:!0},{pathGlob:"{**/*.ps.config,**/*.ps1.config}"}]},"ms-toolsai.prompty":{onFileOpen:[{pathGlob:"{**/*.prompty}",important:!1}]},"quantum.qsharp-lang-vscode":{onFileOpen:[{pathGlob:"{**/*.qs,**/*.qsc,**/*.qasm}",important:!0}]},"typespec.typespec-vscode":{onFileOpen:[{pathGlob:"{**/*.tsp,**/tspconfig.yaml}",important:!0}]},"ms-vscode.cpptools-extension-pack":{onFileOpen:[{pathGlob:"{**/*.c,**/*.cpp,**/*.cc,**/.cxx,**/*.hh,**/*.hpp,**/*.hxx,**/*.h}",important:!0,whenNotInstalled:["llvm-vs-code-extensions.vscode-clangd"]},{languages:["c","cpp"],important:!0,whenNotInstalled:["llvm-vs-code-extensions.vscode-clangd"]}]},"ms-azuretools.vscode-containers":{onFileOpen:[{pathGlob:"{**/dockerfile,**/Dockerfile,**/docker-compose.yml,**/docker-compose.*.yml}",important:!0,whenNotInstalled:["ms-azuretools.vscode-docker"]},{languages:["dockerfile"],important:!0,whenNotInstalled:["ms-azuretools.vscode-docker"]},{pathGlob:"{**/*.cs,**/project.json,**/global.json,**/*.csproj,**/*.cshtml,**/*.sln,**/appsettings.json,**/*.py,**/*.ipynb,**/*.js,**/*.ts,**/package.json}",whenNotInstalled:["ms-azuretools.vscode-docker"]}]},"vue.volar":{onFileOpen:[{pathGlob:"{**/*.vue}",important:!0},{languages:["vue"],important:!0}]},"ms-vscode.makefile-tools":{onFileOpen:[{pathGlob:"{**/makefile,**/Makefile}",important:!0},{languages:["makefile"],important:!0}]},"ms-vscode.cmake-tools":{onFileOpen:[{pathGlob:"{**/CMakeLists.txt}",important:!0}]},"ms-azure-devops.azure-pipelines":{onFileOpen:[{pathGlob:"{**/azure-pipelines.yaml}",important:!0}]},"msazurermtools.azurerm-vscode-tools":{onFileOpen:[{pathGlob:"{**/azuredeploy.json}",important:!0}]},"ms-vscode-remote.remote-containers":{onFileOpen:[{pathGlob:"{**/devcontainer.json}",important:!0}]},"ms-azuretools.vscode-bicep":{onFileOpen:[{pathGlob:"{**/*.bicep}",important:!0,whenNotInstalled:["ms-azuretools.rad-vscode-bicep"]}]},"svelte.svelte-vscode":{onFileOpen:[{pathGlob:"{**/*.svelte}",important:!0}]},"ms-vscode.vscode-github-issue-notebooks":{onFileOpen:[{pathGlob:"{**/*.github-issues}",important:!0}]},"ms-playwright.playwright":{onFileOpen:[{pathGlob:"{**/*playwright*.config.ts,**/*playwright*.config.js,**/*playwright*.config.mjs}",important:!0}]},"vscjava.vscode-gradle":{onFileOpen:[{pathGlob:"{**/gradlew,**/gradlew.bat,**/build.gradle,**/build.gradle.kts,**/settings.gradle,**/settings.gradle.kts}",important:!0}]},"REditorSupport.r":{onFileOpen:[{pathGlob:"{**/*.r}",important:!0},{languages:["r"],important:!0}]},"firefox-devtools.vscode-firefox-debug":{onFileOpen:[{pathGlob:"{**/*.ts,**/*.tsx,**/*.js,**/*.jsx,**/*.es6,**/.babelrc}"}]},"ms-edgedevtools.vscode-edge-devtools":{onFileOpen:[{pathGlob:"{**/*.ts,**/*.tsx,**/*.js,**/*.css,**/*.html}"}]},"Ionide.Ionide-fsharp":{onFileOpen:[{pathGlob:"{**/*.fsx,**/*.fsi,**/*.fs,**/*.ml,**/*.mli}"}]},"dbaeumer.vscode-eslint":{onFileOpen:[{pathGlob:"{**/*.js,**/*.jsx,**/*.es6,**/.eslintrc.*,**/.eslintrc,**/.babelrc,**/jsconfig.json}"}]},"bmewburn.vscode-intelephense-client":{onFileOpen:[{pathGlob:"{**/*.php,**/php.ini}"}]},"xdebug.php-debug":{onFileOpen:[{pathGlob:"{**/*.php,**/php.ini}"}]},"rust-lang.rust-analyzer":{onFileOpen:[{pathGlob:"{**/*.rs,**/*.rslib}"}]},"DavidAnson.vscode-markdownlint":{onFileOpen:[{pathGlob:"{**/*.md}"}]},"EditorConfig.EditorConfig":{onFileOpen:[{pathGlob:"{**/.editorconfig}"}]},"HookyQR.beautify":{onFileOpen:[{pathGlob:"{**/.jsbeautifyrc}"}]},"donjayamanne.githistory":{onFileOpen:[{pathGlob:"{**/.gitignore,**/.git}"}]},"eamodio.gitlens":{onFileOpen:[{pathGlob:"{**/.gitignore,**/.git}"}]},"Shopify.ruby-lsp":{onFileOpen:[{pathGlob:"{**/*.rb,**/*.erb,**/*.reek,**/.fasterer.yml,**/ruby-lint.yml,**/.rubocop.yml}"}]},"swiftlang.swift-vscode":{onFileOpen:[{pathGlob:"{**/*.swift,**/*.swiftinterface}",important:!0}]},"DotJoshJohnson.xml":{onFileOpen:[{pathGlob:"{**/*.xml}"}]},"stylelint.vscode-stylelint":{onFileOpen:[{pathGlob:"{**/.stylelintrc,**/stylelint.config.js}"}]},"ms-mssql.mssql":{onFileOpen:[{pathGlob:"{**/*.sql}"}]},"mtxr.sqltools":{onFileOpen:[{pathGlob:"{**/*.sql}"}]},"usqlextpublisher.usql-vscode-ext":{onFileOpen:[{pathGlob:"{**/*.usql}"}]},"ms-vscode.sublime-keybindings":{onFileOpen:[{pathGlob:"{**/.sublime-project,**/.sublime-workspace}"}]},"k--kato.intellij-idea-keybindings":{onFileOpen:[{pathGlob:"{**/.idea}"}]},"christian-kohler.npm-intellisense":{onFileOpen:[{pathGlob:"{**/package.json}"}]},"cake-build.cake-vscode":{onFileOpen:[{pathGlob:"{**/build.cake}"}]},"Angular.ng-template":{onFileOpen:[{pathGlob:"{**/.angular-cli.json,**/angular.json,**/*.ng.html,**/*.ng,**/*.ngml}"}]},"vscjava.vscode-maven":{onFileOpen:[{pathGlob:"**/pom.xml"}]},"ms-azuretools.vscode-azureterraform":{onFileOpen:[{pathGlob:"**/*.tf"}]},"HashiCorp.terraform":{onFileOpen:[{pathGlob:"**/*.tf"}]},"vsciot-vscode.vscode-arduino":{onFileOpen:[{pathGlob:"**/*.ino"}]},"ms-kubernetes-tools.vscode-kubernetes-tools":{onFileOpen:[{pathGlob:"{**/Chart.yaml}"}]},"Oracle.oracledevtools":{onFileOpen:[{pathGlob:"{**/*.sql}"}]},"betterthantomorrow.calva":{onFileOpen:[{pathGlob:"{**/*.clj,**/*.cljs}"}]},"vmware.vscode-boot-dev-pack":{onFileOpen:[{pathGlob:"{**/application.properties}"}]},"GitHub.copilot":{onFileOpen:[{pathGlob:"{**/*.ts,**/*.tsx,**/*.js,**/*.jsx,**/*.py,**/*.go,**/*.rb,**/*.html,**/*.css,**/*.php,**/*.cpp,**/*.vue,**/*.c,**/*.sql,**/*.java,**/*.cs,**/*.rs,**/*.dart,**/*.ps,**/*.ps1,**/*.tex}"}]},"GitHub.copilot-chat":{onSettingsEditorOpen:{descriptionOverride:"GitHub Copilot is an AI-powered coding assistant that helps you write code faster and smarter."}},"GitHub.vscode-github-actions":{onFileOpen:[{pathGlob:"{**/.github/workflows/*.yml}",important:!0}]},"circleci.circleci":{onFileOpen:[{pathGlob:"{**/.circleci/config.yml}"}]},"mechatroner.rainbow-csv":{onFileOpen:[{pathGlob:"**/*.csv",important:!0}]},"tomoki1207.pdf":{onFileOpen:[{pathGlob:"**/*.pdf",important:!0}]},"Redis.redis-for-vscode":{onFileOpen:[{pathGlob:"{**/redis.*,**/redis-server.*,**/redis_*,**/redisinsight.*}",important:!0}]},"SonarSource.sonarlint-vscode":{onFileOpen:[{pathGlob:"{**/sonar-project.properties,**/sonarcloud.properties,**/sonarlint.*}",important:!0}]}},keymapExtensionTips:["vscodevim.vim","ms-vscode.sublime-keybindings","ms-vscode.atom-keybindings","ms-vscode.brackets-keybindings","ms-vscode.vs-keybindings","ms-vscode.notepadplusplus-keybindings","k--kato.intellij-idea-keybindings","lfs.vscode-emacs-friendly","alphabotsec.vscode-eclipse-keybindings","alefragnani.delphi-keybindings"],languageExtensionTips:["ms-python.python","ms-vscode.cpptools-extension-pack","ms-dotnettools.csdevkit","ms-toolsai.jupyter","vscjava.vscode-java-pack","ecmel.vscode-html-css","vue.volar","bmewburn.vscode-intelephense-client","dsznajder.es7-react-js-snippets","golang.go","ms-vscode.powershell","dart-code.dart-code","rust-lang.rust-analyzer","Shopify.ruby-lsp","GitHub.copilot"],configBasedExtensionTips:{git:{configPath:".git/config",configName:"Git",recommendations:{"github.vscode-pull-request-github":{name:"GitHub Pull Request",contentPattern:"^\\s*url\\s*=\\s*https:\\/\\/github\\.com.*$"},"eamodio.gitlens":{name:"GitLens"}}},devContainer:{configPath:".devcontainer/devcontainer.json",configName:"Dev Container",recommendations:{"ms-vscode-remote.remote-containers":{name:"Dev Containers",important:!0}}},maven:{configPath:"pom.xml",configName:"Maven",recommendations:{"vscjava.vscode-java-pack":{name:"Java",important:!0,isExtensionPack:!0,whenNotInstalled:["ASF.apache-netbeans-java","Oracle.oracle-java"]},"vmware.vscode-boot-dev-pack":{name:"Spring Boot Extension Pack",isExtensionPack:!0}}},gradle:{configPath:"build.gradle",configName:"Gradle",recommendations:{"vscjava.vscode-java-pack":{name:"Java",important:!0,isExtensionPack:!0,whenNotInstalled:["ASF.apache-netbeans-java","Oracle.oracle-java"]}}},"github-pull-request":{configPath:".vscode/.github-pull-request.rec",configName:"GitHub",configScheme:"vscode-vfs",recommendations:{"github.vscode-pull-request-github":{name:"GitHub Pull Request",important:!0}}},"pyproject-formatter":{configPath:"pyproject.toml",configName:"Python Formatter",recommendations:{"ms-python.black-formatter":{name:"Black Formatter",contentPattern:'(^\\s*\\[\\[?\\s*"?tool"?\\s*\\.\\s*"?black"?\\s*[\\].])|("black\\s*["[(<=>!~;@])'},"ms-python.autopep8":{name:"Autopep8",contentPattern:'(^\\s*\\[\\[?\\s*"?tool"?\\s*\\.\\s*"?autopep8"?\\s*[\\].])|("autopep8\\s*["[(<=>!~;@])'}}},"pep8-formatter":{configPath:".pep8",configName:"Python Formatter",recommendations:{"ms-python.autopep8":{name:"Autopep8"}}},"python-setup-cgf-formatter":{configPath:"setup.cfg",configName:"Python Formatter",recommendations:{"ms-python.autopep8":{name:"Autopep8",contentPattern:"^\\[pep8\\]"}}},"tox-ini-formatter":{configPath:"tox.ini",configName:"Python Formatter",recommendations:{"ms-python.autopep8":{name:"Autopep8",contentPattern:"^\\[pep8\\]"}}},"pyproject-linter":{configPath:"pyproject.toml",configName:"Python Linter",recommendations:{"ms-python.pylint":{name:"Pylint",contentPattern:'(^\\s*\\[\\[?\\s*"?tool"?\\s*\\.\\s*"?pylint"?\\s*[\\].])|("pylint\\s*["[(<=>!~;@])'},"charliermarsh.ruff":{name:"Ruff",contentPattern:'(^\\s*\\[\\[?\\s*"?tool"?\\s*\\.\\s*"?ruff"?\\s*[\\].])|("ruff\\s*["[(<=>!~;@])'},"ms-python.mypy-type-checker":{name:"Mypy Type Checker",contentPattern:'(^\\s*\\[\\[?\\s*"?tool"?\\s*\\.\\s*"?mypy"?\\s*[\\].])|("mypy\\s*["[(<=>!~;@])'},"ms-python.flake8":{name:"Flake8",contentPattern:'(^\\s*\\[\\[?\\s*"?tool"?\\s*\\.\\s*"?flake8"?\\s*[\\].])|("flake8\\s*["[(<=>!~;@])'}}},".pylintrc-linter":{configPath:".pylintrc",configName:"Python Linter",recommendations:{"ms-python.pylint":{name:"Pylint"}}},"pylintrc-linter":{configPath:"pylintrc",configName:"Python Linter",recommendations:{"ms-python.pylint":{name:"Pylint"}}},"mypy-ini-linter":{configPath:".mypy.ini",configName:"Python Linter",recommendations:{"ms-python.mypy-type-checker":{name:"Mypy Type Checker"}}},"tox-ini-linter":{configPath:"tox.ini",configName:"Python Linter",recommendations:{"ms-python.flake8":{name:"Flake8",contentPattern:"^\\[flake8\\]"}}},".flake8-linter":{configPath:".flake8",configName:"Python Linter",recommendations:{"ms-python.flake8":{name:"Flake8"}}},"python-setup-cgf-linter":{configPath:"setup.cfg",configName:"Python Linter",recommendations:{"ms-python.flake8":{name:"Flake8",contentPattern:"^\\[flake8\\]"}}}},exeBasedExtensionTips:{az:{friendlyName:"Azure CLI",windowsPath:"%ProgramFiles(x86)%\\Microsoft SDKs\\Azure\\CLI2\\wbin\\az.cmd",recommendations:{"ms-vscode.vscode-node-azure-pack":{name:"Azure Tools"},"ms-azuretools.vscode-azure-github-copilot":{name:"GitHub Copilot for Azure"}}},azd:{friendlyName:"Azure Dev CLI",windowsPath:"%USERPROFILE%\\AppData\\Local\\Programs\\Azure Dev CLI\\azd.exe",recommendations:{"ms-vscode.vscode-node-azure-pack":{name:"Azure Tools"},"ms-azuretools.vscode-azure-github-copilot":{name:"GitHub Copilot for Azure"}}},"azd-user":{friendlyName:"Azure Dev CLI",windowsPath:"%ProgramFiles%\\Azure Dev CLI\\azd.exe",recommendations:{"ms-vscode.vscode-node-azure-pack":{name:"Azure Tools"},"ms-azuretools.vscode-azure-github-copilot":{name:"GitHub Copilot for Azure"}}},"azure-powershell":{friendlyName:"Azure PowerShell",windowsPath:"%USERPROFILE%\\.Azure",recommendations:{"ms-vscode.vscode-node-azure-pack":{name:"Azure Tools"}}},heroku:{friendlyName:"Heroku CLI",windowsPath:"%ProgramFiles%\\Heroku\\bin\\heroku.cmd",recommendations:{"ms-azuretools.vscode-azureappservice":{name:"Azure App Service"},"pkosta2005.heroku-command":{name:"heroku-cli"}}},mongo:{friendlyName:"Mongo",windowsPath:"%ProgramFiles%\\MongoDB\\Server\\3.6\\bin\\mongod.exe",recommendations:{"ms-azuretools.vscode-cosmosdb":{name:"Azure Databases"}}},serverless:{friendlyName:"Serverless framework",windowsPath:"%APPDATA%\\npm\\serverless.cmd",recommendations:{"ms-azuretools.vscode-azurefunctions":{name:"Azure Functions"}}},func:{friendlyName:"Azure Function SDK",windowsPath:"%APPDATA%\\npm\\func.cmd",recommendations:{"ms-azuretools.vscode-azurefunctions":{name:"Azure Functions"}}},mysql:{friendlyName:"MySQL",windowsPath:"%ProgramFiles%\\MySQL\\MySQL Server 8.0\\bin\\mysqld.exe",recommendations:{"mtxr.sqltools":{name:"SQLTools"}}},postgres:{friendlyName:"PostgreSQL",windowsPath:"%ProgramFiles%\\PostgreSQL\\11\\bin\\psql.exe",recommendations:{"ms-ossdata.vscode-postgresql":{name:"PostgreSQL"},"mtxr.sqltools":{name:"SQLTools"}}},sqlcmd:{friendlyName:"SQL CLI",recommendations:{"ms-mssql.mssql":{name:"SQL Server (mssql)"}}},now:{friendlyName:"Now CLI",windowsPath:"%APPDATA%\\npm\\now.cmd",recommendations:{"ms-azuretools.vscode-azureappservice":{name:"Azure App Service"},"ms-azuretools.vscode-containers":{name:"Docker"}}},docker:{friendlyName:"Docker",windowsPath:"%ProgramFiles%\\Docker\\Docker\\Resources\\bin\\docker.exe",recommendations:{"ms-azuretools.vscode-containers":{name:"Docker",important:!0,whenNotInstalled:["ms-azuretools.vscode-docker"]},"ms-vscode-remote.remote-containers":{name:"Dev Containers",important:!0},"ms-kubernetes-tools.vscode-kubernetes-tools":{name:"Kubernetes"}}},kubectl:{friendlyName:"Kubernetes",windowsPath:"%ProgramFiles%\\Docker\\Docker\\Resources\\bin\\kubectl.exe",recommendations:{"ms-azuretools.vscode-containers":{name:"Docker"},"ms-kubernetes-tools.vscode-kubernetes-tools":{name:"Kubernetes"},"ms-vscode-remote.remote-containers":{name:"Dev Containers"}}},ng:{friendlyName:"Angular CLI",windowsPath:"%APPDATA%\\npmexit\\ng.cmd",recommendations:{"johnpapa.Angular2":{name:"Angular Snippets"}}},"create-react-app":{friendlyName:"Create React App",windowsPath:"%APPDATA%\\npm\\create-react-app.cmd",recommendations:{"msjsdiag.vscode-react-native":{name:"React Native Tools"}}},"react-native":{friendlyName:"React Native",windowsPath:"%APPDATA%\\npm\\react-native-cli",recommendations:{"msjsdiag.vscode-react-native":{name:"React Native Tools"}}},p4:{friendlyName:"Perforce",recommendations:{"slevesque.perforce":{name:"Perforce for VS Code"}}},hg:{friendlyName:"Mercurial",recommendations:{"mrcrowl.hg":{name:"Hg"}}},git:{friendlyName:"Git",windowsPath:"%ProgramFiles%\\Git\\git-bash.exe",recommendations:{"eamodio.gitlens":{name:"GitLens"}}},svn:{friendlyName:"Subversion",windowsPath:"%ProgramFiles%\\TortoiseSVN\\bin\\TortoiseProc.exe",recommendations:{"johnstoncode.svn-scm":{name:"SVN"}}},subl:{friendlyName:"Sublime",windowsPath:"%ProgramFiles%\\Sublime Text3\\sublime_text.exe",recommendations:{"ms-vscode.sublime-keybindings":{name:"Sublime Text Keymap and Settings Importer"}}},atom:{friendlyName:"Atom",windowsPath:"%USERPROFILE%\\AppData\\Local\\atom\\bin\\atom.cmd",recommendations:{"ms-vscode.atom-keybindings":{name:"Atom Keymap"}}},brackets:{friendlyName:"Brackets",windowsPath:"%ProgramFiles(x86)%\\Brackets\\Brackets.exe",recommendations:{"ms-vscode.brackets-keybindings":{name:"Brackets Keymap"}}},notepadplusplus:{friendlyName:"Notepad++",windowsPath:"%ProgramFiles%\\Notepad++\\Notepad++.exe",recommendations:{"ms-vscode.notepadplusplus-keybindings":{name:"Notepad++ keymap"}}},vi:{friendlyName:"VIM",windowsPath:"%ProgramFiles(x86)%\\Vim\\vim80\\gvim.exe",recommendations:{"vscodevim.vim":{name:"Vim"}}},mvn:{friendlyName:"Maven",recommendations:{"vscjava.vscode-java-pack":{name:"Java",important:!0,isExtensionPack:!0,whenNotInstalled:["ASF.apache-netbeans-java","Oracle.oracle-java"]}}},gradle:{friendlyName:"Gradle",recommendations:{"vscjava.vscode-java-pack":{name:"Java",important:!0,isExtensionPack:!0,whenNotInstalled:["ASF.apache-netbeans-java","Oracle.oracle-java"]}}},ollama:{friendlyName:"Ollama",windowsPath:"%USERPROFILE%\\AppData\\Local\\Programs\\Ollama\\ollama.exe",recommendations:{"ms-windows-ai-studio.windows-ai-studio":{name:"AI Toolkit for Visual Studio Code"}}},"Microsoft Edge":{friendlyName:"Microsoft Edge",windowsPath:"%USERPROFILE%\\AppData\\Local\\Microsoft\\Edge\\Application\\msedge.exe",recommendations:{"ms-edgedevtools.vscode-edge-devtools":{name:"Microsoft Edge Developer Tools"}}},"Microsoft Edge Dev":{friendlyName:"Microsoft Edge Dev",windowsPath:"%USERPROFILE%\\AppData\\Local\\Microsoft\\Edge Dev\\Application\\msedge.exe",recommendations:{"ms-edgedevtools.vscode-edge-devtools":{name:"Microsoft Edge Developer Tools"}}},"Microsoft Edge Beta":{friendlyName:"Microsoft Edge Beta",windowsPath:"%USERPROFILE%\\AppData\\Local\\Microsoft\\Edge Beta\\Application\\msedge.exe",recommendations:{"ms-edgedevtools.vscode-edge-devtools":{name:"Microsoft Edge Developer Tools"}}},"Microsoft Edge Canary":{friendlyName:"Microsoft Edge Canary",windowsPath:"%USERPROFILE%\\AppData\\Local\\Microsoft\\Edge SxS\\Application\\msedge.exe",recommendations:{"ms-edgedevtools.vscode-edge-devtools":{name:"Microsoft Edge Developer Tools"}}},"Mozilla Firefox (x86)":{friendlyName:"Mozilla Firefox",windowsPath:"%ProgramFiles(x86)%\\Mozilla Firefox\\firefox.exe",recommendations:{"firefox-devtools.vscode-firefox-debug":{name:"Debugger for Firefox"}}},"Mozilla Firefox Developer Edition (x86)":{friendlyName:"Mozilla Firefox Developer Edition",windowsPath:"%ProgramFiles(x86)%\\Firefox Developer Edition\\firefox.exe",recommendations:{"firefox-devtools.vscode-firefox-debug":{name:"Debugger for Firefox"}}},"Mozilla Firefox":{friendlyName:"Mozilla Firefox",windowsPath:"%ProgramFiles%\\Mozilla Firefox\\firefox.exe",recommendations:{"firefox-devtools.vscode-firefox-debug":{name:"Debugger for Firefox"}}},"Mozilla Firefox Developer Edition":{friendlyName:"Mozilla Firefox Developer Edition",windowsPath:"%ProgramFiles%\\Firefox Developer Edition\\firefox.exe",recommendations:{"firefox-devtools.vscode-firefox-debug":{name:"Debugger for Firefox"}}},cordova:{friendlyName:"Cordova",windowsPath:"%APPDATA%\\npm\\cordova",recommendations:{"msjsdiag.cordova-tools":{name:"Cordova Tools"}}},gcloud:{friendlyName:"Google GCloud CLI",windowsPath:"%ProgramFiles(x86)%\\Google\\Cloud SDK\\google-cloud-sdk\\bin\\gcloud.cmd",recommendations:{"GoogleCloudTools.cloudcode":{name:"Cloud Code"}}},skaffold:{friendlyName:"Skaffold Code to Cluster",recommendations:{"ms-azuretools.vscode-containers":{name:"Docker"},"ms-kubernetes-tools.vscode-kubernetes-tools":{name:"Kubernetes"}}},minikube:{friendlyName:"MiniKube Local Kubernetes Cluster",recommendations:{"ms-azuretools.vscode-containers":{name:"Docker"},"ms-kubernetes-tools.vscode-kubernetes-tools":{name:"Kubernetes"},"ms-vscode-remote.remote-containers":{name:"Dev Containers"}}},podman:{friendlyName:"Podman",recommendations:{"ms-vscode-remote.remote-containers":{name:"Dev Containers"}}},wsl:{friendlyName:"Windows Subsystem for Linux (WSL)",windowsPath:"%WINDIR%\\system32\\lxss\\LxssManager.dll",recommendations:{"ms-vscode-remote.remote-wsl":{name:"WSL"}}}},webExtensionTips:["tyriar.luna-paint","codespaces-contrib.codeswing","ms-vscode.vscode-github-issue-notebooks","esbenp.prettier-vscode","hediet.vscode-drawio"],virtualWorkspaceExtensionTips:{"vscode-vfs":{friendlyName:"Remote Repositories",extensionId:"ms-vscode.remote-repositories",startEntry:{helpLink:"https://aka.ms/vscode-remote/remote-repositories",startConnectLabel:"Remote Repository",startCommand:"remoteHub.continueOn.openRepository",priority:5}}},remoteExtensionTips:{wsl:{friendlyName:"WSL",extensionId:"ms-vscode-remote.remote-wsl",supportedPlatforms:["Windows","Web"],startEntry:{helpLink:"https://aka.ms/vscode-remote/wsl",startConnectLabel:"WSL",startCommand:"remote-wsl.connect",priority:3}},"ssh-remote":{friendlyName:"Remote - SSH",extensionId:"ms-vscode-remote.remote-ssh",supportedPlatforms:["Windows","Linux","Mac"],startEntry:{helpLink:"https://aka.ms/vscode-remote/ssh",startConnectLabel:"SSH ",startCommand:"opensshremotes.openEmptyWindowInCurrentWindow",priority:1}},"dev-container":{friendlyName:"Dev Containers",extensionId:"ms-vscode-remote.remote-containers",supportedPlatforms:["Windows","Linux","Mac"],startEntry:{helpLink:"https://aka.ms/vscode-remote/containers",startConnectLabel:"Dev Container",startCommand:"remote-containers.reopenInContainer",priority:2}},"attached-container":{friendlyName:"Dev Containers",extensionId:"ms-vscode-remote.remote-containers"},codespaces:{friendlyName:"GitHub Codespaces",extensionId:"github.codespaces",startEntry:{helpLink:"https://aka.ms/vscode-remote-codespaces",startConnectLabel:"GitHub Codespace ",startCommand:"github.codespaces.connect",priority:4}},tunnel:{friendlyName:"Remote - Tunnels",extensionId:"ms-vscode.remote-server",startEntry:{helpLink:"https://aka.ms/remote-tunnels-doc",startConnectLabel:"Tunnel",startCommand:"remote-tunnels.connectCurrentWindowToTunnel",priority:0}},amlext:{friendlyName:"Azure Machine Learning",extensionId:"ms-toolsai.vscode-ai-remote"}},commandPaletteSuggestedCommandIds:["workbench.action.files.openFile","workbench.action.files.openFileFolder","workbench.action.files.openFolder","workbench.action.remote.showMenu","editor.action.formatDocument","editor.action.commentLine","workbench.action.tasks.runTask","workbench.action.openSettings2","workbench.action.selectTheme","workbench.action.openWalkthrough","workbench.action.openIssueReporter"],extensionKeywords:{md:["Markdown"],js:["JavaScript"],jsx:["JavaScript"],es6:["JavaScript"],html:["Html"],ts:["TypeScript"],tsx:["TypeScript"],css:["CSS"],scss:["SASS"],txt:["Text"],php:["PHP"],php3:["PHP"],php4:["PHP"],ph3:["PHP"],ph4:["PHP"],xml:["XML"],py:["Python"],pyc:["Python"],pyd:["Python"],pyo:["Python"],pyw:["Python"],pyz:["Python"],java:["Java"],class:["Java"],jar:["Java"],c:["c","objective c","objective-c"],m:["objective c","objective-c"],mm:["objective c","objective-c"],cpp:["cpp","c plus plus","c","c++"],cc:["cpp","c plus plus","c","c++"],cxx:["cpp","c plus plus","c++"],hh:["cpp","c plus plus","c++"],hpp:["cpp","c++"],h:["cpp","c plus plus","c++","c","objective c","objective-c"],sql:["sql"],sh:["bash"],bash:["bash"],zsh:["bash","zshell"],cs:["c#","csharp"],csproj:["c#","csharp"],sln:["c#","csharp"],go:["go"],sty:["latex"],tex:["latex"],ps:["powershell"],ps1:["powershell"],rs:["rust"],rslib:["rust"],hs:["haskell"],lhs:["haskell"],scm:["scheme"],ss:["scheme"],clj:["clojure"],cljs:["clojure"],cljc:["clojure"],edn:["clojure"],erl:["erlang"],hrl:["erlang"],scala:["scala"],sc:["scala"],pl:["perl"],pm:["perl"],t:["perl"],pod:["perl"],groovy:["groovy"],swift:["swift"],rb:["ruby"],rbw:["ruby"],jl:["julia"],f:["fortran"],for:["fortran"],f90:["fortran"],f95:["fortran"],coffee:["CoffeeScript"],litcoffee:["CoffeeScript"],yaml:["yaml"],yml:["yaml"],dart:["dart"],json:["json"]},extensionAllowedBadgeProviders:["api.travis-ci.com","app.fossa.io","badge.buildkite.com","badge.fury.io","badgen.net","badges.frapsoft.com","badges.gitter.im","cdn.travis-ci.com","ci.appveyor.com","circleci.com","cla.opensource.microsoft.com","codacy.com","codeclimate.com","codecov.io","coveralls.io","david-dm.org","deepscan.io","dev.azure.com","docs.rs","flat.badgen.net","gitlab.com","godoc.org","goreportcard.com","img.shields.io","isitmaintained.com","marketplace.visualstudio.com","nodesecurity.io","opencollective.com","snyk.io","travis-ci.com","travis-ci.org","visualstudio.com","vsmarketplacebadge.apphb.com"],extensionAllowedBadgeProvidersRegex:["^https:\\/\\/github\\.com\\/[^/]+\\/[^/]+\\/(actions\\/)?workflows\\/.*badge\\.svg"],crashReporter:{productName:"VSCode",companyName:"Microsoft"},appCenter:{"win32-x64":"appcenter://code-insiders?aid=f047834f-d0e1-4aef-8870-5805ee483b2d","win32-arm64":"appcenter://code-insiders?aid=fb1c1670-432e-43dc-a88e-8c5ed7293213","linux-x64":"appcenter://code-insiders?aid=a04472a4-f4ea-4854-bf12-95bb0f2dd01a",darwin:"appcenter://code-insiders?aid=5e4c15d3-0a3c-4c3b-a294-2a40850616a2","darwin-arm64":"appcenter://code-insiders?aid=d6599f8f-6aee-4013-b47c-1e1269faa19a","darwin-universal":"appcenter://code-insiders?aid=9198980f-302c-4143-9ddf-29914b57be2e"},enableTelemetry:!0,aiConfig:{ariaKey:"5bbf946d11a54f6783919c455abaddaf-fd62977b-c92d-4714-a45d-649d06980372-7168"},msftInternalDomains:["redmond.corp.microsoft.com","northamerica.corp.microsoft.com","fareast.corp.microsoft.com","ntdev.corp.microsoft.com","wingroup.corp.microsoft.com","southpacific.corp.microsoft.com","wingroup.windeploy.ntdev.microsoft.com","ddnet.microsoft.com","europe.corp.microsoft.com"],documentationUrl:"https://go.microsoft.com/fwlink/?LinkID=533484#vscode",serverDocumentationUrl:"https://aka.ms/vscode-server-doc",releaseNotesUrl:"https://go.microsoft.com/fwlink/?LinkId=724002",keyboardShortcutsUrlMac:"https://go.microsoft.com/fwlink/?linkid=832143",keyboardShortcutsUrlLinux:"https://go.microsoft.com/fwlink/?linkid=832144",keyboardShortcutsUrlWin:"https://go.microsoft.com/fwlink/?linkid=832145",introductoryVideosUrl:"https://go.microsoft.com/fwlink/?linkid=832146",tipsAndTricksUrl:"https://go.microsoft.com/fwlink/?linkid=852118",newsletterSignupUrl:"https://www.research.net/r/vsc-newsletter",youTubeUrl:"https://aka.ms/vscode-youtube",requestFeatureUrl:"https://go.microsoft.com/fwlink/?LinkID=533482",reportIssueUrl:"https://github.com/Microsoft/vscode/issues/new",reportMarketplaceIssueUrl:"https://github.com/microsoft/vsmarketplace/issues/new",licenseUrl:"https://go.microsoft.com/fwlink/?LinkID=761088",serverLicenseUrl:"https://aka.ms/vscode-server-license",privacyStatementUrl:"https://go.microsoft.com/fwlink/?LinkId=521839",showTelemetryOptOut:!0,npsSurveyUrl:"https://aka.ms/vscode-nps",checksumFailMoreInfoUrl:"https://go.microsoft.com/fwlink/?LinkId=828886",electronRepository:"Microsoft/vscode-electron-prebuilt",nodejsRepository:"Microsoft/vscode-node",settingsSearchUrl:"https://bingsettingssearch.trafficmanager.net/api/Search",surveys:[{surveyId:"cpp.1",surveyUrl:"https://www.research.net/r/VBVV6C6",languageId:"cpp",editCount:10,userProbability:.15},{surveyId:"java.2",surveyUrl:"https://www.research.net/r/vscodejava",languageId:"java",editCount:10,userProbability:.3},{surveyId:"javascript.1",surveyUrl:"https://www.research.net/r/vscode-js",languageId:"javascript",editCount:10,userProbability:.05},{surveyId:"typescript.1",surveyUrl:"https://www.research.net/r/vscode-ts",languageId:"typescript",editCount:10,userProbability:.05},{surveyId:"csharp.1",surveyUrl:"https://www.research.net/r/8KGJ9V8",languageId:"csharp",editCount:10,userProbability:.1}],extensionsEnabledWithApiProposalVersion:["GitHub.copilot-chat","ms-vscode.vscode-commander","GitHub.vscode-pull-request-github"],extensionEnabledApiProposals:{"mrleemurray.theme-2026":["css"],"ms-azuretools.vscode-containers":["authenticationChallenges"],"ms-azuretools.vscode-azureresourcegroups":["authenticationChallenges"],"ms-azuretools.vscode-azure-github-copilot":["authenticationChallenges"],"ms-azuretools.vscode-dev-azurecloudshell":["contribEditSessions","authenticationChallenges"],"ms-toolsai.vscode-ai":["authenticationChallenges"],"TeamsDevApp.vscode-ai-foundry":["authenticationChallenges"],"ms-vscode.vscode-selfhost-test-provider":["testObserver","testRelatedCode"],"VisualStudioExptTeam.vscodeintellicode-completions":["inlineCompletionsAdditions"],"ms-vsliveshare.vsliveshare":["contribMenuBarHome","contribShareMenu","contribStatusBarItems","diffCommand","documentFiltersExclusive","fileSearchProvider","findTextInFiles","notebookLiveShare","terminalDimensions","terminalDataWriteEvent","textSearchProvider"],"ms-vscode.js-debug":["portsAttributes","findTextInFiles","workspaceTrust","tunnels"],"ms-toolsai.vscode-ai-remote":["resolvers","authenticationChallenges"],"ms-python.python":["codeActionAI","contribEditorContentMenu","quickPickSortByLabel","portsAttributes","testObserver","quickPickItemTooltip","terminalDataWriteEvent","terminalExecuteCommandEvent","notebookReplDocument","notebookVariableProvider","terminalShellEnv"],"ms-python.vscode-python-envs":["terminalShellEnv","terminalDataWriteEvent","taskExecutionTerminal"],"ms-dotnettools.dotnet-interactive-vscode":["notebookMessaging"],"GitHub.codespaces":["contribEditSessions","contribMenuBarHome","contribRemoteHelp","contribViewsRemote","resolvers","tunnels","terminalDataWriteEvent","treeViewReveal","notebookKernelSource"],"ms-vscode.azure-repos":["extensionRuntime","fileSearchProvider","textSearchProvider"],"ms-vscode.remote-repositories":["canonicalUriProvider","contribEditSessions","contribRemoteHelp","contribMenuBarHome","contribViewsRemote","contribViewsWelcome","contribShareMenu","documentFiltersExclusive","editSessionIdentityProvider","extensionRuntime","fileSearchProvider","quickPickSortByLabel","workspaceTrust","shareProvider","scmActionButton","scmSelectedProvider","scmValidation","textSearchProvider","timeline"],"ms-vscode-remote.remote-wsl":["resolvers","contribRemoteHelp","contribViewsRemote","telemetry"],"ms-vscode-remote.remote-ssh":["resolvers","tunnels","terminalDataWriteEvent","contribRemoteHelp","contribViewsRemote","telemetry"],"ms-vscode.remote-server":["resolvers","tunnels","contribViewsWelcome"],"ms-vscode.remote-explorer":["contribRemoteHelp","contribViewsRemote","extensionsAny"],"ms-vscode-remote.remote-containers":["contribEditSessions","resolvers","portsAttributes","tunnels","workspaceTrust","terminalDimensions","contribRemoteHelp","contribViewsRemote"],"ms-vscode.js-debug-nightly":["portsAttributes","findTextInFiles","workspaceTrust","tunnels"],"ms-vscode.lsif-browser":["documentFiltersExclusive"],"ms-vscode.vscode-speech":["speech"],"GitHub.vscode-pull-request-github":["activeComment","chatContextProvider","chatParticipantAdditions","chatParticipantPrivate","chatSessionsProvider","codiconDecoration","codeActionRanges","commentingRangeHint","commentReactor","commentReveal","commentsDraftState","commentThreadApplicability","contribAccessibilityHelpContent","contribCommentEditorActionsMenu","contribCommentPeekContext","contribCommentThreadAdditionalMenu","contribCommentsViewThreadMenus","contribEditorContentMenu","contribMultiDiffEditorMenus","contribShareMenu","diffCommand","languageModelToolResultAudience","markdownAlertSyntax","quickDiffProvider","remoteCodingAgents","shareProvider","tabInputMultiDiff","tabInputTextMerge","tokenInformation","treeItemMarkdownLabel","treeViewMarkdownMessage"],"GitHub.copilot":["inlineCompletionsAdditions","interactive","terminalDataWriteEvent","devDeviceId"],"GitHub.copilot-nightly":["inlineCompletionsAdditions","interactive","terminalDataWriteEvent","devDeviceId"],"GitHub.copilot-chat":["agentSessionsWorkspace","interactive","terminalDataWriteEvent","terminalExecuteCommandEvent","terminalSelection","terminalQuickFixProvider","chatParticipantAdditions","defaultChatParticipant","embeddings","chatProvider","mappedEditsProvider","aiRelatedInformation","aiSettingsSearch","codeActionAI","findTextInFiles","findTextInFiles2","textSearchProvider","textSearchProvider2","activeComment","commentReveal","contribSourceControlInputBoxMenu","contribCommentEditorActionsMenu","contribCommentThreadAdditionalMenu","contribCommentsViewThreadMenus","contribChatEditorInlineGutterMenu","extensionAffinity","newSymbolNamesProvider","findFiles2","chatReferenceDiagnostic","extensionsAny","authLearnMore","testObserver","aiTextSearchProvider","documentFiltersExclusive","chatParticipantPrivate","contribDebugCreateConfiguration","inlineCompletionsAdditions","chatReferenceBinaryData","languageModelSystem","languageModelCapabilities","languageModelThinkingPart","languageModelToolSupportsModel","chatStatusItem","taskProblemMatcherStatus","contribLanguageModelToolSets","textDocumentChangeReason","resolvers","taskExecutionTerminal","dataChannels","chatSessionsProvider","devDeviceId","contribEditorContentMenu","tokenInformation","chatPromptFiles","mcpServerDefinitions","tabInputMultiDiff","workspaceTrust","chatHooks","environmentPower"],"GitHub.remotehub":["contribRemoteHelp","contribMenuBarHome","contribViewsRemote","contribViewsWelcome","documentFiltersExclusive","extensionRuntime","fileSearchProvider","quickPickSortByLabel","workspaceTrust","scmSelectedProvider","scmValidation","textSearchProvider","timeline"],"ms-python.vscode-pylance":["terminalShellEnv","portsAttributes","codeActionAI"],"ms-python.debugpy":["contribViewsWelcome","debugVisualization","portsAttributes"],"ms-toolsai.jupyter-renderers":["contribNotebookStaticPreloads"],"ms-toolsai.jupyter":["notebookDeprecated","notebookMessaging","notebookMime","portsAttributes","quickPickSortByLabel","notebookKernelSource","interactiveWindow","notebookControllerAffinityHidden","contribNotebookStaticPreloads","quickPickItemTooltip","notebookExecution","notebookCellExecution","notebookVariableProvider","notebookReplDocument"],"donjayamanne.kusto":["notebookVariableProvider"],"ms-toolsai.tensorboard":["portsAttributes"],"dbaeumer.vscode-eslint":[],"ms-vscode.azure-sphere-tools-ui":["tunnels"],"ms-azuretools.vscode-azureappservice":["terminalDataWriteEvent"],"ms-vscode.anycode":["extensionsAny"],"ms-vscode.cpptools":["terminalDataWriteEvent","chatParticipantAdditions"],"ms-dotnettools.csdevkit":["inlineCompletionsAdditions"],"ms-dotnettools.vscodeintellicode-csharp":["inlineCompletionsAdditions"],"ms-dotnettools.vscode-dotnet-modernize":["chatParticipantAdditions","chatPromptFiles"],"microsoft-IsvExpTools.powerplatform-vscode":["fileSearchProvider","textSearchProvider"],"microsoft-IsvExpTools.powerplatform-vscode-preview":["fileSearchProvider","textSearchProvider"],"TeamsDevApp.ms-teams-vscode-extension":["chatParticipantAdditions","languageModelSystem"],"ms-vscode.vscode-copilot-vision":["chatReferenceBinaryData","codeActionAI"],"ms-autodev.vscode-autodev":["chatParticipantAdditions"],"codetrek.haystack-search":["fileSearchProvider","textSearchProvider2"],"vscjava.vscode-java-upgrade":["chatParticipantAdditions","chatParticipantPrivate"],"FoundryLocal.foundry-local-chat":["chatProvider"],"Microsoft.foundry-local-chat":["chatProvider"],"ms-wmcp.windows-mcp-server-extension":["mcpToolDefinitions"],"openai.chatgpt":["languageModelProxy","chatSessionsProvider"],"TypeScriptTeam.native-preview":["editorHoverVerbosityLevel","multiDocumentHighlightProvider"],"ms-vscode.vscode-eng-codereview":["chatContextProvider"]},tasConfig:{endpoint:"https://default.exp-tas.com/vscode/ab",telemetryEventName:"query-expfeature",assignmentContextTelemetryPropertyName:"abexp.assignmentcontext"},extensionKind:{"Shan.code-settings-sync":["ui"],"shalldie.background":["ui"],"techer.open-in-browser":["ui"],"CoenraadS.bracket-pair-colorizer-2":["ui"],"CoenraadS.bracket-pair-colorizer":["ui","workspace"],"hiro-sun.vscode-emacs":["ui","workspace"],"hnw.vscode-auto-open-markdown-preview":["ui","workspace"],"wayou.vscode-todo-highlight":["ui","workspace"],"aaron-bond.better-comments":["ui","workspace"],"vscodevim.vim":["ui"],"ollyhayes.colmak-vim":["ui"]},extensionPointExtensionKind:{typescriptServerPlugins:["workspace"]},extensionSyncedKeys:{"ritwickdey.liveserver":["liveServer.setup.version"]},extensionVirtualWorkspacesSupport:{"esbenp.prettier-vscode":{default:!1},"msjsdiag.debugger-for-chrome":{default:!1},"redhat.java":{default:!1},"HookyQR.beautify":{default:!1},"ritwickdey.LiveServer":{default:!1},"VisualStudioExptTeam.vscodeintellicode":{default:!1},"octref.vetur":{default:!1},"formulahendry.code-runner":{default:!1},"xdebug.php-debug":{default:!1},"ms-mssql.mssql":{default:!1},"christian-kohler.path-intellisense":{default:!1},"eg2.tslint":{default:!1},"eg2.vscode-npm-script":{default:!1},"donjayamanne.githistory":{default:!1},"Zignd.html-css-class-completion":{default:!1},"christian-kohler.npm-intellisense":{default:!1},"EditorConfig.EditorConfig":{default:!1},"austin.code-gnu-global":{default:!1},"johnpapa.Angular2":{default:!1},"ms-vscode.vscode-typescript-tslint-plugin":{default:!1},"DotJoshJohnson.xml":{default:!1},"techer.open-in-browser":{default:!1},"tht13.python":{default:!1},"bmewburn.vscode-intelephense-client":{default:!1},"Angular.ng-template":{default:!1},"xdebug.php-pack":{default:!1},"dbaeumer.jshint":{default:!1},"yzhang.markdown-all-in-one":{default:!1},"Dart-Code.flutter":{default:!1},"streetsidesoftware.code-spell-checker":{default:!1},"rebornix.Ruby":{default:!1},"ms-vscode.sublime-keybindings":{default:!1},"mitaki28.vscode-clang":{default:!1},"steoates.autoimport":{default:!1},"donjayamanne.python-extension-pack":{default:!1},"shd101wyy.markdown-preview-enhanced":{default:!1},"mikestead.dotenv":{default:!1},"pranaygp.vscode-css-peek":{default:!1},"ikappas.phpcs":{default:!1},"platformio.platformio-ide":{default:!1},"jchannon.csharpextensions":{default:!1},"gruntfuggly.todo-tree":{default:!1}},linkProtectionTrustedDomains:["https://*.visualstudio.com","https://*.microsoft.com","https://aka.ms","https://*.gallerycdn.vsassets.io","https://*.github.com","https://login.microsoftonline.com","https://*.vscode.dev","https://*.github.dev","https://gh.io","https://portal.azure.com","https://raw.githubusercontent.com","https://private-user-images.githubusercontent.com","https://avatars.githubusercontent.com","https://auth.openai.com"],trustedExtensionAuthAccess:{github:["vscode.github","github.remotehub","ms-vscode.remote-server","github.vscode-pull-request-github","github.codespaces","github.copilot","github.copilot-chat","ms-vsliveshare.vsliveshare","ms-azuretools.vscode-azure-github-copilot"],"github-enterprise":["vscode.github","github.remotehub","ms-vscode.remote-server","github.vscode-pull-request-github","github.codespaces","github.copilot","github.copilot-chat","ms-vsliveshare.vsliveshare","ms-azuretools.vscode-azure-github-copilot"],microsoft:["github.copilot-chat","ms-vscode.azure-repos","ms-vscode.remote-server","ms-vsliveshare.vsliveshare","ms-azuretools.vscode-azure-github-copilot","ms-azuretools.vscode-azureresourcegroups","ms-azuretools.vscode-dev-azurecloudshell","ms-edu.vscode-learning","ms-toolsai.vscode-ai","ms-toolsai.vscode-ai-remote"],"microsoft-sovereign-cloud":["ms-vscode.azure-repos","ms-vscode.remote-server","ms-vsliveshare.vsliveshare","ms-azuretools.vscode-azure-github-copilot","ms-azuretools.vscode-azureresourcegroups","ms-azuretools.vscode-dev-azurecloudshell","ms-edu.vscode-learning","ms-toolsai.vscode-ai","ms-toolsai.vscode-ai-remote"],"__GitHub.copilot-chat":["ms-azuretools.vscode-azure-github-copilot","github.vscode-pull-request-github"]},trustedExtensionProtocolHandlers:["vscode.git","vscode.github-authentication","vscode.microsoft-authentication","github.vscode-pull-request-github"],authClientIdMetadataUrl:"https://vscode.dev/oauth/client-metadata.json",inheritAuthAccountPreference:{"github.copilot":["github.copilot-chat"]},auth:{loginUrl:"https://login.microsoftonline.com/common/oauth2/authorize",tokenUrl:"https://login.microsoftonline.com/common/oauth2/token",redirectUrl:"https://vscode-redirect.azurewebsites.net/",clientId:"aebc6443-996d-45c2-90f0-388ff96faa56"},"configurationSync.store":{url:"https://vscode-sync-insiders.trafficmanager.net/",stableUrl:"https://vscode-sync.trafficmanager.net/",insidersUrl:"https://vscode-sync-insiders.trafficmanager.net/",canSwitch:!0,authenticationProviders:{github:{scopes:["user:email"]},microsoft:{scopes:["openid","profile","email","offline_access"]}}},enableSyncingProfiles:!0,"editSessions.store":{url:"https://vscode-sync.trafficmanager.net/",authenticationProviders:{microsoft:{scopes:["openid","profile","email","offline_access"]},github:{scopes:["user:email"]}}},tunnelServerQualities:{stable:{serverApplicationName:"code-server"},exploration:{serverApplicationName:"code-server-exploration"},insider:{serverApplicationName:"code-server-insiders"}},tunnelApplicationName:"code-tunnel-insiders",tunnelApplicationConfig:{editorWebUrl:"https://insiders.vscode.dev",extension:{friendlyName:"Remote - Tunnels",extensionId:"ms-vscode.remote-server"},authenticationProviders:{github:{scopes:["user:email","read:org"]},microsoft:{scopes:["46da2f7e-b5ef-422a-88d4-2a7f9de6a0b2/.default","profile","openid"]}}},win32TunnelServiceMutex:"vscodeinsiders-tunnelservice",win32TunnelMutex:"vscodeinsiders-tunnel",aiGeneratedWorkspaceTrust:{title:"This workspace was generated by GitHub Copilot",checkboxText:"Trust the contents of all files in this workspace",trustOption:"Yes, I trust the contents",dontTrustOption:"No, I don't trust the contents",startupTrustRequestLearnMore:"If you don't trust the contents of the files generated by GitHub Copilot, we recommend continuing in restricted mode. See [our docs](https://aka.ms/vscode-workspace-trust) to learn more. "},defaultChatAgent:{extensionId:"GitHub.copilot",chatExtensionId:"GitHub.copilot-chat",chatExtensionOutputId:"GitHub.copilot-chat.GitHub Copilot Chat.log",chatExtensionOutputExtensionStateCommand:"github.copilot.debug.extensionState",documentationUrl:"https://aka.ms/github-copilot-overview",termsStatementUrl:"https://aka.ms/github-copilot-terms-statement",privacyStatementUrl:"https://aka.ms/github-copilot-privacy-statement",skusDocumentationUrl:"https://aka.ms/github-copilot-plans",publicCodeMatchesUrl:"https://aka.ms/github-copilot-match-public-code",manageSettingsUrl:"https://aka.ms/github-copilot-settings",managePlanUrl:"https://aka.ms/github-copilot-manage-plan",manageOverageUrl:"https://aka.ms/github-copilot-manage-overage",upgradePlanUrl:"https://aka.ms/github-copilot-upgrade-plan",signUpUrl:"https://aka.ms/github-sign-up",provider:{default:{id:"github",name:"GitHub"},enterprise:{id:"github-enterprise",name:"GHE.com"},google:{id:"google",name:"Google"},apple:{id:"apple",name:"Apple"}},providerUriSetting:"github-enterprise.uri",providerScopes:[["read:user","user:email","repo","workflow"],["user:email"],["read:user"]],entitlementUrl:"https://api.github.com/copilot_internal/user",entitlementSignupLimitedUrl:"https://api.github.com/copilot_internal/subscribe_limited_user",chatQuotaExceededContext:"github.copilot.chat.quotaExceeded",completionsQuotaExceededContext:"github.copilot.completions.quotaExceeded",walkthroughCommand:"github.copilot.open.walkthrough",completionsMenuCommand:"github.copilot.toggleStatusMenu",completionsRefreshTokenCommand:"github.copilot.signIn",chatRefreshTokenCommand:"github.copilot.refreshToken",generateCommitMessageCommand:"github.copilot.git.generateCommitMessage",resolveMergeConflictsCommand:"github.copilot.git.resolveMergeConflicts",completionsAdvancedSetting:"github.copilot.advanced",completionsEnablementSetting:"github.copilot.enable",nextEditSuggestionsSetting:"github.copilot.nextEditSuggestions.enabled",tokenEntitlementUrl:"https://api.github.com/copilot_internal/v2/token",mcpRegistryDataUrl:"https://api.github.com/copilot/mcp_registry"},chatParticipantRegistry:"https://main.vscode-cdn.net/extensions/chat.json",remoteDefaultExtensionsIfInstalledLocally:["GitHub.copilot","GitHub.copilot-chat","GitHub.vscode-pull-request-github"],extensionConfigurationPolicy:{"github.copilot.nextEditSuggestions.enabled":{name:"CopilotNextEditSuggestions",minimumVersion:"1.99"},"github.copilot.chat.reviewSelection.enabled":{name:"CopilotReviewSelection",minimumVersion:"1.104"},"github.copilot.chat.reviewAgent.enabled":{name:"CopilotReviewAgent",minimumVersion:"1.104"}},win32ContextMenu:{x64:{clsid:"799F4F7E-5934-4001-A74C-E207F44F05B8"},arm64:{clsid:"7D34756D-32DD-4EE6-B99F-2691C0DAD875"}},chatSessionRecommendations:[{extensionId:"openai.chatgpt",extensionName:"Codex - OpenAI's coding agent",displayName:"Codex Agent",name:"codex",description:"Codex is OpenAI's coding agent that helps you write, review, and ship code faster.",postInstallCommand:"chatgpt.newCodexPanel"},{extensionId:"GitHub.copilot-chat",extensionName:"GitHub Copilot Chat",displayName:"Background Agent",name:"cli",description:"Delegate tasks to a background agent.",postInstallCommand:"workbench.action.chat.openNewSessionSidebar.copilotcli"},{extensionId:"GitHub.copilot-chat",extensionName:"GitHub Copilot Chat",displayName:"Cloud Agent",name:"cloud",description:"Delegate tasks to the GitHub Copilot Cloud Agent. The agent works asynchronously in the cloud to implement changes, iterates via chat, and can create or update pull requests as needed.",postInstallCommand:"workbench.action.chat.openNewSessionSidebar.copilot-cloud-agent"}],builtInExtensions:[{name:"ms-vscode.js-debug-companion",version:"1.1.3",sha256:"7380a890787452f14b2db7835dfa94de538caf358ebc263f9d46dd68ac52de93",repo:"https://github.com/microsoft/vscode-js-debug-companion",metadata:{id:"99cb0b7f-7354-4278-b8da-6cc79972169d",publisherId:{publisherId:"5f5636e7-69ed-4afe-b5d6-8d231fb3d3ee",publisherName:"ms-vscode",displayName:"Microsoft",flags:"verified"},publisherDisplayName:"Microsoft"}},{name:"ms-vscode.js-debug",version:"1.105.0",sha256:"0c45b90342e8aafd4ff2963b4006de64208ca58c2fd01fea7a710fe61dcfd12a",repo:"https://github.com/microsoft/vscode-js-debug",metadata:{id:"25629058-ddac-4e17-abba-74678e126c5d",publisherId:{publisherId:"5f5636e7-69ed-4afe-b5d6-8d231fb3d3ee",publisherName:"ms-vscode",displayName:"Microsoft",flags:"verified"},publisherDisplayName:"Microsoft"}},{name:"ms-vscode.vscode-js-profile-table",version:"1.0.10",sha256:"7361748ddf9fd09d8a2ed1f2a2d7376a2cf9aae708692820b799708385c38e08",repo:"https://github.com/microsoft/vscode-js-profile-visualizer",metadata:{id:"7e52b41b-71ad-457b-ab7e-0620f1fc4feb",publisherId:{publisherId:"5f5636e7-69ed-4afe-b5d6-8d231fb3d3ee",publisherName:"ms-vscode",displayName:"Microsoft",flags:"verified"},publisherDisplayName:"Microsoft"}}],version:"1.110.0-insider",commit:"a2860d1c314872c0c8c436647d10856fdd15f2bc",date:"2026-02-20T17:03:41.182Z"},Object.keys(Gt).length===0&&Object.assign(Gt,{version:"1.104.0-dev",nameShort:"Code - OSS Dev",nameLong:"Code - OSS Dev",applicationName:"code-oss",dataFolderName:".vscode-oss",urlProtocol:"code-oss",reportIssueUrl:"https://github.com/microsoft/vscode/issues/new",licenseName:"MIT",licenseUrl:"https://github.com/microsoft/vscode/blob/main/LICENSE.txt",serverLicenseUrl:"https://github.com/microsoft/vscode/blob/main/LICENSE.txt",defaultChatAgent:{extensionId:"GitHub.copilot",chatExtensionId:"GitHub.copilot-chat",provider:{default:{id:"github",name:"GitHub"},enterprise:{id:"github-enterprise",name:"GitHub Enterprise"}},providerScopes:[]}});var qt=Gt;var Kt={Configuration:"base.contributions.configuration"};var wa={properties:{},patternProperties:{}},Pa={properties:{},patternProperties:{}},Ta={properties:{},patternProperties:{}},Ra={properties:{},patternProperties:{}},Ca={properties:{},patternProperties:{}},_a={properties:{},patternProperties:{}},Ko={properties:{},patternProperties:{}},Vn="vscode://schemas/settings/resourceLanguage";var ka=it.as(Eu.JSONContribution),Pu=class extends _{constructor(){super();this.registeredConfigurationDefaults=[];this.overrideIdentifiers=new Set;this._onDidSchemaChange=this._register(new R);this.onDidSchemaChange=this._onDidSchemaChange.event;this._onDidUpdateConfiguration=this._register(new R);this.onDidUpdateConfiguration=this._onDidUpdateConfiguration.event;this.configurationDefaultsOverrides=new Map,this.defaultLanguageConfigurationOverridesNode={id:"defaultOverrides",title:m(1831,null),properties:{}},this.configurationContributors=[this.defaultLanguageConfigurationOverridesNode],this.resourceLanguageSettingsSchema={properties:{},patternProperties:{},additionalProperties:!0,allowTrailingCommas:!0,allowComments:!0},this.configurationProperties={},this.policyConfigurations=new Map,this.excludedConfigurationProperties={},ka.registerSchema(Vn,this.resourceLanguageSettingsSchema),this.registerOverridePropertyPatternKey()}registerConfiguration(e,r=!0){return this.registerConfigurations([e],r),e}registerConfigurations(e,r=!0){let n=new Set;this.doRegisterConfigurations(e,r,n),ka.registerSchema(Vn,this.resourceLanguageSettingsSchema),this._onDidSchemaChange.fire(),this._onDidUpdateConfiguration.fire({properties:n})}deregisterConfigurations(e){let r=new Set;this.doDeregisterConfigurations(e,r),ka.registerSchema(Vn,this.resourceLanguageSettingsSchema),this._onDidSchemaChange.fire(),this._onDidUpdateConfiguration.fire({properties:r})}updateConfigurations({add:e,remove:r}){let n=new Set;this.doDeregisterConfigurations(r,n),this.doRegisterConfigurations(e,!1,n),ka.registerSchema(Vn,this.resourceLanguageSettingsSchema),this._onDidSchemaChange.fire(),this._onDidUpdateConfiguration.fire({properties:n})}registerDefaultConfigurations(e){let r=new Set;this.doRegisterDefaultConfigurations(e,r),this._onDidSchemaChange.fire(),this._onDidUpdateConfiguration.fire({properties:r,defaultsOverrides:!0})}doRegisterDefaultConfigurations(e,r){this.registeredConfigurationDefaults.push(...e);let n=[];for(let{overrides:o,source:s}of e)for(let a in o){r.add(a);let l=this.configurationDefaultsOverrides.get(a)??this.configurationDefaultsOverrides.set(a,{configurationDefaultOverrides:[]}).get(a),c=o[a];if(l.configurationDefaultOverrides.push({value:c,source:s}),Mr.test(a)){let u=this.mergeDefaultConfigurationsForOverrideIdentifier(a,c,s,l.configurationDefaultOverrideValue);if(!u)continue;l.configurationDefaultOverrideValue=u,this.updateDefaultOverrideProperty(a,u,s),n.push(...wi(a))}else{let u=this.mergeDefaultConfigurationsForConfigurationProperty(a,c,s,l.configurationDefaultOverrideValue);if(!u)continue;l.configurationDefaultOverrideValue=u;let p=this.configurationProperties[a];p&&(this.updatePropertyDefaultValue(a,p),this.updateSchema(a,p))}}this.doRegisterOverrideIdentifiers(n)}deregisterDefaultConfigurations(e){let r=new Set;this.doDeregisterDefaultConfigurations(e,r),this._onDidSchemaChange.fire(),this._onDidUpdateConfiguration.fire({properties:r,defaultsOverrides:!0})}doDeregisterDefaultConfigurations(e,r){for(let n of e){let o=this.registeredConfigurationDefaults.indexOf(n);o!==-1&&this.registeredConfigurationDefaults.splice(o,1)}for(let{overrides:n,source:o}of e)for(let s in n){let a=this.configurationDefaultsOverrides.get(s);if(!a)continue;let l=a.configurationDefaultOverrides.findIndex(c=>o?c.source?.id===o.id:c.value===n[s]);if(l!==-1){if(a.configurationDefaultOverrides.splice(l,1),a.configurationDefaultOverrides.length===0&&this.configurationDefaultsOverrides.delete(s),Mr.test(s)){let c;for(let u of a.configurationDefaultOverrides)c=this.mergeDefaultConfigurationsForOverrideIdentifier(s,u.value,u.source,c);c&&!Hs(c.value)?(a.configurationDefaultOverrideValue=c,this.updateDefaultOverrideProperty(s,c,o)):(this.configurationDefaultsOverrides.delete(s),delete this.configurationProperties[s],delete this.defaultLanguageConfigurationOverridesNode.properties[s])}else{let c;for(let p of a.configurationDefaultOverrides)c=this.mergeDefaultConfigurationsForConfigurationProperty(s,p.value,p.source,c);a.configurationDefaultOverrideValue=c;let u=this.configurationProperties[s];u&&(this.updatePropertyDefaultValue(s,u),this.updateSchema(s,u))}r.add(s)}}this.updateOverridePropertyPatternKey()}updateDefaultOverrideProperty(e,r,n){let o={section:{id:this.defaultLanguageConfigurationOverridesNode.id,title:this.defaultLanguageConfigurationOverridesNode.title,order:this.defaultLanguageConfigurationOverridesNode.order,extensionInfo:this.defaultLanguageConfigurationOverridesNode.extensionInfo},type:"object",default:r.value,description:m(1830,null,Df(e)),$ref:Vn,defaultDefaultValue:r.value,source:n,defaultValueSource:n};this.configurationProperties[e]=o,this.defaultLanguageConfigurationOverridesNode.properties[e]=o}mergeDefaultConfigurationsForOverrideIdentifier(e,r,n,o){let s=o?.value||{},a=o?.source??new Map;if(!(a instanceof Map)){console.error("objectConfigurationSources is not a Map");return}for(let l of Object.keys(r)){let c=r[l];if(he(c)&&(ut(s[l])||he(s[l]))){if(s[l]={...s[l]??{},...c},n)for(let p in c)a.set(`${l}.${p}`,n)}else s[l]=c,n?a.set(l,n):a.delete(l)}return{value:s,source:a}}mergeDefaultConfigurationsForConfigurationProperty(e,r,n,o){let s=this.configurationProperties[e],a=o?.value??s?.defaultDefaultValue,l=n;if(he(r)&&(s!==void 0&&s.type==="object"||s===void 0&&(ut(a)||he(a)))){if(l=o?.source??new Map,!(l instanceof Map)){console.error("defaultValueSource is not a Map");return}for(let u in r)n&&l.set(`${e}.${u}`,n);r={...he(a)?a:{},...r}}return{value:r,source:l}}deltaConfiguration(e){let r=!1,n=new Set;e.removedDefaults&&(this.doDeregisterDefaultConfigurations(e.removedDefaults,n),r=!0),e.addedDefaults&&(this.doRegisterDefaultConfigurations(e.addedDefaults,n),r=!0),e.removedConfigurations&&this.doDeregisterConfigurations(e.removedConfigurations,n),e.addedConfigurations&&this.doRegisterConfigurations(e.addedConfigurations,!1,n),this._onDidSchemaChange.fire(),this._onDidUpdateConfiguration.fire({properties:n,defaultsOverrides:r})}notifyConfigurationSchemaUpdated(...e){this._onDidSchemaChange.fire()}registerOverrideIdentifiers(e){this.doRegisterOverrideIdentifiers(e),this._onDidSchemaChange.fire()}doRegisterOverrideIdentifiers(e){for(let r of e)this.overrideIdentifiers.add(r);this.updateOverridePropertyPatternKey()}doRegisterConfigurations(e,r,n){e.forEach(o=>{this.validateAndRegisterProperties(o,r,o.extensionInfo,o.restrictedProperties,void 0,n),this.configurationContributors.push(o),this.registerJSONConfiguration(o)})}doDeregisterConfigurations(e,r){let n=o=>{if(o.properties)for(let s in o.properties){r.add(s);let a=this.configurationProperties[s];a?.policy?.name&&this.policyConfigurations.delete(a.policy.name),delete this.configurationProperties[s],this.removeFromSchema(s,o.properties[s])}o.allOf?.forEach(s=>n(s))};for(let o of e){n(o);let s=this.configurationContributors.indexOf(o);s!==-1&&this.configurationContributors.splice(s,1)}}validateAndRegisterProperties(e,r=!0,n,o,s=4,a){s=Oe(e.scope)?s:e.scope;let l=e.properties;if(l)for(let u in l){let p=l[u];if(p.section={id:e.id,title:e.title,order:e.order,extensionInfo:e.extensionInfo},r&&_y(u,p,n?.id)){delete l[u];continue}p.source=n,p.defaultDefaultValue=l[u].default,this.updatePropertyDefaultValue(u,p),Mr.test(u)?p.scope=void 0:(p.scope=Oe(p.scope)?s:p.scope,p.restricted=Oe(p.restricted)?!!o?.includes(u):p.restricted),p.experiment?p.tags?.some(v=>v.toLowerCase()==="onexp")||(p.tags=p.tags??[],p.tags.push("onExP")):p.tags?.some(v=>v.toLowerCase()==="onexp")&&(console.error(`Invalid tag 'onExP' found for property '${u}'. Please use 'experiment' property instead.`),p.experiment={mode:"startup"});let f=l[u].hasOwnProperty("included")&&!l[u].included,g=l[u].policy?.name;f?(this.excludedConfigurationProperties[u]=l[u],g&&(this.policyConfigurations.set(g,u),a.add(u)),delete l[u]):(a.add(u),g&&this.policyConfigurations.set(g,u),this.configurationProperties[u]=l[u],!l[u].deprecationMessage&&l[u].markdownDeprecationMessage&&(l[u].deprecationMessage=l[u].markdownDeprecationMessage))}let c=e.allOf;if(c)for(let u of c)this.validateAndRegisterProperties(u,r,n,o,s,a)}getConfigurations(){return this.configurationContributors}getConfigurationProperties(){return this.configurationProperties}getPolicyConfigurations(){return this.policyConfigurations}getExcludedConfigurationProperties(){return this.excludedConfigurationProperties}getRegisteredDefaultConfigurations(){return[...this.registeredConfigurationDefaults]}getConfigurationDefaultsOverrides(){let e=new Map;for(let[r,n]of this.configurationDefaultsOverrides)n.configurationDefaultOverrideValue&&e.set(r,n.configurationDefaultOverrideValue);return e}registerJSONConfiguration(e){let r=n=>{let o=n.properties;if(o)for(let a in o)this.updateSchema(a,o[a]);n.allOf?.forEach(r)};r(e)}updateSchema(e,r){switch(wa.properties[e]=r,r.scope){case 1:Pa.properties[e]=r;break;case 2:Ra.properties[e]=r;break;case 3:Ta.properties[e]=r;break;case 7:Ca.properties[e]=r;break;case 4:_a.properties[e]=r;break;case 5:Ko.properties[e]=r;break;case 6:Ko.properties[e]=r,this.resourceLanguageSettingsSchema.properties[e]=r;break}}removeFromSchema(e,r){switch(delete wa.properties[e],r.scope){case 1:delete Pa.properties[e];break;case 2:delete Ra.properties[e];break;case 3:delete Ta.properties[e];break;case 7:delete Ca.properties[e];break;case 4:delete _a.properties[e];break;case 5:case 6:delete Ko.properties[e],delete this.resourceLanguageSettingsSchema.properties[e];break}}updateOverridePropertyPatternKey(){for(let e of this.overrideIdentifiers.values()){let r=`[${e}]`,n={type:"object",description:m(1832,null),errorMessage:m(1833,null),$ref:Vn};this.updatePropertyDefaultValue(r,n),wa.properties[r]=n,Pa.properties[r]=n,Ta.properties[r]=n,Ra.properties[r]=n,Ca.properties[r]=n,_a.properties[r]=n,Ko.properties[r]=n}}registerOverridePropertyPatternKey(){let e={type:"object",description:m(1832,null),errorMessage:m(1833,null),$ref:Vn};wa.patternProperties[mn]=e,Pa.patternProperties[mn]=e,Ta.patternProperties[mn]=e,Ra.patternProperties[mn]=e,Ca.patternProperties[mn]=e,_a.patternProperties[mn]=e,Ko.patternProperties[mn]=e,this._onDidSchemaChange.fire()}updatePropertyDefaultValue(e,r){let n=this.configurationDefaultsOverrides.get(e)?.configurationDefaultOverrideValue,o,s;n&&(!r.disallowConfigurationDefault||!n.source)&&(o=n.value,s=n.source),ut(o)&&(o=r.defaultDefaultValue,s=void 0),ut(o)&&(o=Cy(r.type)),r.default=o,r.defaultValueSource=s}},tm="\\[([^\\]]+)\\]",em=new RegExp(tm,"g"),mn=`^(${tm})+$`,Mr=new RegExp(mn);function wi(i){let t=[];if(Mr.test(i)){let e=em.exec(i);for(;e?.length;){let r=e[1].trim();r&&t.push(r),e=em.exec(i)}}return Mt(t)}function rm(i){return i.reduce((t,e)=>`${t}[${e}]`,"")}function Cy(i){switch(Array.isArray(i)?i[0]:i){case"boolean":return!1;case"integer":case"number":return 0;case"string":return"";case"array":return[];case"object":return{};default:return null}}var Da=new Pu;it.add(Kt.Configuration,Da);function _y(i,t,e){return i.trim()?Mr.test(i)?m(1829,null,i):Da.getConfigurationProperties()[i]!==void 0&&(!e||!ky.has(e.toLowerCase()))?m(1827,null,i):t.policy?.name&&Da.getPolicyConfigurations().get(t.policy?.name)!==void 0?m(1826,null,i,t.policy?.name,Da.getPolicyConfigurations().get(t.policy?.name)):null:m(1828,null)}var ky=new Set(qt.defaultChatAgent?[qt.defaultChatAgent.extensionId,qt.defaultChatAgent.chatExtensionId].map(i=>i.toLowerCase()):[]);var Tu=class{constructor(){this._value="";this._pos=0}reset(t){return this._value=t,this._pos=0,this}next(){return this._pos+=1,this}hasNext(){return this._pos<this._value.length-1}cmp(t){let e=t.charCodeAt(0),r=this._value.charCodeAt(this._pos);return e-r}value(){return this._value[this._pos]}},Ru=class{constructor(t=!0){this._caseSensitive=t}reset(t){return this._value=t,this._from=0,this._to=0,this.next()}hasNext(){return this._to<this._value.length}next(){this._from=this._to;let t=!0;for(;this._to<this._value.length;this._to++)if(this._value.charCodeAt(this._to)===46)if(t)this._from++;else break;else t=!1;return this}cmp(t){return this._caseSensitive?la(t,this._value,0,t.length,this._from,this._to):Un(t,this._value,0,t.length,this._from,this._to)}value(){return this._value.substring(this._from,this._to)}},La=class{constructor(t=!0,e=!0){this._splitOnBackslash=t;this._caseSensitive=e}reset(t){this._from=0,this._to=0,this._value=t,this._valueLen=t.length;for(let e=t.length-1;e>=0;e--,this._valueLen--){let r=this._value.charCodeAt(e);if(!(r===47||this._splitOnBackslash&&r===92))break}return this.next()}hasNext(){return this._to<this._valueLen}next(){this._from=this._to;let t=!0;for(;this._to<this._valueLen;this._to++){let e=this._value.charCodeAt(this._to);if(e===47||this._splitOnBackslash&&e===92)if(t)this._from++;else break;else t=!1}return this}cmp(t){return this._caseSensitive?la(t,this._value,0,t.length,this._from,this._to):Un(t,this._value,0,t.length,this._from,this._to)}value(){return this._value.substring(this._from,this._to)}};var Cu=class{constructor(t,e){this._ignorePathCasing=t;this._ignoreQueryAndFragment=e;this._states=[];this._stateIdx=0}reset(t){return this._value=t,this._states=[],this._value.scheme&&this._states.push(1),this._value.authority&&this._states.push(2),this._value.path&&(this._pathIterator=new La(!1,!this._ignorePathCasing(t)),this._pathIterator.reset(t.path),this._pathIterator.value()&&this._states.push(3)),this._ignoreQueryAndFragment(t)||(this._value.query&&this._states.push(4),this._value.fragment&&this._states.push(5)),this._stateIdx=0,this}next(){return this._states[this._stateIdx]===3&&this._pathIterator.hasNext()?this._pathIterator.next():this._stateIdx+=1,this}hasNext(){return this._states[this._stateIdx]===3&&this._pathIterator.hasNext()||this._stateIdx<this._states.length-1}cmp(t){if(this._states[this._stateIdx]===1)return fi(t,this._value.scheme);if(this._states[this._stateIdx]===2)return fi(t,this._value.authority);if(this._states[this._stateIdx]===3)return this._pathIterator.cmp(t);if(this._states[this._stateIdx]===4)return Uo(t,this._value.query);if(this._states[this._stateIdx]===5)return Uo(t,this._value.fragment);throw new Error}value(){if(this._states[this._stateIdx]===1)return this._value.scheme;if(this._states[this._stateIdx]===2)return this._value.authority;if(this._states[this._stateIdx]===3)return this._pathIterator.value();if(this._states[this._stateIdx]===4)return this._value.query;if(this._states[this._stateIdx]===5)return this._value.fragment;throw new Error}},Qr=class i{static{this.Val=Symbol("undefined_placeholder")}static wrap(t){return t===void 0?i.Val:t}static unwrap(t){return t===i.Val?void 0:t}},Pi=class{constructor(){this.height=1;this.value=void 0;this.key=void 0;this.left=void 0;this.mid=void 0;this.right=void 0}isEmpty(){return!this.left&&!this.mid&&!this.right&&this.value===void 0}rotateLeft(){let t=this.right;return this.right=t.left,t.left=this,this.updateHeight(),t.updateHeight(),t}rotateRight(){let t=this.left;return this.left=t.right,t.right=this,this.updateHeight(),t.updateHeight(),t}updateHeight(){this.height=1+Math.max(this.heightLeft,this.heightRight)}balanceFactor(){return this.heightRight-this.heightLeft}get heightLeft(){return this.left?.height??0}get heightRight(){return this.right?.height??0}};var Qt=class i{static forUris(t=()=>!1,e=()=>!1){return new i(new Cu(t,e))}static forPaths(t=!1){return new i(new La(void 0,!t))}static forStrings(){return new i(new Tu)}static forConfigKeys(){return new i(new Ru)}constructor(t){this._iter=t}clear(){this._root=void 0}fill(t,e){if(e){let r=e.slice(0);Tc(r);for(let n of r)this.set(n,t)}else{let r=t.slice(0);Tc(r);for(let n of r)this.set(n[0],n[1])}}set(t,e){let r=this._iter.reset(t),n;this._root||(this._root=new Pi,this._root.segment=r.value());let o=[];for(n=this._root;;){let a=r.cmp(n.segment);if(a>0)n.left||(n.left=new Pi,n.left.segment=r.value()),o.push([-1,n]),n=n.left;else if(a<0)n.right||(n.right=new Pi,n.right.segment=r.value()),o.push([1,n]),n=n.right;else if(r.hasNext())r.next(),n.mid||(n.mid=new Pi,n.mid.segment=r.value()),o.push([0,n]),n=n.mid;else break}let s=Qr.unwrap(n.value);n.value=Qr.wrap(e),n.key=t;for(let a=o.length-1;a>=0;a--){let l=o[a][1];l.updateHeight();let c=l.balanceFactor();if(c<-1||c>1){let u=o[a][0],p=o[a+1][0];if(u===1&&p===1)o[a][1]=l.rotateLeft();else if(u===-1&&p===-1)o[a][1]=l.rotateRight();else if(u===1&&p===-1)l.right=o[a+1][1]=o[a+1][1].rotateRight(),o[a][1]=l.rotateLeft();else if(u===-1&&p===1)l.left=o[a+1][1]=o[a+1][1].rotateLeft(),o[a][1]=l.rotateRight();else throw new Error;if(a>0)switch(o[a-1][0]){case-1:o[a-1][1].left=o[a][1];break;case 1:o[a-1][1].right=o[a][1];break;case 0:o[a-1][1].mid=o[a][1];break}else this._root=o[0][1]}}return s}get(t){return Qr.unwrap(this._getNode(t)?.value)}_getNode(t){let e=this._iter.reset(t),r=this._root;for(;r;){let n=e.cmp(r.segment);if(n>0)r=r.left;else if(n<0)r=r.right;else if(e.hasNext())e.next(),r=r.mid;else break}return r}has(t){let e=this._getNode(t);return!(e?.value===void 0&&e?.mid===void 0)}delete(t){return this._delete(t,!1)}deleteSuperstr(t){return this._delete(t,!0)}_delete(t,e){let r=this._iter.reset(t),n=[],o=this._root;for(;o;){let s=r.cmp(o.segment);if(s>0)n.push([-1,o]),o=o.left;else if(s<0)n.push([1,o]),o=o.right;else if(r.hasNext())r.next(),n.push([0,o]),o=o.mid;else break}if(o){if(e?(o.left=void 0,o.mid=void 0,o.right=void 0,o.height=1):(o.key=void 0,o.value=void 0),!o.mid&&!o.value)if(o.left&&o.right){let s=[[1,o]],a=this._min(o.right,s);if(a.key){o.key=a.key,o.value=a.value,o.segment=a.segment;let l=a.right;if(s.length>1){let[u,p]=s[s.length-1];switch(u){case-1:p.left=l;break;case 0:si(!1);case 1:si(!1)}}else o.right=l;let c=this._balanceByStack(s);if(n.length>0){let[u,p]=n[n.length-1];switch(u){case-1:p.left=c;break;case 0:p.mid=c;break;case 1:p.right=c;break}}else this._root=c}}else{let s=o.left??o.right;if(n.length>0){let[a,l]=n[n.length-1];switch(a){case-1:l.left=s;break;case 0:l.mid=s;break;case 1:l.right=s;break}}else this._root=s}this._root=this._balanceByStack(n)??this._root}}_min(t,e){for(;t.left;)e.push([-1,t]),t=t.left;return t}_balanceByStack(t){for(let e=t.length-1;e>=0;e--){let r=t[e][1];r.updateHeight();let n=r.balanceFactor();if(n>1?(r.right.balanceFactor()>=0||(r.right=r.right.rotateRight()),t[e][1]=r.rotateLeft()):n<-1&&(r.left.balanceFactor()<=0||(r.left=r.left.rotateLeft()),t[e][1]=r.rotateRight()),e>0)switch(t[e-1][0]){case-1:t[e-1][1].left=t[e][1];break;case 1:t[e-1][1].right=t[e][1];break;case 0:t[e-1][1].mid=t[e][1];break}else return t[0][1]}}findSubstr(t){let e=this._iter.reset(t),r=this._root,n;for(;r;){let o=e.cmp(r.segment);if(o>0)r=r.left;else if(o<0)r=r.right;else if(e.hasNext())e.next(),n=Qr.unwrap(r.value)||n,r=r.mid;else break}return r&&Qr.unwrap(r.value)||n}findSuperstr(t){return this._findSuperstrOrElement(t,!1)}_findSuperstrOrElement(t,e){let r=this._iter.reset(t),n=this._root;for(;n;){let o=r.cmp(n.segment);if(o>0)n=n.left;else if(o<0)n=n.right;else if(r.hasNext())r.next(),n=n.mid;else return n.mid?this._entries(n.mid):e?Qr.unwrap(n.value):void 0}}hasElementOrSubtree(t){return this._findSuperstrOrElement(t,!0)!==void 0}forEach(t){for(let[e,r]of this)t(r,e)}*[Symbol.iterator](){yield*this._entries(this._root)}_entries(t){let e=[];return this._dfsEntries(t,e),e[Symbol.iterator]()}_dfsEntries(t,e){t&&(t.left&&this._dfsEntries(t.left,e),t.value!==void 0&&e.push([t.key,Qr.unwrap(t.value)]),t.mid&&this._dfsEntries(t.mid,e),t.right&&this._dfsEntries(t.right,e))}_isBalanced(){let t=e=>{if(!e)return!0;let r=e.balanceFactor();return r<-1||r>1?!1:t(e.left)&&t(e.right)};return t(this._root)}};var ee=B("fileService");function Wn(i){return i.create===!0}function Jt(i){return!!(i.capabilities&2)}function nm(i){return!!(i.capabilities&524288)}function zo(i){return!!(i.capabilities&8)}function Ma(i){return!!(i.capabilities&131072)}function im(i){return!!(i.capabilities&262144)}function Xr(i){return!!(i.capabilities&4)}function Fa(i){return!!(i.capabilities&16)}function Oa(i){return Jt(i)?!!(i.capabilities&16384):!1}function _u(i){return Jt(i)?!!(i.capabilities&32768):!1}function om(i){return!!(i.capabilities&65536)}var Ti=class i extends Error{constructor(e,r){super(e);this.code=r}static create(e,r){let n=new i(e.toString(),r);return Dy(n,r),n}};function cr(i,t){return Ti.create(i,t)}function Yr(i){return i||cr(m(2057,null),"Unknown")}function Dy(i,t){return i.name=t?`${t} (FileSystemError)`:"FileSystemError",i}function $o(i){if(!i)return"Unknown";if(i instanceof Ti)return i.code;let t=/^(.+) \(FileSystemError\)$/.exec(i.name);if(!t)return"Unknown";switch(t[1]){case"EntryExists":return"EntryExists";case"EntryIsADirectory":return"EntryIsADirectory";case"EntryNotADirectory":return"EntryNotADirectory";case"EntryNotFound":return"EntryNotFound";case"EntryTooLarge":return"EntryTooLarge";case"EntryWriteLocked":return"EntryWriteLocked";case"NoPermissions":return"NoPermissions";case"Unavailable":return"Unavailable"}return"Unknown"}function Se(i){if(i instanceof Xe)return i.fileOperationResult;switch($o(i)){case"EntryNotFound":return 1;case"EntryIsADirectory":return 0;case"EntryNotADirectory":return 9;case"EntryWriteLocked":return 5;case"NoPermissions":return 6;case"EntryExists":return 4;case"EntryTooLarge":return 7;default:return 10}}var Jr=class{constructor(t,e,r){this.resource=t;this.operation=e;this.target=r}isOperation(t){return this.operation===t}};var Aa=class i{constructor(t,e){this.ignorePathCasing=e;this.correlationId=void 0;this.added=new Ct(()=>{let t=Qt.forUris(()=>this.ignorePathCasing);return t.fill(this.rawAdded.map(e=>[e,!0])),t});this.updated=new Ct(()=>{let t=Qt.forUris(()=>this.ignorePathCasing);return t.fill(this.rawUpdated.map(e=>[e,!0])),t});this.deleted=new Ct(()=>{let t=Qt.forUris(()=>this.ignorePathCasing);return t.fill(this.rawDeleted.map(e=>[e,!0])),t});this.rawAdded=[];this.rawUpdated=[];this.rawDeleted=[];for(let r of t){switch(r.type){case 1:this.rawAdded.push(r.resource);break;case 0:this.rawUpdated.push(r.resource);break;case 2:this.rawDeleted.push(r.resource);break}this.correlationId!==i.MIXED_CORRELATION&&(typeof r.cId=="number"?this.correlationId===void 0?this.correlationId=r.cId:this.correlationId!==r.cId&&(this.correlationId=i.MIXED_CORRELATION):this.correlationId!==void 0&&(this.correlationId=i.MIXED_CORRELATION))}}static{this.MIXED_CORRELATION=null}contains(t,...e){return this.doContains(t,{includeChildren:!1},...e)}affects(t,...e){return this.doContains(t,{includeChildren:!0},...e)}doContains(t,e,...r){if(!t)return!1;let n=r.length>0;return!!((!n||r.includes(1))&&(this.added.value.get(t)||e.includeChildren&&this.added.value.findSuperstr(t))||(!n||r.includes(0))&&(this.updated.value.get(t)||e.includeChildren&&this.updated.value.findSuperstr(t))||(!n||r.includes(2))&&(this.deleted.value.findSubstr(t)||e.includeChildren&&this.deleted.value.findSuperstr(t)))}gotAdded(){return this.rawAdded.length>0}gotDeleted(){return this.rawDeleted.length>0}gotUpdated(){return this.rawUpdated.length>0}correlates(t){return this.correlationId===t}hasCorrelation(){return typeof this.correlationId=="number"}};function sm(i,t,e){return!i||!t||i===t||t.length>i.length?!1:(t.charAt(t.length-1)!==je&&(t+=je),e?Mn(i,t):i.indexOf(t)===0)}var Xe=class extends Error{constructor(e,r,n){super(e);this.fileOperationResult=r;this.options=n}},Ri=class extends Xe{constructor(e,r,n,o){super(e,r,o);this.fileOperationResult=r;this.size=n}},Ci=class extends Xe{constructor(e,r,n){super(e,2,n);this.stat=r}};var Na="";function ku(i){if(!(typeof i.size!="number"||typeof i.mtime!="number"))return i.mtime.toString(29)+i.size.toString(31)}var Ua=class i{static{this.KB=1024}static{this.MB=i.KB*i.KB}static{this.GB=i.MB*i.KB}static{this.TB=i.GB*i.KB}static formatSize(t){return sn(t)||(t=0),t<i.KB?m(2052,null,t.toFixed(0)):t<i.MB?m(2054,null,(t/i.KB).toFixed(2)):t<i.GB?m(2055,null,(t/i.MB).toFixed(2)):t<i.TB?m(2053,null,(t/i.GB).toFixed(2)):m(2056,null,(t/i.TB).toFixed(2))}};function jo(i){return Object.isFrozen(i)?i:Hf(i)}var Ae=class i{constructor(t,e,r,n,o){this._contents=t;this._keys=e;this._overrides=r;this._raw=n;this.logService=o;this.overrideConfigurations=new Map}static createEmptyModel(t){return new i({},[],[],void 0,t)}get rawConfiguration(){if(!this._rawConfiguration)if(this._raw){let t=(Array.isArray(this._raw)?this._raw:[this._raw]).map(e=>{if(e instanceof i)return e;let r=new Va("",this.logService);return r.parseRaw(e),r.configurationModel});this._rawConfiguration=t.reduce((e,r)=>r===e?r:e.merge(r),t[0])}else this._rawConfiguration=this;return this._rawConfiguration}get contents(){return this._contents}get overrides(){return this._overrides}get keys(){return this._keys}get raw(){if(this._raw&&!(Array.isArray(this._raw)&&this._raw.every(t=>t instanceof i)))return this._raw}isEmpty(){return this._keys.length===0&&Object.keys(this._contents).length===0&&this._overrides.length===0}getValue(t){return t?Wo(this.contents,t):this.contents}inspect(t,e){let r=this;return{get value(){return jo(r.rawConfiguration.getValue(t))},get override(){return e?jo(r.rawConfiguration.getOverrideValue(t,e)):void 0},get merged(){return jo(e?r.rawConfiguration.override(e).getValue(t):r.rawConfiguration.getValue(t))},get overrides(){let n=[];for(let{contents:o,identifiers:s,keys:a}of r.rawConfiguration.overrides){let l=new i(o,a,[],void 0,r.logService).getValue(t);l!==void 0&&n.push({identifiers:s,value:l})}return n.length?jo(n):void 0}}}getOverrideValue(t,e){let r=this.getContentsForOverrideIdentifer(e);return r?t?Wo(r,t):r:void 0}getKeysForOverrideIdentifier(t){let e=[];for(let r of this.overrides)r.identifiers.includes(t)&&e.push(...r.keys);return Mt(e)}getAllOverrideIdentifiers(){let t=[];for(let e of this.overrides)t.push(...e.identifiers);return Mt(t)}override(t){let e=this.overrideConfigurations.get(t);return e||(e=this.createOverrideConfigurationModel(t),this.overrideConfigurations.set(t,e)),e}merge(...t){let e=tr(this.contents),r=tr(this.overrides),n=[...this.keys],o=this._raw?Array.isArray(this._raw)?[...this._raw]:[this._raw]:[this];for(let s of t)if(o.push(...s._raw?Array.isArray(s._raw)?s._raw:[s._raw]:[s]),!s.isEmpty()){this.mergeContents(e,s.contents);for(let a of s.overrides){let[l]=r.filter(c=>xr(c.identifiers,a.identifiers));l?(this.mergeContents(l.contents,a.contents),l.keys.push(...a.keys),l.keys=Mt(l.keys)):r.push(tr(a))}for(let a of s.keys)n.indexOf(a)===-1&&n.push(a)}return new i(e,n,r,!o.length||o.every(s=>s instanceof i)?void 0:o,this.logService)}createOverrideConfigurationModel(t){let e=this.getContentsForOverrideIdentifer(t);if(!e||typeof e!="object"||!Object.keys(e).length)return this;let r={};for(let n of Mt([...Object.keys(this.contents),...Object.keys(e)])){let o=this.contents[n],s=e[n];s&&(typeof o=="object"&&typeof s=="object"?(o=tr(o),this.mergeContents(o,s)):o=s),r[n]=o}return new i(r,this.keys,this.overrides,void 0,this.logService)}mergeContents(t,e){for(let r of Object.keys(e)){if(r in t&&he(t[r])&&he(e[r])){this.mergeContents(t[r],e[r]);continue}t[r]=tr(e[r])}}getContentsForOverrideIdentifer(t){let e=null,r=null,n=o=>{o&&(r?this.mergeContents(r,o):r=tr(o))};for(let o of this.overrides)o.identifiers.length===1&&o.identifiers[0]===t?e=o.contents:o.identifiers.includes(t)&&n(o.contents);return n(e),r}toJSON(){return{contents:this.contents,overrides:this.overrides,keys:this.keys}}addValue(t,e){this.updateValue(t,e,!0)}setValue(t,e){this.updateValue(t,e,!1)}removeValue(t){let e=this.keys.indexOf(t);e!==-1&&(this.keys.splice(e,1),_f(this.contents,t),Mr.test(t)&&this.overrides.splice(this.overrides.findIndex(r=>xr(r.identifiers,wi(t))),1))}updateValue(t,e,r){if(uu(this.contents,t,e,n=>this.logService.error(n)),r=r||this.keys.indexOf(t)===-1,r&&this.keys.push(t),Mr.test(t)){let n=this.contents[t],o=wi(t),s={identifiers:o,keys:Object.keys(n),contents:va(n,l=>this.logService.error(l))},a=this.overrides.findIndex(l=>xr(l.identifiers,o));a!==-1?this.overrides[a]=s:this.overrides.push(s)}}},Va=class{constructor(t,e){this._name=t;this.logService=e;this._raw=null;this._configurationModel=null;this._restrictedConfigurations=[];this._parseErrors=[]}get configurationModel(){return this._configurationModel||Ae.createEmptyModel(this.logService)}get restrictedConfigurations(){return this._restrictedConfigurations}get errors(){return this._parseErrors}parse(t,e){if(!Oe(t)){let r=this.doParseContent(t);this.parseRaw(r,e)}}reparse(t){this._raw&&this.parseRaw(this._raw,t)}parseRaw(t,e){this._raw=t;let{contents:r,keys:n,overrides:o,restricted:s,hasExcludedProperties:a}=this.doParseRaw(t,e);this._configurationModel=new Ae(r,n,o,a?[t]:void 0,this.logService),this._restrictedConfigurations=s||[]}doParseContent(t){let e={},r=null,n=[],o=[],s=[];function a(c){Array.isArray(n)?n.push(c):r!==null&&(n[r]=c)}let l={onObjectBegin:()=>{let c={};a(c),o.push(n),n=c,r=null},onObjectProperty:c=>{r=c},onObjectEnd:()=>{n=o.pop()},onArrayBegin:()=>{let c=[];a(c),o.push(n),n=c,r=null},onArrayEnd:()=>{n=o.pop()},onLiteralValue:a,onError:(c,u,p)=>{s.push({error:c,offset:u,length:p})}};if(t)try{Ii(t,l),e=n[0]||{}}catch(c){this.logService.error(`Error while parsing settings file ${this._name}: ${c}`),this._parseErrors=[c]}return e}doParseRaw(t,e){let r=it.as(Kt.Configuration),n=r.getConfigurationProperties(),o=r.getExcludedConfigurationProperties(),s=this.filter(t,n,o,!0,e);t=s.raw;let a=va(t,u=>this.logService.error(`Conflict in settings file ${this._name}: ${u}`)),l=Object.keys(t),c=this.toOverrides(t,u=>this.logService.error(`Conflict in settings file ${this._name}: ${u}`));return{contents:a,keys:l,overrides:c,restricted:s.restricted,hasExcludedProperties:s.hasExcludedProperties}}filter(t,e,r,n,o){let s=!1;if(!o?.scopes&&!o?.skipRestricted&&!o?.skipUnregistered&&!o?.exclude?.length)return{raw:t,restricted:[],hasExcludedProperties:s};let a={},l=[];for(let c in t)if(Mr.test(c)&&n){let u=this.filter(t[c],e,r,!1,o);a[c]=u.raw,s=s||u.hasExcludedProperties,l.push(...u.restricted)}else{let u=e[c];u?.restricted&&l.push(c),this.shouldInclude(c,u,r,o)?a[c]=t[c]:s=!0}return{raw:a,restricted:l,hasExcludedProperties:s}}shouldInclude(t,e,r,n){if(n.exclude?.includes(t))return!1;if(n.include?.includes(t))return!0;if(n.skipRestricted&&e?.restricted||n.skipUnregistered&&!e)return!1;let o=e??r[t],s=o?typeof o.scope<"u"?o.scope:4:void 0;return s===void 0||n.scopes===void 0?!0:n.scopes.includes(s)}toOverrides(t,e){let r=[];for(let n of Object.keys(t))if(Mr.test(n)){let o={},s=t[n];for(let a in s)o[a]=s[a];r.push({identifiers:wi(n),keys:Object.keys(o),contents:va(o,e)})}return r}},Wa=class extends _{constructor(e,r,n,o,s){super();this.userSettingsResource=e;this.parseOptions=r;this.fileService=o;this.logService=s;this._onDidChange=this._register(new R);this.onDidChange=this._onDidChange.event;this.parser=new Va(this.userSettingsResource.toString(),s),this._register(this.fileService.watch(n.dirname(this.userSettingsResource))),this._register(this.fileService.watch(this.userSettingsResource)),this._register(J.any(J.filter(this.fileService.onDidFilesChange,a=>a.contains(this.userSettingsResource)),J.filter(this.fileService.onDidRunOperation,a=>(a.isOperation(0)||a.isOperation(3)||a.isOperation(1)||a.isOperation(4))&&n.isEqual(a.resource,e)))(()=>this._onDidChange.fire()))}async loadConfiguration(){try{let e=await this.fileService.readFile(this.userSettingsResource);return this.parser.parse(e.value.toString()||"{}",this.parseOptions),this.parser.configurationModel}catch{return Ae.createEmptyModel(this.logService)}}reparse(e){return e&&(this.parseOptions=e),this.parser.reparse(this.parseOptions),this.parser.configurationModel}getRestrictedSettings(){return this.parser.restrictedConfigurations}},Du=class{constructor(t,e,r,n,o,s,a,l,c,u,p,f,g){this.key=t;this.overrides=e;this._value=r;this.overrideIdentifiers=n;this.defaultConfiguration=o;this.policyConfiguration=s;this.applicationConfiguration=a;this.userConfiguration=l;this.localUserConfiguration=c;this.remoteUserConfiguration=u;this.workspaceConfiguration=p;this.folderConfigurationModel=f;this.memoryConfigurationModel=g}get value(){return jo(this._value)}toInspectValue(t){return t?.value!==void 0||t?.override!==void 0||t?.overrides!==void 0?t:void 0}get defaultInspectValue(){return this._defaultInspectValue||(this._defaultInspectValue=this.defaultConfiguration.inspect(this.key,this.overrides.overrideIdentifier)),this._defaultInspectValue}get defaultValue(){return this.defaultInspectValue.merged}get default(){return this.toInspectValue(this.defaultInspectValue)}get policyInspectValue(){return this._policyInspectValue===void 0&&(this._policyInspectValue=this.policyConfiguration?this.policyConfiguration.inspect(this.key):null),this._policyInspectValue}get policyValue(){return this.policyInspectValue?.merged}get policy(){return this.policyInspectValue?.value!==void 0?{value:this.policyInspectValue.value}:void 0}get applicationInspectValue(){return this._applicationInspectValue===void 0&&(this._applicationInspectValue=this.applicationConfiguration?this.applicationConfiguration.inspect(this.key):null),this._applicationInspectValue}get applicationValue(){return this.applicationInspectValue?.merged}get application(){return this.toInspectValue(this.applicationInspectValue)}get userInspectValue(){return this._userInspectValue||(this._userInspectValue=this.userConfiguration.inspect(this.key,this.overrides.overrideIdentifier)),this._userInspectValue}get userValue(){return this.userInspectValue.merged}get user(){return this.toInspectValue(this.userInspectValue)}get userLocalInspectValue(){return this._userLocalInspectValue||(this._userLocalInspectValue=this.localUserConfiguration.inspect(this.key,this.overrides.overrideIdentifier)),this._userLocalInspectValue}get userLocalValue(){return this.userLocalInspectValue.merged}get userLocal(){return this.toInspectValue(this.userLocalInspectValue)}get userRemoteInspectValue(){return this._userRemoteInspectValue||(this._userRemoteInspectValue=this.remoteUserConfiguration.inspect(this.key,this.overrides.overrideIdentifier)),this._userRemoteInspectValue}get userRemoteValue(){return this.userRemoteInspectValue.merged}get userRemote(){return this.toInspectValue(this.userRemoteInspectValue)}get workspaceInspectValue(){return this._workspaceInspectValue===void 0&&(this._workspaceInspectValue=this.workspaceConfiguration?this.workspaceConfiguration.inspect(this.key,this.overrides.overrideIdentifier):null),this._workspaceInspectValue}get workspaceValue(){return this.workspaceInspectValue?.merged}get workspace(){return this.toInspectValue(this.workspaceInspectValue)}get workspaceFolderInspectValue(){return this._workspaceFolderInspectValue===void 0&&(this._workspaceFolderInspectValue=this.folderConfigurationModel?this.folderConfigurationModel.inspect(this.key,this.overrides.overrideIdentifier):null),this._workspaceFolderInspectValue}get workspaceFolderValue(){return this.workspaceFolderInspectValue?.merged}get workspaceFolder(){return this.toInspectValue(this.workspaceFolderInspectValue)}get memoryInspectValue(){return this._memoryInspectValue===void 0&&(this._memoryInspectValue=this.memoryConfigurationModel.inspect(this.key,this.overrides.overrideIdentifier)),this._memoryInspectValue}get memoryValue(){return this.memoryInspectValue.merged}get memory(){return this.toInspectValue(this.memoryInspectValue)}},_i=class i{constructor(t,e,r,n,o,s,a,l,c,u){this._defaultConfiguration=t;this._policyConfiguration=e;this._applicationConfiguration=r;this._localUserConfiguration=n;this._remoteUserConfiguration=o;this._workspaceConfiguration=s;this._folderConfigurations=a;this._memoryConfiguration=l;this._memoryConfigurationByResource=c;this.logService=u;this._workspaceConsolidatedConfiguration=null;this._foldersConsolidatedConfigurations=new be;this._userConfiguration=null}getValue(t,e,r){return this.getConsolidatedConfigurationModel(t,e,r).getValue(t)}updateValue(t,e,r={}){let n;r.resource?(n=this._memoryConfigurationByResource.get(r.resource),n||(n=Ae.createEmptyModel(this.logService),this._memoryConfigurationByResource.set(r.resource,n))):n=this._memoryConfiguration,e===void 0?n.removeValue(t):n.setValue(t,e),r.resource||(this._workspaceConsolidatedConfiguration=null)}inspect(t,e,r){let n=this.getConsolidatedConfigurationModel(t,e,r),o=this.getFolderConfigurationModelForResource(e.resource,r),s=e.resource?this._memoryConfigurationByResource.get(e.resource)||this._memoryConfiguration:this._memoryConfiguration,a=new Set;for(let l of n.overrides)for(let c of l.identifiers)n.getOverrideValue(t,c)!==void 0&&a.add(c);return new Du(t,e,n.getValue(t),a.size?[...a]:void 0,this._defaultConfiguration,this._policyConfiguration.isEmpty()?void 0:this._policyConfiguration,this.applicationConfiguration.isEmpty()?void 0:this.applicationConfiguration,this.userConfiguration,this.localUserConfiguration,this.remoteUserConfiguration,r?this._workspaceConfiguration:void 0,o||void 0,s)}keys(t){let e=this.getFolderConfigurationModelForResource(void 0,t);return{default:this._defaultConfiguration.keys.slice(0),policy:this._policyConfiguration.keys.slice(0),user:this.userConfiguration.keys.slice(0),workspace:this._workspaceConfiguration.keys.slice(0),workspaceFolder:e?e.keys.slice(0):[]}}updateDefaultConfiguration(t){this._defaultConfiguration=t,this._workspaceConsolidatedConfiguration=null,this._foldersConsolidatedConfigurations.clear()}updatePolicyConfiguration(t){this._policyConfiguration=t}updateApplicationConfiguration(t){this._applicationConfiguration=t,this._workspaceConsolidatedConfiguration=null,this._foldersConsolidatedConfigurations.clear()}updateLocalUserConfiguration(t){this._localUserConfiguration=t,this._userConfiguration=null,this._workspaceConsolidatedConfiguration=null,this._foldersConsolidatedConfigurations.clear()}updateRemoteUserConfiguration(t){this._remoteUserConfiguration=t,this._userConfiguration=null,this._workspaceConsolidatedConfiguration=null,this._foldersConsolidatedConfigurations.clear()}updateWorkspaceConfiguration(t){this._workspaceConfiguration=t,this._workspaceConsolidatedConfiguration=null,this._foldersConsolidatedConfigurations.clear()}updateFolderConfiguration(t,e){this._folderConfigurations.set(t,e),this._foldersConsolidatedConfigurations.delete(t)}deleteFolderConfiguration(t){this.folderConfigurations.delete(t),this._foldersConsolidatedConfigurations.delete(t)}compareAndUpdateDefaultConfiguration(t,e){let r=[];if(!e){let{added:n,updated:o,removed:s}=gn(this._defaultConfiguration,t);e=[...n,...o,...s]}for(let n of e)for(let o of wi(n)){let s=this._defaultConfiguration.getKeysForOverrideIdentifier(o),a=t.getKeysForOverrideIdentifier(o),l=[...a.filter(c=>s.indexOf(c)===-1),...s.filter(c=>a.indexOf(c)===-1),...s.filter(c=>!xt(this._defaultConfiguration.override(o).getValue(c),t.override(o).getValue(c)))];r.push([o,l])}return this.updateDefaultConfiguration(t),{keys:e,overrides:r}}compareAndUpdatePolicyConfiguration(t){let{added:e,updated:r,removed:n}=gn(this._policyConfiguration,t),o=[...e,...r,...n];return o.length&&this.updatePolicyConfiguration(t),{keys:o,overrides:[]}}compareAndUpdateApplicationConfiguration(t){let{added:e,updated:r,removed:n,overrides:o}=gn(this.applicationConfiguration,t),s=[...e,...r,...n];return s.length&&this.updateApplicationConfiguration(t),{keys:s,overrides:o}}compareAndUpdateLocalUserConfiguration(t){let{added:e,updated:r,removed:n,overrides:o}=gn(this.localUserConfiguration,t),s=[...e,...r,...n];return s.length&&this.updateLocalUserConfiguration(t),{keys:s,overrides:o}}compareAndUpdateRemoteUserConfiguration(t){let{added:e,updated:r,removed:n,overrides:o}=gn(this.remoteUserConfiguration,t),s=[...e,...r,...n];return s.length&&this.updateRemoteUserConfiguration(t),{keys:s,overrides:o}}compareAndUpdateWorkspaceConfiguration(t){let{added:e,updated:r,removed:n,overrides:o}=gn(this.workspaceConfiguration,t),s=[...e,...r,...n];return s.length&&this.updateWorkspaceConfiguration(t),{keys:s,overrides:o}}compareAndUpdateFolderConfiguration(t,e){let r=this.folderConfigurations.get(t),{added:n,updated:o,removed:s,overrides:a}=gn(r,e),l=[...n,...o,...s];return(l.length||!r)&&this.updateFolderConfiguration(t,e),{keys:l,overrides:a}}compareAndDeleteFolderConfiguration(t){let e=this.folderConfigurations.get(t);if(!e)throw new Error("Unknown folder");this.deleteFolderConfiguration(t);let{added:r,updated:n,removed:o,overrides:s}=gn(e,void 0);return{keys:[...r,...n,...o],overrides:s}}get defaults(){return this._defaultConfiguration}get applicationConfiguration(){return this._applicationConfiguration}get userConfiguration(){if(!this._userConfiguration)if(this._remoteUserConfiguration.isEmpty())this._userConfiguration=this._localUserConfiguration;else{let t=this._localUserConfiguration.merge(this._remoteUserConfiguration);this._userConfiguration=new Ae(t.contents,t.keys,t.overrides,void 0,this.logService)}return this._userConfiguration}get localUserConfiguration(){return this._localUserConfiguration}get remoteUserConfiguration(){return this._remoteUserConfiguration}get workspaceConfiguration(){return this._workspaceConfiguration}get folderConfigurations(){return this._folderConfigurations}getConsolidatedConfigurationModel(t,e,r){let n=this.getConsolidatedConfigurationModelForResource(e,r);if(e.overrideIdentifier&&(n=n.override(e.overrideIdentifier)),!this._policyConfiguration.isEmpty()&&this._policyConfiguration.getValue(t)!==void 0){n=n.merge();for(let o of this._policyConfiguration.keys)n.setValue(o,this._policyConfiguration.getValue(o))}return n}getConsolidatedConfigurationModelForResource({resource:t},e){let r=this.getWorkspaceConsolidatedConfiguration();if(e&&t){let n=e.getFolder(t);n&&(r=this.getFolderConsolidatedConfiguration(n.uri)||r);let o=this._memoryConfigurationByResource.get(t);o&&(r=r.merge(o))}return r}getWorkspaceConsolidatedConfiguration(){return this._workspaceConsolidatedConfiguration||(this._workspaceConsolidatedConfiguration=this._defaultConfiguration.merge(this.applicationConfiguration,this.userConfiguration,this._workspaceConfiguration,this._memoryConfiguration)),this._workspaceConsolidatedConfiguration}getFolderConsolidatedConfiguration(t){let e=this._foldersConsolidatedConfigurations.get(t);if(!e){let r=this.getWorkspaceConsolidatedConfiguration(),n=this._folderConfigurations.get(t);n?(e=r.merge(n),this._foldersConsolidatedConfigurations.set(t,e)):e=r}return e}getFolderConfigurationModelForResource(t,e){if(e&&t){let r=e.getFolder(t);if(r)return this._folderConfigurations.get(r.uri)}}toData(){return{defaults:{contents:this._defaultConfiguration.contents,overrides:this._defaultConfiguration.overrides,keys:this._defaultConfiguration.keys},policy:{contents:this._policyConfiguration.contents,overrides:this._policyConfiguration.overrides,keys:this._policyConfiguration.keys},application:{contents:this.applicationConfiguration.contents,overrides:this.applicationConfiguration.overrides,keys:this.applicationConfiguration.keys,raw:Array.isArray(this.applicationConfiguration.raw)?void 0:this.applicationConfiguration.raw},userLocal:{contents:this.localUserConfiguration.contents,overrides:this.localUserConfiguration.overrides,keys:this.localUserConfiguration.keys,raw:Array.isArray(this.localUserConfiguration.raw)?void 0:this.localUserConfiguration.raw},userRemote:{contents:this.remoteUserConfiguration.contents,overrides:this.remoteUserConfiguration.overrides,keys:this.remoteUserConfiguration.keys,raw:Array.isArray(this.remoteUserConfiguration.raw)?void 0:this.remoteUserConfiguration.raw},workspace:{contents:this._workspaceConfiguration.contents,overrides:this._workspaceConfiguration.overrides,keys:this._workspaceConfiguration.keys},folders:[...this._folderConfigurations.keys()].reduce((t,e)=>{let{contents:r,overrides:n,keys:o}=this._folderConfigurations.get(e);return t.push([e,{contents:r,overrides:n,keys:o}]),t},[])}}allKeys(){let t=new Set;return this._defaultConfiguration.keys.forEach(e=>t.add(e)),this.userConfiguration.keys.forEach(e=>t.add(e)),this._workspaceConfiguration.keys.forEach(e=>t.add(e)),this._folderConfigurations.forEach(e=>e.keys.forEach(r=>t.add(r))),[...t.values()]}allOverrideIdentifiers(){let t=new Set;return this._defaultConfiguration.getAllOverrideIdentifiers().forEach(e=>t.add(e)),this.userConfiguration.getAllOverrideIdentifiers().forEach(e=>t.add(e)),this._workspaceConfiguration.getAllOverrideIdentifiers().forEach(e=>t.add(e)),this._folderConfigurations.forEach(e=>e.getAllOverrideIdentifiers().forEach(r=>t.add(r))),[...t.values()]}getAllKeysForOverrideIdentifier(t){let e=new Set;return this._defaultConfiguration.getKeysForOverrideIdentifier(t).forEach(r=>e.add(r)),this.userConfiguration.getKeysForOverrideIdentifier(t).forEach(r=>e.add(r)),this._workspaceConfiguration.getKeysForOverrideIdentifier(t).forEach(r=>e.add(r)),this._folderConfigurations.forEach(r=>r.getKeysForOverrideIdentifier(t).forEach(n=>e.add(n))),[...e.values()]}static parse(t,e){let r=this.parseConfigurationModel(t.defaults,e),n=this.parseConfigurationModel(t.policy,e),o=this.parseConfigurationModel(t.application,e),s=this.parseConfigurationModel(t.userLocal,e),a=this.parseConfigurationModel(t.userRemote,e),l=this.parseConfigurationModel(t.workspace,e),c=t.folders.reduce((u,p)=>(u.set(P.revive(p[0]),this.parseConfigurationModel(p[1],e)),u),new be);return new i(r,n,o,s,a,l,c,Ae.createEmptyModel(e),new be,e)}static parseConfigurationModel(t,e){return new Ae(t.contents,t.keys,t.overrides,t.raw,e)}};var Ba=class{constructor(t,e,r,n,o){this.change=t;this.previous=e;this.currentConfiguraiton=r;this.currentWorkspace=n;this.logService=o;this._marker=`
`;this._markerCode1=this._marker.charCodeAt(0);this._markerCode2=46;this.affectedKeys=new Set;this._previousConfiguration=void 0;for(let s of t.keys)this.affectedKeys.add(s);for(let[,s]of t.overrides)for(let a of s)this.affectedKeys.add(a);this._affectsConfigStr=this._marker;for(let s of this.affectedKeys)this._affectsConfigStr+=s+this._marker}get previousConfiguration(){return!this._previousConfiguration&&this.previous&&(this._previousConfiguration=_i.parse(this.previous.data,this.logService)),this._previousConfiguration}affectsConfiguration(t,e){let r=this._marker+t,n=this._affectsConfigStr.indexOf(r);if(n<0)return!1;let o=n+r.length;if(o>=this._affectsConfigStr.length)return!1;let s=this._affectsConfigStr.charCodeAt(o);if(s!==this._markerCode1&&s!==this._markerCode2)return!1;if(e){let a=this.previousConfiguration?this.previousConfiguration.getValue(t,e,this.previous?.workspace):void 0,l=this.currentConfiguraiton.getValue(t,e,this.currentWorkspace);return!xt(a,l)}return!0}};function gn(i,t){let{added:e,removed:r,updated:n}=am(t?.rawConfiguration,i?.rawConfiguration),o=[],s=i?.getAllOverrideIdentifiers()||[],a=t?.getAllOverrideIdentifiers()||[];if(t){let l=a.filter(c=>!s.includes(c));for(let c of l)o.push([c,t.getKeysForOverrideIdentifier(c)])}if(i){let l=s.filter(c=>!a.includes(c));for(let c of l)o.push([c,i.getKeysForOverrideIdentifier(c)])}if(t&&i){for(let l of s)if(a.includes(l)){let c=am({contents:i.getOverrideValue(void 0,l)||{},keys:i.getKeysForOverrideIdentifier(l)},{contents:t.getOverrideValue(void 0,l)||{},keys:t.getKeysForOverrideIdentifier(l)});o.push([l,[...c.added,...c.removed,...c.updated]])}}return{added:e,removed:r,updated:n,overrides:o}}function am(i,t){let e=i?t?i.keys.filter(o=>t.keys.indexOf(o)===-1):[...i.keys]:[],r=t?i?t.keys.filter(o=>i.keys.indexOf(o)===-1):[...t.keys]:[],n=[];if(i&&t){for(let o of t.keys)if(i.keys.indexOf(o)!==-1){let s=Wo(t.contents,o),a=Wo(i.contents,o);xt(s,a)||n.push(o)}}return{added:e,removed:r,updated:n}}function ur(i){return Uu(i,0)}function Uu(i,t){switch(typeof i){case"object":return i===null?Zr(349,t):Array.isArray(i)?Uy(i,t):My(i,t);case"string":return cm(i,t);case"boolean":return Ay(i,t);case"number":return Zr(i,t);case"undefined":return Zr(937,t);default:return Zr(617,t)}}function Zr(i,t){return(t<<5)-t+i|0}function Ay(i,t){return Zr(i?433:863,t)}function cm(i,t){t=Zr(149417,t);for(let e=0,r=i.length;e<r;e++)t=Zr(i.charCodeAt(e),t);return t}function Uy(i,t){return t=Zr(104579,t),i.reduce((e,r)=>Uu(r,e),t)}function My(i,t){return t=Zr(181387,t),Object.keys(i).sort().reduce((e,r)=>(e=cm(r,e),Uu(i[r],e)),t)}function Au(i,t,e=32){let r=e-t,n=~((1<<r)-1);return(i<<t|(n&i)>>>r)>>>0}function Ho(i,t=32){return i instanceof ArrayBuffer?Gf(U.wrap(new Uint8Array(i))):(i>>>0).toString(16).padStart(t/4,"0")}var lm=class i{constructor(){this._h0=1732584193;this._h1=4023233417;this._h2=2562383102;this._h3=271733878;this._h4=3285377520;this._buff=new Uint8Array(67),this._buffDV=new DataView(this._buff.buffer),this._buffLen=0,this._totalLen=0,this._leftoverHighSurrogate=0,this._finished=!1}static{this._bigBlock32=new DataView(new ArrayBuffer(320))}update(t){let e=t.length;if(e===0)return;let r=this._buff,n=this._buffLen,o=this._leftoverHighSurrogate,s,a;for(o!==0?(s=o,a=-1,o=0):(s=t.charCodeAt(0),a=0);;){let l=s;if(ef(s))if(a+1<e){let c=t.charCodeAt(a+1);Jc(c)?(a++,l=tf(s,c)):l=65533}else{o=s;break}else Jc(s)&&(l=65533);if(n=this._push(r,n,l),a++,a<e)s=t.charCodeAt(a);else break}this._buffLen=n,this._leftoverHighSurrogate=o}_push(t,e,r){return r<128?t[e++]=r:r<2048?(t[e++]=192|(r&1984)>>>6,t[e++]=128|(r&63)>>>0):r<65536?(t[e++]=224|(r&61440)>>>12,t[e++]=128|(r&4032)>>>6,t[e++]=128|(r&63)>>>0):(t[e++]=240|(r&1835008)>>>18,t[e++]=128|(r&258048)>>>12,t[e++]=128|(r&4032)>>>6,t[e++]=128|(r&63)>>>0),e>=64&&(this._step(),e-=64,this._totalLen+=64,t[0]=t[64],t[1]=t[65],t[2]=t[66]),e}digest(){return this._finished||(this._finished=!0,this._leftoverHighSurrogate&&(this._leftoverHighSurrogate=0,this._buffLen=this._push(this._buff,this._buffLen,65533)),this._totalLen+=this._buffLen,this._wrapUp()),Ho(this._h0)+Ho(this._h1)+Ho(this._h2)+Ho(this._h3)+Ho(this._h4)}_wrapUp(){this._buff[this._buffLen++]=128,this._buff.subarray(this._buffLen).fill(0),this._buffLen>56&&(this._step(),this._buff.fill(0));let t=8*this._totalLen;this._buffDV.setUint32(56,Math.floor(t/4294967296),!1),this._buffDV.setUint32(60,t%4294967296,!1),this._step()}_step(){let t=i._bigBlock32,e=this._buffDV;for(let p=0;p<64;p+=4)t.setUint32(p,e.getUint32(p,!1),!1);for(let p=64;p<320;p+=4)t.setUint32(p,Au(t.getUint32(p-12,!1)^t.getUint32(p-32,!1)^t.getUint32(p-56,!1)^t.getUint32(p-64,!1),1),!1);let r=this._h0,n=this._h1,o=this._h2,s=this._h3,a=this._h4,l,c,u;for(let p=0;p<80;p++)p<20?(l=n&o|~n&s,c=1518500249):p<40?(l=n^o^s,c=1859775393):p<60?(l=n&o|n&s|o&s,c=2400959708):(l=n^o^s,c=3395469782),u=Au(r,5)+l+a+c+t.getUint32(p*4,!1)&4294967295,a=s,s=o,o=Au(n,30),n=r,r=u;this._h0=this._h0+r&4294967295,this._h1=this._h1+n&4294967295,this._h2=this._h2+o&4294967295,this._h3=this._h3+s&4294967295,this._h4=this._h4+a&4294967295}};function Mu(...i){switch(i.length){case 1:return m(1857,null,i[0]);case 2:return m(1858,null,i[0],i[1]);case 3:return m(1859,null,i[0],i[1],i[2]);default:return}}var Fy=m(1856,null),Oy=m(1855,null),hn=class i{constructor(){this._input="";this._start=0;this._current=0;this._tokens=[];this._errors=[];this.stringRe=/[a-zA-Z0-9_<>\-\./\\:\*\?\+\[\]\^,#@;"%\$\p{L}-]+/uy}static getLexeme(t){switch(t.type){case 0:return"(";case 1:return")";case 2:return"!";case 3:return t.isTripleEq?"===":"==";case 4:return t.isTripleEq?"!==":"!=";case 5:return"<";case 6:return"<=";case 7:return">=";case 8:return">=";case 9:return"=~";case 10:return t.lexeme;case 11:return"true";case 12:return"false";case 13:return"in";case 14:return"not";case 15:return"&&";case 16:return"||";case 17:return t.lexeme;case 18:return t.lexeme;case 19:return t.lexeme;case 20:return"EOF";default:throw Gs(`unhandled token type: ${JSON.stringify(t)}; have you forgotten to add a case?`)}}static{this._regexFlags=new Set(["i","g","s","m","y","u"].map(t=>t.charCodeAt(0)))}static{this._keywords=new Map([["not",14],["in",13],["false",12],["true",11]])}get errors(){return this._errors}reset(t){return this._input=t,this._start=0,this._current=0,this._tokens=[],this._errors=[],this}scan(){for(;!this._isAtEnd();)switch(this._start=this._current,this._advance()){case 40:this._addToken(0);break;case 41:this._addToken(1);break;case 33:if(this._match(61)){let e=this._match(61);this._tokens.push({type:4,offset:this._start,isTripleEq:e})}else this._addToken(2);break;case 39:this._quotedString();break;case 47:this._regex();break;case 61:if(this._match(61)){let e=this._match(61);this._tokens.push({type:3,offset:this._start,isTripleEq:e})}else this._match(126)?this._addToken(9):this._error(Mu("==","=~"));break;case 60:this._addToken(this._match(61)?6:5);break;case 62:this._addToken(this._match(61)?8:7);break;case 38:this._match(38)?this._addToken(15):this._error(Mu("&&"));break;case 124:this._match(124)?this._addToken(16):this._error(Mu("||"));break;case 32:case 13:case 9:case 10:case 160:break;default:this._string()}return this._start=this._current,this._addToken(20),Array.from(this._tokens)}_match(t){return this._isAtEnd()||this._input.charCodeAt(this._current)!==t?!1:(this._current++,!0)}_advance(){return this._input.charCodeAt(this._current++)}_peek(){return this._isAtEnd()?0:this._input.charCodeAt(this._current)}_addToken(t){this._tokens.push({type:t,offset:this._start})}_error(t){let e=this._start,r=this._input.substring(this._start,this._current),n={type:19,offset:this._start,lexeme:r};this._errors.push({offset:e,lexeme:r,additionalInfo:t}),this._tokens.push(n)}_string(){this.stringRe.lastIndex=this._start;let t=this.stringRe.exec(this._input);if(t){this._current=this._start+t[0].length;let e=this._input.substring(this._start,this._current),r=i._keywords.get(e);r?this._addToken(r):this._tokens.push({type:17,lexeme:e,offset:this._start})}}_quotedString(){for(;this._peek()!==39&&!this._isAtEnd();)this._advance();if(this._isAtEnd()){this._error(Fy);return}this._advance(),this._tokens.push({type:18,lexeme:this._input.substring(this._start+1,this._current-1),offset:this._start+1})}_regex(){let t=this._current,e=!1,r=!1;for(;;){if(t>=this._input.length){this._current=t,this._error(Oy);return}let o=this._input.charCodeAt(t);if(e)e=!1;else if(o===47&&!r){t++;break}else o===91?r=!0:o===92?e=!0:o===93&&(r=!1);t++}for(;t<this._input.length&&i._regexFlags.has(this._input.charCodeAt(t));)t++;this._current=t;let n=this._input.substring(this._start,this._current);this._tokens.push({type:10,lexeme:n,offset:this._start})}_isAtEnd(){return this._current>=this._input.length}};var Ye=new Map;Ye.set("false",!1);Ye.set("true",!0);Ye.set("isMac",ft);Ye.set("isLinux",Te);Ye.set("isWindows",pe);Ye.set("isWeb",Je);Ye.set("isMacNative",ft&&!Je);Ye.set("isEdge",zp);Ye.set("isFirefox",qp);Ye.set("isChrome",Kc);Ye.set("isSafari",Kp);var Ny=Object.prototype.hasOwnProperty;var Vy={regexParsingWithErrorRecovery:!0},Wy=m(1836,null),By=m(1837,null),Gy=m(1839,null),um=m(1835,null),qy=m(1842,null),Ky=m(1843,null),zy=m(1840,null),$y=m(1841,null),Fu=class i{constructor(t=Vy){this._config=t;this._scanner=new hn;this._tokens=[];this._current=0;this._parsingErrors=[];this._flagsGYRe=/g|y/g}static{this._parseError=new Error}get lexingErrors(){return this._scanner.errors}get parsingErrors(){return this._parsingErrors}parse(t){if(t===""){this._parsingErrors.push({message:Wy,offset:0,lexeme:"",additionalInfo:By});return}this._tokens=this._scanner.reset(t).scan(),this._current=0,this._parsingErrors=[];try{let e=this._expr();if(!this._isAtEnd()){let r=this._peek(),n=r.type===17?Ky:void 0;throw this._parsingErrors.push({message:qy,offset:r.offset,lexeme:hn.getLexeme(r),additionalInfo:n}),i._parseError}return e}catch(e){if(e!==i._parseError)throw e;return}}_expr(){return this._or()}_or(){let t=[this._and()];for(;this._matchOne(16);){let e=this._and();t.push(e)}return t.length===1?t[0]:ot.or(...t)}_and(){let t=[this._term()];for(;this._matchOne(15);){let e=this._term();t.push(e)}return t.length===1?t[0]:ot.and(...t)}_term(){if(this._matchOne(2)){let t=this._peek();switch(t.type){case 11:return this._advance(),mt.INSTANCE;case 12:return this._advance(),bt.INSTANCE;case 0:{this._advance();let e=this._expr();return this._consume(1,um),e?.negate()}case 17:return this._advance(),Gn.create(t.lexeme);default:throw this._errExpectedButGot("KEY | true | false | '(' expression ')'",t)}}return this._primary()}_primary(){let t=this._peek();switch(t.type){case 11:return this._advance(),ot.true();case 12:return this._advance(),ot.false();case 0:{this._advance();let e=this._expr();return this._consume(1,um),e}case 17:{let e=t.lexeme;if(this._advance(),this._matchOne(9)){let n=this._peek();if(!this._config.regexParsingWithErrorRecovery){if(this._advance(),n.type!==10)throw this._errExpectedButGot("REGEX",n);let o=n.lexeme,s=o.lastIndexOf("/"),a=s===o.length-1?void 0:this._removeFlagsGY(o.substring(s+1)),l;try{l=new RegExp(o.substring(1,s),a)}catch{throw this._errExpectedButGot("REGEX",n)}return ts.create(e,l)}switch(n.type){case 10:case 19:{let o=[n.lexeme];this._advance();let s=this._peek(),a=0;for(let f=0;f<n.lexeme.length;f++)n.lexeme.charCodeAt(f)===40?a++:n.lexeme.charCodeAt(f)===41&&a--;for(;!this._isAtEnd()&&s.type!==15&&s.type!==16;){switch(s.type){case 0:a++;break;case 1:a--;break;case 10:case 18:for(let f=0;f<s.lexeme.length;f++)s.lexeme.charCodeAt(f)===40?a++:n.lexeme.charCodeAt(f)===41&&a--}if(a<0)break;o.push(hn.getLexeme(s)),this._advance(),s=this._peek()}let l=o.join(""),c=l.lastIndexOf("/"),u=c===l.length-1?void 0:this._removeFlagsGY(l.substring(c+1)),p;try{p=new RegExp(l.substring(1,c),u)}catch{throw this._errExpectedButGot("REGEX",n)}return ot.regex(e,p)}case 18:{let o=n.lexeme;this._advance();let s=null;if(!Yp(o)){let a=o.indexOf("/"),l=o.lastIndexOf("/");if(a!==l&&a>=0){let c=o.slice(a+1,l),u=o[l+1]==="i"?"i":"";try{s=new RegExp(c,u)}catch{throw this._errExpectedButGot("REGEX",n)}}}if(s===null)throw this._errExpectedButGot("REGEX",n);return ts.create(e,s)}default:throw this._errExpectedButGot("REGEX",this._peek())}}if(this._matchOne(14)){this._consume(13,Gy);let n=this._value();return ot.notIn(e,n)}switch(this._peek().type){case 3:{this._advance();let n=this._value();if(this._previous().type===18)return ot.equals(e,n);switch(n){case"true":return ot.has(e);case"false":return ot.not(e);default:return ot.equals(e,n)}}case 4:{this._advance();let n=this._value();if(this._previous().type===18)return ot.notEquals(e,n);switch(n){case"true":return ot.not(e);case"false":return ot.has(e);default:return ot.notEquals(e,n)}}case 5:return this._advance(),Zo.create(e,this._value());case 6:return this._advance(),es.create(e,this._value());case 7:return this._advance(),ki.create(e,this._value());case 8:return this._advance(),Yo.create(e,this._value());case 13:return this._advance(),ot.in(e,this._value());default:return ot.has(e)}}case 20:throw this._parsingErrors.push({message:zy,offset:t.offset,lexeme:"",additionalInfo:$y}),i._parseError;default:throw this._errExpectedButGot(`true | false | KEY 
	| KEY '=~' REGEX 
	| KEY ('==' | '!=' | '<' | '<=' | '>' | '>=' | 'in' | 'not' 'in') value`,this._peek())}}_value(){let t=this._peek();switch(t.type){case 17:case 18:return this._advance(),t.lexeme;case 11:return this._advance(),"true";case 12:return this._advance(),"false";case 13:return this._advance(),"in";default:return""}}_removeFlagsGY(t){return t.replaceAll(this._flagsGYRe,"")}_previous(){return this._tokens[this._current-1]}_matchOne(t){return this._check(t)?(this._advance(),!0):!1}_advance(){return this._isAtEnd()||this._current++,this._previous()}_consume(t,e){if(this._check(t))return this._advance();throw this._errExpectedButGot(e,this._peek())}_errExpectedButGot(t,e,r){let n=m(1838,null,t,hn.getLexeme(e)),o=e.offset,s=hn.getLexeme(e);return this._parsingErrors.push({message:n,offset:o,lexeme:s,additionalInfo:r}),i._parseError}_check(t){return this._peek().type===t}_peek(){return this._tokens[this._current]}_isAtEnd(){return this._peek().type===20}},ot=class{static false(){return mt.INSTANCE}static true(){return bt.INSTANCE}static has(t){return Bn.create(t)}static equals(t,e){return Jo.create(t,e)}static notEquals(t,e){return Xo.create(t,e)}static regex(t,e){return ts.create(t,e)}static in(t,e){return Ga.create(t,e)}static notIn(t,e){return qa.create(t,e)}static not(t){return Gn.create(t)}static and(...t){return Ka.create(t,null,!0)}static or(...t){return rs.create(t,null,!0)}static greater(t,e){return ki.create(t,e)}static greaterEquals(t,e){return Yo.create(t,e)}static smaller(t,e){return Zo.create(t,e)}static smallerEquals(t,e){return es.create(t,e)}static{this._parser=new Fu({regexParsingWithErrorRecovery:!1})}static deserialize(t){return t==null?void 0:this._parser.parse(t)}};function Qo(i,t){return i.cmp(t)}var mt=class i{constructor(){this.type=0}static{this.INSTANCE=new i}cmp(t){return this.type-t.type}equals(t){return t.type===this.type}substituteConstants(){return this}evaluate(t){return!1}serialize(){return"false"}keys(){return[]}map(t){return this}negate(){return bt.INSTANCE}},bt=class i{constructor(){this.type=1}static{this.INSTANCE=new i}cmp(t){return this.type-t.type}equals(t){return t.type===this.type}substituteConstants(){return this}evaluate(t){return!0}serialize(){return"true"}keys(){return[]}map(t){return this}negate(){return mt.INSTANCE}},Bn=class i{constructor(t,e){this.key=t;this.negated=e;this.type=2}static create(t,e=null){let r=Ye.get(t);return typeof r=="boolean"?r?bt.INSTANCE:mt.INSTANCE:new i(t,e)}cmp(t){return t.type!==this.type?this.type-t.type:fm(this.key,t.key)}equals(t){return t.type===this.type?this.key===t.key:!1}substituteConstants(){let t=Ye.get(this.key);return typeof t=="boolean"?t?bt.INSTANCE:mt.INSTANCE:this}evaluate(t){return!!t.getValue(this.key)}serialize(){return this.key}keys(){return[this.key]}map(t){return t.mapDefined(this.key)}negate(){return this.negated||(this.negated=Gn.create(this.key,this)),this.negated}},Jo=class i{constructor(t,e,r){this.key=t;this.value=e;this.negated=r;this.type=4}static create(t,e,r=null){if(typeof e=="boolean")return e?Bn.create(t,r):Gn.create(t,r);let n=Ye.get(t);return typeof n=="boolean"?e===(n?"true":"false")?bt.INSTANCE:mt.INSTANCE:new i(t,e,r)}cmp(t){return t.type!==this.type?this.type-t.type:qn(this.key,this.value,t.key,t.value)}equals(t){return t.type===this.type?this.key===t.key&&this.value===t.value:!1}substituteConstants(){let t=Ye.get(this.key);if(typeof t=="boolean"){let e=t?"true":"false";return this.value===e?bt.INSTANCE:mt.INSTANCE}return this}evaluate(t){return t.getValue(this.key)==this.value}serialize(){return`${this.key} == '${this.value}'`}keys(){return[this.key]}map(t){return t.mapEquals(this.key,this.value)}negate(){return this.negated||(this.negated=Xo.create(this.key,this.value,this)),this.negated}},Ga=class i{constructor(t,e){this.key=t;this.valueKey=e;this.type=10;this.negated=null}static create(t,e){return new i(t,e)}cmp(t){return t.type!==this.type?this.type-t.type:qn(this.key,this.valueKey,t.key,t.valueKey)}equals(t){return t.type===this.type?this.key===t.key&&this.valueKey===t.valueKey:!1}substituteConstants(){return this}evaluate(t){let e=t.getValue(this.valueKey),r=t.getValue(this.key);return Array.isArray(e)?e.includes(r):typeof r=="string"&&typeof e=="object"&&e!==null?Ny.call(e,r):!1}serialize(){return`${this.key} in '${this.valueKey}'`}keys(){return[this.key,this.valueKey]}map(t){return t.mapIn(this.key,this.valueKey)}negate(){return this.negated||(this.negated=qa.create(this.key,this.valueKey)),this.negated}},qa=class i{constructor(t,e){this.key=t;this.valueKey=e;this.type=11;this._negated=Ga.create(t,e)}static create(t,e){return new i(t,e)}cmp(t){return t.type!==this.type?this.type-t.type:this._negated.cmp(t._negated)}equals(t){return t.type===this.type?this._negated.equals(t._negated):!1}substituteConstants(){return this}evaluate(t){return!this._negated.evaluate(t)}serialize(){return`${this.key} not in '${this.valueKey}'`}keys(){return this._negated.keys()}map(t){return t.mapNotIn(this.key,this.valueKey)}negate(){return this._negated}},Xo=class i{constructor(t,e,r){this.key=t;this.value=e;this.negated=r;this.type=5}static create(t,e,r=null){if(typeof e=="boolean")return e?Gn.create(t,r):Bn.create(t,r);let n=Ye.get(t);return typeof n=="boolean"?e===(n?"true":"false")?mt.INSTANCE:bt.INSTANCE:new i(t,e,r)}cmp(t){return t.type!==this.type?this.type-t.type:qn(this.key,this.value,t.key,t.value)}equals(t){return t.type===this.type?this.key===t.key&&this.value===t.value:!1}substituteConstants(){let t=Ye.get(this.key);if(typeof t=="boolean"){let e=t?"true":"false";return this.value===e?mt.INSTANCE:bt.INSTANCE}return this}evaluate(t){return t.getValue(this.key)!=this.value}serialize(){return`${this.key} != '${this.value}'`}keys(){return[this.key]}map(t){return t.mapNotEquals(this.key,this.value)}negate(){return this.negated||(this.negated=Jo.create(this.key,this.value,this)),this.negated}},Gn=class i{constructor(t,e){this.key=t;this.negated=e;this.type=3}static create(t,e=null){let r=Ye.get(t);return typeof r=="boolean"?r?mt.INSTANCE:bt.INSTANCE:new i(t,e)}cmp(t){return t.type!==this.type?this.type-t.type:fm(this.key,t.key)}equals(t){return t.type===this.type?this.key===t.key:!1}substituteConstants(){let t=Ye.get(this.key);return typeof t=="boolean"?t?mt.INSTANCE:bt.INSTANCE:this}evaluate(t){return!t.getValue(this.key)}serialize(){return`!${this.key}`}keys(){return[this.key]}map(t){return t.mapNot(this.key)}negate(){return this.negated||(this.negated=Bn.create(this.key,this)),this.negated}};function $a(i,t){if(typeof i=="string"){let e=parseFloat(i);isNaN(e)||(i=e)}return typeof i=="string"||typeof i=="number"?t(i):mt.INSTANCE}var ki=class i{constructor(t,e,r){this.key=t;this.value=e;this.negated=r;this.type=12}static create(t,e,r=null){return $a(e,n=>new i(t,n,r))}cmp(t){return t.type!==this.type?this.type-t.type:qn(this.key,this.value,t.key,t.value)}equals(t){return t.type===this.type?this.key===t.key&&this.value===t.value:!1}substituteConstants(){return this}evaluate(t){return typeof this.value=="string"?!1:parseFloat(t.getValue(this.key))>this.value}serialize(){return`${this.key} > ${this.value}`}keys(){return[this.key]}map(t){return t.mapGreater(this.key,this.value)}negate(){return this.negated||(this.negated=es.create(this.key,this.value,this)),this.negated}},Yo=class i{constructor(t,e,r){this.key=t;this.value=e;this.negated=r;this.type=13}static create(t,e,r=null){return $a(e,n=>new i(t,n,r))}cmp(t){return t.type!==this.type?this.type-t.type:qn(this.key,this.value,t.key,t.value)}equals(t){return t.type===this.type?this.key===t.key&&this.value===t.value:!1}substituteConstants(){return this}evaluate(t){return typeof this.value=="string"?!1:parseFloat(t.getValue(this.key))>=this.value}serialize(){return`${this.key} >= ${this.value}`}keys(){return[this.key]}map(t){return t.mapGreaterEquals(this.key,this.value)}negate(){return this.negated||(this.negated=Zo.create(this.key,this.value,this)),this.negated}},Zo=class i{constructor(t,e,r){this.key=t;this.value=e;this.negated=r;this.type=14}static create(t,e,r=null){return $a(e,n=>new i(t,n,r))}cmp(t){return t.type!==this.type?this.type-t.type:qn(this.key,this.value,t.key,t.value)}equals(t){return t.type===this.type?this.key===t.key&&this.value===t.value:!1}substituteConstants(){return this}evaluate(t){return typeof this.value=="string"?!1:parseFloat(t.getValue(this.key))<this.value}serialize(){return`${this.key} < ${this.value}`}keys(){return[this.key]}map(t){return t.mapSmaller(this.key,this.value)}negate(){return this.negated||(this.negated=Yo.create(this.key,this.value,this)),this.negated}},es=class i{constructor(t,e,r){this.key=t;this.value=e;this.negated=r;this.type=15}static create(t,e,r=null){return $a(e,n=>new i(t,n,r))}cmp(t){return t.type!==this.type?this.type-t.type:qn(this.key,this.value,t.key,t.value)}equals(t){return t.type===this.type?this.key===t.key&&this.value===t.value:!1}substituteConstants(){return this}evaluate(t){return typeof this.value=="string"?!1:parseFloat(t.getValue(this.key))<=this.value}serialize(){return`${this.key} <= ${this.value}`}keys(){return[this.key]}map(t){return t.mapSmallerEquals(this.key,this.value)}negate(){return this.negated||(this.negated=ki.create(this.key,this.value,this)),this.negated}},ts=class i{constructor(t,e){this.key=t;this.regexp=e;this.type=7;this.negated=null}static create(t,e){return new i(t,e)}cmp(t){if(t.type!==this.type)return this.type-t.type;if(this.key<t.key)return-1;if(this.key>t.key)return 1;let e=this.regexp?this.regexp.source:"",r=t.regexp?t.regexp.source:"";return e<r?-1:e>r?1:0}equals(t){if(t.type===this.type){let e=this.regexp?this.regexp.source:"",r=t.regexp?t.regexp.source:"";return this.key===t.key&&e===r}return!1}substituteConstants(){return this}evaluate(t){let e=t.getValue(this.key);return this.regexp?this.regexp.test(e):!1}serialize(){let t=this.regexp?`/${this.regexp.source}/${this.regexp.flags}`:"/invalid/";return`${this.key} =~ ${t}`}keys(){return[this.key]}map(t){return t.mapRegex(this.key,this.regexp)}negate(){return this.negated||(this.negated=Ou.create(this)),this.negated}},Ou=class i{constructor(t){this._actual=t;this.type=8}static create(t){return new i(t)}cmp(t){return t.type!==this.type?this.type-t.type:this._actual.cmp(t._actual)}equals(t){return t.type===this.type?this._actual.equals(t._actual):!1}substituteConstants(){return this}evaluate(t){return!this._actual.evaluate(t)}serialize(){return`!(${this._actual.serialize()})`}keys(){return this._actual.keys()}map(t){return new i(this._actual.map(t))}negate(){return this._actual}};function pm(i){let t=null;for(let e=0,r=i.length;e<r;e++){let n=i[e].substituteConstants();if(i[e]!==n&&t===null){t=[];for(let o=0;o<e;o++)t[o]=i[o]}t!==null&&(t[e]=n)}return t===null?i:t}var Ka=class i{constructor(t,e){this.expr=t;this.negated=e;this.type=6}static create(t,e,r){return i._normalizeArr(t,e,r)}cmp(t){if(t.type!==this.type)return this.type-t.type;if(this.expr.length<t.expr.length)return-1;if(this.expr.length>t.expr.length)return 1;for(let e=0,r=this.expr.length;e<r;e++){let n=Qo(this.expr[e],t.expr[e]);if(n!==0)return n}return 0}equals(t){if(t.type===this.type){if(this.expr.length!==t.expr.length)return!1;for(let e=0,r=this.expr.length;e<r;e++)if(!this.expr[e].equals(t.expr[e]))return!1;return!0}return!1}substituteConstants(){let t=pm(this.expr);return t===this.expr?this:i.create(t,this.negated,!1)}evaluate(t){for(let e=0,r=this.expr.length;e<r;e++)if(!this.expr[e].evaluate(t))return!1;return!0}static _normalizeArr(t,e,r){let n=[],o=!1;for(let s of t)if(s){if(s.type===1){o=!0;continue}if(s.type===0)return mt.INSTANCE;if(s.type===6){n.push(...s.expr);continue}n.push(s)}if(n.length===0&&o)return bt.INSTANCE;if(n.length!==0){if(n.length===1)return n[0];n.sort(Qo);for(let s=1;s<n.length;s++)n[s-1].equals(n[s])&&(n.splice(s,1),s--);if(n.length===1)return n[0];for(;n.length>1;){let s=n[n.length-1];if(s.type!==9)break;n.pop();let a=n.pop(),l=n.length===0,c=rs.create(s.expr.map(u=>i.create([u,a],null,r)),null,l);c&&(n.push(c),n.sort(Qo))}if(n.length===1)return n[0];if(r){for(let s=0;s<n.length;s++)for(let a=s+1;a<n.length;a++)if(n[s].negate().equals(n[a]))return mt.INSTANCE;if(n.length===1)return n[0]}return new i(n,e)}}serialize(){return this.expr.map(t=>t.serialize()).join(" && ")}keys(){let t=[];for(let e of this.expr)t.push(...e.keys());return t}map(t){return new i(this.expr.map(e=>e.map(t)),null)}negate(){if(!this.negated){let t=[];for(let e of this.expr)t.push(e.negate());this.negated=rs.create(t,this,!0)}return this.negated}},rs=class i{constructor(t,e){this.expr=t;this.negated=e;this.type=9}static create(t,e,r){return i._normalizeArr(t,e,r)}cmp(t){if(t.type!==this.type)return this.type-t.type;if(this.expr.length<t.expr.length)return-1;if(this.expr.length>t.expr.length)return 1;for(let e=0,r=this.expr.length;e<r;e++){let n=Qo(this.expr[e],t.expr[e]);if(n!==0)return n}return 0}equals(t){if(t.type===this.type){if(this.expr.length!==t.expr.length)return!1;for(let e=0,r=this.expr.length;e<r;e++)if(!this.expr[e].equals(t.expr[e]))return!1;return!0}return!1}substituteConstants(){let t=pm(this.expr);return t===this.expr?this:i.create(t,this.negated,!1)}evaluate(t){for(let e=0,r=this.expr.length;e<r;e++)if(this.expr[e].evaluate(t))return!0;return!1}static _normalizeArr(t,e,r){let n=[],o=!1;if(t){for(let s=0,a=t.length;s<a;s++){let l=t[s];if(l){if(l.type===0){o=!0;continue}if(l.type===1)return bt.INSTANCE;if(l.type===9){n=n.concat(l.expr);continue}n.push(l)}}if(n.length===0&&o)return mt.INSTANCE;n.sort(Qo)}if(n.length!==0){if(n.length===1)return n[0];for(let s=1;s<n.length;s++)n[s-1].equals(n[s])&&(n.splice(s,1),s--);if(n.length===1)return n[0];if(r){for(let s=0;s<n.length;s++)for(let a=s+1;a<n.length;a++)if(n[s].negate().equals(n[a]))return bt.INSTANCE;if(n.length===1)return n[0]}return new i(n,e)}}serialize(){return this.expr.map(t=>t.serialize()).join(" || ")}keys(){let t=[];for(let e of this.expr)t.push(...e.keys());return t}map(t){return new i(this.expr.map(e=>e.map(t)),null)}negate(){if(!this.negated){let t=[];for(let e of this.expr)t.push(e.negate());for(;t.length>1;){let e=t.shift(),r=t.shift(),n=[];for(let o of dm(e))for(let s of dm(r))n.push(Ka.create([o,s],null,!1));t.unshift(i.create(n,null,!1))}this.negated=i.create(t,this,!0)}return this.negated}},za=class i extends Bn{static{this._info=[]}static all(){return i._info.values()}constructor(t,e,r){super(t,null),this._defaultValue=e,typeof r=="object"?i._info.push({...r,key:t}):r!==!0&&i._info.push({key:t,description:r,type:e!=null?typeof e:void 0})}bindTo(t){return t.createKey(this.key,this._defaultValue)}getValue(t){return t.getContextKeyValue(this.key)}toNegated(){return this.negate()}isEqualTo(t){return Jo.create(this.key,t)}notEqualsTo(t){return Xo.create(this.key,t)}greater(t){return ki.create(this.key,t)}},cw=B("contextKeyService");function fm(i,t){return i<t?-1:i>t?1:0}function qn(i,t,e,r){return i<e?-1:i>e?1:t<r?-1:t>r?1:0}function dm(i){return i.type===9?i.expr:[i]}var V=B("logService"),mm=B("loggerService");var Vu=3;function jy(i,t){return i!==0&&i<=t}function Di(i,t=!1){let e="";for(let r=0;r<i.length;r++){let n=i[r];if(n instanceof Error&&(n=ar(n,t)),typeof n=="object")try{n=JSON.stringify(n)}catch{}e+=(r>0?" ":"")+n}return e}var ns=class extends _{constructor(){super(...arguments);this.level=Vu;this._onDidChangeLogLevel=this._register(new R)}get onDidChangeLogLevel(){return this._onDidChangeLogLevel.event}setLevel(e){this.level!==e&&(this.level=e,this._onDidChangeLogLevel.fire(this.level))}getLevel(){return this.level}checkLogLevel(e){return jy(this.level,e)}canLog(e){return this._store.isDisposed?!1:this.checkLogLevel(e)}},ja=class extends ns{constructor(e){super();this.logAlways=e}checkLogLevel(e){return this.logAlways||super.checkLogLevel(e)}trace(e,...r){this.canLog(1)&&this.log(1,Di([e,...r],!0))}debug(e,...r){this.canLog(2)&&this.log(2,Di([e,...r]))}info(e,...r){this.canLog(3)&&this.log(3,Di([e,...r]))}warn(e,...r){this.canLog(4)&&this.log(4,Di([e,...r]))}error(e,...r){if(this.canLog(5))if(e instanceof Error){let n=Array.prototype.slice.call(arguments);n[0]=e.stack,this.log(5,Di(n))}else this.log(5,Di([e,...r]))}flush(){}};var Fr=class extends ns{constructor(e=Vu,r=!0){super();this.useColors=r;this.setLevel(e)}trace(e,...r){this.canLog(1)&&(this.useColors?console.log("%cTRACE","color: #888",e,...r):console.log(e,...r))}debug(e,...r){this.canLog(2)&&(this.useColors?console.log("%cDEBUG","background: #eee; color: #888",e,...r):console.log(e,...r))}info(e,...r){this.canLog(3)&&(this.useColors?console.log("%c INFO","color: #33f",e,...r):console.log(e,...r))}warn(e,...r){this.canLog(4)&&(this.useColors?console.warn("%c WARN","color: #993",e,...r):console.log(e,...r))}error(e,...r){this.canLog(5)&&(this.useColors?console.error("%c  ERR","color: #f33",e,...r):console.error(e,...r))}flush(){}};var Ha=class extends ns{constructor(e){super();this.loggers=e;e.length&&this.setLevel(e[0].getLevel())}setLevel(e){for(let r of this.loggers)r.setLevel(e);super.setLevel(e)}trace(e,...r){for(let n of this.loggers)n.trace(e,...r)}debug(e,...r){for(let n of this.loggers)n.debug(e,...r)}info(e,...r){for(let n of this.loggers)n.info(e,...r)}warn(e,...r){for(let n of this.loggers)n.warn(e,...r)}error(e,...r){for(let n of this.loggers)n.error(e,...r)}flush(){for(let e of this.loggers)e.flush()}dispose(){for(let e of this.loggers)e.dispose();super.dispose()}},Qa=class extends _{constructor(e,r,n){super();this.logLevel=e;this.logsHome=r;this._loggers=new be;this._onDidChangeLoggers=this._register(new R);this.onDidChangeLoggers=this._onDidChangeLoggers.event;this._onDidChangeLogLevel=this._register(new R);this.onDidChangeLogLevel=this._onDidChangeLogLevel.event;this._onDidChangeVisibility=this._register(new R);this.onDidChangeVisibility=this._onDidChangeVisibility.event;if(n)for(let o of n)this._loggers.set(o.resource,{logger:void 0,info:o})}getLoggerEntry(e){return te(e)?[...this._loggers.values()].find(r=>r.info.id===e):this._loggers.get(e)}getLogger(e){return this.getLoggerEntry(e)?.logger}createLogger(e,r){let n=this.toResource(e),o=te(e)?e:r?.id??ur(n.toString()).toString(16),s=this._loggers.get(n)?.logger,a=r?.logLevel==="always"?1:r?.logLevel;s||(s=this.doCreateLogger(n,a??this.getLogLevel(n)??this.logLevel,{...r,id:o}));let l={logger:s,info:{resource:n,id:o,logLevel:a,name:r?.name,hidden:r?.hidden,group:r?.group,extensionId:r?.extensionId,when:r?.when}};return this.registerLogger(l.info),this._loggers.set(n,l),s}toResource(e){return te(e)?z(this.logsHome,`${e.replace(/[\\/:\*\?"<>\|]/g,"")}.log`):e}setLogLevel(e,r){if(P.isUri(e)){let n=e,o=r,s=this._loggers.get(n);s&&o!==s.info.logLevel&&(s.info.logLevel=o===this.logLevel?void 0:o,s.logger?.setLevel(o),this._loggers.set(s.info.resource,s),this._onDidChangeLogLevel.fire([n,o]))}else{this.logLevel=e;for(let[n,o]of this._loggers.entries())this._loggers.get(n)?.info.logLevel===void 0&&o.logger?.setLevel(this.logLevel);this._onDidChangeLogLevel.fire(this.logLevel)}}setVisibility(e,r){let n=this.getLoggerEntry(e);n&&r!==!n.info.hidden&&(n.info.hidden=!r,this._loggers.set(n.info.resource,n),this._onDidChangeVisibility.fire([n.info.resource,r]))}getLogLevel(e){let r;return e&&(r=this._loggers.get(e)?.info.logLevel),r??this.logLevel}registerLogger(e){let r=this._loggers.get(e.resource);r?r.info.hidden!==e.hidden&&this.setVisibility(e.resource,!e.hidden):(this._loggers.set(e.resource,{info:e,logger:void 0}),this._onDidChangeLoggers.fire({added:[e],removed:[]}))}deregisterLogger(e){let r=this.toResource(e),n=this._loggers.get(r);n&&(n.logger&&n.logger.dispose(),this._loggers.delete(r),this._onDidChangeLoggers.fire({added:[],removed:[n.info]}))}*getRegisteredLoggers(){for(let e of this._loggers.values())yield e.info}getRegisteredLogger(e){return this._loggers.get(e)?.info}dispose(){this._loggers.forEach(e=>e.logger?.dispose()),this._loggers.clear(),super.dispose()}},Nu=class{constructor(){this.onDidChangeLogLevel=new R().event}setLevel(t){}getLevel(){return 3}trace(t,...e){}debug(t,...e){}info(t,...e){}warn(t,...e){}error(t,...e){}critical(t,...e){}dispose(){}flush(){}},Ja=class extends Nu{};function gm(i){if(i.verbose)return 1;if(typeof i.logLevel=="string"){let t=Qy(i.logLevel.toLowerCase());if(t!==void 0)return t}return Vu}function Hy(i){switch(i){case 1:return"trace";case 2:return"debug";case 3:return"info";case 4:return"warn";case 5:return"error";case 0:return"off"}}function Qy(i){switch(i){case"trace":return 1;case"debug":return 2;case"info":return 3;case"warn":return 4;case"error":return 5;case"critical":return 5;case"off":return 0}}var Pw=new za("logLevel",Hy(3));var Xa=B("policy"),Li=class extends _{constructor(){super(...arguments);this.policyDefinitions={};this.policies=new Map;this._onDidChange=this._register(new R);this.onDidChange=this._onDidChange.event}async updatePolicyDefinitions(e){let r=Object.keys(this.policyDefinitions).length;return this.policyDefinitions={...e,...this.policyDefinitions},r!==Object.keys(this.policyDefinitions).length&&await this._updatePolicyDefinitions(this.policyDefinitions),Er.reduce(this.policies.entries(),(n,[o,s])=>({...n,[o]:s}),{})}getPolicyValue(e){return this.policies.get(e)}serialize(){return Er.reduce(Object.entries(this.policyDefinitions),(e,[r,n])=>({...e,[r]:{definition:n,value:this.policies.get(r)}}),{})}},Ai=class{constructor(){this.onDidChange=J.None;this.policyDefinitions={}}async updatePolicyDefinitions(){return{}}getPolicyValue(){}serialize(){}};var Ya=class extends _{constructor(e){super();this.logService=e;this._onDidChangeConfiguration=this._register(new R);this.onDidChangeConfiguration=this._onDidChangeConfiguration.event;this._configurationModel=Ae.createEmptyModel(e)}get configurationModel(){return this._configurationModel}async initialize(){return this.resetConfigurationModel(),this._register(it.as(Kt.Configuration).onDidUpdateConfiguration(({properties:e,defaultsOverrides:r})=>this.onDidUpdateConfiguration(Array.from(e),r))),this.configurationModel}reload(){return this.resetConfigurationModel(),this.configurationModel}onDidUpdateConfiguration(e,r){this.updateConfigurationModel(e,it.as(Kt.Configuration).getConfigurationProperties()),this._onDidChangeConfiguration.fire({defaults:this.configurationModel,properties:e})}getConfigurationDefaultOverrides(){return{}}resetConfigurationModel(){this._configurationModel=Ae.createEmptyModel(this.logService);let e=it.as(Kt.Configuration).getConfigurationProperties();this.updateConfigurationModel(Object.keys(e),e)}updateConfigurationModel(e,r){let n=this.getConfigurationDefaultOverrides();for(let o of e){let s=n[o],a=r[o];s!==void 0?this._configurationModel.setValue(o,s):a?this._configurationModel.setValue(o,tr(a.default)):this._configurationModel.removeValue(o)}}},Za=class{constructor(){this.onDidChangeConfiguration=J.None;this.configurationModel=Ae.createEmptyModel(new Ja)}async initialize(){return this.configurationModel}},Ui=class extends _{constructor(e,r,n){super();this.defaultConfiguration=e;this.policyService=r;this.logService=n;this._onDidChangeConfiguration=this._register(new R);this.onDidChangeConfiguration=this._onDidChangeConfiguration.event;this._configurationModel=Ae.createEmptyModel(this.logService),this.configurationRegistry=it.as(Kt.Configuration)}get configurationModel(){return this._configurationModel}async initialize(){return this.logService.trace("PolicyConfiguration#initialize"),this.update(await this.updatePolicyDefinitions(this.defaultConfiguration.configurationModel.keys),!1),this.update(await this.updatePolicyDefinitions(Object.keys(this.configurationRegistry.getExcludedConfigurationProperties())),!1),this._register(this.policyService.onDidChange(e=>this.onDidChangePolicies(e))),this._register(this.defaultConfiguration.onDidChangeConfiguration(async({properties:e})=>this.update(await this.updatePolicyDefinitions(e),!0))),this._configurationModel}async updatePolicyDefinitions(e){this.logService.trace("PolicyConfiguration#updatePolicyDefinitions",e);let r={},n=[],o=this.configurationRegistry.getConfigurationProperties(),s=this.configurationRegistry.getExcludedConfigurationProperties();for(let a of e){let l=o[a]??s[a];if(!l){n.push(a);continue}if(l.policy){if(l.type!=="string"&&l.type!=="number"&&l.type!=="array"&&l.type!=="object"&&l.type!=="boolean"){this.logService.warn(`Policy ${l.policy.name} has unsupported type ${l.type}`);continue}let{value:c}=l.policy;n.push(a),r[l.policy.name]={type:l.type==="number"?"number":l.type==="boolean"?"boolean":"string",value:c}}}return Hs(r)||await this.policyService.updatePolicyDefinitions(r),n}onDidChangePolicies(e){this.logService.trace("PolicyConfiguration#onDidChangePolicies",e);let r=this.configurationRegistry.getPolicyConfigurations(),n=br(e.map(o=>r.get(o)));this.update(n,!0)}update(e,r){this.logService.trace("PolicyConfiguration#update",e);let n=this.configurationRegistry.getConfigurationProperties(),o=this.configurationRegistry.getExcludedConfigurationProperties(),s=[],a=this._configurationModel.isEmpty();for(let l of e){let c=n[l]??o[l],u=c?.policy?.name;if(u){let p=this.policyService.getPolicyValue(u);if(te(p)&&c.type!=="string")try{p=this.parse(p)}catch(f){this.logService.error(`Error parsing policy value ${u}:`,G(f));continue}(a?p!==void 0:!xt(this._configurationModel.getValue(l),p))&&s.push([l,p])}else this._configurationModel.getValue(l)!==void 0&&s.push([l,void 0])}if(s.length){this.logService.trace("PolicyConfiguration#changed",s);let l=this._configurationModel;this._configurationModel=Ae.createEmptyModel(this.logService);for(let c of l.keys)this._configurationModel.setValue(c,l.getValue(c));for(let[c,u]of s)u===void 0?this._configurationModel.removeValue(c):this._configurationModel.setValue(c,u);r&&this._onDidChangeConfiguration.fire(this._configurationModel)}}parse(e){let r={},n=null,o=[],s=[],a=[];function l(u){if(Array.isArray(o))o.push(u);else if(n!==null){if(o[n]!==void 0)throw new Error(`Duplicate property found: ${n}`);o[n]=u}}if(e&&(Ii(e,{onObjectBegin:()=>{let u={};l(u),s.push(o),o=u,n=null},onObjectProperty:u=>{n=u},onObjectEnd:()=>{o=s.pop()},onArrayBegin:()=>{let u=[];l(u),s.push(o),o=u,n=null},onArrayEnd:()=>{o=s.pop()},onLiteralValue:l,onError:(u,p,f)=>{a.push({error:u,offset:p,length:f})}}),r=o[0]||r),a.length>0)throw new Error(a.map(u=>G(u.error)).join(`
`));return r}};Ui=T([I(1,Xa),I(2,V)],Ui);var el=class extends _{constructor(e,r,n,o){super();this.settingsResource=e;this.logService=o;this._onDidChangeConfiguration=this._register(new R);this.onDidChangeConfiguration=this._onDidChangeConfiguration.event;this.defaultConfiguration=this._register(new Ya(o)),this.policyConfiguration=n instanceof Ai?new Za:this._register(new Ui(this.defaultConfiguration,n,o)),this.userConfiguration=this._register(new Wa(this.settingsResource,{},On,r,o)),this.configuration=new _i(this.defaultConfiguration.configurationModel,this.policyConfiguration.configurationModel,Ae.createEmptyModel(o),Ae.createEmptyModel(o),Ae.createEmptyModel(o),Ae.createEmptyModel(o),new be,Ae.createEmptyModel(o),new be,o),this.configurationEditing=new Wu(e,r,this),this.reloadConfigurationScheduler=this._register(new Dr(()=>this.reloadConfiguration(),50)),this._register(this.defaultConfiguration.onDidChangeConfiguration(({defaults:s,properties:a})=>this.onDidDefaultConfigurationChange(s,a))),this._register(this.policyConfiguration.onDidChangeConfiguration(s=>this.onDidPolicyConfigurationChange(s))),this._register(this.userConfiguration.onDidChange(()=>this.reloadConfigurationScheduler.schedule()))}async initialize(){let[e,r,n]=await Promise.all([this.defaultConfiguration.initialize(),this.policyConfiguration.initialize(),this.userConfiguration.loadConfiguration()]);this.configuration=new _i(e,r,Ae.createEmptyModel(this.logService),n,Ae.createEmptyModel(this.logService),Ae.createEmptyModel(this.logService),new be,Ae.createEmptyModel(this.logService),new be,this.logService)}getConfigurationData(){return this.configuration.toData()}getValue(e,r){let n=typeof e=="string"?e:void 0,o=ha(e)?e:ha(r)?r:{};return this.configuration.getValue(n,o,void 0)}async updateValue(e,r,n,o,s){let a=Rf(n)?n:ha(n)?{resource:n.resource,overrideIdentifiers:n.overrideIdentifier?[n.overrideIdentifier]:void 0}:void 0,l=a?o:n;if(l!==void 0&&l!==3&&l!==2)throw new Error(`Unable to write ${e} to target ${l}.`);a?.overrideIdentifiers&&(a.overrideIdentifiers=Mt(a.overrideIdentifiers),a.overrideIdentifiers=a.overrideIdentifiers.length?a.overrideIdentifiers:void 0);let c=this.inspect(e,{resource:a?.resource,overrideIdentifier:a?.overrideIdentifiers?a.overrideIdentifiers[0]:void 0});if(c.policyValue!==void 0)throw new Error(`Unable to write ${e} because it is configured in system policy.`);if(xt(r,c.defaultValue)&&(r=void 0),a?.overrideIdentifiers?.length&&a.overrideIdentifiers.length>1){let p=a.overrideIdentifiers.sort(),f=this.configuration.localUserConfiguration.overrides.find(g=>xr([...g.identifiers].sort(),p));f&&(a.overrideIdentifiers=f.identifiers)}let u=a?.overrideIdentifiers?.length?[rm(a.overrideIdentifiers),e]:[e];await this.configurationEditing.write(u,r),await this.reloadConfiguration()}inspect(e,r={}){return this.configuration.inspect(e,r,void 0)}keys(){return this.configuration.keys(void 0)}async reloadConfiguration(){let e=await this.userConfiguration.loadConfiguration();this.onDidChangeUserConfiguration(e)}onDidChangeUserConfiguration(e){let r=this.configuration.toData(),n=this.configuration.compareAndUpdateLocalUserConfiguration(e);this.trigger(n,r,2)}onDidDefaultConfigurationChange(e,r){let n=this.configuration.toData(),o=this.configuration.compareAndUpdateDefaultConfiguration(e,r);this.trigger(o,n,7)}onDidPolicyConfigurationChange(e){let r=this.configuration.toData(),n=this.configuration.compareAndUpdatePolicyConfiguration(e);this.trigger(n,r,7)}trigger(e,r,n){let o=new Ba(e,{data:r},this.configuration,void 0,this.logService);o.source=n,this._onDidChangeConfiguration.fire(o)}},Wu=class{constructor(t,e,r){this.settingsResource=t;this.fileService=e;this.configurationService=r;this.queue=new jt}write(t,e){return this.queue.queue(()=>this.doWriteConfiguration(t,e))}async doWriteConfiguration(t,e){let r;try{r=(await this.fileService.readFile(this.settingsResource)).value.toString()}catch(s){if(s.fileOperationResult===1)r="{}";else throw s}let n=[];if(Ur(r,n,{allowTrailingComma:!0,allowEmptyContent:!0}),n.length>0)throw new Error("Unable to write into the settings file. Please open the file to correct errors/warnings in the file and try again.");let o=this.getEdits(r,t,e);r=jf(r,o),await this.fileService.writeFile(this.settingsResource,U.fromString(r))}getEdits(t,e,r){let{tabSize:n,insertSpaces:o,eol:s}=this.formattingOptions;if(!e.length){let a=JSON.stringify(r,null,o?" ".repeat(n):"	");return[{content:a,length:a.length,offset:0}]}return $f(t,e,r,{tabSize:n,insertSpaces:o,eol:s})}get formattingOptions(){if(!this._formattingOptions){let t=Do===3||Do===2?`
`:`\r
`,e=this.configurationService.getValue("files.eol",{overrideIdentifier:"jsonc"});e&&typeof e=="string"&&e!=="auto"&&(t=e),this._formattingOptions={eol:t,insertSpaces:!!this.configurationService.getValue("editor.insertSpaces",{overrideIdentifier:"jsonc"}),tabSize:this.configurationService.getValue("editor.tabSize",{overrideIdentifier:"jsonc"})}}return this._formattingOptions}};var tl=B("downloadService");var rr=B("requestService"),Gu=class{constructor(t){this.original=t}toJSON(){if(!this.headers){let t=Object.create(null);for(let e in this.original)e.toLowerCase()==="authorization"||e.toLowerCase()==="proxy-authorization"?t[e]="*****":t[e]=this.original[e];this.headers=t}return this.headers}},rl=class extends _{constructor(e){super();this.logService=e;this.counter=0}async logAndRequest(e,r){let n=`#${++this.counter}: ${e.url}`;this.logService.trace(`${n} - begin`,e.type,new Gu(e.headers??{}));try{let o=await r();return this.logService.trace(`${n} - end`,e.type,o.res.statusCode,o.res.headers),o}catch(o){throw this.logService.error(`${n} - error`,e.type,G(o)),o}}};function Mi(i){return i.res.statusCode&&i.res.statusCode>=200&&i.res.statusCode<300||i.res.statusCode===1223}function Im(i){return!!i.res.statusCode&&i.res.statusCode>=400&&i.res.statusCode<500}function xm(i){return!!i.res.statusCode&&i.res.statusCode>=500&&i.res.statusCode<600}function bm(i){return i.res.statusCode===204}async function qu(i){return bm(i)?null:(await Ar(i.stream)).toString()}async function vn(i){if(!Mi(i))throw new Error("Server returned "+i.res.statusCode);return qu(i)}async function yn(i){if(!Mi(i))throw new Error("Server returned "+i.res.statusCode);if(bm(i))return null;let e=(await Ar(i.stream)).toString();try{return JSON.parse(e)}catch(r){throw r.message+=`:
`+e,r}}var Ku=!1,Bu=[],vm,ym;function Xy(i=!0,t=!0){if(vm===i&&ym===t)return;vm=i,ym=t;let e=it.as(Kt.Configuration),r=Bu;Bu=[{id:"http",order:15,title:m(2259,null),type:"object",scope:2,properties:{"http.useLocalProxyConfiguration":{type:"boolean",default:t,markdownDescription:m(2274,null),restricted:!0}}},{id:"http",order:15,title:m(2259,null),type:"object",scope:1,properties:{"http.electronFetch":{type:"boolean",default:!1,description:m(2257,null),restricted:!0}}},{id:"http",order:15,title:m(2259,null),type:"object",scope:i?1:2,properties:{"http.proxy":{type:"string",pattern:"^(https?|socks|socks4a?|socks5h?)://([^:]*(:[^@]*)?@)?([^:]+|\\[[:0-9a-fA-F]+\\])(:\\d+)?/?$|^$",markdownDescription:m(2262,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0},"http.proxyStrictSSL":{type:"boolean",default:!0,markdownDescription:m(2270,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0},"http.proxyKerberosServicePrincipal":{type:"string",markdownDescription:m(2264,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0},"http.noProxy":{type:"array",items:{type:"string"},markdownDescription:m(2261,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0},"http.proxyAuthorization":{type:["null","string"],default:null,markdownDescription:m(2263,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0},"http.proxySupport":{type:"string",enum:["off","on","fallback","override"],enumDescriptions:[m(2267,null),m(2268,null),m(2266,null),m(2269,null)],default:"override",markdownDescription:m(2265,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0},"http.systemCertificates":{type:"boolean",default:!0,markdownDescription:m(2271,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0},"http.systemCertificatesNode":{type:"boolean",tags:["experimental"],default:Ku,markdownDescription:m(2272,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0,experiment:{mode:"auto"}},"http.experimental.systemCertificatesV2":{type:"boolean",tags:["experimental"],default:!1,markdownDescription:m(2273,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0},"http.fetchAdditionalSupport":{type:"boolean",default:!0,markdownDescription:m(2258,null,"`#http.useLocalProxyConfiguration#`","`#http.proxySupport#`","`#http.systemCertificates#`"),restricted:!0},"http.experimental.networkInterfaceCheckInterval":{type:"number",default:300,minimum:-1,tags:["experimental"],markdownDescription:m(2260,null,"`#http.useLocalProxyConfiguration#`"),restricted:!0,experiment:{mode:"auto"}}}}],e.updateConfigurations({add:Bu,remove:r})}Xy();var Fi=class{constructor(t,e){this.requestService=t;this.fileService=e}async download(t,e,r=re.None){if(t.scheme===$.file||t.scheme===$.vscodeRemote){await this.fileService.copy(t,e);return}let n={type:"GET",url:t.toString(!0)},o=await this.requestService.request(n,r);if(o.res.statusCode===200)await this.fileService.writeFile(e,o.stream);else{let s=await vn(o);throw new Error(`Expected 200, got back ${o.res.statusCode} instead.

${s}`)}}};Fi=T([I(0,rr),I(1,ee)],Fi);var gt=B("environmentService"),Qe=gt;import{homedir as s1,tmpdir as a1}from"os";var Zy=60,e1=Zy*60,zu=e1*24,YP=zu*7,ZP=zu*30,e2=zu*365;function Sm(i){return i.getFullYear()+"-"+String(i.getMonth()+1).padStart(2,"0")+"-"+String(i.getDate()).padStart(2,"0")+"T"+String(i.getHours()).padStart(2,"0")+":"+String(i.getMinutes()).padStart(2,"0")+":"+String(i.getSeconds()).padStart(2,"0")+"."+(i.getMilliseconds()/1e3).toFixed(3).slice(2,5)+"Z"}function ge(i,t,e){let r=null,n=null;if(typeof e.value=="function"?(r="value",n=e.value,n.length!==0&&console.warn("Memoize should only be used in functions with zero parameters")):typeof e.get=="function"&&(r="get",n=e.get),!n)throw new Error("not supported");let o=`$memoize$${t}`;e[r]=function(...s){return this.hasOwnProperty(o)||Object.defineProperty(this,o,{configurable:!1,enumerable:!1,writable:!1,value:n.apply(this,s)}),this[o]}}var Em=/^([^.]+\..+)[:=](.+)$/,fe=class{constructor(t,e,r){this._args=t;this.paths=e;this.productService=r}get appRoot(){return Rt(_r.asFileUri("").fsPath)}get userHome(){return P.file(this.paths.homeDir)}get userDataPath(){return this.paths.userDataDir}get appSettingsHome(){return P.file(q(this.userDataPath,"User"))}get tmpDir(){return P.file(this.paths.tmpDir)}get cacheHome(){return P.file(this.userDataPath)}get stateResource(){return z(this.appSettingsHome,"globalStorage","storage.json")}get userRoamingDataHome(){return this.appSettingsHome.with({scheme:$.vscodeUserData})}get userDataSyncHome(){return z(this.appSettingsHome,"sync")}get logsHome(){if(!this.args.logsPath){let t=Sm(new Date).replace(/-|:|\.\d+Z$/g,"");this.args.logsPath=q(this.userDataPath,"logs",t)}return P.file(this.args.logsPath)}get sync(){return this.args.sync}get workspaceStorageHome(){return z(this.appSettingsHome,"workspaceStorage")}get localHistoryHome(){return z(this.appSettingsHome,"History")}get keyboardLayoutResource(){return z(this.userRoamingDataHome,"keyboardLayout.json")}get argvResource(){let t=Ot.VSCODE_PORTABLE;return t?P.file(q(t,"argv.json")):z(this.userHome,this.productService.dataFolderName,"argv.json")}get isExtensionDevelopment(){return!!this.args.extensionDevelopmentPath}get untitledWorkspacesHome(){return P.file(q(this.userDataPath,"Workspaces"))}get builtinExtensionsPath(){let t=this.args["builtin-extensions-dir"];return t?Rr(t):Wt(q(_r.asFileUri("").fsPath,"..","extensions"))}get extensionsDownloadLocation(){let t=this.args["extensions-download-dir"];return t?P.file(Rr(t)):P.file(q(this.userDataPath,"CachedExtensionVSIXs"))}get extensionsPath(){let t=this.args["extensions-dir"];if(t)return Rr(t);let e=Ot.VSCODE_EXTENSIONS;if(e)return e;let r=Ot.VSCODE_PORTABLE;return r?q(r,"extensions"):z(this.userHome,this.productService.dataFolderName,"extensions").fsPath}get extensionDevelopmentLocationURI(){let t=this.args.extensionDevelopmentPath;if(Array.isArray(t))return t.map(e=>/^[^:/?#]+?:\/\//.test(e)?P.parse(e):P.file(Wt(e)))}get extensionDevelopmentKind(){return this.args.extensionDevelopmentKind?.map(t=>t==="ui"||t==="workspace"||t==="web"?t:"workspace")}get extensionTestsLocationURI(){let t=this.args.extensionTestsPath;if(t)return/^[^:/?#]+?:\/\//.test(t)?P.parse(t):P.file(Wt(t))}get disableExtensions(){if(this.args["disable-extensions"])return!0;let t=this.args["disable-extension"];if(t){if(typeof t=="string")return[t];if(Array.isArray(t)&&t.length>0)return t}return!1}get debugExtensionHost(){return t1(this.args,this.isBuilt)}get debugRenderer(){return!!this.args.debugRenderer}get isBuilt(){return!Ot.VSCODE_DEV}get verbose(){return!!this.args.verbose}get logLevel(){return this.args.log?.find(t=>!Em.test(t))}get extensionLogLevel(){let t=[];for(let e of this.args.log||[]){let r=Em.exec(e);r?.[1]&&r[2]&&t.push([r[1],r[2]])}return t.length?t:void 0}get serviceMachineIdResource(){return z(P.file(this.userDataPath),"machineid")}get crashReporterId(){return this.args["crash-reporter-id"]}get crashReporterDirectory(){return this.args["crash-reporter-directory"]}get disableTelemetry(){return!!this.args["disable-telemetry"]}get disableExperiments(){return!!this.args["disable-experiments"]}get disableWorkspaceTrust(){return!!this.args["disable-workspace-trust"]}get useInMemorySecretStorage(){return!!this.args["use-inmemory-secretstorage"]}get policyFile(){if(this.args["__enable-file-policy"]){let t=Ot.VSCODE_PORTABLE;return t?P.file(q(t,"policy.json")):z(this.userHome,this.productService.dataFolderName,"policy.json")}}get agentSessionsWorkspace(){return z(this.appSettingsHome,"agent-sessions.code-workspace")}get editSessionId(){return this.args.editSessionId}get exportPolicyData(){return this.args["export-policy-data"]}get continueOn(){return this.args.continueOn}set continueOn(t){this.args.continueOn=t}get args(){return this._args}};T([ge],fe.prototype,"appRoot",1),T([ge],fe.prototype,"userHome",1),T([ge],fe.prototype,"userDataPath",1),T([ge],fe.prototype,"appSettingsHome",1),T([ge],fe.prototype,"tmpDir",1),T([ge],fe.prototype,"cacheHome",1),T([ge],fe.prototype,"stateResource",1),T([ge],fe.prototype,"userRoamingDataHome",1),T([ge],fe.prototype,"userDataSyncHome",1),T([ge],fe.prototype,"sync",1),T([ge],fe.prototype,"workspaceStorageHome",1),T([ge],fe.prototype,"localHistoryHome",1),T([ge],fe.prototype,"keyboardLayoutResource",1),T([ge],fe.prototype,"argvResource",1),T([ge],fe.prototype,"isExtensionDevelopment",1),T([ge],fe.prototype,"untitledWorkspacesHome",1),T([ge],fe.prototype,"builtinExtensionsPath",1),T([ge],fe.prototype,"extensionsDownloadLocation",1),T([ge],fe.prototype,"extensionsPath",1),T([ge],fe.prototype,"extensionDevelopmentLocationURI",1),T([ge],fe.prototype,"extensionDevelopmentKind",1),T([ge],fe.prototype,"extensionTestsLocationURI",1),T([ge],fe.prototype,"debugExtensionHost",1),T([ge],fe.prototype,"logLevel",1),T([ge],fe.prototype,"extensionLogLevel",1),T([ge],fe.prototype,"serviceMachineIdResource",1),T([ge],fe.prototype,"disableTelemetry",1),T([ge],fe.prototype,"disableExperiments",1),T([ge],fe.prototype,"disableWorkspaceTrust",1),T([ge],fe.prototype,"useInMemorySecretStorage",1),T([ge],fe.prototype,"policyFile",1),T([ge],fe.prototype,"agentSessionsWorkspace",1);function t1(i,t){return wm(i["inspect-extensions"],i["inspect-brk-extensions"],5870,t,i.debugId,i.extensionEnvironment)}function wm(i,t,e,r,n,o){let a=Number(t||i)||(r?null:e),l=a?!!t:!1,c;if(o)try{c=JSON.parse(o)}catch{}return{port:a,break:l,debugId:n,env:c}}import{homedir as Pm}from"os";import{resolve as r1,isAbsolute as n1,join as Oi}from"path";var i1=process.env.VSCODE_CWD||process.cwd();function Tm(i,t){let e=o1(i,t),r=[e];return n1(e)||r.unshift(i1),r1(...r)}function o1(i,t){process.env.VSCODE_DEV&&(process.isEmbeddedApp?t="sessions-oss-dev":t="code-oss-dev");let e=process.env.VSCODE_PORTABLE;if(e)return Oi(e,"user-data");let r=process.env.VSCODE_APPDATA;if(r)return Oi(r,t);let n=i["user-data-dir"];if(n)return n;switch(process.platform){case"win32":if(r=process.env.APPDATA,!r){let o=process.env.USERPROFILE;if(typeof o!="string")throw new Error("Windows: Unexpected undefined %USERPROFILE% environment variable");r=Oi(o,"AppData","Roaming")}break;case"darwin":r=Oi(Pm(),"Library","Application Support");break;case"linux":r=process.env.XDG_CONFIG_HOME||Oi(Pm(),".config");break;default:throw new Error("Platform not supported")}return Oi(r,t)}var nl=class extends fe{constructor(t,e){super(t,{homeDir:s1(),tmpDir:a1(),userDataDir:Tm(t,e.nameShort)},e)}};var il={},ae={exports:il};(function(i,t){if(typeof il=="object"&&typeof ae=="object")ae.exports=t();else if(typeof define=="function"&&define.amd)define([],t);else{var e=t();for(var r in e)(typeof il=="object"?il:i)[r]=e[r]}})(typeof self<"u"?self:void 0,(function(){return(function(i){var t={};function e(r){if(t[r])return t[r].exports;var n=t[r]={i:r,l:!1,exports:{}};return i[r].call(n.exports,n,n.exports,e),n.l=!0,n.exports}return e.m=i,e.c=t,e.d=function(r,n,o){e.o(r,n)||Object.defineProperty(r,n,{enumerable:!0,get:o})},e.r=function(r){typeof Symbol<"u"&&Symbol.toStringTag&&Object.defineProperty(r,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(r,"__esModule",{value:!0})},e.t=function(r,n){if(1&n&&(r=e(r)),8&n||4&n&&typeof r=="object"&&r&&r.__esModule)return r;var o=Object.create(null);if(e.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:r}),2&n&&typeof r!="string")for(var s in r)e.d(o,s,function(a){return r[a]}.bind(null,s));return o},e.n=function(r){var n=r&&r.__esModule?function(){return r.default}:function(){return r};return e.d(n,"a",n),n},e.o=function(r,n){return Object.prototype.hasOwnProperty.call(r,n)},e.p="",e(e.s=0)})([function(i,t,e){(function(r){var n;t=i.exports=ve,n=typeof r=="object"&&r.env&&r.env.NODE_DEBUG&&/\bsemver\b/i.test(r.env.NODE_DEBUG)?function(){var x=Array.prototype.slice.call(arguments,0);x.unshift("SEMVER"),console.log.apply(console,x)}:function(){},t.SEMVER_SPEC_VERSION="2.0.0";var o=256,s=Number.MAX_SAFE_INTEGER||9007199254740991,a=t.re=[],l=t.src=[],c=0,u=c++;l[u]="0|[1-9]\\d*";var p=c++;l[p]="[0-9]+";var f=c++;l[f]="\\d*[a-zA-Z-][a-zA-Z0-9-]*";var g=c++;l[g]="("+l[u]+")\\.("+l[u]+")\\.("+l[u]+")";var v=c++;l[v]="("+l[p]+")\\.("+l[p]+")\\.("+l[p]+")";var h=c++;l[h]="(?:"+l[u]+"|"+l[f]+")";var y=c++;l[y]="(?:"+l[p]+"|"+l[f]+")";var E=c++;l[E]="(?:-("+l[h]+"(?:\\."+l[h]+")*))";var b=c++;l[b]="(?:-?("+l[y]+"(?:\\."+l[y]+")*))";var C=c++;l[C]="[0-9A-Za-z-]+";var N=c++;l[N]="(?:\\+("+l[C]+"(?:\\."+l[C]+")*))";var oe=c++,Fe="v?"+l[g]+l[E]+"?"+l[N]+"?";l[oe]="^"+Fe+"$";var L="[v=\\s]*"+l[v]+l[b]+"?"+l[N]+"?",j=c++;l[j]="^"+L+"$";var F=c++;l[F]="((?:<|>)?=?)";var xe=c++;l[xe]=l[p]+"|x|X|\\*";var Et=c++;l[Et]=l[u]+"|x|X|\\*";var st=c++;l[st]="[v=\\s]*("+l[Et]+")(?:\\.("+l[Et]+")(?:\\.("+l[Et]+")(?:"+l[E]+")?"+l[N]+"?)?)?";var rn=c++;l[rn]="[v=\\s]*("+l[xe]+")(?:\\.("+l[xe]+")(?:\\.("+l[xe]+")(?:"+l[b]+")?"+l[N]+"?)?)?";var hr=c++;l[hr]="^"+l[F]+"\\s*"+l[st]+"$";var M=c++;l[M]="^"+l[F]+"\\s*"+l[rn]+"$";var k=c++;l[k]="(?:^|[^\\d])(\\d{1,16})(?:\\.(\\d{1,16}))?(?:\\.(\\d{1,16}))?(?:$|[^\\d])";var A=c++;l[A]="(?:~>?)";var D=c++;l[D]="(\\s*)"+l[A]+"\\s+",a[D]=new RegExp(l[D],"g");var O=c++;l[O]="^"+l[A]+l[st]+"$";var Q=c++;l[Q]="^"+l[A]+l[rn]+"$";var se=c++;l[se]="(?:\\^)";var De=c++;l[De]="(\\s*)"+l[se]+"\\s+",a[De]=new RegExp(l[De],"g");var we=c++;l[we]="^"+l[se]+l[st]+"$";var at=c++;l[at]="^"+l[se]+l[rn]+"$";var vt=c++;l[vt]="^"+l[F]+"\\s*("+L+")$|^$";var zt=c++;l[zt]="^"+l[F]+"\\s*("+Fe+")$|^$";var wt=c++;l[wt]="(\\s*)"+l[F]+"\\s*("+L+"|"+l[st]+")",a[wt]=new RegExp(l[wt],"g");var vr=c++;l[vr]="^\\s*("+l[st]+")\\s+-\\s+("+l[st]+")\\s*$";var xo=c++;l[xo]="^\\s*("+l[rn]+")\\s+-\\s+("+l[rn]+")\\s*$";var bo=c++;l[bo]="(<|>)?=?\\s*\\*";for(var K=0;K<35;K++)n(K,l[K]),a[K]||(a[K]=new RegExp(l[K]));function Rn(x,S){if(x instanceof ve)return x;if(typeof x!="string"||x.length>o||!(S?a[j]:a[oe]).test(x))return null;try{return new ve(x,S)}catch{return null}}function ve(x,S){if(x instanceof ve){if(x.loose===S)return x;x=x.version}else if(typeof x!="string")throw new TypeError("Invalid Version: "+x);if(x.length>o)throw new TypeError("version is longer than "+o+" characters");if(!(this instanceof ve))return new ve(x,S);n("SemVer",x,S),this.loose=S;var w=x.trim().match(S?a[j]:a[oe]);if(!w)throw new TypeError("Invalid Version: "+x);if(this.raw=x,this.major=+w[1],this.minor=+w[2],this.patch=+w[3],this.major>s||this.major<0)throw new TypeError("Invalid major version");if(this.minor>s||this.minor<0)throw new TypeError("Invalid minor version");if(this.patch>s||this.patch<0)throw new TypeError("Invalid patch version");w[4]?this.prerelease=w[4].split(".").map((function(W){if(/^[0-9]+$/.test(W)){var X=+W;if(X>=0&&X<s)return X}return W})):this.prerelease=[],this.build=w[5]?w[5].split("."):[],this.format()}t.parse=Rn,t.valid=function(x,S){var w=Rn(x,S);return w?w.version:null},t.clean=function(x,S){var w=Rn(x.trim().replace(/^[=v]+/,""),S);return w?w.version:null},t.SemVer=ve,ve.prototype.format=function(){return this.version=this.major+"."+this.minor+"."+this.patch,this.prerelease.length&&(this.version+="-"+this.prerelease.join(".")),this.version},ve.prototype.toString=function(){return this.version},ve.prototype.compare=function(x){return n("SemVer.compare",this.version,this.loose,x),x instanceof ve||(x=new ve(x,this.loose)),this.compareMain(x)||this.comparePre(x)},ve.prototype.compareMain=function(x){return x instanceof ve||(x=new ve(x,this.loose)),oi(this.major,x.major)||oi(this.minor,x.minor)||oi(this.patch,x.patch)},ve.prototype.comparePre=function(x){if(x instanceof ve||(x=new ve(x,this.loose)),this.prerelease.length&&!x.prerelease.length)return-1;if(!this.prerelease.length&&x.prerelease.length)return 1;if(!this.prerelease.length&&!x.prerelease.length)return 0;var S=0;do{var w=this.prerelease[S],W=x.prerelease[S];if(n("prerelease compare",S,w,W),w===void 0&&W===void 0)return 0;if(W===void 0)return 1;if(w===void 0)return-1;if(w!==W)return oi(w,W)}while(++S)},ve.prototype.inc=function(x,S){switch(x){case"premajor":this.prerelease.length=0,this.patch=0,this.minor=0,this.major++,this.inc("pre",S);break;case"preminor":this.prerelease.length=0,this.patch=0,this.minor++,this.inc("pre",S);break;case"prepatch":this.prerelease.length=0,this.inc("patch",S),this.inc("pre",S);break;case"prerelease":this.prerelease.length===0&&this.inc("patch",S),this.inc("pre",S);break;case"major":this.minor===0&&this.patch===0&&this.prerelease.length!==0||this.major++,this.minor=0,this.patch=0,this.prerelease=[];break;case"minor":this.patch===0&&this.prerelease.length!==0||this.minor++,this.patch=0,this.prerelease=[];break;case"patch":this.prerelease.length===0&&this.patch++,this.prerelease=[];break;case"pre":if(this.prerelease.length===0)this.prerelease=[0];else{for(var w=this.prerelease.length;--w>=0;)typeof this.prerelease[w]=="number"&&(this.prerelease[w]++,w=-2);w===-1&&this.prerelease.push(0)}S&&(this.prerelease[0]===S?isNaN(this.prerelease[1])&&(this.prerelease=[S,0]):this.prerelease=[S,0]);break;default:throw new Error("invalid increment argument: "+x)}return this.format(),this.raw=this.version,this},t.inc=function(x,S,w,W){typeof w=="string"&&(W=w,w=void 0);try{return new ve(x,w).inc(S,W).version}catch{return null}},t.diff=function(x,S){if(yc(x,S))return null;var w=Rn(x),W=Rn(S);if(w.prerelease.length||W.prerelease.length){for(var X in w)if((X==="major"||X==="minor"||X==="patch")&&w[X]!==W[X])return"pre"+X;return"prerelease"}for(var X in w)if((X==="major"||X==="minor"||X==="patch")&&w[X]!==W[X])return X},t.compareIdentifiers=oi;var rp=/^[0-9]+$/;function oi(x,S){var w=rp.test(x),W=rp.test(S);return w&&W&&(x=+x,S=+S),w&&!W?-1:W&&!w?1:x<S?-1:x>S?1:0}function Br(x,S,w){return new ve(x,w).compare(new ve(S,w))}function Fs(x,S,w){return Br(x,S,w)>0}function Os(x,S,w){return Br(x,S,w)<0}function yc(x,S,w){return Br(x,S,w)===0}function np(x,S,w){return Br(x,S,w)!==0}function Ic(x,S,w){return Br(x,S,w)>=0}function xc(x,S,w){return Br(x,S,w)<=0}function Ns(x,S,w,W){var X;switch(S){case"===":typeof x=="object"&&(x=x.version),typeof w=="object"&&(w=w.version),X=x===w;break;case"!==":typeof x=="object"&&(x=x.version),typeof w=="object"&&(w=w.version),X=x!==w;break;case"":case"=":case"==":X=yc(x,w,W);break;case"!=":X=np(x,w,W);break;case">":X=Fs(x,w,W);break;case">=":X=Ic(x,w,W);break;case"<":X=Os(x,w,W);break;case"<=":X=xc(x,w,W);break;default:throw new TypeError("Invalid operator: "+S)}return X}function Yt(x,S){if(x instanceof Yt){if(x.loose===S)return x;x=x.value}if(!(this instanceof Yt))return new Yt(x,S);n("comparator",x,S),this.loose=S,this.parse(x),this.semver===So?this.value="":this.value=this.operator+this.semver.version,n("comp",this)}t.rcompareIdentifiers=function(x,S){return oi(S,x)},t.major=function(x,S){return new ve(x,S).major},t.minor=function(x,S){return new ve(x,S).minor},t.patch=function(x,S){return new ve(x,S).patch},t.compare=Br,t.compareLoose=function(x,S){return Br(x,S,!0)},t.rcompare=function(x,S,w){return Br(S,x,w)},t.sort=function(x,S){return x.sort((function(w,W){return t.compare(w,W,S)}))},t.rsort=function(x,S){return x.sort((function(w,W){return t.rcompare(w,W,S)}))},t.gt=Fs,t.lt=Os,t.eq=yc,t.neq=np,t.gte=Ic,t.lte=xc,t.cmp=Ns,t.Comparator=Yt;var So={};function Ve(x,S){if(x instanceof Ve)return x.loose===S?x:new Ve(x.raw,S);if(x instanceof Yt)return new Ve(x.value,S);if(!(this instanceof Ve))return new Ve(x,S);if(this.loose=S,this.raw=x,this.set=x.split(/\s*\|\|\s*/).map((function(w){return this.parseRange(w.trim())}),this).filter((function(w){return w.length})),!this.set.length)throw new TypeError("Invalid SemVer Range: "+x);this.format()}function Pt(x){return!x||x.toLowerCase()==="x"||x==="*"}function iv(x,S,w,W,X,tt,ye,At,Ge,yt,yr,qe,lt){return((S=Pt(w)?"":Pt(W)?">="+w+".0.0":Pt(X)?">="+w+"."+W+".0":">="+S)+" "+(At=Pt(Ge)?"":Pt(yt)?"<"+(+Ge+1)+".0.0":Pt(yr)?"<"+Ge+"."+(+yt+1)+".0":qe?"<="+Ge+"."+yt+"."+yr+"-"+qe:"<="+At)).trim()}function ov(x,S){for(var w=0;w<x.length;w++)if(!x[w].test(S))return!1;if(S.prerelease.length){for(w=0;w<x.length;w++)if(n(x[w].semver),x[w].semver!==So&&x[w].semver.prerelease.length>0){var W=x[w].semver;if(W.major===S.major&&W.minor===S.minor&&W.patch===S.patch)return!0}return!1}return!0}function Vs(x,S,w){try{S=new Ve(S,w)}catch{return!1}return S.test(x)}function bc(x,S,w,W){var X,tt,ye,At,Ge;switch(x=new ve(x,W),S=new Ve(S,W),w){case">":X=Fs,tt=xc,ye=Os,At=">",Ge=">=";break;case"<":X=Os,tt=Ic,ye=Fs,At="<",Ge="<=";break;default:throw new TypeError('Must provide a hilo val of "<" or ">"')}if(Vs(x,S,W))return!1;for(var yt=0;yt<S.set.length;++yt){var yr=S.set[yt],qe=null,lt=null;if(yr.forEach((function(Ut){Ut.semver===So&&(Ut=new Yt(">=0.0.0")),qe=qe||Ut,lt=lt||Ut,X(Ut.semver,qe.semver,W)?qe=Ut:ye(Ut.semver,lt.semver,W)&&(lt=Ut)})),qe.operator===At||qe.operator===Ge||(!lt.operator||lt.operator===At)&&tt(x,lt.semver)||lt.operator===Ge&&ye(x,lt.semver))return!1}return!0}Yt.prototype.parse=function(x){var S=this.loose?a[vt]:a[zt],w=x.match(S);if(!w)throw new TypeError("Invalid comparator: "+x);this.operator=w[1],this.operator==="="&&(this.operator=""),w[2]?this.semver=new ve(w[2],this.loose):this.semver=So},Yt.prototype.toString=function(){return this.value},Yt.prototype.test=function(x){return n("Comparator.test",x,this.loose),this.semver===So||(typeof x=="string"&&(x=new ve(x,this.loose)),Ns(x,this.operator,this.semver,this.loose))},Yt.prototype.intersects=function(x,S){if(!(x instanceof Yt))throw new TypeError("a Comparator is required");var w;if(this.operator==="")return w=new Ve(x.value,S),Vs(this.value,w,S);if(x.operator==="")return w=new Ve(this.value,S),Vs(x.semver,w,S);var W=!(this.operator!==">="&&this.operator!==">"||x.operator!==">="&&x.operator!==">"),X=!(this.operator!=="<="&&this.operator!=="<"||x.operator!=="<="&&x.operator!=="<"),tt=this.semver.version===x.semver.version,ye=!(this.operator!==">="&&this.operator!=="<="||x.operator!==">="&&x.operator!=="<="),At=Ns(this.semver,"<",x.semver,S)&&(this.operator===">="||this.operator===">")&&(x.operator==="<="||x.operator==="<"),Ge=Ns(this.semver,">",x.semver,S)&&(this.operator==="<="||this.operator==="<")&&(x.operator===">="||x.operator===">");return W||X||tt&&ye||At||Ge},t.Range=Ve,Ve.prototype.format=function(){return this.range=this.set.map((function(x){return x.join(" ").trim()})).join("||").trim(),this.range},Ve.prototype.toString=function(){return this.range},Ve.prototype.parseRange=function(x){var S=this.loose;x=x.trim(),n("range",x,S);var w=S?a[xo]:a[vr];x=x.replace(w,iv),n("hyphen replace",x),x=x.replace(a[wt],"$1$2$3"),n("comparator trim",x,a[wt]),x=(x=(x=x.replace(a[D],"$1~")).replace(a[De],"$1^")).split(/\s+/).join(" ");var W=S?a[vt]:a[zt],X=x.split(" ").map((function(tt){return(function(ye,At){return n("comp",ye),ye=(function(Ge,yt){return Ge.trim().split(/\s+/).map((function(yr){return(function(qe,lt){n("caret",qe,lt);var Ut=lt?a[at]:a[we];return qe.replace(Ut,(function(ir,Z,le,Ce,Me){var ct;return n("caret",qe,ir,Z,le,Ce,Me),Pt(Z)?ct="":Pt(le)?ct=">="+Z+".0.0 <"+(+Z+1)+".0.0":Pt(Ce)?ct=Z==="0"?">="+Z+"."+le+".0 <"+Z+"."+(+le+1)+".0":">="+Z+"."+le+".0 <"+(+Z+1)+".0.0":Me?(n("replaceCaret pr",Me),Me.charAt(0)!=="-"&&(Me="-"+Me),ct=Z==="0"?le==="0"?">="+Z+"."+le+"."+Ce+Me+" <"+Z+"."+le+"."+(+Ce+1):">="+Z+"."+le+"."+Ce+Me+" <"+Z+"."+(+le+1)+".0":">="+Z+"."+le+"."+Ce+Me+" <"+(+Z+1)+".0.0"):(n("no pr"),ct=Z==="0"?le==="0"?">="+Z+"."+le+"."+Ce+" <"+Z+"."+le+"."+(+Ce+1):">="+Z+"."+le+"."+Ce+" <"+Z+"."+(+le+1)+".0":">="+Z+"."+le+"."+Ce+" <"+(+Z+1)+".0.0"),n("caret return",ct),ct}))})(yr,yt)})).join(" ")})(ye,At),n("caret",ye),ye=(function(Ge,yt){return Ge.trim().split(/\s+/).map((function(yr){return(function(qe,lt){var Ut=lt?a[Q]:a[O];return qe.replace(Ut,(function(ir,Z,le,Ce,Me){var ct;return n("tilde",qe,ir,Z,le,Ce,Me),Pt(Z)?ct="":Pt(le)?ct=">="+Z+".0.0 <"+(+Z+1)+".0.0":Pt(Ce)?ct=">="+Z+"."+le+".0 <"+Z+"."+(+le+1)+".0":Me?(n("replaceTilde pr",Me),Me.charAt(0)!=="-"&&(Me="-"+Me),ct=">="+Z+"."+le+"."+Ce+Me+" <"+Z+"."+(+le+1)+".0"):ct=">="+Z+"."+le+"."+Ce+" <"+Z+"."+(+le+1)+".0",n("tilde return",ct),ct}))})(yr,yt)})).join(" ")})(ye,At),n("tildes",ye),ye=(function(Ge,yt){return n("replaceXRanges",Ge,yt),Ge.split(/\s+/).map((function(yr){return(function(qe,lt){qe=qe.trim();var Ut=lt?a[M]:a[hr];return qe.replace(Ut,(function(ir,Z,le,Ce,Me,ct){n("xRange",qe,ir,Z,le,Ce,Me,ct);var ip=Pt(le),Eo=ip||Pt(Ce),wo=Eo||Pt(Me);return Z==="="&&wo&&(Z=""),ip?ir=Z===">"||Z==="<"?"<0.0.0":"*":Z&&wo?(Eo&&(Ce=0),wo&&(Me=0),Z===">"?(Z=">=",Eo?(le=+le+1,Ce=0,Me=0):wo&&(Ce=+Ce+1,Me=0)):Z==="<="&&(Z="<",Eo?le=+le+1:Ce=+Ce+1),ir=Z+le+"."+Ce+"."+Me):Eo?ir=">="+le+".0.0 <"+(+le+1)+".0.0":wo&&(ir=">="+le+"."+Ce+".0 <"+le+"."+(+Ce+1)+".0"),n("xRange return",ir),ir}))})(yr,yt)})).join(" ")})(ye,At),n("xrange",ye),ye=(function(Ge,yt){return n("replaceStars",Ge,yt),Ge.trim().replace(a[bo],"")})(ye,At),n("stars",ye),ye})(tt,S)})).join(" ").split(/\s+/);return this.loose&&(X=X.filter((function(tt){return!!tt.match(W)}))),X=X.map((function(tt){return new Yt(tt,S)}))},Ve.prototype.intersects=function(x,S){if(!(x instanceof Ve))throw new TypeError("a Range is required");return this.set.some((function(w){return w.every((function(W){return x.set.some((function(X){return X.every((function(tt){return W.intersects(tt,S)}))}))}))}))},t.toComparators=function(x,S){return new Ve(x,S).set.map((function(w){return w.map((function(W){return W.value})).join(" ").trim().split(" ")}))},Ve.prototype.test=function(x){if(!x)return!1;typeof x=="string"&&(x=new ve(x,this.loose));for(var S=0;S<this.set.length;S++)if(ov(this.set[S],x))return!0;return!1},t.satisfies=Vs,t.maxSatisfying=function(x,S,w){var W=null,X=null;try{var tt=new Ve(S,w)}catch{return null}return x.forEach((function(ye){tt.test(ye)&&(W&&X.compare(ye)!==-1||(X=new ve(W=ye,w)))})),W},t.minSatisfying=function(x,S,w){var W=null,X=null;try{var tt=new Ve(S,w)}catch{return null}return x.forEach((function(ye){tt.test(ye)&&(W&&X.compare(ye)!==1||(X=new ve(W=ye,w)))})),W},t.validRange=function(x,S){try{return new Ve(x,S).range||"*"}catch{return null}},t.ltr=function(x,S,w){return bc(x,S,"<",w)},t.gtr=function(x,S,w){return bc(x,S,">",w)},t.outside=bc,t.prerelease=function(x,S){var w=Rn(x,S);return w&&w.prerelease.length?w.prerelease:null},t.intersects=function(x,S,w){return x=new Ve(x,w),S=new Ve(S,w),x.intersects(S)},t.coerce=function(x){if(x instanceof ve)return x;if(typeof x!="string")return null;var S=x.match(a[k]);return S==null?null:Rn((S[1]||"0")+"."+(S[2]||"0")+"."+(S[3]||"0"))}}).call(this,e(1))},function(i,t){var e,r,n=i.exports={};function o(){throw new Error("setTimeout has not been defined")}function s(){throw new Error("clearTimeout has not been defined")}function a(y){if(e===setTimeout)return setTimeout(y,0);if((e===o||!e)&&setTimeout)return e=setTimeout,setTimeout(y,0);try{return e(y,0)}catch{try{return e.call(null,y,0)}catch{return e.call(this,y,0)}}}(function(){try{e=typeof setTimeout=="function"?setTimeout:o}catch{e=o}try{r=typeof clearTimeout=="function"?clearTimeout:s}catch{r=s}})();var l,c=[],u=!1,p=-1;function f(){u&&l&&(u=!1,l.length?c=l.concat(c):p=-1,c.length&&g())}function g(){if(!u){var y=a(f);u=!0;for(var E=c.length;E;){for(l=c,c=[];++p<E;)l&&l[p].run();p=-1,E=c.length}l=null,u=!1,(function(b){if(r===clearTimeout)return clearTimeout(b);if((r===s||!r)&&clearTimeout)return r=clearTimeout,clearTimeout(b);try{r(b)}catch{try{return r.call(null,b)}catch{return r.call(this,b)}}})(y)}}function v(y,E){this.fun=y,this.array=E}function h(){}n.nextTick=function(y){var E=new Array(arguments.length-1);if(arguments.length>1)for(var b=1;b<arguments.length;b++)E[b-1]=arguments[b];c.push(new v(y,E)),c.length!==1||u||a(g)},v.prototype.run=function(){this.fun.apply(null,this.array)},n.title="browser",n.browser=!0,n.env={},n.argv=[],n.version="",n.versions={},n.on=h,n.addListener=h,n.once=h,n.off=h,n.removeListener=h,n.removeAllListeners=h,n.emit=h,n.prependListener=h,n.prependOnceListener=h,n.listeners=function(y){return[]},n.binding=function(y){throw new Error("process.binding is not supported")},n.cwd=function(){return"/"},n.chdir=function(y){throw new Error("process.chdir is not supported")},n.umask=function(){return 0}}])}));var R2=ae.exports.SEMVER_SPEC_VERSION,C2=ae.exports.parse,Rm=ae.exports.valid,_2=ae.exports.coerce,k2=ae.exports.clean,D2=ae.exports.inc,L2=ae.exports.major,A2=ae.exports.minor,U2=ae.exports.patch,M2=ae.exports.prerelease,In=ae.exports.gt,F2=ae.exports.gte,O2=ae.exports.lt,N2=ae.exports.lte,Cm=ae.exports.eq,V2=ae.exports.neq,W2=ae.exports.cmp,B2=ae.exports.compare,ol=ae.exports.rcompare,G2=ae.exports.compareIdentifiers,q2=ae.exports.rcompareIdentifiers,K2=ae.exports.compareBuild,z2=ae.exports.sort,$2=ae.exports.rsort,j2=ae.exports.diff,H2=ae.exports.validRange,_m=ae.exports.satisfies,Q2=ae.exports.maxSatisfying,J2=ae.exports.minSatisfying,X2=ae.exports.minVersion,Y2=ae.exports.gtr,Z2=ae.exports.ltr,eT=ae.exports.outside,tT=ae.exports.intersects,rT=ae.exports.SemVer,nT=ae.exports.Comparator,iT=ae.exports.Range;var $u="Offline";function Hu(i){return i instanceof ju?!0:i instanceof Error&&i.name===$u&&i.message===$u}var ju=class extends Error{constructor(){super($u),this.name=this.message}};var km="/etc/vscode/policy.json";var aT={Extensions:{name:{key:"extensionsConfigurationTitle",value:m(136,null)}},IntegratedTerminal:{name:{key:"terminalIntegratedConfigurationTitle",value:m(139,null)}},InteractiveSession:{name:{key:"interactiveSessionConfigurationTitle",value:m(137,null)}},Telemetry:{name:{key:"telemetryConfigurationTitle",value:m(138,null)}},Update:{name:{key:"updateConfigurationTitle",value:m(140,null)}}};var al="extensions.user.cache",Dm="extensions.builtin.cache",ll="undefined_publisher";var Lm=["AI","Azure","Chat","Data Science","Debuggers","Extension Packs","Education","Formatters","Keymaps","Language Packs","Linters","Machine Learning","Notebooks","Programming Languages","SCM Providers","Snippets","Testing","Themes","Visualization","Other"];var pr=class{constructor(t){this.value=t,this._lower=t.toLowerCase()}static equals(t,e){if(typeof t>"u"||t===null)return typeof e>"u"||e===null;if(typeof e>"u"||e===null)return!1;if(typeof t=="string"||typeof e=="string"){let r=typeof t=="string"?t:t.value,n=typeof e=="string"?e:e.value;return Bt(r,n)}return t._lower===e._lower}static toKey(t){return typeof t=="string"?t.toLowerCase():t._lower}};var sl=class{constructor(){this._map=new Map}clear(){this._map.clear()}delete(t){this._map.delete(pr.toKey(t))}get(t){return this._map.get(pr.toKey(t))}has(t){return this._map.has(pr.toKey(t))}set(t,e){this._map.set(pr.toKey(t),e)}values(){return this._map.values()}forEach(t){this._map.forEach(t)}[Symbol.iterator](){return this._map[Symbol.iterator]()}};function Qu(i){return c1(i)}function c1(i){return i.contributes&&i.contributes.localizations?i.contributes.localizations.length>0:!1}function Am(i){return i.map(t=>{let[e,r]=t.split("@");return{proposalName:e,version:r?parseInt(r):void 0}})}function Um(i){return i.map(t=>t.split("@")[0])}var fT=B("IBuiltinExtensionsScannerService");var p1="^([a-z0-9A-Z][a-z0-9-A-Z]*)\\.([a-z0-9A-Z][a-z0-9-A-Z]*)$",ss=new RegExp(p1),Mm="__web_extension";var Ju="extensionInstallSource",Fm="dependecyOrPackExtensionInstall",Om="clientTargetPlatform";function Xu(i){switch(i){case"win32-x64":return"Windows 64 bit";case"win32-arm64":return"Windows ARM";case"linux-x64":return"Linux 64 bit";case"linux-arm64":return"Linux ARM 64";case"linux-armhf":return"Linux ARM";case"alpine-x64":return"Alpine Linux 64 bit";case"alpine-arm64":return"Alpine ARM 64";case"darwin-x64":return"Mac";case"darwin-arm64":return"Mac Silicon";case"web":return"Web";case"universal":return"universal";case"unknown":return"unknown";case"undefined":return"undefined"}}function Nm(i){switch(i){case"win32-x64":return"win32-x64";case"win32-arm64":return"win32-arm64";case"linux-x64":return"linux-x64";case"linux-arm64":return"linux-arm64";case"linux-armhf":return"linux-armhf";case"alpine-x64":return"alpine-x64";case"alpine-arm64":return"alpine-arm64";case"darwin-x64":return"darwin-x64";case"darwin-arm64":return"darwin-arm64";case"web":return"web";case"universal":return"universal";default:return"unknown"}}function cl(i,t){switch(i){case 3:return t==="x64"?"win32-x64":t==="arm64"?"win32-arm64":"unknown";case 2:return t==="x64"?"linux-x64":t==="arm64"?"linux-arm64":t==="arm"?"linux-armhf":"unknown";case"alpine":return t==="x64"?"alpine-x64":t==="arm64"?"alpine-arm64":"unknown";case 1:return t==="x64"?"darwin-x64":t==="arm64"?"darwin-arm64":"unknown";case 0:return"web"}}function Ni(i,t){return t==="web"&&!i.includes("web")}function as(i,t,e){return Ni(t,e)?!1:i==="undefined"||i==="universal"?!0:i==="unknown"?!1:i===e}function Vm(i){let t=i;return!!t&&typeof t=="object"&&typeof t.id=="string"&&(!t.uuid||typeof t.uuid=="string")}var kt=B("extensionGalleryService");var Xt=class extends Error{constructor(e,r){super(e);this.code=r;this.name=r}};var Ee=class extends Error{constructor(e,r){super(e);this.code=r;this.name=r}},Vi=B("extensionManagementService");var kT=B("IGlobalExtensionEnablementService"),DT=B("IExtensionTipsService"),fr=B("IAllowedExtensionsService");async function ul(i,t){let e;try{e=await t.resolve(i)}catch(r){if(r.fileOperationResult===1)return 0;throw r}return e.children?(await Promise.all(e.children.map(n=>ul(n.resource,t)))).reduce((n,o)=>n+o,0):e.size??0}var LT=Bc(1959,"Extensions"),AT=Bc(1976,"Preferences"),ls="extensions.allowed",Wm="extensions.verifySignature",Bm="extensions.requestTimeout";it.as(Kt.Configuration).registerConfiguration({id:"extensions",order:30,title:m(1975,null),type:"object",properties:{[ls]:{type:"object",markdownDescription:m(1965,null),default:"*",defaultSnippets:[{body:{},description:m(1970,null)},{body:{"*":!0},description:m(1966,null)}],scope:1,policy:{name:"AllowedExtensions",category:"Extensions",minimumVersion:"1.96",localization:{description:{key:"extensions.allowed.policy",value:m(1971,null)}}},additionalProperties:!1,patternProperties:{"([a-z0-9A-Z][a-z0-9-A-Z]*)\\.([a-z0-9A-Z][a-z0-9-A-Z]*)$":{anyOf:[{type:["boolean","string"],enum:[!0,!1,"stable"],description:m(1963,null),enumDescriptions:[m(1969,null),m(1967,null),m(1968,null)]},{type:"array",items:{type:"string"},description:m(1964,null)}]},"([a-z0-9A-Z][a-z0-9-A-Z]*)$":{type:["boolean","string"],enum:[!0,!1,"stable"],description:m(1958,null),enumDescriptions:[m(1974,null),m(1972,null),m(1973,null)]},"\\*":{type:"boolean",enum:[!0,!1],description:m(1960,null),enumDescriptions:[m(1962,null),m(1961,null)]}}}}});function Gm(i,t){return i?t?.capabilities.signing?.allPrivateRepositorySigned===!0:t?.capabilities.signing?.allPublicRepositorySigned===!0}var f1=/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;function qm(i){return f1.test(i)}var Ne=(function(){if(typeof crypto.randomUUID=="function")return crypto.randomUUID.bind(crypto);let i=new Uint8Array(16),t=[];for(let e=0;e<256;e++)t.push(e.toString(16).padStart(2,"0"));return function(){crypto.getRandomValues(i),i[6]=i[6]&15|64,i[8]=i[8]&63|128;let r=0,n="";return n+=t[i[r++]],n+=t[i[r++]],n+=t[i[r++]],n+=t[i[r++]],n+="-",n+=t[i[r++]],n+=t[i[r++]],n+="-",n+=t[i[r++]],n+=t[i[r++]],n+="-",n+=t[i[r++]],n+=t[i[r++]],n+="-",n+=t[i[r++]],n+=t[i[r++]],n+=t[i[r++]],n+=t[i[r++]],n+=t[i[r++]],n+=t[i[r++]],n}})();function g1(i){if(Dn===2&&/^penguin(\.|$)/i.test(i))return"chromebook"}function Km(i,t,e,r,n,o,s,a,l,c,u){let p=Object.create(null);p["common.machineId"]=o,p["common.sqmId"]=s,p["common.devDeviceId"]=a,p.sessionID=Ne()+Date.now(),p.commitHash=r,p.version=n,p["common.releaseDate"]=c,p["common.platformVersion"]=(i||"").replace(/^(\d+)(\.\d+)?(\.\d+)?(.*)/,"$1$2$3"),p["common.platform"]=Np(Dn),p["common.nodePlatform"]=ra,p["common.nodeArch"]=e,p["common.product"]=u||"desktop",l&&(p["common.msftInternal"]=l);let f=0,g=Date.now();Object.defineProperties(p,{timestamp:{get:()=>new Date,enumerable:!0},"common.timesincesessionstart":{get:()=>Date.now()-g,enumerable:!0},"common.sequence":{get:()=>f++,enumerable:!0}}),Vp&&(p["common.snap"]="true");let v=g1(t);return v&&(p["common.platformDetail"]=v),p}function zm(i){let t=Ot.USERDNSDOMAIN;if(!t)return!1;let e=t.toLowerCase();return i.some(r=>e===r)}var St=B("telemetryService");var WT=B("customEndpointTelemetryService");var $m="telemetry.machineId",jm="telemetry.sqmId",Hm="telemetry.devDeviceId",Qm="telemetry",Wi="telemetry.telemetryLevel",dl="telemetry.enableCrashReporter",cs="telemetry.enableTelemetry";var xn=class{constructor(t){this.value=t;this.isTrustedTelemetryValue=!0}},Yu=class{constructor(){this.telemetryLevel=0;this.sessionId="someValue.sessionId";this.machineId="someValue.machineId";this.sqmId="someValue.sqmId";this.devDeviceId="someValue.devDeviceId";this.firstSessionDate="someValue.firstSessionDate";this.sendErrorTelemetry=!1}publicLog(){}publicLog2(){}publicLogError(){}publicLogError2(){}setExperimentProperty(){}},Xm=new Yu;var v1="telemetry",YT={id:v1,name:m(2298,null)};function pl(i,t){return!t.isBuilt&&!t.disableTelemetry?!0:!(t.disableTelemetry||!i.enableTelemetry)}function fl(i){let t=i.getValue(Wi),e=i.getValue(dl);if(i.getValue(cs)===!1||e===!1)return 0;switch(t??"all"){case"all":return 3;case"error":return 2;case"crash":return 1;case"off":return 0}}function Ym(i){let t={},e={},r={};Zm(i,r);for(let n in r){n=n.length>150?n.substr(n.length-149):n;let o=r[n];typeof o=="number"?e[n]=o:typeof o=="boolean"?e[n]=o?1:0:typeof o=="string"?(o.length>8192&&console.warn(`Telemetry property: ${n} has been trimmed to 8192, the original length is ${o.length}`),t[n]=o.substring(0,8191)):typeof o<"u"&&o!==null&&(t[n]=String(o))}return{properties:t,measurements:e}}function Zm(i,t,e=0,r){if(!i||typeof i!="object"&&typeof i!="function")return;let n=i;for(let o of Object.getOwnPropertyNames(n)){let s=n[o],a=r?r+o:o;Array.isArray(s)?t[a]=xu(s):s instanceof Date?t[a]=s.toISOString():he(s)?e<2?Zm(s,t,e+1,a+"."):t[a]=xu(s):t[a]=s}}function eg(i,t){let e=i.msftInternalDomains||[],r=t.getValue("telemetry.internalTesting");return zm(e)||r}function tg(i){return[i.appRoot,i.extensionsPath,i.userHome.fsPath,i.tmpDir.fsPath,i.userDataPath]}function y1(i,t){if(!i||!i.includes("/")&&!i.includes("\\"))return i;let e=i,r=[];for(let l of t)for(;;){let c=l.exec(i);if(!c)break;r.push([c.index,l.lastIndex])}let n=/^[\\\/]?(node_modules|node_modules\.asar)[\\\/]/,o=/^(.*?)((?:\.vscode(?:-[a-z]+)*|resources[\\\/]app)[\\\/]extensions[\\\/].*)$/i,s=/(file:\/\/)?([a-zA-Z]:(\\\\|\\|\/)|(\\\\|\\|\/))?([\w-\._]+(\\\\|\\|\/))+[\w-\._]*/g,a=0;for(e="";;){let l=s.exec(i);if(!l)break;let c=r.some(([u,p])=>l.index<p&&u<s.lastIndex);if(!n.test(l[0])&&!c){let u=o.exec(l[0]);u?e+=i.substring(a,l.index)+"<REDACTED: user-file-path>/"+u[2]:e+=i.substring(a,l.index)+"<REDACTED: user-file-path>",a=s.lastIndex}}return a<i.length&&(e+=i.substr(a)),e}function I1(i){if(!i)return i;let t=[{label:"URL",regex:/[a-zA-Z][a-zA-Z0-9+.-]*:\/\/[^\s]*/},{label:"Google API Key",regex:/AIza[A-Za-z0-9_\\\-]{35}/},{label:"JWT",regex:/eyJ[0eXAiOiJKV1Qi|hbGci|a-zA-Z0-9\-_]+\.[a-zA-Z0-9\-_]+\.[a-zA-Z0-9\-_]+/},{label:"Slack Token",regex:/xox[pbar]\-[A-Za-z0-9]/},{label:"GitHub Token",regex:/(gh[psuro]_[a-zA-Z0-9]{36}|github_pat_[a-zA-Z0-9]{22}_[a-zA-Z0-9]{59})/},{label:"Generic Secret",regex:/(key|token|sig|secret|signature|password|passwd|pwd|android:value)[^a-zA-Z0-9]/i},{label:"CLI Credentials",regex:/((login|psexec|(certutil|psexec)\.exe).{1,50}(\s-u(ser(name)?)?\s+.{3,100})?\s-(admin|user|vm|root)?p(ass(word)?)?\s+["']?[^$\-\/\s]|(^|[\s\r\n\\])net(\.exe)?.{1,5}(user\s+|share\s+\/user:| user -? secrets ? set) \s + [^ $\s \/])/},{label:"Microsoft Entra ID",regex:/eyJ(?:0eXAiOiJKV1Qi|hbGci|[a-zA-Z0-9\-_]+\.[a-zA-Z0-9\-_]+\.)/},{label:"Email",regex:/[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/}];for(let e of t)if(e.regex.test(i))return`<REDACTED: ${e.label}>`;return i}function rg(i,t){return i?Jf(i,e=>{if(e instanceof xn||Object.hasOwnProperty.call(e,"isTrustedTelemetryValue"))return e.value;if(typeof e=="string"){let r=e.replaceAll("%20"," ");r=y1(r,t);for(let n of t)r=r.replace(n,"");return r=I1(r),r}}):{}}function H(i,t){return i.uuid&&t.uuid?i.uuid===t.uuid:i.id===t.id?!0:fi(i.id,t.id)===0}var x1=/^([^.]+\..+)-(\d+\.\d+\.\d+)(-(.+))?$/,Ze=class i{constructor(t,e,r="undefined"){this.identifier=t;this.version=e;this.targetPlatform=r;this.id=t.id}static create(t){let e=t.manifest?t.manifest.version:t.version,r=t.manifest?t.targetPlatform:t.properties.targetPlatform;return new i(t.identifier,e,r)}static parse(t){let e=x1.exec(t);return e&&e[1]&&e[2]?new i({id:e[1]},e[2],e[4]||void 0):null}toString(){return`${this.id}-${this.version}${this.targetPlatform!=="undefined"?`-${this.targetPlatform}`:""}`}equals(t){return t instanceof i?H(this,t)&&this.version===t.version&&this.targetPlatform===t.targetPlatform:!1}},b1=/^([^.]+\..+)@((prerelease)|(\d+\.\d+\.\d+(-.*)?))$/;function ds(i){let t=b1.exec(i);return t&&t[1]?[us(t[1]),t[2]]:[us(i),void 0]}function ml(i,t){return`${i}.${t}`}function us(i){return i.toLowerCase()}function Dt(i,t){return us(ml(i??ll,t))}function gl(i,t){let e=[],r=n=>{for(let o of e)if(o.some(s=>H(t(s),t(n))))return o;return null};for(let n of i){let o=r(n);o?o.push(n):e.push([n])}return e}function ng(i){return{id:i.identifier.id,name:i.manifest.name,galleryId:null,publisherId:i.publisherId,publisherName:i.manifest.publisher,publisherDisplayName:i.publisherDisplayName,dependencies:i.manifest.extensionDependencies&&i.manifest.extensionDependencies.length>0}}function ps(i){return{id:new xn(i.identifier.id),name:new xn(i.name),extensionVersion:i.version,galleryId:i.identifier.uuid,publisherId:i.publisherId,publisherName:i.publisher,publisherDisplayName:i.publisherDisplayName,isPreReleaseVersion:i.properties.isPreReleaseVersion,dependencies:!!(i.properties.dependencies&&i.properties.dependencies.length>0),isSigned:i.isSigned,...i.telemetryData}}var mR=new pr("pprice.better-merge");async function S1(i,t){if(!Te)return!1;let e;try{e=(await i.readFile(P.file("/etc/os-release"))).value.toString()}catch{try{e=(await i.readFile(P.file("/usr/lib/os-release"))).value.toString()}catch(n){t.debug("Error while getting the os-release file.",G(n))}}return!!e&&(e.match(/^ID=([^\u001b\r\n]*)/m)||[])[1]==="alpine"}async function hl(i,t){let e=await S1(i,t),r=cl(e?"alpine":Dn,na);return t.debug("ComputeTargetPlatform:",r),r}function ig(i,t){return E1(i,t)!==void 0}function E1(i,t){return t.find(({extensionOrPublisher:e})=>te(e)?fi(i.id.split(".")[0],e)===0:H(i,e))}var vl=(n=>(n[n.Ignore=0]="Ignore",n[n.Info=1]="Info",n[n.Warning=2]="Warning",n[n.Error=3]="Error",n))(vl||{});(a=>{let i="error",t="warning",e="warn",r="info",n="ignore";function o(l){return l?Bt(i,l)?3:Bt(t,l)||Bt(e,l)?2:Bt(r,l)?1:0:0}a.fromValue=o;function s(l){switch(l){case 3:return i;case 2:return t;case 1:return r;default:return n}}a.toString=s})(vl||={});var ze=vl;var w1={activeComment:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.activeComment.d.ts"},agentSessionsWorkspace:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.agentSessionsWorkspace.d.ts"},aiRelatedInformation:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.aiRelatedInformation.d.ts"},aiSettingsSearch:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.aiSettingsSearch.d.ts"},aiTextSearchProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.aiTextSearchProvider.d.ts",version:2},authIssuers:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.authIssuers.d.ts"},authLearnMore:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.authLearnMore.d.ts"},authProviderSpecific:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.authProviderSpecific.d.ts"},authSession:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.authSession.d.ts"},authenticationChallenges:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.authenticationChallenges.d.ts"},canonicalUriProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.canonicalUriProvider.d.ts"},chatContextProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatContextProvider.d.ts"},chatHooks:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatHooks.d.ts",version:6},chatOutputRenderer:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatOutputRenderer.d.ts"},chatParticipantAdditions:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatParticipantAdditions.d.ts",version:3},chatParticipantPrivate:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatParticipantPrivate.d.ts",version:14},chatPromptFiles:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatPromptFiles.d.ts",version:1},chatProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatProvider.d.ts",version:4},chatReferenceBinaryData:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatReferenceBinaryData.d.ts"},chatReferenceDiagnostic:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatReferenceDiagnostic.d.ts"},chatSessionsProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatSessionsProvider.d.ts",version:3},chatStatusItem:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatStatusItem.d.ts"},chatTab:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatTab.d.ts"},codeActionAI:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.codeActionAI.d.ts"},codeActionRanges:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.codeActionRanges.d.ts"},codiconDecoration:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.codiconDecoration.d.ts"},commentReactor:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentReactor.d.ts"},commentReveal:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentReveal.d.ts"},commentThreadApplicability:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentThreadApplicability.d.ts"},commentingRangeHint:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentingRangeHint.d.ts"},commentsDraftState:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentsDraftState.d.ts"},contribAccessibilityHelpContent:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribAccessibilityHelpContent.d.ts"},contribChatEditorInlineGutterMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribChatEditorInlineGutterMenu.d.ts"},contribCommentEditorActionsMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribCommentEditorActionsMenu.d.ts"},contribCommentPeekContext:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribCommentPeekContext.d.ts"},contribCommentThreadAdditionalMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribCommentThreadAdditionalMenu.d.ts"},contribCommentsViewThreadMenus:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribCommentsViewThreadMenus.d.ts"},contribDebugCreateConfiguration:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribDebugCreateConfiguration.d.ts"},contribDiffEditorGutterToolBarMenus:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribDiffEditorGutterToolBarMenus.d.ts"},contribEditSessions:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribEditSessions.d.ts"},contribEditorContentMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribEditorContentMenu.d.ts"},contribLabelFormatterWorkspaceTooltip:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribLabelFormatterWorkspaceTooltip.d.ts"},contribLanguageModelToolSets:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribLanguageModelToolSets.d.ts"},contribMenuBarHome:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribMenuBarHome.d.ts"},contribMergeEditorMenus:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribMergeEditorMenus.d.ts"},contribMultiDiffEditorMenus:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribMultiDiffEditorMenus.d.ts"},contribNotebookStaticPreloads:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribNotebookStaticPreloads.d.ts"},contribRemoteHelp:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribRemoteHelp.d.ts"},contribShareMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribShareMenu.d.ts"},contribSourceControlArtifactGroupMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlArtifactGroupMenu.d.ts"},contribSourceControlArtifactMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlArtifactMenu.d.ts"},contribSourceControlHistoryItemMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlHistoryItemMenu.d.ts"},contribSourceControlHistoryTitleMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlHistoryTitleMenu.d.ts"},contribSourceControlInputBoxMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlInputBoxMenu.d.ts"},contribSourceControlTitleMenu:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlTitleMenu.d.ts"},contribStatusBarItems:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribStatusBarItems.d.ts"},contribViewContainerTitle:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribViewContainerTitle.d.ts"},contribViewsRemote:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribViewsRemote.d.ts"},contribViewsWelcome:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribViewsWelcome.d.ts"},css:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.css.d.ts"},customEditorMove:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.customEditorMove.d.ts"},dataChannels:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.dataChannels.d.ts"},debugVisualization:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.debugVisualization.d.ts"},defaultChatParticipant:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.defaultChatParticipant.d.ts",version:4},devDeviceId:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.devDeviceId.d.ts"},diffCommand:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.diffCommand.d.ts"},diffContentOptions:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.diffContentOptions.d.ts"},documentFiltersExclusive:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.documentFiltersExclusive.d.ts"},editSessionIdentityProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.editSessionIdentityProvider.d.ts"},editorHoverVerbosityLevel:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.editorHoverVerbosityLevel.d.ts"},editorInsets:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.editorInsets.d.ts"},embeddings:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.embeddings.d.ts"},envIsAppPortable:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.envIsAppPortable.d.ts"},envIsConnectionMetered:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.envIsConnectionMetered.d.ts"},environmentPower:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.environmentPower.d.ts"},extensionAffinity:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.extensionAffinity.d.ts"},extensionRuntime:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.extensionRuntime.d.ts"},extensionsAny:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.extensionsAny.d.ts"},externalUriOpener:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.externalUriOpener.d.ts"},fileSearchProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.fileSearchProvider.d.ts"},fileSearchProvider2:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.fileSearchProvider2.d.ts"},findFiles2:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.findFiles2.d.ts",version:2},findTextInFiles:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.findTextInFiles.d.ts"},findTextInFiles2:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.findTextInFiles2.d.ts"},fsChunks:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.fsChunks.d.ts"},inlineCompletionsAdditions:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.inlineCompletionsAdditions.d.ts"},interactive:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.interactive.d.ts"},interactiveWindow:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.interactiveWindow.d.ts"},ipc:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.ipc.d.ts"},languageModelCapabilities:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelCapabilities.d.ts"},languageModelProxy:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelProxy.d.ts"},languageModelSystem:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelSystem.d.ts"},languageModelThinkingPart:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelThinkingPart.d.ts",version:1},languageModelToolResultAudience:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelToolResultAudience.d.ts"},languageModelToolSupportsModel:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelToolSupportsModel.d.ts",version:1},languageStatusText:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageStatusText.d.ts"},mappedEditsProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.mappedEditsProvider.d.ts"},markdownAlertSyntax:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.markdownAlertSyntax.d.ts"},mcpServerDefinitions:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.mcpServerDefinitions.d.ts"},mcpToolDefinitions:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.mcpToolDefinitions.d.ts"},multiDocumentHighlightProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.multiDocumentHighlightProvider.d.ts"},nativeWindowHandle:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.nativeWindowHandle.d.ts"},newSymbolNamesProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.newSymbolNamesProvider.d.ts"},notebookCellExecution:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookCellExecution.d.ts"},notebookControllerAffinityHidden:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookControllerAffinityHidden.d.ts"},notebookDeprecated:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookDeprecated.d.ts"},notebookExecution:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookExecution.d.ts"},notebookKernelSource:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookKernelSource.d.ts"},notebookLiveShare:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookLiveShare.d.ts"},notebookMessaging:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookMessaging.d.ts"},notebookMime:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookMime.d.ts"},notebookReplDocument:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookReplDocument.d.ts"},notebookVariableProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookVariableProvider.d.ts"},portsAttributes:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.portsAttributes.d.ts"},profileContentHandlers:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.profileContentHandlers.d.ts"},quickDiffProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.quickDiffProvider.d.ts"},quickPickItemTooltip:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.quickPickItemTooltip.d.ts"},quickPickSortByLabel:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.quickPickSortByLabel.d.ts"},remoteCodingAgents:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.remoteCodingAgents.d.ts"},resolvers:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.resolvers.d.ts"},scmActionButton:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmActionButton.d.ts"},scmArtifactProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmArtifactProvider.d.ts"},scmHistoryProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmHistoryProvider.d.ts"},scmMultiDiffEditor:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmMultiDiffEditor.d.ts"},scmProviderOptions:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmProviderOptions.d.ts"},scmSelectedProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmSelectedProvider.d.ts"},scmTextDocument:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmTextDocument.d.ts"},scmValidation:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmValidation.d.ts"},shareProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.shareProvider.d.ts"},speech:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.speech.d.ts"},statusBarItemTooltip:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.statusBarItemTooltip.d.ts"},tabInputMultiDiff:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tabInputMultiDiff.d.ts"},tabInputTextMerge:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tabInputTextMerge.d.ts"},taskExecutionTerminal:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.taskExecutionTerminal.d.ts"},taskPresentationGroup:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.taskPresentationGroup.d.ts"},taskProblemMatcherStatus:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.taskProblemMatcherStatus.d.ts"},telemetry:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.telemetry.d.ts"},terminalCompletionProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalCompletionProvider.d.ts"},terminalDataWriteEvent:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalDataWriteEvent.d.ts"},terminalDimensions:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalDimensions.d.ts"},terminalExecuteCommandEvent:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalExecuteCommandEvent.d.ts"},terminalQuickFixProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalQuickFixProvider.d.ts"},terminalSelection:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalSelection.d.ts"},terminalShellEnv:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalShellEnv.d.ts"},testObserver:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.testObserver.d.ts"},testRelatedCode:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.testRelatedCode.d.ts"},textDocumentChangeReason:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textDocumentChangeReason.d.ts"},textEditorDiffInformation:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textEditorDiffInformation.d.ts"},textSearchComplete2:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textSearchComplete2.d.ts"},textSearchProvider:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textSearchProvider.d.ts"},textSearchProvider2:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textSearchProvider2.d.ts"},timeline:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.timeline.d.ts"},tokenInformation:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tokenInformation.d.ts"},toolProgress:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.toolProgress.d.ts"},treeItemMarkdownLabel:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.treeItemMarkdownLabel.d.ts"},treeViewActiveItem:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.treeViewActiveItem.d.ts"},treeViewMarkdownMessage:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.treeViewMarkdownMessage.d.ts"},treeViewReveal:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.treeViewReveal.d.ts"},tunnelFactory:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tunnelFactory.d.ts"},tunnels:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tunnels.d.ts"},valueSelectionInQuickPick:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.valueSelectionInQuickPick.d.ts"},workspaceTrust:{proposal:"https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.workspaceTrust.d.ts"}},og=Object.freeze(w1);var sg=/^(\^|>=)?((\d+)|x)\.((\d+)|x)\.((\d+)|x)(\-.*)?$/,P1=/^-(\d{4})(\d{2})(\d{2})(\d{2})?(\d{2})?$/;function T1(i){return i=i.trim(),i==="*"||sg.test(i)}function ed(i){if(!T1(i))return null;if(i=i.trim(),i==="*")return{hasCaret:!1,hasGreaterEquals:!1,majorBase:0,majorMustEqual:!1,minorBase:0,minorMustEqual:!1,patchBase:0,patchMustEqual:!1,preRelease:null};let t=i.match(sg);return t?{hasCaret:t[1]==="^",hasGreaterEquals:t[1]===">=",majorBase:t[2]==="x"?0:parseInt(t[2],10),majorMustEqual:t[2]!=="x",minorBase:t[4]==="x"?0:parseInt(t[4],10),minorMustEqual:t[4]!=="x",patchBase:t[6]==="x"?0:parseInt(t[6],10),patchMustEqual:t[6]!=="x",preRelease:t[8]||null}:null}function td(i){if(!i)return null;let t=i.majorBase,e=i.majorMustEqual,r=i.minorBase,n=i.minorMustEqual,o=i.patchBase,s=i.patchMustEqual;i.hasCaret&&(t===0||(n=!1),s=!1);let a=0;if(i.preRelease){let l=P1.exec(i.preRelease);if(l){let[,c,u,p,f,g]=l;a=Date.UTC(Number(c),Number(u)-1,Number(p),Number(f)||0,Number(g)||0)}}return{majorBase:t,majorMustEqual:e,minorBase:r,minorMustEqual:n,patchBase:o,patchMustEqual:s,isMinimum:i.hasGreaterEquals,notBefore:a}}function R1(i,t,e){let r;typeof i=="string"?r=td(ed(i)):r=i;let n;t instanceof Date?n=t.getTime():typeof t=="string"&&(n=new Date(t).getTime());let o;if(typeof e=="string"?o=td(ed(e)):o=e,!r||!o)return!1;let s=r.majorBase,a=r.minorBase,l=r.patchBase,c=o.majorBase,u=o.minorBase,p=o.patchBase,f=o.notBefore,g=o.majorMustEqual,v=o.minorMustEqual,h=o.patchMustEqual;return o.isMinimum?s>c?!0:s<c?!1:a>u?!0:a<u||n&&n<f?!1:l>=p:(s===1&&c===0&&(!g||!v||!h)&&(c=1,u=0,p=0,g=!0,v=!1,h=!1),s<c?!1:s>c?!g:a<u?!1:a>u?!v:l<p?!1:l>p?!h:!(n&&n<f))}function ag(i,t,e,r,n,o){let s=[];if(typeof r.publisher<"u"&&typeof r.publisher!="string")return s.push([ze.Error,m(2037,null)]),s;if(typeof r.name!="string")return s.push([ze.Error,m(2036,null,"name")]),s;if(typeof r.version!="string")return s.push([ze.Error,m(2038,null,"version")]),s;if(!r.engines)return s.push([ze.Error,m(2029,null,"engines")]),s;if(typeof r.engines.vscode!="string")return s.push([ze.Error,m(2030,null,"engines.vscode")]),s;if(typeof r.extensionDependencies<"u"&&!Zu(r.extensionDependencies))return s.push([ze.Error,m(2032,null,"extensionDependencies")]),s;if(typeof r.extensionAffinity<"u"&&!Zu(r.extensionAffinity))return s.push([ze.Error,m(2031,null,"extensionAffinity")]),s;if(typeof r.activationEvents<"u"){if(!Zu(r.activationEvents))return s.push([ze.Error,m(2025,null,"activationEvents")]),s;if(typeof r.main>"u"&&typeof r.browser>"u")return s.push([ze.Error,m(2026,null,"activationEvents","main","browser")]),s}if(typeof r.extensionKind<"u"&&typeof r.main>"u"&&s.push([ze.Warning,m(2033,null,"extensionKind")]),typeof r.main<"u"){if(typeof r.main!="string")return s.push([ze.Error,m(2034,null,"main")]),s;{let c=z(e,r.main);ou(c,e)||s.push([ze.Warning,m(2035,null,c.path,e.path)])}}if(typeof r.browser<"u"){if(typeof r.browser!="string")return s.push([ze.Error,m(2027,null,"browser")]),s;{let c=z(e,r.browser);ou(c,e)||s.push([ze.Warning,m(2028,null,c.path,e.path)])}}if(!Rm(r.version))return s.push([ze.Error,m(2039,null)]),s;let a=[];if(!C1(i,t,r,n,a))for(let c of a)s.push([ze.Error,c]);if(o&&r.enabledApiProposals?.length){let c=[];if(!ms([...r.enabledApiProposals],c))for(let u of c)s.push([ze.Error,u])}return s}function C1(i,t,e,r,n){return r||typeof e.main>"u"&&typeof e.browser>"u"?!0:lg(i,t,e.engines.vscode,n)}function fs(i,t,e){return i==="*"||lg(t,e,i)}function ms(i,t){if(i.length===0)return!0;let e=Array.isArray(t)?t:void 0,r=(Array.isArray(t)?void 0:t)??og,n=[],o=Am(i);for(let{proposalName:s,version:a}of o){if(!a)continue;r[s]?.version!==a&&n.push(s)}return n.length?(e&&(n.length===1?e.push(m(2023,null,n[0])):e.push(m(2024,null,n.slice(0,n.length-1).map(s=>`'${s}'`).join(", "),n[n.length-1]))),!1):!0}function lg(i,t,e,r=[]){let n=td(ed(e));if(!n)return r.push(m(2043,null,e)),!1;if(n.majorBase===0){if(!n.majorMustEqual||!n.minorMustEqual)return r.push(m(2041,null,e)),!1}else if(!n.majorMustEqual)return r.push(m(2042,null,e)),!1;return R1(i,t,n)?!0:(r.push(m(2040,null,i,e)),!1)}function Zu(i){if(!Array.isArray(i))return!1;for(let t=0,e=i.length;t<e;t++)if(typeof i[t]!="string")return!1;return!0}var ke=B("productService");function rd(i){let t=[];typeof i=="number"&&t.push("code/timeOrigin",i);function e(n,o){t.push(n,o?.startTime??Date.now())}function r(){let n=[];for(let o=0;o<t.length;o+=2)n.push({name:t[o],startTime:t[o+1]});return n}return{mark:e,getMarks:r}}function _1(){if(typeof performance=="object"&&typeof performance.mark=="function"&&!performance.nodeTiming)return typeof performance.timeOrigin!="number"&&!performance.timing?rd():{mark(i,t){performance.mark(i,t)},getMarks(){let i=performance.timeOrigin;typeof i!="number"&&(i=(performance.timing.navigationStart||performance.timing.redirectStart||performance.timing.fetchStart)??0);let t=[{name:"code/timeOrigin",startTime:Math.round(i)}];for(let e of performance.getEntriesByType("mark"))t.push({name:e.name,startTime:Math.round(i+e.startTime)});return t}};if(typeof process=="object"){let i=performance?.timeOrigin;return rd(i)}else return console.trace("perf-util loaded in UNKNOWN environment"),rd()}function k1(i){return i.MonacoPerformanceMarks||(i.MonacoPerformanceMarks=_1()),i.MonacoPerformanceMarks}var cg=k1(globalThis),gs=cg.mark,TR=cg.getMarks;function ug(i){return JSON.stringify(i,D1)}function dg(i){let t=JSON.parse(i);return t=bn(t),t}function D1(i,t){return t instanceof RegExp?{$mid:2,source:t.source,flags:t.flags}:t}function bn(i,t=0){if(!i||t>200)return i;if(typeof i=="object"){switch(i.$mid){case 1:return P.revive(i);case 2:return new RegExp(i.source,i.flags);case 17:return new Date(i.source)}if(i instanceof U||i instanceof Uint8Array)return i;if(Array.isArray(i))for(let e=0;e<i.length;++e)i[e]=bn(i[e],t+1);else for(let e in i)Object.hasOwnProperty.call(i,e)&&(i[e]=bn(i[e],t+1))}return i}var nd=class i extends _{constructor(e,r=Object.create(null)){super();this.database=e;this.options=r;this._onDidChangeStorage=this._register(new _n);this.onDidChangeStorage=this._onDidChangeStorage.event;this.state=0;this.cache=new Map;this.flushDelayer=this._register(new _t(i.DEFAULT_FLUSH_DELAY));this.pendingDeletes=new Set;this.pendingInserts=new Map;this.pendingClose=void 0;this.whenFlushedCallbacks=[];this.registerListeners()}static{this.DEFAULT_FLUSH_DELAY=100}registerListeners(){this._register(this.database.onDidChangeItemsExternal(e=>this.onDidChangeItemsExternal(e)))}onDidChangeItemsExternal(e){this._onDidChangeStorage.pause();try{e.changed?.forEach((r,n)=>this.acceptExternal(n,r)),e.deleted?.forEach(r=>this.acceptExternal(r,void 0))}finally{this._onDidChangeStorage.resume()}}acceptExternal(e,r){if(this.state===2)return;let n=!1;Oe(r)?n=this.cache.delete(e):this.cache.get(e)!==r&&(this.cache.set(e,r),n=!0),n&&this._onDidChangeStorage.fire({key:e,external:!0})}get items(){return this.cache}get size(){return this.cache.size}async init(){this.state===0&&(this.state=1,this.options.hint!==0&&(this.cache=await this.database.getItems()))}get(e,r){let n=this.cache.get(e);return Oe(n)?r:n}getBoolean(e,r){let n=this.get(e);return Oe(n)?r:n==="true"}getNumber(e,r){let n=this.get(e);return Oe(n)?r:parseInt(n,10)}getObject(e,r){let n=this.get(e);return Oe(n)?r:dg(n)}async set(e,r,n=!1){if(this.state===2)return;if(Oe(r))return this.delete(e,n);let o=he(r)||Array.isArray(r)?ug(r):String(r);if(this.cache.get(e)!==o)return this.cache.set(e,o),this.pendingInserts.set(e,o),this.pendingDeletes.delete(e),this._onDidChangeStorage.fire({key:e,external:n}),this.doFlush()}async delete(e,r=!1){if(!(this.state===2||!this.cache.delete(e)))return this.pendingDeletes.has(e)||this.pendingDeletes.add(e),this.pendingInserts.delete(e),this._onDidChangeStorage.fire({key:e,external:r}),this.doFlush()}async optimize(){if(this.state!==2)return await this.flush(0),this.database.optimize()}async close(){return this.pendingClose||(this.pendingClose=this.doClose()),this.pendingClose}async doClose(){this.state=2;try{await this.doFlush(0)}catch{}await this.database.close(()=>this.cache)}get hasPending(){return this.pendingInserts.size>0||this.pendingDeletes.size>0}async flushPending(){if(!this.hasPending)return;let e={insert:this.pendingInserts,delete:this.pendingDeletes};return this.pendingDeletes=new Set,this.pendingInserts=new Map,this.database.updateItems(e).finally(()=>{if(!this.hasPending)for(;this.whenFlushedCallbacks.length;)this.whenFlushedCallbacks.pop()?.()})}async flush(e){if(!(this.state===2||this.pendingClose))return this.doFlush(e)}async doFlush(e){return this.options.hint===1?this.flushPending():this.flushDelayer.trigger(()=>this.flushPending(),e)}async whenFlushed(){if(this.hasPending)return new Promise(e=>this.whenFlushedCallbacks.push(e))}isInMemory(){return this.options.hint===1}};var HR=B("contextService");function pg(i){let t=i;return typeof t?.id=="string"&&P.isUri(t.uri)}function fg(i){let t=i;return typeof t?.id=="string"&&P.isUri(t.configPath)}var mg="code-workspace",QR=`.${mg}`,JR=[{name:m(2722,null),extensions:[mg]}];var me=B("IUriIdentityService");function gg(i){let t=i;return!!(t&&typeof t=="object"&&typeof t.id=="string"&&typeof t.isDefault=="boolean"&&typeof t.name=="string"&&P.isUri(t.location)&&P.isUri(t.globalStorageHome)&&P.isUri(t.settingsResource)&&P.isUri(t.keybindingsResource)&&P.isUri(t.tasksResource)&&P.isUri(t.snippetsHome)&&P.isUri(t.promptsHome)&&P.isUri(t.extensionsResource)&&P.isUri(t.mcpResource))}var $e=B("IUserDataProfilesService");function yl(i,t,e,r,n,o){return{id:i,name:t,location:e,isDefault:!1,icon:n?.icon,globalStorageHome:o&&n?.useDefaultFlags?.globalState?o.globalStorageHome:z(e,"globalStorage"),settingsResource:o&&n?.useDefaultFlags?.settings?o.settingsResource:z(e,"settings.json"),keybindingsResource:o&&n?.useDefaultFlags?.keybindings?o.keybindingsResource:z(e,"keybindings.json"),tasksResource:o&&n?.useDefaultFlags?.tasks?o.tasksResource:z(e,"tasks.json"),snippetsHome:o&&n?.useDefaultFlags?.snippets?o.snippetsHome:z(e,"snippets"),promptsHome:o&&n?.useDefaultFlags?.prompts?o.promptsHome:z(e,"prompts"),extensionsResource:o&&n?.useDefaultFlags?.extensions?o.extensionsResource:z(e,"extensions.json"),mcpResource:o&&n?.useDefaultFlags?.mcp?o.mcpResource:z(e,"mcp.json"),cacheHome:z(r,i),useDefaultFlags:n?.useDefaultFlags,isTransient:n?.transient,workspaces:n?.workspaces}}var Bi=class extends _{constructor(e,r,n,o){super();this.environmentService=e;this.fileService=r;this.uriIdentityService=n;this.logService=o;this._onDidChangeProfiles=this._register(new R);this.onDidChangeProfiles=this._onDidChangeProfiles.event;this._onWillCreateProfile=this._register(new R);this.onWillCreateProfile=this._onWillCreateProfile.event;this._onWillRemoveProfile=this._register(new R);this.onWillRemoveProfile=this._onWillRemoveProfile.event;this._onDidResetWorkspaces=this._register(new R);this.onDidResetWorkspaces=this._onDidResetWorkspaces.event;this.profileCreationPromises=new Map;this.transientProfilesObject={profiles:[],emptyWindows:new Map};this.profilesHome=z(this.environmentService.userRoamingDataHome,"profiles"),this.profilesCacheHome=z(this.environmentService.cacheHome,"CachedProfilesData")}static{this.PROFILES_KEY="userDataProfiles"}static{this.PROFILE_ASSOCIATIONS_KEY="profileAssociations"}get defaultProfile(){return this.profiles[0]}get profiles(){return[...this.profilesObject.profiles,...this.transientProfilesObject.profiles]}init(){this._profilesObject=void 0}get profilesObject(){if(!this._profilesObject){let e=this.createDefaultProfile(),r=[e];try{for(let o of this.getStoredProfiles()){if(this.isInvalidProfile(o)){this.logService.warn("Skipping the invalid stored profile",o.location||o.name);continue}let s=kr(o.location);r.push(yl(s,o.name,o.location,this.profilesCacheHome,{icon:o.icon,useDefaultFlags:o.useDefaultFlags},e))}}catch(o){this.logService.error(o)}let n=new Map;if(r.length)try{let o=this.getStoredProfileAssociations();if(o.workspaces)for(let[s,a]of Object.entries(o.workspaces)){let l=P.parse(s),c=r.find(u=>u.id===a);if(c){let u=c.workspaces?c.workspaces.slice(0):[];u.push(l),c.workspaces=u}}if(o.emptyWindows)for(let[s,a]of Object.entries(o.emptyWindows)){let l=r.find(c=>c.id===a);l&&n.set(s,l)}}catch(o){this.logService.error(o)}this._profilesObject={profiles:r,emptyWindows:n}}return this._profilesObject}isInvalidProfile(e){return!!(!e.name||!te(e.name)||!e.location||e.isSystem||this.uriIdentityService.extUri.basename(this.uriIdentityService.extUri.dirname(e.location))==="builtin")}createDefaultProfile(){let e=yl("__default__profile__",m(2681,null),this.environmentService.userRoamingDataHome,this.profilesCacheHome);return{...e,extensionsResource:this.getDefaultProfileExtensionsLocation()??e.extensionsResource,isDefault:!0}}async createTransientProfile(e){let r="Temp",n=new RegExp(`${Cr(r)}\\s(\\d+)`),o=0;for(let a of this.profiles){let l=n.exec(a.name),c=l?parseInt(l[1]):0;o=c>o?c:o}let s=`${r} ${o+1}`;return this.createProfile(ur(Ne()).toString(16),s,{transient:!0},e)}async createNamedProfile(e,r,n){return this.createProfile(ur(Ne()).toString(16),e,r,n)}async createProfile(e,r,n,o){return await this.doCreateProfile(e,r,n,o)}async doCreateProfile(e,r,n,o){if(!te(r)||!r)throw new Error("Name of the profile is mandatory and must be of type `string`");let s=this.profileCreationPromises.get(r);return s||(s=(async()=>{try{if(this.profiles.find(p=>p.id===e||!p.isTransient&&!n?.transient&&p.name===r))throw new Error(`Profile with ${r} name already exists`);let l=o?this.getWorkspace(o):void 0;P.isUri(l)&&(n={...n,workspaces:[l]});let c=yl(e,r,this.uriIdentityService.extUri.joinPath(this.profilesHome,e),this.profilesCacheHome,n,this.defaultProfile);await this.fileService.createFolder(c.location);let u=[];return this._onWillCreateProfile.fire({profile:c,join(p){u.push(p)}}),await He.settled(u),l&&!P.isUri(l)&&this.updateEmptyWindowAssociation(l,c,!!c.isTransient),this.updateProfiles([c],[],[]),c}finally{this.profileCreationPromises.delete(r)}})(),this.profileCreationPromises.set(r,s)),s}async updateProfile(e,r){let n=[];for(let s of this.profiles){let a;if(e.id===s.id)s.isDefault?r.workspaces&&(a=s,a.workspaces=r.workspaces):a=yl(s.id,r.name??s.name,s.location,this.profilesCacheHome,{icon:r.icon===null?void 0:r.icon??s.icon,transient:r.transient??s.isTransient,useDefaultFlags:r.useDefaultFlags??s.useDefaultFlags,workspaces:r.workspaces??s.workspaces},this.defaultProfile);else if(r.workspaces){let l=s.workspaces?.filter(c=>!r.workspaces?.some(u=>this.uriIdentityService.extUri.isEqual(c,u)));s.workspaces?.length!==l?.length&&(a=s,a.workspaces=l)}a&&n.push(a)}if(!n.length)throw e.isDefault?new Error("Cannot update default profile"):new Error(`Profile '${e.name}' does not exist`);this.updateProfiles([],[],n);let o=this.profiles.find(s=>s.id===e.id);if(!o)throw new Error(`Profile '${e.name}' was not updated`);return o}async removeProfile(e){if(e.isDefault)throw new Error("Cannot remove default profile");let r=this.profiles.find(o=>o.id===e.id);if(!r)throw new Error(`Profile '${e.name}' does not exist`);let n=[];this._onWillRemoveProfile.fire({profile:r,join(o){n.push(o)}});try{await Promise.allSettled(n)}catch(o){this.logService.error(o)}this.updateProfiles([],[r],[]);try{await this.fileService.del(r.cacheHome,{recursive:!0})}catch(o){Se(o)!==1&&this.logService.error(o)}}async setProfileForWorkspace(e,r){let n=this.profiles.find(s=>s.id===r.id);if(!n)throw new Error(`Profile '${r.name}' does not exist`);let o=this.getWorkspace(e);if(P.isUri(o)){let s=n.workspaces?[...n.workspaces]:[];s.some(a=>this.uriIdentityService.extUri.isEqual(a,o))||(s.push(o),await this.updateProfile(n,{workspaces:s}))}else this.updateEmptyWindowAssociation(o,n,!1),this.updateStoredProfiles(this.profiles)}unsetWorkspace(e,r=!1){let n=this.getWorkspace(e);if(P.isUri(n)){let o=this.getProfileForWorkspace(e);o&&this.updateProfile(o,{workspaces:o.workspaces?.filter(s=>!this.uriIdentityService.extUri.isEqual(s,n))})}else this.updateEmptyWindowAssociation(n,void 0,r),this.updateStoredProfiles(this.profiles)}async resetWorkspaces(){this.transientProfilesObject.emptyWindows.clear(),this.profilesObject.emptyWindows.clear();for(let e of this.profiles)e.workspaces=void 0;this.updateProfiles([],[],this.profiles),this._onDidResetWorkspaces.fire()}async cleanUp(){try{if(await this.fileService.exists(this.profilesHome)){let e=this.uriIdentityService.extUri.joinPath(this.profilesHome,"builtin");if(await this.fileService.exists(e))try{await this.fileService.del(e,{recursive:!0})}catch(n){this.logService.error(n)}let r=await this.fileService.resolve(this.profilesHome);await Promise.all((r.children||[]).filter(n=>n.isDirectory&&this.profiles.every(o=>!this.uriIdentityService.extUri.isEqual(o.location,n.resource))).map(n=>this.fileService.del(n.resource,{recursive:!0})))}}catch(e){this.logService.error("Error deleting redundant profile folders",e)}try{let e=this.getStoredProfiles(),r=[];for(let n of this.getStoredProfiles())this.isInvalidProfile(n)?this.logService.warn(`Invalid user data profile found: ${n.name}`):r.push(n);e.length!==r.length&&this.saveStoredProfiles(r)}catch(e){this.logService.error("Error removing invalid stored profiles",e)}}async cleanUpTransientProfiles(){let e=this.transientProfilesObject.profiles.filter(r=>!this.isProfileAssociatedToWorkspace(r));await Promise.allSettled(e.map(r=>this.removeProfile(r)))}getProfileForWorkspace(e){let r=this.getWorkspace(e);return P.isUri(r)?this.profiles.find(n=>n.workspaces?.some(o=>this.uriIdentityService.extUri.isEqual(o,r))):this.profilesObject.emptyWindows.get(r)??this.transientProfilesObject.emptyWindows.get(r)}getWorkspace(e){return pg(e)?e.uri:fg(e)?e.configPath:e.id}isProfileAssociatedToWorkspace(e){return!!(e.workspaces?.length||[...this.profilesObject.emptyWindows.values()].some(r=>this.uriIdentityService.extUri.isEqual(r.location,e.location))||[...this.transientProfilesObject.emptyWindows.values()].some(r=>this.uriIdentityService.extUri.isEqual(r.location,e.location)))}updateProfiles(e,r,n,o=!1){let s=[...this.profiles,...e],a=this.transientProfilesObject.profiles;this.transientProfilesObject.profiles=[];let l=[];for(let c of s){if(r.some(u=>c.id===u.id)){for(let u of[...this.profilesObject.emptyWindows.keys()])c.id===this.profilesObject.emptyWindows.get(u)?.id&&this.profilesObject.emptyWindows.delete(u);continue}if(!c.isDefault){c=n.find(p=>c.id===p.id)??c;let u=a.find(p=>c.id===p.id);if(c.isTransient)this.transientProfilesObject.profiles.push(c);else if(u){for(let[p,f]of this.transientProfilesObject.emptyWindows.entries())if(c.id===f.id){this.transientProfilesObject.emptyWindows.delete(p),this.profilesObject.emptyWindows.set(p,c);break}}}c.workspaces?.length===0&&(c.workspaces=void 0),l.push(c)}this.updateStoredProfiles(l),o||this.triggerProfilesChanges(e,r,n)}triggerProfilesChanges(e,r,n){this._onDidChangeProfiles.fire({added:e,removed:r,updated:n,all:this.profiles})}updateEmptyWindowAssociation(e,r,n){n=r?.isTransient?!0:n,n?r?this.transientProfilesObject.emptyWindows.set(e,r):this.transientProfilesObject.emptyWindows.delete(e):(this.transientProfilesObject.emptyWindows.delete(e),r?this.profilesObject.emptyWindows.set(e,r):this.profilesObject.emptyWindows.delete(e))}updateStoredProfiles(e){let r=[],n={},o={};for(let s of e)if(!s.isTransient&&(s.isDefault||r.push({location:s.location,name:s.name,icon:s.icon,useDefaultFlags:s.useDefaultFlags}),s.workspaces))for(let a of s.workspaces)n[a.toString()]=s.id;for(let[s,a]of this.profilesObject.emptyWindows.entries())o[s.toString()]=a.id;this.saveStoredProfileAssociations({workspaces:n,emptyWindows:o}),this.saveStoredProfiles(r),this._profilesObject=void 0}getStoredProfiles(){return[]}saveStoredProfiles(e){throw new Error("not implemented")}getStoredProfileAssociations(){return{}}saveStoredProfileAssociations(e){throw new Error("not implemented")}getDefaultProfileExtensionsLocation(){}};Bi=T([I(0,gt),I(1,ee),I(2,me),I(3,V)],Bi);var L1="__$__isNewStorageMarker",Il="__$__targetStorageMarker",yg=B("storageService");function A1(i){let t=i.get(Il);if(t)try{return JSON.parse(t)}catch{}return Object.create(null)}var hg=class i extends _{constructor(e={flushInterval:i.DEFAULT_FLUSH_INTERVAL}){super();this._onDidChangeValue=this._register(new _n);this._onDidChangeTarget=this._register(new _n);this.onDidChangeTarget=this._onDidChangeTarget.event;this._onWillSaveState=this._register(new R);this.onWillSaveState=this._onWillSaveState.event;this.runFlushWhenIdle=this._register(new Zt);this._workspaceKeyTargets=void 0;this._profileKeyTargets=void 0;this._applicationKeyTargets=void 0;this.flushWhenIdleScheduler=this._register(new Dr(()=>this.doFlushWhenIdle(),e.flushInterval))}static{this.DEFAULT_FLUSH_INTERVAL=60*1e3}onDidChangeValue(e,r,n){return J.filter(this._onDidChangeValue.event,o=>o.scope===e&&(r===void 0||o.key===r),n)}doFlushWhenIdle(){this.runFlushWhenIdle.value=lu(()=>{this.shouldFlushWhenIdle()&&this.flush(),this.flushWhenIdleScheduler.schedule()})}shouldFlushWhenIdle(){return!0}stopFlushWhenIdle(){dt([this.runFlushWhenIdle,this.flushWhenIdleScheduler])}initialize(){return this.initializationPromise||(this.initializationPromise=(async()=>{gs("code/willInitStorage");try{await this.doInitialize()}finally{gs("code/didInitStorage")}this.flushWhenIdleScheduler.schedule()})()),this.initializationPromise}emitDidChangeValue(e,r){let{key:n,external:o}=r;if(n===Il){switch(e){case-1:this._applicationKeyTargets=void 0;break;case 0:this._profileKeyTargets=void 0;break;case 1:this._workspaceKeyTargets=void 0;break}this._onDidChangeTarget.fire({scope:e})}else this._onDidChangeValue.fire({scope:e,key:n,target:this.getKeyTargets(e)[n],external:o})}emitWillSaveState(e){this._onWillSaveState.fire({reason:e})}get(e,r,n){return this.getStorage(r)?.get(e,n)}getBoolean(e,r,n){return this.getStorage(r)?.getBoolean(e,n)}getNumber(e,r,n){return this.getStorage(r)?.getNumber(e,n)}getObject(e,r,n){return this.getStorage(r)?.getObject(e,n)}storeAll(e,r){this.withPausedEmitters(()=>{for(let n of e)this.store(n.key,n.value,n.scope,n.target,r)})}store(e,r,n,o,s=!1){if(Oe(r)){this.remove(e,n,s);return}this.withPausedEmitters(()=>{this.updateKeyTarget(e,n,o),this.getStorage(n)?.set(e,r,s)})}remove(e,r,n=!1){this.withPausedEmitters(()=>{this.updateKeyTarget(e,r,void 0),this.getStorage(r)?.delete(e,n)})}withPausedEmitters(e){this._onDidChangeValue.pause(),this._onDidChangeTarget.pause();try{e()}finally{this._onDidChangeValue.resume(),this._onDidChangeTarget.resume()}}keys(e,r){let n=[],o=this.getKeyTargets(e);for(let s of Object.keys(o))o[s]===r&&n.push(s);return n}updateKeyTarget(e,r,n,o=!1){let s=this.getKeyTargets(r);typeof n=="number"?s[e]!==n&&(s[e]=n,this.getStorage(r)?.set(Il,JSON.stringify(s),o)):typeof s[e]=="number"&&(delete s[e],this.getStorage(r)?.set(Il,JSON.stringify(s),o))}get workspaceKeyTargets(){return this._workspaceKeyTargets||(this._workspaceKeyTargets=this.loadKeyTargets(1)),this._workspaceKeyTargets}get profileKeyTargets(){return this._profileKeyTargets||(this._profileKeyTargets=this.loadKeyTargets(0)),this._profileKeyTargets}get applicationKeyTargets(){return this._applicationKeyTargets||(this._applicationKeyTargets=this.loadKeyTargets(-1)),this._applicationKeyTargets}getKeyTargets(e){switch(e){case-1:return this.applicationKeyTargets;case 0:return this.profileKeyTargets;default:return this.workspaceKeyTargets}}loadKeyTargets(e){let r=this.getStorage(e);return r?A1(r):Object.create(null)}isNew(e){return this.getBoolean(L1,e)===!0}async flush(e=0){this._onWillSaveState.fire({reason:e});let r=this.getStorage(-1),n=this.getStorage(0),o=this.getStorage(1);switch(e){case 0:await He.settled([r?.whenFlushed()??Promise.resolve(),n?.whenFlushed()??Promise.resolve(),o?.whenFlushed()??Promise.resolve()]);break;case 1:await He.settled([r?.flush(0)??Promise.resolve(),n?.flush(0)??Promise.resolve(),o?.flush(0)??Promise.resolve()]);break}}async log(){let e=this.getStorage(-1)?.items??new Map,r=this.getStorage(0)?.items??new Map,n=this.getStorage(1)?.items??new Map;return U1(e,r,n,this.getLogDetails(-1)??"",this.getLogDetails(0)??"",this.getLogDetails(1)??"")}async optimize(e){return await this.flush(),this.getStorage(e)?.optimize()}async switch(e,r){return this.emitWillSaveState(0),gg(e)?this.switchToProfile(e,r):this.switchToWorkspace(e,r)}canSwitchProfile(e,r){return!(e.id===r.id||vg(r)&&vg(e))}switchData(e,r,n){this.withPausedEmitters(()=>{let o=new Set;for(let[s,a]of e)o.add(s),r.get(s)!==a&&this.emitDidChangeValue(n,{key:s,external:!0});for(let[s]of r.items)o.has(s)||this.emitDidChangeValue(n,{key:s,external:!0})})}};function vg(i){return i.isDefault||!!i.useDefaultFlags?.globalState}async function U1(i,t,e,r,n,o){let s=h=>{try{return JSON.parse(h)}catch{return h}},a=new Map,l=new Map;i.forEach((h,y)=>{a.set(y,h),l.set(y,s(h))});let c=new Map,u=new Map;t.forEach((h,y)=>{c.set(y,h),u.set(y,s(h))});let p=new Map,f=new Map;e.forEach((h,y)=>{p.set(y,h),f.set(y,s(h))}),console.group(r!==n?`Storage: Application (path: ${r})`:`Storage: Application & Profile (path: ${r}, default profile)`);let g=[];if(a.forEach((h,y)=>{g.push({key:y,value:h})}),console.table(g),console.groupEnd(),console.log(l),r!==n){console.group(`Storage: Profile (path: ${n}, profile specific)`);let h=[];c.forEach((y,E)=>{h.push({key:E,value:y})}),console.table(h),console.groupEnd(),console.log(u)}console.group(`Storage: Workspace (path: ${o})`);let v=[];p.forEach((h,y)=>{v.push({key:y,value:h})}),console.table(v),console.groupEnd(),console.log(f)}async function Ig(i,t,e){let r=e&&e.get("storage.serviceMachineId",-1)||null;if(r)return r;try{let o=(await t.readFile(i.serviceMachineIdResource)).value.toString();r=qm(o)?o:null}catch{r=null}if(!r){r=Ne();try{await t.writeFile(i.serviceMachineIdResource,U.fromString(r))}catch{}}return e?.store("storage.serviceMachineId",r,-1,1),r}async function xg(i,t,e,r,n,o,s){let a={"X-Market-Client-Id":`VSCode ${i}`,"User-Agent":`VSCode ${i} (${t.nameShort})`};if(pl(t,e)&&fl(r)===3){let l=await Ig(e,n,o);a["X-Market-User-Id"]=l,a["VSCode-SessionId"]=s.machineId||l}return a}var Sn=B("IExtensionGalleryManifestService");function Kn(i,t){let[e,r]=t.split("/");for(let n of i.resources){let[o,s]=n.type.split("/");if(o===e){if(!r||s===r)return n.id;break}}}var xl=Je?"web":cl(Dn,na),El="X-Market-Search-Activity-Id",id="Activityid",od="Server",sd="X-Vss-E2eid",et={Icon:"Microsoft.VisualStudio.Services.Icons.Default",Details:"Microsoft.VisualStudio.Services.Content.Details",Changelog:"Microsoft.VisualStudio.Services.Content.Changelog",Manifest:"Microsoft.VisualStudio.Code.Manifest",VSIX:"Microsoft.VisualStudio.Services.VSIXPackage",License:"Microsoft.VisualStudio.Services.Content.License",Repository:"Microsoft.VisualStudio.Services.Links.Source",Signature:"Microsoft.VisualStudio.Services.VsixSignature"},gr={Dependency:"Microsoft.VisualStudio.Code.ExtensionDependencies",ExtensionPack:"Microsoft.VisualStudio.Code.ExtensionPack",Engine:"Microsoft.VisualStudio.Code.Engine",PreRelease:"Microsoft.VisualStudio.Code.PreRelease",EnabledApiProposals:"Microsoft.VisualStudio.Code.EnabledApiProposals",LocalizedLanguages:"Microsoft.VisualStudio.Code.LocalizedLanguages",WebExtension:"Microsoft.VisualStudio.Code.WebExtension",SponsorLink:"Microsoft.VisualStudio.Code.SponsorLink",SupportLink:"Microsoft.VisualStudio.Services.Links.Support",ExecutesCode:"Microsoft.VisualStudio.Code.ExecutesCode",Private:"PrivateMarketplace"},B1=10,G1={pageNumber:1,pageSize:B1,sortBy:"NoneOrRelevance",sortOrder:0,flags:[],criteria:[],assetTypes:[]};var Gi=class i{constructor(t=G1){this.state=t}get pageNumber(){return this.state.pageNumber}get pageSize(){return this.state.pageSize}get sortBy(){return this.state.sortBy}get sortOrder(){return this.state.sortOrder}get flags(){return this.state.flags}get criteria(){return this.state.criteria}get assetTypes(){return this.state.assetTypes}get source(){return this.state.source}get searchText(){let t=this.state.criteria.filter(e=>e.filterType==="SearchText")[0];return t&&t.value?t.value:""}withPage(t,e=this.state.pageSize){return new i({...this.state,pageNumber:t,pageSize:e})}withFilter(t,...e){let r=[...this.state.criteria,...e.length?e.map(n=>({filterType:t,value:n})):[{filterType:t}]];return new i({...this.state,criteria:r})}withSortBy(t){return new i({...this.state,sortBy:t})}withSortOrder(t){return new i({...this.state,sortOrder:t})}withFlags(...t){return new i({...this.state,flags:Mt(t)})}withAssetTypes(...t){return new i({...this.state,assetTypes:t})}withSource(t){return new i({...this.state,source:t})}};function ad(i,t){let e=(i||[]).filter(r=>r.statisticName===t)[0];return e?e.value:0}function q1(i){let t="Microsoft.VisualStudio.Code.Translation.";return i.files.filter(r=>r.assetType.indexOf(t)===0).reduce((r,n)=>{let o=mr(i,n.assetType);return o&&r.push([n.assetType.substring(t.length),o]),r},[])}function K1(i){if(i.properties){let t=i.properties.filter(n=>n.key===et.Repository),e=new RegExp("((git|ssh|http(s)?)|(git@[\\w.]+))(:(//)?)([\\w.@:/\\-~]+)(.git)(/)?"),r=t.filter(n=>e.test(n.value))[0];return r?{uri:r.value,fallbackUri:r.value}:null}return mr(i,et.Repository)}function z1(i){return{uri:`${i.fallbackAssetUri}/${et.VSIX}?redirect=true${i.targetPlatform?`&targetPlatform=${i.targetPlatform}`:""}`,fallbackUri:`${i.fallbackAssetUri}/${et.VSIX}${i.targetPlatform?`?targetPlatform=${i.targetPlatform}`:""}`}}function mr(i,t){return i.files.filter(r=>r.assetType===t)[0]?{uri:`${i.assetUri}/${t}${i.targetPlatform?`?targetPlatform=${i.targetPlatform}`:""}`,fallbackUri:`${i.fallbackAssetUri}/${t}${i.targetPlatform?`?targetPlatform=${i.targetPlatform}`:""}`}:null}function bg(i,t){let e=i.properties?i.properties.filter(n=>n.key===t):[],r=e.length>0&&e[0].value;return r?r.split(",").map(n=>us(n)):[]}function wl(i){let t=i.properties?i.properties.filter(e=>e.key===gr.Engine):[];return t.length>0&&t[0].value||""}function $1(i,t){i.properties=i.properties??[],i.properties.push({key:gr.Engine,value:t})}function zi(i){let t=i.properties?i.properties.filter(e=>e.key===gr.PreRelease):[];return t.length>0&&t[0].value==="true"}function wg(i,t){return t.extensionProperties?.[i.toLowerCase()]?.hasPrereleaseVersion}function j1(i,t){return t.extensionProperties?.[i.toLowerCase()]?.excludeVersionRange}function H1(i){let t=i.properties?i.properties.filter(e=>e.key===gr.Private):[];return t.length>0&&t[0].value==="true"}function Q1(i){let t=i.properties?i.properties.filter(e=>e.key===gr.ExecutesCode):[];return t.length>0?t[0].value==="true":void 0}function cd(i){let t=i.properties?i.properties.filter(r=>r.key===gr.EnabledApiProposals):[],e=t.length>0&&t[0].value||"";return e?e.split(","):[]}function J1(i){let t=i.properties?i.properties.filter(r=>r.key===gr.LocalizedLanguages):[],e=t.length>0&&t[0].value||"";return e?e.split(","):[]}function X1(i){return i.properties?.find(t=>t.key===gr.SponsorLink)?.value}function Y1(i){return i.properties?.find(t=>t.key===gr.SupportLink)?.value}function Z1(i){return i.indexOf("preview")!==-1}function zn(i){return i.targetPlatform?Nm(i.targetPlatform):"undefined"}function bl(i){let t=Mt(i.versions.map(zn)),e=!!i.tags?.includes(Mm),r=t.indexOf("web");return e?r===-1&&t.push("web"):r!==-1&&t.splice(r,1),t}function Sg(i,t){for(let e=0;e<i.length;e++){let r=i[e];if(r.version===i[e-1]?.version){let n=e;if(zn(r)===t)for(;n>0&&i[n-1].version===r.version;)n--;n!==e&&(i.splice(e,1),i.splice(n,0,r))}}return i}function eI(i,t,e){let r=[],n=-1,o=-1;for(let s of i){let a=zn(s);if(!as(a,e,t)){r.push(s);continue}zi(s)?n===-1?(n=r.length,r.push(s)):a===t&&r[n].version===s.version&&(r[n]=s):o===-1?(o=r.length,r.push(s)):a===t&&r[o].version===s.version&&(r[o]=s)}return r}function Eg(i,t,e){i.telemetryData={index:t,querySource:e,queryActivityId:i.queryContext?.[El]}}function ld(i,t,e,r,n,o){let s=i.versions[0],a={manifest:mr(t,et.Manifest),readme:mr(t,et.Details),changelog:mr(t,et.Changelog),license:mr(t,et.License),repository:K1(t),download:z1(t),icon:mr(t,et.Icon),signature:mr(t,et.Signature),coreTranslations:q1(t)},l=Kn(r,i.linkType??"ExtensionDetailsViewUriTemplate"),c=Kn(r,i.publisher.linkType??"PublisherViewUriTemplate"),u=Kn(r,i.ratingLinkType??"ExtensionRatingViewUriTemplate"),p=Dt(i.publisher.publisherName,i.extensionName);return{type:"gallery",identifier:{id:p,uuid:i.extensionId},name:i.extensionName,version:t.version,displayName:i.displayName,publisherId:i.publisher.publisherId,publisher:i.publisher.publisherName,publisherDisplayName:i.publisher.displayName,publisherDomain:i.publisher.domain?{link:i.publisher.domain,verified:!!i.publisher.isDomainVerified}:void 0,publisherSponsorLink:X1(s),description:i.shortDescription??"",installCount:ad(i.statistics,"install"),rating:ad(i.statistics,"averagerating"),ratingCount:ad(i.statistics,"ratingcount"),categories:i.categories||[],tags:i.tags||[],releaseDate:Date.parse(i.releaseDate),lastUpdated:Date.parse(i.lastUpdated),allTargetPlatforms:e,assets:a,properties:{dependencies:bg(t,gr.Dependency),extensionPack:bg(t,gr.ExtensionPack),engine:wl(t),enabledApiProposals:cd(t),localizedLanguages:J1(t),targetPlatform:zn(t),isPreReleaseVersion:zi(t),executesCode:Q1(t)},hasPreReleaseVersion:wg(p,n)??zi(s),hasReleaseVersion:!0,private:H1(s),preview:Z1(i.flags),isSigned:!!a.signature,queryContext:o,supportLink:Y1(s),detailsLink:l?$t(l,{publisher:i.publisher.publisherName,name:i.extensionName}):void 0,publisherLink:c?$t(c,{publisher:i.publisher.publisherName}):void 0,ratingLink:u?$t(u,{publisher:i.publisher.publisherName,name:i.extensionName}):void 0}}var qi=class{constructor(t,e,r,n,o,s,a,l,c,u){this.requestService=e;this.logService=r;this.environmentService=n;this.telemetryService=o;this.fileService=s;this.productService=a;this.configurationService=l;this.allowedExtensionsService=c;this.extensionGalleryManifestService=u;this.extensionsControlUrl=a.extensionsGallery?.controlUrl,this.unpkgResourceApi=a.extensionsGallery?.extensionUrlTemplate,this.extensionsEnabledWithApiProposalVersion=a.extensionsEnabledWithApiProposalVersion?.map(p=>p.toLowerCase())??[],this.commonHeadersPromise=xg(a.version,a,this.environmentService,this.configurationService,this.fileService,t,this.telemetryService)}isEnabled(){return this.extensionGalleryManifestService.extensionGalleryManifestStatus==="available"}async getExtensions(t,e,r){let n=await this.extensionGalleryManifestService.getExtensionGalleryManifest();if(!n)throw new Error("No extension gallery service configured.");let o=re.isCancellationToken(e)?{}:e,s=re.isCancellationToken(e)?e:r,a=this.getResourceApi(n),l=a?await this.getExtensionsUsingResourceApi(t,o,a,n,s):await this.getExtensionsUsingQueryApi(t,o,n,s),c=l.map(p=>p.identifier.uuid),u=[];for(let p of t)p.uuid&&!c.includes(p.uuid)&&u.push({...p,uuid:void 0});if(u.length){this.telemetryService.publicLog2("galleryService:additionalQueryByName",{count:u.length});let p=await this.getExtensionsUsingQueryApi(u,o,n,s);l.push(...p)}return l}getResourceApi(t){let e=Kn(t,"ExtensionLatestVersionUriTemplate");if(e)return{uri:e,fallback:this.unpkgResourceApi}}async getExtensionsUsingQueryApi(t,e,r,n){let o=[],s=[],a=[],l=[],c=!0;for(let f of t)f.uuid?s.push(f.uuid):o.push(f.id),f.version?l.push({id:f.id,uuid:f.uuid,version:f.version}):a.push({id:f.id,uuid:f.uuid,includePreRelease:!!f.preRelease}),c=c&&!!f.hasPreRelease&&!f.preRelease;if(!s.length&&!o.length)return[];let u=new Gi().withPage(1,t.length);s.length&&(u=u.withFilter("ExtensionId",...s)),o.length&&(u=u.withFilter("ExtensionName",...o)),e.queryAllVersions&&(u=u.withFlags(...u.flags,"IncludeVersions")),e.source&&(u=u.withSource(e.source));let{extensions:p}=await this.queryGalleryExtensions(u,{targetPlatform:e.targetPlatform??xl,includePreRelease:a,versions:l,compatible:!!e.compatible,productVersion:e.productVersion??{version:this.productService.version,date:this.productService.date},isQueryForReleaseVersionFromPreReleaseVersion:c},r,n);return e.source&&p.forEach((f,g)=>Eg(f,g,e.source)),p}async getExtensionsUsingResourceApi(t,e,r,n,o){let s=[],a=[],l=[];for(let c of t)ss.test(c.id)&&(c.version?a.push(c):l.push(c));if(await Promise.all(l.map(async c=>{let u;try{u=await this.getLatestGalleryExtension(c,e,r,n,o),te(u)?(this.telemetryService.publicLog2("galleryService:fallbacktoquery",{extension:c.id,preRelease:!!c.preRelease,compatible:!!e.compatible,errorCode:u}),a.push(c)):s.push(u)}catch(p){if(p instanceof Xt)switch(p.code){case"Offline":case"Cancelled":case"Timeout":throw p}this.logService.error(`Error while getting the latest version for the extension ${c.id}.`,G(p)),this.telemetryService.publicLog2("galleryService:fallbacktoquery",{extension:c.id,preRelease:!!c.preRelease,compatible:!!e.compatible,errorCode:p instanceof Xt?p.code:"Unknown"}),a.push(c)}})),a.length){let c=await this.getExtensionsUsingQueryApi(a,e,n,o);s.push(...c)}return s}async getLatestGalleryExtension(t,e,r,n,o){let s=await this.getLatestRawGalleryExtensionWithFallback(t,r,o);if(!s)return"NOT_FOUND";let a=bl(s),l=await this.getValidRawGalleryExtensionVersionFromLatestVersions(s,s.versions,t,e,a);return l?ld(s,l,a,n,this.productService):"NOT_COMPATIBLE"}async getValidRawGalleryExtensionVersionFromLatestVersions(t,e,r,n,o){let s=n.targetPlatform??xl,a=eI(e,s,o),l=await this.getValidRawGalleryExtensionVersion(t,a,{targetPlatform:s,compatible:!!n.compatible,productVersion:n.productVersion??{version:this.productService.version,date:this.productService.date},version:r.preRelease?1:0},o);if(!r.preRelease)return l;let c=l,u=await this.getValidRawGalleryExtensionVersion(t,a,{targetPlatform:s,compatible:!!n.compatible,productVersion:n.productVersion??{version:this.productService.version,date:this.productService.date},version:0},o);if(c&&u)return In(u.version,c.version)?u:c;if(n.compatible){if(u){let p=await this.getValidRawGalleryExtensionVersion(t,a,{targetPlatform:s,compatible:!1,productVersion:n.productVersion??{version:this.productService.version,date:this.productService.date},version:1},o);if(!p||In(u.version,p.version))return u}return c}return c??u??null}async getCompatibleExtension(t,e,r,n={version:this.productService.version,date:this.productService.date}){return Ni(t.allTargetPlatforms,r)?null:await this.isExtensionCompatible(t,e,r)?t:this.allowedExtensionsService.isAllowed({id:t.identifier.id,publisherDisplayName:t.publisherDisplayName})!==!0?null:(await this.getExtensions([{...t.identifier,preRelease:e,hasPreRelease:t.hasPreReleaseVersion}],{compatible:!0,productVersion:n,queryAllVersions:!0,targetPlatform:r},re.None))[0]??null}async isExtensionCompatible(t,e,r,n={version:this.productService.version,date:this.productService.date}){return this.isValidVersion({id:t.identifier.id,version:t.version,isPreReleaseVersion:t.properties.isPreReleaseVersion,targetPlatform:t.properties.targetPlatform,manifestAsset:t.assets.manifest,engine:t.properties.engine,enabledApiProposals:t.properties.enabledApiProposals},{targetPlatform:r,compatible:!0,productVersion:n,version:e?2:0},t.publisherDisplayName,t.allTargetPlatforms)}async isValidVersion(t,{targetPlatform:e,compatible:r,productVersion:n,version:o},s,a){let l=wg(t.id,this.productService),c=j1(t.id,this.productService);if(t.isPreReleaseVersion&&l===!1||c&&_m(t.version,c))return!1;if(te(o)){if(t.version!==o)return!1}else if((o===0||o===1)&&t.isPreReleaseVersion!==(o===1))return!1;return!(e&&!as(t.targetPlatform,a,e)||r&&(this.allowedExtensionsService.isAllowed({id:t.id,publisherDisplayName:s,version:t.version,prerelease:t.isPreReleaseVersion,targetPlatform:t.targetPlatform})!==!0||!this.areApiProposalsCompatible(t.id,t.enabledApiProposals)||!await this.isEngineValid(t.id,t.version,t.engine,t.manifestAsset,n)))}areApiProposalsCompatible(t,e){return!e||!this.extensionsEnabledWithApiProposalVersion.includes(t.toLowerCase())?!0:ms(e)}async isEngineValid(t,e,r,n,o){if(!r)try{r=await this.getEngine(t,e,n)}catch(s){return this.logService.error(`Error while getting the engine for the version ${e}.`,G(s)),!1}return r?fs(r,o.version,o.date):(this.logService.error(`Missing engine for the extension ${t} with version ${e}`),!1)}async getEngine(t,e,r){if(!r){this.logService.error(`Missing engine and manifest asset for the extension ${t} with version ${e}`);return}try{this.telemetryService.publicLog2("galleryService:engineFallback",{extension:t,extensionVersion:e});let n={"Accept-Encoding":"gzip"},o=await this.getAsset(t,r,et.Manifest,e,{headers:n}),s=await yn(o);if(!s){this.logService.error(`Manifest was not found for the extension ${t} with version ${e}`);return}return s.engines.vscode}catch(n){this.logService.error(`Error while getting the engine for the version ${e}.`,G(n));return}}async query(t,e){let r=await this.extensionGalleryManifestService.getExtensionGalleryManifest();if(!r)throw new Error("No extension gallery service configured.");let n=t.text||"",o=t.pageSize??50,s=new Gi().withPage(1,o);n?(n=n.replace(/\bcategory:("([^"]*)"|([^"]\S*))(\s+|\b|$)/g,(p,f,g)=>(s=s.withFilter("Category",g||f),"")),n=n.replace(/\btag:("([^"]*)"|([^"]\S*))(\s+|\b|$)/g,(p,f,g)=>(s=s.withFilter("Tag",g||f),"")),n=n.replace(/\bfeatured(\s+|\b|$)/g,()=>(s=s.withFilter("Featured"),"")),n=n.trim(),n&&(n=n.length<200?n:n.substring(0,200),s=s.withFilter("SearchText",n)),r.capabilities.extensionQuery.sorting?.some(p=>p.name==="NoneOrRelevance")&&(s=s.withSortBy("NoneOrRelevance"))):r.capabilities.extensionQuery.sorting?.some(p=>p.name==="InstallCount")&&(s=s.withSortBy("InstallCount")),t.sortBy&&r.capabilities.extensionQuery.sorting?.some(p=>p.name===t.sortBy)&&(s=s.withSortBy(t.sortBy)),typeof t.sortOrder=="number"&&(s=s.withSortOrder(t.sortOrder)),t.source&&(s=s.withSource(t.source));let a=async(p,f)=>{let{extensions:g,total:v}=await this.queryGalleryExtensions(p,{targetPlatform:xl,compatible:!1,includePreRelease:!!t.includePreRelease,productVersion:t.productVersion??{version:this.productService.version,date:this.productService.date}},r,f),h=[],y;for(let E=0;E<g.length;E++){let b=g[E];Eg(b,(p.pageNumber-1)*p.pageSize+E,t.source),H(b.identifier,{id:this.productService.defaultChatAgent.extensionId})?y=b:h.push(b)}return y&&h.push(y),{extensions:h,total:v}},{extensions:l,total:c}=await a(s,e),u=async(p,f)=>{if(f.isCancellationRequested)throw new Ie;let{extensions:g}=await a(s.withPage(p+1),f);return g};return{firstPage:l,total:c,pageSize:s.pageSize,getPage:u}}async queryGalleryExtensions(t,e,r,n){let o=t.flags;t.flags.includes("IncludeLatestVersionOnly")&&t.flags.includes("IncludeVersions")&&(t=t.withFlags(...t.flags.filter(f=>f!=="IncludeVersions"))),!t.flags.includes("IncludeLatestVersionOnly")&&!t.flags.includes("IncludeVersions")&&(t=t.withFlags(...t.flags,"IncludeLatestVersionOnly")),(e.versions?.length||e.isQueryForReleaseVersionFromPreReleaseVersion)&&(t=t.withFlags(...t.flags.filter(f=>f!=="IncludeLatestVersionOnly"),"IncludeVersions")),t=t.withFlags(...t.flags,"IncludeAssetUri","IncludeCategoryAndTags","IncludeFiles","IncludeStatistics","IncludeVersionProperties");let{galleryExtensions:s,total:a,context:l}=await this.queryRawGalleryExtensions(t,r,n);if(!t.flags.includes("IncludeLatestVersionOnly")){let f=[];for(let g of s){let v=bl(g),h={id:Dt(g.publisher.publisherName,g.extensionName),uuid:g.extensionId},y=Tt(e.includePreRelease)?e.includePreRelease:!!e.includePreRelease.find(b=>H(b,h))?.includePreRelease,E=await this.getValidRawGalleryExtensionVersion(g,g.versions,{compatible:e.compatible,targetPlatform:e.targetPlatform,productVersion:e.productVersion,version:e.versions?.find(b=>H(b,h))?.version??(y?2:0)},v);E&&f.push(ld(g,E,v,r,this.productService,l))}return{extensions:f,total:a}}let u=[],p=new Map;for(let f=0;f<s.length;f++){let g=s[f],v={id:Dt(g.publisher.publisherName,g.extensionName),uuid:g.extensionId},h=Tt(e.includePreRelease)?e.includePreRelease:!!e.includePreRelease.find(C=>H(C,v))?.includePreRelease,y=bl(g);if(e.compatible&&(Ni(y,e.targetPlatform)||this.allowedExtensionsService.isAllowed({id:v.id,publisherDisplayName:g.publisher.displayName})!==!0))continue;let E=await this.getValidRawGalleryExtensionVersion(g,g.versions,{compatible:e.compatible,targetPlatform:e.targetPlatform,productVersion:e.productVersion,version:e.versions?.find(C=>H(C,v))?.version??(h?2:0)},y),b=E?ld(g,E,y,r,this.productService,l):null;!b||b.properties.isPreReleaseVersion&&(!h||!b.hasReleaseVersion)||!b.properties.isPreReleaseVersion&&b.properties.targetPlatform!==e.targetPlatform&&b.hasPreReleaseVersion?p.set(g.extensionId,f):u.push([f,b])}if(p.size){let f=new an,g=new Gi().withFlags(...o.filter(h=>h!=="IncludeLatestVersionOnly"),"IncludeVersions").withPage(1,p.size).withFilter("ExtensionId",...p.keys()),{extensions:v}=await this.queryGalleryExtensions(g,e,r,n);this.telemetryService.publicLog2("galleryService:additionalQuery",{duration:f.elapsed(),count:p.size});for(let h of v){let y=p.get(h.identifier.uuid);u.push([y,h])}}return{extensions:u.sort((f,g)=>f[0]-g[0]).map(([,f])=>f),total:a}}async getValidRawGalleryExtensionVersion(t,e,r,n){let o={id:Dt(t.publisher.publisherName,t.extensionName),uuid:t.extensionId},s=Sg(e,r.targetPlatform);if(r.compatible&&Ni(n,r.targetPlatform))return null;let a=te(r.version)?r.version:void 0;for(let l=0;l<s.length;l++){let c=s[l];if(r.compatible&&await this.setEngineIfNotExists(o.id,c),await this.isValidVersion({id:o.id,version:c.version,isPreReleaseVersion:zi(c),targetPlatform:zn(c),engine:wl(c),manifestAsset:mr(c,et.Manifest),enabledApiProposals:cd(c)},r,t.publisher.displayName,n))return c;if(a&&c.version===a)return null}return a||r.compatible?null:t.versions[0]}async setEngineIfNotExists(t,e){if(!wl(e))try{let r=await this.getEngine(t,e.version,mr(e,et.Manifest));r&&$1(e,r)}catch(r){this.logService.error(`Error while getting the engine for the version ${e.version}.`,G(r))}}async queryRawGalleryExtensions(t,e,r){let n=Kn(e,"ExtensionQueryService");if(!n)throw new Error("No extension gallery query service configured.");t=t.withFlags(...t.flags,"ExcludeNonValidated").withFilter("Target","Microsoft.VisualStudio.Code");let o=e.capabilities.extensionQuery.flags?.find(g=>g.name==="Unpublished");o&&(t=t.withFilter("ExcludeWithFlags",String(o.value)));let s=JSON.stringify({filters:[{criteria:t.criteria.reduce((g,v)=>{let h=e.capabilities.extensionQuery.filtering?.find(y=>y.name===v.filterType);return h&&g.push({filterType:h.value,value:v.value}),g},[]),pageNumber:t.pageNumber,pageSize:t.pageSize,sortBy:e.capabilities.extensionQuery.sorting?.find(g=>g.name===t.sortBy)?.value,sortOrder:t.sortOrder}],assetTypes:t.assetTypes,flags:t.flags.reduce((g,v)=>{let h=e.capabilities.extensionQuery.flags?.find(y=>y.name===v);return h&&(g|=h.value),g},0)}),l={...await this.commonHeadersPromise,"Content-Type":"application/json",Accept:"application/json;api-version=3.0-preview.1","Accept-Encoding":"gzip","Content-Length":String(s.length)},c=new an,u,p,f=0;try{if(u=await this.requestService.request({type:"POST",url:n,data:s,headers:l},r),u.res.statusCode&&u.res.statusCode>=400&&u.res.statusCode<500)return{galleryExtensions:[],total:f};let g=await yn(u);if(g){let v=g.results[0],h=v.extensions,y=v.resultMetadata&&v.resultMetadata.filter(E=>E.metadataType==="ResultCount")[0];return f=y&&y.metadataItems.filter(E=>E.name==="TotalCount")[0].count||0,{galleryExtensions:h,total:f,context:u.res.headers.activityid?{[El]:u.res.headers.activityid}:{}}}return{galleryExtensions:[],total:f}}catch(g){if(or(g))throw p="Cancelled",g;{let v=G(g);throw p=Hu(g)?"Offline":v.startsWith("XHR timeout")?"Timeout":"Failed",new Xt(v,p)}}finally{this.telemetryService.publicLog2("galleryService:query",{filterTypes:t.criteria.map(g=>g.filterType),flags:t.flags,sortBy:t.sortBy,sortOrder:String(t.sortOrder),pageNumber:String(t.pageNumber),source:t.source,searchTextLength:t.searchText.length,requestBodySize:String(s.length),duration:c.elapsed(),success:!!u&&Mi(u),responseBodySize:u?.res.headers["Content-Length"],statusCode:u?String(u.res.statusCode):void 0,errorCode:p,count:String(f),server:this.getHeaderValue(u?.res.headers,od),activityId:this.getHeaderValue(u?.res.headers,id),endToEndId:this.getHeaderValue(u?.res.headers,sd)})}}getHeaderValue(t,e){let r=t?.[e.toLowerCase()],n=Array.isArray(r)?r[0]:r;return n?new xn(n):void 0}async getLatestRawGalleryExtensionWithFallback(t,e,r){let[n,o]=t.id.split("."),s;try{let a=P.parse($t(e.uri,{publisher:n,name:o}));return await this.getLatestRawGalleryExtension(t.id,a,r)}catch(a){if(a instanceof Xt)switch(s=a.code,a.code){case"Offline":case"Cancelled":case"Timeout":case"ClientError":throw a}else s="Unknown";if(!e.fallback)throw a}finally{this.telemetryService.publicLog2("galleryService:getmarketplacelatest",{extension:t.id,errorCode:s})}this.logService.error(`Error while getting the latest version for the extension ${t.id} from ${e.uri}. Trying the fallback ${e.fallback}`,s);try{let a=P.parse($t(e.fallback,{publisher:n,name:o}));return await this.getLatestRawGalleryExtension(t.id,a,r)}catch(a){throw s=a instanceof Xt?a.code:"Unknown",a}finally{this.telemetryService.publicLog2("galleryService:fallbacktounpkg",{extension:t.id,errorCode:s})}}async getLatestRawGalleryExtension(t,e,r){let n,o,s=new an;try{let l={...await this.commonHeadersPromise,"Content-Type":"application/json",Accept:"application/json;api-version=7.2-preview","Accept-Encoding":"gzip"};if(n=await this.requestService.request({type:"GET",url:e.toString(!0),headers:l,timeout:this.getRequestTimeout()},r),n.res.statusCode===404)return o="NotFound",null;if(n.res.statusCode&&n.res.statusCode!==200)throw new Error("Unexpected HTTP response: "+n.res.statusCode);let c=await yn(n);return c||(o="NoData"),c}catch(a){let l;throw or(a)?l="Cancelled":Hu(a)?l="Offline":G(a).startsWith("XHR timeout")?l="Timeout":n&&Im(n)?l="ClientError":n&&xm(n)?l="ServerError":l="Failed",o=l,new Xt(a,l)}finally{this.telemetryService.publicLog2("galleryService:getLatest",{extension:t,host:e.authority,duration:s.elapsed(),errorCode:o,statusCode:n?.res.statusCode&&n?.res.statusCode!==200?`${n.res.statusCode}`:void 0,server:this.getHeaderValue(n?.res.headers,od),activityId:this.getHeaderValue(n?.res.headers,id),endToEndId:this.getHeaderValue(n?.res.headers,sd)})}}async reportStatistic(t,e,r,n){if(Je){this.logService.info("ExtensionGalleryService#reportStatistic: Skipped in web");return}let o=await this.extensionGalleryManifestService.getExtensionGalleryManifest();if(!o)return;let s=Kn(o,"ExtensionStatisticsUriTemplate");if(!s)return;let a=$t(s,{publisher:t,name:e,version:r,statTypeName:n}),u={...await this.commonHeadersPromise,Accept:"*/*;api-version=4.0-preview.1"};try{await this.requestService.request({type:"POST",url:a,headers:u},re.None)}catch{}}async download(t,e,r){this.logService.trace("ExtensionGalleryService#download",t.identifier.id);let n=ps(t),o=new Date().getTime(),s=r===2?"install":r===3?"update":"",a=s?{uri:`${t.assets.download.uri}${P.parse(t.assets.download.uri).query?"&":"?"}${s}=true`,fallbackUri:`${t.assets.download.fallbackUri}${P.parse(t.assets.download.fallbackUri).query?"&":"?"}${s}=true`}:t.assets.download,l=t.queryContext?.[El],c=l&&typeof l=="string"?{[El]:l}:void 0,u=await this.getAsset(t.identifier.id,a,et.VSIX,t.version,c?{headers:c}:void 0);try{await this.fileService.writeFile(e,u.stream)}catch(p){try{await this.fileService.del(e)}catch(f){this.logService.warn(`Error while deleting the file ${e.toString()}`,G(f))}throw new Xt(G(p),"DownloadFailedWriting")}this.telemetryService.publicLog("galleryService:downloadVSIX",{...n,duration:new Date().getTime()-o})}async downloadSignatureArchive(t,e){if(!t.assets.signature)throw new Error("No signature asset found");this.logService.trace("ExtensionGalleryService#downloadSignatureArchive",t.identifier.id);let r=await this.getAsset(t.identifier.id,t.assets.signature,et.Signature,t.version);try{await this.fileService.writeFile(e,r.stream)}catch(n){try{await this.fileService.del(e)}catch(o){this.logService.warn(`Error while deleting the file ${e.toString()}`,G(o))}throw new Xt(G(n),"DownloadFailedWriting")}}async getReadme(t,e){if(t.assets.readme){let r=await this.getAsset(t.identifier.id,t.assets.readme,et.Details,t.version,{},e);return await vn(r)||""}return""}async getManifest(t,e){if(t.assets.manifest){let r=await this.getAsset(t.identifier.id,t.assets.manifest,et.Manifest,t.version,{},e),n=await vn(r);return n?JSON.parse(n):null}return null}async getCoreTranslation(t,e){let r=t.assets.coreTranslations.filter(n=>n[0]===e.toUpperCase())[0];if(r){let n=await this.getAsset(t.identifier.id,r[1],r[0],t.version),o=await vn(n);return o?JSON.parse(o):null}return null}async getChangelog(t,e){if(t.assets.changelog){let r=await this.getAsset(t.identifier.id,t.assets.changelog,et.Changelog,t.version,{},e);return await vn(r)||""}return""}async getAllVersions(t){return this.getVersions(t)}async getAllCompatibleVersions(t,e,r){return this.getVersions(t,{version:e?2:0,targetPlatform:r})}async getVersions(t,e){let r=await this.extensionGalleryManifestService.getExtensionGalleryManifest();if(!r)throw new Error("No extension gallery service configured.");let n=new Gi().withFlags("IncludeVersions","IncludeCategoryAndTags","IncludeFiles","IncludeVersionProperties").withPage(1,1);t.uuid?n=n.withFilter("ExtensionId",t.uuid):n=n.withFilter("ExtensionName",t.id);let{galleryExtensions:o}=await this.queryRawGalleryExtensions(n,r,re.None);if(!o.length)return[];let s=bl(o[0]);if(e&&Ni(s,e.targetPlatform))return[];let a=[],l={version:this.productService.version,date:this.productService.date};await Promise.all(o[0].versions.map(async p=>{try{await this.isValidVersion({id:t.id,version:p.version,isPreReleaseVersion:zi(p),targetPlatform:zn(p),engine:wl(p),manifestAsset:mr(p,et.Manifest),enabledApiProposals:cd(p)},{compatible:!!e,productVersion:l,targetPlatform:e?.targetPlatform,version:e?.version??p.version},o[0].publisher.displayName,s)&&a.push(p)}catch{}}));let c=[],u=new Map;for(let p of Sg(a,e?.targetPlatform??xl)){let f=u.get(p.version),g=f!==void 0?c[f]:void 0,v=zn(p);g?g.targetPlatforms.push(v):(u.set(p.version,c.length),c.push({version:p.version,date:p.lastUpdated,isPreReleaseVersion:zi(p),targetPlatforms:[v]}))}return c}async getAsset(t,e,r,n,o={},s=re.None){let a=await this.commonHeadersPromise,l={type:"GET"},c={...a,...o.headers||{}};o={...o,...l,headers:c};let u=e.uri,p=e.fallbackUri,f={...o,url:u,timeout:this.getRequestTimeout()},g;try{if(g=await this.requestService.request(f,s),g.res.statusCode===200)return g;let v=await vn(g);throw new Error(`Expected 200, got back ${g.res.statusCode} instead.

${v}`)}catch(v){if(or(v))throw v;let h=G(v);this.telemetryService.publicLog2("galleryService:cdnFallback",{extension:t,assetType:r,message:h,extensionVersion:n,server:this.getHeaderValue(g?.res.headers,od),activityId:this.getHeaderValue(g?.res.headers,id),endToEndId:this.getHeaderValue(g?.res.headers,sd)});let y={...o,url:p,timeout:this.getRequestTimeout()};return this.requestService.request(y,s)}}async getExtensionsControlManifest(){if(!await this.extensionGalleryManifestService.getExtensionGalleryManifest())throw new Error("No extension gallery service configured.");if(!this.extensionsControlUrl)return{malicious:[],deprecated:{},search:[],autoUpdate:{}};let e=await this.requestService.request({type:"GET",url:this.extensionsControlUrl,timeout:this.getRequestTimeout()},re.None);if(e.res.statusCode!==200)throw new Error("Could not get extensions report.");let r=await yn(e),n=[],o={},s=[],a=r?.autoUpdate??{};if(r){for(let l of r.malicious){if(!te(l))continue;let c=ss.test(l)?{id:l}:l;n.push({extensionOrPublisher:c,learnMoreLink:r.learnMoreLinks?.[l]})}if(r.migrateToPreRelease)for(let[l,c]of Object.entries(r.migrateToPreRelease))(!c.engine||fs(c.engine,this.productService.version,this.productService.date))&&(o[l.toLowerCase()]={disallowInstall:!0,extension:{id:c.id,displayName:c.displayName,autoMigrate:{storage:!!c.migrateStorage},preRelease:!0}});if(r.deprecated)for(let[l,c]of Object.entries(r.deprecated))c&&(o[l.toLowerCase()]=Tt(c)?{}:c);if(r.search)for(let l of r.search)s.push(l)}return o[this.productService.defaultChatAgent.extensionId.toLowerCase()]={disallowInstall:!0,extension:{id:this.productService.defaultChatAgent.chatExtensionId,displayName:"GitHub Copilot Chat",autoMigrate:{storage:!1,donotDisable:!0},preRelease:this.productService.quality!=="stable"}},{malicious:n,deprecated:o,search:s,autoUpdate:a}}getRequestTimeout(){let t=this.configurationService.getValue(Bm);return sn(t)&&t>=0?t:6e4}};qi=T([I(1,rr),I(2,V),I(3,gt),I(4,St),I(5,ee),I(6,ke),I(7,It),I(8,fr),I(9,Sn)],qi);var Sl=class extends qi{constructor(t,e,r,n,o,s,a,l,c,u){super(t,e,r,n,o,s,a,l,c,u)}};Sl=T([I(0,yg),I(1,rr),I(2,V),I(3,gt),I(4,St),I(5,ee),I(6,ke),I(7,It),I(8,fr),I(9,Sn)],Sl);var Ki=class extends qi{constructor(t,e,r,n,o,s,a,l,c){super(void 0,t,e,r,n,o,s,a,l,c)}};Ki=T([I(0,rr),I(1,V),I(2,gt),I(3,St),I(4,ee),I(5,ke),I(6,It),I(7,fr),I(8,Sn)],Ki);var Pl=B("IExtensionSignatureVerificationService"),$i=class{constructor(t,e){this.logService=t;this.telemetryService=e}vsceSign(){return this.moduleLoadingPromise||(this.moduleLoadingPromise=this.resolveVsceSign()),this.moduleLoadingPromise}async resolveVsceSign(){return import("@vscode/vsce-sign")}async verify(t,e,r,n,o){let s;try{s=await this.vsceSign()}catch(u){this.logService.error("Could not load vsce-sign module",G(u)),this.logService.info(`Extension signature verification is not done: ${t}`);return}let a=new Date().getTime(),l;try{this.logService.trace(`Verifying extension signature for ${t}...`),l=await s.verify(r,n,this.logService.getLevel()===1)}catch(u){l={code:"UnknownError",didExecute:!1,output:G(u)}}let c=new Date().getTime()-a;return this.logService.info(`Extension signature verification result for ${t}: ${l.code}. ${js(l.internalCode)?`Internal Code: ${l.internalCode}. `:""}Executed: ${l.didExecute}. Duration: ${c}ms.`),this.logService.trace(`Extension signature verification output for ${t}:
${l.output}`),this.telemetryService.publicLog2("extensionsignature:verification",{extensionId:t,extensionVersion:e,code:l.code,internalCode:l.internalCode,duration:c,didExecute:l.didExecute,clientTargetPlatform:o}),{code:l.code}}};$i=T([I(0,V),I(1,St)],$i);var tI=i=>m(1994,null,i),Pg=m(2007,null,"ms-dotnettools.csharp"),Or=class{constructor(t,e,r,n,o){this.extensionsForceVersionByQuality=t;this.logger=e;this.extensionManagementService=r;this.extensionGalleryService=n;this.productService=o;this.extensionsForceVersionByQuality=this.extensionsForceVersionByQuality.map(s=>s.toLowerCase())}get location(){}async listExtensions(t,e,r){let n=await this.extensionManagementService.getInstalled(1,r),o=Lm.map(a=>a.toLowerCase());if(e&&e!==""){if(o.indexOf(e.toLowerCase())<0){this.logger.info("Invalid category please enter a valid category. To list valid categories run --category without a category specified");return}n=n.filter(a=>a.manifest.categories?a.manifest.categories.map(c=>c.toLowerCase()).indexOf(e.toLowerCase())>-1:!1)}else if(e===""){this.logger.info("Possible Categories: "),o.forEach(a=>{this.logger.info(a)});return}this.location&&this.logger.info(m(1993,null,this.location)),n=n.sort((a,l)=>a.identifier.id.localeCompare(l.identifier.id));let s;for(let a of n)s!==a.identifier.id&&(s=a.identifier.id,this.logger.info(t?`${s}@${a.manifest.version}`:s))}async installExtensions(t,e,r,n){let o=[];try{t.length&&this.logger.info(this.location?m(1992,null,this.location):m(1991,null));let s=[],a=[],l=(u,p,f)=>{this.extensionsForceVersionByQuality?.some(g=>g===u.toLowerCase())&&(p=this.productService.quality!=="stable"?"prerelease":void 0),a.push({id:u,version:p!=="prerelease"?p:void 0,installOptions:{...r,isBuiltin:f,installPreReleaseVersion:p==="prerelease"||r.installPreReleaseVersion}})};for(let u of t)if(u instanceof P)s.push({vsix:u,installOptions:r});else{let[p,f]=ds(u);l(p,f,!1)}for(let u of e)if(u instanceof P)s.push({vsix:u,installOptions:{...r,isBuiltin:!0,donotIncludePackAndDependencies:!0}});else{let[p,f]=ds(u);l(p,f,!0)}let c=await this.extensionManagementService.getInstalled(void 0,r.profileLocation);if(s.length&&await Promise.all(s.map(async({vsix:u,installOptions:p})=>{try{await this.installVSIX(u,p,n,c)}catch(f){this.logger.error(f),o.push(u.toString())}})),a.length){let u=await this.installGalleryExtensions(a,c,n);o.push(...u)}}catch(s){throw this.logger.error(m(1981,null,G(s))),s}if(o.length)throw new Error(m(1986,null,o.join(", ")))}async updateExtensions(t){let e=await this.extensionManagementService.getInstalled(1,t),r=[];for(let a of e)a.identifier.uuid&&r.push({...a.identifier,preRelease:a.preRelease});this.logger.trace(m(2005,null,r.length));let n=await this.extensionGalleryService.getExtensions(r,{compatible:!0},re.None),o=[];for(let a of n)for(let l of e)H(l.identifier,a.identifier)&&In(a.version,l.manifest.version)&&o.push({extension:a,options:{operation:3,installPreReleaseVersion:l.preRelease,profileLocation:t,isApplicationScoped:l.isApplicationScoped}});if(!o.length){this.logger.info(m(2004,null));return}this.logger.info(m(2003,null,o.map(a=>a.extension.identifier.id).join(", ")));let s=await this.extensionManagementService.installGalleryExtensions(o);for(let a of s)a.error?this.logger.error(m(1983,null,a.identifier.id,G(a.error))):this.logger.info(m(2000,null,a.identifier.id,a.local?.manifest.version))}async installGalleryExtensions(t,e,r){if(t=t.filter(a=>{let{id:l,version:c,installOptions:u}=a,p=e.find(f=>H(f.identifier,{id:l}));if(p){if(!r&&(!c||c==="prerelease"&&p.preRelease))return this.logger.info(m(1978,null,l,p.manifest.version,l)),!1;if(c&&p.manifest.version===c)return this.logger.info(m(1977,null,`${l}@${c}`)),!1;p.preRelease&&c!=="prerelease"&&(u.preRelease=!1)}return!0}),!t.length)return[];let n=[],o=[],s=await this.getGalleryExtensions(t);if(await Promise.all(t.map(async({id:a,version:l,installOptions:c})=>{let u=s.get(a.toLowerCase());if(!u){this.logger.error(`${tI(l?`${a}@${l}`:a)}
${Pg}`),n.push(a);return}try{let f=await this.extensionGalleryService.getManifest(u,re.None);if(f&&!this.validateExtensionKind(f))return}catch(f){this.logger.error(f.message||f.stack||f),n.push(a);return}let p=e.find(f=>H(f.identifier,u.identifier));if(p){if(u.version===p.manifest.version){this.logger.info(m(1977,null,l?`${a}@${l}`:a));return}this.logger.info(m(2006,null,a,u.version))}c.isBuiltin?this.logger.info(l?m(1989,null,a,l):m(1988,null,a)):this.logger.info(l?m(1990,null,a,l):m(1987,null,a)),o.push({extension:u,options:{...c,installGivenVersion:!!l,isApplicationScoped:c.isApplicationScoped||p?.isApplicationScoped}})})),o.length){let a=await this.extensionManagementService.installGalleryExtensions(o);for(let l of a)l.error?(this.logger.error(m(1982,null,l.identifier.id,G(l.error))),n.push(l.identifier.id)):this.logger.info(m(1997,null,l.identifier.id,l.local?.manifest.version))}return n}async installVSIX(t,e,r,n){let o=await this.extensionManagementService.getManifest(t);if(!o)throw new Error("Invalid vsix");if(await this.validateVSIX(o,r,e.profileLocation,n))try{await this.extensionManagementService.install(t,{...e,installGivenVersion:!0}),this.logger.info(m(2001,null,kr(t)))}catch(a){if(or(a))this.logger.info(m(1980,null,kr(t)));else throw a}}async getGalleryExtensions(t){let e=new Map,r=t.some(s=>s.installOptions.installPreReleaseVersion),n=await this.extensionManagementService.getTargetPlatform(),o=[];for(let s of t)ss.test(s.id)&&o.push({...s,preRelease:r});if(o.length){let s=await this.extensionGalleryService.getExtensions(o,{targetPlatform:n},re.None);for(let a of s)e.set(a.identifier.id.toLowerCase(),a)}return e}validateExtensionKind(t){return!0}async validateVSIX(t,e,r,n){if(!e){let o={id:Dt(t.publisher,t.name)},s=n.find(a=>H(o,a.identifier)&&In(a.manifest.version,t.version));if(s)return this.logger.info(m(1984,null,s.identifier.id,s.manifest.version,t.version)),!1}return this.validateExtensionKind(t)}async uninstallExtensions(t,e,r){let n=async s=>{if(s instanceof P){let a=await this.extensionManagementService.getManifest(s);return ml(a.publisher,a.name)}return s},o=[];for(let s of t){let a=await n(s),c=(await this.extensionManagementService.getInstalled(void 0,r)).filter(u=>H(u.identifier,{id:a}));if(!c.length)throw new Error(`${this.notInstalled(a)}
${Pg}`);if(c.some(u=>u.type===0)){this.logger.info(m(1979,null,a));return}if(!e&&c.some(u=>u.isBuiltin)){this.logger.info(m(1985,null,a));return}this.logger.info(m(2002,null,a));for(let u of c)await this.extensionManagementService.uninstall(u,{profileLocation:r}),o.push(u);this.location?this.logger.info(m(1999,null,a,this.location)):this.logger.info(m(1998,null,a))}}async locateExtension(t){let e=await this.extensionManagementService.getInstalled();t.forEach(r=>{e.forEach(n=>{if(n.identifier.id===r&&n.location.scheme===$.file){this.logger.info(n.location.fsPath);return}})})}notInstalled(t){return this.location?m(1996,null,t,this.location):m(1995,null,t)}};Or=T([I(2,Vi),I(3,kt),I(4,ke)],Or);var $n=class extends Error{constructor(e,r){super(e);this.code=r}},nr=B("IExtensionsProfileScannerService"),ji=class extends _{constructor(e,r,n,o,s){super();this.extensionsLocation=e;this.fileService=r;this.userDataProfilesService=n;this.uriIdentityService=o;this.logService=s;this._onAddExtensions=this._register(new R);this.onAddExtensions=this._onAddExtensions.event;this._onDidAddExtensions=this._register(new R);this.onDidAddExtensions=this._onDidAddExtensions.event;this._onRemoveExtensions=this._register(new R);this.onRemoveExtensions=this._onRemoveExtensions.event;this._onDidRemoveExtensions=this._register(new R);this.onDidRemoveExtensions=this._onDidRemoveExtensions.event;this.resourcesAccessQueueMap=new be}scanProfileExtensions(e,r){return this.withProfileExtensions(e,void 0,r)}async addExtensionsToProfile(e,r,n){let o=[],s=[];try{return await this.withProfileExtensions(r,a=>{let l=[];if(n)l.push(...a);else for(let c of a)e.some(([u])=>H(u.identifier,c.identifier)&&u.manifest.version!==c.version)?o.push(c):l.push(c);for(let[c,u]of e){let p=l.findIndex(g=>H(g.identifier,c.identifier)&&g.version===c.manifest.version),f={identifier:c.identifier,version:c.manifest.version,location:c.location,metadata:u};p===-1?(s.push(f),l.push(f)):l.splice(p,1,f)}return s.length&&this._onAddExtensions.fire({extensions:s,profileLocation:r}),o.length&&this._onRemoveExtensions.fire({extensions:o,profileLocation:r}),l}),s.length&&this._onDidAddExtensions.fire({extensions:s,profileLocation:r}),o.length&&this._onDidRemoveExtensions.fire({extensions:o,profileLocation:r}),s}catch(a){throw s.length&&this._onDidAddExtensions.fire({extensions:s,error:a,profileLocation:r}),o.length&&this._onDidRemoveExtensions.fire({extensions:o,error:a,profileLocation:r}),a}}async updateMetadata(e,r){let n=[];return await this.withProfileExtensions(r,o=>{let s=[];for(let a of o){let l=e.find(([c])=>H({id:c.identifier.id},{id:a.identifier.id})&&c.manifest.version===a.version);l&&(a.metadata={...a.metadata,...l[1]},n.push(a)),s.push(a)}return s}),n}async removeExtensionsFromProfile(e,r){let n=[];try{await this.withProfileExtensions(r,o=>{let s=[];for(let a of o)e.some(l=>H(a.identifier,l))?n.push(a):s.push(a);return n.length&&this._onRemoveExtensions.fire({extensions:n,profileLocation:r}),s}),n.length&&this._onDidRemoveExtensions.fire({extensions:n,profileLocation:r})}catch(o){throw n.length&&this._onDidRemoveExtensions.fire({extensions:n,error:o,profileLocation:r}),o}}async withProfileExtensions(e,r,n){return this.getResourceAccessQueue(e).queue(async()=>{let o=[],s;try{let a=await this.fileService.readFile(e);s=JSON.parse(a.value.toString().trim()||"[]")}catch(a){if(Se(a)!==1)throw a;if(this.uriIdentityService.extUri.isEqual(e,this.userDataProfilesService.defaultProfile.extensionsResource)&&(s=await this.migrateFromOldDefaultProfileExtensionsLocation()),!s&&n?.bailOutWhenFileNotFound)throw new $n(G(a),"ERROR_PROFILE_NOT_FOUND")}if(s){Array.isArray(s)||this.throwInvalidConentError(e);let a=!1;for(let l of s){Tg(l)||this.throwInvalidConentError(e);let c;if(te(l.relativeLocation)&&l.relativeLocation)c=this.resolveExtensionLocation(l.relativeLocation);else if(te(l.location)){this.logService.warn(`Extensions profile: Ignoring extension with invalid location: ${l.location}`);continue}else{c=P.revive(l.location);let p=this.toRelativePath(c);p&&(a=!0,l.relativeLocation=p)}ut(l.metadata?.hasPreReleaseVersion)&&l.metadata?.preRelease&&(a=!0,l.metadata.hasPreReleaseVersion=!0);let u=l.metadata?.id??l.identifier.uuid;o.push({identifier:u?{id:l.identifier.id,uuid:u}:{id:l.identifier.id},location:c,version:l.version,metadata:l.metadata})}a&&await this.fileService.writeFile(e,U.fromString(JSON.stringify(s)))}if(r){o=r(o);let a=o.map(l=>({identifier:l.identifier,version:l.version,location:l.location.toJSON(),relativeLocation:this.toRelativePath(l.location),metadata:l.metadata}));await this.fileService.writeFile(e,U.fromString(JSON.stringify(a)))}return o})}throwInvalidConentError(e){throw new $n(`Invalid extensions content in ${e.toString()}`,"ERROR_INVALID_CONTENT")}toRelativePath(e){return this.uriIdentityService.extUri.isEqual(this.uriIdentityService.extUri.dirname(e),this.extensionsLocation)?this.uriIdentityService.extUri.basename(e):void 0}resolveExtensionLocation(e){return this.uriIdentityService.extUri.joinPath(this.extensionsLocation,e)}async migrateFromOldDefaultProfileExtensionsLocation(){return this._migrationPromise||(this._migrationPromise=(async()=>{let e=this.uriIdentityService.extUri.joinPath(this.userDataProfilesService.defaultProfile.location,"extensions.json"),r=this.uriIdentityService.extUri.joinPath(this.extensionsLocation,".init-default-profile-extensions"),n;try{n=(await this.fileService.readFile(e)).value.toString()}catch(s){if(Se(s)===1)return;throw s}this.logService.info("Migrating extensions from old default profile location",e.toString());let o;try{let s=JSON.parse(n);Array.isArray(s)&&s.every(a=>Tg(a))?o=s:this.logService.warn("Skipping migrating from old default profile locaiton: Found invalid data",s)}catch(s){this.logService.error(s)}if(o)try{await this.fileService.createFile(this.userDataProfilesService.defaultProfile.extensionsResource,U.fromString(JSON.stringify(o)),{overwrite:!1}),this.logService.info("Migrated extensions from old default profile location to new location",e.toString(),this.userDataProfilesService.defaultProfile.extensionsResource.toString())}catch(s){if(Se(s)===3)this.logService.info("Migration from old default profile location to new location is done by another window",e.toString(),this.userDataProfilesService.defaultProfile.extensionsResource.toString());else throw s}try{await this.fileService.del(e)}catch(s){Se(s)!==1&&this.logService.error(s)}try{await this.fileService.del(r)}catch(s){Se(s)!==1&&this.logService.error(s)}return o})()),this._migrationPromise}getResourceAccessQueue(e){let r=this.resourcesAccessQueueMap.get(e);return r||(r=new jt,this.resourcesAccessQueueMap.set(e,r)),r}};ji=T([I(1,ee),I(2,$e),I(3,me),I(4,V)],ji);function Tg(i){let t=i;return he(t)&&Vm(t.identifier)&&(rI(t.location)||te(t.location)&&!!t.location)&&(ut(t.relativeLocation)||te(t.relativeLocation))&&!!t.version&&te(t.version)}function rI(i){if(!i)return!1;let t=i;return typeof t?.path=="string"&&typeof t?.scheme=="string"}function Rl(i){switch(i){case 1:return m(121,null);case 2:return m(120,null);case 3:return m(122,null);case 4:return m(123,null);case 5:return m(117,null);case 6:return m(118,null);case 7:return m(115,null);case 8:return m(116,null);case 9:return m(119,null);default:return""}}function Rg(i,t,e,r){try{nI(i,t,e,r)}catch(n){i.error(n?.message??n)}return t}function nI(i,t,e,r){let n=(o,s,a)=>{let l=o[s];if(te(l)){let c=l,u=c.length;if(u>1&&c[0]==="%"&&c[u-1]==="%"){let p=c.substr(1,u-2),f=e[p];f===void 0&&r&&(f=r[p]);let g=typeof f=="string"?f:f?.message,v=r?.[p],h=typeof v=="string"?v:v?.message;if(!g){h||i.warn(`[${t.name}]: ${m(2008,null,p)}`);return}if(a&&(s==="title"||s==="category")&&h&&h!==g){let y={value:g,original:h};o[s]=y}else o[s]=g}}else if(he(l))for(let c in l)l.hasOwnProperty(c)&&(c==="commands"?n(l,c,!0):n(l,c,a));else if(Array.isArray(l))for(let c=0;c<l.length;c++)n(l,c,a)};for(let o in t)t.hasOwnProperty(o)&&n(t,o)}var Cg;(t=>{function i(e,r){if(e===r)return!0;let n=Object.keys(e),o=new Set;for(let s of Object.keys(r))o.add(s);if(n.length!==o.size)return!1;for(let s of n){if(e[s]!==r[s])return!1;o.delete(s)}return o.size===0}t.equals=i})(Cg||={});var Ji=B("IExtensionsScannerService"),hs=class extends _{constructor(e,r,n,o,s,a,l,c,u,p,f,g){super();this.systemExtensionsLocation=e;this.userExtensionsLocation=r;this.extensionsControlLocation=n;this.userDataProfilesService=s;this.extensionsProfileScannerService=a;this.fileService=l;this.logService=c;this.environmentService=u;this.productService=p;this.uriIdentityService=f;this.instantiationService=g;this._onDidChangeCache=this._register(new R);this.onDidChangeCache=this._onDidChangeCache.event;this.initializeDefaultProfileExtensionsPromise=void 0;this.systemExtensionsCachedScanner=this._register(this.instantiationService.createInstance(Qi,o)),this.userExtensionsCachedScanner=this._register(this.instantiationService.createInstance(Qi,o)),this.extensionsScanner=this._register(this.instantiationService.createInstance(Hi)),this._register(this.systemExtensionsCachedScanner.onDidChangeCache(()=>this._onDidChangeCache.fire(0))),this._register(this.userExtensionsCachedScanner.onDidChangeCache(()=>this._onDidChangeCache.fire(1)))}getTargetPlatform(){return this._targetPlatformPromise||(this._targetPlatformPromise=hl(this.fileService,this.logService)),this._targetPlatformPromise}async scanAllExtensions(e,r){let[n,o]=await Promise.all([this.scanSystemExtensions(e),this.scanUserExtensions(r)]);return this.dedupExtensions(n,o,[],await this.getTargetPlatform(),!0)}async scanSystemExtensions(e){let r=[];r.push(this.scanDefaultSystemExtensions(e.language)),r.push(this.scanDevSystemExtensions(e.language,!!e.checkControlFile));let[n,o]=await Promise.all(r);return this.applyScanOptions([...n,...o],0,{pickLatest:!1})}async scanUserExtensions(e){this.logService.trace("Started scanning user extensions",e.profileLocation);let r=this.uriIdentityService.extUri.isEqual(e.profileLocation,this.userDataProfilesService.defaultProfile.extensionsResource)?{bailOutWhenFileNotFound:!0}:void 0,n=await this.createExtensionScannerInput(e.profileLocation,!0,1,e.language,!0,r,e.productVersion??this.getProductVersion()),o=e.useCache&&!n.devMode?this.userExtensionsCachedScanner:this.extensionsScanner,s;try{s=await o.scanExtensions(n)}catch(a){if(a instanceof $n&&a.code==="ERROR_PROFILE_NOT_FOUND")await this.doInitializeDefaultProfileExtensions(),s=await o.scanExtensions(n);else throw a}return s=await this.applyScanOptions(s,1,{includeInvalid:e.includeInvalid,pickLatest:!0}),this.logService.trace("Scanned user extensions:",s.length),s}async scanAllUserExtensions(e={includeInvalid:!0,includeAllVersions:!0}){let r=await this.createExtensionScannerInput(this.userExtensionsLocation,!1,1,void 0,!0,void 0,this.getProductVersion()),n=await this.extensionsScanner.scanExtensions(r);return this.applyScanOptions(n,1,{includeAllVersions:e.includeAllVersions,includeInvalid:e.includeInvalid})}async scanExtensionsUnderDevelopment(e,r){if(this.environmentService.isExtensionDevelopment&&this.environmentService.extensionDevelopmentLocationURI){let n=(await Promise.all(this.environmentService.extensionDevelopmentLocationURI.filter(o=>o.scheme===$.file).map(async o=>{let s=await this.createExtensionScannerInput(o,!1,1,r.language,!1,void 0,this.getProductVersion());return(await this.extensionsScanner.scanOneOrMultipleExtensions(s)).map(l=>(l.type=e.find(c=>H(c.identifier,l.identifier))?.type??l.type,this.extensionsScanner.validate(l,s)))}))).flat();return this.applyScanOptions(n,"development",{includeInvalid:r.includeInvalid,pickLatest:!0})}return[]}async scanExistingExtension(e,r,n){let o=await this.createExtensionScannerInput(e,!1,r,n.language,!0,void 0,this.getProductVersion()),s=await this.extensionsScanner.scanExtension(o);return!s||!n.includeInvalid&&!s.isValid?null:s}async scanOneOrMultipleExtensions(e,r,n){let o=await this.createExtensionScannerInput(e,!1,r,n.language,!0,void 0,this.getProductVersion()),s=await this.extensionsScanner.scanOneOrMultipleExtensions(o);return this.applyScanOptions(s,r,{includeInvalid:n.includeInvalid,pickLatest:!0})}async scanMultipleExtensions(e,r,n){let o=[];return await Promise.all(e.map(async s=>{let a=await this.scanOneOrMultipleExtensions(s,r,n);o.push(...a)})),this.applyScanOptions(o,r,{includeInvalid:n.includeInvalid,pickLatest:!0})}async updateManifestMetadata(e,r){let n=z(e,"package.json"),o=(await this.fileService.readFile(n)).value.toString(),s=JSON.parse(o);s.__metadata={...s.__metadata,...r},await this.fileService.writeFile(z(e,"package.json"),U.fromString(JSON.stringify(s,null,"	")))}async initializeDefaultProfileExtensions(){try{await this.extensionsProfileScannerService.scanProfileExtensions(this.userDataProfilesService.defaultProfile.extensionsResource,{bailOutWhenFileNotFound:!0})}catch(e){if(e instanceof $n&&e.code==="ERROR_PROFILE_NOT_FOUND")await this.doInitializeDefaultProfileExtensions();else throw e}}async doInitializeDefaultProfileExtensions(){return this.initializeDefaultProfileExtensionsPromise||(this.initializeDefaultProfileExtensionsPromise=(async()=>{try{this.logService.info("Started initializing default profile extensions in extensions installation folder.",this.userExtensionsLocation.toString());let e=await this.scanAllUserExtensions({includeInvalid:!0});if(e.length)await this.extensionsProfileScannerService.addExtensionsToProfile(e.map(r=>[r,r.metadata]),this.userDataProfilesService.defaultProfile.extensionsResource);else try{await this.fileService.createFile(this.userDataProfilesService.defaultProfile.extensionsResource,U.fromString(JSON.stringify([])))}catch(r){Se(r)!==1&&this.logService.warn("Failed to create default profile extensions manifest in extensions installation folder.",this.userExtensionsLocation.toString(),G(r))}this.logService.info("Completed initializing default profile extensions in extensions installation folder.",this.userExtensionsLocation.toString())}catch(e){this.logService.error(e)}finally{this.initializeDefaultProfileExtensionsPromise=void 0}})()),this.initializeDefaultProfileExtensionsPromise}async applyScanOptions(e,r,n={}){return n.includeAllVersions||(e=this.dedupExtensions(r===0?e:void 0,r===1?e:void 0,r==="development"?e:void 0,await this.getTargetPlatform(),!!n.pickLatest)),n.includeInvalid||(e=e.filter(o=>o.isValid)),e.sort((o,s)=>{let a=nt(o.location.fsPath),l=nt(s.location.fsPath);return a<l?-1:a>l?1:0})}dedupExtensions(e,r,n,o,s){let a=(c,u,p)=>{if(!p){if(c.metadata?.isApplicationScoped&&!u.metadata?.isApplicationScoped)return!1;if(!c.metadata?.isApplicationScoped&&u.metadata?.isApplicationScoped)return!0}if(c.isValid&&!u.isValid)return!1;if(c.isValid===u.isValid){if(s&&In(c.manifest.version,u.manifest.version))return this.logService.debug(`Skipping extension ${u.location.path} with lower version ${u.manifest.version} in favour of ${c.location.path} with version ${c.manifest.version}`),!1;if(Cm(c.manifest.version,u.manifest.version)){if(c.type===0)return this.logService.debug(`Skipping extension ${u.location.path} in favour of system extension ${c.location.path} with same version`),!1;if(c.targetPlatform===o)return this.logService.debug(`Skipping extension ${u.location.path} from different target platform ${u.targetPlatform}`),!1}}return p?this.logService.warn(`Overwriting user extension ${c.location.path} with ${u.location.path}.`):this.logService.debug(`Overwriting user extension ${c.location.path} with ${u.location.path}.`),!0},l=new sl;return e?.forEach(c=>{let u=l.get(c.identifier.id);(!u||a(u,c,!1))&&l.set(c.identifier.id,c)}),r?.forEach(c=>{let u=l.get(c.identifier.id);if(!u&&e&&c.type===0){this.logService.debug(`Skipping obsolete system extension ${c.location.path}.`);return}(!u||a(u,c,!1))&&l.set(c.identifier.id,c)}),n?.forEach(c=>{let u=l.get(c.identifier.id);(!u||a(u,c,!0))&&l.set(c.identifier.id,c),l.set(c.identifier.id,c)}),[...l.values()]}async scanDefaultSystemExtensions(e){this.logService.trace("Started scanning system extensions");let r=await this.createExtensionScannerInput(this.systemExtensionsLocation,!1,0,e,!0,void 0,this.getProductVersion()),o=await(r.devMode?this.extensionsScanner:this.systemExtensionsCachedScanner).scanExtensions(r);return this.logService.trace("Scanned system extensions:",o.length),o}async scanDevSystemExtensions(e,r){let n=this.environmentService.isBuilt?[]:this.productService.builtInExtensions;if(!n?.length)return[];this.logService.trace("Started scanning dev system extensions");let o=r?await this.getBuiltInExtensionControl():{},s=[],a=P.file(Wt(q(_r.asFileUri("").fsPath,"..",".build","builtInExtensions")));for(let c of n){let u=o[c.name]||"marketplace";switch(u){case"disabled":break;case"marketplace":s.push(z(a,c.name));break;default:s.push(P.file(u));break}}let l=await Promise.all(s.map(async c=>this.extensionsScanner.scanExtension(await this.createExtensionScannerInput(c,!1,0,e,!0,void 0,this.getProductVersion()))));return this.logService.trace("Scanned dev system extensions:",l.length),br(l)}async getBuiltInExtensionControl(){try{let e=await this.fileService.readFile(this.extensionsControlLocation);return JSON.parse(e.value.toString())}catch{return{}}}async createExtensionScannerInput(e,r,n,o,s,a,l){let c=await this.getTranslations(o??er),u=await this.getMtime(e),p=r&&!this.uriIdentityService.extUri.isEqual(e,this.userDataProfilesService.defaultProfile.extensionsResource)?this.userDataProfilesService.defaultProfile.extensionsResource:void 0,f=p?await this.getMtime(p):void 0;return new jn(e,u,p,f,r,a,n,s,l.version,l.date,this.productService.commit,!this.environmentService.isBuilt,o,c)}async getMtime(e){try{let r=await this.fileService.stat(e);if(typeof r.mtime=="number")return r.mtime}catch{}}getProductVersion(){return{version:this.productService.version,date:this.productService.date}}};hs=T([I(4,$e),I(5,nr),I(6,ee),I(7,V),I(8,gt),I(9,ke),I(10,me),I(11,Lr)],hs);var jn=class{constructor(t,e,r,n,o,s,a,l,c,u,p,f,g,v){this.location=t;this.mtime=e;this.applicationExtensionslocation=r;this.applicationExtensionslocationMtime=n;this.profile=o;this.profileScanOptions=s;this.type=a;this.validate=l;this.productVersion=c;this.productDate=u;this.productCommit=p;this.devMode=f;this.language=g;this.translations=v}static createNlsConfiguration(t){return{language:t.language,pseudo:t.language==="pseudo",devMode:t.devMode,translations:t.translations}}static equals(t,e){return ua(t.location,e.location)&&t.mtime===e.mtime&&ua(t.applicationExtensionslocation,e.applicationExtensionslocation)&&t.applicationExtensionslocationMtime===e.applicationExtensionslocationMtime&&t.profile===e.profile&&xt(t.profileScanOptions,e.profileScanOptions)&&t.type===e.type&&t.validate===e.validate&&t.productVersion===e.productVersion&&t.productDate===e.productDate&&t.productCommit===e.productCommit&&t.devMode===e.devMode&&t.language===e.language&&Cg.equals(t.translations,e.translations)}},Hi=class extends _{constructor(e,r,n,o,s,a){super();this.extensionsProfileScannerService=e;this.uriIdentityService=r;this.fileService=n;this.environmentService=s;this.logService=a;this.extensionsEnabledWithApiProposalVersion=o.extensionsEnabledWithApiProposalVersion?.map(l=>l.toLowerCase())??[]}async scanExtensions(e){return e.profile?this.scanExtensionsFromProfile(e):this.scanExtensionsFromLocation(e)}async scanExtensionsFromLocation(e){let r=await this.fileService.resolve(e.location);if(!r.children?.length)return[];let n=await Promise.all(r.children.map(async o=>{if(!o.isDirectory||e.type===1&&kr(o.resource).indexOf(".")===0)return null;let s=new jn(o.resource,e.mtime,e.applicationExtensionslocation,e.applicationExtensionslocationMtime,e.profile,e.profileScanOptions,e.type,e.validate,e.productVersion,e.productDate,e.productCommit,e.devMode,e.language,e.translations);return this.scanExtension(s)}));return br(n).sort((o,s)=>o.location.path<s.location.path?-1:1)}async scanExtensionsFromProfile(e){let r=await this.scanExtensionsFromProfileResource(e.location,()=>!0,e);if(e.applicationExtensionslocation&&!this.uriIdentityService.extUri.isEqual(e.location,e.applicationExtensionslocation)){r=r.filter(o=>!o.metadata?.isApplicationScoped);let n=await this.scanExtensionsFromProfileResource(e.applicationExtensionslocation,o=>!!o.metadata?.isBuiltin||!!o.metadata?.isApplicationScoped,e);r.push(...n)}return r}async scanExtensionsFromProfileResource(e,r,n){let o=await this.extensionsProfileScannerService.scanProfileExtensions(e,n.profileScanOptions);if(!o.length)return[];let s=await Promise.all(o.map(async a=>{if(r(a)){let l=new jn(a.location,n.mtime,n.applicationExtensionslocation,n.applicationExtensionslocationMtime,n.profile,n.profileScanOptions,n.type,n.validate,n.productVersion,n.productDate,n.productCommit,n.devMode,n.language,n.translations);return this.scanExtension(l,a)}return null}));return br(s)}async scanOneOrMultipleExtensions(e){try{if(await this.fileService.exists(z(e.location,"package.json"))){let r=await this.scanExtension(e);return r?[r]:[]}else return await this.scanExtensions(e)}catch(r){return this.logService.error(`Error scanning extensions at ${e.location.path}:`,G(r)),[]}}async scanExtension(e,r){let n=[],o=!0,s;try{s=await this.scanExtensionManifest(e.location)}catch(g){if(r){n.push([ze.Error,G(g)]),o=!1;let[v,h]=r.identifier.id.split(".");s={name:h,publisher:v,version:r.version,engines:{vscode:""}}}else return e.type!==0&&this.logService.error(g),null}s.publisher||(s.publisher=ll);let a;r?a={...r.metadata,size:s.__metadata?.size}:s.__metadata&&(a={installedTimestamp:s.__metadata.installedTimestamp,size:s.__metadata.size,targetPlatform:s.__metadata.targetPlatform}),delete s.__metadata;let l=Dt(s.publisher,s.name),c=a?.id?{id:l,uuid:a.id}:{id:l},u=a?.isSystem?0:e.type,p=u===0||!!a?.isBuiltin;try{s=await this.translateManifest(e.location,s,jn.createNlsConfiguration(e))}catch(g){this.logService.warn("Failed to translate manifest",G(g))}let f={type:u,identifier:c,manifest:s,location:e.location,isBuiltin:p,targetPlatform:a?.targetPlatform??"undefined",publisherDisplayName:a?.publisherDisplayName,metadata:a,isValid:o,validations:n,preRelease:!!a?.preRelease};return e.validate&&(f=this.validate(f,e)),s.enabledApiProposals&&(!this.environmentService.isBuilt||this.extensionsEnabledWithApiProposalVersion.includes(l.toLowerCase()))&&(s.originalEnabledApiProposals=s.enabledApiProposals,s.enabledApiProposals=Um([...s.enabledApiProposals])),f}validate(e,r){let n=e.isValid,o=this.environmentService.isBuilt&&this.extensionsEnabledWithApiProposalVersion.includes(e.identifier.id.toLowerCase()),s=ag(r.productVersion,r.productDate,r.location,e.manifest,e.isBuiltin,o);for(let[a,l]of s)a===ze.Error&&(n=!1,this.logService.error(this.formatMessage(r.location,l)));return e.isValid=n,e.validations=[...e.validations,...s],e}async scanExtensionManifest(e){let r=z(e,"package.json"),n;try{n=(await this.fileService.readFile(r)).value.toString()}catch(s){throw Se(s)!==1&&this.logService.error(this.formatMessage(e,m(2009,null,r.path,s.message))),s}let o;try{o=JSON.parse(n)}catch(s){let a=[];Ur(n,a);for(let l of a)this.logService.error(this.formatMessage(e,m(2011,null,r.path,l.offset,l.length,Rl(l.error))));throw s}if(xi(o)!=="object"){let s=this.formatMessage(e,m(2012,null,r.path));throw this.logService.error(s),new Error(s)}return o}async translateManifest(e,r,n){let o=await this.getLocalizedMessages(e,r,n);if(o)try{let s=[],a=await this.resolveOriginalMessageBundle(o.default,s);if(s.length>0)return s.forEach(c=>{this.logService.error(this.formatMessage(e,m(2013,null,o.default?.path,Rl(c.error))))}),r;if(xi(o)!=="object")return this.logService.error(this.formatMessage(e,m(2010,null,o.default?.path))),r;let l=o.values||Object.create(null);return Rg(this.logService,r,l,a)}catch{}return r}async getLocalizedMessages(e,r,n){let o=z(e,"package.nls.json"),s=(u,p)=>{p.forEach(f=>{this.logService.error(this.formatMessage(e,m(2013,null,u?.path,Rl(f.error))))})},a=u=>{this.logService.error(this.formatMessage(e,m(2010,null,u?.path)))},l=`${r.publisher}.${r.name}`,c=n.translations[l];if(c)try{let u=P.file(c),p=(await this.fileService.readFile(u)).value.toString(),f=[],g=Ur(p,f);return f.length>0?(s(u,f),{values:void 0,default:o}):xi(g)!=="object"?(a(u),{values:void 0,default:o}):{values:g.contents?g.contents.package:void 0,default:o}}catch{return{values:void 0,default:o}}else{if(!await this.fileService.exists(o))return;let p;try{p=await this.findMessageBundles(e,n)}catch{return}if(!p.localized)return{values:void 0,default:p.original};try{let f=(await this.fileService.readFile(p.localized)).value.toString(),g=[],v=Ur(f,g);return g.length>0?(s(p.localized,g),{values:void 0,default:p.original}):xi(v)!=="object"?(a(p.localized),{values:void 0,default:p.original}):{values:v,default:p.original}}catch{return{values:void 0,default:p.original}}}}async resolveOriginalMessageBundle(e,r){if(e)try{let n=(await this.fileService.readFile(e)).value.toString();return Ur(n,r)}catch{}}findMessageBundles(e,r){return new Promise((n,o)=>{let s=a=>{let l=z(e,`package.nls.${a}.json`);this.fileService.exists(l).then(c=>{c&&n({localized:l,original:z(e,"package.nls.json")});let u=a.lastIndexOf("-");u===-1?n({localized:z(e,"package.nls.json"),original:null}):(a=a.substring(0,u),s(a))})};if(r.devMode||r.pseudo||!r.language)return n({localized:z(e,"package.nls.json"),original:null});s(r.language)})}formatMessage(e,r){return`[${e.path}]: ${r}`}};Hi=T([I(0,nr),I(1,me),I(2,ee),I(3,ke),I(4,gt),I(5,V)],Hi);var Qi=class extends Hi{constructor(e,r,n,o,s,a,l,c){super(n,o,s,a,l,c);this.currentProfile=e;this.userDataProfilesService=r;this.cacheValidatorThrottler=this._register(new _t(3e3));this._onDidChangeCache=this._register(new R);this.onDidChangeCache=this._onDidChangeCache.event}async scanExtensions(e){let r=this.getCacheFile(e),n=await this.readExtensionCache(r);if(this.input=e,n&&n.input&&jn.equals(n.input,this.input))return this.logService.debug("Using cached extensions scan result",e.type===0?"system":"user",e.location.toString()),this.cacheValidatorThrottler.trigger(()=>this.validateCache()),n.result.map(s=>(s.location=P.revive(s.location),s));let o=await super.scanExtensions(e);return await this.writeExtensionCache(r,{input:e,result:o}),o}async readExtensionCache(e){try{let r=await this.fileService.readFile(e),n=JSON.parse(r.value.toString());return{result:n.result,input:bn(n.input)}}catch(r){Se(r)!==1&&this.logService.debug("Error while reading the extension cache file:",e.path,G(r))}return null}async writeExtensionCache(e,r){try{await this.fileService.writeFile(e,U.fromString(JSON.stringify(r)))}catch(n){this.logService.debug("Error while writing the extension cache file:",e.path,G(n))}}async validateCache(){if(!this.input)return;let e=this.getCacheFile(this.input),r=await this.readExtensionCache(e);if(!r)return;let n=r.result,o=JSON.parse(JSON.stringify(await super.scanExtensions(this.input)));if(!xt(o,n))try{this.logService.info("Invalidating Cache",n,o),await this.fileService.del(e),this._onDidChangeCache.fire()}catch(s){this.logService.error(s)}}getCacheFile(e){let r=this.getProfile(e);return this.uriIdentityService.extUri.joinPath(r.cacheHome,e.type===0?Dm:al)}getProfile(e){return e.type===0?this.userDataProfilesService.defaultProfile:e.profile?this.uriIdentityService.extUri.isEqual(e.location,this.currentProfile.extensionsResource)?this.currentProfile:this.userDataProfilesService.profiles.find(r=>this.uriIdentityService.extUri.isEqual(e.location,r.extensionsResource))??this.currentProfile:this.userDataProfilesService.defaultProfile}};Qi=T([I(1,$e),I(2,nr),I(3,me),I(4,ee),I(5,ke),I(6,gt),I(7,V)],Qi);var Cl=class extends hs{constructor(t,e,r,n,o,s,a,l,c,u,p,f){super(t,e,z(r,".vscode-oss-dev","extensions","control.json"),n,o,s,a,l,c,u,p,f),this.translationsPromise=(async()=>{if(qc)try{let g=await this.fileService.readFile(P.file(qc));return JSON.parse(g.value.toString())}catch{}return Object.create(null)})()}getTranslations(t){return this.translationsPromise}};import*as nh from"fs";import*as Y from"fs";import{tmpdir as cI}from"os";import{promisify as ys}from"util";var iI=new Sr(1e4);function vs(i){return _g(i,"NFC",iI)}var oI=new Sr(1e4);function sI(i){return _g(i,"NFD",oI)}var aI=/[^\u0000-\u0080]/;function _g(i,t,e){if(!i)return i;let r=e.get(i);if(r)return r;let n;return aI.test(i)?n=i.normalize(t):n=i,e.set(i,n),n}var lI=(function(){let i=new Sr(1e4),t=/[\u0300-\u036f]/g;return function(e){let r=i.get(e);if(r)return r;let n=sI(e).replace(t,""),o=(n.length===e.length?n:e).toLowerCase();return i.set(e,o),o}})();async function Lg(i,t=0,e){if(eu(i))throw new Error("rimraf - will refuse to recursively delete root");return t===0?fd(i):uI(i,e)}async function uI(i,t=sf(cI())){try{try{await Y.promises.rename(i,t)}catch(e){return e.code==="ENOENT"?void 0:fd(i)}fd(t).catch(()=>{})}catch(e){if(e.code!=="ENOENT")throw e}}async function fd(i){return Y.promises.rm(i,{recursive:!0,force:!0,maxRetries:3})}async function _l(i,t){try{return await kg(i,t)}catch(e){if(e.code==="ENOENT"&&pe&&eu(i))try{return await kg(`${i}.`,t)}catch{}throw e}}async function kg(i,t){return pI(await(t?dI(i):Y.promises.readdir(i)))}async function dI(i){try{return await Y.promises.readdir(i,{withFileTypes:!0})}catch(r){r.code!=="ENOENT"&&console.warn("[node.js fs] readdir with filetypes failed with error: ",r)}let t=[],e=await _l(i);for(let r of e){let n=!1,o=!1,s=!1;try{let a=await Y.promises.lstat(q(i,r));n=a.isFile(),o=a.isDirectory(),s=a.isSymbolicLink()}catch(a){a.code!=="ENOENT"&&console.warn("[node.js fs] unexpected error from lstat after readdir: ",a)}t.push({name:r,isFile:()=>n,isDirectory:()=>o,isSymbolicLink:()=>s})}return t}function pI(i){return i.map(t=>typeof t=="string"?ft?vs(t):t:(t.name=ft?vs(t.name):t.name,t))}async function fI(i){let t=await _l(i),e=[];for(let r of t)await Lt.existsDirectory(q(i,r))&&e.push(r);return e}var Lt;(r=>{async function i(n){let o;try{if(o=await Y.promises.lstat(n),!o.isSymbolicLink())return{stat:o}}catch{}try{return{stat:await Y.promises.stat(n),symbolicLink:o?.isSymbolicLink()?{dangling:!1}:void 0}}catch(s){if(s.code==="ENOENT"&&o)return{stat:o,symbolicLink:{dangling:!0}};if(pe&&s.code==="EACCES")try{return{stat:await Y.promises.stat(await Y.promises.readlink(n)),symbolicLink:{dangling:!1}}}catch(a){if(a.code==="ENOENT"&&o)return{stat:o,symbolicLink:{dangling:!0}};throw a}throw s}}r.stat=i;async function t(n){try{let{stat:o,symbolicLink:s}=await r.stat(n);return o.isFile()&&s?.dangling!==!0}catch{}return!1}r.existsFile=t;async function e(n){try{let{stat:o,symbolicLink:s}=await r.stat(n);return o.isDirectory()&&s?.dangling!==!0}catch{}return!1}r.existsDirectory=e})(Lt||={});var mI=new hi;function gI(i,t,e){return mI.queueFor(P.file(i),()=>{let r=yI(e);return new Promise((n,o)=>vI(i,t,r,s=>s?o(s):n()))},On)}var Ag=!0;function hI(i){Ag=i}function vI(i,t,e,r){if(!Ag)return Y.writeFile(i,t,{mode:e.mode,flag:e.flag},r);Y.open(i,e.flag,e.mode,(n,o)=>{if(n)return r(n);Y.writeFile(o,t,s=>{if(s)return Y.close(o,()=>r(s));Y.fdatasync(o,a=>(a&&(console.warn("[node.js fs] fdatasync is now disabled for this session because it failed: ",a),hI(!1)),Y.close(o,l=>r(l))))})})}function yI(i){return i?{mode:typeof i.mode=="number"?i.mode:438,flag:typeof i.flag=="string"?i.flag:"w"}:{mode:438,flag:"w"}}async function II(i,t,e=6e4){if(i!==t)try{pe&&typeof e=="number"?await Ug(i,t,Date.now(),e):await Y.promises.rename(i,t)}catch(r){if(i.toLowerCase()!==t.toLowerCase()&&r.code==="EXDEV"||i.endsWith("."))await Mg(i,t,{preserveSymlinks:!1}),await Lg(i,1);else throw r}}async function Ug(i,t,e,r,n=0){try{return await Y.promises.rename(i,t)}catch(o){if(o.code!=="EACCES"&&o.code!=="EPERM"&&o.code!=="EBUSY")throw o;if(Date.now()-e>=r)throw console.error(`[node.js fs] rename failed after ${n} retries with error: ${o}`),o;if(n===0){let s=!1;try{let{stat:a}=await Lt.stat(t);a.isFile()||(s=!0)}catch{}if(s)throw o}return await Hr(Math.min(100,n*10)),Ug(i,t,e,r,n+1)}}async function Mg(i,t,e){return Fg(i,t,{root:{source:i,target:t},options:e,handledSourcePaths:new Set})}var Dg=511;async function Fg(i,t,e){if(e.handledSourcePaths.has(i))return;e.handledSourcePaths.add(i);let{stat:r,symbolicLink:n}=await Lt.stat(i);if(n){if(e.options.preserveSymlinks)try{return await SI(i,t,e)}catch{}if(n.dangling)return}return r.isDirectory()?xI(i,t,r.mode&Dg,e):bI(i,t,r.mode&Dg)}async function xI(i,t,e,r){await Y.promises.mkdir(t,{recursive:!0,mode:e});let n=await _l(i);for(let o of n)await Fg(q(i,o),q(t,o),r)}async function bI(i,t,e){await Y.promises.copyFile(i,t),await Y.promises.chmod(t,e)}async function SI(i,t,e){let r=await Y.promises.readlink(i);$r(r,e.root.source,!Te)&&(r=q(e.root.target,r.substr(e.root.source.length+1))),await Y.promises.symlink(r,t)}async function EI(i){try{return await ys(Y.realpath)(i)}catch{let t=wI(i);return await Y.promises.access(t,Y.constants.R_OK),t}}function wI(i){return Ao(Wt(i),je)}var ie=new class{get read(){return(i,t,e,r,n)=>new Promise((o,s)=>{Y.read(i,t,e,r,n,(a,l,c)=>a?s(a):o({bytesRead:l,buffer:c}))})}get write(){return(i,t,e,r,n)=>new Promise((o,s)=>{Y.write(i,t,e,r,n,(a,l,c)=>a?s(a):o({bytesWritten:l,buffer:c}))})}get fdatasync(){return ys(Y.fdatasync)}get open(){return ys(Y.open)}get close(){return ys(Y.close)}get ftruncate(){return ys(Y.ftruncate)}async exists(i){try{return await Y.promises.access(i),!0}catch{return!1}}get readdir(){return _l}get readDirsInDir(){return fI}get writeFile(){return gI}get rm(){return Lg}get rename(){return II}get copy(){return Mg}get realpath(){return EI}};import{createWriteStream as Og,promises as Ng}from"fs";var gd="end of central directory record signature not found",PI=new RegExp(gd),Hn=class extends Error{constructor(t,e){let r=e.message;t==="CorruptZip"&&(r=`Corrupt ZIP: ${r}`),super(r),this.type=t,this.cause=e}};function TI(i){let t=i.externalFileAttributes>>16||33188;return[448,56,7].map(e=>t&e).reduce((e,r)=>e+r,t&61440)}function Vg(i){if(i instanceof Hn)return i;let t;return PI.test(i.message)&&(t="CorruptZip"),new Hn(t,i)}function RI(i,t,e,r,n,o){let s=Rt(t),a=q(r,s);if(!a.startsWith(r))return Promise.reject(new Error(m(151,null,t)));let l=q(r,t),c;return o.onCancellationRequested(()=>{c?.destroy()}),Promise.resolve(Ng.mkdir(a,{recursive:!0})).then(()=>new Promise((u,p)=>{if(!o.isCancellationRequested)try{c=Og(l,{mode:e}),c.once("close",()=>u()),c.once("error",p),i.once("error",p),i.pipe(c)}catch(f){p(f)}}))}function CI(i,t,e,r){let n=Ht(()=>Promise.resolve()),o=0,s=r.onCancellationRequested(()=>{n.cancel(),i.close()});return new Promise((a,l)=>{let c=new pa,u=p=>{p.isCancellationRequested||(o++,i.readEntry())};i.once("error",l),i.once("close",()=>n.then(()=>{r.isCancellationRequested||i.entryCount===o?a():l(new Hn("Incomplete",new Error(m(150,null,o,i.entryCount))))},l)),i.readEntry(),i.on("entry",p=>{if(r.isCancellationRequested)return;if(!e.sourcePathRegex.test(p.fileName)){u(r);return}let f=p.fileName.replace(e.sourcePathRegex,"");if(/\/$/.test(f)){let h=q(t,f);n=Ht(y=>Ng.mkdir(h,{recursive:!0}).then(()=>u(y)).then(void 0,l));return}let g=Bg(i,p),v=TI(p);n=Ht(h=>c.queue(()=>g.then(y=>RI(y,f,v,t,e,h).then(()=>u(h)))).then(null,l))})}).finally(()=>s.dispose())}async function Wg(i,t=!1){let{open:e}=await import("yauzl");return new Promise((r,n)=>{e(i,t?{lazyEntries:!0}:void 0,(o,s)=>{o?n(Vg(o)):r(Dc(s))})})}function Bg(i,t){return new Promise((e,r)=>{i.openReadStream(t,(n,o)=>{n?r(Vg(n)):e(Dc(o))})})}async function Gg(i,t){let{ZipFile:e}=await import("yazl");return new Promise((r,n)=>{let o=new e;t.forEach(a=>{a.contents?o.addBuffer(typeof a.contents=="string"?Buffer.from(a.contents,"utf8"):a.contents,a.path):a.localPath&&o.addFile(a.localPath,a.path)}),o.end();let s=Og(i);o.outputStream.pipe(s),o.outputStream.once("error",n),s.once("error",n),s.once("finish",()=>r(i))})}function qg(i,t,e={},r){let n=new RegExp(e.sourcePath?`^${e.sourcePath}`:""),o=Wg(i,!0);return e.overwrite&&(o=o.then(s=>ie.rm(t).then(()=>s))),o.then(s=>CI(s,t,{sourcePathRegex:n},r))}function _I(i,t){return Wg(i).then(e=>new Promise((r,n)=>{e.on("entry",o=>{o.fileName===t&&Bg(e,o).then(s=>r(s),s=>n(s))}),e.once("close",()=>n(new Error(m(152,null,t))))}))}function kl(i,t){return _I(i,t).then(e=>new Promise((r,n)=>{let o=[];e.once("error",n),e.on("data",s=>o.push(s)),e.on("end",()=>r(Buffer.concat(o)))}))}var X5=new Uint32Array(10);var Y5=new Uint8Array([114,82,115,101,69,102,97,113,81,116,84,100,119,87,99,122,120,118,103]),Z5=new Uint16Array([107,111,105,79,106,112,117,80,104,27496,28520,27752,121,110,27246,28782,27758,98,109,27757,108]),ek=new Uint16Array([114,82,29810,115,30579,26483,101,102,29286,24934,29030,29798,30822,30310,26470,97,113,29809,116,84,100,119,99,122,120,118,103]),tk=new Uint16Array([114,82,29810,115,30579,26483,101,69,102,29286,24934,29030,29798,30822,30310,26470,97,113,81,29809,116,84,100,119,87,99,122,120,118,103,107,111,105,79,106,112,117,80,104,27496,28520,27752,121,110,27246,28782,27758,98,109,27757,108]);function zg(...i){return function(t,e){for(let r=0,n=i.length;r<n;r++){let o=i[r](t,e);if(o)return o}return null}}var uk=jg.bind(void 0,!1),$g=jg.bind(void 0,!0);function jg(i,t,e){if(!e||e.length<t.length)return null;let r;return i?r=Mn(e,t):r=e.indexOf(t)===0,r?t.length>0?[{start:0,end:t.length}]:[]:null}function kI(i,t){if(i.length>t.length)return null;let e=t.toLowerCase().indexOf(i.toLowerCase());return e===-1?null:[{start:e,end:e+i.length}]}function DI(i,t){return i.length>t.length?null:hd(i.toLowerCase(),t.toLowerCase(),0,0)}function hd(i,t,e,r){if(e===i.length)return[];if(r===t.length)return null;if(i[e]===t[r]){let n=null;return(n=hd(i,t,e+1,r+1))?Qg({start:r,end:r+1},n):null}return hd(i,t,e,r+1)}function yd(i){return 97<=i&&i<=122}function Ll(i){return 65<=i&&i<=90}function Id(i){return 48<=i&&i<=57}function LI(i){return i===32||i===9||i===10||i===13}var AI=new Set;"()[]{}<>`'\"-/;:,.?!".split("").forEach(i=>AI.add(i.charCodeAt(0)));function Hg(i){return yd(i)||Ll(i)||Id(i)}function Qg(i,t){return t.length===0?t=[i]:i.end===t[0].start?t[0].start=i.start:t.unshift(i),t}function Jg(i,t){for(let e=t;e<i.length;e++){let r=i.charCodeAt(e);if(Ll(r)||Id(r)||e>0&&!Hg(i.charCodeAt(e-1)))return e}return i.length}function vd(i,t,e,r){if(e===i.length)return[];if(r===t.length)return null;if(i[e]!==t[r].toLowerCase())return null;{let n=null,o=r+1;for(n=vd(i,t,e+1,r+1);!n&&(o=Jg(t,o))<t.length;)n=vd(i,t,e+1,o),o++;return n===null?null:Qg({start:r,end:r+1},n)}}function UI(i){let t=0,e=0,r=0,n=0,o=0;for(let u=0;u<i.length;u++)o=i.charCodeAt(u),Ll(o)&&t++,yd(o)&&e++,Hg(o)&&r++,Id(o)&&n++;let s=t/i.length,a=e/i.length,l=r/i.length,c=n/i.length;return{upperPercent:s,lowerPercent:a,alphaPercent:l,numericPercent:c}}function MI(i){let{upperPercent:t,lowerPercent:e}=i;return e===0&&t>.6}function FI(i){let{upperPercent:t,lowerPercent:e,alphaPercent:r,numericPercent:n}=i;return e>.2&&t<.8&&r>.6&&n<.2}function OI(i){let t=0,e=0,r=0,n=0;for(let o=0;o<i.length;o++)r=i.charCodeAt(o),Ll(r)&&t++,yd(r)&&e++,LI(r)&&n++;return(t===0||e===0)&&n===0?i.length<=30:t<=5}function Xg(i,t){if(!t||(t=t.trim(),t.length===0)||!OI(i))return null;t.length>60&&(t=t.substring(0,60));let e=UI(t);if(!FI(e)){if(!MI(e))return null;t=t.toLowerCase()}let r=null,n=0;for(i=i.toLowerCase();n<t.length&&(r=vd(i,t,0,n))===null;)n=Jg(t,n+1);return r}var dk=zg($g,Xg,kI),pk=zg($g,Xg,DI),fk=new Sr(1e4);var Dl=128;function xd(){let i=[],t=[];for(let e=0;e<=Dl;e++)t[e]=0;for(let e=0;e<=Dl;e++)i.push(t.slice(0));return i}function Yg(i){let t=[];for(let e=0;e<=i;e++)t[e]=0;return t}var mk=Yg(2*Dl),gk=Yg(2*Dl),hk=xd(),vk=xd(),yk=xd();var NI;(e=>{e.Default=[-100,0];function t(r){return!r||r.length===2&&r[0]===-100&&r[1]===0}e.isDefault=t})(NI||={});var Kg=class{constructor(t,e){this.firstMatchCanBeWeak=t;this.boostFullMatch=e}static{this.default={boostFullMatch:!0,firstMatchCanBeWeak:!1}}};var Zg=Object.create(null);function d(i,t){if(te(t)){let e=Zg[t];if(e===void 0)throw new Error(`${i} references an unknown codicon: ${t}`);t=e}return Zg[i]=t,{id:i}}var eh={add:d("add",6e4),plus:d("plus",6e4),gistNew:d("gist-new",6e4),repoCreate:d("repo-create",6e4),lightbulb:d("lightbulb",60001),lightBulb:d("light-bulb",60001),repo:d("repo",60002),repoDelete:d("repo-delete",60002),gistFork:d("gist-fork",60003),repoForked:d("repo-forked",60003),gitPullRequest:d("git-pull-request",60004),gitPullRequestAbandoned:d("git-pull-request-abandoned",60004),recordKeys:d("record-keys",60005),keyboard:d("keyboard",60005),tag:d("tag",60006),gitPullRequestLabel:d("git-pull-request-label",60006),tagAdd:d("tag-add",60006),tagRemove:d("tag-remove",60006),person:d("person",60007),personFollow:d("person-follow",60007),personOutline:d("person-outline",60007),personFilled:d("person-filled",60007),sourceControl:d("source-control",60008),mirror:d("mirror",60009),mirrorPublic:d("mirror-public",60009),star:d("star",60010),starAdd:d("star-add",60010),starDelete:d("star-delete",60010),starEmpty:d("star-empty",60010),comment:d("comment",60011),commentAdd:d("comment-add",60011),alert:d("alert",60012),warning:d("warning",60012),search:d("search",60013),searchSave:d("search-save",60013),logOut:d("log-out",60014),signOut:d("sign-out",60014),logIn:d("log-in",60015),signIn:d("sign-in",60015),eye:d("eye",60016),eyeUnwatch:d("eye-unwatch",60016),eyeWatch:d("eye-watch",60016),circleFilled:d("circle-filled",60017),primitiveDot:d("primitive-dot",60017),closeDirty:d("close-dirty",60017),debugBreakpoint:d("debug-breakpoint",60017),debugBreakpointDisabled:d("debug-breakpoint-disabled",60017),debugHint:d("debug-hint",60017),terminalDecorationSuccess:d("terminal-decoration-success",60017),primitiveSquare:d("primitive-square",60018),edit:d("edit",60019),pencil:d("pencil",60019),info:d("info",60020),issueOpened:d("issue-opened",60020),gistPrivate:d("gist-private",60021),gitForkPrivate:d("git-fork-private",60021),lock:d("lock",60021),mirrorPrivate:d("mirror-private",60021),close:d("close",60022),removeClose:d("remove-close",60022),x:d("x",60022),repoSync:d("repo-sync",60023),sync:d("sync",60023),clone:d("clone",60024),desktopDownload:d("desktop-download",60024),beaker:d("beaker",60025),microscope:d("microscope",60025),vm:d("vm",60026),deviceDesktop:d("device-desktop",60026),file:d("file",60027),more:d("more",60028),ellipsis:d("ellipsis",60028),kebabHorizontal:d("kebab-horizontal",60028),mailReply:d("mail-reply",60029),reply:d("reply",60029),organization:d("organization",60030),organizationFilled:d("organization-filled",60030),organizationOutline:d("organization-outline",60030),newFile:d("new-file",60031),fileAdd:d("file-add",60031),newFolder:d("new-folder",60032),fileDirectoryCreate:d("file-directory-create",60032),trash:d("trash",60033),trashcan:d("trashcan",60033),history:d("history",60034),clock:d("clock",60034),folder:d("folder",60035),fileDirectory:d("file-directory",60035),symbolFolder:d("symbol-folder",60035),logoGithub:d("logo-github",60036),markGithub:d("mark-github",60036),github:d("github",60036),terminal:d("terminal",60037),console:d("console",60037),repl:d("repl",60037),zap:d("zap",60038),symbolEvent:d("symbol-event",60038),error:d("error",60039),stop:d("stop",60039),variable:d("variable",60040),symbolVariable:d("symbol-variable",60040),array:d("array",60042),symbolArray:d("symbol-array",60042),symbolModule:d("symbol-module",60043),symbolPackage:d("symbol-package",60043),symbolNamespace:d("symbol-namespace",60043),symbolObject:d("symbol-object",60043),symbolMethod:d("symbol-method",60044),symbolFunction:d("symbol-function",60044),symbolConstructor:d("symbol-constructor",60044),symbolBoolean:d("symbol-boolean",60047),symbolNull:d("symbol-null",60047),symbolNumeric:d("symbol-numeric",60048),symbolNumber:d("symbol-number",60048),symbolStructure:d("symbol-structure",60049),symbolStruct:d("symbol-struct",60049),symbolParameter:d("symbol-parameter",60050),symbolTypeParameter:d("symbol-type-parameter",60050),symbolKey:d("symbol-key",60051),symbolText:d("symbol-text",60051),symbolReference:d("symbol-reference",60052),goToFile:d("go-to-file",60052),symbolEnum:d("symbol-enum",60053),symbolValue:d("symbol-value",60053),symbolRuler:d("symbol-ruler",60054),symbolUnit:d("symbol-unit",60054),activateBreakpoints:d("activate-breakpoints",60055),archive:d("archive",60056),arrowBoth:d("arrow-both",60057),arrowDown:d("arrow-down",60058),arrowLeft:d("arrow-left",60059),arrowRight:d("arrow-right",60060),arrowSmallDown:d("arrow-small-down",60061),arrowSmallLeft:d("arrow-small-left",60062),arrowSmallRight:d("arrow-small-right",60063),arrowSmallUp:d("arrow-small-up",60064),arrowUp:d("arrow-up",60065),bell:d("bell",60066),bold:d("bold",60067),book:d("book",60068),bookmark:d("bookmark",60069),debugBreakpointConditionalUnverified:d("debug-breakpoint-conditional-unverified",60070),debugBreakpointConditional:d("debug-breakpoint-conditional",60071),debugBreakpointConditionalDisabled:d("debug-breakpoint-conditional-disabled",60071),debugBreakpointDataUnverified:d("debug-breakpoint-data-unverified",60072),debugBreakpointData:d("debug-breakpoint-data",60073),debugBreakpointDataDisabled:d("debug-breakpoint-data-disabled",60073),debugBreakpointLogUnverified:d("debug-breakpoint-log-unverified",60074),debugBreakpointLog:d("debug-breakpoint-log",60075),debugBreakpointLogDisabled:d("debug-breakpoint-log-disabled",60075),briefcase:d("briefcase",60076),broadcast:d("broadcast",60077),browser:d("browser",60078),bug:d("bug",60079),calendar:d("calendar",60080),caseSensitive:d("case-sensitive",60081),check:d("check",60082),checklist:d("checklist",60083),chevronDown:d("chevron-down",60084),chevronLeft:d("chevron-left",60085),chevronRight:d("chevron-right",60086),chevronUp:d("chevron-up",60087),chromeClose:d("chrome-close",60088),chromeMaximize:d("chrome-maximize",60089),chromeMinimize:d("chrome-minimize",60090),chromeRestore:d("chrome-restore",60091),circleOutline:d("circle-outline",60092),circle:d("circle",60092),debugBreakpointUnverified:d("debug-breakpoint-unverified",60092),terminalDecorationIncomplete:d("terminal-decoration-incomplete",60092),circleSlash:d("circle-slash",60093),circuitBoard:d("circuit-board",60094),clearAll:d("clear-all",60095),clippy:d("clippy",60096),closeAll:d("close-all",60097),cloudDownload:d("cloud-download",60098),cloudUpload:d("cloud-upload",60099),code:d("code",60100),collapseAll:d("collapse-all",60101),colorMode:d("color-mode",60102),commentDiscussion:d("comment-discussion",60103),creditCard:d("credit-card",60105),dash:d("dash",60108),dashboard:d("dashboard",60109),database:d("database",60110),debugContinue:d("debug-continue",60111),debugDisconnect:d("debug-disconnect",60112),debugPause:d("debug-pause",60113),debugRestart:d("debug-restart",60114),debugStart:d("debug-start",60115),debugStepInto:d("debug-step-into",60116),debugStepOut:d("debug-step-out",60117),debugStepOver:d("debug-step-over",60118),debugStop:d("debug-stop",60119),debug:d("debug",60120),deviceCameraVideo:d("device-camera-video",60121),deviceCamera:d("device-camera",60122),deviceMobile:d("device-mobile",60123),diffAdded:d("diff-added",60124),diffIgnored:d("diff-ignored",60125),diffModified:d("diff-modified",60126),diffRemoved:d("diff-removed",60127),diffRenamed:d("diff-renamed",60128),diff:d("diff",60129),diffSidebyside:d("diff-sidebyside",60129),discard:d("discard",60130),editorLayout:d("editor-layout",60131),emptyWindow:d("empty-window",60132),exclude:d("exclude",60133),extensions:d("extensions",60134),eyeClosed:d("eye-closed",60135),fileBinary:d("file-binary",60136),fileCode:d("file-code",60137),fileMedia:d("file-media",60138),filePdf:d("file-pdf",60139),fileSubmodule:d("file-submodule",60140),fileSymlinkDirectory:d("file-symlink-directory",60141),fileSymlinkFile:d("file-symlink-file",60142),fileZip:d("file-zip",60143),files:d("files",60144),filter:d("filter",60145),flame:d("flame",60146),foldDown:d("fold-down",60147),foldUp:d("fold-up",60148),fold:d("fold",60149),folderActive:d("folder-active",60150),folderOpened:d("folder-opened",60151),gear:d("gear",60152),gift:d("gift",60153),gistSecret:d("gist-secret",60154),gist:d("gist",60155),gitCommit:d("git-commit",60156),gitCompare:d("git-compare",60157),compareChanges:d("compare-changes",60157),gitMerge:d("git-merge",60158),githubAction:d("github-action",60159),githubAlt:d("github-alt",60160),globe:d("globe",60161),grabber:d("grabber",60162),graph:d("graph",60163),gripper:d("gripper",60164),heart:d("heart",60165),home:d("home",60166),horizontalRule:d("horizontal-rule",60167),hubot:d("hubot",60168),inbox:d("inbox",60169),issueReopened:d("issue-reopened",60171),issues:d("issues",60172),italic:d("italic",60173),jersey:d("jersey",60174),json:d("json",60175),bracket:d("bracket",60175),kebabVertical:d("kebab-vertical",60176),key:d("key",60177),law:d("law",60178),lightbulbAutofix:d("lightbulb-autofix",60179),linkExternal:d("link-external",60180),link:d("link",60181),listOrdered:d("list-ordered",60182),listUnordered:d("list-unordered",60183),liveShare:d("live-share",60184),loading:d("loading",60185),location:d("location",60186),mailRead:d("mail-read",60187),mail:d("mail",60188),markdown:d("markdown",60189),megaphone:d("megaphone",60190),mention:d("mention",60191),milestone:d("milestone",60192),gitPullRequestMilestone:d("git-pull-request-milestone",60192),mortarBoard:d("mortar-board",60193),move:d("move",60194),multipleWindows:d("multiple-windows",60195),mute:d("mute",60196),noNewline:d("no-newline",60197),note:d("note",60198),octoface:d("octoface",60199),openPreview:d("open-preview",60200),package:d("package",60201),paintcan:d("paintcan",60202),pin:d("pin",60203),play:d("play",60204),run:d("run",60204),plug:d("plug",60205),preserveCase:d("preserve-case",60206),preview:d("preview",60207),project:d("project",60208),pulse:d("pulse",60209),question:d("question",60210),quote:d("quote",60211),radioTower:d("radio-tower",60212),reactions:d("reactions",60213),references:d("references",60214),refresh:d("refresh",60215),regex:d("regex",60216),remoteExplorer:d("remote-explorer",60217),remote:d("remote",60218),remove:d("remove",60219),replaceAll:d("replace-all",60220),replace:d("replace",60221),repoClone:d("repo-clone",60222),repoForcePush:d("repo-force-push",60223),repoPull:d("repo-pull",60224),repoPush:d("repo-push",60225),report:d("report",60226),requestChanges:d("request-changes",60227),rocket:d("rocket",60228),rootFolderOpened:d("root-folder-opened",60229),rootFolder:d("root-folder",60230),rss:d("rss",60231),ruby:d("ruby",60232),saveAll:d("save-all",60233),saveAs:d("save-as",60234),save:d("save",60235),screenFull:d("screen-full",60236),screenNormal:d("screen-normal",60237),searchStop:d("search-stop",60238),server:d("server",60240),settingsGear:d("settings-gear",60241),settings:d("settings",60242),shield:d("shield",60243),smiley:d("smiley",60244),sortPrecedence:d("sort-precedence",60245),splitHorizontal:d("split-horizontal",60246),splitVertical:d("split-vertical",60247),squirrel:d("squirrel",60248),starFull:d("star-full",60249),starHalf:d("star-half",60250),symbolClass:d("symbol-class",60251),symbolColor:d("symbol-color",60252),symbolConstant:d("symbol-constant",60253),symbolEnumMember:d("symbol-enum-member",60254),symbolField:d("symbol-field",60255),symbolFile:d("symbol-file",60256),symbolInterface:d("symbol-interface",60257),symbolKeyword:d("symbol-keyword",60258),symbolMisc:d("symbol-misc",60259),symbolOperator:d("symbol-operator",60260),symbolProperty:d("symbol-property",60261),wrench:d("wrench",60261),wrenchSubaction:d("wrench-subaction",60261),symbolSnippet:d("symbol-snippet",60262),tasklist:d("tasklist",60263),telescope:d("telescope",60264),textSize:d("text-size",60265),threeBars:d("three-bars",60266),thumbsdown:d("thumbsdown",60267),thumbsup:d("thumbsup",60268),tools:d("tools",60269),triangleDown:d("triangle-down",60270),triangleLeft:d("triangle-left",60271),triangleRight:d("triangle-right",60272),triangleUp:d("triangle-up",60273),twitter:d("twitter",60274),unfold:d("unfold",60275),unlock:d("unlock",60276),unmute:d("unmute",60277),unverified:d("unverified",60278),verified:d("verified",60279),versions:d("versions",60280),vmActive:d("vm-active",60281),vmOutline:d("vm-outline",60282),vmRunning:d("vm-running",60283),watch:d("watch",60284),whitespace:d("whitespace",60285),wholeWord:d("whole-word",60286),window:d("window",60287),wordWrap:d("word-wrap",60288),zoomIn:d("zoom-in",60289),zoomOut:d("zoom-out",60290),listFilter:d("list-filter",60291),listFlat:d("list-flat",60292),listSelection:d("list-selection",60293),selection:d("selection",60293),listTree:d("list-tree",60294),debugBreakpointFunctionUnverified:d("debug-breakpoint-function-unverified",60295),debugBreakpointFunction:d("debug-breakpoint-function",60296),debugBreakpointFunctionDisabled:d("debug-breakpoint-function-disabled",60296),debugStackframeActive:d("debug-stackframe-active",60297),circleSmallFilled:d("circle-small-filled",60298),debugStackframeDot:d("debug-stackframe-dot",60298),terminalDecorationMark:d("terminal-decoration-mark",60298),debugStackframe:d("debug-stackframe",60299),debugStackframeFocused:d("debug-stackframe-focused",60299),debugBreakpointUnsupported:d("debug-breakpoint-unsupported",60300),symbolString:d("symbol-string",60301),debugReverseContinue:d("debug-reverse-continue",60302),debugStepBack:d("debug-step-back",60303),debugRestartFrame:d("debug-restart-frame",60304),debugAlt:d("debug-alt",60305),callIncoming:d("call-incoming",60306),callOutgoing:d("call-outgoing",60307),menu:d("menu",60308),expandAll:d("expand-all",60309),feedback:d("feedback",60310),gitPullRequestReviewer:d("git-pull-request-reviewer",60310),groupByRefType:d("group-by-ref-type",60311),ungroupByRefType:d("ungroup-by-ref-type",60312),account:d("account",60313),gitPullRequestAssignee:d("git-pull-request-assignee",60313),bellDot:d("bell-dot",60314),debugConsole:d("debug-console",60315),library:d("library",60316),output:d("output",60317),runAll:d("run-all",60318),syncIgnored:d("sync-ignored",60319),pinned:d("pinned",60320),githubInverted:d("github-inverted",60321),serverProcess:d("server-process",60322),serverEnvironment:d("server-environment",60323),pass:d("pass",60324),issueClosed:d("issue-closed",60324),stopCircle:d("stop-circle",60325),playCircle:d("play-circle",60326),record:d("record",60327),debugAltSmall:d("debug-alt-small",60328),vmConnect:d("vm-connect",60329),cloud:d("cloud",60330),merge:d("merge",60331),export:d("export",60332),graphLeft:d("graph-left",60333),magnet:d("magnet",60334),notebook:d("notebook",60335),redo:d("redo",60336),checkAll:d("check-all",60337),pinnedDirty:d("pinned-dirty",60338),passFilled:d("pass-filled",60339),circleLargeFilled:d("circle-large-filled",60340),circleLarge:d("circle-large",60341),circleLargeOutline:d("circle-large-outline",60341),combine:d("combine",60342),gather:d("gather",60342),table:d("table",60343),variableGroup:d("variable-group",60344),typeHierarchy:d("type-hierarchy",60345),typeHierarchySub:d("type-hierarchy-sub",60346),typeHierarchySuper:d("type-hierarchy-super",60347),gitPullRequestCreate:d("git-pull-request-create",60348),runAbove:d("run-above",60349),runBelow:d("run-below",60350),notebookTemplate:d("notebook-template",60351),debugRerun:d("debug-rerun",60352),workspaceTrusted:d("workspace-trusted",60353),workspaceUntrusted:d("workspace-untrusted",60354),workspaceUnknown:d("workspace-unknown",60355),terminalCmd:d("terminal-cmd",60356),terminalDebian:d("terminal-debian",60357),terminalLinux:d("terminal-linux",60358),terminalPowershell:d("terminal-powershell",60359),terminalTmux:d("terminal-tmux",60360),terminalUbuntu:d("terminal-ubuntu",60361),terminalBash:d("terminal-bash",60362),arrowSwap:d("arrow-swap",60363),copy:d("copy",60364),personAdd:d("person-add",60365),filterFilled:d("filter-filled",60366),wand:d("wand",60367),debugLineByLine:d("debug-line-by-line",60368),inspect:d("inspect",60369),layers:d("layers",60370),layersDot:d("layers-dot",60371),layersActive:d("layers-active",60372),compass:d("compass",60373),compassDot:d("compass-dot",60374),compassActive:d("compass-active",60375),azure:d("azure",60376),issueDraft:d("issue-draft",60377),gitPullRequestClosed:d("git-pull-request-closed",60378),gitPullRequestDraft:d("git-pull-request-draft",60379),debugAll:d("debug-all",60380),debugCoverage:d("debug-coverage",60381),runErrors:d("run-errors",60382),folderLibrary:d("folder-library",60383),debugContinueSmall:d("debug-continue-small",60384),beakerStop:d("beaker-stop",60385),graphLine:d("graph-line",60386),graphScatter:d("graph-scatter",60387),pieChart:d("pie-chart",60388),bracketDot:d("bracket-dot",60389),bracketError:d("bracket-error",60390),lockSmall:d("lock-small",60391),azureDevops:d("azure-devops",60392),verifiedFilled:d("verified-filled",60393),newline:d("newline",60394),layout:d("layout",60395),layoutActivitybarLeft:d("layout-activitybar-left",60396),layoutActivitybarRight:d("layout-activitybar-right",60397),layoutPanelLeft:d("layout-panel-left",60398),layoutPanelCenter:d("layout-panel-center",60399),layoutPanelJustify:d("layout-panel-justify",60400),layoutPanelRight:d("layout-panel-right",60401),layoutPanel:d("layout-panel",60402),layoutSidebarLeft:d("layout-sidebar-left",60403),layoutSidebarRight:d("layout-sidebar-right",60404),layoutStatusbar:d("layout-statusbar",60405),layoutMenubar:d("layout-menubar",60406),layoutCentered:d("layout-centered",60407),target:d("target",60408),indent:d("indent",60409),recordSmall:d("record-small",60410),errorSmall:d("error-small",60411),terminalDecorationError:d("terminal-decoration-error",60411),arrowCircleDown:d("arrow-circle-down",60412),arrowCircleLeft:d("arrow-circle-left",60413),arrowCircleRight:d("arrow-circle-right",60414),arrowCircleUp:d("arrow-circle-up",60415),layoutSidebarRightOff:d("layout-sidebar-right-off",60416),layoutPanelOff:d("layout-panel-off",60417),layoutSidebarLeftOff:d("layout-sidebar-left-off",60418),blank:d("blank",60419),heartFilled:d("heart-filled",60420),map:d("map",60421),mapHorizontal:d("map-horizontal",60421),foldHorizontal:d("fold-horizontal",60421),mapFilled:d("map-filled",60422),mapHorizontalFilled:d("map-horizontal-filled",60422),foldHorizontalFilled:d("fold-horizontal-filled",60422),circleSmall:d("circle-small",60423),bellSlash:d("bell-slash",60424),bellSlashDot:d("bell-slash-dot",60425),commentUnresolved:d("comment-unresolved",60426),gitPullRequestGoToChanges:d("git-pull-request-go-to-changes",60427),gitPullRequestNewChanges:d("git-pull-request-new-changes",60428),searchFuzzy:d("search-fuzzy",60429),commentDraft:d("comment-draft",60430),send:d("send",60431),sparkle:d("sparkle",60432),insert:d("insert",60433),mic:d("mic",60434),thumbsdownFilled:d("thumbsdown-filled",60435),thumbsupFilled:d("thumbsup-filled",60436),coffee:d("coffee",60437),snake:d("snake",60438),game:d("game",60439),vr:d("vr",60440),chip:d("chip",60441),piano:d("piano",60442),music:d("music",60443),micFilled:d("mic-filled",60444),repoFetch:d("repo-fetch",60445),copilot:d("copilot",60446),lightbulbSparkle:d("lightbulb-sparkle",60447),robot:d("robot",60448),sparkleFilled:d("sparkle-filled",60449),diffSingle:d("diff-single",60450),diffMultiple:d("diff-multiple",60451),surroundWith:d("surround-with",60452),share:d("share",60453),gitStash:d("git-stash",60454),gitStashApply:d("git-stash-apply",60455),gitStashPop:d("git-stash-pop",60456),vscode:d("vscode",60457),vscodeInsiders:d("vscode-insiders",60458),codeOss:d("code-oss",60459),runCoverage:d("run-coverage",60460),runAllCoverage:d("run-all-coverage",60461),coverage:d("coverage",60462),githubProject:d("github-project",60463),mapVertical:d("map-vertical",60464),foldVertical:d("fold-vertical",60464),mapVerticalFilled:d("map-vertical-filled",60465),foldVerticalFilled:d("fold-vertical-filled",60465),goToSearch:d("go-to-search",60466),percentage:d("percentage",60467),sortPercentage:d("sort-percentage",60467),attach:d("attach",60468),goToEditingSession:d("go-to-editing-session",60469),editSession:d("edit-session",60470),codeReview:d("code-review",60471),copilotWarning:d("copilot-warning",60472),python:d("python",60473),copilotLarge:d("copilot-large",60474),copilotWarningLarge:d("copilot-warning-large",60475),keyboardTab:d("keyboard-tab",60476),copilotBlocked:d("copilot-blocked",60477),copilotNotConnected:d("copilot-not-connected",60478),flag:d("flag",60479),lightbulbEmpty:d("lightbulb-empty",60480),symbolMethodArrow:d("symbol-method-arrow",60481),copilotUnavailable:d("copilot-unavailable",60482),repoPinned:d("repo-pinned",60483),keyboardTabAbove:d("keyboard-tab-above",60484),keyboardTabBelow:d("keyboard-tab-below",60485),gitPullRequestDone:d("git-pull-request-done",60486),mcp:d("mcp",60487),extensionsLarge:d("extensions-large",60488),layoutPanelDock:d("layout-panel-dock",60489),layoutSidebarLeftDock:d("layout-sidebar-left-dock",60490),layoutSidebarRightDock:d("layout-sidebar-right-dock",60491),copilotInProgress:d("copilot-in-progress",60492),copilotError:d("copilot-error",60493),copilotSuccess:d("copilot-success",60494),chatSparkle:d("chat-sparkle",60495),searchSparkle:d("search-sparkle",60496),editSparkle:d("edit-sparkle",60497),copilotSnooze:d("copilot-snooze",60498),sendToRemoteAgent:d("send-to-remote-agent",60499),commentDiscussionSparkle:d("comment-discussion-sparkle",60500),chatSparkleWarning:d("chat-sparkle-warning",60501),chatSparkleError:d("chat-sparkle-error",60502),collection:d("collection",60503),newCollection:d("new-collection",60504),thinking:d("thinking",60505),build:d("build",60506),commentDiscussionQuote:d("comment-discussion-quote",60507),cursor:d("cursor",60508),eraser:d("eraser",60509),fileText:d("file-text",60510),quotes:d("quotes",60512),rename:d("rename",60513),runWithDeps:d("run-with-deps",60514),debugConnected:d("debug-connected",60515),strikethrough:d("strikethrough",60516),openInProduct:d("open-in-product",60517),indexZero:d("index-zero",60518),agent:d("agent",60519),editCode:d("edit-code",60520),repoSelected:d("repo-selected",60521),skip:d("skip",60522),mergeInto:d("merge-into",60523),gitBranchChanges:d("git-branch-changes",60524),gitBranchStagedChanges:d("git-branch-staged-changes",60525),gitBranchConflicts:d("git-branch-conflicts",60526),gitBranch:d("git-branch",60527),gitBranchCreate:d("git-branch-create",60527),gitBranchDelete:d("git-branch-delete",60527),searchLarge:d("search-large",60528),terminalGitBash:d("terminal-git-bash",60529),windowActive:d("window-active",60530),forward:d("forward",60531),download:d("download",60532),clockface:d("clockface",60533),unarchive:d("unarchive",60534),sessionInProgress:d("session-in-progress",60535),collectionSmall:d("collection-small",60536),vmSmall:d("vm-small",60537),cloudSmall:d("cloud-small",60538),addSmall:d("add-small",60539),removeSmall:d("remove-small",60540),worktreeSmall:d("worktree-small",60541),worktree:d("worktree",60542),screenCut:d("screen-cut",60543),ask:d("ask",60544),openai:d("openai",60545),claude:d("claude",60546),openInWindow:d("open-in-window",60547)};var VI={dialogError:d("dialog-error","error"),dialogWarning:d("dialog-warning","warning"),dialogInfo:d("dialog-info","info"),dialogClose:d("dialog-close","close"),treeItemExpanded:d("tree-item-expanded","chevron-down"),treeFilterOnTypeOn:d("tree-filter-on-type-on","list-filter"),treeFilterOnTypeOff:d("tree-filter-on-type-off","list-selection"),treeFilterClear:d("tree-filter-clear","close"),treeItemLoading:d("tree-item-loading","loading"),menuSelection:d("menu-selection","check"),menuSubmenu:d("menu-submenu","chevron-right"),menuBarMore:d("menubar-more","more"),scrollbarButtonLeft:d("scrollbar-button-left","triangle-left"),scrollbarButtonRight:d("scrollbar-button-right","triangle-right"),scrollbarButtonUp:d("scrollbar-button-up","triangle-up"),scrollbarButtonDown:d("scrollbar-button-down","triangle-down"),toolBarMore:d("toolbar-more","more"),quickInputBack:d("quick-input-back","arrow-left"),dropDownButton:d("drop-down-button",60084),symbolCustomColor:d("symbol-customcolor",60252),exportIcon:d("export",60332),workspaceUnspecified:d("workspace-unspecified",60355),newLine:d("newline",60394),thumbsDownFilled:d("thumbsdown-filled",60435),thumbsUpFilled:d("thumbsup-filled",60436),gitFetch:d("git-fetch",60445),lightbulbSparkleAutofix:d("lightbulb-sparkle-autofix",60447),debugBreakpointPending:d("debug-breakpoint-pending",60377)},Al={...eh,...VI};var th;(t=>{function i(e){return!!e&&typeof e=="object"&&typeof e.id=="string"}t.isThemeColor=i})(th||={});var Is;(E=>{E.iconNameSegment="[A-Za-z0-9]+",E.iconNameExpression="[A-Za-z0-9-]+",E.iconModifierExpression="~[A-Za-z]+",E.iconNameCharacter="[A-Za-z0-9~-]";let n=new RegExp(`^(${E.iconNameExpression})(${E.iconModifierExpression})?$`);function o(b){let C=n.exec(b.id);if(!C)return o(Al.error);let[,N,oe]=C,Fe=["codicon","codicon-"+N];return oe&&Fe.push("codicon-modifier-"+oe.substring(1)),Fe}E.asClassNameArray=o;function s(b){return o(b).join(" ")}E.asClassName=s;function a(b){return"."+o(b).join(".")}E.asCSSSelector=a;function l(b){return!!b&&typeof b=="object"&&typeof b.id=="string"&&(typeof b.color>"u"||th.isThemeColor(b.color))}E.isThemeIcon=l;let c=new RegExp(`^\\$\\((${E.iconNameExpression}(?:${E.iconModifierExpression})?)\\)$`);function u(b){let C=c.exec(b);if(!C)return;let[,N]=C;return{id:N}}E.fromString=u;function p(b){return{id:b}}E.fromId=p;function f(b,C){let N=b.id,oe=N.lastIndexOf("~");return oe!==-1&&(N=N.substring(0,oe)),C&&(N=`${N}~${C}`),{id:N}}E.modify=f;function g(b){let C=b.id.lastIndexOf("~");if(C!==-1)return b.id.substring(C+1)}E.getModifier=g;function v(b,C){return b.id===C.id&&b.color?.id===C.color?.id}E.isEqual=v;function h(b){return b?.id===Al.file.id}E.isFile=h;function y(b){return b?.id===Al.folder.id}E.isFolder=y})(Is||={});var bd=new RegExp(`\\$\\(${Is.iconNameExpression}(?:${Is.iconModifierExpression})?\\)`,"g"),WI=new RegExp(`(\\\\)?${bd.source}`,"g");function rh(i){return i.replace(WI,(t,e)=>e?t:`\\${t}`)}var Uk=new RegExp(`\\\\${bd.source}`,"g");var Mk=new RegExp(`(\\s)?(\\\\)?${bd.source}(\\s)?`,"g");var Fk=new RegExp(`\\$\\(${Is.iconNameCharacter}+\\)`,"g");var ht=class i{static lift(t){let e=new i(t.value,t);return e.uris=t.uris,e.baseUri=t.baseUri?P.revive(t.baseUri):void 0,e}constructor(t="",e=!1){if(this.value=t,typeof this.value!="string")throw Ec("value");typeof e=="boolean"?(this.isTrusted=e,this.supportThemeIcons=!1,this.supportHtml=!1,this.supportAlertSyntax=!1):(this.isTrusted=e.isTrusted??void 0,this.supportThemeIcons=e.supportThemeIcons??!1,this.supportHtml=e.supportHtml??!1,this.supportAlertSyntax=e.supportAlertSyntax??!1)}appendText(t,e=0){return this.value+=BI(this.supportThemeIcons?rh(t):t).replace(/([ \t]+)/g,(r,n)=>"&nbsp;".repeat(n.length)).replace(/\>/gm,"\\>").replace(/\n/g,e===1?`\\
`:`

`),this}appendMarkdown(t){return this.value+=t,this}appendCodeblock(t,e){return this.value+=`
${GI(e,t)}
`,this}appendLink(t,e,r){return this.value+="[",this.value+=this._escape(e,"]"),this.value+="](",this.value+=this._escape(String(t),")"),r&&(this.value+=` "${this._escape(this._escape(r,'"'),")")}"`),this.value+=")",this}_escape(t,e){let r=new RegExp(Cr(e),"g");return t.replace(r,(n,o)=>t.charAt(o-1)!=="\\"?`\\${n}`:n)}};function BI(i){return i.replace(/[\\`*_{}[\]()#+\-!~]/g,"\\$&")}function GI(i,t){let e=i.match(/^`+/gm)?.reduce((n,o)=>n.length>o.length?n:o).length??0,r=e>=3?e+1:3;return[`${"`".repeat(r)}${t}`,i,`${"`".repeat(r)}`].join(`
`)}function Ul(i,...t){return P.from({scheme:$.command,path:i,query:t.length?encodeURIComponent(JSON.stringify(t)):void 0})}var xs=class extends _{constructor(e,r){super();this.productService=e;this.allowedExtensionsService=r;this.preferPreReleases=this.productService.quality!=="stable"}async canInstall(e){let r=this.allowedExtensionsService.isAllowed({id:e.identifier.id,publisherDisplayName:e.publisherDisplayName});if(r!==!0)return new ht(m(1945,null,r.value));if(!await this.isExtensionPlatformCompatible(e)){let n=Je?"https://aka.ms/vscode-web-extensions-guide":"https://aka.ms/vscode-platform-specific-extensions";return new ht(`${m(1938,null,e.displayName??e.identifier.id,this.productService.nameLong,Xu(await this.getTargetPlatform()))} [${m(1940,null)}](${n})`)}return!0}async isExtensionPlatformCompatible(e){let r=await this.getTargetPlatform();return e.allTargetPlatforms.some(n=>as(n,e.allTargetPlatforms,r))}};xs=T([I(0,ke),I(1,fr)],xs);var Xi=class extends xs{constructor(e,r,n,o,s,a,l){super(s,a);this.galleryService=e;this.telemetryService=r;this.uriIdentityService=n;this.logService=o;this.userDataProfilesService=l;this.lastReportTimestamp=0;this.installingExtensions=new Map;this.uninstallingExtensions=new Map;this._onInstallExtension=this._register(new R);this._onDidInstallExtensions=this._register(new R);this._onUninstallExtension=this._register(new R);this._onDidUninstallExtension=this._register(new R);this._onDidUpdateExtensionMetadata=this._register(new R);this.participants=[];this._register(ue(()=>{this.installingExtensions.forEach(({task:c})=>c.cancel()),this.uninstallingExtensions.forEach(c=>c.cancel()),this.installingExtensions.clear(),this.uninstallingExtensions.clear()}))}get onInstallExtension(){return this._onInstallExtension.event}get onDidInstallExtensions(){return this._onDidInstallExtensions.event}get onUninstallExtension(){return this._onUninstallExtension.event}get onDidUninstallExtension(){return this._onDidUninstallExtension.event}get onDidUpdateExtensionMetadata(){return this._onDidUpdateExtensionMetadata.event}async installFromGallery(e,r={}){try{let o=(await this.installGalleryExtensions([{extension:e,options:r}])).find(({identifier:s})=>H(s,e.identifier));if(o?.local)return o?.local;throw o?.error?o.error:new Ee(`Unknown error while installing extension ${e.identifier.id}`,"Unknown")}catch(n){throw Ue(n)}}async installGalleryExtensions(e){if(!this.galleryService.isEnabled())throw new Ee(m(1942,null),"NotAllowed");let r=[],n=[];return await Promise.allSettled(e.map(async({extension:o,options:s})=>{try{let a=await this.checkAndGetCompatibleVersion(o,!!s?.installGivenVersion,!!s?.installPreReleaseVersion,s.productVersion??{version:this.productService.version,date:this.productService.date});n.push({...a,options:s})}catch(a){r.push({identifier:o.identifier,operation:2,source:o,error:a,profileLocation:s.profileLocation??this.getCurrentExtensionsManifestLocation()})}})),n.length&&r.push(...await this.installExtensions(n)),r}async uninstall(e,r){return this.logService.trace("ExtensionManagementService#uninstall",e.identifier.id),this.uninstallExtensions([{extension:e,options:r}])}async toggleApplicationScope(e,r){if(Qu(e.manifest)||e.isBuiltin)return e;if(e.isApplicationScoped){let n=await this.updateMetadata(e,{isApplicationScoped:!1},this.userDataProfilesService.defaultProfile.extensionsResource);this.uriIdentityService.extUri.isEqual(r,this.userDataProfilesService.defaultProfile.extensionsResource)||(n=await this.copyExtension(e,this.userDataProfilesService.defaultProfile.extensionsResource,r));for(let o of this.userDataProfilesService.profiles){let s=(await this.getInstalled(1,o.extensionsResource)).find(a=>H(a.identifier,e.identifier));s?this._onDidUpdateExtensionMetadata.fire({local:s,profileLocation:o.extensionsResource}):this._onDidUninstallExtension.fire({identifier:e.identifier,profileLocation:o.extensionsResource})}return n}else{let n=this.uriIdentityService.extUri.isEqual(r,this.userDataProfilesService.defaultProfile.extensionsResource)?await this.updateMetadata(e,{isApplicationScoped:!0},this.userDataProfilesService.defaultProfile.extensionsResource):await this.copyExtension(e,r,this.userDataProfilesService.defaultProfile.extensionsResource,{isApplicationScoped:!0});return this._onDidInstallExtensions.fire([{identifier:n.identifier,operation:2,local:n,profileLocation:this.userDataProfilesService.defaultProfile.extensionsResource,applicationScoped:!0}]),n}}getExtensionsControlManifest(){let e=new Date().getTime();return(!this.extensionsControlManifest||e-this.lastReportTimestamp>1e3*60*5)&&(this.extensionsControlManifest=this.updateControlCache(),this.lastReportTimestamp=e),this.extensionsControlManifest}registerParticipant(e){this.participants.push(e)}async resetPinnedStateForAllUserExtensions(e){try{await this.joinAllSettled(this.userDataProfilesService.profiles.map(async r=>{let n=await this.getInstalled(1,r.extensionsResource);await this.joinAllSettled(n.map(async o=>{o.pinned!==e&&await this.updateMetadata(o,{pinned:e},r.extensionsResource)}))}))}catch(r){throw this.logService.error("Error while resetting pinned state for all user extensions",G(r)),r}}async installExtensions(e){let r=new Map,n=new Map,o=[],s=(c,u)=>`${Ze.create(c).toString()}-${u.toString()}`,a=(c,u,p,f)=>{let g;if(!P.isUri(u)){if(n.has(`${u.identifier.id.toLowerCase()}-${p.profileLocation.toString()}`))return;let y=this.installingExtensions.get(s(u,p.profileLocation));if(y){if(f&&this.canWaitForTask(f,y.task)){let E=y.task.identifier;this.logService.info("Waiting for already requested installing extension",E.id,f.identifier.id,p.profileLocation.toString()),y.waitingTasks.push(f),o.push(J.toPromise(J.filter(this.onDidInstallExtensions,b=>b.some(C=>H(C.identifier,E)))).then(b=>{this.logService.info("Finished waiting for already requested installing extension",E.id,f.identifier.id,p.profileLocation.toString());let C=b.find(N=>H(N.identifier,E));if(!C?.local)throw new Error(`Extension ${E.id} is not installed`);return C.local}))}return}g=this.uninstallingExtensions.get(this.getUninstallExtensionTaskKey(u.identifier,p.profileLocation))}let v=this.createInstallExtensionTask(c,u,p),h=`${Dt(c.publisher,c.name)}-${p.profileLocation.toString()}`;n.set(h,{task:v,root:f,uninstallTaskToWaitFor:g}),this._onInstallExtension.fire({identifier:v.identifier,source:u,profileLocation:p.profileLocation}),this.logService.info("Installing extension:",v.identifier.id,p),P.isUri(u)||this.installingExtensions.set(s(u,p.profileLocation),{task:v,waitingTasks:[]})};try{for(let{manifest:u,extension:p,options:f}of e){let g=f.isApplicationScoped||f.isBuiltin||Qu(u),v={...f,isApplicationScoped:g,profileLocation:g?this.userDataProfilesService.defaultProfile.extensionsResource:f.profileLocation??this.getCurrentExtensionsManifestLocation(),productVersion:f.productVersion??{version:this.productService.version,date:this.productService.date}},h=P.isUri(p)?void 0:this.installingExtensions.get(s(p,v.profileLocation));h?(this.logService.info("Extension is already requested to install",h.task.identifier.id,v.profileLocation.toString()),o.push(h.task.waitUntilTaskIsFinished())):a(u,p,v,void 0)}await Promise.all([...n.values()].map(async({task:u})=>{if(u.options.donotIncludePackAndDependencies)this.logService.info("Installing the extension without checking dependencies and pack",u.identifier.id);else try{let p=this.preferPreReleases;u.options.installPreReleaseVersion?p=!0:!P.isUri(u.source)&&u.source.hasPreReleaseVersion&&(p=!1);let f=await this.getInstalled(void 0,u.options.profileLocation,u.options.productVersion),g=await this.getAllDepsAndPackExtensions(u.identifier,u.manifest,p,u.options.productVersion,f),v={...u.options,pinned:!1,installGivenVersion:!1,context:{...u.options.context,[Fm]:!0}};for(let{gallery:h,manifest:y}of Mt(g,({gallery:E})=>E.identifier.id)){let E=f.find(b=>H(b.identifier,h.identifier));E&&E.isApplicationScoped===!!v.isApplicationScoped||a(y,h,v,u)}}catch(p){if(P.isUri(u.source))wc(u.manifest.extensionDependencies)&&this.logService.warn("Cannot install dependencies of extension:",u.identifier.id,p.message),wc(u.manifest.extensionPack)&&this.logService.warn("Cannot install packed extensions of extension:",u.identifier.id,p.message);else throw this.logService.error("Error while preparing to install dependencies and extension packs of the extension:",u.identifier.id),p}}));let c=await this.getOtherProfilesToUpdateExtension([...n.values()].map(({task:u})=>u));for(let[u,p]of c)a(p.manifest,p.source,{...p.options,profileLocation:u},void 0);await this.joinAllSettled([...n.entries()].map(async([u,{task:p,uninstallTaskToWaitFor:f}])=>{let g=new Date().getTime(),v;try{if(f){this.logService.info("Waiting for existing uninstall task to complete before installing",p.identifier.id);try{await f.waitUntilTaskIsFinished(),this.logService.info("Finished waiting for uninstall task, proceeding with install",p.identifier.id)}catch(h){this.logService.info("Uninstall task failed, proceeding with install anyway",p.identifier.id,G(h))}}v=await p.run(),await this.joinAllSettled(this.participants.map(h=>h.postInstall(v,p.source,p.options,re.None)),"PostInstall")}catch(h){let y=Ue(h);throw P.isUri(p.source)||Sd(this.telemetryService,p.operation===3?"extensionGallery:update":"extensionGallery:install",{extensionData:ps(p.source),error:y,source:p.options.context?.[Ju]}),r.set(u,{error:y,identifier:p.identifier,operation:p.operation,source:p.source,context:p.options.context,profileLocation:p.options.profileLocation,applicationScoped:p.options.isApplicationScoped}),this.logService.error("Error while installing the extension",p.identifier.id,G(y),p.options.profileLocation.toString()),y}if(!P.isUri(p.source)){let h=p.operation===3,y=h?void 0:(new Date().getTime()-p.source.lastUpdated)/1e3;Sd(this.telemetryService,h?"extensionGallery:update":"extensionGallery:install",{extensionData:ps(p.source),verificationStatus:p.verificationStatus,duration:new Date().getTime()-g,durationSinceUpdate:y,source:p.options.context?.[Ju]})}r.set(u,{local:v,identifier:p.identifier,operation:p.operation,source:p.source,context:p.options.context,profileLocation:p.options.profileLocation,applicationScoped:v.isApplicationScoped})})),o.length&&await this.joinAllSettled(o)}catch(c){let u=(g,v,h)=>{let y=[];g.manifest.extensionDependencies?.length&&y.push(...g.manifest.extensionDependencies),g.manifest.extensionPack?.length&&y.push(...g.manifest.extensionPack);for(let E of y){if(h.includes(E.toLowerCase()))continue;h.push(E.toLowerCase());let b=r.get(`${E.toLowerCase()}-${v.toString()}`);b?.local&&(h=u(b.local,v,h))}return h},p=g=>({identifier:g.identifier,operation:2,source:g.source,context:g.options.context,profileLocation:g.options.profileLocation,error:c}),f=[];for(let[g,{task:v,root:h}]of n){let y=r.get(g);y?y.local&&h&&!r.get(`${h.identifier.id.toLowerCase()}-${v.options.profileLocation.toString()}`)?.local&&(f.push(this.createUninstallExtensionTask(y.local,{versionOnly:!0,profileLocation:v.options.profileLocation})),r.set(g,p(v))):(v.cancel(),r.set(g,p(v)))}for(let[g,{task:v}]of n){let h=r.get(g);if(!h?.local||v.options.donotIncludePackAndDependencies)continue;u(h.local,v.options.profileLocation,[h.local.identifier.id.toLowerCase()]).slice(1).some(E=>n.has(`${E.toLowerCase()}-${v.options.profileLocation.toString()}`)&&!r.get(`${E.toLowerCase()}-${v.options.profileLocation.toString()}`)?.local)&&(f.push(this.createUninstallExtensionTask(h.local,{versionOnly:!0,profileLocation:v.options.profileLocation})),r.set(g,p(v)))}f.length&&await Promise.allSettled(f.map(async g=>{try{await g.run(),this.logService.info("Rollback: Uninstalled extension",g.extension.identifier.id)}catch(v){this.logService.warn("Rollback: Error while uninstalling extension",g.extension.identifier.id,G(v))}}))}finally{for(let{task:c}of n.values())c.source&&!P.isUri(c.source)&&this.installingExtensions.delete(s(c.source,c.options.profileLocation))}let l=[...r.values()];for(let c of l)c.local&&this.logService.info("Extension installed successfully:",c.identifier.id,c.profileLocation.toString());return this._onDidInstallExtensions.fire(l),l}async getOtherProfilesToUpdateExtension(e){let r=[],n=new be;for(let o of e)if(!(o.operation!==3||o.options.isApplicationScoped||o.options.pinned||o.options.installGivenVersion||P.isUri(o.source)))for(let s of this.userDataProfilesService.profiles){if(this.uriIdentityService.extUri.isEqual(s.extensionsResource,o.options.profileLocation))continue;let a=n.get(s.extensionsResource);a||(a=await this.getInstalled(1,s.extensionsResource),n.set(s.extensionsResource,a));let l=a.find(c=>H(c.identifier,o.identifier));l&&!l.pinned&&r.push([s.extensionsResource,o])}return r}canWaitForTask(e,r){for(let[,{task:n,waitingTasks:o}]of this.installingExtensions.entries())if(n===e&&(o.includes(r)||o.some(s=>this.canWaitForTask(s,r)))||n===r&&o[0]&&!this.canWaitForTask(e,o[0]))return!1;return!0}async joinAllSettled(e,r){let n=[],o=[],s=await Promise.allSettled(e);for(let l of s)l.status==="fulfilled"?n.push(l.value):o.push(Ue(l.reason,r));if(!o.length)return n;if(o.length===1)throw o[0];let a=new Ee("","Unknown");for(let l of o)a=new Ee(a.message?`${a.message}, ${l.message}`:l.message,l.code!=="Unknown"&&l.code!=="Internal"?l.code:a.code);throw a}async getAllDepsAndPackExtensions(e,r,n,o,s){if(!this.galleryService.isEnabled())return[];let a=[],l=[],c=async(u,p)=>{a.push(u);let f=p.extensionDependencies?p.extensionDependencies.filter(v=>!s.some(h=>H(h.identifier,{id:v}))):[],g=[...f];if(p.extensionPack){let v=s.find(h=>H(h.identifier,u));for(let h of p.extensionPack)v&&v.manifest.extensionPack&&v.manifest.extensionPack.some(y=>H({id:y},{id:h}))||g.every(y=>!H({id:y},{id:h}))&&g.push(h)}if(g.length){let v=g.filter(h=>a.every(y=>!H(y,{id:h})));if(v.length){let h=await this.galleryService.getExtensions(v.map(y=>({id:y,preRelease:n})),re.None);for(let y of h){if(a.find(C=>H(C,y.identifier)))continue;let E=f.some(C=>H({id:C},y.identifier)),b;try{b=await this.checkAndGetCompatibleVersion(y,!1,n,o)}catch(C){if(E)throw C;this.logService.info("Skipping the packed extension as it cannot be installed",y.identifier.id,G(C));continue}l.push({gallery:b.extension,manifest:b.manifest}),await c(b.extension.identifier,b.manifest)}}}};return await c(e,r),l}async checkAndGetCompatibleVersion(e,r,n,o){let s,a=await this.getExtensionsControlManifest();if(ig(e.identifier,a.malicious))throw new Ee(m(1941,null,e.identifier.id),"Malicious");let l=a.deprecated[e.identifier.id.toLowerCase()];if(l?.extension?.autoMigrate){if(this.logService.info(`The '${e.identifier.id}' extension is deprecated, fetching the compatible '${l.extension.id}' extension instead.`),s=(await this.galleryService.getExtensions([{id:l.extension.id,preRelease:l.extension.preRelease}],{targetPlatform:await this.getTargetPlatform(),compatible:!0,productVersion:o},re.None))[0],!s)throw new Ee(m(1947,null,e.identifier.id,l.extension.id),"Deprecated")}else{if(await this.canInstall(e)!==!0){let u=await this.getTargetPlatform();throw new Ee(m(1938,null,e.identifier.id,this.productService.nameLong,Xu(u)),"IncompatibleTargetPlatform")}if(s=await this.getCompatibleVersion(e,r,n,o),!s){let u=[];throw ms(e.properties.enabledApiProposals??[],u)?!n&&e.hasPreReleaseVersion&&e.properties.isPreReleaseVersion&&(await this.galleryService.getExtensions([e.identifier],re.None))[0]?new Ee(m(1948,null,e.displayName??e.identifier.id),"ReleaseVersionNotFound"):new Ee(m(1946,null,e.identifier.id,this.productService.nameLong,this.productService.version),"Incompatible"):new Ee(m(1939,null,e.displayName??e.identifier.id,u[0]),"IncompatibleApi")}}this.logService.info("Getting Manifest...",s.identifier.id);let c=await this.galleryService.getManifest(s,re.None);if(c===null)throw new Ee(`Missing manifest for extension ${s.identifier.id}`,"Invalid");if(c.version!==s.version)throw new Ee(`Cannot install '${s.identifier.id}' extension because of version mismatch in Marketplace`,"Invalid");return{extension:s,manifest:c}}async getCompatibleVersion(e,r,n,o){let s=await this.getTargetPlatform(),a=null;return!r&&e.hasPreReleaseVersion&&e.properties.isPreReleaseVersion!==n&&(a=(await this.galleryService.getExtensions([{...e.identifier,preRelease:n}],{targetPlatform:s,compatible:!0,productVersion:o},re.None))[0]||null),!a&&await this.galleryService.isExtensionCompatible(e,n,s,o)&&(a=e),a||(r?a=(await this.galleryService.getExtensions([{...e.identifier,version:e.version}],{targetPlatform:s,compatible:!0,productVersion:o},re.None))[0]||null:a=await this.galleryService.getCompatibleExtension(e,n,s,o)),a}getUninstallExtensionTaskKey(e,r,n){return`${e.id.toLowerCase()}${n?`-${n}`:""}@${r.toString()}`}async uninstallExtensions(e){let r=(f,g)=>this.getUninstallExtensionTaskKey(f.identifier,g.profileLocation,g.versionOnly?f.manifest.version:void 0),n=(f,g)=>{let v;for(let{task:y}of this.installingExtensions.values())if(!(y.source instanceof P)&&H(y.identifier,f.identifier)&&this.uriIdentityService.extUri.isEqual(y.options.profileLocation,g.profileLocation)){v=y;break}let h=this.createUninstallExtensionTask(f,g);this.uninstallingExtensions.set(r(h.extension,g),h),this.logService.info("Uninstalling extension from the profile:",`${f.identifier.id}@${f.manifest.version}`,g.profileLocation.toString()),this._onUninstallExtension.fire({identifier:f.identifier,profileLocation:g.profileLocation,applicationScoped:f.isApplicationScoped}),s.push({task:h,installTaskToWaitFor:v})},o=(f,g,v)=>{v?this.logService.error("Failed to uninstall extension from the profile:",`${f.identifier.id}@${f.manifest.version}`,g.profileLocation.toString(),v.message):this.logService.info("Successfully uninstalled extension from the profile",`${f.identifier.id}@${f.manifest.version}`,g.profileLocation.toString()),Sd(this.telemetryService,"extensionGallery:uninstall",{extensionData:ng(f),error:v}),this._onDidUninstallExtension.fire({identifier:f.identifier,error:v?.code,profileLocation:g.profileLocation,applicationScoped:f.isApplicationScoped})},s=[],a=[],l=[],c=[],u=new be,p=async f=>{let g=u.get(f);return g||u.set(f,g=await this.getInstalled(1,f)),g};for(let{extension:f,options:g}of e){let v={...g,profileLocation:f.isApplicationScoped?this.userDataProfilesService.defaultProfile.extensionsResource:g?.profileLocation??this.getCurrentExtensionsManifestLocation()},h=this.uninstallingExtensions.get(r(f,v));if(h?(this.logService.info("Extensions is already requested to uninstall",f.identifier.id),l.push(h.waitUntilTaskIsFinished())):n(f,v),v.remove||f.isApplicationScoped){v.remove&&c.push(f);for(let y of this.userDataProfilesService.profiles){if(this.uriIdentityService.extUri.isEqual(y.extensionsResource,v.profileLocation))continue;let b=(await p(y.extensionsResource)).find(C=>H(C.identifier,f.identifier));if(b){let C={...v,profileLocation:y.extensionsResource},N=this.uninstallingExtensions.get(r(b,C));N?(this.logService.info("Extensions is already requested to uninstall",b.identifier.id),l.push(N.waitUntilTaskIsFinished())):n(b,C)}}}}try{for(let{task:f}of s.slice(0)){let g=await p(f.options.profileLocation);if(f.options.donotIncludePack)this.logService.info("Uninstalling the extension without including packed extension",`${f.extension.identifier.id}@${f.extension.manifest.version}`);else{let v=this.getAllPackExtensionsToUninstall(f.extension,g);for(let h of v)this.uninstallingExtensions.has(r(h,f.options))?this.logService.info("Extensions is already requested to uninstall",h.identifier.id):n(h,f.options)}f.options.donotCheckDependents?this.logService.info("Uninstalling the extension without checking dependents",`${f.extension.identifier.id}@${f.extension.manifest.version}`):this.checkForDependents(s.map(({task:v})=>v.extension),g,f.extension)}await this.joinAllSettled(s.map(async({task:f,installTaskToWaitFor:g})=>{try{if(g){this.logService.info("Waiting for existing install task to complete before uninstalling",f.extension.identifier.id);try{await g.waitUntilTaskIsFinished(),this.logService.info("Finished waiting for install task, proceeding with uninstall",f.extension.identifier.id)}catch(v){this.logService.info("Install task failed, proceeding with uninstall anyway",f.extension.identifier.id,G(v))}}if(await f.run(),await this.joinAllSettled(this.participants.map(v=>v.postUninstall(f.extension,f.options,re.None))),f.extension.identifier.uuid&&!Je)try{await this.galleryService.reportStatistic(f.extension.manifest.publisher,f.extension.manifest.name,f.extension.manifest.version,"uninstall")}catch{}}catch(v){let h=Ue(v);throw o(f.extension,f.options,h),h}finally{a.push(f)}})),l.length&&await this.joinAllSettled(l);for(let{task:f}of s)o(f.extension,f.options);c.length&&await this.joinAllSettled(c.map(f=>this.deleteExtension(f)))}catch(f){let g=Ue(f);for(let{task:v}of s){try{v.cancel()}catch{}a.includes(v)||o(v.extension,v.options,g)}throw g}finally{for(let{task:f}of s)this.uninstallingExtensions.delete(r(f.extension,f.options))||this.logService.warn("Uninstallation task is not found in the cache",f.extension.identifier.id)}}checkForDependents(e,r,n){for(let o of e){let s=this.getDependents(o,r);if(s.length){let a=s.filter(l=>!e.some(c=>H(c.identifier,l.identifier)));if(a.length)throw new Error(this.getDependentsErrorMessage(o,a,n))}}}getDependentsErrorMessage(e,r,n){return n===e?r.length===1?m(1949,null,n.manifest.displayName||n.manifest.name,r[0].manifest.displayName||r[0].manifest.name):r.length===2?m(1951,null,n.manifest.displayName||n.manifest.name,r[0].manifest.displayName||r[0].manifest.name,r[1].manifest.displayName||r[1].manifest.name):m(1943,null,n.manifest.displayName||n.manifest.name,r[0].manifest.displayName||r[0].manifest.name,r[1].manifest.displayName||r[1].manifest.name):r.length===1?m(1950,null,n.manifest.displayName||n.manifest.name,e.manifest.displayName||e.manifest.name,r[0].manifest.displayName||r[0].manifest.name):r.length===2?m(1952,null,n.manifest.displayName||n.manifest.name,e.manifest.displayName||e.manifest.name,r[0].manifest.displayName||r[0].manifest.name,r[1].manifest.displayName||r[1].manifest.name):m(1944,null,n.manifest.displayName||n.manifest.name,e.manifest.displayName||e.manifest.name,r[0].manifest.displayName||r[0].manifest.name,r[1].manifest.displayName||r[1].manifest.name)}getAllPackExtensionsToUninstall(e,r,n=[]){if(n.indexOf(e)!==-1)return[];if(H(e.identifier,{id:this.productService.defaultChatAgent.extensionId}))return[];n.push(e);let o=e.manifest.extensionPack?e.manifest.extensionPack:[];if(o.length){let s=r.filter(l=>!l.isBuiltin&&o.some(c=>H({id:c},l.identifier))),a=[];for(let l of s)a.push(...this.getAllPackExtensionsToUninstall(l,r,n));return[...s,...a]}return[]}getDependents(e,r){return r.filter(n=>n.manifest.extensionDependencies&&n.manifest.extensionDependencies.some(o=>H({id:o},e.identifier)))}async updateControlCache(){try{return this.logService.trace("ExtensionManagementService.updateControlCache"),await this.galleryService.getExtensionsControlManifest()}catch(e){return this.logService.trace("ExtensionManagementService.refreshControlCache - failed to get extension control manifest",G(e)),{malicious:[],deprecated:{},search:[]}}}};Xi=T([I(0,kt),I(1,St),I(2,me),I(3,V),I(4,ke),I(5,fr),I(6,$e)],Xi);function Ue(i,t){if(i instanceof Ee)return i;let e;return i instanceof Xt?e=new Ee(i.message,i.code==="DownloadFailedWriting"?"DownloadFailedWriting":"Gallery"):e=new Ee(i.message,or(i)?"Cancelled":t??"Internal"),e.stack=i.stack,e}function Sd(i,t,{extensionData:e,verificationStatus:r,duration:n,error:o,source:s,durationSinceUpdate:a}){i.publicLog(t,{...e,source:s,duration:n,durationSinceUpdate:a,success:!o,errorcode:o?.code,verificationStatus:r==="Success"?"Verified":r??"Unverified"})}var bs=class{constructor(){this.barrier=new gi}async waitUntilTaskIsFinished(){return await this.barrier.wait(),this.cancellablePromise}run(){return this.cancellablePromise||(this.cancellablePromise=Ht(t=>this.doRun(t))),this.barrier.open(),this.cancellablePromise}cancel(){this.cancellablePromise||(this.cancellablePromise=Ht(t=>new Promise((e,r)=>{let n=t.onCancellationRequested(()=>{n.dispose(),r(new Ie)})})),this.barrier.open()),this.cancellablePromise.cancel()}};function Ss(i){let t="Extract";return i instanceof Hn&&(i.type==="CorruptZip"?t="CorruptZip":i.type==="Incomplete"&&(t="IncompleteZip")),Ue(i,t)}async function Ml(i){let t;try{t=await kl(i,"extension/package.json")}catch(e){throw Ss(e)}try{return JSON.parse(t.toString("utf8"))}catch{throw new Ee(m(2022,null),"Invalid")}}var en=class extends _{constructor(e,r,n,o,s,a,l){super();this.fileService=r;this.extensionGalleryService=n;this.extensionSignatureVerificationService=o;this.telemetryService=s;this.uriIdentityService=a;this.logService=l;this.extensionsDownloadDir=e.extensionsDownloadLocation,this.extensionsTrashDir=a.extUri.joinPath(e.extensionsDownloadLocation,".trash"),this.cache=20,this.cleanUpPromise=this.cleanUp()}static{this.SignatureArchiveExtension=".sigzip"}async download(e,r,n,o){await this.cleanUpPromise;let s=await this.downloadVSIX(e,r);if(!n)return{location:s,verificationStatus:void 0};if(!e.isSigned)return{location:s,verificationStatus:"NotSigned"};let a;try{a=await this.downloadSignatureArchive(e);let l=(await this.extensionSignatureVerificationService.verify(e.identifier.id,e.version,s.fsPath,a.fsPath,o))?.code;if(l==="PackageIsInvalidZip"||l==="SignatureArchiveIsInvalidZip"){try{await this.delete(s)}catch(c){this.logService.error(c)}throw new Ee(gd,"CorruptZip")}return{location:s,verificationStatus:l}}catch(l){try{await this.delete(s)}catch(c){this.logService.error(c)}throw l}finally{if(a)try{await this.delete(a)}catch(l){this.logService.error(l)}}}async downloadVSIX(e,r){try{let n=z(this.extensionsDownloadDir,this.getName(e)),o=await this.doDownload(e,"vsix",async()=>{await this.downloadFile(e,n,s=>this.extensionGalleryService.download(e,s,r));try{await this.validate(n.fsPath,"extension/package.json")}catch(s){try{await this.fileService.del(n)}catch(a){this.logService.warn(`Error while deleting: ${n.path}`,G(a))}throw s}},2);return o>1&&this.telemetryService.publicLog2("extensiongallery:downloadvsix:retry",{extensionId:e.identifier.id,attempts:o}),n}catch(n){throw Ue(n,"Download")}}async downloadSignatureArchive(e){try{let r=z(this.extensionsDownloadDir,`${this.getName(e)}${en.SignatureArchiveExtension}`),n=await this.doDownload(e,"sigzip",async()=>{await this.extensionGalleryService.downloadSignatureArchive(e,r);try{await this.validate(r.fsPath,".signature.p7s")}catch(o){try{await this.fileService.del(r)}catch(s){this.logService.warn(`Error while deleting: ${r.path}`,G(s))}throw o}},2);return n>1&&this.telemetryService.publicLog2("extensiongallery:downloadsigzip:retry",{extensionId:e.identifier.id,attempts:n}),r}catch(r){throw Ue(r,"DownloadSignature")}}async downloadFile(e,r,n){if(await this.fileService.exists(r))return;if(r.scheme!==$.file){await n(r);return}let o=z(this.extensionsDownloadDir,`.${Ne()}`);try{await n(o)}catch(s){try{await this.fileService.del(o)}catch{}throw s}try{await ie.rename(o.fsPath,r.fsPath,120*1e3)}catch(s){try{await this.fileService.del(o)}catch{}let a=!1;try{a=await this.fileService.exists(r)}catch{}if(a)this.logService.info("Rename failed because the file was downloaded by another source. So ignoring renaming.",e.identifier.id,r.path);else throw this.logService.info(`Rename failed because of ${G(s)}. Deleted the file from downloaded location`,o.path),s}}async doDownload(e,r,n,o){let s=1;for(;;)try{return await n(),s}catch(a){if(s++>o)throw a;this.logService.warn(`Failed downloading ${r}. ${G(a)}. Retry again...`,e.identifier.id)}}async validate(e,r){try{await kl(e,r)}catch(n){throw Ss(n)}}async delete(e){await this.cleanUpPromise;let r=this.uriIdentityService.extUri.relativePath(this.extensionsDownloadDir,e);r?await this.fileService.move(e,this.uriIdentityService.extUri.joinPath(this.extensionsTrashDir,r),!0):await this.fileService.del(e)}async cleanUp(){try{if(!await this.fileService.exists(this.extensionsDownloadDir)){this.logService.trace("Extension VSIX downloads cache dir does not exist");return}try{await this.fileService.del(this.extensionsTrashDir,{recursive:!0})}catch(r){Se(r)!==1&&this.logService.error(r)}let e=await this.fileService.resolve(this.extensionsDownloadDir,{resolveMetadata:!0});if(e.children){let r=[],n=[],o=[];for(let l of e.children)if(l.name.endsWith(en.SignatureArchiveExtension))o.push(l.resource);else{let c=Ze.parse(l.name);c&&n.push([c,l])}let s=gl(n,([l])=>l),a=[];for(let l of s)l.sort((c,u)=>ol(c[0].version,u[0].version)),r.push(...l.slice(1).map(c=>c[1].resource)),a.push(l[0][1]);a.sort((l,c)=>l.mtime-c.mtime),r.push(...a.slice(0,Math.max(0,a.length-this.cache)).map(l=>l.resource)),r.push(...o),await He.settled(r.map(l=>(this.logService.trace("Deleting from cache",l.path),this.fileService.del(l))))}}catch(e){this.logService.error(e)}}getName(e){return Ze.create(e).toString().toLowerCase()}};en=T([I(0,Qe),I(1,ee),I(2,kt),I(3,Pl),I(4,St),I(5,me),I(6,V)],en);import{fork as qI}from"child_process";var Yi=class extends _{constructor(e,r){super();this.userDataProfilesService=e;this.logService=r;this.processesLimiter=new Vo(5)}async postUninstall(e){let r=this.parseScript(e,"uninstall");r&&(this.logService.info(e.identifier.id,e.manifest.version,"Running post uninstall script"),await this.processesLimiter.queue(async()=>{try{await this.runLifecycleHook(r.script,"uninstall",r.args,!0,e),this.logService.info("Finished running post uninstall script",e.identifier.id,e.manifest.version)}catch(n){this.logService.error("Failed to run post uninstall script",e.identifier.id,e.manifest.version),this.logService.error(n)}}));try{await ie.rm(this.getExtensionStoragePath(e))}catch(n){this.logService.error("Error while removing extension storage path",e.identifier.id),this.logService.error(n)}}parseScript(e,r){let n=`vscode:${r}`;if(e.location.scheme===$.file&&e.manifest&&e.manifest.scripts&&typeof e.manifest.scripts[n]=="string"){let o=e.manifest.scripts[n].split(" ");return o.length<2||o[0]!=="node"||!o[1]?(this.logService.warn(e.identifier.id,e.manifest.version,`${n} should be a node script`),null):{script:q(e.location.fsPath,o[1]),args:o.slice(2)||[]}}return null}runLifecycleHook(e,r,n,o,s){return new Promise((a,l)=>{let c=this.start(e,r,n,s),u,p=f=>{u&&(clearTimeout(u),u=null),f?l(f):a(void 0)};c.on("error",f=>{p(ar(f)||"Unknown")}),c.on("exit",(f,g)=>{p(f?`post-${r} process exited with code ${f}`:void 0)}),o&&(u=setTimeout(()=>{u=null,c.kill(),l("timed out")},5e3))})}start(e,r,n,o){let s={silent:!0,execArgv:void 0},a=qI(e,[`--type=extension-post-${r}`,...n],s);a.stdout.setEncoding("utf8"),a.stderr.setEncoding("utf8");let l=J.fromNodeEventEmitter(a.stdout,"data"),c=J.fromNodeEventEmitter(a.stderr,"data");this._register(l(f=>this.logService.info(o.identifier.id,o.manifest.version,`post-${r}`,f))),this._register(c(f=>this.logService.error(o.identifier.id,o.manifest.version,`post-${r}`,f)));let u=J.any(J.map(l,f=>({data:`%c${f}`,format:[""]}),this._store),J.map(c,f=>({data:`%c${f}`,format:["color: red"]}),this._store));return J.debounce(u,(f,g)=>f?{data:f.data+g.data,format:[...f.format,...g.format]}:{data:g.data,format:g.format},100,void 0,void 0,void 0,this._store)(f=>{console.group(o.identifier.id),console.log(f.data,...f.format),console.groupEnd()}),a}getExtensionStoragePath(e){return q(this.userDataProfilesService.defaultProfile.globalStorageHome.fsPath,e.identifier.id.toLowerCase())}};Yi=T([I(0,$e),I(1,V)],Yi);var Fl=class extends _{constructor(e,r,n,o,s){super();this.userDataProfilesService=e;this.fileService=r;this.uriIdentityService=n;this.logService=s;this._register(o.onDidInstallExtensions(a=>this.onDidInstallExtensions(a))),this._register(o.onDidUninstallExtension(a=>this.onDidUnInstallExtension(a)))}onDidInstallExtensions(e){for(let r of e)r.local&&this.invalidate(r.profileLocation)}onDidUnInstallExtension(e){e.error||this.invalidate(e.profileLocation)}async invalidate(e){if(e)for(let r of this.userDataProfilesService.profiles)this.uriIdentityService.extUri.isEqual(r.extensionsResource,e)&&await this.deleteUserCacheFile(r);else await this.deleteUserCacheFile(this.userDataProfilesService.defaultProfile)}async deleteUserCacheFile(e){try{await this.fileService.del(this.uriIdentityService.extUri.joinPath(e.cacheHome,al))}catch(r){Se(r)!==1&&this.logService.error(r)}}};var Ol=class extends _{constructor(e,r,n,o,s,a,l){super();this.extensionManagementService=e;this.extensionsScannerService=r;this.userDataProfilesService=n;this.extensionsProfileScannerService=o;this.uriIdentityService=s;this.fileService=a;this.logService=l;this._onDidChangeExtensionsByAnotherSource=this._register(new R);this.onDidChangeExtensionsByAnotherSource=this._onDidChangeExtensionsByAnotherSource.event;this.allExtensions=new Map;this.extensionsProfileWatchDisposables=this._register(new wr);this.initialize().then(null,c=>l.error("Error while initializing Extensions Watcher",G(c)))}async initialize(){await this.extensionsScannerService.initializeDefaultProfileExtensions(),await this.onDidChangeProfiles(this.userDataProfilesService.profiles),this.registerListeners(),await this.deleteExtensionsNotInProfiles()}registerListeners(){this._register(this.userDataProfilesService.onDidChangeProfiles(e=>this.onDidChangeProfiles(e.added))),this._register(this.extensionsProfileScannerService.onAddExtensions(e=>this.onAddExtensions(e))),this._register(this.extensionsProfileScannerService.onDidAddExtensions(e=>this.onDidAddExtensions(e))),this._register(this.extensionsProfileScannerService.onRemoveExtensions(e=>this.onRemoveExtensions(e))),this._register(this.extensionsProfileScannerService.onDidRemoveExtensions(e=>this.onDidRemoveExtensions(e))),this._register(this.fileService.onDidFilesChange(e=>this.onDidFilesChange(e)))}async onDidChangeProfiles(e){try{e.length&&await Promise.all(e.map(r=>(this.extensionsProfileWatchDisposables.set(r.id,Js(this.fileService.watch(this.uriIdentityService.extUri.dirname(r.extensionsResource)),this.fileService.watch(r.extensionsResource))),this.populateExtensionsFromProfile(r.extensionsResource))))}catch(r){throw this.logService.error(r),r}}async onAddExtensions(e){for(let r of e.extensions)this.addExtensionWithKey(this.getKey(r.identifier,r.version),e.profileLocation)}async onDidAddExtensions(e){for(let r of e.extensions){let n=this.getKey(r.identifier,r.version);e.error?this.removeExtensionWithKey(n,e.profileLocation):this.addExtensionWithKey(n,e.profileLocation)}}async onRemoveExtensions(e){for(let r of e.extensions)this.removeExtensionWithKey(this.getKey(r.identifier,r.version),e.profileLocation)}async onDidRemoveExtensions(e){let r=[],n=[];for(let o of e.extensions){let s=this.getKey(o.identifier,o.version);e.error?this.addExtensionWithKey(s,e.profileLocation):(this.removeExtensionWithKey(s,e.profileLocation),this.allExtensions.has(s)||(this.logService.debug("Extension is removed from all profiles",o.identifier.id,o.version),n.push(this.extensionManagementService.scanInstalledExtensionAtLocation(o.location).then(a=>{a?r.push(a):this.logService.info("Extension not found at the location",o.location.toString())},a=>this.logService.error(a)))))}try{await Promise.all(n),r.length&&await this.deleteExtensionsNotInProfiles(r)}catch(o){this.logService.error(o)}}onDidFilesChange(e){for(let r of this.userDataProfilesService.profiles)e.contains(r.extensionsResource,0,1)&&this.onDidExtensionsProfileChange(r.extensionsResource)}async onDidExtensionsProfileChange(e){let r=[],n=[],o=await this.extensionsProfileScannerService.scanProfileExtensions(e),s=new Set,a=new Set;for(let[l,c]of this.allExtensions)c.has(e)&&a.add(l);for(let l of o){let c=this.getKey(l.identifier,l.version);s.add(c),a.has(c)||(r.push(l.identifier),this.addExtensionWithKey(c,e))}for(let l of a)if(!s.has(l)){let c=this.fromKey(l);c&&(n.push(c.identifier),this.removeExtensionWithKey(l,e))}(r.length||n.length)&&this._onDidChangeExtensionsByAnotherSource.fire({added:r.length?{extensions:r,profileLocation:e}:void 0,removed:n.length?{extensions:n,profileLocation:e}:void 0})}async populateExtensionsFromProfile(e){let r=await this.extensionsProfileScannerService.scanProfileExtensions(e);for(let n of r)this.addExtensionWithKey(this.getKey(n.identifier,n.version),e)}async deleteExtensionsNotInProfiles(e){e||(e=(await this.extensionManagementService.scanAllUserInstalledExtensions()).filter(n=>!this.allExtensions.has(this.getKey(n.identifier,n.manifest.version)))),e.length&&await this.extensionManagementService.deleteExtensions(...e)}addExtensionWithKey(e,r){let n=this.allExtensions.get(e);n||this.allExtensions.set(e,n=new on(o=>this.uriIdentityService.extUri.getComparisonKey(o))),n.add(r)}removeExtensionWithKey(e,r){let n=this.allExtensions.get(e);n&&n.delete(r),n?.size||this.allExtensions.delete(e)}getKey(e,r){return`${pr.toKey(e.id)}@${r}`}fromKey(e){let[r,n]=ds(e);return n?{identifier:{id:r},version:n}:void 0}};var ih=Vi,wd=".vsctmp",Zi=class extends Xi{constructor(e,r,n,o,s,a,l,c,u,p,f,g,v,h,y){super(e,r,h,n,g,v,y);this.environmentService=o;this.extensionsScannerService=s;this.extensionsProfileScannerService=a;this.downloadService=l;this.instantiationService=c;this.fileService=u;this.configurationService=p;this.extensionGalleryManifestService=f;this.extractingGalleryExtensions=new Map;this.knownDirectories=new on;let E=this._register(c.createInstance(Yi));this.extensionsScanner=this._register(c.createInstance(Es,C=>E.postUninstall(C))),this.manifestCache=this._register(new Fl(y,u,h,this,this.logService)),this.extensionsDownloader=this._register(c.createInstance(en));let b=this._register(new Ol(this,this.extensionsScannerService,y,a,h,u,n));this._register(b.onDidChangeExtensionsByAnotherSource(C=>this.onDidChangeExtensionsFromAnotherSource(C))),this.watchForExtensionsNotInstalledBySystem()}getTargetPlatform(){return this._targetPlatformPromise||(this._targetPlatformPromise=hl(this.fileService,this.logService)),this._targetPlatformPromise}async zip(e){this.logService.trace("ExtensionManagementService#zip",e.identifier.id);let r=await this.collectFiles(e),n=await Gg(z(this.extensionsDownloader.extensionsDownloadDir,Ne()).fsPath,r);return P.file(n)}async getManifest(e){let{location:r,cleanup:n}=await this.downloadVsix(e),o=Rr(r.fsPath);try{return await Ml(o)}finally{await n()}}getInstalled(e,r=this.userDataProfilesService.defaultProfile.extensionsResource,n={version:this.productService.version,date:this.productService.date},o){return this.extensionsScanner.scanExtensions(e??null,r,n,o)}scanAllUserInstalledExtensions(){return this.extensionsScanner.scanAllUserExtensions()}scanInstalledExtensionAtLocation(e){return this.extensionsScanner.scanUserExtensionAtLocation(e)}async install(e,r={}){this.logService.trace("ExtensionManagementService#install",e.toString());let{location:n,cleanup:o}=await this.downloadVsix(e);try{let s=await Ml(Rr(n.fsPath)),a=Dt(s.publisher,s.name);if(s.engines&&s.engines.vscode&&!fs(s.engines.vscode,this.productService.version,this.productService.date))throw new Error(m(2016,null,a,this.productService.version));let l=this.allowedExtensionsService.isAllowed({id:a,version:s.version,publisherDisplayName:void 0});if(l!==!0)throw new Error(m(2018,null,l.value));let u=(await this.installExtensions([{manifest:s,extension:n,options:r}])).find(({identifier:p})=>H(p,{id:a}));if(u?.local)return u.local;throw u?.error?u.error:Ue(new Error(`Unknown error while installing extension ${a}`))}finally{await o()}}async installFromLocation(e,r){this.logService.trace("ExtensionManagementService#installFromLocation",e.toString());let n=await this.extensionsScanner.scanUserExtensionAtLocation(e);if(!n||!n.manifest.name||!n.manifest.version)throw new Error(`Cannot find a valid extension from the location ${e.toString()}`);return await this.addExtensionsToProfile([[n,{source:"resource"}]],r),this.logService.info("Successfully installed extension",n.identifier.id,r.toString()),n}async installExtensionsFromProfile(e,r,n){this.logService.trace("ExtensionManagementService#installExtensionsFromProfile",e,r.toString(),n.toString());let o=(await this.getInstalled(1,r)).filter(s=>e.some(a=>H(a,s.identifier)));if(o.length){let s=await Promise.all(o.map(a=>this.extensionsScanner.scanMetadata(a,r)));await this.addExtensionsToProfile(o.map((a,l)=>[a,s[l]]),n),this.logService.info("Successfully installed extensions",o.map(a=>a.identifier.id),n.toString())}return o}async updateMetadata(e,r,n){return this.logService.trace("ExtensionManagementService#updateMetadata",e.identifier.id),r.isPreReleaseVersion&&(r.preRelease=!0,r.hasPreReleaseVersion=!0),r.isMachineScoped===!1&&(r.isMachineScoped=void 0),r.isBuiltin===!1&&(r.isBuiltin=void 0),r.pinned===!1&&(r.pinned=void 0),e=await this.extensionsScanner.updateMetadata(e,r,n),this.manifestCache.invalidate(n),this._onDidUpdateExtensionMetadata.fire({local:e,profileLocation:n}),e}deleteExtension(e){return this.extensionsScanner.deleteExtension(e,"remove")}copyExtension(e,r,n,o){return this.extensionsScanner.copyExtension(e,r,n,o)}moveExtension(e,r,n,o){return this.extensionsScanner.moveExtension(e,r,n,o)}removeExtension(e,r){return this.extensionsScanner.removeExtension(e.identifier,r)}copyExtensions(e,r){return this.extensionsScanner.copyExtensions(e,r,{version:this.productService.version,date:this.productService.date})}deleteExtensions(...e){return this.extensionsScanner.setExtensionsForRemoval(...e)}async cleanUp(){this.logService.trace("ExtensionManagementService#cleanUp");try{await this.extensionsScanner.cleanUp()}catch(e){this.logService.error(e)}}async download(e,r,n){let{location:o}=await this.downloadExtension(e,r,!n);return o}async downloadVsix(e){if(e.scheme===$.file)return{location:e,async cleanup(){}};this.logService.trace("Downloading extension from",e.toString());let r=z(this.extensionsDownloader.extensionsDownloadDir,Ne());return await this.downloadService.download(e,r),this.logService.info("Downloaded extension to",r.toString()),{location:r,cleanup:async()=>{try{await this.fileService.del(r)}catch(o){this.logService.error(o)}}}}getCurrentExtensionsManifestLocation(){return this.userDataProfilesService.defaultProfile.extensionsResource}createInstallExtensionTask(e,r,n){let o=r instanceof P?new Ze({id:Dt(e.publisher,e.name)},e.version):Ze.create(r);return this.instantiationService.createInstance(ws,o,e,r,n,(s,a)=>{if(r instanceof P)return this.extractVSIX(o,r,n,a);let l=this.extractingGalleryExtensions.get(o.toString());return l||(this.extractingGalleryExtensions.set(o.toString(),l=this.downloadAndExtractGalleryExtension(o,r,s,n,a)),l.finally(()=>this.extractingGalleryExtensions.delete(o.toString()))),l},this.extensionsScanner)}createUninstallExtensionTask(e,r){return new Pd(e,r,this.extensionsProfileScannerService)}async downloadAndExtractGalleryExtension(e,r,n,o,s){let{verificationStatus:a,location:l}=await this.downloadExtension(r,n,!o.donotVerifySignature,o.context?.[Om]);try{if(s.isCancellationRequested)throw new Ie;let c=await Ml(l.fsPath);if(!new Ze(r.identifier,r.version).equals(new Ze({id:Dt(c.publisher,c.name)},c.version)))throw new Ee(m(2017,null,r.identifier.id),"Invalid");let u=await this.extensionsScanner.extractUserExtension(e,l.fsPath,!1,s);if(a!=="Success"&&this.environmentService.isBuilt)try{await this.extensionsDownloader.delete(l)}catch(p){this.logService.warn("Error while deleting the downloaded file",l.toString(),G(p))}return{local:u,verificationStatus:a}}catch(c){try{await this.extensionsDownloader.delete(l)}catch(u){this.logService.warn("Error while deleting the downloaded file",l.toString(),G(u))}throw Ue(c)}}async downloadExtension(e,r,n,o){if(n){let c=this.configurationService.getValue(Wm);n=Tt(c)?c:!0}let{location:s,verificationStatus:a}=await this.extensionsDownloader.download(e,r,n,o),l=Gm(e.private,await this.extensionGalleryManifestService.getExtensionGalleryManifest());if(a!=="Success"&&!(a==="NotSigned"&&!l)&&n&&this.environmentService.isBuilt&&await this.getTargetPlatform()!=="linux-armhf"){try{await this.extensionsDownloader.delete(s)}catch(c){this.logService.warn("Error while deleting the downloaded file",s.toString(),G(c))}if(!a)throw new Ee(m(2021,null),"SignatureVerificationInternal");switch(a){case"PackageIntegrityCheckFailed":case"SignatureIsInvalid":case"SignatureManifestIsInvalid":case"SignatureIntegrityCheckFailed":case"EntryIsMissing":case"EntryIsTampered":case"Untrusted":case"CertificateRevoked":case"SignatureIsNotValid":case"SignatureArchiveHasTooManyEntries":case"NotSigned":throw new Ee(m(2020,null,a),"SignatureVerificationFailed")}throw new Ee(m(2020,null,a),"SignatureVerificationInternal")}return{location:s,verificationStatus:a}}async extractVSIX(e,r,n,o){return{local:await this.extensionsScanner.extractUserExtension(e,Rr(r.fsPath),Tt(n.keepExisting)?!n.keepExisting:!0,o)}}async collectFiles(e){let r=async o=>{let s=await ie.readdir(o);s=s.map(c=>q(o,c));let a=await Promise.all(s.map(c=>nh.promises.stat(c))),l=Promise.resolve([]);return a.forEach((c,u)=>{let p=s[u];c.isFile()&&(l=l.then(f=>[...f,p])),c.isDirectory()&&(l=l.then(f=>r(p).then(g=>[...f,...g])))}),l};return(await r(e.location.fsPath)).map(o=>({path:`extension/${sa(e.location.fsPath,o)}`,localPath:o}))}async onDidChangeExtensionsFromAnotherSource({added:e,removed:r}){if(r){let n=e&&this.uriIdentityService.extUri.isEqual(r.profileLocation,e.profileLocation)?r.extensions.filter(o=>e.extensions.every(s=>!H(s,o))):r.extensions;for(let o of n)this.logService.info("Extensions removed from another source",o.id,r.profileLocation.toString()),this._onDidUninstallExtension.fire({identifier:o,profileLocation:r.profileLocation})}if(e){let o=(await this.getInstalled(1,e.profileLocation)).filter(s=>e.extensions.some(a=>H(a,s.identifier)));this._onDidInstallExtensions.fire(o.map(s=>(this.logService.info("Extensions added from another source",s.identifier.id,e.profileLocation.toString()),{identifier:s.identifier,local:s,profileLocation:e.profileLocation,operation:1})))}}async watchForExtensionsNotInstalledBySystem(){this._register(this.extensionsScanner.onExtract(r=>this.knownDirectories.add(r)));let e=await this.fileService.resolve(this.extensionsScannerService.userExtensionsLocation);for(let r of e.children??[])r.isDirectory&&this.knownDirectories.add(r.resource);this._register(this.fileService.watch(this.extensionsScannerService.userExtensionsLocation)),this._register(this.fileService.onDidFilesChange(r=>this.onDidFilesChange(r)))}async onDidFilesChange(e){if(!e.affects(this.extensionsScannerService.userExtensionsLocation,1))return;let r=[];for(let n of e.rawAdded){if(this.knownDirectories.has(n)||!this.uriIdentityService.extUri.isEqual(this.uriIdentityService.extUri.dirname(n),this.extensionsScannerService.userExtensionsLocation)||this.uriIdentityService.extUri.isEqual(n,this.uriIdentityService.extUri.joinPath(this.extensionsScannerService.userExtensionsLocation,".obsolete"))||this.uriIdentityService.extUri.basename(n).startsWith(".")||this.uriIdentityService.extUri.basename(n).endsWith(wd))continue;try{if(!(await this.fileService.stat(n)).isDirectory)continue}catch(s){Se(s)!==1&&this.logService.error(s);continue}let o=await this.extensionsScanner.scanUserExtensionAtLocation(n);o&&o.installedTimestamp===void 0&&(this.knownDirectories.add(n),r.push(o))}r.length&&(await this.addExtensionsToProfile(r.map(n=>[n,void 0]),this.userDataProfilesService.defaultProfile.extensionsResource),this.logService.info("Added extensions to default profile from external source",r.map(n=>n.identifier.id)))}async addExtensionsToProfile(e,r){let n=e.map(o=>o[0]);await this.extensionsScanner.unsetExtensionsForRemoval(...n.map(o=>Ze.create(o))),await this.extensionsProfileScannerService.addExtensionsToProfile(e,r),this._onDidInstallExtensions.fire(n.map(o=>({local:o,identifier:o.identifier,operation:1,profileLocation:r})))}};Zi=T([I(0,kt),I(1,St),I(2,V),I(3,Qe),I(4,Ji),I(5,nr),I(6,tl),I(7,Lr),I(8,ee),I(9,It),I(10,Sn),I(11,ke),I(12,fr),I(13,me),I(14,$e)],Zi);var Es=class extends _{constructor(e,r,n,o,s,a,l){super();this.beforeRemovingExtension=e;this.fileService=r;this.extensionsScannerService=n;this.extensionsProfileScannerService=o;this.uriIdentityService=s;this.telemetryService=a;this.logService=l;this._onExtract=this._register(new R);this.onExtract=this._onExtract.event;this.scanAllExtensionPromise=new be;this.scanUserExtensionsPromise=new be;this.obsoletedResource=z(this.extensionsScannerService.userExtensionsLocation,".obsolete"),this.obsoleteFileLimiter=new jt}async cleanUp(){await this.removeTemporarilyDeletedFolders(),await this.deleteExtensionsMarkedForRemoval(),await this.initializeExtensionSize()}async scanExtensions(e,r,n,o){try{let s=r.with({query:o}),a={includeInvalid:!0,profileLocation:r,productVersion:n,language:o},l=[];if(e===null||e===0){let c=this.scanAllExtensionPromise.get(s);c||(c=this.extensionsScannerService.scanAllExtensions({language:o},a).finally(()=>this.scanAllExtensionPromise.delete(s)),this.scanAllExtensionPromise.set(s,c)),l.push(...await c)}else if(e===1){let c=this.scanUserExtensionsPromise.get(s);c||(c=this.extensionsScannerService.scanUserExtensions(a).finally(()=>this.scanUserExtensionsPromise.delete(s)),this.scanUserExtensionsPromise.set(s,c)),l.push(...await c)}return l=e!==null?l.filter(c=>c.type===e):l,await Promise.all(l.map(c=>this.toLocalExtension(c)))}catch(s){throw Ue(s,"Scanning")}}async scanAllUserExtensions(){try{let e=await this.extensionsScannerService.scanAllUserExtensions();return await Promise.all(e.map(r=>this.toLocalExtension(r)))}catch(e){throw Ue(e,"Scanning")}}async scanUserExtensionAtLocation(e){try{let r=await this.extensionsScannerService.scanExistingExtension(e,1,{includeInvalid:!0});if(r)return await this.toLocalExtension(r)}catch(r){this.logService.error(r)}return null}async extractUserExtension(e,r,n,o){let s=e.toString(),a=P.file(q(this.extensionsScannerService.userExtensionsLocation.fsPath,`.${Ne()}`)),l=P.file(q(this.extensionsScannerService.userExtensionsLocation.fsPath,s));if(await this.fileService.exists(l)){if(!n)try{return await this.scanLocalExtension(l,1)}catch(c){this.logService.warn(`Error while scanning the existing extension at ${l.path}. Deleting the existing extension and extracting it.`,G(c))}try{await this.deleteExtensionFromLocation(e.id,l,"removeExisting")}catch{throw new Ee(m(2015,null,l.fsPath,e.id),"Delete")}}try{if(o.isCancellationRequested)throw new Ie;try{this.logService.trace(`Started extracting the extension from ${r} to ${l.fsPath}`),await qg(r,a.fsPath,{sourcePath:"extension",overwrite:!0},o),this.logService.info(`Extracted extension to ${l}:`,e.id)}catch(u){throw Ss(u)}let c={installedTimestamp:Date.now(),targetPlatform:e.targetPlatform};try{c.size=await ul(a,this.fileService)}catch(u){this.logService.warn(`Error while getting the size of the extracted extension : ${a.fsPath}`,G(u))}try{await this.extensionsScannerService.updateManifestMetadata(a,c)}catch(u){throw this.telemetryService.publicLog2("extension:extract",{extensionId:e.id,code:`${Se(u)}`}),Ue(u,"UpdateMetadata")}if(o.isCancellationRequested)throw new Ie;try{this.logService.trace(`Started renaming the extension from ${a.fsPath} to ${l.fsPath}`),await this.rename(a.fsPath,l.fsPath),this.logService.info("Renamed to",l.fsPath)}catch(u){if(u.code==="ENOTEMPTY"){this.logService.info("Rename failed because extension was installed by another source. So ignoring renaming.",e.id);try{await this.fileService.del(a,{recursive:!0})}catch{}}else throw this.logService.info(`Rename failed because of ${G(u)}. Deleted from extracted location`,a),u}this._onExtract.fire(l)}catch(c){try{await this.fileService.del(a,{recursive:!0})}catch{}throw c}return this.scanLocalExtension(l,1)}async scanMetadata(e,r){return(await this.getScannedExtension(e,r))?.metadata}async getScannedExtension(e,r){return(await this.extensionsProfileScannerService.scanProfileExtensions(r)).find(o=>H(o.identifier,e.identifier))}async updateMetadata(e,r,n){try{await this.extensionsProfileScannerService.updateMetadata([[e,r]],n)}catch(o){throw this.telemetryService.publicLog2("extension:extract",{extensionId:e.identifier.id,code:`${Se(o)}`,isProfile:!!n}),Ue(o,"UpdateMetadata")}return this.scanLocalExtension(e.location,e.type,n)}async setExtensionsForRemoval(...e){let r=[];for(let o of e)await this.fileService.exists(o.location)&&r.push(o);let n=r.map(o=>Ze.create(o));await this.withRemovedExtensions(o=>n.forEach(s=>{o[s.toString()]=!0,this.logService.info("Marked extension as removed",s.toString())}))}async unsetExtensionsForRemoval(...e){try{let r=[];return await this.withRemovedExtensions(n=>e.forEach(o=>{n[o.toString()]?(r.push(!0),delete n[o.toString()]):r.push(!1)})),r}catch(r){throw Ue(r,"UnsetRemoved")}}async deleteExtension(e,r){this.uriIdentityService.extUri.isEqualOrParent(e.location,this.extensionsScannerService.userExtensionsLocation)&&(await this.deleteExtensionFromLocation(e.identifier.id,e.location,r),await this.unsetExtensionsForRemoval(Ze.create(e)))}async copyExtension(e,r,n,o){let s=await this.getScannedExtension(e,r),a=await this.getScannedExtension(e,n);if(o={...s?.metadata,...o},a)if(this.uriIdentityService.extUri.isEqual(a.location,e.location))await this.extensionsProfileScannerService.updateMetadata([[e,{...a.metadata,...o}]],n);else{let l=await this.scanLocalExtension(a.location,e.type,n);await this.extensionsProfileScannerService.removeExtensionsFromProfile([l.identifier],n),await this.extensionsProfileScannerService.addExtensionsToProfile([[e,{...a.metadata,...o}]],n)}else await this.extensionsProfileScannerService.addExtensionsToProfile([[e,o]],n);return this.scanLocalExtension(e.location,e.type,n)}async moveExtension(e,r,n,o){let s=await this.getScannedExtension(e,r),a=await this.getScannedExtension(e,n);if(o={...s?.metadata,...o},a)if(this.uriIdentityService.extUri.isEqual(a.location,e.location))await this.extensionsProfileScannerService.updateMetadata([[e,{...a.metadata,...o}]],n);else{let l=await this.scanLocalExtension(a.location,e.type,n);await this.removeExtension(l.identifier,n),await this.extensionsProfileScannerService.addExtensionsToProfile([[e,{...a.metadata,...o}]],n)}else await this.extensionsProfileScannerService.addExtensionsToProfile([[e,o]],n),s&&await this.removeExtension(s.identifier,r);return this.scanLocalExtension(e.location,e.type,n)}async removeExtension(e,r){await this.extensionsProfileScannerService.removeExtensionsFromProfile([e],r)}async copyExtensions(e,r,n){let o=await this.scanExtensions(1,e,n),s=await Promise.all(o.filter(a=>!a.isApplicationScoped).map(async a=>[a,await this.scanMetadata(a,e)]));await this.extensionsProfileScannerService.addExtensionsToProfile(s,r)}async deleteExtensionFromLocation(e,r,n){this.logService.trace(`Deleting ${n} extension from disk`,e,r.fsPath);let o=this.uriIdentityService.extUri.joinPath(this.uriIdentityService.extUri.dirname(r),`${this.uriIdentityService.extUri.basename(r)}.${ur(Ne()).toString(16)}${wd}`);await this.rename(r.fsPath,o.fsPath),await this.fileService.del(o,{recursive:!0}),this.logService.info(`Deleted ${n} extension from disk`,e,r.fsPath)}withRemovedExtensions(e){return this.obsoleteFileLimiter.queue(async()=>{let r;try{r=(await this.fileService.readFile(this.obsoletedResource,"utf8")).value.toString()}catch(o){if(Se(o)!==1)throw o}let n={};if(r)try{n=JSON.parse(r)}catch{}if(e)if(e(n),Object.keys(n).length)await this.fileService.writeFile(this.obsoletedResource,U.fromString(JSON.stringify(n)));else try{await this.fileService.del(this.obsoletedResource)}catch(o){if(Se(o)!==1)throw o}return n})}async rename(e,r){try{await ie.rename(e,r,120*1e3)}catch(n){throw Ue(n,"Rename")}}async scanLocalExtension(e,r,n){try{if(n){let s=(await this.extensionsScannerService.scanUserExtensions({profileLocation:n})).find(a=>this.uriIdentityService.extUri.isEqual(a.location,e));if(s)return await this.toLocalExtension(s)}else{let o=await this.extensionsScannerService.scanExistingExtension(e,r,{includeInvalid:!0});if(o)return await this.toLocalExtension(o)}throw new Ee(m(2014,null,e.path),"ScanningExtension")}catch(o){throw Ue(o,"ScanningExtension")}}async toLocalExtension(e){let r;try{r=await this.fileService.resolve(e.location)}catch{}let n,o;return r?.children&&(n=r.children.find(({name:s})=>/^readme(\.txt|\.md|)$/i.test(s))?.resource,o=r.children.find(({name:s})=>/^changelog(\.txt|\.md|)$/i.test(s))?.resource),{identifier:e.identifier,type:e.type,isBuiltin:e.isBuiltin||!!e.metadata?.isBuiltin,location:e.location,manifest:e.manifest,targetPlatform:e.targetPlatform,validations:e.validations,isValid:e.isValid,readmeUrl:n,changelogUrl:o,publisherDisplayName:e.metadata?.publisherDisplayName,publisherId:e.metadata?.publisherId||null,isApplicationScoped:!!e.metadata?.isApplicationScoped,isMachineScoped:!!e.metadata?.isMachineScoped,isPreReleaseVersion:!!e.metadata?.isPreReleaseVersion,hasPreReleaseVersion:!!e.metadata?.hasPreReleaseVersion,preRelease:e.preRelease,installedTimestamp:e.metadata?.installedTimestamp,updated:!!e.metadata?.updated,pinned:!!e.metadata?.pinned,private:!!e.metadata?.private,isWorkspaceScoped:!1,source:e.metadata?.source??(e.identifier.uuid?"gallery":"vsix"),size:e.metadata?.size??0}}async initializeExtensionSize(){let e=await this.extensionsScannerService.scanAllUserExtensions();await Promise.all(e.map(async r=>{if(js(r.metadata?.installedTimestamp)&&ut(r.metadata?.size)){let n=await ul(r.location,this.fileService);await this.extensionsScannerService.updateManifestMetadata(r.location,{size:n})}}))}async deleteExtensionsMarkedForRemoval(){let e;try{e=await this.withRemovedExtensions()}catch(s){throw Ue(s,"ReadRemoved")}if(Object.keys(e).length===0){this.logService.debug("No extensions are marked as removed.");return}this.logService.debug("Deleting extensions marked as removed:",Object.keys(e));let r=await this.scanAllUserExtensions(),n=new Set;for(let s of r)e[Ze.create(s).toString()]||n.add(s.identifier.id.toLowerCase());try{let s=gl(r,a=>a.identifier);await He.settled(s.map(async a=>{let l=a.sort((c,u)=>ol(c.manifest.version,u.manifest.version))[0];n.has(l.identifier.id.toLowerCase())||await this.beforeRemovingExtension(l)}))}catch(s){this.logService.error(s)}let o=r.filter(s=>s.installedTimestamp&&e[Ze.create(s).toString()]);await Promise.allSettled(o.map(s=>this.deleteExtension(s,"marked for removal")))}async removeTemporarilyDeletedFolders(){this.logService.trace("ExtensionManagementService#removeTempDeleteFolders");let e;try{e=await this.fileService.resolve(this.extensionsScannerService.userExtensionsLocation)}catch(r){Se(r)!==1&&this.logService.error(r);return}if(e?.children)try{await Promise.allSettled(e.children.map(async r=>{if(!(!r.isDirectory||!r.name.endsWith(wd))){this.logService.trace("Deleting the temporarily deleted folder",r.resource.toString());try{await this.fileService.del(r.resource,{recursive:!0}),this.logService.trace("Deleted the temporarily deleted folder",r.resource.toString())}catch(n){Se(n)!==1&&this.logService.error(n)}}}))}catch{}}};Es=T([I(1,ee),I(2,Ji),I(3,nr),I(4,me),I(5,St),I(6,V)],Es);var ws=class extends bs{constructor(e,r,n,o,s,a,l,c,u,p,f,g){super();this.extensionKey=e;this.manifest=r;this.source=n;this.options=o;this.extractExtensionFn=s;this.extensionsScanner=a;this.uriIdentityService=l;this.galleryService=c;this.userDataProfilesService=u;this.extensionsScannerService=p;this.extensionsProfileScannerService=f;this.logService=g;this._operation=2;this.identifier=this.extensionKey.identifier}get operation(){return this.options.operation??this._operation}get verificationStatus(){return this._verificationStatus}async doRun(e){let n=(await this.extensionsScanner.scanExtensions(1,this.options.profileLocation,this.options.productVersion)).find(l=>H(l.identifier,this.identifier));n&&(this._operation=3);let o={isApplicationScoped:this.options.isApplicationScoped||n?.isApplicationScoped,isMachineScoped:this.options.isMachineScoped||n?.isMachineScoped,isBuiltin:this.options.isBuiltin||n?.isBuiltin,isSystem:n?.type===0?!0:void 0,installedTimestamp:Date.now(),pinned:this.options.installGivenVersion?!0:this.options.pinned??n?.pinned,source:this.source instanceof P?"vsix":"gallery"},s;if(this.source instanceof P){if(n&&this.extensionKey.equals(new Ze(n.identifier,n.manifest.version)))try{await this.extensionsScanner.deleteExtension(n,"existing")}catch{throw new Error(m(2019,null,this.manifest.displayName||this.manifest.name))}let l=await this.unsetIfRemoved(this.extensionKey);if(l)try{await this.extensionsScanner.deleteExtension(l,"existing")}catch{throw new Error(m(2019,null,this.manifest.displayName||this.manifest.name))}}else{if(o.id=this.source.identifier.uuid,o.publisherId=this.source.publisherId,o.publisherDisplayName=this.source.publisherDisplayName,o.targetPlatform=this.source.properties.targetPlatform,o.updated=!!n,o.private=this.source.private,o.isPreReleaseVersion=this.source.properties.isPreReleaseVersion,o.hasPreReleaseVersion=n?.hasPreReleaseVersion||this.source.properties.isPreReleaseVersion,o.preRelease=Tt(this.options.preRelease)?this.options.preRelease:this.options.installPreReleaseVersion||this.source.properties.isPreReleaseVersion||n?.preRelease,n&&n.type!==0&&n.manifest.version===this.source.version)return this.extensionsScanner.updateMetadata(n,o,this.options.profileLocation);s=await this.unsetIfRemoved(this.extensionKey)}if(e.isCancellationRequested)throw Ue(new Ie);if(!s){let l=await this.extractExtensionFn(this.operation,e);s=l.local,this._verificationStatus=l.verificationStatus}if(this.uriIdentityService.extUri.isEqual(this.userDataProfilesService.defaultProfile.extensionsResource,this.options.profileLocation))try{await this.extensionsScannerService.initializeDefaultProfileExtensions()}catch(l){throw Ue(l,"IntializeDefaultProfile")}if(e.isCancellationRequested)throw Ue(new Ie);try{await this.extensionsProfileScannerService.addExtensionsToProfile([[s,o]],this.options.profileLocation,!s.isValid)}catch(l){throw Ue(l,"AddToProfile")}let a=await this.extensionsScanner.scanLocalExtension(s.location,1,this.options.profileLocation);if(!a)throw new Ee("Cannot find the installed extension","InstalledExtensionNotFound");return this.source instanceof P&&this.updateMetadata(s,e),a}async unsetIfRemoved(e){let[r]=await this.extensionsScanner.unsetExtensionsForRemoval(e);if(r)return this.logService.info("Removed the extension from removed list:",e.id),(await this.extensionsScanner.scanAllUserExtensions()).find(o=>Ze.create(o).equals(e))}async updateMetadata(e,r){try{let[n]=await this.galleryService.getExtensions([{id:e.identifier.id,version:e.manifest.version}],r);if(n||([n]=await this.galleryService.getExtensions([{id:e.identifier.id}],r)),n){let o={id:n.identifier.uuid,publisherDisplayName:n.publisherDisplayName,publisherId:n.publisherId,isPreReleaseVersion:n.properties.isPreReleaseVersion,hasPreReleaseVersion:e.hasPreReleaseVersion||n.properties.isPreReleaseVersion,preRelease:n.properties.isPreReleaseVersion||this.options.installPreReleaseVersion};await this.extensionsScanner.updateMetadata(e,o,this.options.profileLocation)}}catch{}}};ws=T([I(6,me),I(7,kt),I(8,$e),I(9,Ji),I(10,nr),I(11,V)],ws);var Pd=class extends bs{constructor(e,r,n){super();this.extension=e;this.options=r;this.extensionsProfileScannerService=n}doRun(e){return this.extensionsProfileScannerService.removeExtensionsFromProfile([this.extension.identifier],this.options.profileLocation)}};var eo=class extends Cl{constructor(t,e,r,n,o,s,a,l){super(P.file(o.builtinExtensionsPath),P.file(o.extensionsPath),o.userHome,t.defaultProfile,t,e,r,n,o,s,a,l)}};eo=T([I(0,$e),I(1,nr),I(2,ee),I(3,V),I(4,Qe),I(5,ke),I(6,me),I(7,Lr)],eo);async function Vl(i,t,e,r,n,o){let s;try{await KI(i,t,e,r,n,o)}catch(a){s=a}finally{s&&n.errorTransformer&&(s=n.errorTransformer(s)),typeof s<"u"&&e.error(s),e.end()}}async function KI(i,t,e,r,n,o){Td(o);let s=await i.open(t,{create:!1});try{Td(o);let a=0,l=0,c=n&&typeof n.length=="number"?n.length:void 0,u=U.alloc(Math.min(n.bufferSize,typeof c=="number"?c:n.bufferSize)),p=n&&typeof n.position=="number"?n.position:0,f=0;do l=await i.read(s,p,u.buffer,f,u.byteLength-f),p+=l,f+=l,a+=l,typeof c=="number"&&(c-=l),f===u.byteLength&&(await e.write(r(u)),u=U.alloc(Math.min(n.bufferSize,typeof c=="number"?c:n.bufferSize)),f=0);while(l>0&&(typeof c!="number"||c>0)&&Td(o)&&zI(a,n));if(f>0){let g=f;typeof c=="number"&&(g=Math.min(f,c)),e.write(r(u.slice(0,g)))}}catch(a){throw Yr(a)}finally{await i.close(s)}}function Td(i){if(i.isCancellationRequested)throw Bs();return!0}function zI(i,t){if(typeof t?.limits?.size=="number"&&i>t.limits.size)throw cr(m(2085,null),"EntryTooLarge");return!0}var En=class extends _{constructor(e){super();this.logService=e;this.BUFFER_SIZE=256*1024;this._onDidChangeFileSystemProviderRegistrations=this._register(new R);this.onDidChangeFileSystemProviderRegistrations=this._onDidChangeFileSystemProviderRegistrations.event;this._onWillActivateFileSystemProvider=this._register(new R);this.onWillActivateFileSystemProvider=this._onWillActivateFileSystemProvider.event;this._onDidChangeFileSystemProviderCapabilities=this._register(new R);this.onDidChangeFileSystemProviderCapabilities=this._onDidChangeFileSystemProviderCapabilities.event;this.provider=new Map;this._onDidRunOperation=this._register(new R);this.onDidRunOperation=this._onDidRunOperation.event;this.internalOnDidFilesChange=this._register(new R);this._onDidUncorrelatedFilesChange=this._register(new R);this.onDidFilesChange=this._onDidUncorrelatedFilesChange.event;this._onDidWatchError=this._register(new R);this.onDidWatchError=this._onDidWatchError.event;this.activeWatchers=new Map;this.writeQueue=this._register(new hi)}registerProvider(e,r){if(this.provider.has(e))throw new Error(`A filesystem provider for the scheme '${e}' is already registered.`);gs(`code/registerFilesystem/${e}`);let n=new Pe;return this.provider.set(e,r),this._onDidChangeFileSystemProviderRegistrations.fire({added:!0,scheme:e,provider:r}),n.add(r.onDidChangeFile(o=>{let s=new Aa(o,!this.isPathCaseSensitive(r));this.internalOnDidFilesChange.fire(s),s.hasCorrelation()||this._onDidUncorrelatedFilesChange.fire(s)})),typeof r.onDidWatchError=="function"&&n.add(r.onDidWatchError(o=>this._onDidWatchError.fire(new Error(o)))),n.add(r.onDidChangeCapabilities(()=>this._onDidChangeFileSystemProviderCapabilities.fire({provider:r,scheme:e}))),ue(()=>{this._onDidChangeFileSystemProviderRegistrations.fire({added:!1,scheme:e,provider:r}),this.provider.delete(e),dt(n)})}getProvider(e){return this.provider.get(e)}async activateProvider(e){let r=[];this._onWillActivateFileSystemProvider.fire({scheme:e,join(n){r.push(n)}}),!this.provider.has(e)&&await He.settled(r)}async canHandleResource(e){return await this.activateProvider(e.scheme),this.hasProvider(e)}hasProvider(e){return this.provider.has(e.scheme)}hasCapability(e,r){let n=this.provider.get(e.scheme);return!!(n&&n.capabilities&r)}listCapabilities(){return Er.map(this.provider,([e,r])=>({scheme:e,capabilities:r.capabilities}))}async withProvider(e){if(!If(e))throw new Xe(m(2074,null,this.resourceForError(e)),8);await this.activateProvider(e.scheme);let r=this.provider.get(e.scheme);if(!r){let n=new Ir;throw n.message=m(2076,null,e.toString()),n}return r}async withReadProvider(e){let r=await this.withProvider(e);if(Xr(r)||Jt(r)||Fa(r))return r;throw new Error(`Filesystem provider for scheme '${e.scheme}' neither has FileReadWrite, FileReadStream nor FileOpenReadWriteClose capability which is needed for the read operation.`)}async withWriteProvider(e){let r=await this.withProvider(e);if(Xr(r)||Jt(r))return r;throw new Error(`Filesystem provider for scheme '${e.scheme}' neither has FileReadWrite nor FileOpenReadWriteClose capability which is needed for the write operation.`)}async resolve(e,r){try{return await this.doResolveFile(e,r)}catch(n){throw $o(n)==="EntryNotFound"?new Xe(m(2071,null,this.resourceForError(e)),1):Yr(n)}}async doResolveFile(e,r){let n=await this.withProvider(e),o=this.isPathCaseSensitive(n),s=r?.resolveTo,a=r?.resolveSingleChildDescendants,l=r?.resolveMetadata,c=await n.stat(e),u;return this.toFileStat(n,e,c,void 0,!!l,(p,f)=>(u||(u=Qt.forUris(()=>!o),u.set(e,!0),s&&u.fill(!0,s)),u.get(p.resource)||u.findSuperstr(p.resource.with({query:null,fragment:null}))?!0:p.isDirectory&&a?f===1:!1))}async toFileStat(e,r,n,o,s,a){let{providerExtUri:l}=this.getExtUri(e),c={resource:r,name:l.basename(r),isFile:(n.type&1)!==0,isDirectory:(n.type&2)!==0,isSymbolicLink:(n.type&64)!==0,mtime:n.mtime,ctime:n.ctime,size:n.size,readonly:!!((n.permissions??0)&1)||!!(e.capabilities&2048),locked:!!((n.permissions??0)&2),executable:!!((n.permissions??0)&4),etag:ku({mtime:n.mtime,size:n.size}),children:void 0};if(c.isDirectory&&a(c,o)){try{let u=await e.readdir(r),p=await He.settled(u.map(async([f,g])=>{try{let v=l.joinPath(r,f),h=s?await e.stat(v):{type:g};return await this.toFileStat(e,v,h,u.length,s,a)}catch(v){return this.logService.trace(v),null}}));c.children=br(p)}catch(u){this.logService.trace(u),c.children=[]}return c}return c}async resolveAll(e){return He.settled(e.map(async r=>{try{return{stat:await this.doResolveFile(r.resource,r.options),success:!0}}catch(n){return this.logService.trace(n),{stat:void 0,success:!1}}}))}async stat(e){let r=await this.withProvider(e),n=await r.stat(e);return this.toFileStat(r,e,n,void 0,!0,()=>!1)}async realpath(e){let r=await this.withProvider(e);if(im(r)){let n=await r.realpath(e);return e.with({path:n})}}async exists(e){let r=await this.withProvider(e);try{return!!await r.stat(e)}catch{return!1}}async canCreateFile(e,r){try{await this.doValidateCreateFile(e,r)}catch(n){return n}return!0}async doValidateCreateFile(e,r){if(!r?.overwrite&&await this.exists(e))throw new Xe(m(2067,null,this.resourceForError(e)),3,r)}async createFile(e,r=U.fromString(""),n){await this.doValidateCreateFile(e,n);let o=await this.writeFile(e,r);return this._onDidRunOperation.fire(new Jr(e,0,o)),o}async writeFile(e,r,n){let o=this.throwIfFileSystemIsReadonly(await this.withWriteProvider(e),e),{providerExtUri:s}=this.getExtUri(o),a=n;if(_u(o)&&!a?.atomic){let l=o.enforceAtomicWriteFile?.(e);l&&(a={...n,atomic:l})}try{let{stat:l,buffer:c}=await this.validateWriteFile(o,e,r,a);l||await this.mkdirp(o,s.dirname(e)),c||(c=await this.peekBufferForWriting(o,r)),!Xr(o)||Jt(o)&&c instanceof U||Jt(o)&&_u(o)&&a?.atomic?await this.doWriteUnbuffered(o,e,a,c):await this.doWriteBuffered(o,e,a,c instanceof U?Nf(c):c),this._onDidRunOperation.fire(new Jr(e,4))}catch(l){throw new Xe(m(2066,null,this.resourceForError(e),Yr(l).toString()),Se(l),a)}return this.resolve(e,{resolveMetadata:!0})}async peekBufferForWriting(e,r){let n;if(Jt(e)&&!(r instanceof U))if(Bo(r)){let o=await Uf(r,3);o.ended?n=U.concat(o.buffer):n=o}else n=Af(r,o=>U.concat(o),3);else n=r;return n}async validateWriteFile(e,r,n,o){let s=!!o?.unlock;if(s&&!(e.capabilities&8192))throw new Error(m(2084,null,this.resourceForError(r)));if(o?.append&&!nm(e))throw new Xe(m(2063,null,this.resourceForError(r)),6);if(!!o?.atomic){if(!(e.capabilities&32768))throw new Error(m(2082,null,this.resourceForError(r)));if(!(e.capabilities&2))throw new Error(m(2083,null,this.resourceForError(r)));if(s)throw new Error(m(2081,null,this.resourceForError(r)))}let l;try{l=await e.stat(r)}catch{return Object.create(null)}if((l.type&2)!==0)throw new Xe(m(2069,null,this.resourceForError(r)),0,o);this.throwIfFileIsReadonly(r,l);let c;if(typeof o?.mtime=="number"&&typeof o.etag=="string"&&o.etag!==Na&&typeof l.mtime=="number"&&typeof l.size=="number"&&o.mtime<l.mtime&&o.etag!==ku({mtime:o.mtime,size:l.size})){if(c=await this.peekBufferForWriting(e,n),c instanceof U&&c.byteLength===l.size)try{let{value:u}=await this.readFile(r,{limits:{size:l.size}});if(c.equals(u))return{stat:l,buffer:c}}catch{}throw new Xe(m(2070,null),3,o)}return{stat:l,buffer:c}}async readFile(e,r,n){let o=await this.withReadProvider(e);return r?.atomic?this.doReadFileAtomic(o,e,r,n):this.doReadFile(o,e,r,n)}async doReadFileAtomic(e,r,n,o){return new Promise((s,a)=>{this.writeQueue.queueFor(r,async()=>{try{let l=await this.doReadFile(e,r,n,o);s(l)}catch(l){a(l)}},this.getExtUri(e).providerExtUri)})}async doReadFile(e,r,n,o){let s=await this.doReadFileStream(e,r,{...n,preferUnbuffered:!0},o);return{...s,value:await Ar(s.value)}}async readFileStream(e,r,n){let o=await this.withReadProvider(e);return this.doReadFileStream(o,e,r,n)}async doReadFileStream(e,r,n,o){let s=new pt(o),a=n;Oa(e)&&e.enforceAtomicReadFile?.(r)&&(a={...n,atomic:!0});let l=this.validateReadFile(r,a).then(u=>u,u=>{throw s.dispose(!0),u}),c;try{return typeof a?.etag=="string"&&a.etag!==Na&&await l,a?.atomic&&Oa(e)||!(Xr(e)||Fa(e))||Jt(e)&&a?.preferUnbuffered?c=this.readFileUnbuffered(e,r,a):Fa(e)?c=this.readFileStreamed(e,r,s.token,a):c=this.readFileBuffered(e,r,s.token,a),c.on("end",()=>s.dispose()),c.on("error",()=>s.dispose()),{...await l,value:c}}catch(u){throw c&&await Ia(c),this.restoreReadError(u,r,a)}}restoreReadError(e,r,n){let o=m(2064,null,this.resourceForError(r),Yr(e).toString());return e instanceof Ci?new Ci(o,e.stat,n):e instanceof Ri?new Ri(o,e.fileOperationResult,e.size,e.options):new Xe(o,Se(e),n)}readFileStreamed(e,r,n,o=Object.create(null)){let s=e.readFileStream(r,o,n);return ba(s,{data:a=>a instanceof U?a:U.wrap(a),error:a=>this.restoreReadError(a,r,o)},a=>U.concat(a))}readFileBuffered(e,r,n,o=Object.create(null)){let s=Bf();return Vl(e,r,s,a=>a,{...o,bufferSize:this.BUFFER_SIZE,errorTransformer:a=>this.restoreReadError(a,r,o)},n),s}readFileUnbuffered(e,r,n){let o=Nn(s=>U.concat(s));return(async()=>{try{let s;n?.atomic&&Oa(e)?s=await e.readFile(r,{atomic:!0}):s=await e.readFile(r),typeof n?.position=="number"&&(s=s.slice(n.position)),typeof n?.length=="number"&&(s=s.slice(0,n.length)),this.validateReadFileLimits(r,s.byteLength,n),o.end(U.wrap(s))}catch(s){o.error(s),o.end()}})(),o}async validateReadFile(e,r){let n=await this.resolve(e,{resolveMetadata:!0});if(n.isDirectory)throw new Xe(m(2068,null,this.resourceForError(e)),0,r);if(typeof r?.etag=="string"&&r.etag!==Na&&r.etag===n.etag)throw new Ci(m(2072,null),n,r);return this.validateReadFileLimits(e,n.size,r),n}validateReadFileLimits(e,r,n){if(typeof n?.limits?.size=="number"&&r>n.limits.size)throw new Ri(m(2073,null,this.resourceForError(e)),7,r,n)}async canMove(e,r,n){return this.doCanMoveCopy(e,r,"move",n)}async canCopy(e,r,n){return this.doCanMoveCopy(e,r,"copy",n)}async doCanMoveCopy(e,r,n,o){if(e.toString()!==r.toString())try{let s=n==="move"?this.throwIfFileSystemIsReadonly(await this.withWriteProvider(e),e):await this.withReadProvider(e),a=this.throwIfFileSystemIsReadonly(await this.withWriteProvider(r),r);await this.doValidateMoveCopy(s,e,a,r,n,o)}catch(s){return s}return!0}async move(e,r,n){let o=this.throwIfFileSystemIsReadonly(await this.withWriteProvider(e),e),s=this.throwIfFileSystemIsReadonly(await this.withWriteProvider(r),r),a=await this.doMoveCopy(o,e,s,r,"move",!!n),l=await this.resolve(r,{resolveMetadata:!0});return this._onDidRunOperation.fire(new Jr(e,a==="move"?2:3,l)),l}async copy(e,r,n){let o=await this.withReadProvider(e),s=this.throwIfFileSystemIsReadonly(await this.withWriteProvider(r),r),a=await this.doMoveCopy(o,e,s,r,"copy",!!n),l=await this.resolve(r,{resolveMetadata:!0});return this._onDidRunOperation.fire(new Jr(e,a==="copy"?3:2,l)),l}async doMoveCopy(e,r,n,o,s,a){if(r.toString()===o.toString())return s;let{exists:l,isSameResourceWithDifferentPathCase:c}=await this.doValidateMoveCopy(e,r,n,o,s,a);if(l&&!c&&a&&await this.del(o,{recursive:!0}),await this.mkdirp(n,this.getExtUri(n).providerExtUri.dirname(o)),s==="copy"){if(e===n&&zo(e))await e.copy(r,o,{overwrite:a});else{let u=await this.resolve(r);u.isDirectory?await this.doCopyFolder(e,u,n,o):await this.doCopyFile(e,r,n,o)}return s}else return e===n?(await e.rename(r,o,{overwrite:a}),s):(await this.doMoveCopy(e,r,n,o,"copy",a),await this.del(r,{recursive:!0}),"copy")}async doCopyFile(e,r,n,o){if(Xr(e)&&Xr(n))return this.doPipeBuffered(e,r,n,o);if(Xr(e)&&Jt(n))return this.doPipeBufferedToUnbuffered(e,r,n,o);if(Jt(e)&&Xr(n))return this.doPipeUnbufferedToBuffered(e,r,n,o);if(Jt(e)&&Jt(n))return this.doPipeUnbuffered(e,r,n,o)}async doCopyFolder(e,r,n,o){await n.mkdir(o),Array.isArray(r.children)&&await He.settled(r.children.map(async s=>{let a=this.getExtUri(n).providerExtUri.joinPath(o,s.name);return s.isDirectory?this.doCopyFolder(e,await this.resolve(s.resource),n,a):this.doCopyFile(e,s.resource,n,a)}))}async doValidateMoveCopy(e,r,n,o,s,a){let l=!1;if(e===n){let{providerExtUri:u,isPathCaseSensitive:p}=this.getExtUri(e);if(p||(l=u.isEqual(r,o)),l&&s==="copy")throw new Error(m(2077,null,this.resourceForError(r),this.resourceForError(o)));if(!l&&u.isEqualOrParent(o,r))throw new Error(m(2078,null,this.resourceForError(r),this.resourceForError(o)))}let c=await this.exists(o);if(c&&!l){if(!a)throw new Xe(m(2079,null,this.resourceForError(r),this.resourceForError(o)),4);if(e===n){let{providerExtUri:u}=this.getExtUri(e);if(u.isEqualOrParent(r,o))throw new Error(m(2080,null,this.resourceForError(r),this.resourceForError(o)))}}return{exists:c,isSameResourceWithDifferentPathCase:l}}getExtUri(e){let r=this.isPathCaseSensitive(e);return{providerExtUri:r?de:hf,isPathCaseSensitive:r}}isPathCaseSensitive(e){return!!(e.capabilities&1024)}async createFolder(e){let r=this.throwIfFileSystemIsReadonly(await this.withProvider(e),e);await this.mkdirp(r,e);let n=await this.resolve(e,{resolveMetadata:!0});return this._onDidRunOperation.fire(new Jr(e,0,n)),n}async mkdirp(e,r){let n=[],{providerExtUri:o}=this.getExtUri(e);for(;!o.isEqual(r,o.dirname(r));)try{if(((await e.stat(r)).type&2)===0)throw new Error(m(2075,null,this.resourceForError(r)));break}catch(s){if($o(s)!=="EntryNotFound")throw s;n.push(o.basename(r)),r=o.dirname(r)}for(let s=n.length-1;s>=0;s--){r=o.joinPath(r,n[s]);try{await e.mkdir(r)}catch(a){if($o(a)!=="EntryExists")throw a}}}async canDelete(e,r){try{await this.doValidateDelete(e,r)}catch(n){return n}return!0}async doValidateDelete(e,r){let n=this.throwIfFileSystemIsReadonly(await this.withProvider(e),e),o=!!r?.useTrash;if(o&&!(n.capabilities&4096))throw new Error(m(2062,null,this.resourceForError(e)));let s=r?.atomic;if(s&&!(n.capabilities&65536))throw new Error(m(2058,null,this.resourceForError(e)));if(o&&s)throw new Error(m(2061,null,this.resourceForError(e)));let a;try{a=await n.stat(e)}catch{}if(a)this.throwIfFileIsReadonly(e,a);else throw new Xe(m(2060,null,this.resourceForError(e)),1);if(!!!r?.recursive){let c=await this.resolve(e);if(c.isDirectory&&Array.isArray(c.children)&&c.children.length>0)throw new Error(m(2059,null,this.resourceForError(e)))}return n}async del(e,r){let n=await this.doValidateDelete(e,r),o=r;if(om(n)&&!o?.atomic){let c=n.enforceAtomicDelete?.(e);c&&(o={...r,atomic:c})}let s=!!o?.useTrash,a=!!o?.recursive,l=o?.atomic??!1;await n.delete(e,{recursive:a,useTrash:s,atomic:l}),this._onDidRunOperation.fire(new Jr(e,1))}async cloneFile(e,r){let n=await this.withProvider(e),o=this.throwIfFileSystemIsReadonly(await this.withWriteProvider(r),r);if(!(n===o&&this.getExtUri(n).providerExtUri.isEqual(e,r)))return n===o&&Ma(n)?n.cloneFile(e,r):(await this.mkdirp(o,this.getExtUri(o).providerExtUri.dirname(r)),n===o&&zo(n)?this.writeQueue.queueFor(e,()=>n.copy(e,r,{overwrite:!0}),this.getExtUri(n).providerExtUri):this.writeQueue.queueFor(e,()=>this.doCopyFile(n,e,o,r),this.getExtUri(n).providerExtUri))}static{this.WATCHER_CORRELATION_IDS=0}createWatcher(e,r){return this.watch(e,{...r,correlationId:En.WATCHER_CORRELATION_IDS++})}watch(e,r={recursive:!1,excludes:[]}){let n=new Pe,o=!1,s=()=>{o=!0};n.add(ue(()=>s())),(async()=>{try{let l=await this.doWatch(e,r);o?dt(l):s=()=>dt(l)}catch(l){this.logService.error(l)}})();let a=r.correlationId;if(typeof a=="number"){let l=n.add(new R);return n.add(this.internalOnDidFilesChange.event(u=>{u.correlates(a)&&l.fire(u)})),{onDidChange:l.event,dispose:()=>n.dispose()}}return n}async doWatch(e,r){let n=await this.withProvider(e),o=ur([this.getExtUri(n).providerExtUri.getComparisonKey(e),r]),s=this.activeWatchers.get(o);return s||(s={count:0,disposable:n.watch(e,r)},this.activeWatchers.set(o,s)),s.count+=1,ue(()=>{s&&(s.count--,s.count===0&&(dt(s.disposable),this.activeWatchers.delete(o)))})}dispose(){super.dispose();for(let[,e]of this.activeWatchers)dt(e.disposable);this.activeWatchers.clear()}async doWriteBuffered(e,r,n,o){return this.writeQueue.queueFor(r,async()=>{let s=await e.open(r,{create:!0,unlock:n?.unlock??!1,append:n?.append??!1});try{Bo(o)||ya(o)?await this.doWriteStreamBufferedQueued(e,s,o):await this.doWriteReadableBufferedQueued(e,s,o)}catch(a){throw Yr(a)}finally{await e.close(s)}},this.getExtUri(e).providerExtUri)}async doWriteStreamBufferedQueued(e,r,n){let o=0,s;if(ya(n)){if(n.buffer.length>0){let a=U.concat(n.buffer);await this.doWriteBuffer(e,r,a,a.byteLength,o,0),o+=a.byteLength}if(n.ended)return;s=n.stream}else s=n;return new Promise((a,l)=>{xa(s,{onData:async c=>{s.pause();try{await this.doWriteBuffer(e,r,c,c.byteLength,o,0)}catch(u){return l(u)}o+=c.byteLength,setTimeout(()=>s.resume())},onError:c=>l(c),onEnd:()=>a()})})}async doWriteReadableBufferedQueued(e,r,n){let o=0,s;for(;(s=n.read())!==null;)await this.doWriteBuffer(e,r,s,s.byteLength,o,0),o+=s.byteLength}async doWriteBuffer(e,r,n,o,s,a){let l=0;for(;l<o;){let c=await e.write(r,s+l,n.buffer,a+l,o-l);l+=c}}async doWriteUnbuffered(e,r,n,o){return this.writeQueue.queueFor(r,()=>this.doWriteUnbufferedQueued(e,r,n,o),this.getExtUri(e).providerExtUri)}async doWriteUnbufferedQueued(e,r,n,o){let s;o instanceof U?s=o:Bo(o)?s=await Ar(o):ya(o)?s=await Vf(o):s=Of(o),await e.writeFile(r,s.buffer,{create:!0,overwrite:!0,unlock:n?.unlock??!1,atomic:n?.atomic??!1,append:n?.append??!1})}async doPipeBuffered(e,r,n,o){return this.writeQueue.queueFor(o,()=>this.doPipeBufferedQueued(e,r,n,o),this.getExtUri(n).providerExtUri)}async doPipeBufferedQueued(e,r,n,o){let s,a;try{s=await e.open(r,{create:!1}),a=await n.open(o,{create:!0,unlock:!1});let l=U.alloc(this.BUFFER_SIZE),c=0,u=0,p=0;do p=await e.read(s,c,l.buffer,u,l.byteLength-u),await this.doWriteBuffer(n,a,l,p,c,u),c+=p,u+=p,u===l.byteLength&&(u=0);while(p>0)}catch(l){throw Yr(l)}finally{await He.settled([typeof s=="number"?e.close(s):Promise.resolve(),typeof a=="number"?n.close(a):Promise.resolve()])}}async doPipeUnbuffered(e,r,n,o){return this.writeQueue.queueFor(o,()=>this.doPipeUnbufferedQueued(e,r,n,o),this.getExtUri(n).providerExtUri)}async doPipeUnbufferedQueued(e,r,n,o){return n.writeFile(o,await e.readFile(r),{create:!0,overwrite:!0,unlock:!1,atomic:!1})}async doPipeUnbufferedToBuffered(e,r,n,o){return this.writeQueue.queueFor(o,()=>this.doPipeUnbufferedToBufferedQueued(e,r,n,o),this.getExtUri(n).providerExtUri)}async doPipeUnbufferedToBufferedQueued(e,r,n,o){let s=await n.open(o,{create:!0,unlock:!1});try{let a=await e.readFile(r);await this.doWriteBuffer(n,s,U.wrap(a),a.byteLength,0,0)}catch(a){throw Yr(a)}finally{await n.close(s)}}async doPipeBufferedToUnbuffered(e,r,n,o){let s=await Ar(this.readFileBuffered(e,r,re.None));await this.doWriteUnbuffered(n,o,void 0,s)}throwIfFileSystemIsReadonly(e,r){if(e.capabilities&2048)throw new Xe(m(2065,null,this.resourceForError(r)),6);return e}throwIfFileIsReadonly(e,r){if((r.permissions??0)&1)throw new Xe(m(2065,null,this.resourceForError(e)),6)}resourceForError(e){return e.scheme===$.file?e.fsPath:e.toString(!0)}};En=T([I(0,V)],En);import{constants as Nd,promises as Jn}from"fs";var to="**",ah="/",Wl="[/\\\\]",Bl="[^/\\\\]",HI=/\//g;function lh(i,t){switch(i){case 0:return"";case 1:return`${Bl}*?`;default:return`(?:${Wl}|${Bl}+${Wl}${t?`|${Wl}${Bl}+`:""})*?`}}function ch(i,t){if(!i)return[];let e=[],r=!1,n=!1,o="";for(let s of i){switch(s){case t:if(!r&&!n){e.push(o),o="";continue}break;case"{":r=!0;break;case"}":r=!1;break;case"[":n=!0;break;case"]":n=!1;break}o+=s}return o&&e.push(o),e}function mh(i){if(!i)return"";let t="",e=ch(i,ah);if(e.every(r=>r===to))t=".*";else{let r=!1;e.forEach((n,o)=>{if(n===to){if(r)return;t+=lh(2,o===e.length-1)}else{let s=!1,a="",l=!1,c="";for(let u of n){if(u!=="}"&&s){a+=u;continue}if(l&&(u!=="]"||!c)){let p;u==="-"?p=u:(u==="^"||u==="!")&&!c?p="^":u===ah?p="":p=Cr(u),c+=p;continue}switch(u){case"{":s=!0;continue;case"[":l=!0;continue;case"}":{let f=`(?:${ch(a,",").map(g=>mh(g)).join("|")})`;t+=f,s=!1,a="";break}case"]":{t+="["+c+"]",l=!1,c="";break}case"?":t+=Bl;continue;case"*":t+=lh(1);continue;default:t+=Cr(u)}}o<e.length-1&&(e[o+1]!==to||o+2<e.length)&&(t+=Wl)}r=n===to})}return t}var QI=/^\*\*\/\*\.[\w\.-]+$/,JI=/^\*\*\/([\w\.-]+)\/?$/,XI=/^{\*\*\/\*?[\w\.-]+\/?(,\*\*\/\*?[\w\.-]+\/?)*}$/,YI=/^{\*\*\/\*?[\w\.-]+(\/(\*\*)?)?(,\*\*\/\*?[\w\.-]+(\/(\*\*)?)?)*}$/,ZI=/^\*\*((\/[\w\.-]+)+)\/?$/,ex=/^([\w\.-]+(\/[\w\.-]+)*)\/?$/,uh=new Sr(1e4),dh=function(){return!1},Nr=function(){return null};function Cd(i,t){if(!i)return Nr;let e;typeof i!="string"?e=i.pattern:e=i,e=e.trim();let r=t.ignoreCase??!1,n={...t,equals:r?Bt:(l,c)=>l===c,endsWith:r?Zp:(l,c)=>l.endsWith(c),isEqualOrParent:(l,c)=>$r(l,c,!Te||r)},o=`${r?e.toLowerCase():e}_${!!t.trimForExclusions}_${r}`,s=uh.get(o);if(s)return ph(s,i,n);let a;return QI.test(e)?s=tx(e.substring(4),e,n):(a=JI.exec(Rd(e,n)))?s=rx(a[1],e,n):(t.trimForExclusions?YI:XI).test(e)?s=nx(e,n):(a=ZI.exec(Rd(e,n)))?s=fh(a[1].substring(1),e,!0,n):(a=ex.exec(Rd(e,n)))?s=fh(a[1],e,!1,n):s=ix(e,n),uh.set(o,s),ph(s,i,n)}function ph(i,t,e){if(typeof t=="string")return i;let r=function(n,o){return e.isEqualOrParent(n,t.base)?i(Hc(n.substring(t.base.length),je),o):null};return r.allBasenames=i.allBasenames,r.allPaths=i.allPaths,r.basenames=i.basenames,r.patterns=i.patterns,r}function Rd(i,t){return t.trimForExclusions&&i.endsWith("/**")?i.substring(0,i.length-2):i}function tx(i,t,e){return function(r,n){return typeof r=="string"&&e.endsWith(r,i)?t:null}}function rx(i,t,e){let r=`/${i}`,n=`\\${i}`,o=function(a,l){return typeof a!="string"?null:l?e.equals(l,i)?t:null:e.equals(a,i)||e.endsWith(a,r)||e.endsWith(a,n)?t:null},s=[i];return o.basenames=s,o.patterns=[t],o.allBasenames=s,o}function nx(i,t){let e=hh(i.slice(1,-1).split(",").map(a=>Cd(a,t)).filter(a=>a!==Nr),i),r=e.length;if(!r)return Nr;if(r===1)return e[0];let n=function(a,l){for(let c=0,u=e.length;c<u;c++)if(e[c](a,l))return i;return null},o=e.find(a=>!!a.allBasenames);o&&(n.allBasenames=o.allBasenames);let s=e.reduce((a,l)=>l.allPaths?a.concat(l.allPaths):a,[]);return s.length&&(n.allPaths=s),n}function fh(i,t,e,r){let n=je===ce.sep,o=n?i:i.replace(HI,je),s=je+o,a=ce.sep+i,l;return e?l=function(c,u){return typeof c=="string"&&(r.equals(c,o)||r.endsWith(c,s)||!n&&(r.equals(c,i)||r.endsWith(c,a)))?t:null}:l=function(c,u){return typeof c=="string"&&(r.equals(c,o)||!n&&r.equals(c,i))?t:null},l.allPaths=[(e?"*/":"./")+i],l}function ix(i,t){try{let e=new RegExp(`^${mh(i)}$`,t.ignoreCase?"i":void 0);return function(r){return e.lastIndex=0,typeof r=="string"&&e.test(r)?i:null}}catch{return Nr}}function gh(i,t={}){if(!i)return dh;if(typeof i=="string"||ox(i)){let e=Cd(i,t);if(e===Nr)return dh;let r=function(n,o){return!!e(n,o)};return e.allBasenames&&(r.allBasenames=e.allBasenames),e.allPaths&&(r.allPaths=e.allPaths),r}return sx(i,t)}function ox(i){let t=i;return t?typeof t.base=="string"&&typeof t.pattern=="string":!1}function sx(i,t){let e=hh(Object.getOwnPropertyNames(i).map(a=>ax(a,i[a],t)).filter(a=>a!==Nr)),r=e.length;if(!r)return Nr;if(!e.some(a=>!!a.requiresSiblings)){if(r===1)return e[0];let a=function(u,p){let f;for(let g=0,v=e.length;g<v;g++){let h=e[g](u,p);if(typeof h=="string")return h;ga(h)&&(f||(f=[]),f.push(h))}return f?(async()=>{for(let g of f){let v=await g;if(typeof v=="string")return v}return null})():null},l=e.find(u=>!!u.allBasenames);l&&(a.allBasenames=l.allBasenames);let c=e.reduce((u,p)=>p.allPaths?u.concat(p.allPaths):u,[]);return c.length&&(a.allPaths=c),a}let n=function(a,l,c){let u,p;for(let f=0,g=e.length;f<g;f++){let v=e[f];v.requiresSiblings&&c&&(l||(l=nt(a)),u||(u=l.substring(0,l.length-jc(a).length)));let h=v(a,l,u,c);if(typeof h=="string")return h;ga(h)&&(p||(p=[]),p.push(h))}return p?(async()=>{for(let f of p){let g=await f;if(typeof g=="string")return g}return null})():null},o=e.find(a=>!!a.allBasenames);o&&(n.allBasenames=o.allBasenames);let s=e.reduce((a,l)=>l.allPaths?a.concat(l.allPaths):a,[]);return s.length&&(n.allPaths=s),n}function ax(i,t,e){if(t===!1)return Nr;let r=Cd(i,e);if(r===Nr)return Nr;if(typeof t=="boolean")return r;if(t){let n=t.when;if(typeof n=="string"){let o=(s,a,l,c)=>{if(!c||!r(s,a))return null;let u=n.replace("$(basename)",()=>l),p=c(u);return ga(p)?p.then(f=>f?i:null):p?i:null};return o.requiresSiblings=!0,o}}return r}function hh(i,t){let e=i.filter(a=>!!a.basenames);if(e.length<2)return i;let r=e.reduce((a,l)=>{let c=l.basenames;return c?a.concat(c):a},[]),n;if(t){n=[];for(let a=0,l=r.length;a<l;a++)n.push(t)}else n=e.reduce((a,l)=>{let c=l.patterns;return c?a.concat(c):a},[]);let o=function(a,l){if(typeof a!="string")return null;if(!l){let u;for(u=a.length;u>0;u--){let p=a.charCodeAt(u-1);if(p===47||p===92)break}l=a.substring(u)}let c=r.indexOf(l);return c!==-1?n[c]:null};o.basenames=r,o.patterns=n,o.allBasenames=r;let s=i.filter(a=>!a.basenames);return s.push(o),s}function _d(i,t){return xr(i,t,(e,r)=>typeof e=="string"&&typeof r=="string"?e===r:typeof e!="string"&&typeof r!="string"?e.base===r.base&&e.pattern===r.pattern:!1)}function zl(i){return typeof i.correlationId=="number"}function vh(i){return i.recursive===!0}var Gl=class i extends _{constructor(e,r,n,o){super();this.onFileChanges=e;this.onLogMessage=r;this.verboseLogging=n;this.options=o;this.watcherDisposables=this._register(new Zt);this.requests=void 0;this.restartCounter=0}static{this.MAX_RESTARTS=5}init(){let e=new Pe;this.watcherDisposables.value=e,this.watcher=this.createWatcher(e),this.watcher.setVerboseLogging(this.verboseLogging),e.add(this.watcher.onDidChangeFile(r=>this.onFileChanges(r))),e.add(this.watcher.onDidLogMessage(r=>this.onLogMessage(r))),e.add(this.watcher.onDidError(r=>this.onError(r.error,r.request)))}onError(e,r){this.canRestart(e,r)?this.restartCounter<i.MAX_RESTARTS&&this.requests?(this.error(`restarting watcher after unexpected error: ${e}`),this.restart(this.requests)):this.error(`gave up attempting to restart watcher after unexpected error: ${e}`):this.error(e)}canRestart(e,r){return!(!this.options.restartOnError||r||e.indexOf("No space left on device")!==-1||e.indexOf("EMFILE")!==-1)}restart(e){this.restartCounter++,this.init(),this.watch(e)}async watch(e){this.requests=e,await this.watcher?.watch(e)}async setVerboseLogging(e){this.verboseLogging=e,await this.watcher?.setVerboseLogging(e)}error(e){this.onLogMessage({type:"error",message:`[File Watcher (${this.options.type})] ${e}`})}trace(e){this.onLogMessage({type:"trace",message:`[File Watcher (${this.options.type})] ${e}`})}dispose(){return this.watcher=void 0,super.dispose()}},ql=class extends Gl{constructor(t,e,r){super(t,e,r,{type:"node.js",restartOnError:!1})}},Kl=class extends Gl{constructor(t,e,r){super(t,e,r,{type:"universal",restartOnError:!0})}};function Dd(i){return i.map(t=>({type:t.type,resource:P.revive(t.resource),cId:t.cId}))}function yh(i){let t=new kd;for(let e of i)t.processEvent(e);return t.coalesce()}function lx(i,t){return typeof t=="string"&&!t.startsWith(to)&&!pi(t)?{base:i,pattern:t}:t}function Ld(i,t,e){let r=[];for(let n of t)r.push(gh(lx(i,n),{ignoreCase:e}));return r}var kd=class{constructor(){this.coalesced=new Set;this.mapPathToChange=new Map}toKey(t){return Te?t.resource.fsPath:t.resource.fsPath.toLowerCase()}processEvent(t){let e=this.mapPathToChange.get(this.toKey(t)),r=!1;if(e){let n=e.type,o=t.type;e.resource.fsPath!==t.resource.fsPath&&(t.type===2||t.type===1)?r=!0:n===1&&o===2?(this.mapPathToChange.delete(this.toKey(t)),this.coalesced.delete(e)):n===2&&o===1?e.type=0:n===1&&o===0||(e.type=o)}else r=!0;r&&(this.coalesced.add(t),this.mapPathToChange.set(this.toKey(t),t))}coalesce(){let t=[],e=[];return Array.from(this.coalesced).filter(r=>r.type!==2?(t.push(r),!1):!0).sort((r,n)=>r.resource.fsPath.length-n.resource.fsPath.length).filter(r=>e.some(n=>sm(r.resource.fsPath,n,!Te))?!1:(e.push(r.resource.fsPath),!0)).concat(t)}};function Ih(i,t){if(typeof t=="number")switch(i.type){case 1:return(t&4)===0;case 2:return(t&8)===0;case 0:return(t&2)===0}return!1}function xh(i){if(typeof i=="number"){let t=[];return i&4&&t.push("Added"),i&8&&t.push("Deleted"),i&2&&t.push("Updated"),t.length===0?"<all>":`[${t.join(", ")}]`}return"<none>"}var $l=class extends _{constructor(e,r){super();this.logService=e;this.options=r;this._onDidChangeFile=this._register(new R);this.onDidChangeFile=this._onDidChangeFile.event;this._onDidWatchError=this._register(new R);this.onDidWatchError=this._onDidWatchError.event;this.universalWatchRequests=[];this.universalWatchRequestDelayer=this._register(new _t(this.getRefreshWatchersDelay(this.universalWatchRequests.length)));this.nonRecursiveWatchRequests=[];this.nonRecursiveWatchRequestDelayer=this._register(new _t(this.getRefreshWatchersDelay(this.nonRecursiveWatchRequests.length)))}watch(e,r){return r.recursive||this.options?.watcher?.forceUniversal?this.watchUniversal(e,r):this.watchNonRecursive(e,r)}getRefreshWatchersDelay(e){return e>200?500:0}watchUniversal(e,r){let n=this.toWatchRequest(e,r),o=Pc(this.universalWatchRequests,n);return this.refreshUniversalWatchers(),ue(()=>{o(),this.refreshUniversalWatchers()})}toWatchRequest(e,r){let n={path:this.toWatchPath(e),excludes:r.excludes,includes:r.includes,recursive:r.recursive,filter:r.filter,correlationId:r.correlationId};if(vh(n)){let o=this.options?.watcher?.recursive?.usePolling;o===!0?n.pollingInterval=this.options?.watcher?.recursive?.pollingInterval??5e3:Array.isArray(o)&&o.includes(n.path)&&(n.pollingInterval=this.options?.watcher?.recursive?.pollingInterval??5e3)}return n}refreshUniversalWatchers(){this.universalWatchRequestDelayer.trigger(()=>this.doRefreshUniversalWatchers(),this.getRefreshWatchersDelay(this.universalWatchRequests.length)).catch(e=>Ke(e))}doRefreshUniversalWatchers(){return this.universalWatcher||(this.universalWatcher=this._register(this.createUniversalWatcher(e=>this._onDidChangeFile.fire(Dd(e)),e=>this.onWatcherLogMessage(e),this.logService.getLevel()===1)),this._register(this.logService.onDidChangeLogLevel(()=>{this.universalWatcher?.setVerboseLogging(this.logService.getLevel()===1)}))),this.universalWatcher.watch(this.universalWatchRequests)}watchNonRecursive(e,r){let n={path:this.toWatchPath(e),excludes:r.excludes,includes:r.includes,recursive:!1,filter:r.filter,correlationId:r.correlationId},o=Pc(this.nonRecursiveWatchRequests,n);return this.refreshNonRecursiveWatchers(),ue(()=>{o(),this.refreshNonRecursiveWatchers()})}refreshNonRecursiveWatchers(){this.nonRecursiveWatchRequestDelayer.trigger(()=>this.doRefreshNonRecursiveWatchers(),this.getRefreshWatchersDelay(this.nonRecursiveWatchRequests.length)).catch(e=>Ke(e))}doRefreshNonRecursiveWatchers(){return this.nonRecursiveWatcher||(this.nonRecursiveWatcher=this._register(this.createNonRecursiveWatcher(e=>this._onDidChangeFile.fire(Dd(e)),e=>this.onWatcherLogMessage(e),this.logService.getLevel()===1)),this._register(this.logService.onDidChangeLogLevel(()=>{this.nonRecursiveWatcher?.setVerboseLogging(this.logService.getLevel()===1)}))),this.nonRecursiveWatcher.watch(this.nonRecursiveWatchRequests)}onWatcherLogMessage(e){e.type==="error"&&this._onDidWatchError.fire(e.message),this.logWatcherMessage(e)}logWatcherMessage(e){this.logService[e.type](e.message)}toFilePath(e){return Wt(e.fsPath)}toWatchPath(e){let r=this.toFilePath(e);return of(r)}};function bh(i){switch(i){case 100:return"req";case 101:return"cancel";case 102:return"subscribe";case 103:return"unsubscribe"}}function Sh(i){switch(i){case 200:return"init";case 201:return"reply:";case 202:case 203:return"replyErr:";case 204:return"event:"}}function ro(i){let t=0;for(let e=0;;e+=7){let r=i.read(1);if(t|=(r.buffer[0]&127)<<e,!(r.buffer[0]&128))return t}}var cx=wn(0);function no(i,t){if(t===0){i.write(cx);return}let e=0;for(let n=t;n!==0;n=n>>>7)e++;let r=U.alloc(e);for(let n=0;t!==0;n++)r.buffer[n]=t&127,t=t>>>7,t>0&&(r.buffer[n]|=128);i.write(r)}var Ad=class{constructor(t){this.buffer=t;this.pos=0}read(t){let e=this.buffer.slice(this.pos,this.pos+t);return this.pos+=e.byteLength,e}},Ud=class{constructor(){this.buffers=[]}get buffer(){return U.concat(this.buffers)}write(t){this.buffers.push(t)}};function wn(i){let t=U.alloc(1);return t.writeUInt8(i,0),t}var Qn={Undefined:wn(0),String:wn(1),Buffer:wn(2),VSBuffer:wn(3),Array:wn(4),Object:wn(5),Uint:wn(6)};function Md(i,t){if(typeof t>"u")i.write(Qn.Undefined);else if(typeof t=="string"){let e=U.fromString(t);i.write(Qn.String),no(i,e.byteLength),i.write(e)}else if(U.isNativeBuffer(t)){let e=U.wrap(t);i.write(Qn.Buffer),no(i,e.byteLength),i.write(e)}else if(t instanceof U)i.write(Qn.VSBuffer),no(i,t.byteLength),i.write(t);else if(Array.isArray(t)){i.write(Qn.Array),no(i,t.length);for(let e of t)Md(i,e)}else if(typeof t=="number"&&(t|0)===t)i.write(Qn.Uint),no(i,t);else{let e=U.fromString(JSON.stringify(t));i.write(Qn.Object),no(i,e.byteLength),i.write(e)}}function Fd(i){switch(i.read(1).readUInt8(0)){case 0:return;case 1:return i.read(ro(i)).toString();case 2:return i.read(ro(i)).buffer;case 3:return i.read(ro(i));case 4:{let e=ro(i),r=[];for(let n=0;n<e;n++)r.push(Fd(i));return r}case 5:return JSON.parse(i.read(ro(i)).toString());case 6:return ro(i)}}var Ps=class{constructor(t,e=null){this.protocol=t;this.isDisposed=!1;this.state=0;this.activeRequests=new Set;this.handlers=new Map;this.lastRequestId=0;this._onDidInitialize=new R;this.onDidInitialize=this._onDidInitialize.event;this.protocolListener=this.protocol.onMessage(r=>this.onBuffer(r)),this.logger=e}getChannel(t){let e=this;return{call(r,n,o){return e.isDisposed?Promise.reject(new Ie):e.requestPromise(t,r,n,o)},listen(r,n){return e.isDisposed?J.None:e.requestEvent(t,r,n)}}}requestPromise(t,e,r,n=re.None){let o=this.lastRequestId++,a={id:o,type:100,channelName:t,name:e,arg:r};if(n.isCancellationRequested)return Promise.reject(new Ie);let l,c;return new Promise((p,f)=>{if(n.isCancellationRequested)return f(new Ie);let g=()=>{let y=E=>{switch(E.type){case 201:this.handlers.delete(o),p(E.data);break;case 202:{this.handlers.delete(o);let b=new Error(E.data.message);b.stack=Array.isArray(E.data.stack)?E.data.stack.join(`
`):E.data.stack,b.name=E.data.name,f(b);break}case 203:this.handlers.delete(o),f(E.data);break}};this.handlers.set(o,y),this.sendRequest(a)},v=null;this.state===1?g():(v=Ht(y=>this.whenInitialized()),v.then(()=>{v=null,g()}));let h=()=>{v?(v.cancel(),v=null):this.sendRequest({id:o,type:101}),f(new Ie)};l=n.onCancellationRequested(h),c={dispose:qs(()=>{h(),l.dispose()})},this.activeRequests.add(c)}).finally(()=>{l?.dispose(),this.activeRequests.delete(c)})}requestEvent(t,e,r){let n=this.lastRequestId++,s={id:n,type:102,channelName:t,name:e,arg:r},a=null,l=new R({onWillAddFirstListener:()=>{let u=()=>{this.activeRequests.add(l),this.sendRequest(s)};this.state===1?u():(a=Ht(p=>this.whenInitialized()),a.then(()=>{a=null,u()}))},onDidRemoveLastListener:()=>{a?(a.cancel(),a=null):(this.activeRequests.delete(l),this.sendRequest({id:n,type:103})),this.handlers.delete(n)}}),c=u=>l.fire(u.data);return this.handlers.set(n,c),l.event}sendRequest(t){switch(t.type){case 100:case 102:{let e=this.send([t.type,t.id,t.channelName,t.name],t.arg);this.logger?.logOutgoing(e,t.id,0,`${bh(t.type)}: ${t.channelName}.${t.name}`,t.arg);return}case 101:case 103:{let e=this.send([t.type,t.id]);this.logger?.logOutgoing(e,t.id,0,bh(t.type));return}}}send(t,e=void 0){let r=new Ud;return Md(r,t),Md(r,e),this.sendBuffer(r.buffer)}sendBuffer(t){try{return this.protocol.send(t),t.byteLength}catch{return 0}}onBuffer(t){let e=new Ad(t),r=Fd(e),n=Fd(e),o=r[0];switch(o){case 200:return this.logger?.logIncoming(t.byteLength,0,0,Sh(o)),this.onResponse({type:r[0]});case 201:case 202:case 204:case 203:return this.logger?.logIncoming(t.byteLength,r[1],0,Sh(o),n),this.onResponse({type:r[0],id:r[1],data:n})}}onResponse(t){if(t.type===200){this.state=1,this._onDidInitialize.fire();return}this.handlers.get(t.id)?.(t)}get onDidInitializePromise(){return J.toPromise(this.onDidInitialize)}whenInitialized(){return this.state===1?Promise.resolve():this.onDidInitializePromise}dispose(){this.isDisposed=!0,this.protocolListener&&(this.protocolListener.dispose(),this.protocolListener=null),dt(this.activeRequests.values()),this.activeRequests.clear(),this._onDidInitialize.dispose()}};T([ge],Ps.prototype,"onDidInitializePromise",1);function Eh(i){let t=!1;return{call(e,r,n){return t?i.call(e,r,n):Hr(0).then(()=>t=!0).then(()=>i.call(e,r,n))},listen(e,r){if(t)return i.listen(e,r);let n=new Xs;return Hr(0).then(()=>t=!0).then(()=>n.input=i.listen(e,r)),n.event}}}var Od;(n=>{function i(o,s,a){let l=o,c=a?.disableMarshalling,u=new Map;for(let p in l)e(p)&&u.set(p,J.buffer(l[p],!0,void 0,s));return new class{listen(p,f,g){let v=u.get(f);if(v)return v;let h=l[f];if(typeof h=="function"){if(r(f))return h.call(l,g);if(e(f))return u.set(f,J.buffer(l[f],!0,void 0,s)),u.get(f)}throw new Ir(`Event not found: ${f}`)}call(p,f,g){let v=l[f];if(typeof v=="function"){if(!c&&Array.isArray(g))for(let y=0;y<g.length;y++)g[y]=bn(g[y]);let h=v.apply(l,g);return h instanceof Promise||(h=Promise.resolve(h)),h}throw new Ir(`Method not found: ${f}`)}}}n.fromService=i;function t(o,s){let a=s?.disableMarshalling;return new Proxy({},{get(l,c){if(typeof c=="string")return s?.properties?.has(c)?s.properties.get(c):r(c)?function(u){return o.listen(c,u)}:e(c)?o.listen(c):async function(...u){let p;s&&!Oe(s.context)?p=[s.context,...u]:p=u;let f=await o.call(c,p);return a?f:bn(f)};throw new Ir(`Property not found: ${String(c)}`)}})}n.toService=t;function e(o){return o[0]==="o"&&o[1]==="n"&&Qc(o.charCodeAt(2))}function r(o){return/^onDynamic/.test(o)&&Qc(o.charCodeAt(9))}})(Od||={});import{fork as mx}from"child_process";function wh(i){let t=i;return t&&typeof t.type=="string"&&typeof t.severity=="string"}function ux(i){let t=[],e;try{let r=JSON.parse(i.arguments),n=r[r.length-1];n&&n.__$stack&&(r.pop(),e=n.__$stack),t.push(...r)}catch{t.push("Unable to log remote console arguments",i.arguments)}return{args:t,stack:e}}function dx(i){if(!i)return i;let t=i.indexOf(`
`);return t===-1?i:i.substring(0,t)}function Ph(i,t){let{args:e,stack:r}=ux(i),n=typeof e[0]=="string"&&e.length===1,o=dx(r);o&&(o=`(${o.trim()})`);let s=[];if(typeof e[0]=="string"?o&&n?s=[`%c[${t}] %c${e[0]} %c${o}`,io("blue"),io(""),io("grey")]:s=[`%c[${t}] %c${e[0]}`,io("blue"),io(""),...e.slice(1)]:s=[`%c[${t}]%`,io("blue"),...e],o&&!n&&s.push(o),typeof console[i.severity]!="function")throw new Error("Unknown console method");console[i.severity].apply(console,s)}function io(i){return`color: ${i}`}import*as px from"child_process";import{promises as b6}from"fs";function Th(i){i&&(delete i.DEBUG,Te&&delete i.LD_PRELOAD)}function Rh(i=Ot){return i.comspec||"cmd.exe"}function Ch(i){let t=[],e=!1,r=function(n){if(e){t.push(n);return}(!i.send(n,s=>{if(s&&console.error(s),e=!1,t.length>0){let a=t.slice(0);t=[],a.forEach(l=>r(l))}})||pe)&&(e=!0)};return{send:r}}var jl=class{constructor(t,e){this.modulePath=t;this.options=e;this.activeRequests=new Set;this.channels=new Map;this._onDidProcessExit=new R;this.onDidProcessExit=this._onDidProcessExit.event;let r=e.timeout||6e4;this.disposeDelayer=new No(r),this.child=null,this._client=null}getChannel(t){let e=this;return{call(r,n,o){return e.requestPromise(t,r,n,o)},listen(r,n){return e.requestEvent(t,r,n)}}}requestPromise(t,e,r,n=re.None){if(!this.disposeDelayer)return Promise.reject(new Error("disposed"));if(n.isCancellationRequested)return Promise.reject(Bs());this.disposeDelayer.cancel();let o=this.getCachedChannel(t),s=Ht(c=>o.call(e,r,c)),a=n.onCancellationRequested(()=>s.cancel()),l=ue(()=>s.cancel());return this.activeRequests.add(l),s.finally(()=>{a.dispose(),this.activeRequests.delete(l),this.activeRequests.size===0&&this.disposeDelayer&&this.disposeDelayer.trigger(()=>this.disposeClient())}),s}requestEvent(t,e,r){if(!this.disposeDelayer)return J.None;this.disposeDelayer.cancel();let n,o=new R({onWillAddFirstListener:()=>{n=this.getCachedChannel(t).listen(e,r)(o.fire,o),this.activeRequests.add(n)},onDidRemoveLastListener:()=>{this.activeRequests.delete(n),n.dispose(),this.activeRequests.size===0&&this.disposeDelayer&&this.disposeDelayer.trigger(()=>this.disposeClient())}});return o.event}get client(){if(!this._client){let t=this.options.args||[],e=Object.create(null);e.env={...tr(process.env),VSCODE_PARENT_PID:String(process.pid)},this.options.env&&(e.env={...e.env,...this.options.env}),this.options.freshExecArgv&&(e.execArgv=[]),typeof this.options.debug=="number"&&(e.execArgv=["--nolazy","--inspect="+this.options.debug]),typeof this.options.debugBrk=="number"&&(e.execArgv=["--nolazy","--inspect-brk="+this.options.debugBrk]),e.execArgv===void 0&&(e.execArgv=process.execArgv.filter(p=>!/^--inspect(-brk)?=/.test(p)).filter(p=>!p.startsWith("--vscode-"))),Th(e.env),this.child=mx(this.modulePath,t,e);let r=new R,o=J.fromNodeEventEmitter(this.child,"message",p=>p)(p=>{if(wh(p)){Ph(p,`IPC Library: ${this.options.serverName}`);return}r.fire(U.wrap(Buffer.from(p,"base64")))}),s=this.options.useQueue?Ch(this.child):this.child,a=p=>this.child?.connected&&s.send(p.buffer.toString("base64")),l=r.event,c={send:a,onMessage:l};this._client=new Ps(c);let u=()=>this.disposeClient();process.once("exit",u),this.child.on("error",p=>console.warn('IPC "'+this.options.serverName+'" errored with '+p)),this.child.on("exit",(p,f)=>{process.removeListener("exit",u),o.dispose(),this.activeRequests.forEach(g=>dt(g)),this.activeRequests.clear(),p!==0&&f!=="SIGTERM"&&console.warn('IPC "'+this.options.serverName+'" crashed with exit code '+p+" and signal "+f),this.disposeDelayer?.cancel(),this.disposeClient(),this._onDidProcessExit.fire({code:p,signal:f})})}return this._client}getCachedChannel(t){let e=this.channels.get(t);return e||(e=this.client.getChannel(t),this.channels.set(t,e)),e}disposeClient(){this._client&&(this.child&&(this.child.kill(),this.child=null),this._client=null,this.channels.clear())}dispose(){this._onDidProcessExit.dispose(),this.disposeDelayer?.cancel(),this.disposeDelayer=void 0,this.disposeClient(),this.activeRequests.clear()}};var Hl=class extends Kl{constructor(t,e,r){super(t,e,r),this.init()}createWatcher(t){let e=t.add(new jl(_r.asFileUri("bootstrap-fork").fsPath,{serverName:"File Watcher",args:["--type=fileWatcher"],env:{VSCODE_ESM_ENTRYPOINT:"vs/platform/files/node/watcher/watcherMain",VSCODE_PIPE_LOGGING:"true",VSCODE_VERBOSE_LOGGING:"true"}}));return t.add(e.onDidProcessExit(({code:r,signal:n})=>this.onError(`terminated by itself with code ${r}, signal: ${n} (ETERM)`))),Od.toService(Eh(e.getChannel("watcher")))}};import{watchFile as gx,unwatchFile as hx}from"fs";var Ql=class extends _{constructor(){super();this._onDidChangeFile=this._register(new R);this.onDidChangeFile=this._onDidChangeFile.event;this._onDidLogMessage=this._register(new R);this.onDidLogMessage=this._onDidLogMessage.event;this._onDidWatchFail=this._register(new R);this.onDidWatchFail=this._onDidWatchFail.event;this.correlatedWatchRequests=new Map;this.nonCorrelatedWatchRequests=new Map;this.suspendedWatchRequests=this._register(new wr);this.suspendedWatchRequestsWithPolling=new Set;this.updateWatchersDelayer=this._register(new _t(this.getUpdateWatchersDelay()));this.suspendedWatchRequestPollingInterval=5007;this.joinWatch=new fn;this.verboseLogging=!1;this._register(this.onDidWatchFail(e=>this.suspendWatchRequest({id:this.computeId(e),correlationId:this.isCorrelated(e)?e.correlationId:void 0,path:e.path})))}isCorrelated(e){return zl(e)}computeId(e){return this.isCorrelated(e)?e.correlationId:ur(e)}async watch(e){this.joinWatch.isSettled||this.joinWatch.complete(),this.joinWatch=new fn;try{this.correlatedWatchRequests.clear(),this.nonCorrelatedWatchRequests.clear();for(let r of e)this.isCorrelated(r)?this.correlatedWatchRequests.set(r.correlationId,r):this.nonCorrelatedWatchRequests.set(this.computeId(r),r);for(let[r]of this.suspendedWatchRequests)!this.nonCorrelatedWatchRequests.has(r)&&!this.correlatedWatchRequests.has(r)&&(this.suspendedWatchRequests.deleteAndDispose(r),this.suspendedWatchRequestsWithPolling.delete(r));return await this.updateWatchers(!1)}finally{this.joinWatch.complete()}}updateWatchers(e){let r=[];for(let[n,o]of[...this.nonCorrelatedWatchRequests,...this.correlatedWatchRequests])this.suspendedWatchRequests.has(n)||r.push(o);return this.updateWatchersDelayer.trigger(()=>this.doWatch(r),e?this.getUpdateWatchersDelay():0).catch(n=>Ke(n))}getUpdateWatchersDelay(){return 800}isSuspended(e){let r=this.computeId(e);return this.suspendedWatchRequestsWithPolling.has(r)?"polling":this.suspendedWatchRequests.has(r)}async suspendWatchRequest(e){if(this.suspendedWatchRequests.has(e.id))return;let r=new Pe;this.suspendedWatchRequests.set(e.id,r),await this.joinWatch.p,!r.isDisposed&&(this.monitorSuspendedWatchRequest(e,r),this.updateWatchers(!0))}resumeWatchRequest(e){this.suspendedWatchRequests.deleteAndDispose(e.id),this.suspendedWatchRequestsWithPolling.delete(e.id),this.updateWatchers(!1)}monitorSuspendedWatchRequest(e,r){this.doMonitorWithExistingWatcher(e,r)?(this.trace(`reusing an existing recursive watcher to monitor ${e.path}`),this.suspendedWatchRequestsWithPolling.delete(e.id)):(this.doMonitorWithNodeJS(e,r),this.suspendedWatchRequestsWithPolling.add(e.id))}doMonitorWithExistingWatcher(e,r){let n=this.recursiveWatcher?.subscribe(e.path,(o,s)=>{r.isDisposed||(o?this.monitorSuspendedWatchRequest(e,r):s?.type===1&&this.onMonitoredPathAdded(e))});return n?(r.add(n),!0):!1}doMonitorWithNodeJS(e,r){let n=!1,o=(s,a)=>{if(r.isDisposed)return;let l=this.isPathNotFound(s),c=this.isPathNotFound(a),u=n;n=l,!l&&(c||u)&&this.onMonitoredPathAdded(e)};this.trace(`starting fs.watchFile() on ${e.path} (correlationId: ${e.correlationId})`);try{gx(e.path,{persistent:!1,interval:this.suspendedWatchRequestPollingInterval},o)}catch(s){this.warn(`fs.watchFile() failed with error ${s} on path ${e.path} (correlationId: ${e.correlationId})`)}r.add(ue(()=>{this.trace(`stopping fs.watchFile() on ${e.path} (correlationId: ${e.correlationId})`);try{hx(e.path,o)}catch(s){this.warn(`fs.unwatchFile() failed with error ${s} on path ${e.path} (correlationId: ${e.correlationId})`)}}))}onMonitoredPathAdded(e){this.trace(`detected ${e.path} exists again, resuming watcher (correlationId: ${e.correlationId})`);let r={resource:P.file(e.path),type:1,cId:e.correlationId};this._onDidChangeFile.fire([r]),this.traceEvent(r,e),this.resumeWatchRequest(e)}isPathNotFound(e){return e.ctimeMs===0&&e.ino===0}async stop(){this.suspendedWatchRequests.clearAndDisposeAll(),this.suspendedWatchRequestsWithPolling.clear()}traceEvent(e,r){if(this.verboseLogging){let n=` >> normalized ${e.type===1?"[ADDED]":e.type===2?"[DELETED]":"[CHANGED]"} ${e.resource.fsPath}`;this.traceWithCorrelation(n,r)}}traceWithCorrelation(e,r){this.verboseLogging&&this.trace(`${e}${typeof r.correlationId=="number"?` <${r.correlationId}> `:""}`)}requestToString(e){return`${e.path} (excludes: ${e.excludes.length>0?e.excludes:"<none>"}, includes: ${e.includes&&e.includes.length>0?JSON.stringify(e.includes):"<all>"}, filter: ${xh(e.filter)}, correlationId: ${typeof e.correlationId=="number"?e.correlationId:"<none>"})`}async setVerboseLogging(e){this.verboseLogging=e}};import{watch as vx,promises as yx}from"fs";var Jl=class i extends _{constructor(e,r,n,o,s,a){super();this.request=e;this.recursiveWatcher=r;this.onDidFilesChange=n;this.onDidWatchFail=o;this.onLogMessage=s;this.verboseLogging=a;this.throttledFileChangesEmitter=this._register(new vi({maxWorkChunkSize:100,throttleDelay:200,maxBufferedWork:1e4},e=>this.onDidFilesChange(e)));this.fileChangesAggregator=this._register(new fa(e=>this.handleFileChanges(e),i.FILE_CHANGES_HANDLER_DELAY));this.cts=new pt;this.realPath=new Ct(async()=>{let e=this.request.path;try{e=await ie.realpath(this.request.path),this.request.path!==e&&this.trace(`correcting a path to watch that seems to be a symbolic link (original: ${this.request.path}, real: ${e})`)}catch{}return e});this._isReusingRecursiveWatcher=!1;this.didFail=!1;let l=!Te;this.excludes=Ld(this.request.path,this.request.excludes,l),this.includes=this.request.includes?Ld(this.request.path,this.request.includes,l):void 0,this.filter=zl(this.request)?this.request.filter:void 0,this.ready=this.watch()}static{this.FILE_DELETE_HANDLER_DELAY=100}static{this.FILE_CHANGES_HANDLER_DELAY=75}get isReusingRecursiveWatcher(){return this._isReusingRecursiveWatcher}get failed(){return this.didFail}async watch(){try{let e=await yx.stat(this.request.path);if(this.cts.token.isCancellationRequested)return;this._register(await this.doWatch(e.isDirectory()))}catch(e){e.code!=="ENOENT"?this.error(e):this.trace(`ignoring a path for watching who's stat info failed to resolve: ${this.request.path} (error: ${e})`),this.notifyWatchFailed()}}notifyWatchFailed(){this.didFail=!0,this.onDidWatchFail?.()}async doWatch(e){let r=new Pe;return this.doWatchWithExistingWatcher(e,r)?(this.trace(`reusing an existing recursive watcher for ${this.request.path}`),this._isReusingRecursiveWatcher=!0):(this._isReusingRecursiveWatcher=!1,await this.doWatchWithNodeJS(e,r)),r}doWatchWithExistingWatcher(e,r){if(e)return!1;let n=P.file(this.request.path),o=this.recursiveWatcher?.subscribe(this.request.path,async(s,a)=>{r.isDisposed||(s?await Tp(this.doWatch(e),r):a&&(typeof a.cId=="number"||typeof this.request.correlationId=="number")&&this.onFileChange({resource:n,type:a.type,cId:this.request.correlationId},!0))});return o?(r.add(o),!0):!1}async doWatchWithNodeJS(e,r){let n=await this.realPath.value;if(this.cts.token.isCancellationRequested)return;if(ft&&$r(n,"/Volumes/",!0)){this.error(`Refusing to watch ${n} for changes using fs.watch() for possibly being a network share where watching is unreliable and unstable.`);return}let o=new pt(this.cts.token);r.add(ue(()=>o.dispose(!0)));let s=new Pe;r.add(s);try{let a=P.file(this.request.path),l=nt(n),c=vx(n);s.add(ue(()=>{c.removeAllListeners(),c.close()})),this.trace(`Started watching: '${n}'`);let u=new Set;if(e)try{for(let f of await ie.readdir(n))u.add(f)}catch(f){this.error(f)}if(o.token.isCancellationRequested)return;let p=new Map;s.add(ue(()=>{for(let[,f]of p)f.dispose();p.clear()})),c.on("error",(f,g)=>{o.token.isCancellationRequested||(this.error(`Failed to watch ${n} for changes using fs.watch() (${f}, ${g})`),this.notifyWatchFailed())}),c.on("change",(f,g)=>{if(o.token.isCancellationRequested)return;this.verboseLogging&&this.traceWithCorrelation(`[raw] ["${f}"] ${g}`);let v="";if(g&&(v=g.toString(),ft&&(v=vs(v))),!(!v||f!=="change"&&f!=="rename"))if(e)if(f==="rename"){p.get(v)?.dispose();let h=setTimeout(async()=>{if(p.delete(v),mi(v,l,!Te)&&!await ie.exists(n)){this.onWatchedPathDeleted(a);return}if(o.token.isCancellationRequested)return;let y=await this.existsChildStrictCase(q(n,v));if(o.token.isCancellationRequested)return;let E;y?u.has(v)?E=0:(E=1,u.add(v)):(u.delete(v),E=2),this.onFileChange({resource:z(a,v),type:E,cId:this.request.correlationId})},i.FILE_DELETE_HANDLER_DELAY);p.set(v,ue(()=>clearTimeout(h)))}else{let h;u.has(v)?h=0:(h=1,u.add(v)),this.onFileChange({resource:z(a,v),type:h,cId:this.request.correlationId})}else if(f==="rename"||!mi(v,l,!Te)){let h=setTimeout(async()=>{let y=await ie.exists(n);o.token.isCancellationRequested||(y?(this.onFileChange({resource:a,type:0,cId:this.request.correlationId},!0),s.add(await this.doWatch(!1))):this.onWatchedPathDeleted(a))},i.FILE_DELETE_HANDLER_DELAY);s.clear(),s.add(ue(()=>clearTimeout(h)))}else this.onFileChange({resource:a,type:0,cId:this.request.correlationId},!0)})}catch(a){if(o.token.isCancellationRequested)return;this.error(`Failed to watch ${n} for changes using fs.watch() (${a.toString()})`),this.notifyWatchFailed()}}onWatchedPathDeleted(e){this.warn("Watcher shutdown because watched path got deleted"),this.onFileChange({resource:e,type:2,cId:this.request.correlationId},!0),this.fileChangesAggregator.flush(),this.notifyWatchFailed()}onFileChange(e,r=!1){this.cts.token.isCancellationRequested||(this.verboseLogging&&this.traceWithCorrelation(`${e.type===1?"[ADDED]":e.type===2?"[DELETED]":"[CHANGED]"} ${e.resource.fsPath}`),!r&&this.excludes.some(n=>n(e.resource.fsPath))?this.verboseLogging&&this.traceWithCorrelation(` >> ignored (excluded) ${e.resource.fsPath}`):!r&&this.includes&&this.includes.length>0&&!this.includes.some(n=>n(e.resource.fsPath))?this.verboseLogging&&this.traceWithCorrelation(` >> ignored (not included) ${e.resource.fsPath}`):this.fileChangesAggregator.work(e))}handleFileChanges(e){let r=yh(e),n=[];for(let s of r){if(Ih(s,this.filter)){this.verboseLogging&&this.traceWithCorrelation(` >> ignored (filtered) ${s.resource.fsPath}`);continue}n.push(s)}if(n.length===0)return;if(this.verboseLogging)for(let s of n)this.traceWithCorrelation(` >> normalized ${s.type===1?"[ADDED]":s.type===2?"[DELETED]":"[CHANGED]"} ${s.resource.fsPath}`);this.throttledFileChangesEmitter.work(n)?this.throttledFileChangesEmitter.pending>0&&this.trace(`started throttling events due to large amount of file change events at once (pending: ${this.throttledFileChangesEmitter.pending}, most recent change: ${n[0].resource.fsPath}). Use 'files.watcherExclude' setting to exclude folders with lots of changing files (e.g. compilation output).`):this.warn(`started ignoring events due to too many file change events at once (incoming: ${n.length}, most recent change: ${n[0].resource.fsPath}). Use 'files.watcherExclude' setting to exclude folders with lots of changing files (e.g. compilation output).`)}async existsChildStrictCase(e){if(Te)return ie.exists(e);try{let r=nt(e);return(await ie.readdir(Rt(e))).some(o=>o===r)}catch(r){return this.trace(r),!1}}setVerboseLogging(e){this.verboseLogging=e}error(e){this.cts.token.isCancellationRequested||this.onLogMessage?.({type:"error",message:`[File Watcher (node.js)] ${e}`})}warn(e){this.cts.token.isCancellationRequested||this.onLogMessage?.({type:"warn",message:`[File Watcher (node.js)] ${e}`})}trace(e){!this.cts.token.isCancellationRequested&&this.verboseLogging&&this.onLogMessage?.({type:"trace",message:`[File Watcher (node.js)] ${e}`})}traceWithCorrelation(e){!this.cts.token.isCancellationRequested&&this.verboseLogging&&this.trace(`${e}${typeof this.request.correlationId=="number"?` <${this.request.correlationId}> `:""}`)}dispose(){this.cts.dispose(!0),super.dispose()}};var Xl=class extends Ql{constructor(e){super();this.recursiveWatcher=e;this.onDidError=J.None;this._watchers=new Map;this.worker=this._register(new Zt)}get watchers(){return this._watchers.values()}async doWatch(e){e=this.removeDuplicateRequests(e);let r=[],n=new Set(Array.from(this.watchers));for(let o of e){let s=this._watchers.get(this.requestToWatcherKey(o));s&&_d(s.request.excludes,o.excludes)&&_d(s.request.includes,o.includes)?n.delete(s):r.push(o)}r.length&&this.trace(`Request to start watching: ${r.map(o=>this.requestToString(o)).join(",")}`),n.size&&this.trace(`Request to stop watching: ${Array.from(n).map(o=>this.requestToString(o.request)).join(",")}`),this.worker.clear();for(let o of n)this.stopWatching(o);this.createWatchWorker().work(r)}createWatchWorker(){return this.worker.value=new vi({maxWorkChunkSize:100,throttleDelay:100,maxBufferedWork:Number.MAX_VALUE},e=>{for(let r of e)this.startWatching(r)}),this.worker.value}requestToWatcherKey(e){return typeof e.correlationId=="number"?e.correlationId:this.pathToWatcherKey(e.path)}pathToWatcherKey(e){return Te?e:e.toLowerCase()}startWatching(e){let r=new Jl(e,this.recursiveWatcher,o=>this._onDidChangeFile.fire(o),()=>this._onDidWatchFail.fire(e),o=>this._onDidLogMessage.fire(o),this.verboseLogging),n={request:e,instance:r};this._watchers.set(this.requestToWatcherKey(e),n)}async stop(){await super.stop();for(let e of this.watchers)this.stopWatching(e)}stopWatching(e){this.trace("stopping file watcher",e),this._watchers.delete(this.requestToWatcherKey(e.request)),e.instance.dispose()}removeDuplicateRequests(e){let r=new Map;for(let n of e){let o=r.get(n.correlationId);o||(o=new Map,r.set(n.correlationId,o));let s=this.pathToWatcherKey(n.path);o.has(s)&&this.trace(`ignoring a request for watching who's path is already watched: ${this.requestToString(n)}`),o.set(s,n)}return Array.from(r.values()).flatMap(n=>Array.from(n.values()))}async setVerboseLogging(e){super.setVerboseLogging(e);for(let r of this.watchers)r.instance.setVerboseLogging(e)}trace(e,r){this.verboseLogging&&this._onDidLogMessage.fire({type:"trace",message:this.toMessage(e,r)})}warn(e){this._onDidLogMessage.fire({type:"warn",message:this.toMessage(e)})}toMessage(e,r){return r?`[File Watcher (node.js)] ${e} (${this.requestToString(r.request)})`:`[File Watcher (node.js)] ${e}`}};var Yl=class extends ql{constructor(t,e,r){super(t,e,r),this.init()}createWatcher(t){return t.add(new Xl(void 0))}};var Zl=class i extends $l{constructor(){super(...arguments);this.onDidChangeCapabilities=J.None;this.resourceLocks=new be(e=>On.getComparisonKey(e));this.mapHandleToPos=new Map;this.mapHandleToLock=new Map;this.writeHandles=new Map}static{this.TRACE_LOG_RESOURCE_LOCKS=!1}get capabilities(){return this._capabilities||(this._capabilities=1040414,Te&&(this._capabilities|=1024)),this._capabilities}async stat(e){try{let{stat:r,symbolicLink:n}=await Lt.stat(this.toFilePath(e)),o;return(r.mode&128)===0&&(o=2),(r.mode&Nd.S_IXUSR||r.mode&Nd.S_IXGRP||r.mode&Nd.S_IXOTH)&&(o=(o??0)|4),{type:this.toType(r,n),ctime:r.birthtime.getTime(),mtime:r.mtime.getTime(),size:r.size,permissions:o}}catch(r){throw this.toFileSystemProviderError(r)}}async statIgnoreError(e){try{return await this.stat(e)}catch{return}}async realpath(e){let r=this.toFilePath(e);return ie.realpath(r)}async readdir(e){try{let r=await ie.readdir(this.toFilePath(e),{withFileTypes:!0}),n=[];return await Promise.all(r.map(async o=>{try{let s;o.isSymbolicLink()?s=(await this.stat(z(e,o.name))).type:s=this.toType(o),n.push([o.name,s])}catch(s){this.logService.trace(s)}})),n}catch(r){throw this.toFileSystemProviderError(r)}}toType(e,r){let n;return r?.dangling?n=0:e.isFile()?n=1:e.isDirectory()?n=2:n=0,r&&(n|=64),n}async createResourceLock(e){let r=this.toFilePath(e);this.traceLock(`[Disk FileSystemProvider]: createResourceLock() - request to acquire resource lock (${r})`);let n;for(;n=this.resourceLocks.get(e);)this.traceLock(`[Disk FileSystemProvider]: createResourceLock() - waiting for resource lock to be released (${r})`),await n.wait();let o=new gi;return this.resourceLocks.set(e,o),this.traceLock(`[Disk FileSystemProvider]: createResourceLock() - new resource lock created (${r})`),ue(()=>{this.traceLock(`[Disk FileSystemProvider]: createResourceLock() - resource lock dispose() (${r})`),this.resourceLocks.get(e)===o&&(this.traceLock(`[Disk FileSystemProvider]: createResourceLock() - resource lock removed from resource-lock map (${r})`),this.resourceLocks.delete(e)),this.traceLock(`[Disk FileSystemProvider]: createResourceLock() - resource lock barrier open() (${r})`),o.open()})}async readFile(e,r){let n;try{r?.atomic&&(this.traceLock(`[Disk FileSystemProvider]: atomic read operation started (${this.toFilePath(e)})`),n=await this.createResourceLock(e));let o=this.toFilePath(e);return await Jn.readFile(o)}catch(o){throw this.toFileSystemProviderError(o)}finally{n?.dispose()}}traceLock(e){i.TRACE_LOG_RESOURCE_LOCKS&&this.logService.trace(e)}readFileStream(e,r,n){let o=Nn(s=>U.concat(s.map(a=>U.wrap(a))).buffer);return Vl(this,e,o,s=>s.buffer,{...r,bufferSize:256*1024},n),o}async writeFile(e,r,n){return n?.atomic!==!1&&n?.atomic?.postfix&&await this.canWriteFileAtomic(e)?this.doWriteFileAtomic(e,z(vf(e),`${kr(e)}${n.atomic.postfix}`),r,n):this.doWriteFile(e,r,n)}async canWriteFileAtomic(e){try{let r=this.toFilePath(e),{symbolicLink:n}=await Lt.stat(r);if(n)return!1}catch{}return!0}async doWriteFileAtomic(e,r,n,o){let s=new Pe;try{s.add(await this.createResourceLock(e)),s.add(await this.createResourceLock(r)),await this.doWriteFile(r,n,{...o,create:!0,overwrite:!0},!0);try{await this.rename(r,e,{overwrite:!0})}catch(a){try{await this.delete(r,{recursive:!1,useTrash:!1,atomic:!1})}catch{}throw a}}finally{s.dispose()}}async doWriteFile(e,r,n,o){let s;try{let a=this.toFilePath(e);if(!n.create||!n.overwrite){if(await ie.exists(a)){if(!n.overwrite)throw cr(m(2090,null),"EntryExists")}else if(!n.create)throw cr(m(2093,null),"EntryNotFound")}s=await this.open(e,{create:!0,append:n.append,unlock:n.unlock},o),await this.write(s,0,r,0,r.byteLength)}catch(a){throw await this.toFileSystemProviderWriteError(e,a)}finally{typeof s=="number"&&await this.close(s)}}static{this.canFlush=!0}static configureFlushOnWrite(e){i.canFlush=e}async open(e,r,n){let o=this.toFilePath(e),s;Wn(r)&&!n&&(s=await this.createResourceLock(e));let a;try{if(Wn(r)&&r.unlock)try{let{stat:l}=await Lt.stat(o);l.mode&128||await Jn.chmod(o,l.mode|128)}catch(l){l.code!=="ENOENT"&&this.logService.trace(l)}if(pe&&Wn(r)&&!r.append)try{a=await ie.open(o,"r+"),await ie.ftruncate(a,0)}catch(l){if(l.code!=="ENOENT"&&this.logService.trace(l),typeof a=="number"){try{await ie.close(a)}catch(c){this.logService.trace(c)}a=void 0}}typeof a!="number"&&(a=await ie.open(o,Wn(r)?r.append?"a":"w":"r"))}catch(l){throw s?.dispose(),Wn(r)?await this.toFileSystemProviderWriteError(e,l):this.toFileSystemProviderError(l)}if(this.mapHandleToPos.set(a,0),Wn(r)&&this.writeHandles.set(a,e),s){let l=this.mapHandleToLock.get(a);this.traceLock(`[Disk FileSystemProvider]: open() - storing lock for handle ${a} (${o})`),this.mapHandleToLock.set(a,s),l&&(this.traceLock(`[Disk FileSystemProvider]: open() - disposing a previous lock that was still stored on same handle ${a} (${o})`),l.dispose())}return a}async close(e){let r=this.mapHandleToLock.get(e);try{if(this.mapHandleToPos.delete(e),this.writeHandles.delete(e)&&i.canFlush)try{await ie.fdatasync(e)}catch(n){i.configureFlushOnWrite(!1),this.logService.error(n)}return await ie.close(e)}catch(n){throw this.toFileSystemProviderError(n)}finally{r&&(this.mapHandleToLock.get(e)===r&&(this.traceLock(`[Disk FileSystemProvider]: close() - resource lock removed from handle-lock map ${e}`),this.mapHandleToLock.delete(e)),this.traceLock(`[Disk FileSystemProvider]: close() - disposing lock for handle ${e}`),r.dispose())}}async read(e,r,n,o,s){let a=this.normalizePos(e,r),l=null;try{l=(await ie.read(e,n,o,s,a)).bytesRead}catch(c){throw this.toFileSystemProviderError(c)}finally{this.updatePos(e,a,l)}return l}normalizePos(e,r){return r===this.mapHandleToPos.get(e)?null:r}updatePos(e,r,n){let o=this.mapHandleToPos.get(e);typeof o=="number"&&(typeof r=="number"||(typeof n=="number"?this.mapHandleToPos.set(e,o+n):this.mapHandleToPos.delete(e)))}async write(e,r,n,o,s){return wf(()=>this.doWrite(e,r,n,o,s),100,3)}async doWrite(e,r,n,o,s){let a=this.normalizePos(e,r),l=null;try{l=(await ie.write(e,n,o,s,a)).bytesWritten}catch(c){throw await this.toFileSystemProviderWriteError(this.writeHandles.get(e),c)}finally{this.updatePos(e,a,l)}return l}async mkdir(e){try{await Jn.mkdir(this.toFilePath(e))}catch(r){throw this.toFileSystemProviderError(r)}}async delete(e,r){try{let n=this.toFilePath(e);if(r.recursive){let o;r?.atomic!==!1&&r.atomic.postfix&&(o=q(Rt(n),`${nt(n)}${r.atomic.postfix}`)),await ie.rm(n,1,o)}else try{await Jn.unlink(n)}catch(o){if(o.code==="EPERM"||o.code==="EISDIR"){let s=!1;try{let{stat:a,symbolicLink:l}=await Lt.stat(n);s=a.isDirectory()&&!l}catch{}if(s)await Jn.rmdir(n);else throw o}else throw o}}catch(n){throw this.toFileSystemProviderError(n)}}async rename(e,r,n){let o=this.toFilePath(e),s=this.toFilePath(r);if(o!==s)try{await this.validateMoveCopy(e,r,"move",n.overwrite),await ie.rename(o,s)}catch(a){throw(a.code==="EINVAL"||a.code==="EBUSY"||a.code==="ENAMETOOLONG")&&(a=new Error(m(2094,null,nt(o),nt(Rt(s)),a.toString()))),this.toFileSystemProviderError(a)}}async copy(e,r,n){let o=this.toFilePath(e),s=this.toFilePath(r);if(o!==s)try{await this.validateMoveCopy(e,r,"copy",n.overwrite),await ie.copy(o,s,{preserveSymlinks:!0})}catch(a){throw(a.code==="EINVAL"||a.code==="EBUSY"||a.code==="ENAMETOOLONG")&&(a=new Error(m(2088,null,nt(o),nt(Rt(s)),a.toString()))),this.toFileSystemProviderError(a)}}async validateMoveCopy(e,r,n,o){let s=this.toFilePath(e),a=this.toFilePath(r),l=!1;if(this.capabilities&1024||(l=mi(s,a,!0)),l){if(n==="copy")throw cr(m(2089,null),"EntryExists");if(n==="move")return}let u=await this.statIgnoreError(e);if(!u)throw cr(m(2092,null),"EntryNotFound");let p=await this.statIgnoreError(r);if(p){if(!o)throw cr(m(2091,null),"EntryExists");(u.type&1)!==0&&(p.type&1)!==0||await this.delete(r,{recursive:!0,useTrash:!1,atomic:!1})}}async cloneFile(e,r){return this.doCloneFile(e,r,!1)}async doCloneFile(e,r,n){let o=this.toFilePath(e),s=this.toFilePath(r),a=!!(this.capabilities&1024);if(mi(o,s,!a))return;let l=new Pe;try{l.add(await this.createResourceLock(e)),l.add(await this.createResourceLock(r)),n&&await Jn.mkdir(Rt(s),{recursive:!0}),await Jn.copyFile(o,s)}catch(c){if(c.code==="ENOENT"&&!n)return this.doCloneFile(e,r,!0);throw this.toFileSystemProviderError(c)}finally{l.dispose()}}createUniversalWatcher(e,r,n){return new Hl(o=>e(o),o=>r(o),n)}createNonRecursiveWatcher(e,r,n){return new Yl(o=>e(o),o=>r(o),n)}toFileSystemProviderError(e){if(e instanceof Ti)return e;let r=e,n;switch(e.code){case"ENOENT":n="EntryNotFound";break;case"EISDIR":n="EntryIsADirectory";break;case"ENOTDIR":n="EntryNotADirectory";break;case"EEXIST":n="EntryExists";break;case"EPERM":case"EACCES":n="NoPermissions";break;case"ERR_UNC_HOST_NOT_ALLOWED":r=`${e.message}. Please update the 'security.allowedUNCHosts' setting if you want to allow this host.`,n="Unknown";break;default:n="Unknown"}return cr(r,n)}async toFileSystemProviderWriteError(e,r){let n=this.toFileSystemProviderError(r);if(e&&n.code==="NoPermissions")try{let{stat:o}=await Lt.stat(this.toFilePath(e));o.mode&128||(n=cr(r,"EntryWriteLocked"))}catch(o){this.logService.trace(o)}return n}};var Re=class{constructor(t,e=[],r=!1){this.ctor=t,this.staticArguments=e,this.supportsDelayedInstantiation=r}};var Vd=class{constructor(t,e){this.key=t;this.data=e;this.incoming=new Map;this.outgoing=new Map}},Ts=class{constructor(t){this._hashFn=t;this._nodes=new Map}roots(){let t=[];for(let e of this._nodes.values())e.outgoing.size===0&&t.push(e);return t}insertEdge(t,e){let r=this.lookupOrInsertNode(t),n=this.lookupOrInsertNode(e);r.outgoing.set(n.key,n),n.incoming.set(r.key,r)}removeNode(t){let e=this._hashFn(t);this._nodes.delete(e);for(let r of this._nodes.values())r.outgoing.delete(e),r.incoming.delete(e)}lookupOrInsertNode(t){let e=this._hashFn(t),r=this._nodes.get(e);return r||(r=new Vd(e,t),this._nodes.set(e,r)),r}lookup(t){return this._nodes.get(this._hashFn(t))}isEmpty(){return this._nodes.size===0}toString(){let t=[];for(let[e,r]of this._nodes)t.push(`${e}
	(-> incoming)[${[...r.incoming.keys()].join(", ")}]
	(outgoing ->)[${[...r.outgoing.keys()].join(",")}]
`);return t.join(`
`)}findCycleSlow(){for(let[t,e]of this._nodes){let r=new Set([t]),n=this._findCycle(e,r);if(n)return n}}_findCycle(t,e){for(let[r,n]of t.outgoing){if(e.has(r))return[...e,r].join(" -> ");e.add(r);let o=this._findCycle(n,e);if(o)return o;e.delete(r)}}};var oo=class{constructor(...t){this._entries=new Map;for(let[e,r]of t)this.set(e,r)}set(t,e){let r=this._entries.get(t);return this._entries.set(t,e),r}has(t){return this._entries.has(t)}get(t){return this._entries.get(t)}};var Ix=!1,ec=class extends Error{constructor(t){super("cyclic dependency between services"),this.message=t.findCycleSlow()??`UNABLE to detect cycle, dumping graph: 
${t.toString()}`}},tc=class i{constructor(t=new oo,e=!1,r,n=Ix){this._services=t;this._strict=e;this._parent=r;this._enableTracing=n;this._isDisposed=!1;this._servicesToMaybeDispose=new Set;this._children=new Set;this._activeInstantiations=new Set;this._services.set(Lr,this),this._globalGraph=n?r?._globalGraph??new Ts(o=>o):void 0}dispose(){if(!this._isDisposed){this._isDisposed=!0,dt(this._children),this._children.clear();for(let t of this._servicesToMaybeDispose)Qs(t)&&t.dispose();this._servicesToMaybeDispose.clear()}}_throwIfDisposed(){if(this._isDisposed)throw new Error("InstantiationService has been disposed")}createChild(t,e){this._throwIfDisposed();let r=this,n=new class extends i{dispose(){r._children.delete(n),super.dispose()}}(t,this._strict,this,this._enableTracing);return this._children.add(n),e?.add(n),n}invokeFunction(t,...e){this._throwIfDisposed();let r=Rs.traceInvocation(this._enableTracing,t),n=!1;try{return t({get:s=>{if(n)throw Gs("service accessor is only valid during the invocation of its target method");let a=this._getOrCreateServiceInstance(s,r);return a||this._throwIfStrict(`[invokeFunction] unknown service '${s}'`,!1),a}},...e)}finally{n=!0,r.stop()}}createInstance(t,...e){this._throwIfDisposed();let r,n;return t instanceof Re?(r=Rs.traceCreation(this._enableTracing,t.ctor),n=this._createInstance(t.ctor,t.staticArguments.concat(e),r)):(r=Rs.traceCreation(this._enableTracing,t),n=this._createInstance(t,e,r)),r.stop(),n}_createInstance(t,e=[],r){let n=lr.getServiceDependencies(t).sort((a,l)=>a.index-l.index),o=[];for(let a of n){let l=this._getOrCreateServiceInstance(a.id,r);l||this._throwIfStrict(`[createInstance] ${t.name} depends on UNKNOWN service ${a.id}.`,!1),o.push(l)}let s=n.length>0?n[0].index:e.length;if(e.length!==s){console.trace(`[createInstance] First service dependency of ${t.name} at position ${s+1} conflicts with ${e.length} static arguments`);let a=s-e.length;a>0?e=e.concat(new Array(a)):e=e.slice(0,s)}return Reflect.construct(t,e.concat(o))}_setCreatedServiceInstance(t,e){if(this._services.get(t)instanceof Re)this._services.set(t,e);else if(this._parent)this._parent._setCreatedServiceInstance(t,e);else throw new Error("illegalState - setting UNKNOWN service instance")}_getServiceInstanceOrDescriptor(t){let e=this._services.get(t);return!e&&this._parent?this._parent._getServiceInstanceOrDescriptor(t):e}_getOrCreateServiceInstance(t,e){this._globalGraph&&this._globalGraphImplicitDependency&&this._globalGraph.insertEdge(this._globalGraphImplicitDependency,String(t));let r=this._getServiceInstanceOrDescriptor(t);return r instanceof Re?this._safeCreateAndCacheServiceInstance(t,r,e.branch(t,!0)):(e.branch(t,!1),r)}_safeCreateAndCacheServiceInstance(t,e,r){if(this._activeInstantiations.has(t))throw new Error(`illegal state - RECURSIVELY instantiating service '${t}'`);this._activeInstantiations.add(t);try{return this._createAndCacheServiceInstance(t,e,r)}finally{this._activeInstantiations.delete(t)}}_createAndCacheServiceInstance(t,e,r){let n=new Ts(l=>l.id.toString()),o=0,s=[{id:t,desc:e,_trace:r}],a=new Set;for(;s.length;){let l=s.pop();if(!a.has(String(l.id))){if(a.add(String(l.id)),n.lookupOrInsertNode(l),o++>1e3)throw new ec(n);for(let c of lr.getServiceDependencies(l.desc.ctor)){let u=this._getServiceInstanceOrDescriptor(c.id);if(u||this._throwIfStrict(`[createInstance] ${t} depends on ${c.id} which is NOT registered.`,!0),this._globalGraph?.insertEdge(String(l.id),String(c.id)),u instanceof Re){let p={id:c.id,desc:u,_trace:l._trace.branch(c.id,!0)};n.insertEdge(l,p),s.push(p)}}}}for(;;){let l=n.roots();if(l.length===0){if(!n.isEmpty())throw new ec(n);break}for(let{data:c}of l){if(this._getServiceInstanceOrDescriptor(c.id)instanceof Re){let p=this._createServiceInstanceWithOwner(c.id,c.desc.ctor,c.desc.staticArguments,c.desc.supportsDelayedInstantiation,c._trace);this._setCreatedServiceInstance(c.id,p)}n.removeNode(c)}}return this._getServiceInstanceOrDescriptor(t)}_createServiceInstanceWithOwner(t,e,r=[],n,o){if(this._services.get(t)instanceof Re)return this._createServiceInstance(t,e,r,n,o,this._servicesToMaybeDispose);if(this._parent)return this._parent._createServiceInstanceWithOwner(t,e,r,n,o);throw new Error(`illegalState - creating UNKNOWN service instance ${e.name}`)}_createServiceInstance(t,e,r=[],n,o,s){if(n){let a=new i(void 0,this._strict,this,this._enableTracing);a._globalGraphImplicitDependency=String(t);let l=new Map,c=new ma(()=>{let u=a._createInstance(e,r,o);for(let[p,f]of l){let g=u[p];if(typeof g=="function")for(let v of f)v.disposable=g.apply(u,v.listener)}return l.clear(),s.add(u),u});return new Proxy(Object.create(null),{get(u,p){if(!c.isInitialized&&typeof p=="string"&&(p.startsWith("onDid")||p.startsWith("onWill"))){let v=l.get(p);return v||(v=new ci,l.set(p,v)),(y,E,b)=>{if(c.isInitialized)return c.value[p](y,E,b);{let C={listener:[y,E,b],disposable:void 0},N=v.push(C);return ue(()=>{N(),C.disposable?.dispose()})}}}if(p in u)return u[p];let f=c.value,g=f[p];return typeof g!="function"||(g=g.bind(f),u[p]=g),g},set(u,p,f){return c.value[p]=f,!0},getPrototypeOf(u){return e.prototype}})}else{let a=this._createInstance(e,r,o);return s.add(a),a}}_throwIfStrict(t,e){if(e&&console.warn(t),this._strict)throw new Error(t)}};var Rs=class i{constructor(t,e){this.type=t;this.name=e;this._start=Date.now();this._dep=[]}static{this.all=new Set}static{this._None=new class extends i{constructor(){super(0,null)}stop(){}branch(){return this}}}static traceInvocation(t,e){return t?new i(2,e.name||new Error().stack.split(`
`).slice(3,4).join(`
`)):i._None}static traceCreation(t,e){return t?new i(1,e.name):i._None}static{this._totals=0}branch(t,e){let r=new i(3,t.toString());return this._dep.push([t,e,r]),r}stop(){let t=Date.now()-this._start;i._totals+=t;let e=!1;function r(o,s){let a=[],l=new Array(o+1).join("	");for(let[c,u,p]of s._dep)if(u&&p){e=!0,a.push(`${l}CREATES -> ${c}`);let f=r(o+1,p);f&&a.push(f)}else a.push(`${l}uses -> ${c}`);return a.join(`
`)}let n=[`${this.type===1?"CREATE":"CALL"} ${this.name}`,`${r(1,this)}`,`DONE, took ${t.toFixed(2)}ms (grand total ${i._totals.toFixed(2)}ms)`];(t>2||e)&&i.all.add(n.join(`
`))}};function xx(i){return i.tags.find(t=>t.startsWith("lp-"))?.split("lp-")[1]}var _h=B("languagePackService"),so=class extends _{constructor(e){super();this.extensionGalleryService=e}async getAvailableLanguages(){let e=new pt;setTimeout(()=>e.cancel(),1e3);let r;try{r=await this.extensionGalleryService.query({text:'category:"language packs"',pageSize:20},e.token)}catch{return[]}let o=r.firstPage.filter(s=>s.properties.localizedLanguages?.length&&s.tags.some(a=>a.startsWith("lp-"))).map(s=>{let a=s.properties.localizedLanguages?.[0],l=xx(s);return{...this.createQuickPickItem(l,a,s),extensionId:s.identifier.id,galleryExtension:s}});return o.push(this.createQuickPickItem("en","English")),o}createQuickPickItem(e,r,n){let o=r??e,s;if(o!==e&&(s=`(${e})`),e.toLowerCase()===er.toLowerCase()&&(s??="",s+=m(2105,null)),n?.installCount){s??="";let a=n.installCount,l;a>1e6?l=`${Math.floor(a/1e5)/10}M`:a>1e3?l=`${Math.floor(a/1e3)}K`:l=String(a),s+=` $(cloud-download) ${l}`}return{id:e,label:o,description:s}}};so=T([I(0,kt)],so);import*as kh from"fs";import{createHash as bx}from"crypto";var ao=class extends so{constructor(e,r,n,o){super(n);this.extensionManagementService=e;this.logService=o;this.cache=this._register(new Cs(r,o)),this.extensionManagementService.registerParticipant({postInstall:async s=>this.postInstallExtension(s),postUninstall:async s=>this.postUninstallExtension(s)})}async getBuiltInExtensionTranslationsUri(e,r){let o=(await this.cache.getLanguagePacks())[r];if(!o){this.logService.warn(`No language pack found for ${r}`);return}let s=o.translations[e];return s?P.file(s):void 0}async getInstalledLanguages(){let e=await this.cache.getLanguagePacks(),r=Object.keys(e).map(n=>{let o=e[n];return{...this.createQuickPickItem(n,o.label),extensionId:o.extensions[0].extensionIdentifier.id}});return r.push(this.createQuickPickItem("en","English")),r.sort((n,o)=>n.label.localeCompare(o.label)),r}async postInstallExtension(e){e&&e.manifest&&e.manifest.contributes&&e.manifest.contributes.localizations&&e.manifest.contributes.localizations.length&&(this.logService.info("Adding language packs from the extension",e.identifier.id),await this.update())}async postUninstallExtension(e){let r=await this.cache.getLanguagePacks();Object.keys(r).some(n=>r[n]&&r[n].extensions.some(o=>H(o.extensionIdentifier,e.identifier)))&&(this.logService.info("Removing language packs from the extension",e.identifier.id),await this.update())}async update(){let[e,r]=await Promise.all([this.cache.getLanguagePacks(),this.extensionManagementService.getInstalled()]),n=await this.cache.update(r);return!xr(Object.keys(e),Object.keys(n))}};ao=T([I(0,Vi),I(1,Qe),I(2,kt),I(3,V)],ao);var Cs=class extends _{constructor(e,r){super();this.logService=r;this.languagePacks={};this.languagePacksFilePath=q(e.userDataPath,"languagepacks.json"),this.languagePacksFileLimiter=new jt}getLanguagePacks(){return this.languagePacksFileLimiter.size||!this.initializedCache?this.withLanguagePacks().then(()=>this.languagePacks):Promise.resolve(this.languagePacks)}update(e){return this.withLanguagePacks(r=>{Object.keys(r).forEach(n=>delete r[n]),this.createLanguagePacksFromExtensions(r,...e)}).then(()=>this.languagePacks)}createLanguagePacksFromExtensions(e,...r){for(let n of r)n&&n.manifest&&n.manifest.contributes&&n.manifest.contributes.localizations&&n.manifest.contributes.localizations.length&&this.createLanguagePacksFromExtension(e,n);Object.keys(e).forEach(n=>this.updateHash(e[n]))}createLanguagePacksFromExtension(e,r){let n=r.identifier,o=r.manifest.contributes&&r.manifest.contributes.localizations?r.manifest.contributes.localizations:[];for(let s of o)if(r.location.scheme===$.file&&Sx(s)){let a=e[s.languageId];a||(a={hash:"",extensions:[],translations:{},label:s.localizedLanguageName??s.languageName},e[s.languageId]=a);let l=a.extensions.filter(c=>H(c.extensionIdentifier,n))[0];l?l.version=r.manifest.version:a.extensions.push({extensionIdentifier:n,version:r.manifest.version});for(let c of s.translations)a.translations[c.id]=q(r.location.fsPath,c.path)}}updateHash(e){if(e){let r=bx("md5");for(let n of e.extensions)r.update(n.extensionIdentifier.uuid||n.extensionIdentifier.id).update(n.version);e.hash=r.digest("hex")}}withLanguagePacks(e=()=>null){return this.languagePacksFileLimiter.queue(()=>{let r=null;return kh.promises.readFile(this.languagePacksFilePath,"utf8").then(void 0,n=>n.code==="ENOENT"?Promise.resolve("{}"):Promise.reject(n)).then(n=>{try{return JSON.parse(n)}catch{return{}}}).then(n=>(r=e(n),n)).then(n=>{for(let s of Object.keys(n))n[s]||delete n[s];this.languagePacks=n,this.initializedCache=!0;let o=JSON.stringify(this.languagePacks);return this.logService.debug("Writing language packs",o),ie.writeFile(this.languagePacksFilePath,o)}).then(()=>r,n=>this.logService.error(n))})}};Cs=T([I(0,Qe),I(1,V)],Cs);function Sx(i){if(typeof i.languageId!="string"||!Array.isArray(i.translations)||i.translations.length===0)return!1;for(let t of i.translations)if(typeof t.id!="string"||typeof t.path!="string")return!1;return!(i.languageName&&typeof i.languageName!="string"||i.localizedLanguageName&&typeof i.localizedLanguageName!="string")}function Ex(i,t){let e=[];for(let r of new Set(Er.concat(i.keys(),t.keys())))i.get(r)!==t.get(r)&&e.push(r);return e}var Xn=class extends Li{constructor(e,r,n){super();this.file=e;this.fileService=r;this.logService=n;this.throttledDelayer=this._register(new _t(500));let o=J.filter(r.onDidFilesChange,s=>s.affects(e));this._register(r.watch(e)),this._register(o(()=>this.throttledDelayer.trigger(()=>this.refresh())))}async _updatePolicyDefinitions(){await this.refresh()}async read(){let e=new Map;try{let r=await this.fileService.readFile(this.file),n=JSON.parse(r.value.toString());if(!he(n))throw new Error("Policy file isn't a JSON object");for(let o of Object.keys(n))this.policyDefinitions[o]&&e.set(o,n[o])}catch(r){r.fileOperationResult!==1&&this.logService.error("[FilePolicyService] Failed to read policies",r)}return e}async refresh(){let e=await this.read(),r=Ex(this.policies,e);this.policies=e,r.length>0&&this._onDidChange.fire(r)}};Xn=T([I(1,ee),I(2,V)],Xn);var Yn=class extends Li{constructor(e,r){super();this.logService=e;this.productName=r;this.throttler=this._register(new Oo);this.watcher=this._register(new Zt)}async _updatePolicyDefinitions(e){this.logService.trace(`NativePolicyService#_updatePolicyDefinitions - Found ${Object.keys(e).length} policy definitions`);let{createWatcher:r}=await import("@vscode/policy-watcher");await this.throttler.queue(()=>new Promise((n,o)=>{try{this.watcher.value=r(this.productName,e,s=>{this._onDidPolicyChange(s),n()})}catch(s){this.logService.error("NativePolicyService#_updatePolicyDefinitions - Error creating watcher:",s),o(s)}}))}_onDidPolicyChange(e){this.logService.trace(`NativePolicyService#_onDidPolicyChange - Updated policy values: ${JSON.stringify(e)}`);for(let r in e){let n=e[r];n===void 0?this.policies.delete(r):this.policies.set(r,n)}this._onDidChange.fire(Object.keys(e))}};Yn=T([I(0,V)],Yn);import{parse as Vh}from"url";import{spawn as Fx}from"child_process";import{userInfo as Lx}from"os";import*as Wd from"os";var Dh=/^\d+$/,wx=/^Microsoft.PowerShell_.*/,Px=/^Microsoft.PowerShellPreview_.*/;var _s;switch(process.arch){case"ia32":_s=1;break;case"arm":case"arm64":_s=2;break;default:_s=0;break}var lo;process.env.PROCESSOR_ARCHITEW6432?lo=process.env.PROCESSOR_ARCHITEW6432==="ARM64"?2:0:process.env.PROCESSOR_ARCHITECTURE==="ARM64"?lo=2:process.env.PROCESSOR_ARCHITECTURE==="X86"?lo=1:lo=0;var Zn=class{constructor(t,e,r){this.exePath=t;this.displayName=e;this.knownToExist=r}async exists(){return this.knownToExist===void 0&&(this.knownToExist=await Lt.existsFile(this.exePath)),this.knownToExist}};function Tx({useAlternateBitness:i=!1}={}){return i?_s===0?process.env["ProgramFiles(x86)"]||null:lo===0&&process.env.ProgramW6432||null:process.env.ProgramFiles||null}async function rc({useAlternateBitness:i=!1,findPreview:t=!1}={}){let e=Tx({useAlternateBitness:i});if(!e)return null;let r=q(e,"PowerShell");if(!await Lt.existsDirectory(r))return null;let n=-1,o=null;for(let l of await ie.readdir(r)){let c=-1;if(t){let p=l.indexOf("-");if(p<0)continue;let f=l.substring(0,p);if(!Dh.test(f)||l.substring(p+1)!=="preview")continue;c=parseInt(f,10)}else{if(!Dh.test(l))continue;c=parseInt(l,10)}if(c<=n)continue;let u=q(r,l,"pwsh.exe");await Lt.existsFile(u)&&(o=u,n=c)}if(!o)return null;let s=e.includes("x86")?" (x86)":"",a=t?" Preview":"";return new Zn(o,`PowerShell${a}${s}`,!0)}async function Lh({findPreview:i}={}){if(!process.env.LOCALAPPDATA)return null;let t=q(process.env.LOCALAPPDATA,"Microsoft","WindowsApps");if(!await Lt.existsDirectory(t))return null;let{pwshMsixDirRegex:e,pwshMsixName:r}=i?{pwshMsixDirRegex:Px,pwshMsixName:"PowerShell Preview (Store)"}:{pwshMsixDirRegex:wx,pwshMsixName:"PowerShell (Store)"};for(let n of await ie.readdir(t))if(e.test(n)){let o=q(t,n,"pwsh.exe");return new Zn(o,r)}return null}function Rx(){let i=q(Wd.homedir(),".dotnet","tools","pwsh.exe");return new Zn(i,".NET Core PowerShell Global Tool")}function Cx(){let i=q(Wd.homedir(),"scoop","apps"),t=q(i,"pwsh","current","pwsh.exe");return new Zn(t,"PowerShell (Scoop)")}function _x(){let i=q(process.env.windir,_s===1&&lo!==1?"SysNative":"System32","WindowsPowerShell","v1.0","powershell.exe");return new Zn(i,"Windows PowerShell",!0)}async function*kx(){let i=await rc();i&&(yield i),i=await rc({useAlternateBitness:!0}),i&&(yield i),i=await Lh(),i&&(yield i),i=Rx(),i&&(yield i),i=await rc({findPreview:!0}),i&&(yield i),i=await Lh({findPreview:!0}),i&&(yield i),i=await rc({useAlternateBitness:!0,findPreview:!0}),i&&(yield i),i=await Cx(),i&&(yield i),i=_x(),i&&(yield i)}async function*Dx(){for await(let i of kx())await i.exists()&&(yield i)}async function Ah(){for await(let i of Dx())return i;return null}async function Uh(i,t){return i===1?pe?Ux():Rh(t):Ax(i,t)}var Bd=null;function Ax(i,t){if(Te&&i===2||ft&&i===3)return"/bin/bash";if(!Bd){let e;if(pe)e="/bin/bash";else{if(e=t.SHELL,!e)try{e=Lx().shell}catch{}e||(e="sh"),e==="/bin/false"&&(e="/bin/bash")}Bd=e}return Bd}var Gd=null;async function Ux(){return Gd||(Gd=(await Ah()).exePath),Gd}import m3 from"assert";import s3 from"minimist";var c3={o:m(1906,null),e:m(1890,null),t:m(1921,null),m:m(1901,null)};var Mx={chat:{type:"subcommand",description:"Pass in a prompt to run in a chat session in the current working directory.",options:{_:{type:"string[]",description:m(1910,null)},mode:{type:"string",cat:"o",alias:"m",args:"mode",description:m(1878,null)},"add-file":{type:"string[]",cat:"o",alias:"a",args:"path",description:m(1874,null)},maximize:{type:"boolean",cat:"o",description:m(1877,null)},"reuse-window":{type:"boolean",cat:"o",alias:"r",description:m(1913,null)},"new-window":{type:"boolean",cat:"o",alias:"n",description:m(1904,null)},profile:{type:"string",cat:"o",args:"profileName",description:m(1909,null)},help:{type:"boolean",alias:"h",description:m(1892,null)}}},"serve-web":{type:"subcommand",description:"Run a server that displays the editor UI in browsers.",options:{"cli-data-dir":{type:"string",args:"dir",description:m(1879,null)},"disable-telemetry":{type:"boolean"},"telemetry-level":{type:"string"}}},tunnel:{type:"subcommand",description:"Make the current machine accessible from vscode.dev or other machines through a secure tunnel.",options:{"cli-data-dir":{type:"string",args:"dir",description:m(1879,null)},"disable-telemetry":{type:"boolean"},"telemetry-level":{type:"string"},user:{type:"subcommand",options:{login:{type:"subcommand",options:{provider:{type:"string"},"access-token":{type:"string"}}}}}}},diff:{type:"boolean",cat:"o",alias:"d",args:["file","file"],description:m(1882,null)},merge:{type:"boolean",cat:"o",alias:"m",args:["path1","path2","base","result"],description:m(1902,null)},add:{type:"boolean",cat:"o",alias:"a",args:"folder",description:m(1873,null)},remove:{type:"boolean",cat:"o",args:"folder",description:m(1911,null)},goto:{type:"boolean",cat:"o",alias:"g",args:"file:line[:character]",description:m(1891,null)},"new-window":{type:"boolean",cat:"o",alias:"n",description:m(1903,null)},"reuse-window":{type:"boolean",cat:"o",alias:"r",description:m(1912,null)},sessions:{type:"boolean",cat:"o",description:m(1914,null)},wait:{type:"boolean",cat:"o",alias:"w",description:m(1931,null)},waitMarkerFilePath:{type:"string"},locale:{type:"string",cat:"o",args:"locale",description:m(1898,null)},"user-data-dir":{type:"string",cat:"o",args:"dir",description:m(1928,null)},profile:{type:"string",cat:"o",args:"profileName",description:m(1909,null)},help:{type:"boolean",cat:"o",alias:"h",description:m(1892,null)},"extensions-dir":{type:"string",deprecates:["extensionHomePath"],cat:"e",args:"dir",description:m(1889,null)},"extensions-download-dir":{type:"string"},"builtin-extensions-dir":{type:"string"},"list-extensions":{type:"boolean",cat:"e",description:m(1897,null)},"show-versions":{type:"boolean",cat:"e",description:m(1915,null)},category:{type:"string",allowEmptyValue:!0,cat:"e",description:m(1876,null),args:"category"},"install-extension":{type:"string[]",cat:"e",args:"ext-id | path",description:m(1896,null)},"pre-release":{type:"boolean",cat:"e",description:m(1895,null)},"uninstall-extension":{type:"string[]",cat:"e",args:"ext-id",description:m(1923,null)},"update-extensions":{type:"boolean",cat:"e",description:m(1926,null)},"enable-proposed-api":{type:"string[]",allowEmptyValue:!0,cat:"e",args:"ext-id",description:m(1888,null)},"add-mcp":{type:"string[]",cat:"m",args:"json",description:m(1875,null)},version:{type:"boolean",cat:"t",alias:"v",description:m(1930,null)},verbose:{type:"boolean",cat:"t",global:!0,description:m(1929,null)},log:{type:"string[]",cat:"t",args:"level",global:!0,description:m(1900,null)},status:{type:"boolean",alias:"s",cat:"t",description:m(1916,null)},"prof-startup":{type:"boolean",cat:"t",description:m(1908,null)},"prof-append-timers":{type:"string"},"prof-duration-markers":{type:"string[]"},"prof-duration-markers-file":{type:"string"},"no-cached-data":{type:"boolean"},"prof-startup-prefix":{type:"string"},"prof-v8-extensions":{type:"boolean"},"disable-extensions":{type:"boolean",deprecates:["disableExtensions"],cat:"t",description:m(1885,null)},"disable-extension":{type:"string[]",cat:"t",args:"ext-id",description:m(1884,null)},sync:{type:"string",cat:"t",description:m(1922,null),args:["on | off"]},"inspect-extensions":{type:"string",allowEmptyValue:!0,deprecates:["debugPluginHost"],args:"port",cat:"t",description:m(1894,null)},"inspect-brk-extensions":{type:"string",allowEmptyValue:!0,deprecates:["debugBrkPluginHost"],args:"port",cat:"t",description:m(1893,null)},"disable-lcd-text":{type:"boolean",cat:"t",description:m(1887,null)},"disable-gpu":{type:"boolean",cat:"t",description:m(1886,null)},"disable-chromium-sandbox":{type:"boolean",cat:"t",description:m(1883,null)},sandbox:{type:"boolean"},"locate-shell-integration-path":{type:"string",cat:"t",args:["shell"],description:m(1899,null)},telemetry:{type:"boolean",cat:"t",description:m(1919,null)},remote:{type:"string",allowEmptyValue:!0},"folder-uri":{type:"string[]",cat:"o",args:"uri"},"file-uri":{type:"string[]",cat:"o",args:"uri"},"locate-extension":{type:"string[]"},extensionDevelopmentPath:{type:"string[]"},extensionDevelopmentKind:{type:"string[]"},extensionTestsPath:{type:"string"},extensionEnvironment:{type:"string"},debugId:{type:"string"},debugRenderer:{type:"boolean"},"inspect-ptyhost":{type:"string",allowEmptyValue:!0},"inspect-brk-ptyhost":{type:"string",allowEmptyValue:!0},"inspect-search":{type:"string",deprecates:["debugSearch"],allowEmptyValue:!0},"inspect-brk-search":{type:"string",deprecates:["debugBrkSearch"],allowEmptyValue:!0},"inspect-sharedprocess":{type:"string",allowEmptyValue:!0},"inspect-brk-sharedprocess":{type:"string",allowEmptyValue:!0},"export-default-configuration":{type:"string"},"export-policy-data":{type:"string",allowEmptyValue:!0},"install-source":{type:"string"},"enable-smoke-test-driver":{type:"boolean"},logExtensionHostCommunication:{type:"boolean"},"skip-release-notes":{type:"boolean"},"skip-welcome":{type:"boolean"},"disable-telemetry":{type:"boolean"},"disable-updates":{type:"boolean"},transient:{type:"boolean",cat:"t",description:m(1920,null)},"use-inmemory-secretstorage":{type:"boolean",deprecates:["disable-keytar"]},"password-store":{type:"string"},"disable-workspace-trust":{type:"boolean"},"disable-crash-reporter":{type:"boolean"},"crash-reporter-directory":{type:"string"},"crash-reporter-id":{type:"string"},"skip-add-to-recently-opened":{type:"boolean"},"open-url":{type:"boolean"},"file-write":{type:"boolean"},"file-chmod":{type:"boolean"},"install-builtin-extension":{type:"string[]"},force:{type:"boolean"},"do-not-sync":{type:"boolean"},"do-not-include-pack-dependencies":{type:"boolean"},trace:{type:"boolean"},"trace-memory-infra":{type:"boolean"},"trace-category-filter":{type:"string"},"trace-options":{type:"string"},"preserve-env":{type:"boolean"},"force-user-env":{type:"boolean"},"force-disable-user-env":{type:"boolean"},"open-devtools":{type:"boolean"},"disable-gpu-sandbox":{type:"boolean"},logsPath:{type:"string"},"__enable-file-policy":{type:"boolean"},editSessionId:{type:"string"},continueOn:{type:"string"},"enable-coi":{type:"boolean"},"unresponsive-sample-interval":{type:"string"},"unresponsive-sample-period":{type:"string"},"enable-rdp-display-tracking":{type:"boolean"},"disable-layout-restore":{type:"boolean"},"disable-experiments":{type:"boolean"},"no-proxy-server":{type:"boolean"},"no-sandbox":{type:"boolean",alias:"sandbox"},"proxy-server":{type:"string"},"proxy-bypass-list":{type:"string"},"proxy-pac-url":{type:"string"},"js-flags":{type:"string"},inspect:{type:"string",allowEmptyValue:!0},"inspect-brk":{type:"string",allowEmptyValue:!0},nolazy:{type:"boolean"},"force-device-scale-factor":{type:"string"},"force-renderer-accessibility":{type:"boolean"},"ignore-certificate-errors":{type:"boolean"},"allow-insecure-localhost":{type:"boolean"},"log-net-log":{type:"string"},vmodule:{type:"string"},_urls:{type:"string[]"},"disable-dev-shm-usage":{type:"boolean"},"profile-temp":{type:"boolean"},"ozone-platform":{type:"string"},"enable-tracing":{type:"string"},"trace-startup-format":{type:"string"},"trace-startup-file":{type:"string"},"trace-startup-duration":{type:"string"},"xdg-portal-required-version":{type:"string"},_:{type:"string[]"}};function qd(i){return i.VSCODE_CLI==="1"}function Mh(i,t,e){return Math.min(Math.max(i,t),e)}var Kd;async function Fh(i,t,e,r){return e["force-disable-user-env"]?(t.trace("resolveShellEnv(): skipped (--force-disable-user-env)"),{}):pe?(t.trace("resolveShellEnv(): skipped (Windows)"),{}):qd(r)&&!e["force-user-env"]?(t.trace("resolveShellEnv(): skipped (VSCODE_CLI is set)"),{}):(qd(r)?t.trace("resolveShellEnv(): running (--force-user-env)"):t.trace("resolveShellEnv(): running (macOS/Linux)"),Kd||(Kd=He.withAsyncBody(async(n,o)=>{let s=new pt,a=1e4,l=i.getValue("application.shellEnvironmentResolutionTimeout");typeof l=="number"&&(a=Mh(l,1,120)*1e3);let c=setTimeout(()=>{s.dispose(!0),o(new Error(m(2277,null)))},a);try{n(await Ox(t,s.token))}catch(u){!or(u)&&!s.token.isCancellationRequested?o(new Error(m(2275,null,ar(u)))):n({})}finally{clearTimeout(c),s.dispose()}})),Kd)}async function Ox(i,t){let e=process.env.ELECTRON_RUN_AS_NODE;i.trace("getUnixShellEnvironment#runAsNode",e);let r=process.env.ELECTRON_NO_ATTACH_CONSOLE;i.trace("getUnixShellEnvironment#noAttach",r);let n=Ne().replace(/-/g,"").substr(0,12),o=new RegExp(n+"({.*})"+n),s={...process.env,ELECTRON_RUN_AS_NODE:"1",ELECTRON_NO_ATTACH_CONSOLE:"1",VSCODE_RESOLVING_ENVIRONMENT:"1"};i.trace("getUnixShellEnvironment#env",s);let a=await Uh(Do,s);return i.trace("getUnixShellEnvironment#shell",a),new Promise((l,c)=>{if(t.isCancellationRequested)return c(new Ie);let u=nt(a),p,f,g="";/^(?:pwsh|powershell)(?:-preview)?$/.test(u)?(p=`& '${process.execPath}' ${g} -p '''${n}'' + JSON.stringify(process.env) + ''${n}'''`,f=["-Login","-Command"]):u==="nu"?(p=`^'${process.execPath}' ${g} -p '"${n}" + JSON.stringify(process.env) + "${n}"'`,f=["-i","-l","-c"]):u==="xonsh"?(p=`import os, json; print("${n}", json.dumps(dict(os.environ)), "${n}")`,f=["-i","-l","-c"]):(p=`'${process.execPath}' ${g} -p '"${n}" + JSON.stringify(process.env) + "${n}"'`,u==="tcsh"||u==="csh"?f=["-ic"]:f=["-i","-l","-c"]),i.trace("getUnixShellEnvironment#spawn",JSON.stringify(f),p);let v=Fx(a,[...f,p],{detached:!0,stdio:["ignore","pipe","pipe"],env:s});t.onCancellationRequested(()=>(v.kill(),c(new Ie))),v.on("error",E=>{i.error("getUnixShellEnvironment#errorChildProcess",ar(E)),c(E)});let h=[];v.stdout.on("data",E=>h.push(E));let y=[];v.stderr.on("data",E=>y.push(E)),v.on("close",(E,b)=>{let C=Buffer.concat(h).toString("utf8");i.trace("getUnixShellEnvironment#raw",C);let N=Buffer.concat(y).toString("utf8");if(N.trim()&&i.trace("getUnixShellEnvironment#stderr",N),E||b)return c(new Error(m(2276,null,E,b)));let oe=o.exec(C),Fe=oe?oe[1]:"{}";try{let L=JSON.parse(Fe);e?L.ELECTRON_RUN_AS_NODE=e:delete L.ELECTRON_RUN_AS_NODE,r?L.ELECTRON_NO_ATTACH_CONSOLE=r:delete L.ELECTRON_NO_ATTACH_CONSOLE,delete L.VSCODE_RESOLVING_ENVIRONMENT,delete L.XDG_RUNTIME_DIR,i.trace("getUnixShellEnvironment#result",L),l(L)}catch(L){i.error("getUnixShellEnvironment#errorCaught",ar(L)),c(L)}})})}import{parse as Oh}from"url";function Nx(i,t){return i.protocol==="http:"?t.HTTP_PROXY||t.http_proxy||null:i.protocol==="https:"&&(t.HTTPS_PROXY||t.https_proxy||t.HTTP_PROXY||t.http_proxy)||null}async function Nh(i,t,e={}){let r=Oh(i),n=e.proxyUrl||Nx(r,t);if(!n)return null;let o=Oh(n);if(!/^https?:$/.test(o.protocol||""))return null;let s={host:o.hostname||"",port:(o.port?+o.port:0)||(o.protocol==="https"?443:80),auth:o.auth,rejectUnauthorized:Tt(e.strictSSL)?e.strictSSL:!0};if(r.protocol==="http:"){let{default:a}=await import("http-proxy-agent");return new a.HttpProxyAgent(n,s)}else{let{default:a}=await import("https-proxy-agent");return new a.HttpsProxyAgent(n,s)}}import{createGunzip as Vx}from"zlib";var Wx=new Set(["EAI_AGAIN","ECONNREFUSED","EHOSTDOWN","EHOSTUNREACH","ENETDOWN","ENETUNREACH","EPROTO"]),Bx=/^(GET|HEAD|OPTIONS)$/i;function Gx(i){if(i instanceof Error){let t=i.code;return!!t&&Wx.has(t)}return!1}var co=class extends rl{constructor(e,r,n,o){super(o);this.machine=e;this.configurationService=r;this.environmentService=n;this.configure(),this._register(r.onDidChangeConfiguration(s=>{s.affectsConfiguration("http")&&this.configure()}))}configure(){this.proxyUrl=this.getConfigValue("http.proxy"),this.strictSSL=!!this.getConfigValue("http.proxyStrictSSL"),this.authorization=this.getConfigValue("http.proxyAuthorization")}async request(e,r){let{proxyUrl:n,strictSSL:o}=this,s;try{s=await Fh(this.configurationService,this.logService,this.environmentService.args,process.env)}catch(c){this.shellEnvErrorLogged||(this.shellEnvErrorLogged=!0,this.logService.error("resolving shell environment failed",G(c)))}let a={...process.env,...s},l=e.agent?e.agent:await Nh(e.url||"",a,{proxyUrl:n,strictSSL:o});return e.agent=l,e.strictSSL=o,this.authorization&&(e.headers={...e.headers||{},"Proxy-Authorization":this.authorization}),this.logAndRequest(e,()=>Wh(e,r))}async resolveProxy(e){}async lookupAuthorization(e){}async lookupKerberosAuthorization(e){try{let r=this.getConfigValue("http.proxyKerberosServicePrincipal");return"Negotiate "+await qx(e,r,this.logService,"RequestService#lookupKerberosAuthorization")}catch(r){this.logService.debug("RequestService#lookupKerberosAuthorization Kerberos authentication failed",r);return}}async loadCertificates(){return(await import("@vscode/proxy-agent")).loadSystemCertificates({loadSystemCertificatesFromNode:()=>this.getConfigValue("http.systemCertificatesNode",Ku),log:this.logService})}getConfigValue(e,r){if(this.machine==="remote")return this.configurationService.getValue(e);let n=this.configurationService.inspect(e);return n.userLocalValue??n.defaultValue??r}};co=T([I(1,It),I(2,Qe),I(3,V)],co);async function qx(i,t,e,r){let n=await import("kerberos"),o=n.default||n,s=new URL(i),a=t||(process.platform==="win32"?`HTTP/${s.hostname}`:`HTTP@${s.hostname}`);return e.debug(`${r} Kerberos authentication lookup`,`proxyURL:${s}`,`spn:${a}`),(await o.initializeClient(a)).step("")}async function Kx(i){return(Vh(i.url).protocol==="https:"?await import("https"):await import("http")).request}async function Wh(i,t){let r,n=Bx.test(i.type||"GET");for(let o=1;o<=3;o++)try{return await zx(i,t)}catch(s){if(r=s,s instanceof Ie||!n||!Gx(s)||o===3)throw s;await Hr(100*o,t)}throw r}async function zx(i,t){return He.withAsyncBody(async(e,r)=>{let n=Vh(i.url),o=i.getRawRequest?i.getRawRequest(i):await Kx(i),s={hostname:n.hostname,port:n.port?parseInt(n.port):n.protocol==="https:"?443:80,protocol:n.protocol,path:n.path,method:i.type||"GET",headers:i.headers,agent:i.agent,rejectUnauthorized:Tt(i.strictSSL)?i.strictSSL:!0};i.user&&i.password&&(s.auth=i.user+":"+i.password),i.disableCache&&(s.cache="no-store");let a=o(s,c=>{let u=sn(i.followRedirects)?i.followRedirects:3;if(c.statusCode&&c.statusCode>=300&&c.statusCode<400&&u>0&&c.headers.location)Wh({...i,url:c.headers.location,followRedirects:u-1},t).then(e,r);else{let p=c;!i.isChromiumNetwork&&c.headers["content-encoding"]==="gzip"&&(p=c.pipe(Vx())),e({res:c,stream:Wf(p)})}});if(a.on("error",r),i.timeout)if(i.isChromiumNetwork){let c=setTimeout(()=>{a.abort(),r(new Error(`Request timeout after ${i.timeout}ms`))},i.timeout);a.on("response",()=>clearTimeout(c)),a.on("error",()=>clearTimeout(c)),a.on("abort",()=>clearTimeout(c))}else a.setTimeout(i.timeout);i.isChromiumNetwork&&a.removeHeader("Content-Length"),i.data&&typeof i.data=="string"&&a.write(i.data),a.end();let l=t.onCancellationRequested(()=>{l.dispose(),a.abort(),r(new Ie)});a.on("response",()=>l.dispose()),a.on("error",()=>l.dispose())})}var zd=class extends _{constructor(e,r,n,o){super();this.storagePath=e;this.logService=n;this.fileService=o;this.storage=Object.create(null);this.lastSavedStorageContents="";this.initializing=void 0;this.closing=void 0;this.flushDelayer=this._register(new _t(r===0?0:100))}init(){return this.initializing||(this.initializing=this.doInit()),this.initializing}async doInit(){try{this.lastSavedStorageContents=(await this.fileService.readFile(this.storagePath)).value.toString(),this.storage=JSON.parse(this.lastSavedStorageContents)}catch(e){e.fileOperationResult!==1&&this.logService.error(e)}}getItem(e,r){let n=this.storage[e];return Oe(n)?r:n}setItem(e,r){this.setItems([{key:e,data:r}])}setItems(e){let r=!1;for(let{key:n,data:o}of e)this.storage[n]!==o&&(Oe(o)?ut(this.storage[n])||(this.storage[n]=void 0,r=!0):(this.storage[n]=o,r=!0));r&&this.save()}removeItem(e){ut(this.storage[e])||(this.storage[e]=void 0,this.save())}async save(){if(!this.closing)return this.flushDelayer.trigger(()=>this.doSave())}async doSave(){if(!this.initializing)return;await this.initializing;let e=JSON.stringify(this.storage,null,4);if(e!==this.lastSavedStorageContents)try{await this.fileService.writeFile(this.storagePath,U.fromString(e),{atomic:{postfix:".vsctmp"}}),this.lastSavedStorageContents=e}catch(r){this.logService.error(r)}}async close(){return this.closing||(this.closing=this.flushDelayer.trigger(()=>this.doSave(),0)),this.closing}},ei=class extends _{constructor(t,e,r,n){super(),this.fileStorage=this._register(new zd(e.stateResource,t,r,n))}async init(){await this.fileStorage.init()}getItem(t,e){return this.fileStorage.getItem(t,e)}};ei=T([I(1,gt),I(2,V),I(3,ee)],ei);var nc=class extends ei{setItem(t,e){this.fileStorage.setItem(t,e)}setItems(t){this.fileStorage.setItems(t)}removeItem(t){this.fileStorage.removeItem(t)}close(){return this.fileStorage.close()}};var tn=class{constructor(t,e,r){this._configurationService=e;this._productService=r;this._experimentProperties={};this._pendingEvents=[];this._isExperimentPropertySet=!1;this._disposables=new Pe;this._cleanupPatterns=[];this._appenders=t.appenders,this._commonProperties=t.commonProperties??Object.create(null),this.sessionId=this._commonProperties.sessionID,this.machineId=this._commonProperties["common.machineId"],this.sqmId=this._commonProperties["common.sqmId"],this.devDeviceId=this._commonProperties["common.devDeviceId"],this.firstSessionDate=this._commonProperties["common.firstSessionDate"],this.msftInternal=this._commonProperties["common.msftInternal"],this._piiPaths=t.piiPaths||[],this._telemetryLevel=3,this._sendErrorTelemetry=!!t.sendErrorTelemetry,this._meteredConnectionService=t.meteredConnectionService,this._cleanupPatterns=[/(vscode-)?file:\/\/.*?\/resources\/app\//gi];for(let n of this._piiPaths)this._cleanupPatterns.push(new RegExp(Cr(n),"gi")),n.indexOf("\\")>=0&&this._cleanupPatterns.push(new RegExp(Cr(n.replace(/\\/g,"/")),"gi"));this._updateTelemetryLevel(),this._disposables.add(this._configurationService.onDidChangeConfiguration(n=>{(n.affectsConfiguration(Wi)||n.affectsConfiguration(cs)||n.affectsConfiguration(dl))&&this._updateTelemetryLevel()})),t.waitForExperimentProperties?this._flushTimeout=setTimeout(()=>this._flushPendingEvents(),tn.BUFFER_FLUSH_TIMEOUT):this._isExperimentPropertySet=!0}static{this.IDLE_START_EVENT_NAME="UserIdleStart"}static{this.IDLE_STOP_EVENT_NAME="UserIdleStop"}static{this.BUFFER_FLUSH_TIMEOUT=1e4}static{this.MAX_BUFFER_SIZE=1e3}setExperimentProperty(t,e){this._experimentProperties[t]=e,this._isExperimentPropertySet||this._flushPendingEvents()}_flushPendingEvents(){if(!this._isExperimentPropertySet){this._isExperimentPropertySet=!0,this._flushTimeout!==void 0&&(clearTimeout(this._flushTimeout),this._flushTimeout=void 0);for(let t of this._pendingEvents)this._doLog(t.eventName,t.eventLevel,t.data);this._pendingEvents=[]}}_updateTelemetryLevel(){let t=fl(this._configurationService),e=this._productService.enabledTelemetryLevels;if(e){this._sendErrorTelemetry=this.sendErrorTelemetry?e.error:!1;let r=e.usage?3:e.error?2:0;t=Math.min(t,r)}this._telemetryLevel=t}get sendErrorTelemetry(){return this._sendErrorTelemetry}get telemetryLevel(){return this._telemetryLevel}dispose(){this._flushPendingEvents(),this._disposables.dispose()}_log(t,e,r){if(!(this._telemetryLevel<e)&&!this._meteredConnectionService?.isConnectionMetered){if(!this._isExperimentPropertySet){this._pendingEvents.length<tn.MAX_BUFFER_SIZE&&this._pendingEvents.push({eventName:t,eventLevel:e,data:r});return}this._doLog(t,e,r)}}_doLog(t,e,r){r=Si(r,this._experimentProperties),r=rg(r,this._cleanupPatterns),r=Si(r,this._commonProperties),this._appenders.forEach(n=>n.log(t,r??{}))}publicLog(t,e){this._log(t,3,e)}publicLog2(t,e){this.publicLog(t,e)}publicLogError(t,e){this._sendErrorTelemetry&&this._log(t,2,e)}publicLogError2(t,e){this.publicLogError(t,e)}};tn=T([I(1,It),I(2,ke)],tn);function $x(){let i=m(2295,null,qt.nameLong),t=qt.privacyStatementUrl?m(2281,null,"https://aka.ms/vscode-telemetry",qt.privacyStatementUrl):m(2282,null,"https://aka.ms/vscode-telemetry"),e=Je?"":m(2287,null),r=m(2280,null),n=m(2285,null),o=m(2296,null),s=m(2294,null),a=`
|       | ${r} | ${n} | ${o} |
|:------|:-------------:|:---------------:|:----------:|
| all   |       \u2713       |        \u2713        |     \u2713      |
| error |       \u2713       |        \u2713        |     -      |
| crash |       \u2713       |        -        |     -      |
| off   |       -       |        -        |     -      |
`,l=m(2290,null);return`
${i} ${t} ${e}

&nbsp;

${s}
${a}

&nbsp;

${l}
`}var jx=it.as(Kt.Configuration);jx.registerConfiguration({id:Qm,order:1,type:"object",title:m(2297,null),properties:{[Wi]:{type:"string",enum:["all","error","crash","off"],enumDescriptions:[m(2289,null),m(2291,null),m(2288,null),m(2292,null)],markdownDescription:$x(),default:"all",restricted:!0,scope:1,tags:["usesOnlineServices","telemetry"],policy:{name:"TelemetryLevel",category:"Telemetry",minimumVersion:"1.99",localization:{description:{key:"telemetry.telemetryLevel.policyDescription",value:m(2293,null)},enumDescriptions:[{key:"telemetry.telemetryLevel.default",value:m(2289,null)},{key:"telemetry.telemetryLevel.error",value:m(2291,null)},{key:"telemetry.telemetryLevel.crash",value:m(2288,null)},{key:"telemetry.telemetryLevel.off",value:m(2292,null)}]}}},"telemetry.feedback.enabled":{type:"boolean",default:!0,description:m(2286,null),policy:{name:"EnableFeedback",category:"Telemetry",minimumVersion:"1.99",localization:{description:{key:"telemetry.feedback.enabled",value:m(2286,null)}}}},[cs]:{type:"boolean",markdownDescription:qt.privacyStatementUrl?m(2284,null,qt.nameLong,qt.privacyStatementUrl):m(2283,null,qt.nameLong),default:!0,restricted:!0,markdownDeprecationMessage:m(2279,null,`\`#${Wi}#\``),scope:1,tags:["usesOnlineServices","telemetry"]}}});var Hx=!1,jd=class{constructor(t,e,r){this.id=t;this.dependencies=e;this.callback=r}};var Hd=class i{constructor(){this._isWebWorker=typeof self=="object"&&self.constructor&&self.constructor.name==="DedicatedWorkerGlobalScope";this._isRenderer=typeof document=="object";this._defineCalls=[];this._state=1}static{this.INSTANCE=new i}_initialize(){if(this._state===1){if(globalThis.define){this._state=3;return}}else return;this._state=2,globalThis.define=(t,e,r)=>{typeof t!="string"&&(r=e,e=t,t=null),(typeof e!="object"||!Array.isArray(e))&&(r=e,e=null),this._defineCalls.push(new jd(t,e,r))},globalThis.define.amd=!0,this._isRenderer?this._amdPolicy=globalThis._VSCODE_WEB_PACKAGE_TTP??window.trustedTypes?.createPolicy("amdLoader",{createScriptURL(t){if(t.startsWith(window.location.origin)||t.startsWith(`${$.vscodeFileResource}://${iu}`))return t;throw new Error(`[trusted_script_src] Invalid script url: ${t}`)}}):this._isWebWorker&&(this._amdPolicy=globalThis._VSCODE_WEB_PACKAGE_TTP??globalThis.trustedTypes?.createPolicy("amdLoader",{createScriptURL(t){return t}}))}async load(t){if(this._initialize(),this._state===3)return new Promise(s=>{let a=Ne();globalThis.define(a,[t],function(l){s(l)})});let e=await(this._isWebWorker?this._workerLoadScript(t):this._isRenderer?this._rendererLoadScript(t):this._nodeJSLoadScript(t));if(!e){console.warn(`Did not receive a define call from script ${t}`);return}let r={},n=[],o=[];if(Array.isArray(e.dependencies))for(let s of e.dependencies)s==="exports"?n.push(r):o.push(s);if(o.length>0)throw new Error(`Cannot resolve dependencies for script ${t}. The dependencies are: ${o.join(", ")}`);return typeof e.callback=="function"?e.callback(...n)??r:e.callback}_rendererLoadScript(t){return new Promise((e,r)=>{let n=document.createElement("script");n.setAttribute("async","async"),n.setAttribute("type","text/javascript");let o=()=>{n.removeEventListener("load",s),n.removeEventListener("error",a)},s=l=>{o(),e(this._defineCalls.pop())},a=l=>{o(),r(l)};n.addEventListener("load",s),n.addEventListener("error",a),this._amdPolicy&&(t=this._amdPolicy.createScriptURL(t)),n.setAttribute("src",t),window.document.getElementsByTagName("head")[0].appendChild(n)})}async _workerLoadScript(t){return this._amdPolicy&&(t=this._amdPolicy.createScriptURL(t)),await import(t),this._defineCalls.pop()}async _nodeJSLoadScript(t){try{let e=(await import("fs")).default,r=(await import("vm")).default,n=(await import("module")).default,o=P.parse(t).fsPath,s=e.readFileSync(o).toString(),a=n.wrap(s.replace(/^#!.*/,""));return new r.Script(a).runInThisContext().apply(),this._defineCalls.pop()}catch(e){throw e}}},$d=new Map;async function Qd(i,t,e){e===void 0&&(e=!!(globalThis._VSCODE_PRODUCT_JSON??globalThis.vscode?.context?.configuration()?.product)?.commit);let r=t?`${i}/${t}`:i;if($d.has(r))return $d.get(r);let n;if(/^\w[\w\d+.-]*:\/\//.test(r))n=r;else{let l=`${Hx&&e&&!Je?ff:pf}/${r}`;n=_r.asBrowserUri(l).toString(!0)}let o=Hd.INSTANCE.load(n);return $d.set(r,o),o}var Bh="https://mobile.events.data.microsoft.com/OneCollector/1.0",Qx="https://mobile.events.data.microsoft.com/ping";async function Jx(i,t,e){let r=Je?await Qd("@microsoft/1ds-core-js","bundle/ms.core.min.js"):await import("@microsoft/1ds-core-js"),n=Je?await Qd("@microsoft/1ds-post-js","bundle/ms.post.min.js"):await import("@microsoft/1ds-post-js"),o=new r.AppInsightsCore,s=new n.PostChannel,a={instrumentationKey:i,endpointUrl:Bh,loggingLevelTelemetry:0,loggingLevelConsole:0,disableCookiesUsage:!0,disableDbgExt:!0,disableInstrumentationKeyValidation:!0,channels:[[s]]};if(e){a.extensionConfig={};let l={alwaysUseXhrOverride:!0,ignoreMc1Ms0CookieProcessing:!0,httpXHROverride:e};a.extensionConfig[s.identifier]=l}return o.initialize(a,[]),o.addTelemetryInitializer(l=>{l.ext=l.ext??{},l.ext.web=l.ext.web??{},l.ext.web.consentDetails='{"GPC_DataSharingOptIn":false}',t&&(l.ext.utc=l.ext.utc??{},l.ext.utc.flags=8462029)}),o}var ic=class{constructor(t,e,r,n,o){this._isInternalTelemetry=t;this._eventPrefix=e;this._defaultData=r;this._xhrOverride=o;this.endPointUrl=Bh;this.endPointHealthUrl=Qx;this._defaultData||(this._defaultData={}),typeof n=="function"?this._aiCoreOrKey=n():this._aiCoreOrKey=n,this._asyncAiCore=null}_withAIClient(t){if(this._aiCoreOrKey){if(typeof this._aiCoreOrKey!="string"){t(this._aiCoreOrKey);return}this._asyncAiCore||(this._asyncAiCore=Jx(this._aiCoreOrKey,this._isInternalTelemetry,this._xhrOverride)),this._asyncAiCore.then(e=>{t(e)},e=>{Ke(e),console.error(e)})}}log(t,e){if(!this._aiCoreOrKey)return;e=Si(e,this._defaultData);let r=Ym(e),n=this._eventPrefix+"/"+t;try{this._withAIClient(o=>{o.pluginVersionString=r?.properties.version??"Unknown",o.track({name:n,baseData:{name:n,properties:r?.properties,measurements:r?.measurements}})})}catch{}}flush(){return this._aiCoreOrKey?new Promise(t=>{this._withAIClient(e=>{e.unload(!0,()=>{this._aiCoreOrKey=void 0,t(void 0)})})}):Promise.resolve(void 0)}};async function Xx(i,t){let e=await t.request(i,re.None),r=(await Ar(e.stream)).toString(),n=e.res.statusCode??200;return{headers:e.res.headers,statusCode:n,responseData:r}}async function Yx(i){let t=await import("https"),e={method:i.type,headers:i.headers};return new Promise((n,o)=>{let s=t.request(i.url??"",e,a=>{a.on("data",function(l){n({headers:a.headers,statusCode:a.statusCode??200,responseData:l.toString()})}),a.on("error",function(l){o(l)})});s.write(i.data,a=>{a&&o(a)}),s.end()})}async function Zx(i,t,e){let r=typeof t.data=="string"?t.data:new TextDecoder().decode(t.data),n={type:"POST",headers:{...t.headers,"Content-Type":"application/json","Content-Length":Buffer.byteLength(t.data).toString()},url:t.urlString,data:r};try{let o=i?await Xx(n,i):await Yx(n);e(o.statusCode,o.headers,o.responseData)}catch{e(0,{})}}var oc=class extends ic{constructor(t,e,r,n,o){let s={sendPOST:(a,l)=>{Zx(t,a,l)}};super(e,r,n,o,s)}};import*as ks from"fs";async function Gh(i,t){let e=Object.create(null),r=(o,s)=>{let a=JSON.parse(o);e[s]=a};if(t){let o=[],s=await ie.readdir(t);for(let l of s)try{(await ks.promises.stat(q(t,l))).isDirectory()&&o.push(l)}catch{}let a=[];for(let l of o)(await ie.readdir(q(t,l))).filter(u=>u==="telemetry.json").length===1&&a.push(l);for(let l of a){let c=(await ks.promises.readFile(q(t,l,"telemetry.json"))).toString();r(c,l)}}let n=(await ks.promises.readFile(q(i,"telemetry-core.json"))).toString();return r(n,"vscode-core"),n=(await ks.promises.readFile(q(i,"telemetry-extensions.json"))).toString(),r(n,"vscode-extensions"),JSON.stringify(e,null,4)}var eb=[];function sc(i,t,e){t instanceof Re||(t=new Re(t,[],!!e)),eb.push([i,t])}var ac=class i{constructor(t){this.uri=t;this.time=i._clock++}static{this._clock=0}touch(){return this.time=i._clock++,this}},Pn=class{constructor(t){this._fileService=t;this._dispooables=new Pe;this._limit=2**16;let e=new Map,r=n=>{let o=e.get(n.scheme);return o===void 0&&(o=t.hasProvider(n)&&!this._fileService.hasCapability(n,1024),e.set(n.scheme,o)),o};this._dispooables.add(J.any(t.onDidChangeFileSystemProviderRegistrations,t.onDidChangeFileSystemProviderCapabilities)(n=>{if(e.get(n.scheme)===void 0)return;e.delete(n.scheme);let s=r(P.from({scheme:n.scheme}));if(s!==s)for(let[a,l]of this._canonicalUris.entries())l.uri.scheme===n.scheme&&this._canonicalUris.delete(a)})),this.extUri=new Fn(r),this._canonicalUris=new Map}dispose(){this._dispooables.dispose(),this._canonicalUris.clear()}asCanonicalUri(t){this._fileService.hasProvider(t)&&(t=yf(t));let e=this.extUri.getComparisonKey(t,!0),r=this._canonicalUris.get(e);return r?r.touch().uri.with({fragment:t.fragment}):(this._canonicalUris.set(e,new ac(t)),this._checkTrim(),t)}_checkTrim(){if(this._canonicalUris.size<this._limit)return;ac._clock=1;let t=[...this._canonicalUris.values()].map(r=>r.time),e=Ks(Math.floor(t.length/2),t,(r,n)=>r-n);for(let[r,n]of this._canonicalUris.entries())n.time<=e?this._canonicalUris.delete(r):n.time=0}};Pn=T([I(0,ee)],Pn);sc(me,Pn,1);var qh=B("stateReadService"),Kh=B("stateService");var Vr=class extends Bi{constructor(e,r,n,o,s){super(n,o,r,s);this.stateReadonlyService=e;this.nativeEnvironmentService=n}getStoredProfiles(){return this.stateReadonlyService.getItem(Vr.PROFILES_KEY,[]).map(r=>({...r,location:te(r.location)?this.uriIdentityService.extUri.joinPath(this.profilesHome,r.location):P.revive(r.location)}))}getStoredProfileAssociations(){return this.stateReadonlyService.getItem(Vr.PROFILE_ASSOCIATIONS_KEY,{})}getDefaultProfileExtensionsLocation(){return this.uriIdentityService.extUri.joinPath(P.file(this.nativeEnvironmentService.extensionsPath).with({scheme:this.profilesHome.scheme}),"extensions.json")}};Vr=T([I(0,qh),I(1,me),I(2,Qe),I(3,ee),I(4,V)],Vr);var Wr=class extends Vr{constructor(e,r,n,o,s){super(e,r,n,o,s);this.stateService=e}saveStoredProfiles(e){e.length?this.stateService.setItem(Wr.PROFILES_KEY,e.map(r=>({...r,location:this.uriIdentityService.extUri.relativePath(this.profilesHome,r.location)}))):this.stateService.removeItem(Wr.PROFILES_KEY)}saveStoredProfileAssociations(e){e.emptyWindows||e.workspaces?this.stateService.setItem(Wr.PROFILE_ASSOCIATIONS_KEY,e):this.stateService.removeItem(Wr.PROFILE_ASSOCIATIONS_KEY)}};Wr=T([I(0,Kh),I(1,me),I(2,Qe),I(3,ee),I(4,V)],Wr);var lc=class extends Wr{constructor(t,e,r,n){super(new nc(0,e,n,r),t,e,r,n)}async init(){return await this.stateService.init(),super.init()}};lc=T([I(0,me),I(1,Qe),I(2,ee),I(3,V)],lc);import{networkInterfaces as sb}from"os";import{networkInterfaces as nb}from"os";var ib=new Set(["00:00:00:00:00:00","ff:ff:ff:ff:ff:ff","ac:de:48:00:11:22"]);function ob(i){let t=i.replace(/\-/g,":").toLowerCase();return!ib.has(t)}function zh(){let i=nb();for(let t in i){let e=i[t];if(e){for(let{mac:r}of e)if(ob(r))return r}}throw new Error("Unable to retrieve mac address (unexpected format)")}var NO=new class{_isVirtualMachineMacAddress(i){return this._virtualMachineOUIs||(this._virtualMachineOUIs=Qt.forStrings(),this._virtualMachineOUIs.set("00-50-56",!0),this._virtualMachineOUIs.set("00-0C-29",!0),this._virtualMachineOUIs.set("00-05-69",!0),this._virtualMachineOUIs.set("00-03-FF",!0),this._virtualMachineOUIs.set("00-1C-42",!0),this._virtualMachineOUIs.set("00-16-3E",!0),this._virtualMachineOUIs.set("08-00-27",!0),this._virtualMachineOUIs.set("00:50:56",!0),this._virtualMachineOUIs.set("00:0C:29",!0),this._virtualMachineOUIs.set("00:05:69",!0),this._virtualMachineOUIs.set("00:03:FF",!0),this._virtualMachineOUIs.set("00:1C:42",!0),this._virtualMachineOUIs.set("00:16:3E",!0),this._virtualMachineOUIs.set("08:00:27",!0)),!!this._virtualMachineOUIs.findSubstr(i)}value(){if(this._value===void 0){let i=0,t=0,e=sb();for(let r in e){let n=e[r];if(n)for(let{mac:o,internal:s}of n)s||(t+=1,this._isVirtualMachineMacAddress(o.toUpperCase())&&(i+=1))}this._value=t>0?i/t:0}return this._value}},Jd;async function $h(i){return Jd||(Jd=(async()=>await ab(i)||Ne())()),Jd}async function ab(i){try{let t=await import("crypto"),e=zh();return t.createHash("sha256").update(e,"utf8").digest("hex")}catch(t){i(t);return}}var lb="Software\\Microsoft\\SQMClient";async function jh(i){if(pe){let t=await import("@vscode/windows-registry");try{return t.GetStringRegKey("HKEY_LOCAL_MACHINE",lb,"MachineId")||""}catch(e){return i(e),""}}return""}async function Hh(i){try{return await(await import("@vscode/deviceid")).getDeviceId()}catch(t){return i(t),Ne()}}async function Qh(i,t){let e=i.getItem($m);return(typeof e!="string"||ft&&e==="6c9d2bc8f91b89624add29c0abeae7fb42bf539fa1cdb2e3e57cd668fa9bcead")&&(e=await $h(t.error.bind(t))),e}async function Jh(i,t){let e=i.getItem(jm);return typeof e!="string"&&(e=await jh(t.error.bind(t))),e}async function Xh(i,t){let e=i.getItem(Hm);return typeof e!="string"&&(e=await Hh(t.error.bind(t))),e}var uo=class extends ji{constructor(t,e,r,n,o){super(P.file(t.extensionsPath),e,r,n,o)}};uo=T([I(0,Qe),I(1,ee),I(2,$e),I(3,me),I(4,V)],uo);var cc=class extends _{constructor(t,e=[]){super(),this.logger=new Ha([t,...e]),this._register(t.onDidChangeLogLevel(r=>this.setLevel(r)))}get onDidChangeLogLevel(){return this.logger.onDidChangeLogLevel}setLevel(t){this.logger.setLevel(t)}getLevel(){return this.logger.getLevel()}trace(t,...e){this.logger.trace(t,...e)}debug(t,...e){this.logger.debug(t,...e)}info(t,...e){this.logger.info(t,...e)}warn(t,...e){this.logger.warn(t,...e)}error(t,...e){this.logger.error(t,...e)}flush(){this.logger.flush()}};async function cb(i,t,e,r,n){try{let o=await import("@vscode/spdlog");o.setFlushOn(0);let s=await o.createAsyncRotatingLogger(i,t,e,r);return n?s.clearFormatters():s.setPattern("%Y-%m-%d %H:%M:%S.%e [%l] %v"),s}catch(o){console.error(o)}return null}function Yh(i,t,e){switch(t){case 1:i.trace(e);break;case 2:i.debug(e);break;case 3:i.info(e);break;case 4:i.warn(e);break;case 5:i.error(e);break;case 0:break;default:throw new Error(`Invalid log level ${t}`)}}function Zh(i,t){switch(t){case 1:i.setLevel(0);break;case 2:i.setLevel(1);break;case 3:i.setLevel(2);break;case 4:i.setLevel(3);break;case 5:i.setLevel(4);break;case 0:i.setLevel(6);break;default:throw new Error(`Invalid log level ${t}`)}}var uc=class extends ja{constructor(e,r,n,o,s){super();this.buffer=[];this.setLevel(s),this._loggerCreationPromise=this._createSpdLogLogger(e,r,n,o),this._register(this.onDidChangeLogLevel(a=>{this._logger&&Zh(this._logger,a)}))}async _createSpdLogLogger(e,r,n,o){let s=n?6:1,a=30/s*Ua.MB,l=await cb(e,r,a,s,o);if(l){this._logger=l,Zh(this._logger,this.getLevel());for(let{level:c,message:u}of this.buffer)Yh(this._logger,c,u);this.buffer=[]}}log(e,r){this._logger?Yh(this._logger,e,r):this.getLevel()<=e&&this.buffer.push({level:e,message:r})}flush(){this._logger?this.flushLogger():this._loggerCreationPromise.then(()=>this.flushLogger())}dispose(){this._logger?this.disposeLogger():this._loggerCreationPromise.then(()=>this.disposeLogger()),super.dispose()}flushLogger(){this._logger&&this._logger.flush()}disposeLogger(){this._logger&&(this._logger.drop(),this._logger=void 0)}};var dc=class extends Qa{doCreateLogger(t,e,r){return new uc(Ne(),t.fsPath,!r?.donotRotate,!!r?.donotUseFormatters,e)}};var pc=class extends _{constructor(e,r,n,o,s,a){super();this.fileSystemScheme=e;this.fileSystemProvider=r;this.userDataScheme=n;this.userDataProfilesService=o;this.uriIdentityService=s;this.logService=a;this.capabilities=this.fileSystemProvider.capabilities,this.onDidChangeCapabilities=this.fileSystemProvider.onDidChangeCapabilities,this._onDidChangeFile=this._register(new R),this.onDidChangeFile=this._onDidChangeFile.event,this.watchResources=Qt.forUris(()=>!(this.capabilities&1024)),this.atomicReadWriteResources=new on(l=>this.uriIdentityService.extUri.getComparisonKey(this.toFileSystemResource(l))),this.updateAtomicReadWritesResources(),this._register(o.onDidChangeProfiles(()=>this.updateAtomicReadWritesResources())),this._register(this.fileSystemProvider.onDidChangeFile(l=>this.handleFileChanges(l)))}updateAtomicReadWritesResources(){this.atomicReadWriteResources.clear();for(let e of this.userDataProfilesService.profiles)this.atomicReadWriteResources.add(e.settingsResource),this.atomicReadWriteResources.add(e.keybindingsResource),this.atomicReadWriteResources.add(e.tasksResource),this.atomicReadWriteResources.add(e.extensionsResource)}open(e,r){return this.fileSystemProvider.open(this.toFileSystemResource(e),r)}close(e){return this.fileSystemProvider.close(e)}read(e,r,n,o,s){return this.fileSystemProvider.read(e,r,n,o,s)}write(e,r,n,o,s){return this.fileSystemProvider.write(e,r,n,o,s)}watch(e,r){this.watchResources.set(e,e);let n=this.fileSystemProvider.watch(this.toFileSystemResource(e),r);return ue(()=>{this.watchResources.delete(e),n.dispose()})}stat(e){return this.fileSystemProvider.stat(this.toFileSystemResource(e))}mkdir(e){return this.fileSystemProvider.mkdir(this.toFileSystemResource(e))}rename(e,r,n){return this.fileSystemProvider.rename(this.toFileSystemResource(e),this.toFileSystemResource(r),n)}readFile(e,r){return this.fileSystemProvider.readFile(this.toFileSystemResource(e),r)}readFileStream(e,r,n){return this.fileSystemProvider.readFileStream(this.toFileSystemResource(e),r,n)}readdir(e){return this.fileSystemProvider.readdir(this.toFileSystemResource(e))}enforceAtomicReadFile(e){return this.atomicReadWriteResources.has(e)}writeFile(e,r,n){return this.fileSystemProvider.writeFile(this.toFileSystemResource(e),r,n)}enforceAtomicWriteFile(e){return this.atomicReadWriteResources.has(e)?{postfix:".vsctmp"}:!1}delete(e,r){return this.fileSystemProvider.delete(this.toFileSystemResource(e),r)}copy(e,r,n){if(zo(this.fileSystemProvider))return this.fileSystemProvider.copy(this.toFileSystemResource(e),this.toFileSystemResource(r),n);throw new Error("copy not supported")}cloneFile(e,r){if(Ma(this.fileSystemProvider))return this.fileSystemProvider.cloneFile(this.toFileSystemResource(e),this.toFileSystemResource(r));throw new Error("clone not supported")}handleFileChanges(e){let r=[];for(let n of e){if(n.resource.scheme!==this.fileSystemScheme)continue;let o=this.toUserDataResource(n.resource);this.watchResources.findSubstr(o)&&r.push({resource:o,type:n.type,cId:n.cId})}r.length&&(this.logService.debug("User data changed"),this._onDidChangeFile.fire(r))}toFileSystemResource(e){return e.with({scheme:this.fileSystemScheme})}toUserDataResource(e){return e.with({scheme:this.userDataScheme})}};function ub(){return process.uncHostAllowlist}function Xd(i){if(process.platform!=="win32")return;let t=ub();if(t)if(typeof i=="string")t.add(i.toLowerCase());else for(let e of db(i))Xd(e)}function db(i){let t=new Set;if(Array.isArray(i))for(let e of i)typeof e=="string"&&t.add(e);return Array.from(t)}function ev(i){if(typeof i!="string")return;let t=["\\\\.\\UNC\\","\\\\?\\UNC\\","\\\\"],e;for(let r of t){if(i.indexOf(r)!==0)continue;let o=i.indexOf("\\",r.length);if(o===-1)continue;let s=i.substring(r.length,o);if(s){e=s;break}}return e}function pb(i){return i.type==="gallery"}function fb(i){return i.type===1||i.type===0}var mb=/^(?<version>\d+\.\d+\.\d+(-.*)?)(@(?<platform>.+))?$/,po=class extends _{constructor(e,r){super();this.configurationService=r;this._onDidChangeAllowedExtensions=this._register(new R);this.onDidChangeAllowedExtensionsConfigValue=this._onDidChangeAllowedExtensions.event;this.publisherOrgs=e.extensionPublisherOrgs?.map(n=>n.toLowerCase())??[],this._allowedExtensionsConfigValue=this.getAllowedExtensionsValue(),this._register(this.configurationService.onDidChangeConfiguration(n=>{n.affectsConfiguration(ls)&&(this._allowedExtensionsConfigValue=this.getAllowedExtensionsValue(),this._onDidChangeAllowedExtensions.fire())}))}get allowedExtensionsConfigValue(){return this._allowedExtensionsConfigValue}getAllowedExtensionsValue(){let e=this.configurationService.getValue(ls);if(!he(e)||Array.isArray(e))return;let r=Object.entries(e).map(([n,o])=>[n.toLowerCase(),o]);if(!(r.length===1&&r[0][0]==="*"&&r[0][1]===!0))return Object.fromEntries(r)}isAllowed(e){if(!this._allowedExtensionsConfigValue)return!0;let r,n,o,s,a,l;pb(e)?(r=e.identifier.id.toLowerCase(),n=e.version,s=e.properties.isPreReleaseVersion,a=e.publisher.toLowerCase(),l=e.publisherDisplayName.toLowerCase(),o=e.properties.targetPlatform):fb(e)?(r=e.identifier.id.toLowerCase(),n=e.manifest.version,s=e.preRelease,a=e.manifest.publisher.toLowerCase(),l=e.publisherDisplayName?.toLowerCase(),o=e.targetPlatform):(r=e.id.toLowerCase(),n=e.version??"*",o=e.targetPlatform??"universal",s=e.prerelease??!1,a=e.id.substring(0,e.id.indexOf(".")).toLowerCase(),l=e.publisherDisplayName?.toLowerCase());let c=Ul("workbench.action.openSettings",{query:`@id:${ls}`}).toString(),u=this._allowedExtensionsConfigValue[r],p=new ht(m(1956,null,c));if(!ut(u))return Tt(u)?u?!0:p:u==="stable"&&s?new ht(m(1953,null,c)):n!=="*"&&Array.isArray(u)&&!u.some(v=>{let h=mb.exec(v);if(h&&h.groups){let{platform:y,version:E}=h.groups;return!(E!==n||o!=="universal"&&y&&o!==y)}return!1})?new ht(m(1957,null,n,c)):!0;let f=l&&this.publisherOrgs.includes(l)?l:a,g=this._allowedExtensionsConfigValue[f];return ut(g)?this._allowedExtensionsConfigValue["*"]===!0?!0:p:Tt(g)?g?!0:new ht(m(1955,null,f,c)):g==="stable"&&s?new ht(m(1954,null,f,c)):!0}};po=T([I(0,ke),I(1,It)],po);var ti=B("IMcpGalleryService"),fc=B("IMcpManagementService"),Ds=B("IAllowedMcpServersService"),mc="chat.mcp.access";var fo=class{constructor(t,e){this._logger=t;this._mcpManagementService=e}async addMcpDefinitions(t){let e=t.map(r=>this.validateConfiguration(r));await this.updateMcpInResource(e),this._logger.info(`Added MCP servers: ${e.map(r=>r.name).join(", ")}`)}async updateMcpInResource(t){await Promise.all(t.map(({name:e,config:r,inputs:n})=>this._mcpManagementService.install({name:e,config:r,inputs:n})))}validateConfiguration(t){let e;try{e=JSON.parse(t)}catch(s){throw new Ls(`Invalid JSON '${t}': ${s}`)}if(!e.name)throw new Ls(`Missing name property in ${t}`);if(!("command"in e)&&!("url"in e))throw new Ls(`Missing command or URL property in ${t}`);let{name:r,inputs:n,...o}=e;return{name:r,inputs:n,config:o}}};fo=T([I(1,fc)],fo);var Ls=class extends Error{constructor(t){super(t),this.stack=t}};var mo=class extends _{constructor(e){super();this.productService=e;this.onDidChangeExtensionGalleryManifest=J.None;this.onDidChangeExtensionGalleryManifestStatus=J.None}get extensionGalleryManifestStatus(){return this.productService.extensionsGallery?.serviceUrl?"available":"unavailable"}async getExtensionGalleryManifest(){let e=this.productService.extensionsGallery;if(!e?.serviceUrl)return null;let r=[{id:`${e.serviceUrl}/extensionquery`,type:"ExtensionQueryService"},{id:`${e.serviceUrl}/vscode/{publisher}/{name}/latest`,type:"ExtensionLatestVersionUriTemplate"},{id:`${e.serviceUrl}/publishers/{publisher}/extensions/{name}/{version}/stats?statType={statTypeName}`,type:"ExtensionStatisticsUriTemplate"}];e.publisherUrl&&r.push({id:`${e.publisherUrl}/{publisher}`,type:"PublisherViewUriTemplate"}),e.itemUrl&&(r.push({id:`${e.itemUrl}?itemName={publisher}.{name}`,type:"ExtensionDetailsViewUriTemplate"}),r.push({id:`${e.itemUrl}?itemName={publisher}.{name}&ssr=false#review-details`,type:"ExtensionRatingViewUriTemplate"})),e.resourceUrlTemplate&&r.push({id:e.resourceUrlTemplate,type:"ExtensionResourceUriTemplate"});let n=[{name:"Tag",value:1},{name:"ExtensionId",value:4},{name:"Category",value:5},{name:"ExtensionName",value:7},{name:"Target",value:8},{name:"Featured",value:9},{name:"SearchText",value:10},{name:"ExcludeWithFlags",value:12}],o=[{name:"NoneOrRelevance",value:0},{name:"LastUpdatedDate",value:1},{name:"Title",value:2},{name:"PublisherName",value:3},{name:"InstallCount",value:4},{name:"AverageRating",value:6},{name:"PublishedDate",value:10},{name:"WeightedRating",value:12}],s=[{name:"None",value:0},{name:"IncludeVersions",value:1},{name:"IncludeFiles",value:2},{name:"IncludeCategoryAndTags",value:4},{name:"IncludeSharedAccounts",value:8},{name:"IncludeVersionProperties",value:16},{name:"ExcludeNonValidated",value:32},{name:"IncludeInstallationTargets",value:64},{name:"IncludeAssetUri",value:128},{name:"IncludeStatistics",value:256},{name:"IncludeLatestVersionOnly",value:512},{name:"Unpublished",value:4096},{name:"IncludeNameConflictInfo",value:32768},{name:"IncludeLatestPrereleaseAndStableVersionOnly",value:65536}];return{version:"",resources:r,capabilities:{extensionQuery:{filtering:n,sorting:o,flags:s},signing:{allPublicRepositorySigned:!0}}}}};mo=T([I(0,ke)],mo);var Tn=B("IMcpResourceScannerService"),ri=class extends _{constructor(e,r){super();this.fileService=e;this.uriIdentityService=r;this.resourcesAccessQueueMap=new be}async scanMcpServers(e,r){return this.withProfileMcpServers(e,r)}async addMcpServers(e,r,n){await this.withProfileMcpServers(r,n,o=>{let s=o.inputs??[],a=o.servers??{};for(let{name:l,config:c,inputs:u}of e)if(a[l]=c,u){let p=new Set(s.map(g=>g.id)),f=u.filter(g=>!p.has(g.id));s=[...s,...f]}return{servers:a,inputs:s}})}async removeMcpServers(e,r,n){await this.withProfileMcpServers(r,n,o=>{for(let s of e)o.servers?.[s]&&delete o.servers[s];return o})}async withProfileMcpServers(e,r,n){return this.getResourceAccessQueue(e).queue(async()=>{r=r??2;let o={};try{let s=await this.fileService.readFile(e),a=[],l=Ur(s.value.toString(),a,{allowTrailingComma:!0,allowEmptyContent:!0})||{};if(a.length>0)throw new Error("Failed to parse scanned MCP servers: "+a.join(", "));if(r===2)o=this.fromUserMcpServers(l);else if(r===6)o=this.fromWorkspaceFolderMcpServers(l);else if(r===5){let c=l;c.settings?.mcp&&(o=this.fromWorkspaceFolderMcpServers(c.settings?.mcp))}}catch(s){if(Se(s)!==1)throw s}return n&&(o=n(o??{}),r===2?await this.writeScannedMcpServers(e,o):r===6?await this.writeScannedMcpServersToWorkspaceFolder(e,o):r===5?await this.writeScannedMcpServersToWorkspace(e,o):kc(r,`Invalid Target: ${Cf(r)}`)),o})}async writeScannedMcpServers(e,r){r.servers&&Object.keys(r.servers).length>0||r.inputs&&r.inputs.length>0?await this.fileService.writeFile(e,U.fromString(JSON.stringify(r,null,"	"))):await this.fileService.del(e)}async writeScannedMcpServersToWorkspaceFolder(e,r){await this.fileService.writeFile(e,U.fromString(JSON.stringify(r,null,"	")))}async writeScannedMcpServersToWorkspace(e,r){let n;try{let o=await this.fileService.readFile(e),s=[];if(n=Ur(o.value.toString(),s,{allowTrailingComma:!0,allowEmptyContent:!0}),s.length>0)throw new Error("Failed to parse scanned MCP servers: "+s.join(", "))}catch(o){if(Se(o)!==1)throw o;n={settings:{}}}n.settings||(n.settings={}),n.settings.mcp=r,await this.fileService.writeFile(e,U.fromString(JSON.stringify(n,null,"	")))}fromUserMcpServers(e){let r={inputs:e.inputs},n=Object.entries(e.servers??{});if(n.length>0){r.servers={};for(let[o,s]of n)r.servers[o]=this.sanitizeServer(s)}return r}fromWorkspaceFolderMcpServers(e){let r={inputs:e.inputs},n=Object.entries(e.servers??{});if(n.length>0){r.servers={};for(let[o,s]of n)r.servers[o]=this.sanitizeServer(s)}return r}sanitizeServer(e){let r;if(e.config){let n=e;r={...n.config,version:n.version,gallery:n.gallery}}else r=e;return(r.type===void 0||r.type!=="http"&&r.type!=="stdio")&&(r.type=r.command?"stdio":"http"),r}getResourceAccessQueue(e){let r=this.resourcesAccessQueueMap.get(e);return r||(r=new jt,this.resourcesAccessQueueMap.set(e,r)),r}};ri=T([I(0,ee),I(1,me)],ri);sc(Tn,ri,1);var go=class extends _{constructor(e){super();this.logService=e}getMcpServerConfigurationFromManifest(e,r){if(r==="remote"&&e.remotes?.length){let c=e.remotes[0].url,u=e.remotes[0].headers??[],{inputs:p,variables:f}=this.processKeyValueInputs(c.startsWith("https://api.githubcopilot.com/mcp")?u.filter(g=>g.name.toLowerCase()!=="authorization"):u);return{mcpServerConfiguration:{config:{type:"http",url:e.remotes[0].url,headers:Object.keys(p).length?p:void 0},inputs:f.length?f:void 0},notices:[]}}let n=e.packages?.find(c=>c.registryType===r)??e.packages?.[0];if(!n)throw new Error("No server package found");let o=[],s=[],a={},l=[];if(n.registryType==="oci"&&(o.push("run"),o.push("-i"),o.push("--rm")),n.runtimeArguments?.length){let c=this.processArguments(n.runtimeArguments??[]);o.push(...c.args),s.push(...c.variables),l.push(...c.notices)}if(n.environmentVariables?.length){let{inputs:c,variables:u,notices:p}=this.processKeyValueInputs(n.environmentVariables??[]);s.push(...u),l.push(...p);for(let[f,g]of Object.entries(c))a[f]=g,n.registryType==="oci"&&(o.push("-e"),o.push(f))}switch(n.registryType){case"npm":n.registryBaseUrl&&o.push("--registry",n.registryBaseUrl),o.push(n.version?`${n.identifier}@${n.version}`:n.identifier);break;case"pypi":n.registryBaseUrl&&o.push("--index-url",n.registryBaseUrl),o.push(n.version?`${n.identifier}@${n.version}`:n.identifier);break;case"oci":{let c=n.registryBaseUrl?`${n.registryBaseUrl}/${n.identifier}`:n.identifier;o.push(n.version?`${c}:${n.version}`:c);break}case"nuget":o.push(n.version?`${n.identifier}@${n.version}`:n.identifier),o.push("--yes"),n.registryBaseUrl&&o.push("--source",n.registryBaseUrl),n.packageArguments?.length&&o.push("--");break}if(n.packageArguments?.length){let c=this.processArguments(n.packageArguments);o.push(...c.args),s.push(...c.variables),l.push(...c.notices)}return{notices:l,mcpServerConfiguration:{config:{type:"stdio",command:this.getCommandName(n.registryType),args:o.length?o:void 0,env:Object.keys(a).length?a:void 0},inputs:s.length?s:void 0}}}getCommandName(e){switch(e){case"npm":return"npx";case"oci":return"docker";case"pypi":return"uvx";case"nuget":return"dnx"}return e}getVariables(e){let r=[];for(let[n,o]of Object.entries(e))r.push({id:n,type:o.choices?"pickString":"promptString",description:o.description??"",password:!!o.isSecret,default:o.default,options:o.choices});return r}processKeyValueInputs(e){let r=[],n={},o=[];for(let s of e){let a=s.variables?this.getVariables(s.variables):[],l=s.value||"";if(a.length){for(let c of a)l=l.replace(`{${c.id}}`,`\${input:${c.id}}`);o.push(...a)}else!l&&(s.description||s.choices||s.default!==void 0)&&(o.push({id:s.name,type:s.choices?"pickString":"promptString",description:s.description??"",password:!!s.isSecret,default:s.default,options:s.choices}),l=`\${input:${s.name}}`);n[s.name]=l}return{inputs:n,variables:o,notices:r}}processArguments(e){let r=[],n=[],o=[];for(let s of e){let a=s.variables?this.getVariables(s.variables):[];if(s.type==="positional"){let l=s.value;if(l){for(let c of a)l=l.replace(`{${c.id}}`,`\${input:${c.id}}`);r.push(l),a.length&&n.push(...a)}else s.valueHint&&(s.description||s.default!==void 0)?(n.push({id:s.valueHint,type:"promptString",description:s.description??"",password:!1,default:s.default}),r.push(`\${input:${s.valueHint}}`)):r.push(s.valueHint??"")}else if(s.type==="named"){if(!s.name){o.push(`Named argument is missing a name. ${JSON.stringify(s)}`);continue}if(r.push(s.name),s.value){let l=s.value;for(let c of a)l=l.replace(`{${c.id}}`,`\${input:${c.id}}`);r.push(l),a.length&&n.push(...a)}else if(s.description||s.default!==void 0){let l=s.name.replace(/^--?/,"");n.push({id:l,type:"promptString",description:s.description??"",password:!1,default:s.default}),r.push(`\${input:${l}}`)}}}return{args:r,variables:n,notices:o}}};go=T([I(0,V)],go);var As=class extends go{constructor(e,r,n,o,s,a,l){super(a);this.mcpResource=e;this.target=r;this.mcpGalleryService=n;this.fileService=o;this.uriIdentityService=s;this.mcpResourceScannerService=l;this.local=new Map;this._onInstallMcpServer=this._register(new R);this.onInstallMcpServer=this._onInstallMcpServer.event;this._onDidInstallMcpServers=this._register(new R);this._onDidUpdateMcpServers=this._register(new R);this._onUninstallMcpServer=this._register(new R);this._onDidUninstallMcpServer=this._register(new R);this.reloadConfigurationScheduler=this._register(new Dr(()=>this.updateLocal(),50))}get onDidInstallMcpServers(){return this._onDidInstallMcpServers.event}get onDidUpdateMcpServers(){return this._onDidUpdateMcpServers.event}get onUninstallMcpServer(){return this._onUninstallMcpServer.event}get onDidUninstallMcpServer(){return this._onDidUninstallMcpServer.event}initialize(){return this.initializePromise||(this.initializePromise=(async()=>{try{this.local=await this.populateLocalServers()}finally{this.startWatching()}})()),this.initializePromise}async populateLocalServers(){this.logService.trace("AbstractMcpResourceManagementService#populateLocalServers",this.mcpResource.toString());let e=new Map;try{let r=await this.mcpResourceScannerService.scanMcpServers(this.mcpResource,this.target);r.servers&&await Promise.allSettled(Object.entries(r.servers).map(async([n,o])=>{let s=await this.scanLocalServer(n,o);e.set(n,s)}))}catch(r){throw this.logService.debug("Could not read user MCP servers:",r),r}return e}startWatching(){this._register(this.fileService.watch(this.mcpResource)),this._register(this.fileService.onDidFilesChange(e=>{e.affects(this.mcpResource)&&this.reloadConfigurationScheduler.schedule()}))}async updateLocal(){try{let e=await this.populateLocalServers(),r=[],n=[],o=[...this.local.keys()].filter(s=>!e.has(s));for(let s of o)this.local.delete(s);for(let[s,a]of e){let l=this.local.get(s);l?xt(l,a)||(n.push(a),this.local.set(s,a)):(r.push(a),this.local.set(s,a))}for(let s of o)this.local.delete(s),this._onDidUninstallMcpServer.fire({name:s,mcpResource:this.mcpResource});n.length&&this._onDidUpdateMcpServers.fire(n.map(s=>({name:s.name,local:s,mcpResource:this.mcpResource}))),r.length&&this._onDidInstallMcpServers.fire(r.map(s=>({name:s.name,local:s,mcpResource:this.mcpResource})))}catch(e){this.logService.error("Failed to load installed MCP servers:",e)}}async getInstalled(){return await this.initialize(),Array.from(this.local.values())}async scanLocalServer(e,r){let n=await this.getLocalServerInfo(e,r);return n||(n={name:e,version:r.version,galleryUrl:te(r.gallery)?r.gallery:void 0}),{name:e,config:r,mcpResource:this.mcpResource,version:n.version,location:n.location,displayName:n.displayName,description:n.description,publisher:n.publisher,publisherDisplayName:n.publisherDisplayName,galleryUrl:n.galleryUrl,galleryId:n.galleryId,repositoryUrl:n.repositoryUrl,readmeUrl:n.readmeUrl,icon:n.icon,codicon:n.codicon,manifest:n.manifest,source:r.gallery?"gallery":"local"}}async install(e,r){this.logService.trace("MCP Management Service: install",e.name),this._onInstallMcpServer.fire({name:e.name,mcpResource:this.mcpResource});try{await this.mcpResourceScannerService.addMcpServers([e],this.mcpResource,this.target),await this.updateLocal();let n=this.local.get(e.name);if(!n)throw new Error(`Failed to install MCP server: ${e.name}`);return n}catch(n){throw this._onDidInstallMcpServers.fire([{name:e.name,error:n,mcpResource:this.mcpResource}]),n}}async uninstall(e,r){this.logService.trace("MCP Management Service: uninstall",e.name),this._onUninstallMcpServer.fire({name:e.name,mcpResource:this.mcpResource});try{if(!(await this.mcpResourceScannerService.scanMcpServers(this.mcpResource,this.target)).servers)return;await this.mcpResourceScannerService.removeMcpServers([e.name],this.mcpResource,this.target),e.location&&await this.fileService.del(P.revive(e.location),{recursive:!0}),await this.updateLocal()}catch(n){throw this._onDidUninstallMcpServer.fire({name:e.name,error:n,mcpResource:this.mcpResource}),n}}};As=T([I(2,ti),I(3,ee),I(4,me),I(5,V),I(6,Tn)],As);var ni=class extends As{constructor(t,e,r,n,o,s,a){super(t,2,e,r,n,o,s),this.mcpLocation=n.extUri.joinPath(a.userRoamingDataHome,"mcp")}async installFromGallery(t,e){throw new Error("Not supported")}async updateMetadata(t,e){await this.updateMetadataFromGallery(e),await this.updateLocal();let r=(await this.getInstalled()).find(n=>n.name===t.name);if(!r)throw new Error(`Failed to find MCP server: ${t.name}`);return r}async updateMetadataFromGallery(t){let e=t.configuration,r=this.getLocation(t.name,t.version),n=this.uriIdentityService.extUri.joinPath(r,"manifest.json"),o={galleryUrl:t.galleryUrl,galleryId:t.id,name:t.name,displayName:t.displayName,description:t.description,version:t.version,publisher:t.publisher,publisherDisplayName:t.publisherDisplayName,repositoryUrl:t.repositoryUrl,licenseUrl:t.license,icon:t.icon,codicon:t.codicon,manifest:e};if(await this.fileService.writeFile(n,U.fromString(JSON.stringify(o))),t.readmeUrl||t.readme){let s=t.readme?t.readme:await this.mcpGalleryService.getReadme(t,re.None);await this.fileService.writeFile(this.uriIdentityService.extUri.joinPath(r,"README.md"),U.fromString(s))}return e}async getLocalServerInfo(t,e){let r,n,o;if(e.gallery){n=this.getLocation(t,e.version);let s=this.uriIdentityService.extUri.joinPath(n,"manifest.json");try{let a=await this.fileService.readFile(s);r=JSON.parse(a.value.toString()),r.galleryUrl?.includes("/v0/")&&(r.galleryUrl=r.galleryUrl.substring(0,r.galleryUrl.indexOf("/v0/")),await this.fileService.writeFile(s,U.fromString(JSON.stringify(r)))),r.location=n,o=this.uriIdentityService.extUri.joinPath(n,"README.md"),await this.fileService.exists(o)||(o=void 0),r.readmeUrl=o}catch(a){this.logService.error("MCP Management Service: failed to read manifest",n.toString(),a)}}return r}getLocation(t,e){return t=t.replace("/","."),this.uriIdentityService.extUri.joinPath(this.mcpLocation,e?`${t}-${e}`:t)}installFromUri(t,e){throw new Error("Method not supported.")}canInstall(){throw new Error("Not supported")}};ni=T([I(1,ti),I(2,ee),I(3,me),I(4,V),I(5,Tn),I(6,gt)],ni);var Us=class extends go{constructor(e,r){super(r);this.allowedMcpServersService=e}canInstall(e){let r=this.allowedMcpServersService.isAllowed(e);return r!==!0?new ht(m(2153,null,r.value)):!0}};Us=T([I(0,Ds),I(1,V)],Us);var ho=class extends Us{constructor(e,r,n,o){super(e,r);this.userDataProfilesService=n;this.instantiationService=o;this._onInstallMcpServer=this._register(new R);this.onInstallMcpServer=this._onInstallMcpServer.event;this._onDidInstallMcpServers=this._register(new R);this.onDidInstallMcpServers=this._onDidInstallMcpServers.event;this._onDidUpdateMcpServers=this._register(new R);this.onDidUpdateMcpServers=this._onDidUpdateMcpServers.event;this._onUninstallMcpServer=this._register(new R);this.onUninstallMcpServer=this._onUninstallMcpServer.event;this._onDidUninstallMcpServer=this._register(new R);this.onDidUninstallMcpServer=this._onDidUninstallMcpServer.event;this.mcpResourceManagementServices=new be}getMcpResourceManagementService(e){let r=this.mcpResourceManagementServices.get(e);if(!r){let n=new Pe,o=n.add(this.createMcpResourceManagementService(e));n.add(o.onInstallMcpServer(s=>this._onInstallMcpServer.fire(s))),n.add(o.onDidInstallMcpServers(s=>this._onDidInstallMcpServers.fire(s))),n.add(o.onDidUpdateMcpServers(s=>this._onDidUpdateMcpServers.fire(s))),n.add(o.onUninstallMcpServer(s=>this._onUninstallMcpServer.fire(s))),n.add(o.onDidUninstallMcpServer(s=>this._onDidUninstallMcpServer.fire(s))),this.mcpResourceManagementServices.set(e,r={service:o,dispose:()=>n.dispose()})}return r.service}async getInstalled(e){let r=e||this.userDataProfilesService.defaultProfile.mcpResource;return this.getMcpResourceManagementService(r).getInstalled()}async install(e,r){let n=r?.mcpResource||this.userDataProfilesService.defaultProfile.mcpResource;return this.getMcpResourceManagementService(n).install(e,r)}async uninstall(e,r){let n=r?.mcpResource||this.userDataProfilesService.defaultProfile.mcpResource;return this.getMcpResourceManagementService(n).uninstall(e,r)}async installFromGallery(e,r){let n=r?.mcpResource||this.userDataProfilesService.defaultProfile.mcpResource;return this.getMcpResourceManagementService(n).installFromGallery(e,r)}async updateMetadata(e,r,n){return this.getMcpResourceManagementService(n||this.userDataProfilesService.defaultProfile.mcpResource).updateMetadata(e,r)}dispose(){this.mcpResourceManagementServices.forEach(e=>e.dispose()),this.mcpResourceManagementServices.clear(),super.dispose()}createMcpResourceManagementService(e){return this.instantiationService.createInstance(ni,e)}};ho=T([I(0,Ds),I(1,V),I(2,$e),I(3,Lr)],ho);var Ms=class extends ni{constructor(t,e,r,n,o,s,a){super(t,e,r,n,o,s,a)}async installFromGallery(t,e){this.logService.trace("MCP Management Service: installGallery",t.name,t.galleryUrl),this._onInstallMcpServer.fire({name:t.name,mcpResource:this.mcpResource});try{let r=await this.updateMetadataFromGallery(t),n=e?.packageType??(r.remotes?.length?"remote":r.packages?.[0]?.registryType??"remote"),{mcpServerConfiguration:o,notices:s}=this.getMcpServerConfigurationFromManifest(r,n);s.length>0&&this.logService.warn(`MCP Management Service: Warnings while installing ${t.name}`,s);let a={name:t.name,config:{...o.config,gallery:t.galleryUrl??!0,version:t.version},inputs:o.inputs};await this.mcpResourceScannerService.addMcpServers([a],this.mcpResource,this.target),await this.updateLocal();let l=(await this.getInstalled()).find(c=>c.name===t.name);if(!l)throw new Error(`Failed to install MCP server: ${t.name}`);return l}catch(r){throw this._onDidInstallMcpServers.fire([{name:t.name,source:t,error:r,mcpResource:this.mcpResource}]),r}}};Ms=T([I(1,ti),I(2,ee),I(3,me),I(4,V),I(5,Tn),I(6,gt)],Ms);var gc=class extends ho{createMcpResourceManagementService(t){return this.instantiationService.createInstance(Ms,t)}};var hc=B("IMcpGalleryManifestService");function ii(i,t){let[e,r]=t.split("/");for(let n of i.resources){let[o,s]=n.type.split("/");if(o===e){if(!r||s===r)return n.id;break}}}var rv;(n=>{n.VERSION="v0-2025-07-09",n.SCHEMA="https://static.modelcontextprotocol.io/schemas/2025-07-09/server.schema.json";class e{toRawGalleryMcpServerResult(s){if(!s||typeof s!="object"||!Array.isArray(s.servers))return;let a=s,l=[];for(let c of a.servers){let u=this.toRawGalleryMcpServer(c);if(!u)return;l.push(u)}return{metadata:{count:a.metadata.count??0,nextCursor:a.metadata?.next_cursor},servers:l}}toRawGalleryMcpServer(s){if(!s||typeof s!="object")return;let a=s;if(!a.name||!te(a.name)||!a.description||!te(a.description)||!a.version||!te(a.version)||a.$schema&&a.$schema!==n.SCHEMA)return;let l=a._meta?.["io.modelcontextprotocol.registry/official"];function c(y){return{...y,isRequired:y.is_required,isSecret:y.is_secret}}function u(y){let E={};for(let[b,C]of Object.entries(y))E[b]=c(C);return E}function p(y){return y.type==="positional"?{...y,valueHint:y.value_hint,isRepeated:y.is_repeated,isRequired:y.is_required,isSecret:y.is_secret,variables:y.variables?u(y.variables):void 0}:{...y,isRepeated:y.is_repeated,isRequired:y.is_required,isSecret:y.is_secret,variables:y.variables?u(y.variables):void 0}}function f(y){return{...y,isRequired:y.is_required,isSecret:y.is_secret,variables:y.variables?u(y.variables):void 0}}function g(y){switch(y.type){case"stdio":return{type:"stdio"};case"streamable-http":return{type:"streamable-http",url:y.url,headers:y.headers?.map(f)};case"sse":return{type:"sse",url:y.url,headers:y.headers?.map(f)};default:return{type:"stdio"}}}function v(y){switch(y){case"npm":return"npm";case"docker":case"docker-hub":case"oci":return"oci";case"pypi":return"pypi";case"nuget":return"nuget";case"mcpb":return"mcpb";default:return"npm"}}let h=a._meta["io.modelcontextprotocol.registry/publisher-provided"]?.github;return{id:l.id,name:a.name,description:a.description,repository:a.repository?{url:a.repository.url,source:a.repository.source,id:a.repository.id}:void 0,readme:a.repository?.readme,version:a.version,createdAt:a.created_at,updatedAt:a.updated_at,packages:a.packages?.map(y=>({identifier:y.identifier??y.name,registryType:v(y.registry_type??y.registry_name),version:y.version,fileSha256:y.file_sha256,registryBaseUrl:y.registry_base_url,transport:y.transport?g(y.transport):{type:"stdio"},packageArguments:y.package_arguments?.map(p),runtimeHint:y.runtime_hint,runtimeArguments:y.runtime_arguments?.map(p),environmentVariables:y.environment_variables?.map(f)})),remotes:a.remotes?.map(y=>({type:(y.type??y.transport_type??y.transport)==="sse"?"sse":"streamable-http",url:y.url,headers:y.headers?.map(f)})),registryInfo:{isLatest:l.is_latest,publishedAt:l.published_at,updatedAt:l.updated_at},githubInfo:h?{name:h.name,nameWithOwner:h.name_with_owner,displayName:h.display_name,isInOrganization:h.is_in_organization,license:h.license,opengraphImageUrl:h.opengraph_image_url,ownerAvatarUrl:h.owner_avatar_url,primaryLanguage:h.primary_language,primaryLanguageColor:h.primary_language_color,pushedAt:h.pushed_at,stargazerCount:h.stargazer_count,topics:h.topics,usesCustomOpengraphImage:h.uses_custom_opengraph_image}:void 0}}}n.SERIALIZER=new e})(rv||={});var vc;(r=>{r.VERSION="v0.1";class t{toRawGalleryMcpServerResult(o){if(!o||typeof o!="object"||!Array.isArray(o.servers))return;let s=o,a=[];for(let l of s.servers){let c=this.toRawGalleryMcpServer(l);if(!c){if(a.length===0)return;continue}a.push(c)}return{metadata:s.metadata,servers:a}}toRawGalleryMcpServer(o){if(!o||typeof o!="object")return;let s=o;if(!s.server||!he(s.server)||!s.server.name||!te(s.server.name)||!s.server.description||!te(s.server.description)||!s.server.version||!te(s.server.version))return;let{"io.modelcontextprotocol.registry/official":a,...l}=s._meta,c=s.server._meta?.["io.modelcontextprotocol.registry/publisher-provided"]?.github;return{name:s.server.name,description:s.server.description,version:s.server.version,title:s.server.title,repository:s.server.repository?{url:s.server.repository.url,source:s.server.repository.source,id:s.server.repository.id}:void 0,readme:c?.readme,icons:s.server.icons,websiteUrl:s.server.websiteUrl,packages:s.server.packages,remotes:s.server.remotes,status:a?.status,registryInfo:a,githubInfo:c,apicInfo:l}}}r.SERIALIZER=new t})(vc||={});var Yd;(r=>{r.VERSION="v0";class t{constructor(){this.galleryMcpServerDataSerializers=[];this.galleryMcpServerDataSerializers.push(vc.SERIALIZER),this.galleryMcpServerDataSerializers.push(rv.SERIALIZER)}toRawGalleryMcpServerResult(o){for(let s of this.galleryMcpServerDataSerializers){let a=s.toRawGalleryMcpServerResult(o);if(a)return a}}toRawGalleryMcpServer(o){for(let s of this.galleryMcpServerDataSerializers){let a=s.toRawGalleryMcpServer(o);if(a)return a}}}r.SERIALIZER=new t})(Yd||={});var yb=50,Ib={pageSize:yb},Zd=class i{constructor(t=Ib){this.state=t}get pageSize(){return this.state.pageSize}get searchText(){return this.state.searchText}get cursor(){return this.state.cursor}withPage(t,e=this.pageSize){return new i({...this.state,pageSize:e,cursor:t})}withSearchText(t){return new i({...this.state,searchText:t})}},vo=class extends _{constructor(e,r,n,o){super();this.requestService=e;this.fileService=r;this.logService=n;this.mcpGalleryManifestService=o;this.galleryMcpServerDataSerializers=new Map,this.galleryMcpServerDataSerializers.set(Yd.VERSION,Yd.SERIALIZER),this.galleryMcpServerDataSerializers.set(vc.VERSION,vc.SERIALIZER)}isEnabled(){return this.mcpGalleryManifestService.mcpGalleryManifestStatus==="available"}async query(e,r=re.None){let n=await this.mcpGalleryManifestService.getMcpGalleryManifest();if(!n)return{firstPage:{items:[],hasMore:!1},getNextPage:async()=>({items:[],hasMore:!1})};let o=new Zd;e?.text&&(o=o.withSearchText(e.text.trim()));let{servers:s,metadata:a}=await this.queryGalleryMcpServers(o,n,r),l=a.nextCursor;return{firstPage:{items:s,hasMore:!!a.nextCursor},getNextPage:async c=>{if(c.isCancellationRequested)throw new Ie;if(!l)return{items:[],hasMore:!1};let{servers:u,metadata:p}=await this.queryGalleryMcpServers(o.withPage(l).withSearchText(void 0),n,c);return l=p.nextCursor,{items:u,hasMore:!!p.nextCursor}}}}async getMcpServersFromGallery(e){let r=await this.mcpGalleryManifestService.getMcpGalleryManifest();if(!r)return[];let n=[];return await Promise.allSettled(e.map(async o=>{let s=await this.getMcpServerByName(o,r);s&&n.push(s)})),n}async getMcpServerByName({name:e,id:r},n){let o=this.getLatestServerVersionUrl(e,n);if(o){let l=await this.getMcpServer(o);if(l)return l}let s=this.getNamedServerUrl(e,n);if(s){let l=await this.getMcpServer(s);if(l)return l}let a=r?this.getServerIdUrl(r,n):void 0;if(a){let l=await this.getMcpServer(a);if(l)return l}}async getReadme(e,r){let n=e.readmeUrl;if(!n)return Promise.resolve(m(2151,null));let o=P.parse(n);if(o.scheme===$.file)try{return(await this.fileService.readFile(o)).value.toString()}catch(l){this.logService.error(`Failed to read file from ${o}: ${l}`)}if(o.authority!=="raw.githubusercontent.com")return new ht(m(2152,null,n)).value;let s=await this.requestService.request({type:"GET",url:n},r),a=await qu(s);if(!a)throw new Error(`Failed to fetch README from ${n}`);return a}toGalleryMcpServer(e,r){let n="",o=e.title;if(e.githubInfo?.name)o||(o=e.githubInfo.name.split("-").map(c=>c.toLowerCase()==="mcp"?"MCP":c.toLowerCase()==="github"?"GitHub":Xc(c)).join(" ")),n=e.githubInfo.nameWithOwner.split("/")[0];else{let c=e.name.split("/");if(c.length>0){let u=c[0].split(".");u.length>0&&(n=u[u.length-1])}o||(o=c[c.length-1].split("-").map(u=>Xc(u)).join(" "))}e.githubInfo?.displayName&&(o=e.githubInfo.displayName);let s;if(e.githubInfo?.preferredImage)s={light:e.githubInfo.preferredImage,dark:e.githubInfo.preferredImage};else if(e.githubInfo?.ownerAvatarUrl)s={light:e.githubInfo.ownerAvatarUrl,dark:e.githubInfo.ownerAvatarUrl};else if(e.apicInfo?.["x-ms-icon"])s={light:e.apicInfo["x-ms-icon"],dark:e.apicInfo["x-ms-icon"]};else if(e.icons&&e.icons.length>0){let c=e.icons.find(p=>p.theme==="light")??e.icons[0],u=e.icons.find(p=>p.theme==="dark")??c;s={light:c.src,dark:u.src}}let a=r?this.getWebUrl(e.name,r):void 0,l=r?this.getPublisherUrl(n,r):void 0;return{id:e.id,name:e.name,displayName:o,galleryUrl:r?.url,webUrl:a,description:e.description,status:e.status??"active",version:e.version,isLatest:e.registryInfo?.isLatest??!0,publishDate:e.registryInfo?.publishedAt?Date.parse(e.registryInfo.publishedAt):void 0,lastUpdated:e.githubInfo?.pushedAt?Date.parse(e.githubInfo.pushedAt):e.registryInfo?.updatedAt?Date.parse(e.registryInfo.updatedAt):void 0,repositoryUrl:e.repository?.url,readme:e.readme,icon:s,publisher:n,publisherUrl:l,license:e.githubInfo?.license,starsCount:e.githubInfo?.stargazerCount,topics:e.githubInfo?.topics,configuration:{packages:e.packages,remotes:e.remotes}}}async queryGalleryMcpServers(e,r,n){let{servers:o,metadata:s}=await this.queryRawGalleryMcpServers(e,r,n);return{servers:o.map(a=>this.toGalleryMcpServer(a,r)),metadata:s}}async queryRawGalleryMcpServers(e,r,n){let o=this.getMcpGalleryUrl(r);if(!o)return{servers:[],metadata:{count:0}};let s=P.parse(o);if(s.scheme===$.file)try{let f=(await this.fileService.readFile(s)).value.toString();return JSON.parse(f)}catch(p){this.logService.error(`Failed to read file from ${s}: ${p}`)}let a=`${o}?limit=${e.pageSize}&version=latest`;if(e.cursor&&(a+=`&cursor=${e.cursor}`),e.searchText){let p=encodeURIComponent(e.searchText);a+=`&search=${p}`}let l=await this.requestService.request({type:"GET",url:a},n),c=await yn(l);if(!c)return{servers:[],metadata:{count:0}};let u=this.serializeMcpServersResult(c,r);if(!u)throw new Error(`Failed to serialize MCP servers result from ${o}`,c);return u}async getMcpServer(e,r){let n=await this.requestService.request({type:"GET",url:e},re.None);if(n.res.statusCode&&n.res.statusCode>=400&&n.res.statusCode<500)return;let o=await yn(n);if(!o)return;r||(r=await this.mcpGalleryManifestService.getMcpGalleryManifest()),r=r&&e.startsWith(r.url)?r:null;let s=this.serializeMcpServer(o,r);if(!s)throw new Error(`Failed to serialize MCP server from ${e}`,o);return this.toGalleryMcpServer(s,r)}serializeMcpServer(e,r){return this.getSerializer(r)?.toRawGalleryMcpServer(e)}serializeMcpServersResult(e,r){return this.getSerializer(r)?.toRawGalleryMcpServerResult(e)}getSerializer(e){let r=e?.version??"v0";return this.galleryMcpServerDataSerializers.get(r)}getNamedServerUrl(e,r){let n=ii(r,"McpServerNamedResourceUriTemplate");if(n)return $t(n,{name:e})}getServerIdUrl(e,r){let n=ii(r,"McpServerIdUriTemplate");if(n)return $t(n,{id:e})}getLatestServerVersionUrl(e,r){let n=ii(r,"McpServerLatestVersionUriTemplate");if(n)return $t(n,{name:encodeURIComponent(e)})}getWebUrl(e,r){let n=ii(r,"McpServerWebUriTemplate");if(n)return $t(n,{name:e})}getPublisherUrl(e,r){let n=ii(r,"PublisherUriTemplate");if(n)return $t(n,{name:e})}getMcpGalleryUrl(e){return ii(e,"McpServersQueryService")}};vo=T([I(0,rr),I(1,ee),I(2,V),I(3,hc)],vo);var yo=class extends _{constructor(e){super();this.configurationService=e;this._onDidChangeAllowedMcpServers=this._register(new R);this.onDidChangeAllowedMcpServers=this._onDidChangeAllowedMcpServers.event;this._register(this.configurationService.onDidChangeConfiguration(r=>{r.affectsConfiguration(mc)&&this._onDidChangeAllowedMcpServers.fire()}))}isAllowed(e){if(this.configurationService.getValue(mc)!=="none")return!0;let r=Ul("workbench.action.openSettings",{query:`@id:${mc}`}).toString();return new ht(m(2150,null,r))}};yo=T([I(0,It)],yo);var ep=["v0.1","v0"],Io=class extends _{constructor(e,r,n){super();this.productService=e;this.requestService=r;this.logService=n;this.onDidChangeMcpGalleryManifest=J.None;this.onDidChangeMcpGalleryManifestStatus=J.None;this.versionByUrl=new Map}get mcpGalleryManifestStatus(){return this.productService.mcpGallery?.serviceUrl?"available":"unavailable"}async getMcpGalleryManifest(){return this.productService.mcpGallery?this.createMcpGalleryManifest(this.productService.mcpGallery.serviceUrl,ep[0]):null}async createMcpGalleryManifest(e,r){if(e=e.endsWith("/")?e.slice(0,-1):e,!r){let a=this.versionByUrl.get(e);a||this.versionByUrl.set(e,a=this.getVersion(e)),r=await a}let n=this.productService.mcpGallery?.serviceUrl===e,o=`${e}/${r}/servers`,s=[{id:o,type:"McpServersQueryService"},{id:`${o}/{name}/versions/{version}`,type:"McpServerVersionUriTemplate"},{id:`${o}/{name}/versions/latest`,type:"McpServerLatestVersionUriTemplate"}];return n&&(s.push({id:`${o}/by-name/{name}`,type:"McpServerNamedResourceUriTemplate"}),s.push({id:this.productService.mcpGallery.itemWebUrl,type:"McpServerWebUriTemplate"}),s.push({id:this.productService.mcpGallery.publisherUrl,type:"PublisherUriTemplate"}),s.push({id:this.productService.mcpGallery.supportUrl,type:"ContactSupportUri"}),s.push({id:this.productService.mcpGallery.supportUrl,type:"ContactSupportUri"}),s.push({id:this.productService.mcpGallery.privacyPolicyUrl,type:"PrivacyPolicyUri"}),s.push({id:this.productService.mcpGallery.termsOfServiceUrl,type:"TermsOfServiceUri"}),s.push({id:this.productService.mcpGallery.reportUrl,type:"ReportUri"})),r==="v0"&&s.push({id:`${o}/{id}`,type:"McpServerIdUriTemplate"}),{version:r,url:e,resources:s}}async getVersion(e){for(let r of ep)if(await this.checkVersion(e,r))return r;return ep[0]}async checkVersion(e,r){try{let n=await this.requestService.request({type:"GET",url:`${e}/${r}/servers?limit=1`},re.None);if(Mi(n))return!0;this.logService.info(`The service at ${e} does not support version ${r}. Service returned status ${n.res.statusCode}.`)}catch(n){this.logService.error(n)}return!1}};Io=T([I(0,ke),I(1,rr),I(2,V)],Io);var tp=class extends _{constructor(e){super();this.argv=e;this.registerListeners()}registerListeners(){process.once("exit",()=>this.dispose())}async run(){let[e,r]=await this.initServices();return e.invokeFunction(async n=>{let o=n.get(V),s=n.get(ee),a=n.get(Qe),l=n.get($e);o.info("CLI main",this.argv),this.registerErrorHandler(o),xb("ipv4first"),await this.doRun(a,s,l,e),await Promise.all(r.map(c=>{Ef(c.flush(),1e3)}))})}async initServices(){let e=new oo,r={_serviceBrand:void 0,...qt};e.set(ke,r);let n=new nl(this.argv,r);e.set(Qe,n),await Promise.all([this.allowWindowsUNCPath(n.appSettingsHome.with({scheme:$.file}).fsPath),this.allowWindowsUNCPath(n.extensionsPath)].map(Fe=>Fe?nv.promises.mkdir(Fe,{recursive:!0}):void 0));let o=new dc(gm(n),n.logsHome);e.set(mm,o);let s=this._register(o.createLogger("cli",{name:m(172,null)})),a=[];o.getLogLevel()===1&&a.push(new Fr(o.getLogLevel()));let l=this._register(new cc(s,a));e.set(V,l);let c=this._register(new En(l));e.set(ee,c);let u=this._register(new Zl(l));c.registerProvider($.file,u);let p=new Pn(c);e.set(me,p);let f=new ei(1,n,l,c),g=new Vr(f,p,n,c,l);e.set($e,g),c.registerProvider($.vscodeUserData,new pc($.file,u,$.vscodeUserData,g,p,l));let v;pe&&r.win32RegValueName?v=this._register(new Yn(l,r.win32RegValueName)):ft&&r.darwinBundleIdentifier?v=this._register(new Yn(l,r.darwinBundleIdentifier)):Te?v=this._register(new Xn(P.file(km),c,l)):n.policyFile?v=this._register(new Xn(n.policyFile,c,l)):v=new Ai,e.set(Xa,v);let h=this._register(new el(g.defaultProfile.settingsResource,c,v,l));e.set(It,h),await Promise.all([f.init(),h.initialize()]);let y;try{y=await Qh(f,l)}catch(Fe){Fe.code!=="ENOENT"&&l.error(Fe)}let E=await Jh(f,l),b=await Xh(f,l);g.init(),e.set(me,new Pn(c));let C=new co("local",h,n,l);e.set(rr,C),e.set(tl,new Re(Fi,void 0,!0)),e.set(nr,new Re(uo,void 0,!0)),e.set(Ji,new Re(eo,void 0,!0)),e.set(Pl,new Re($i,void 0,!0)),e.set(fr,new Re(po,void 0,!0)),e.set(ih,new Re(Zi,void 0,!0)),e.set(Sn,new Re(mo)),e.set(kt,new Re(Ki,void 0,!0)),e.set(_h,new Re(ao,void 0,!1)),e.set(Ds,new Re(yo,void 0,!0)),e.set(Tn,new Re(ri,void 0,!0)),e.set(hc,new Re(Io,void 0,!0)),e.set(ti,new Re(vo,void 0,!0)),e.set(fc,new Re(gc,void 0,!0));let N=[],oe=eg(r,h);if(pl(r,n)){r.aiConfig?.ariaKey&&N.push(new oc(C,oe,"monacoworkbench",null,r.aiConfig.ariaKey));let Fe={appenders:N,sendErrorTelemetry:!1,commonProperties:Km(Sb(),bb(),process.arch,r.commit,r.version,y,E,b,oe,r.date),piiPaths:tg(n)};e.set(St,new Re(tn,[Fe],!1))}else e.set(St,Xm);return[new tc(e),N]}allowWindowsUNCPath(e){if(pe){let r=ev(e);r&&Xd(r)}return e}registerErrorHandler(e){dp(r=>{let n=ar(r,!0);n&&e.error(`[uncaught exception in CLI]: ${n}`)}),process.on("uncaughtException",r=>{pp(r)||Ke(r)}),process.on("unhandledRejection",r=>Ke(r))}async doRun(e,r,n,o){let s;if(e.args.profile&&(s=n.profiles.find(l=>l.name===e.args.profile),!s))throw new Error(`Profile '${e.args.profile}' not found.`);let a=(s??n.defaultProfile).extensionsResource;if(this.argv["list-extensions"])return o.createInstance(Or,[],new Fr(3,!1)).listExtensions(!!this.argv["show-versions"],this.argv.category,a);if(this.argv["install-extension"]||this.argv["install-builtin-extension"]){let l={isMachineScoped:!!this.argv["do-not-sync"],installPreReleaseVersion:!!this.argv["pre-release"],donotIncludePackAndDependencies:!!this.argv["do-not-include-pack-dependencies"],profileLocation:a};return o.createInstance(Or,[],new Fr(3,!1)).installExtensions(this.asExtensionIdOrVSIX(this.argv["install-extension"]||[]),this.asExtensionIdOrVSIX(this.argv["install-builtin-extension"]||[]),l,!!this.argv.force)}else{if(this.argv["uninstall-extension"])return o.createInstance(Or,[],new Fr(3,!1)).uninstallExtensions(this.asExtensionIdOrVSIX(this.argv["uninstall-extension"]),!!this.argv.force,a);if(this.argv["update-extensions"])return o.createInstance(Or,[],new Fr(3,!1)).updateExtensions(a);if(this.argv["locate-extension"])return o.createInstance(Or,[],new Fr(3,!1)).locateExtension(this.argv["locate-extension"]);if(this.argv["add-mcp"])return o.createInstance(fo,new Fr(3,!1)).addMcpDefinitions(this.argv["add-mcp"]);this.argv.telemetry&&console.log(await Gh(e.appRoot,e.extensionsPath))}}asExtensionIdOrVSIX(e){return e.map(r=>/\.vsix$/i.test(r)?P.file(pi(r)?r:q(ln(),r)):r)}};async function hq(i){let t=new tp(i);try{await t.run()}finally{t.dispose()}}export{hq as main};
//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/a2860d1c314872c0c8c436647d10856fdd15f2bc/core/vs/code/node/cliProcessMain.js.map
