/*!--------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

export function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

export var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

export function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

export function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

export function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

export function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

export function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

export function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

export function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

export function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

export function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

export function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

export var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

export function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

export function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

export function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
export function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
export function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

export function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

export function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

export function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

export function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

export function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

export function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

export function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

export function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

export function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

export function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

export function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

export function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
            if (async) inner = dispose;
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;

}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

export function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

export default {
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
};

function Oo(){return globalThis._VSCODE_NLS_MESSAGES}function kn(){return globalThis._VSCODE_NLS_LANGUAGE}var Do=kn()==="pseudo"||typeof document<"u"&&document.location&&typeof document.location.hash=="string"&&document.location.hash.indexOf("pseudo=true")>=0;function Kr(r,e){let t;return e.length===0?t=r:t=r.replace(/\{(\d+)\}/g,(n,i)=>{let s=i[0],a=e[s],l=n;return typeof a=="string"?l=a:(typeof a=="number"||typeof a=="boolean"||a===void 0||a===null)&&(l=String(a)),l}),Do&&(t="\uFF3B"+t.replace(/[aouei]/g,"$&$&")+"\uFF3D"),t}function x(r,e,...t){return Kr(typeof r=="number"?Ao(r,e):e,t)}function Ao(r,e){let t=Oo()?.[r];if(typeof t!="string"){if(typeof e=="string")return e;throw new Error(`!!! NLS MISSING: ${r} !!!`)}return t}var Ze="en",Mt=!1,Ft=!1,dt=!1,Po=!1,jr=!1,En=!1,No=!1,Uo=!1,Mo=!1,Fo=!1,Nt,Ut=Ze,qr=Ze,Vo,xe,ye=globalThis,te;typeof ye.vscode<"u"&&typeof ye.vscode.process<"u"?te=ye.vscode.process:typeof process<"u"&&typeof process?.versions?.node=="string"&&(te=process);var $r=typeof te?.versions?.electron=="string",Bo=$r&&te?.type==="renderer";if(typeof te=="object"){Mt=te.platform==="win32",Ft=te.platform==="darwin",dt=te.platform==="linux",Po=dt&&!!te.env.SNAP&&!!te.env.SNAP_REVISION,No=$r,Mo=!!te.env.CI||!!te.env.BUILD_ARTIFACTSTAGINGDIRECTORY||!!te.env.GITHUB_WORKSPACE,Nt=Ze,Ut=Ze;let r=te.env.VSCODE_NLS_CONFIG;if(r)try{let e=JSON.parse(r);Nt=e.userLocale,qr=e.osLocale,Ut=e.resolvedLanguage||Ze,Vo=e.languagePack?.translationsConfigFile}catch{}jr=!0}else typeof navigator=="object"&&!Bo?(xe=navigator.userAgent,Mt=xe.indexOf("Windows")>=0,Ft=xe.indexOf("Macintosh")>=0,Uo=(xe.indexOf("Macintosh")>=0||xe.indexOf("iPad")>=0||xe.indexOf("iPhone")>=0)&&!!navigator.maxTouchPoints&&navigator.maxTouchPoints>0,dt=xe.indexOf("Linux")>=0,Fo=xe?.indexOf("Mobi")>=0,En=!0,Ut=kn()||Ze,Nt=navigator.language.toLowerCase(),qr=Nt):console.error("Unable to resolve platform.");var Sn=0;Ft?Sn=1:Mt?Sn=3:dt&&(Sn=2);var he=Mt,Hr=Ft,Gr=dt;var Qr=jr;var ct=En,zo=En&&typeof ye.importScripts=="function",Yr=zo?ye.origin:void 0;var be=xe,Re=Ut,Wo;(n=>{function r(){return Re}n.value=r;function e(){return Re.length===2?Re==="en":Re.length>=3?Re[0]==="e"&&Re[1]==="n"&&Re[2]==="-":!1}n.isDefaultVariant=e;function t(){return Re==="en"}n.isDefault=t})(Wo||={});var Ko=typeof ye.postMessage=="function"&&!ye.importScripts,ft=(()=>{if(Ko){let r=[];ye.addEventListener("message",t=>{if(t.data&&t.data.vscodeScheduleAsyncWork)for(let n=0,i=r.length;n<i;n++){let s=r[n];if(s.id===t.data.vscodeScheduleAsyncWork){r.splice(n,1),s.callback();return}}});let e=0;return t=>{let n=++e;r.push({id:n,callback:t}),ye.postMessage({vscodeScheduleAsyncWork:n},"*")}}return r=>setTimeout(r)})();var qo=!!(be&&be.indexOf("Chrome")>=0),Oa=!!(be&&be.indexOf("Firefox")>=0),Da=!!(!qo&&be&&be.indexOf("Safari")>=0),Aa=!!(be&&be.indexOf("Edg/")>=0),Ca=!!(be&&be.indexOf("Android")>=0);var Be,wn=globalThis.vscode;if(typeof wn<"u"&&typeof wn.process<"u"){let r=wn.process;Be={get platform(){return r.platform},get arch(){return r.arch},get env(){return r.env},cwd(){return r.cwd()}}}else typeof process<"u"&&typeof process?.versions?.node=="string"?Be={get platform(){return process.platform},get arch(){return process.arch},get env(){return process.env},cwd(){return process.env.VSCODE_CWD||process.cwd()}}:Be={get platform(){return he?"win32":Hr?"darwin":"linux"},get arch(){},get env(){return{}},cwd(){return"/"}};var pt=Be.cwd,mt=Be.env,Jr=Be.platform,Ua=Be.arch;var $o=65,Ho=97,Go=90,Qo=122,ze=46,G=47,ne=92,_e=58,Yo=63,Vt=class extends Error{constructor(e,t,n){let i;typeof t=="string"&&t.indexOf("not ")===0?(i="must not be",t=t.replace(/^not /,"")):i="must be";let s=e.indexOf(".")!==-1?"property":"argument",a=`The "${e}" ${s} ${i} of type ${t}`;a+=`. Received type ${typeof n}`,super(a),this.code="ERR_INVALID_ARG_TYPE"}};function Zo(r,e){if(r===null||typeof r!="object")throw new Vt(e,"Object",r)}function F(r,e){if(typeof r!="string")throw new Vt(e,"string",r)}var re=Jr==="win32";function E(r){return r===G||r===ne}function Rn(r){return r===G}function Ie(r){return r>=$o&&r<=Go||r>=Ho&&r<=Qo}function Bt(r,e,t,n){let i="",s=0,a=-1,l=0,u=0;for(let d=0;d<=r.length;++d){if(d<r.length)u=r.charCodeAt(d);else{if(n(u))break;u=G}if(n(u)){if(!(a===d-1||l===1))if(l===2){if(i.length<2||s!==2||i.charCodeAt(i.length-1)!==ze||i.charCodeAt(i.length-2)!==ze){if(i.length>2){let f=i.lastIndexOf(t);f===-1?(i="",s=0):(i=i.slice(0,f),s=i.length-1-i.lastIndexOf(t)),a=d,l=0;continue}else if(i.length!==0){i="",s=0,a=d,l=0;continue}}e&&(i+=i.length>0?`${t}..`:"..",s=2)}else i.length>0?i+=`${t}${r.slice(a+1,d)}`:i=r.slice(a+1,d),s=d-a-1;a=d,l=0}else u===ze&&l!==-1?++l:l=-1}return i}function Jo(r){return r?`${r[0]==="."?"":"."}${r}`:""}function Xr(r,e){Zo(e,"pathObject");let t=e.dir||e.root,n=e.base||`${e.name||""}${Jo(e.ext)}`;return t?t===e.root?`${t}${n}`:`${t}${r}${n}`:n}var V={resolve(...r){let e="",t="",n=!1;for(let i=r.length-1;i>=-1;i--){let s;if(i>=0){if(s=r[i],F(s,`paths[${i}]`),s.length===0)continue}else e.length===0?s=pt():(s=mt[`=${e}`]||pt(),(s===void 0||s.slice(0,2).toLowerCase()!==e.toLowerCase()&&s.charCodeAt(2)===ne)&&(s=`${e}\\`));let a=s.length,l=0,u="",d=!1,f=s.charCodeAt(0);if(a===1)E(f)&&(l=1,d=!0);else if(E(f))if(d=!0,E(s.charCodeAt(1))){let c=2,b=c;for(;c<a&&!E(s.charCodeAt(c));)c++;if(c<a&&c!==b){let k=s.slice(b,c);for(b=c;c<a&&E(s.charCodeAt(c));)c++;if(c<a&&c!==b){for(b=c;c<a&&!E(s.charCodeAt(c));)c++;(c===a||c!==b)&&(u=`\\\\${k}\\${s.slice(b,c)}`,l=c)}}}else l=1;else Ie(f)&&s.charCodeAt(1)===_e&&(u=s.slice(0,2),l=2,a>2&&E(s.charCodeAt(2))&&(d=!0,l=3));if(u.length>0)if(e.length>0){if(u.toLowerCase()!==e.toLowerCase())continue}else e=u;if(n){if(e.length>0)break}else if(t=`${s.slice(l)}\\${t}`,n=d,d&&e.length>0)break}return t=Bt(t,!n,"\\",E),n?`${e}\\${t}`:`${e}${t}`||"."},normalize(r){F(r,"path");let e=r.length;if(e===0)return".";let t=0,n,i=!1,s=r.charCodeAt(0);if(e===1)return Rn(s)?"\\":r;if(E(s))if(i=!0,E(r.charCodeAt(1))){let l=2,u=l;for(;l<e&&!E(r.charCodeAt(l));)l++;if(l<e&&l!==u){let d=r.slice(u,l);for(u=l;l<e&&E(r.charCodeAt(l));)l++;if(l<e&&l!==u){for(u=l;l<e&&!E(r.charCodeAt(l));)l++;if(l===e)return`\\\\${d}\\${r.slice(u)}\\`;l!==u&&(n=`\\\\${d}\\${r.slice(u,l)}`,t=l)}}}else t=1;else Ie(s)&&r.charCodeAt(1)===_e&&(n=r.slice(0,2),t=2,e>2&&E(r.charCodeAt(2))&&(i=!0,t=3));let a=t<e?Bt(r.slice(t),!i,"\\",E):"";if(a.length===0&&!i&&(a="."),a.length>0&&E(r.charCodeAt(e-1))&&(a+="\\"),!i&&n===void 0&&r.includes(":")){if(a.length>=2&&Ie(a.charCodeAt(0))&&a.charCodeAt(1)===_e)return`.\\${a}`;let l=r.indexOf(":");do if(l===e-1||E(r.charCodeAt(l+1)))return`.\\${a}`;while((l=r.indexOf(":",l+1))!==-1)}return n===void 0?i?`\\${a}`:a:i?`${n}\\${a}`:`${n}${a}`},isAbsolute(r){F(r,"path");let e=r.length;if(e===0)return!1;let t=r.charCodeAt(0);return E(t)||e>2&&Ie(t)&&r.charCodeAt(1)===_e&&E(r.charCodeAt(2))},join(...r){if(r.length===0)return".";let e,t;for(let s=0;s<r.length;++s){let a=r[s];F(a,"path"),a.length>0&&(e===void 0?e=t=a:e+=`\\${a}`)}if(e===void 0)return".";let n=!0,i=0;if(typeof t=="string"&&E(t.charCodeAt(0))){++i;let s=t.length;s>1&&E(t.charCodeAt(1))&&(++i,s>2&&(E(t.charCodeAt(2))?++i:n=!1))}if(n){for(;i<e.length&&E(e.charCodeAt(i));)i++;i>=2&&(e=`\\${e.slice(i)}`)}return V.normalize(e)},relative(r,e){if(F(r,"from"),F(e,"to"),r===e)return"";let t=V.resolve(r),n=V.resolve(e);if(t===n||(r=t.toLowerCase(),e=n.toLowerCase(),r===e))return"";if(t.length!==r.length||n.length!==e.length){let A=t.split("\\"),M=n.split("\\");A[A.length-1]===""&&A.pop(),M[M.length-1]===""&&M.pop();let J=A.length,ge=M.length,Ue=J<ge?J:ge,X;for(X=0;X<Ue&&A[X].toLowerCase()===M[X].toLowerCase();X++);return X===0?n:X===Ue?ge>Ue?M.slice(X).join("\\"):J>Ue?"..\\".repeat(J-1-X)+"..":"":"..\\".repeat(J-X)+M.slice(X).join("\\")}let i=0;for(;i<r.length&&r.charCodeAt(i)===ne;)i++;let s=r.length;for(;s-1>i&&r.charCodeAt(s-1)===ne;)s--;let a=s-i,l=0;for(;l<e.length&&e.charCodeAt(l)===ne;)l++;let u=e.length;for(;u-1>l&&e.charCodeAt(u-1)===ne;)u--;let d=u-l,f=a<d?a:d,c=-1,b=0;for(;b<f;b++){let A=r.charCodeAt(i+b);if(A!==e.charCodeAt(l+b))break;A===ne&&(c=b)}if(b!==f){if(c===-1)return n}else{if(d>f){if(e.charCodeAt(l+b)===ne)return n.slice(l+b+1);if(b===2)return n.slice(l+b)}a>f&&(r.charCodeAt(i+b)===ne?c=b:b===2&&(c=3)),c===-1&&(c=0)}let k="";for(b=i+c+1;b<=s;++b)(b===s||r.charCodeAt(b)===ne)&&(k+=k.length===0?"..":"\\..");return l+=c,k.length>0?`${k}${n.slice(l,u)}`:(n.charCodeAt(l)===ne&&++l,n.slice(l,u))},toNamespacedPath(r){if(typeof r!="string"||r.length===0)return r;let e=V.resolve(r);if(e.length<=2)return r;if(e.charCodeAt(0)===ne){if(e.charCodeAt(1)===ne){let t=e.charCodeAt(2);if(t!==Yo&&t!==ze)return`\\\\?\\UNC\\${e.slice(2)}`}}else if(Ie(e.charCodeAt(0))&&e.charCodeAt(1)===_e&&e.charCodeAt(2)===ne)return`\\\\?\\${e}`;return e},dirname(r){F(r,"path");let e=r.length;if(e===0)return".";let t=-1,n=0,i=r.charCodeAt(0);if(e===1)return E(i)?r:".";if(E(i)){if(t=n=1,E(r.charCodeAt(1))){let l=2,u=l;for(;l<e&&!E(r.charCodeAt(l));)l++;if(l<e&&l!==u){for(u=l;l<e&&E(r.charCodeAt(l));)l++;if(l<e&&l!==u){for(u=l;l<e&&!E(r.charCodeAt(l));)l++;if(l===e)return r;l!==u&&(t=n=l+1)}}}}else Ie(i)&&r.charCodeAt(1)===_e&&(t=e>2&&E(r.charCodeAt(2))?3:2,n=t);let s=-1,a=!0;for(let l=e-1;l>=n;--l)if(E(r.charCodeAt(l))){if(!a){s=l;break}}else a=!1;if(s===-1){if(t===-1)return".";s=t}return r.slice(0,s)},basename(r,e){e!==void 0&&F(e,"suffix"),F(r,"path");let t=0,n=-1,i=!0,s;if(r.length>=2&&Ie(r.charCodeAt(0))&&r.charCodeAt(1)===_e&&(t=2),e!==void 0&&e.length>0&&e.length<=r.length){if(e===r)return"";let a=e.length-1,l=-1;for(s=r.length-1;s>=t;--s){let u=r.charCodeAt(s);if(E(u)){if(!i){t=s+1;break}}else l===-1&&(i=!1,l=s+1),a>=0&&(u===e.charCodeAt(a)?--a===-1&&(n=s):(a=-1,n=l))}return t===n?n=l:n===-1&&(n=r.length),r.slice(t,n)}for(s=r.length-1;s>=t;--s)if(E(r.charCodeAt(s))){if(!i){t=s+1;break}}else n===-1&&(i=!1,n=s+1);return n===-1?"":r.slice(t,n)},extname(r){F(r,"path");let e=0,t=-1,n=0,i=-1,s=!0,a=0;r.length>=2&&r.charCodeAt(1)===_e&&Ie(r.charCodeAt(0))&&(e=n=2);for(let l=r.length-1;l>=e;--l){let u=r.charCodeAt(l);if(E(u)){if(!s){n=l+1;break}continue}i===-1&&(s=!1,i=l+1),u===ze?t===-1?t=l:a!==1&&(a=1):t!==-1&&(a=-1)}return t===-1||i===-1||a===0||a===1&&t===i-1&&t===n+1?"":r.slice(t,i)},format:Xr.bind(null,"\\"),parse(r){F(r,"path");let e={root:"",dir:"",base:"",ext:"",name:""};if(r.length===0)return e;let t=r.length,n=0,i=r.charCodeAt(0);if(t===1)return E(i)?(e.root=e.dir=r,e):(e.base=e.name=r,e);if(E(i)){if(n=1,E(r.charCodeAt(1))){let c=2,b=c;for(;c<t&&!E(r.charCodeAt(c));)c++;if(c<t&&c!==b){for(b=c;c<t&&E(r.charCodeAt(c));)c++;if(c<t&&c!==b){for(b=c;c<t&&!E(r.charCodeAt(c));)c++;c===t?n=c:c!==b&&(n=c+1)}}}}else if(Ie(i)&&r.charCodeAt(1)===_e){if(t<=2)return e.root=e.dir=r,e;if(n=2,E(r.charCodeAt(2))){if(t===3)return e.root=e.dir=r,e;n=3}}n>0&&(e.root=r.slice(0,n));let s=-1,a=n,l=-1,u=!0,d=r.length-1,f=0;for(;d>=n;--d){if(i=r.charCodeAt(d),E(i)){if(!u){a=d+1;break}continue}l===-1&&(u=!1,l=d+1),i===ze?s===-1?s=d:f!==1&&(f=1):s!==-1&&(f=-1)}return l!==-1&&(s===-1||f===0||f===1&&s===l-1&&s===a+1?e.base=e.name=r.slice(a,l):(e.name=r.slice(a,s),e.base=r.slice(a,l),e.ext=r.slice(s,l))),a>0&&a!==n?e.dir=r.slice(0,a-1):e.dir=e.root,e},sep:"\\",delimiter:";",win32:null,posix:null},Xo=(()=>{if(re){let r=/\\/g;return()=>{let e=pt().replace(r,"/");return e.slice(e.indexOf("/"))}}return()=>pt()})(),L={resolve(...r){let e="",t=!1;for(let n=r.length-1;n>=0&&!t;n--){let i=r[n];F(i,`paths[${n}]`),i.length!==0&&(e=`${i}/${e}`,t=i.charCodeAt(0)===G)}if(!t){let n=Xo();e=`${n}/${e}`,t=n.charCodeAt(0)===G}return e=Bt(e,!t,"/",Rn),t?`/${e}`:e.length>0?e:"."},normalize(r){if(F(r,"path"),r.length===0)return".";let e=r.charCodeAt(0)===G,t=r.charCodeAt(r.length-1)===G;return r=Bt(r,!e,"/",Rn),r.length===0?e?"/":t?"./":".":(t&&(r+="/"),e?`/${r}`:r)},isAbsolute(r){return F(r,"path"),r.length>0&&r.charCodeAt(0)===G},join(...r){if(r.length===0)return".";let e=[];for(let t=0;t<r.length;++t){let n=r[t];F(n,"path"),n.length>0&&e.push(n)}return e.length===0?".":L.normalize(e.join("/"))},relative(r,e){if(F(r,"from"),F(e,"to"),r===e||(r=L.resolve(r),e=L.resolve(e),r===e))return"";let t=1,n=r.length,i=n-t,s=1,a=e.length-s,l=i<a?i:a,u=-1,d=0;for(;d<l;d++){let c=r.charCodeAt(t+d);if(c!==e.charCodeAt(s+d))break;c===G&&(u=d)}if(d===l)if(a>l){if(e.charCodeAt(s+d)===G)return e.slice(s+d+1);if(d===0)return e.slice(s+d)}else i>l&&(r.charCodeAt(t+d)===G?u=d:d===0&&(u=0));let f="";for(d=t+u+1;d<=n;++d)(d===n||r.charCodeAt(d)===G)&&(f+=f.length===0?"..":"/..");return`${f}${e.slice(s+u)}`},toNamespacedPath(r){return r},dirname(r){if(F(r,"path"),r.length===0)return".";let e=r.charCodeAt(0)===G,t=-1,n=!0;for(let i=r.length-1;i>=1;--i)if(r.charCodeAt(i)===G){if(!n){t=i;break}}else n=!1;return t===-1?e?"/":".":e&&t===1?"//":r.slice(0,t)},basename(r,e){e!==void 0&&F(e,"suffix"),F(r,"path");let t=0,n=-1,i=!0,s;if(e!==void 0&&e.length>0&&e.length<=r.length){if(e===r)return"";let a=e.length-1,l=-1;for(s=r.length-1;s>=0;--s){let u=r.charCodeAt(s);if(u===G){if(!i){t=s+1;break}}else l===-1&&(i=!1,l=s+1),a>=0&&(u===e.charCodeAt(a)?--a===-1&&(n=s):(a=-1,n=l))}return t===n?n=l:n===-1&&(n=r.length),r.slice(t,n)}for(s=r.length-1;s>=0;--s)if(r.charCodeAt(s)===G){if(!i){t=s+1;break}}else n===-1&&(i=!1,n=s+1);return n===-1?"":r.slice(t,n)},extname(r){F(r,"path");let e=-1,t=0,n=-1,i=!0,s=0;for(let a=r.length-1;a>=0;--a){let l=r[a];if(l==="/"){if(!i){t=a+1;break}continue}n===-1&&(i=!1,n=a+1),l==="."?e===-1?e=a:s!==1&&(s=1):e!==-1&&(s=-1)}return e===-1||n===-1||s===0||s===1&&e===n-1&&e===t+1?"":r.slice(e,n)},format:Xr.bind(null,"/"),parse(r){F(r,"path");let e={root:"",dir:"",base:"",ext:"",name:""};if(r.length===0)return e;let t=r.charCodeAt(0)===G,n;t?(e.root="/",n=1):n=0;let i=-1,s=0,a=-1,l=!0,u=r.length-1,d=0;for(;u>=n;--u){let f=r.charCodeAt(u);if(f===G){if(!l){s=u+1;break}continue}a===-1&&(l=!1,a=u+1),f===ze?i===-1?i=u:d!==1&&(d=1):i!==-1&&(d=-1)}if(a!==-1){let f=s===0&&t?1:s;i===-1||d===0||d===1&&i===a-1&&i===s+1?e.base=e.name=r.slice(f,a):(e.name=r.slice(f,i),e.base=r.slice(f,a),e.ext=r.slice(i,a))}return s>0?e.dir=r.slice(0,s-1):t&&(e.dir="/"),e},sep:"/",delimiter:":",win32:null,posix:null};L.win32=V.win32=V;L.posix=V.posix=L;var Ln=re?V.normalize:L.normalize,es=re?V.isAbsolute:L.isAbsolute,On=re?V.join:L.join,ei=re?V.resolve:L.resolve,ti=re?V.relative:L.relative,ni=re?V.dirname:L.dirname,Ma=re?V.basename:L.basename,Fa=re?V.extname:L.extname,Va=re?V.format:L.format,Ba=re?V.parse:L.parse,za=re?V.toNamespacedPath:L.toNamespacedPath,Je=re?V.sep:L.sep,Wa=re?V.delimiter:L.delimiter;var ts=/^\w[\w\d+.-]*$/,ns=/^\//,rs=/^\/\//;function is(r,e){if(!r.scheme&&e)throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${r.authority}", path: "${r.path}", query: "${r.query}", fragment: "${r.fragment}"}`);if(r.scheme&&!ts.test(r.scheme)){let t=[...r.scheme.matchAll(/[^\w\d+.-]/gu)],n=t.length>0?` Found '${t[0][0]}' at index ${t[0].index} (${t.length} total)`:"";throw new Error(`[UriError]: Scheme contains illegal characters.${n} (len:${r.scheme.length})`)}if(r.path){if(r.authority){if(!ns.test(r.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(rs.test(r.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}}function os(r,e){return!r&&!e?"file":r}function ss(r,e){switch(r){case"https":case"http":case"file":e?e[0]!==fe&&(e=fe+e):e=fe;break}return e}var C="",fe="/",as=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/,z=class r{static isUri(e){return e instanceof r?!0:!e||typeof e!="object"?!1:typeof e.authority=="string"&&typeof e.fragment=="string"&&typeof e.path=="string"&&typeof e.query=="string"&&typeof e.scheme=="string"&&typeof e.fsPath=="string"&&typeof e.with=="function"&&typeof e.toString=="function"}constructor(e,t,n,i,s,a=!1){typeof e=="object"?(this.scheme=e.scheme||C,this.authority=e.authority||C,this.path=e.path||C,this.query=e.query||C,this.fragment=e.fragment||C):(this.scheme=os(e,a),this.authority=t||C,this.path=ss(this.scheme,n||C),this.query=i||C,this.fragment=s||C,is(this,a))}get fsPath(){return bt(this,!1)}with(e){if(!e)return this;let{scheme:t,authority:n,path:i,query:s,fragment:a}=e;return t===void 0?t=this.scheme:t===null&&(t=C),n===void 0?n=this.authority:n===null&&(n=C),i===void 0?i=this.path:i===null&&(i=C),s===void 0?s=this.query:s===null&&(s=C),a===void 0?a=this.fragment:a===null&&(a=C),t===this.scheme&&n===this.authority&&i===this.path&&s===this.query&&a===this.fragment?this:new Le(t,n,i,s,a)}static parse(e,t=!1){let n=as.exec(e);return n?new Le(n[2]||C,zt(n[4]||C),zt(n[5]||C),zt(n[7]||C),zt(n[9]||C),t):new Le(C,C,C,C,C)}static file(e){let t=C;if(he&&(e=e.replace(/\\/g,fe)),e[0]===fe&&e[1]===fe){let n=e.indexOf(fe,2);n===-1?(t=e.substring(2),e=fe):(t=e.substring(2,n),e=e.substring(n)||fe)}return new Le("file",t,e,C,C)}static from(e,t){return new Le(e.scheme,e.authority,e.path,e.query,e.fragment,t)}static joinPath(e,...t){if(!e.path)throw new Error("[UriError]: cannot call joinPath on URI without path");let n;return he&&e.scheme==="file"?n=r.file(V.join(bt(e,!0),...t)).path:n=L.join(e.path,...t),e.with({path:n})}toString(e=!1){return An(this,e)}toJSON(){return this}static revive(e){if(e){if(e instanceof r)return e;{let t=new Le(e);return t._formatted=e.external??null,t._fsPath=e._sep===oi?e.fsPath??null:null,t}}else return e}[Symbol.for("debug.description")](){return`URI(${this.toString()})`}};var oi=he?1:void 0,Le=class extends z{constructor(){super(...arguments);this._formatted=null;this._fsPath=null}get fsPath(){return this._fsPath||(this._fsPath=bt(this,!1)),this._fsPath}toString(t=!1){return t?An(this,!0):(this._formatted||(this._formatted=An(this,!1)),this._formatted)}toJSON(){let t={$mid:1};return this._fsPath&&(t.fsPath=this._fsPath,t._sep=oi),this._formatted&&(t.external=this._formatted),this.path&&(t.path=this.path),this.scheme&&(t.scheme=this.scheme),this.authority&&(t.authority=this.authority),this.query&&(t.query=this.query),this.fragment&&(t.fragment=this.fragment),t}},si={58:"%3A",47:"%2F",63:"%3F",35:"%23",91:"%5B",93:"%5D",64:"%40",33:"%21",36:"%24",38:"%26",39:"%27",40:"%28",41:"%29",42:"%2A",43:"%2B",44:"%2C",59:"%3B",61:"%3D",32:"%20"};function ri(r,e,t){let n,i=-1;for(let s=0;s<r.length;s++){let a=r.charCodeAt(s);if(a>=97&&a<=122||a>=65&&a<=90||a>=48&&a<=57||a===45||a===46||a===95||a===126||e&&a===47||t&&a===91||t&&a===93||t&&a===58)i!==-1&&(n+=encodeURIComponent(r.substring(i,s)),i=-1),n!==void 0&&(n+=r.charAt(s));else{n===void 0&&(n=r.substr(0,s));let l=si[a];l!==void 0?(i!==-1&&(n+=encodeURIComponent(r.substring(i,s)),i=-1),n+=l):i===-1&&(i=s)}}return i!==-1&&(n+=encodeURIComponent(r.substring(i))),n!==void 0?n:r}function ls(r){let e;for(let t=0;t<r.length;t++){let n=r.charCodeAt(t);n===35||n===63?(e===void 0&&(e=r.substr(0,t)),e+=si[n]):e!==void 0&&(e+=r[t])}return e!==void 0?e:r}function bt(r,e){let t;return r.authority&&r.path.length>1&&r.scheme==="file"?t=`//${r.authority}${r.path}`:r.path.charCodeAt(0)===47&&(r.path.charCodeAt(1)>=65&&r.path.charCodeAt(1)<=90||r.path.charCodeAt(1)>=97&&r.path.charCodeAt(1)<=122)&&r.path.charCodeAt(2)===58?e?t=r.path.substr(1):t=r.path[1].toLowerCase()+r.path.substr(2):t=r.path,he&&(t=t.replace(/\//g,"\\")),t}function An(r,e){let t=e?ls:ri,n="",{scheme:i,authority:s,path:a,query:l,fragment:u}=r;if(i&&(n+=i,n+=":"),(s||i==="file")&&(n+=fe,n+=fe),s){let d=s.indexOf("@");if(d!==-1){let f=s.substr(0,d);s=s.substr(d+1),d=f.lastIndexOf(":"),d===-1?n+=t(f,!1,!1):(n+=t(f.substr(0,d),!1,!1),n+=":",n+=t(f.substr(d+1),!1,!0)),n+="@"}s=s.toLowerCase(),d=s.lastIndexOf(":"),d===-1?n+=t(s,!1,!0):(n+=t(s.substr(0,d),!1,!0),n+=s.substr(d))}if(a){if(a.length>=3&&a.charCodeAt(0)===47&&a.charCodeAt(2)===58){let d=a.charCodeAt(1);d>=65&&d<=90&&(a=`/${String.fromCharCode(d+32)}:${a.substr(3)}`)}else if(a.length>=2&&a.charCodeAt(1)===58){let d=a.charCodeAt(0);d>=65&&d<=90&&(a=`${String.fromCharCode(d+32)}:${a.substr(2)}`)}n+=t(a,!0,!1)}return l&&(n+="?",n+=t(l,!1,!1)),u&&(n+="#",n+=e?u:ri(u,!1,!1)),n}function ai(r){try{return decodeURIComponent(r)}catch{return r.length>3?r.substr(0,3)+ai(r.substr(3)):r}}var ii=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function zt(r){return r.match(ii)?r.replace(ii,e=>ai(e)):r}function Cn(r,e){let t=gt(r,e);return t===-1?void 0:r[t]}function gt(r,e,t=0,n=r.length){let i=t,s=n;for(;i<s;){let a=Math.floor((i+s)/2);e(r[a])?i=a+1:s=a}return i-1}function Wt(r,e,t=0,n=r.length){let i=t,s=n;for(;i<s;){let a=Math.floor((i+s)/2);e(r[a])?s=a:i=a+1}return i}var li=class r{constructor(e){this._array=e;this._findLastMonotonousLastIdx=0}static{this.assertInvariants=!1}findLastMonotonous(e){if(r.assertInvariants){if(this._prevFindLastPredicate){for(let n of this._array)if(this._prevFindLastPredicate(n)&&!e(n))throw new Error("MonotonousArray: current predicate must be weaker than (or equal to) the previous predicate.")}this._prevFindLastPredicate=e}let t=gt(this._array,e,this._findLastMonotonousLastIdx);return this._findLastMonotonousLastIdx=t+1,t===-1?void 0:this._array[t]}};var Pn=class{constructor(){this.listeners=[],this.unexpectedErrorHandler=function(e){setTimeout(()=>{throw e.stack?vt.isErrorNoTelemetry(e)?new vt(e.message+`

`+e.stack):new Error(e.message+`

`+e.stack):e},0)}}addListener(e){return this.listeners.push(e),()=>{this._removeListener(e)}}emit(e){this.listeners.forEach(t=>{t(e)})}_removeListener(e){this.listeners.splice(this.listeners.indexOf(e),1)}setUnexpectedErrorHandler(e){this.unexpectedErrorHandler=e}getUnexpectedErrorHandler(){return this.unexpectedErrorHandler}onUnexpectedError(e){this.unexpectedErrorHandler(e),this.emit(e)}onUnexpectedExternalError(e){this.unexpectedErrorHandler(e)}},di=new Pn;function De(r){di.onUnexpectedError(r)}function W(r){us(r)||di.onUnexpectedError(r)}function Kt(r){if(r instanceof Error){let{name:e,message:t,cause:n}=r,i=r.stacktrace||r.stack;return{$isError:!0,name:e,message:t,stack:i,noTelemetry:vt.isErrorNoTelemetry(r),cause:n?Kt(n):void 0,code:r.code}}return r}var Nn="Canceled";function us(r){return r instanceof Oe?!0:r instanceof Error&&r.name===Nn&&r.message===Nn}var Oe=class extends Error{constructor(){super(Nn),this.name=this.message}},ui=class r extends Error{static{this._name="PendingMigrationError"}static is(e){return e instanceof r||e instanceof Error&&e.name===r._name}constructor(e){super(e),this.name=r._name}};var vt=class r extends Error{constructor(e){super(e),this.name="CodeExpectedError"}static fromError(e){if(e instanceof r)return e;let t=new r;return t.message=e.message,t.stack=e.stack,t}static isErrorNoTelemetry(e){return e.name==="CodeExpectedError"}},w=class r extends Error{constructor(e){super(e||"An unexpected bug occurred."),Object.setPrototypeOf(this,r.prototype)}};function Un(r,e,t=(n,i)=>n===i){if(r===e)return!0;if(!r||!e||r.length!==e.length)return!1;for(let n=0,i=r.length;n<i;n++)if(!t(r[n],e[n]))return!1;return!0}function Mn(r,e){let t=0,n=r-1;for(;t<=n;){let i=(t+n)/2|0,s=e(i);if(s<0)t=i+1;else if(s>0)n=i-1;else return i}return-(t+1)}function Tt(r,e,t){let n=r.slice(0,e),i=r.slice(e);return n.concat(t,i)}var fi;(l=>{function r(u){return u<0}l.isLessThan=r;function e(u){return u<=0}l.isLessThanOrEqual=e;function t(u){return u>0}l.isGreaterThan=t;function n(u){return u===0}l.isNeitherLessOrGreaterThan=n,l.greaterThan=1,l.lessThan=-1,l.neitherLessOrGreaterThan=0})(fi||={});function qt(r,e){return(t,n)=>e(r(t),r(n))}var jt=(r,e)=>r-e;var ci=class r{constructor(e){this.iterate=e}static{this.empty=new r(e=>{})}forEach(e){this.iterate(t=>(e(t),!0))}toArray(){let e=[];return this.iterate(t=>(e.push(t),!0)),e}filter(e){return new r(t=>this.iterate(n=>e(n)?t(n):!0))}map(e){return new r(t=>this.iterate(n=>t(e(n))))}some(e){let t=!1;return this.iterate(n=>(t=e(n),!t)),t}findFirst(e){let t;return this.iterate(n=>e(n)?(t=n,!1):!0),t}findLast(e){let t;return this.iterate(n=>(e(n)&&(t=n),!0)),t}findLastMaxBy(e){let t,n=!0;return this.iterate(i=>((n||fi.isGreaterThan(e(i,t)))&&(n=!1,t=i),!0)),t}};function gi(r,e){let t=Object.create(null);for(let n of r){let i=e(n),s=t[i];s||(s=t[i]=[]),s.push(n)}return t}var bi,hi,mi=class{constructor(e,t){this.toKey=t;this._map=new Map;this[bi]="SetWithKey";for(let n of e)this.add(n)}get size(){return this._map.size}add(e){let t=this.toKey(e);return this._map.set(t,e),this}delete(e){return this._map.delete(this.toKey(e))}has(e){return this._map.has(this.toKey(e))}*entries(){for(let e of this._map.values())yield[e,e]}keys(){return this.values()}*values(){for(let e of this._map.values())yield e}clear(){this._map.clear()}forEach(e,t){this._map.forEach(n=>e.call(t,n,n,this))}[(hi=Symbol.iterator,bi=Symbol.toStringTag,hi)](){return this.values()}};var Fn=class{constructor(e,t){this.uri=e;this.value=t}};function cs(r){return Array.isArray(r)}var xi,xt=class r{constructor(e,t){this[xi]="ResourceMap";if(e instanceof r)this.map=new Map(e.map),this.toKey=t??r.defaultToKey;else if(cs(e)){this.map=new Map,this.toKey=t??r.defaultToKey;for(let[n,i]of e)this.set(n,i)}else this.map=new Map,this.toKey=e??r.defaultToKey}static{this.defaultToKey=e=>e.toString()}set(e,t){return this.map.set(this.toKey(e),new Fn(e,t)),this}get(e){return this.map.get(this.toKey(e))?.value}has(e){return this.map.has(this.toKey(e))}get size(){return this.map.size}clear(){this.map.clear()}delete(e){return this.map.delete(this.toKey(e))}forEach(e,t){typeof t<"u"&&(e=e.bind(t));for(let[n,i]of this.map)e(i.value,i.uri,this)}*values(){for(let e of this.map.values())yield e.value}*keys(){for(let e of this.map.values())yield e.uri}*entries(){for(let e of this.map.values())yield[e.uri,e.value]}*[(xi=Symbol.toStringTag,Symbol.iterator)](){for(let[,e]of this.map)yield[e.uri,e.value]}},yi,vi=class{constructor(e,t){this[yi]="ResourceSet";!e||typeof e=="function"?this._map=new xt(e):(this._map=new xt(t),e.forEach(this.add,this))}get size(){return this._map.size}add(e){return this._map.set(e,e),this}clear(){this._map.clear()}delete(e){return this._map.delete(e)}forEach(e,t){this._map.forEach((n,i)=>e.call(t,i,i,this))}has(e){return this._map.has(e)}entries(){return this._map.entries()}keys(){return this._map.keys()}values(){return this._map.keys()}[(yi=Symbol.toStringTag,Symbol.iterator)](){return this.keys()}};var _i,Ti=class{constructor(){this[_i]="LinkedMap";this._map=new Map,this._head=void 0,this._tail=void 0,this._size=0,this._state=0}clear(){this._map.clear(),this._head=void 0,this._tail=void 0,this._size=0,this._state++}isEmpty(){return!this._head&&!this._tail}get size(){return this._size}get first(){return this._head?.value}get last(){return this._tail?.value}has(e){return this._map.has(e)}get(e,t=0){let n=this._map.get(e);if(n)return t!==0&&this.touch(n,t),n.value}set(e,t,n=0){let i=this._map.get(e);if(i)i.value=t,n!==0&&this.touch(i,n);else{switch(i={key:e,value:t,next:void 0,previous:void 0},n){case 0:this.addItemLast(i);break;case 1:this.addItemFirst(i);break;case 2:this.addItemLast(i);break;default:this.addItemLast(i);break}this._map.set(e,i),this._size++}return this}delete(e){return!!this.remove(e)}remove(e){let t=this._map.get(e);if(t)return this._map.delete(e),this.removeItem(t),this._size--,t.value}shift(){if(!this._head&&!this._tail)return;if(!this._head||!this._tail)throw new Error("Invalid list");let e=this._head;return this._map.delete(e.key),this.removeItem(e),this._size--,e.value}forEach(e,t){let n=this._state,i=this._head;for(;i;){if(t?e.bind(t)(i.value,i.key,this):e(i.value,i.key,this),this._state!==n)throw new Error("LinkedMap got modified during iteration.");i=i.next}}keys(){let e=this,t=this._state,n=this._head,i={[Symbol.iterator](){return i},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(n){let s={value:n.key,done:!1};return n=n.next,s}else return{value:void 0,done:!0}}};return i}values(){let e=this,t=this._state,n=this._head,i={[Symbol.iterator](){return i},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(n){let s={value:n.value,done:!1};return n=n.next,s}else return{value:void 0,done:!0}}};return i}entries(){let e=this,t=this._state,n=this._head,i={[Symbol.iterator](){return i},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(n){let s={value:[n.key,n.value],done:!1};return n=n.next,s}else return{value:void 0,done:!0}}};return i}[(_i=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}trimOld(e){if(e>=this.size)return;if(e===0){this.clear();return}let t=this._head,n=this.size;for(;t&&n>e;)this._map.delete(t.key),t=t.next,n--;this._head=t,this._size=n,t&&(t.previous=void 0),this._state++}trimNew(e){if(e>=this.size)return;if(e===0){this.clear();return}let t=this._tail,n=this.size;for(;t&&n>e;)this._map.delete(t.key),t=t.previous,n--;this._tail=t,this._size=n,t&&(t.next=void 0),this._state++}addItemFirst(e){if(!this._head&&!this._tail)this._tail=e;else if(this._head)e.next=this._head,this._head.previous=e;else throw new Error("Invalid list");this._head=e,this._state++}addItemLast(e){if(!this._head&&!this._tail)this._head=e;else if(this._tail)e.previous=this._tail,this._tail.next=e;else throw new Error("Invalid list");this._tail=e,this._state++}removeItem(e){if(e===this._head&&e===this._tail)this._head=void 0,this._tail=void 0;else if(e===this._head){if(!e.next)throw new Error("Invalid list");e.next.previous=void 0,this._head=e.next}else if(e===this._tail){if(!e.previous)throw new Error("Invalid list");e.previous.next=void 0,this._tail=e.previous}else{let t=e.next,n=e.previous;if(!t||!n)throw new Error("Invalid list");t.previous=n,n.next=t}e.next=void 0,e.previous=void 0,this._state++}touch(e,t){if(!this._head||!this._tail)throw new Error("Invalid list");if(!(t!==1&&t!==2)){if(t===1){if(e===this._head)return;let n=e.next,i=e.previous;e===this._tail?(i.next=void 0,this._tail=i):(n.previous=i,i.next=n),e.previous=void 0,e.next=this._head,this._head.previous=e,this._head=e,this._state++}else if(t===2){if(e===this._tail)return;let n=e.next,i=e.previous;e===this._head?(n.previous=void 0,this._head=n):(n.previous=i,i.next=n),e.next=void 0,e.previous=this._tail,this._tail.next=e,this._tail=e,this._state++}}}toJSON(){let e=[];return this.forEach((t,n)=>{e.push([n,t])}),e}fromJSON(e){this.clear();for(let[t,n]of e)this.set(t,n)}};var $t=class{constructor(){this.map=new Map}add(e,t){let n=this.map.get(e);n||(n=new Set,this.map.set(e,n)),n.add(t)}delete(e,t){let n=this.map.get(e);n&&(n.delete(t),n.size===0&&this.map.delete(e))}forEach(e,t){let n=this.map.get(e);n&&n.forEach(t)}get(e){let t=this.map.get(e);return t||new Set}};function yt(r){if(!r()){debugger;r(),W(new w("Assertion Failed"))}}function Ii(r){return typeof r=="string"}function ki(r){return!!r&&typeof r[Symbol.iterator]=="function"}function fs(r){return typeof r>"u"}function Xe(r){return!ps(r)}function ps(r){return fs(r)||r===null}var Vn;(In=>{function r(y){return!!y&&typeof y=="object"&&typeof y[Symbol.iterator]=="function"}In.is=r;let e=Object.freeze([]);function t(){return e}In.empty=t;function*n(y){yield y}In.single=n;function i(y){return r(y)?y:n(y)}In.wrap=i;function s(y){return y??e}In.from=s;function*a(y){for(let S=y.length-1;S>=0;S--)yield y[S]}In.reverse=a;function l(y){return!y||y[Symbol.iterator]().next().done===!0}In.isEmpty=l;function u(y){return y[Symbol.iterator]().next().value}In.first=u;function d(y,S){let O=0;for(let Y of y)if(S(Y,O++))return!0;return!1}In.some=d;function f(y,S){let O=0;for(let Y of y)if(!S(Y,O++))return!1;return!0}In.every=f;function c(y,S){for(let O of y)if(S(O))return O}In.find=c;function*b(y,S){for(let O of y)S(O)&&(yield O)}In.filter=b;function*k(y,S){let O=0;for(let Y of y)yield S(Y,O++)}In.map=k;function*A(y,S){let O=0;for(let Y of y)yield*S(Y,O++)}In.flatMap=A;function*M(...y){for(let S of y)ki(S)?yield*S:yield S}In.concat=M;function J(y,S,O){let Y=O;for(let Me of y)Y=S(Y,Me);return Y}In.reduce=J;function ge(y){let S=0;for(let O of y)S++;return S}In.length=ge;function*Ue(y,S,O=y.length){for(S<-y.length&&(S=0),S<0&&(S+=y.length),O<0?O+=y.length:O>y.length&&(O=y.length);S<O;S++)yield y[S]}In.slice=Ue;function X(y,S=Number.POSITIVE_INFINITY){let O=[];if(S===0)return[O,y];let Y=y[Symbol.iterator]();for(let Me=0;Me<S;Me++){let Pt=Y.next();if(Pt.done)return[O,In.empty()];O.push(Pt.value)}return[O,{[Symbol.iterator](){return Y}}]}In.consume=X;async function Ye(y){let S=[];for await(let O of y)S.push(O);return S}In.asyncToArray=Ye;async function _n(y){let S=[];for await(let O of y)S=S.concat(O);return S}In.asyncToArrayFlat=_n})(Vn||={});var bs=!1,et=null;var Si=class r{constructor(){this.livingDisposables=new Map}static{this.idx=0}getDisposableData(e){let t=this.livingDisposables.get(e);return t||(t={parent:null,source:null,isSingleton:!1,value:e,idx:r.idx++},this.livingDisposables.set(e,t)),t}trackDisposable(e){let t=this.getDisposableData(e);t.source||(t.source=new Error().stack)}setParent(e,t){let n=this.getDisposableData(e);n.parent=t}markAsDisposed(e){this.livingDisposables.delete(e)}markAsSingleton(e){this.getDisposableData(e).isSingleton=!0}getRootParent(e,t){let n=t.get(e);if(n)return n;let i=e.parent?this.getRootParent(this.getDisposableData(e.parent),t):e;return t.set(e,i),i}getTrackedDisposables(){let e=new Map;return[...this.livingDisposables.entries()].filter(([,n])=>n.source!==null&&!this.getRootParent(n,e).isSingleton).flatMap(([n])=>n)}computeLeakingDisposables(e=10,t){let n;if(t)n=t;else{let u=new Map,d=[...this.livingDisposables.values()].filter(c=>c.source!==null&&!this.getRootParent(c,u).isSingleton);if(d.length===0)return;let f=new Set(d.map(c=>c.value));if(n=d.filter(c=>!(c.parent&&f.has(c.parent))),n.length===0)throw new Error("There are cyclic diposable chains!")}if(!n)return;function i(u){function d(c,b){for(;c.length>0&&b.some(k=>typeof k=="string"?k===c[0]:c[0].match(k));)c.shift()}let f=u.source.split(`
`).map(c=>c.trim().replace("at ","")).filter(c=>c!=="");return d(f,["Error",/^trackDisposable \(.*\)$/,/^DisposableTracker.trackDisposable \(.*\)$/]),f.reverse()}let s=new $t;for(let u of n){let d=i(u);for(let f=0;f<=d.length;f++)s.add(d.slice(0,f).join(`
`),u)}n.sort(qt(u=>u.idx,jt));let a="",l=0;for(let u of n.slice(0,e)){l++;let d=i(u),f=[];for(let c=0;c<d.length;c++){let b=d[c];b=`(shared with ${s.get(d.slice(0,c+1).join(`
`)).size}/${n.length} leaks) at ${b}`;let A=s.get(d.slice(0,c).join(`
`)),M=gi([...A].map(J=>i(J)[c]),J=>J);delete M[d[c]];for(let[J,ge]of Object.entries(M))ge&&f.unshift(`    - stacktraces of ${ge.length} other leaks continue with ${J}`);f.unshift(b)}a+=`


==================== Leaking disposable ${l}/${n.length}: ${u.value.constructor.name} ====================
${f.join(`
`)}
============================================================

`}return n.length>e&&(a+=`


... and ${n.length-e} more leaking disposables

`),{leaks:n,details:a}}};function hs(r){et=r}if(bs){let r="__is_disposable_tracked__";hs(new class{trackDisposable(e){let t=new Error("Potentially leaked disposable").stack;setTimeout(()=>{e[r]||console.log(t)},3e3)}setParent(e,t){if(e&&e!==K.None)try{e[r]=!0}catch{}}markAsDisposed(e){if(e&&e!==K.None)try{e[r]=!0}catch{}}markAsSingleton(e){}})}function tt(r){return et?.trackDisposable(r),r}function nt(r){et?.markAsDisposed(r)}function Bn(r,e){et?.setParent(r,e)}function gs(r,e){if(et)for(let t of r)et.setParent(t,e)}function Ei(r){if(Vn.is(r)){let e=[];for(let t of r)if(t)try{t.dispose()}catch(n){e.push(n)}if(e.length===1)throw e[0];if(e.length>1)throw new AggregateError(e,"Encountered errors while disposing of store");return Array.isArray(r)?[]:r}else if(r)return r.dispose(),r}function wi(...r){let e=ie(()=>Ei(r));return gs(r,e),e}var zn=class{constructor(e){this._isDisposed=!1,this._fn=e,tt(this)}dispose(){if(!this._isDisposed){if(!this._fn)throw new Error("Unbound disposable context: Need to use an arrow function to preserve the value of this");this._isDisposed=!0,nt(this),this._fn()}}};function ie(r){return new zn(r)}var q=class r{constructor(){this._toDispose=new Set;this._isDisposed=!1;tt(this)}static{this.DISABLE_DISPOSED_WARNING=!1}dispose(){this._isDisposed||(nt(this),this._isDisposed=!0,this.clear())}get isDisposed(){return this._isDisposed}clear(){if(this._toDispose.size!==0)try{Ei(this._toDispose)}finally{this._toDispose.clear()}}add(e){if(!e||e===K.None)return e;if(e===this)throw new Error("Cannot register a disposable on itself!");return Bn(e,this),this._isDisposed?r.DISABLE_DISPOSED_WARNING||console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack):this._toDispose.add(e),e}delete(e){if(e){if(e===this)throw new Error("Cannot dispose a disposable on itself!");this._toDispose.delete(e),e.dispose()}}deleteAndLeak(e){e&&this._toDispose.delete(e)&&Bn(e,null)}assertNotDisposed(){this._isDisposed&&W(new w("Object disposed"))}},K=class{constructor(){this._store=new q;tt(this),Bn(this._store,this)}static{this.None=Object.freeze({dispose(){}})}dispose(){nt(this),this._store.dispose()}_register(e){if(e===this)throw new Error("Cannot register a disposable on itself!");return this._store.add(e)}};var Ri=class r{static{this.Undefined=new r(void 0)}constructor(e){this.element=e,this.next=r.Undefined,this.prev=r.Undefined}};var vs=globalThis.performance.now.bind(globalThis.performance),We=class r{static create(e){return new r(e)}constructor(e){this._now=e===!1?Date.now:vs,this._startTime=this._now(),this._stopTime=-1}stop(){this._stopTime=this._now()}reset(){this._startTime=this._now(),this._stopTime=-1}elapsed(){return this._stopTime!==-1?this._stopTime-this._startTime:this._now()-this._startTime}};var Li=!1,xs=!1,Ke;(Fe=>{Fe.None=()=>K.None;function e(g){if(xs){let{onDidAddListener:p}=g,h=_t.create(),m=0;g.onDidAddListener=()=>{++m===2&&(console.warn("snapshotted emitter LIKELY used public and SHOULD HAVE BEEN created with DisposableStore. snapshotted here"),h.print()),p?.()}}}function t(g,p,h){return k(g,()=>{},0,void 0,p??!0,void 0,h)}Fe.defer=t;function n(g){return(p,h=null,m)=>{let v=!1,_;return _=g(R=>{if(!v)return _?_.dispose():v=!0,p.call(h,R)},null,m),v&&_.dispose(),_}}Fe.once=n;function i(g,p){return Fe.once(Fe.filter(g,p))}Fe.onceIf=i;function s(g,p,h){return c((m,v=null,_)=>g(R=>m.call(v,p(R)),null,_),h)}Fe.map=s;function a(g,p,h){return c((m,v=null,_)=>g(R=>{p(R),m.call(v,R)},null,_),h)}Fe.forEach=a;function l(g,p,h){return c((m,v=null,_)=>g(R=>p(R)&&m.call(v,R),null,_),h)}Fe.filter=l;function u(g){return g}Fe.signal=u;function d(...g){return(p,h=null,m)=>{let v=wi(...g.map(_=>_(R=>p.call(h,R))));return b(v,m)}}Fe.any=d;function f(g,p,h,m){let v=h;return s(g,_=>(v=p(v,_),v),m)}Fe.reduce=f;function c(g,p){let h,m={onWillAddFirstListener(){h=g(v.fire,v)},onDidRemoveLastListener(){h?.dispose()}};p||e(m);let v=new $(m);return p?.add(v),v.event}function b(g,p){return p instanceof Array?p.push(g):p&&p.add(g),g}function k(g,p,h=100,m=!1,v=!1,_,R){let B,P,ee,se=0,ve,Te={leakWarningThreshold:_,onWillAddFirstListener(){B=g(zr=>{se++,P=p(P,zr),m&&!ee&&(Ve.fire(P),P=void 0),ve=()=>{let Wr=P;P=void 0,ee=void 0,(!m||se>1)&&Ve.fire(Wr),se=0},typeof h=="number"?(ee&&clearTimeout(ee),ee=setTimeout(ve,h)):ee===void 0&&(ee=null,queueMicrotask(ve))})},onWillRemoveListener(){v&&se>0&&ve?.()},onDidRemoveLastListener(){ve=void 0,B.dispose()}};R||e(Te);let Ve=new $(Te);return R?.add(Ve),Ve.event}Fe.debounce=k;function A(g,p=0,h,m){return Fe.debounce(g,(v,_)=>v?(v.push(_),v):[_],p,void 0,h??!0,void 0,m)}Fe.accumulate=A;function M(g,p,h=100,m=!0,v=!0,_,R){let B,P,ee,se=0,ve={leakWarningThreshold:_,onWillAddFirstListener(){B=g(Ve=>{se++,P=p(P,Ve),ee===void 0&&(m&&(Te.fire(P),P=void 0,se=0),typeof h=="number"?ee=setTimeout(()=>{v&&se>0&&Te.fire(P),P=void 0,ee=void 0,se=0},h):(ee=0,queueMicrotask(()=>{v&&se>0&&Te.fire(P),P=void 0,ee=void 0,se=0})))})},onDidRemoveLastListener(){B.dispose()}};R||e(ve);let Te=new $(ve);return R?.add(Te),Te.event}Fe.throttle=M;function J(g,p=(m,v)=>m===v,h){let m=!0,v;return l(g,_=>{let R=m||!p(_,v);return m=!1,v=_,R},h)}Fe.latch=J;function ge(g,p,h){return[Fe.filter(g,p,h),Fe.filter(g,m=>!p(m),h)]}Fe.split=ge;function Ue(g,p=!1,h=[],m){let v=h.slice(),_=g(P=>{v?v.push(P):B.fire(P)});m&&m.add(_);let R=()=>{v?.forEach(P=>B.fire(P)),v=null},B=new $({onWillAddFirstListener(){_||(_=g(P=>B.fire(P)),m&&m.add(_))},onDidAddFirstListener(){v&&(p?setTimeout(R):R())},onDidRemoveLastListener(){_&&_.dispose(),_=null}});return m&&m.add(B),B.event}Fe.buffer=Ue;function X(g,p){return(m,v,_)=>{let R=p(new _n);return g(function(B){let P=R.evaluate(B);P!==Ye&&m.call(v,P)},void 0,_)}}Fe.chain=X;let Ye=Symbol("HaltChainable");class _n{constructor(){this.steps=[]}map(p){return this.steps.push(p),this}forEach(p){return this.steps.push(h=>(p(h),h)),this}filter(p){return this.steps.push(h=>p(h)?h:Ye),this}reduce(p,h){let m=h;return this.steps.push(v=>(m=p(m,v),m)),this}latch(p=(h,m)=>h===m){let h=!0,m;return this.steps.push(v=>{let _=h||!p(v,m);return h=!1,m=v,_?v:Ye}),this}evaluate(p){for(let h of this.steps)if(p=h(p),p===Ye)break;return p}}function In(g,p,h=m=>m){let m=(...B)=>R.fire(h(...B)),v=()=>g.on(p,m),_=()=>g.removeListener(p,m),R=new $({onWillAddFirstListener:v,onDidRemoveLastListener:_});return R.event}Fe.fromNodeEventEmitter=In;function y(g,p,h=m=>m){let m=(...B)=>R.fire(h(...B)),v=()=>g.addEventListener(p,m),_=()=>g.removeEventListener(p,m),R=new $({onWillAddFirstListener:v,onDidRemoveLastListener:_});return R.event}Fe.fromDOMEventEmitter=y;function S(g,p){let h,m,v=new Promise(_=>{m=n(g)(_),Hn(m,p),h=()=>{Di(m,p)}});return v.cancel=h,p&&v.finally(()=>Di(m,p)),v}Fe.toPromise=S;function O(g,p){return g(h=>p.fire(h))}Fe.forward=O;function Y(g,p,h){return p(h),g(m=>p(m))}Fe.runAndSubscribe=Y;class Me{constructor(p,h){this._observable=p;this._counter=0;this._hasChanged=!1;let m={onWillAddFirstListener:()=>{p.addObserver(this),this._observable.reportChanges()},onDidRemoveLastListener:()=>{p.removeObserver(this)}};h||e(m),this.emitter=new $(m),h&&h.add(this.emitter)}beginUpdate(p){this._counter++}handlePossibleChange(p){}handleChange(p,h){this._hasChanged=!0}endUpdate(p){this._counter--,this._counter===0&&(this._observable.reportChanges(),this._hasChanged&&(this._hasChanged=!1,this.emitter.fire(this._observable.get())))}}function Pt(g,p){return new Me(g,p).emitter.event}Fe.fromObservable=Pt;function Lo(g){return(p,h,m)=>{let v=0,_=!1,R={beginUpdate(){v++},endUpdate(){v--,v===0&&(g.reportChanges(),_&&(_=!1,p.call(h)))},handlePossibleChange(){},handleChange(){_=!0}};g.addObserver(R),g.reportChanges();let B={dispose(){g.removeObserver(R)}};return Hn(B,m),B}}Fe.fromObservableLight=Lo})(Ke||={});var Wn=class r{constructor(e){this.listenerCount=0;this.invocationCount=0;this.elapsedOverall=0;this.durations=[];this.name=`${e}_${r._idPool++}`,r.all.add(this)}static{this.all=new Set}static{this._idPool=0}start(e){this._stopWatch=new We,this.listenerCount=e}stop(){if(this._stopWatch){let e=this._stopWatch.elapsed();this.durations.push(e),this.elapsedOverall+=e,this.invocationCount+=1,this._stopWatch=void 0}}},Oi=-1;var Kn=class r{constructor(e,t,n=(r._idPool++).toString(16).padStart(3,"0")){this._errorHandler=e;this.threshold=t;this.name=n;this._warnCountdown=0}static{this._idPool=1}dispose(){this._stacks?.clear()}check(e,t){let n=this.threshold;if(n<=0||t<n)return;this._stacks||(this._stacks=new Map);let i=this._stacks.get(e.value)||0;if(this._stacks.set(e.value,i+1),this._warnCountdown-=1,this._warnCountdown<=0){this._warnCountdown=n*.5;let[s,a]=this.getMostFrequentStack(),l=`[${this.name}] potential listener LEAK detected, having ${t} listeners already. MOST frequent listener (${a}):`;console.warn(l),console.warn(s);let u=new qn(l,s);this._errorHandler(u)}return()=>{let s=this._stacks.get(e.value)||0;this._stacks.set(e.value,s-1)}}getMostFrequentStack(){if(!this._stacks)return;let e,t=0;for(let[n,i]of this._stacks)(!e||t<i)&&(e=[n,i],t=i);return e}},_t=class r{constructor(e){this.value=e}static create(){let e=new Error;return new r(e.stack??"")}print(){console.warn(this.value.split(`
`).slice(2).join(`
`))}},qn=class extends Error{constructor(e,t){super(e),this.name="ListenerLeakError",this.stack=t}},jn=class extends Error{constructor(e,t){super(e),this.name="ListenerRefusalError",this.stack=t}},ys=0,rt=class{constructor(e){this.value=e;this.id=ys++}},_s=2,Is=(r,e)=>{if(r instanceof rt)e(r);else for(let t=0;t<r.length;t++){let n=r[t];n&&e(n)}},$=class{constructor(e){this._size=0;this._options=e,this._leakageMon=Oi>0||this._options?.leakWarningThreshold?new Kn(e?.onListenerError??W,this._options?.leakWarningThreshold??Oi):void 0,this._perfMon=this._options?._profName?new Wn(this._options._profName):void 0,this._deliveryQueue=this._options?.deliveryQueue}dispose(){if(!this._disposed){if(this._disposed=!0,this._deliveryQueue?.current===this&&this._deliveryQueue.reset(),this._listeners){if(Li){let e=this._listeners;queueMicrotask(()=>{Is(e,t=>t.stack?.print())})}this._listeners=void 0,this._size=0}this._options?.onDidRemoveLastListener?.(),this._leakageMon?.dispose()}}get event(){return this._event??=(e,t,n)=>{if(this._leakageMon&&this._size>this._leakageMon.threshold**2){let u=`[${this._leakageMon.name}] REFUSES to accept new listeners because it exceeded its threshold by far (${this._size} vs ${this._leakageMon.threshold})`;console.warn(u);let d=this._leakageMon.getMostFrequentStack()??["UNKNOWN stack",-1],f=new jn(`${u}. HINT: Stack shows most frequent listener (${d[1]}-times)`,d[0]);return(this._options?.onListenerError||W)(f),K.None}if(this._disposed)return K.None;t&&(e=e.bind(t));let i=new rt(e),s,a;this._leakageMon&&this._size>=Math.ceil(this._leakageMon.threshold*.2)&&(i.stack=_t.create(),s=this._leakageMon.check(i.stack,this._size+1)),Li&&(i.stack=a??_t.create()),this._listeners?this._listeners instanceof rt?(this._deliveryQueue??=new $n,this._listeners=[this._listeners,i]):this._listeners.push(i):(this._options?.onWillAddFirstListener?.(this),this._listeners=i,this._options?.onDidAddFirstListener?.(this)),this._options?.onDidAddListener?.(this),this._size++;let l=ie(()=>{s?.(),this._removeListener(i)});return Hn(l,n),l},this._event}_removeListener(e){if(this._options?.onWillRemoveListener?.(this),!this._listeners)return;if(this._size===1){this._listeners=void 0,this._options?.onDidRemoveLastListener?.(this),this._size=0;return}let t=this._listeners,n=t.indexOf(e);if(n===-1)throw console.log("disposed?",this._disposed),console.log("size?",this._size),console.log("arr?",JSON.stringify(this._listeners)),new Error("Attempted to dispose unknown listener");this._size--,t[n]=void 0;let i=this._deliveryQueue.current===this;if(this._size*_s<=t.length){let s=0;for(let a=0;a<t.length;a++)t[a]?t[s++]=t[a]:i&&s<this._deliveryQueue.end&&(this._deliveryQueue.end--,s<this._deliveryQueue.i&&this._deliveryQueue.i--);t.length=s}}_deliver(e,t){if(!e)return;let n=this._options?.onListenerError||W;if(!n){e.value(t);return}try{e.value(t)}catch(i){n(i)}}_deliverQueue(e){let t=e.current._listeners;for(;e.i<e.end;)this._deliver(t[e.i++],e.value);e.reset()}fire(e){if(this._deliveryQueue?.current&&(this._deliverQueue(this._deliveryQueue),this._perfMon?.stop()),this._perfMon?.start(this._size),this._listeners)if(this._listeners instanceof rt)this._deliver(this._listeners,e);else{let t=this._deliveryQueue;t.enqueue(this,e,this._listeners.length),this._deliverQueue(t)}this._perfMon?.stop()}hasListeners(){return this._size>0}};var $n=class{constructor(){this.i=-1;this.end=0}enqueue(e,t,n){this.i=0,this.end=n,this.current=e,this.value=t}reset(){this.i=this.end,this.current=void 0,this.value=void 0}};function Hn(r,e){e instanceof q?e.add(r):Array.isArray(e)&&e.push(r)}function Di(r,e){if(e instanceof q)e.delete(r);else if(Array.isArray(e)){let t=e.indexOf(r);t!==-1&&e.splice(t,1)}r.dispose()}var Ai=Object.freeze(function(r,e){let t=setTimeout(r.bind(e),0);return{dispose(){clearTimeout(t)}}}),Ci;(n=>{function r(i){return i===n.None||i===n.Cancelled||i instanceof Gn?!0:!i||typeof i!="object"?!1:typeof i.isCancellationRequested=="boolean"&&typeof i.onCancellationRequested=="function"}n.isCancellationToken=r,n.None=Object.freeze({isCancellationRequested:!1,onCancellationRequested:Ke.None}),n.Cancelled=Object.freeze({isCancellationRequested:!0,onCancellationRequested:Ai})})(Ci||={});var Gn=class{constructor(){this._isCancelled=!1;this._emitter=null}cancel(){this._isCancelled||(this._isCancelled=!0,this._emitter&&(this._emitter.fire(void 0),this.dispose()))}get isCancellationRequested(){return this._isCancelled}get onCancellationRequested(){return this._isCancelled?Ai:(this._emitter||(this._emitter=new $),this._emitter.event)}dispose(){this._emitter&&(this._emitter.dispose(),this._emitter=null)}};function ks(r){return r}var Ht=class{constructor(e,t){this.lastCache=void 0;this.lastArgKey=void 0;typeof e=="function"?(this._fn=e,this._computeKey=ks):(this._fn=t,this._computeKey=e.getCacheKey)}get(e){let t=this._computeKey(e);return this.lastArgKey!==t&&(this.lastArgKey=t,this.lastCache=this._fn(e)),this.lastCache}};var Ae=class{constructor(e){this.executor=e;this._state=0}get hasValue(){return this._state===2}get value(){if(this._state===0){this._state=1;try{this._value=this.executor()}catch(e){this._error=e}finally{this._state=2}}else if(this._state===1)throw new Error("Cannot read the value of a lazy that is being initialized");if(this._error)throw this._error;return this._value}get rawValue(){return this._value}};function qe(r){return r<0?0:r>4294967295?4294967295:r|0}function Fi(r){return r.split(/\r\n|\r|\n/)}function Vi(r,e){return r<e?-1:r>e?1:0}function Ss(r,e,t=0,n=r.length,i=0,s=e.length){for(;t<n&&i<s;t++,i++){let u=r.charCodeAt(t),d=e.charCodeAt(i);if(u<d)return-1;if(u>d)return 1}let a=n-t,l=s-i;return a<l?-1:a>l?1:0}function Bi(r,e,t=0,n=r.length,i=0,s=e.length){for(;t<n&&i<s;t++,i++){let u=r.charCodeAt(t),d=e.charCodeAt(i);if(u===d)continue;if(u>=128||d>=128)return Ss(r.toLowerCase(),e.toLowerCase(),t,n,i,s);Pi(u)&&(u-=32),Pi(d)&&(d-=32);let f=u-d;if(f!==0)return f}let a=n-t,l=s-i;return a<l?-1:a>l?1:0}function Pi(r){return r>=97&&r<=122}function Yn(r){return r>=65&&r<=90}function Gt(r,e){return r.length===e.length&&Bi(r,e)===0}function Zn(r,e){let t=e.length;return t<=r.length&&Bi(r,e,0,t)===0}var Es=/(?:\x1b\[|\x9b)[=?>!]?[\d;:]*["$#'* ]?[a-zA-Z@^`{}|~]/,ws=/(?:\x1b\]|\x9d).*?(?:\x1b\\|\x07|\x9c)/,Rs=/\x1b(?:[ #%\(\)\*\+\-\.\/]?[a-zA-Z0-9\|}~@])/,zl=new RegExp("(?:"+[Es.source,ws.source,Rs.source].join("|")+")","g");var Wl=String.fromCharCode(65279);var Ni=class r{static{this._INSTANCE=null}static getInstance(){return r._INSTANCE||(r._INSTANCE=new r),r._INSTANCE}constructor(){this._data=Ls()}getGraphemeBreakType(e){if(e<32)return e===10?3:e===13?2:4;if(e<127)return 0;let t=this._data,n=t.length/3,i=1;for(;i<=n;)if(e<t[3*i])i=2*i;else if(e>t[3*i+1])i=2*i+1;else return t[3*i+2];return 0}};function Ls(){return JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]")}var Ui=class r{constructor(e){this.confusableDictionary=e}static{this.ambiguousCharacterData=new Ae(()=>JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,1523,96,8242,96,1370,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,118002,50,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,118003,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,118004,52,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,118005,53,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,118006,54,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,118007,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,118008,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,118009,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,117974,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,117975,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71913,67,71922,67,65315,67,8557,67,8450,67,8493,67,117976,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,117977,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,117978,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,117979,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,117980,71,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,117981,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,117983,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,117984,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,118001,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,117982,108,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,117985,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,117986,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,117987,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,118000,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,117988,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,117989,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,117990,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,117991,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,117992,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,117993,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,117994,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,117995,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71910,87,71919,87,117996,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,117997,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,117998,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,71909,90,66293,90,65338,90,8484,90,8488,90,117999,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65283,35,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"cs":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"es":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"fr":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"it":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ja":[8211,45,8218,44,65281,33,8216,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65292,44,65297,49,65307,59],"ko":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pt-BR":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ru":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"zh-hans":[160,32,65374,126,8218,44,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65297,49],"zh-hant":[8211,45,65374,126,8218,44,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89]}'))}static{this.cache=new Ht(e=>{let t=e.split(",");function n(c){let b=new Map;for(let k=0;k<c.length;k+=2)b.set(c[k],c[k+1]);return b}function i(c,b){let k=new Map(c);for(let[A,M]of b)k.set(A,M);return k}function s(c,b){if(!c)return b;let k=new Map;for(let[A,M]of c)b.has(A)&&k.set(A,M);return k}let a=this.ambiguousCharacterData.value,l=t.filter(c=>!c.startsWith("_")&&Object.hasOwn(a,c));l.length===0&&(l=["_default"]);let u;for(let c of l){let b=n(a[c]);u=s(u,b)}let d=n(a._common),f=i(d,u);return new r(f)})}static getInstance(e){return r.cache.get(Array.from(e).join(","))}static{this._locales=new Ae(()=>Object.keys(r.ambiguousCharacterData.value).filter(e=>!e.startsWith("_")))}static getLocales(){return r._locales.value}isAmbiguous(e){return this.confusableDictionary.has(e)}containsAmbiguousCharacter(e){for(let t=0;t<e.length;t++){let n=e.codePointAt(t);if(typeof n=="number"&&this.isAmbiguous(n))return!0}return!1}getPrimaryConfusable(e){return this.confusableDictionary.get(e)}getConfusableCodePoints(){return new Set(this.confusableDictionary.keys())}},Mi=class r{static getRawData(){return JSON.parse('{"_common":[11,12,13,127,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999],"cs":[173,8203,12288],"de":[173,8203,12288],"es":[8203,12288],"fr":[173,8203,12288],"it":[160,173,12288],"ja":[173],"ko":[173,12288],"pl":[173,8203,12288],"pt-BR":[173,8203,12288],"qps-ploc":[160,173,8203,12288],"ru":[173,12288],"tr":[160,173,8203,12288],"zh-hans":[160,173,8203,12288],"zh-hant":[173,12288]}')}static{this._data=void 0}static getData(){return this._data||(this._data=new Set([...Object.values(r.getRawData())].flat())),this._data}static isInvisibleCharacter(e){return r.getData().has(e)}static containsInvisibleCharacter(e){for(let t=0;t<e.length;t++){let n=e.codePointAt(t);if(typeof n=="number"&&(r.isInvisibleCharacter(n)||n===32))return!0}return!1}static get codePoints(){return r.getData()}};function Ce(r){return r===47||r===92}function Jn(r){return r.replace(/[\\/]/g,L.sep)}function zi(r){return r.indexOf("/")===-1&&(r=Jn(r)),/^[a-zA-Z]:(\/|$)/.test(r)&&(r="/"+r),r}function Xn(r,e=L.sep){if(!r)return"";let t=r.length,n=r.charCodeAt(0);if(Ce(n)){if(Ce(r.charCodeAt(1))&&!Ce(r.charCodeAt(2))){let s=3,a=s;for(;s<t&&!Ce(r.charCodeAt(s));s++);if(a!==s&&!Ce(r.charCodeAt(s+1))){for(s+=1;s<t;s++)if(Ce(r.charCodeAt(s)))return r.slice(0,s+1).replace(/[\\/]/g,e)}}return e}else if(Ds(n)&&r.charCodeAt(1)===58)return Ce(r.charCodeAt(2))?r.slice(0,2)+e:r.slice(0,2);let i=r.indexOf("://");if(i!==-1){for(i+=3;i<t;i++)if(Ce(r.charCodeAt(i)))return r.slice(0,i+1)}return""}function er(r,e,t,n=Je){if(r===e)return!0;if(!r||!e||e.length>r.length)return!1;if(t){if(!Zn(r,e))return!1;if(e.length===r.length)return!0;let s=e.length;return e.charAt(e.length-1)===n&&s--,r.charAt(s)===n}return e.charAt(e.length-1)!==n&&(e+=n),r.indexOf(e)===0}function Ds(r){return r>=65&&r<=90||r>=97&&r<=122}var j;(I=>(I.inMemory="inmemory",I.vscode="vscode",I.internal="private",I.walkThrough="walkThrough",I.walkThroughSnippet="walkThroughSnippet",I.http="http",I.https="https",I.file="file",I.mailto="mailto",I.untitled="untitled",I.data="data",I.command="command",I.vscodeRemote="vscode-remote",I.vscodeRemoteResource="vscode-remote-resource",I.vscodeManagedRemoteResource="vscode-managed-remote-resource",I.vscodeUserData="vscode-userdata",I.vscodeCustomEditor="vscode-custom-editor",I.vscodeNotebookCell="vscode-notebook-cell",I.vscodeNotebookCellMetadata="vscode-notebook-cell-metadata",I.vscodeNotebookCellMetadataDiff="vscode-notebook-cell-metadata-diff",I.vscodeNotebookCellOutput="vscode-notebook-cell-output",I.vscodeNotebookCellOutputDiff="vscode-notebook-cell-output-diff",I.vscodeNotebookMetadata="vscode-notebook-metadata",I.vscodeInteractiveInput="vscode-interactive-input",I.vscodeSettings="vscode-settings",I.vscodeWorkspaceTrust="vscode-workspace-trust",I.vscodeTerminal="vscode-terminal",I.vscodeChatCodeBlock="vscode-chat-code-block",I.vscodeChatCodeCompareBlock="vscode-chat-code-compare-block",I.vscodeChatEditor="vscode-chat-editor",I.vscodeChatInput="chatSessionInput",I.vscodeLocalChatSession="vscode-chat-session",I.webviewPanel="webview-panel",I.vscodeWebview="vscode-webview",I.vscodeBrowser="vscode-browser",I.extension="extension",I.vscodeFileResource="vscode-file",I.tmp="tmp",I.vsls="vsls",I.vscodeSourceControl="vscode-scm",I.commentsInput="comment",I.codeSetting="code-setting",I.outputChannel="output",I.accessibleView="accessible-view",I.chatEditingSnapshotScheme="chat-editing-snapshot-text-model",I.chatEditingModel="chat-editing-text-model",I.copilotPr="copilot-pr"))(j||={});var Cs="tkn",tr=class{constructor(){this._hosts=Object.create(null);this._ports=Object.create(null);this._connectionTokens=Object.create(null);this._preferredWebSchema="http";this._delegate=null;this._serverRootPath="/"}setPreferredWebSchema(e){this._preferredWebSchema=e}setDelegate(e){this._delegate=e}setServerRootPath(e,t){this._serverRootPath=L.join(t??"/",Ns(e))}getServerRootPath(){return this._serverRootPath}get _remoteResourcesPath(){return L.join(this._serverRootPath,j.vscodeRemoteResource)}set(e,t,n){this._hosts[e]=t,this._ports[e]=n}setConnectionToken(e,t){this._connectionTokens[e]=t}getPreferredWebSchema(){return this._preferredWebSchema}rewrite(e){if(this._delegate)try{return this._delegate(e)}catch(l){return W(l),e}let t=e.authority,n=this._hosts[t];n&&n.indexOf(":")!==-1&&n.indexOf("[")===-1&&(n=`[${n}]`);let i=this._ports[t],s=this._connectionTokens[t],a=`path=${encodeURIComponent(e.path)}`;return typeof s=="string"&&(a+=`&${Cs}=${encodeURIComponent(s)}`),z.from({scheme:ct?this._preferredWebSchema:j.vscodeRemoteResource,authority:`${n}:${i}`,path:this._remoteResourcesPath,query:a})}},Ps=new tr;function Ns(r){return`${r.quality??"oss"}-${r.commit??"dev"}`}var Wi="vs/../../node_modules",Ki="vs/../../node_modules.asar";var rr="vscode-app",nr=class r{static{this.FALLBACK_AUTHORITY=rr}asBrowserUri(e){let t=this.toUri(e);return this.uriToBrowserUri(t)}uriToBrowserUri(e){return e.scheme===j.vscodeRemote?Ps.rewrite(e):e.scheme===j.file&&(Qr||Yr===`${j.vscodeFileResource}://${r.FALLBACK_AUTHORITY}`)?e.with({scheme:j.vscodeFileResource,authority:e.authority||r.FALLBACK_AUTHORITY,query:null,fragment:null}):e}asFileUri(e){let t=this.toUri(e);return this.uriToFileUri(t)}uriToFileUri(e){return e.scheme===j.vscodeFileResource?e.with({scheme:j.file,authority:e.authority!==r.FALLBACK_AUTHORITY?e.authority:null,query:null,fragment:null}):e}toUri(e){if(z.isUri(e))return e;if(globalThis._VSCODE_FILE_ROOT){let t=globalThis._VSCODE_FILE_ROOT;if(/^\w[\w\d+.-]*:\/\//.test(t))return z.joinPath(z.parse(t,!0),e);let n=On(t,e);return z.file(n)}throw new Error("Cannot determine URI for module id!")}},qi=new nr,Jl=Object.freeze({"Cache-Control":"no-cache, no-store"}),Xl=Object.freeze({"Document-Policy":"include-js-call-stacks-in-crash-reports"}),Us;(s=>{let r=new Map([["1",{"Cross-Origin-Opener-Policy":"same-origin"}],["2",{"Cross-Origin-Embedder-Policy":"require-corp"}],["3",{"Cross-Origin-Opener-Policy":"same-origin","Cross-Origin-Embedder-Policy":"require-corp"}]]);s.CoopAndCoep=Object.freeze(r.get("3"));let t="vscode-coi";function n(a){let l;typeof a=="string"?l=new URL(a).searchParams:a instanceof URL?l=a.searchParams:z.isUri(a)&&(l=new URL(a.toString(!0)).searchParams);let u=l?.get(t);if(u)return r.get(u)}s.getHeadersFromQuery=n;function i(a,l,u){if(!globalThis.crossOriginIsolated)return;let d=l&&u?"3":u?"2":"1";a instanceof URLSearchParams?a.set(t,d):a[t]=d}s.addSearchParam=i})(Us||={});function ke(r){return bt(r,!0)}var It=class{constructor(e){this._ignorePathCasing=e}compare(e,t,n=!1){return e===t?0:Vi(this.getComparisonKey(e,n),this.getComparisonKey(t,n))}isEqual(e,t,n=!1){return e===t?!0:!e||!t?!1:this.getComparisonKey(e,n)===this.getComparisonKey(t,n)}getComparisonKey(e,t=!1){return e.with({path:this._ignorePathCasing(e)?e.path.toLowerCase():void 0,fragment:t?null:void 0}).toString()}ignorePathCasing(e){return this._ignorePathCasing(e)}isEqualOrParent(e,t,n=!1){if(e.scheme===t.scheme){if(e.scheme===j.file)return er(ke(e),ke(t),this._ignorePathCasing(e))&&e.query===t.query&&(n||e.fragment===t.fragment);if(ji(e.authority,t.authority))return er(e.path,t.path,this._ignorePathCasing(e),"/")&&e.query===t.query&&(n||e.fragment===t.fragment)}return!1}joinPath(e,...t){return z.joinPath(e,...t)}basenameOrAuthority(e){return Ms(e)||e.authority}basename(e){return L.basename(e.path)}extname(e){return L.extname(e.path)}dirname(e){if(e.path.length===0)return e;let t;return e.scheme===j.file?t=z.file(ni(ke(e))).path:(t=L.dirname(e.path),e.authority&&t.length&&t.charCodeAt(0)!==47&&(console.error(`dirname("${e.toString})) resulted in a relative path`),t="/")),e.with({path:t})}normalizePath(e){if(!e.path.length)return e;let t;return e.scheme===j.file?t=z.file(Ln(ke(e))).path:t=L.normalize(e.path),e.with({path:t})}relativePath(e,t){if(e.scheme!==t.scheme||!ji(e.authority,t.authority))return;if(e.scheme===j.file){let s=ti(ke(e),ke(t));return he?Jn(s):s}let n=e.path||"/",i=t.path||"/";if(this._ignorePathCasing(e)){let s=0;for(let a=Math.min(n.length,i.length);s<a&&!(n.charCodeAt(s)!==i.charCodeAt(s)&&n.charAt(s).toLowerCase()!==i.charAt(s).toLowerCase());s++);n=i.substr(0,s)+n.substr(s)}return L.relative(n,i)}resolvePath(e,t){if(e.scheme===j.file){let n=z.file(ei(ke(e),t));return e.with({authority:n.authority,path:n.path})}return t=zi(t),e.with({path:L.resolve(e.path,t)})}isAbsolutePath(e){return!!e.path&&e.path[0]==="/"}isEqualAuthority(e,t){return e===t||e!==void 0&&t!==void 0&&Gt(e,t)}hasTrailingPathSeparator(e,t=Je){if(e.scheme===j.file){let n=ke(e);return n.length>Xn(n).length&&n[n.length-1]===t}else{let n=e.path;return n.length>1&&n.charCodeAt(n.length-1)===47&&!/^[a-zA-Z]:(\/$|\\$)/.test(e.fsPath)}}removeTrailingPathSeparator(e,t=Je){return $i(e,t)?e.with({path:e.path.substr(0,e.path.length-1)}):e}addTrailingPathSeparator(e,t=Je){let n=!1;if(e.scheme===j.file){let i=ke(e);n=i!==void 0&&i.length===Xn(i).length&&i[i.length-1]===t}else{t="/";let i=e.path;n=i.length===1&&i.charCodeAt(i.length-1)===47}return!n&&!$i(e,t)?e.with({path:e.path+"/"}):e}},D=new It(()=>!1),su=new It(r=>r.scheme===j.file?!Gr:!0),au=new It(r=>!0),Hi=D.isEqual.bind(D),lu=D.isEqualOrParent.bind(D),uu=D.getComparisonKey.bind(D),du=D.basenameOrAuthority.bind(D),Ms=D.basename.bind(D),cu=D.extname.bind(D),fu=D.dirname.bind(D),pu=D.joinPath.bind(D),mu=D.normalizePath.bind(D),bu=D.relativePath.bind(D),hu=D.resolvePath.bind(D),gu=D.isAbsolutePath.bind(D),ji=D.isEqualAuthority.bind(D),$i=D.hasTrailingPathSeparator.bind(D),vu=D.removeTrailingPathSeparator.bind(D),Tu=D.addTrailingPathSeparator.bind(D);var Fs;(s=>{s.META_DATA_LABEL="label",s.META_DATA_DESCRIPTION="description",s.META_DATA_SIZE="size",s.META_DATA_MIME="mime";function i(a){let l=new Map;a.path.substring(a.path.indexOf(";")+1,a.path.lastIndexOf(";")).split(";").forEach(f=>{let[c,b]=f.split(":");c&&b&&l.set(c,b)});let d=a.path.substring(0,a.path.indexOf(";"));return d&&l.set(s.META_DATA_MIME,d),l}s.parseMetaData=i})(Fs||={});var Qt=class{constructor(){this._scopeNameToLanguageRegistration=Object.create(null)}reset(){this._scopeNameToLanguageRegistration=Object.create(null)}register(e){if(this._scopeNameToLanguageRegistration[e.scopeName]){let t=this._scopeNameToLanguageRegistration[e.scopeName];Hi(t.location,e.location)||console.warn(`Overwriting grammar scope name to file mapping for scope ${e.scopeName}.
Old grammar file: ${t.location.toString()}.
New grammar file: ${e.location.toString()}`)}this._scopeNameToLanguageRegistration[e.scopeName]=e}getGrammarDefinition(e){return this._scopeNameToLanguageRegistration[e]||null}};var ir="No TM Grammar registered for this language.",Yt=class extends K{constructor(e,t,n,i){super(),this._host=e,this._initialState=n.INITIAL,this._scopeRegistry=new Qt,this._injections={},this._injectedEmbeddedLanguages={},this._languageToScope=new Map,this._grammarRegistry=this._register(new n.Registry({onigLib:i,loadGrammar:async s=>{let a=this._scopeRegistry.getGrammarDefinition(s);if(!a)return this._host.logTrace(`No grammar found for scope ${s}`),null;let l=a.location;try{let u=await this._host.readFile(l);return n.parseRawGrammar(u,l.path)}catch(u){return this._host.logError(`Unable to load and parse grammar for scope ${s} from ${l}`,u),null}},getInjections:s=>{let a=s.split("."),l=[];for(let u=1;u<=a.length;u++){let d=a.slice(0,u).join(".");l=[...l,...this._injections[d]||[]]}return l}}));for(let s of t){if(this._scopeRegistry.register(s),s.injectTo){for(let a of s.injectTo){let l=this._injections[a];l||(this._injections[a]=l=[]),l.push(s.scopeName)}if(s.embeddedLanguages)for(let a of s.injectTo){let l=this._injectedEmbeddedLanguages[a];l||(this._injectedEmbeddedLanguages[a]=l=[]),l.push(s.embeddedLanguages)}}s.language&&this._languageToScope.set(s.language,s.scopeName)}}has(e){return this._languageToScope.has(e)}setTheme(e,t){this._grammarRegistry.setTheme(e,t)}getColorMap(){return this._grammarRegistry.getColorMap()}async createGrammar(e,t){let n=this._languageToScope.get(e);if(typeof n!="string")throw new Error(ir);let i=this._scopeRegistry.getGrammarDefinition(n);if(!i)throw new Error(ir);let s=i.embeddedLanguages;if(this._injectedEmbeddedLanguages[n]){let u=this._injectedEmbeddedLanguages[n];for(let d of u)for(let f of Object.keys(d))s[f]=d[f]}let a=Object.keys(s).length>0,l;try{l=await this._grammarRegistry.loadGrammarWithConfiguration(n,t,{embeddedLanguages:s,tokenTypes:i.tokenTypes,balancedBracketSelectors:i.balancedBracketSelectors,unbalancedBracketSelectors:i.unbalancedBracketSelectors})}catch(u){throw u.message&&u.message.startsWith("No grammar provided for")?new Error(ir):u}return{languageId:e,grammar:l,initialState:this._initialState,containsEmbeddedLanguages:a,sourceExtensionId:i.sourceExtensionId}}};var Gi=(function(){if(typeof crypto.randomUUID=="function")return crypto.randomUUID.bind(crypto);let r=new Uint8Array(16),e=[];for(let t=0;t<256;t++)e.push(t.toString(16).padStart(2,"0"));return function(){crypto.getRandomValues(r),r[6]=r[6]&15|64,r[8]=r[8]&63|128;let n=0,i="";return i+=e[r[n++]],i+=e[r[n++]],i+=e[r[n++]],i+=e[r[n++]],i+="-",i+=e[r[n++]],i+=e[r[n++]],i+="-",i+=e[r[n++]],i+=e[r[n++]],i+="-",i+=e[r[n++]],i+=e[r[n++]],i+="-",i+=e[r[n++]],i+=e[r[n++]],i+=e[r[n++]],i+=e[r[n++]],i+=e[r[n++]],i+=e[r[n++]],i}})();var Bs=!1,sr=class{constructor(e,t,n){this.id=e;this.dependencies=t;this.callback=n}};var ar=class r{constructor(){this._isWebWorker=typeof self=="object"&&self.constructor&&self.constructor.name==="DedicatedWorkerGlobalScope";this._isRenderer=typeof document=="object";this._defineCalls=[];this._state=1}static{this.INSTANCE=new r}_initialize(){if(this._state===1){if(globalThis.define){this._state=3;return}}else return;this._state=2,globalThis.define=(e,t,n)=>{typeof e!="string"&&(n=t,t=e,e=null),(typeof t!="object"||!Array.isArray(t))&&(n=t,t=null),this._defineCalls.push(new sr(e,t,n))},globalThis.define.amd=!0,this._isRenderer?this._amdPolicy=globalThis._VSCODE_WEB_PACKAGE_TTP??window.trustedTypes?.createPolicy("amdLoader",{createScriptURL(e){if(e.startsWith(window.location.origin)||e.startsWith(`${j.vscodeFileResource}://${rr}`))return e;throw new Error(`[trusted_script_src] Invalid script url: ${e}`)}}):this._isWebWorker&&(this._amdPolicy=globalThis._VSCODE_WEB_PACKAGE_TTP??globalThis.trustedTypes?.createPolicy("amdLoader",{createScriptURL(e){return e}}))}async load(e){if(this._initialize(),this._state===3)return new Promise(a=>{let l=Gi();globalThis.define(l,[e],function(u){a(u)})});let t=await(this._isWebWorker?this._workerLoadScript(e):this._isRenderer?this._rendererLoadScript(e):this._nodeJSLoadScript(e));if(!t){console.warn(`Did not receive a define call from script ${e}`);return}let n={},i=[],s=[];if(Array.isArray(t.dependencies))for(let a of t.dependencies)a==="exports"?i.push(n):s.push(a);if(s.length>0)throw new Error(`Cannot resolve dependencies for script ${e}. The dependencies are: ${s.join(", ")}`);return typeof t.callback=="function"?t.callback(...i)??n:t.callback}_rendererLoadScript(e){return new Promise((t,n)=>{let i=document.createElement("script");i.setAttribute("async","async"),i.setAttribute("type","text/javascript");let s=()=>{i.removeEventListener("load",a),i.removeEventListener("error",l)},a=u=>{s(),t(this._defineCalls.pop())},l=u=>{s(),n(u)};i.addEventListener("load",a),i.addEventListener("error",l),this._amdPolicy&&(e=this._amdPolicy.createScriptURL(e)),i.setAttribute("src",e),window.document.getElementsByTagName("head")[0].appendChild(i)})}async _workerLoadScript(e){return this._amdPolicy&&(e=this._amdPolicy.createScriptURL(e)),await import(e),this._defineCalls.pop()}async _nodeJSLoadScript(e){try{let t=(await import("fs")).default,n=(await import("vm")).default,i=(await import("module")).default,s=z.parse(e).fsPath,a=t.readFileSync(s).toString(),l=i.wrap(a.replace(/^#!.*/,""));return new n.Script(l).runInThisContext().apply(),this._defineCalls.pop()}catch(t){throw t}}},or=new Map;async function kt(r,e,t){t===void 0&&(t=!!(globalThis._VSCODE_PRODUCT_JSON??globalThis.vscode?.context?.configuration()?.product)?.commit);let n=e?`${r}/${e}`:r;if(or.has(n))return or.get(n);let i;if(/^\w[\w\d+.-]*:\/\//.test(n))i=n;else{let u=`${Bs&&t&&!ct?Ki:Wi}/${n}`;i=qi.asBrowserUri(u).toString(!0)}let s=ar.INSTANCE.load(i);return or.set(n,s),s}var Zt=class{constructor(e,t){this.timeoutToken=void 0,this.runner=e,this.timeout=t,this.timeoutHandler=this.onTimeout.bind(this)}dispose(){this.cancel(),this.runner=null}cancel(){this.isScheduled()&&(clearTimeout(this.timeoutToken),this.timeoutToken=void 0)}schedule(e=this.timeout){this.cancel(),this.timeoutToken=setTimeout(this.timeoutHandler,e)}get delay(){return this.timeout}set delay(e){this.timeout=e}isScheduled(){return this.timeoutToken!==void 0}flush(){this.isScheduled()&&(this.cancel(),this.doRun())}onTimeout(){this.timeoutToken=void 0,this.runner&&this.doRun()}doRun(){this.runner?.()}};var Zi,lr;(function(){let r=globalThis;typeof r.requestIdleCallback!="function"||typeof r.cancelIdleCallback!="function"?lr=(e,t,n)=>{ft(()=>{if(i)return;let s=Date.now()+15;t(Object.freeze({didTimeout:!0,timeRemaining(){return Math.max(0,s-Date.now())}}))});let i=!1;return{dispose(){i||(i=!0)}}}:lr=(e,t,n)=>{let i=e.requestIdleCallback(t,typeof n=="number"?{timeout:n}:void 0),s=!1;return{dispose(){s||(s=!0,e.cancelIdleCallback(i))}}},Zi=(e,t)=>lr(globalThis,e,t)})();var Jt=class r{static fromPromise(e){let t=new r;return t.settleWith(e),t}get isRejected(){return this.outcome?.outcome===1}get isResolved(){return this.outcome?.outcome===0}get isSettled(){return!!this.outcome}get value(){return this.outcome?.outcome===0?this.outcome?.value:void 0}constructor(){this.p=new Promise((e,t)=>{this.completeCallback=e,this.errorCallback=t})}complete(e){return this.isSettled?Promise.resolve():new Promise(t=>{this.completeCallback(e),this.outcome={outcome:0,value:e},t()})}error(e){return this.isSettled?Promise.resolve():new Promise(t=>{this.errorCallback(e),this.outcome={outcome:1,value:e},t()})}settleWith(e){return e.then(t=>this.complete(t),t=>this.error(t))}cancel(){return this.error(new Oe)}},zs;(t=>{async function r(n){let i,s=await Promise.all(n.map(a=>a.then(l=>l,l=>{i||(i=l)})));if(typeof i<"u")throw i;return s}t.settled=r;function e(n){return new Promise(async(i,s)=>{try{await n(i,s)}catch(a){s(a)}})}t.withAsyncBody=e})(zs||={});var Qi=class r{static fromArray(e){return new r(t=>{t.emitMany(e)})}static fromPromise(e){return new r(async t=>{t.emitMany(await e)})}static fromPromisesResolveOrder(e){return new r(async t=>{await Promise.all(e.map(async n=>t.emitOne(await n)))})}static merge(e){return new r(async t=>{await Promise.all(e.map(async n=>{for await(let i of n)t.emitOne(i)}))})}static{this.EMPTY=r.fromArray([])}constructor(e,t){this._state=0,this._results=[],this._error=null,this._onReturn=t,this._onStateChanged=new $,queueMicrotask(async()=>{let n={emitOne:i=>this.emitOne(i),emitMany:i=>this.emitMany(i),reject:i=>this.reject(i)};try{await Promise.resolve(e(n)),this.resolve()}catch(i){this.reject(i)}finally{n.emitOne=void 0,n.emitMany=void 0,n.reject=void 0}})}[Symbol.asyncIterator](){let e=0;return{next:async()=>{do{if(this._state===2)throw this._error;if(e<this._results.length)return{done:!1,value:this._results[e++]};if(this._state===1)return{done:!0,value:void 0};await Ke.toPromise(this._onStateChanged.event)}while(!0)},return:async()=>(this._onReturn?.(),{done:!0,value:void 0})}}static map(e,t){return new r(async n=>{for await(let i of e)n.emitOne(t(i))})}map(e){return r.map(this,e)}static filter(e,t){return new r(async n=>{for await(let i of e)t(i)&&n.emitOne(i)})}filter(e){return r.filter(this,e)}static coalesce(e){return r.filter(e,t=>!!t)}coalesce(){return r.coalesce(this)}static async toPromise(e){let t=[];for await(let n of e)t.push(n);return t}toPromise(){return r.toPromise(this)}emitOne(e){this._state===0&&(this._results.push(e),this._onStateChanged.fire())}emitMany(e){this._state===0&&(this._results=this._results.concat(e),this._onStateChanged.fire())}resolve(){this._state===0&&(this._state=1,this._onStateChanged.fire())}reject(e){this._state===0&&(this._state=2,this._error=e,this._onStateChanged.fire())}};var ur=class{constructor(){this._unsatisfiedConsumers=[];this._unconsumedValues=[]}get hasFinalValue(){return!!this._finalValue}produce(e){if(this._ensureNoFinalValue(),this._unsatisfiedConsumers.length>0){let t=this._unsatisfiedConsumers.shift();this._resolveOrRejectDeferred(t,e)}else this._unconsumedValues.push(e)}produceFinal(e){this._ensureNoFinalValue(),this._finalValue=e;for(let t of this._unsatisfiedConsumers)this._resolveOrRejectDeferred(t,e);this._unsatisfiedConsumers.length=0}_ensureNoFinalValue(){if(this._finalValue)throw new w("ProducerConsumer: cannot produce after final value has been set")}_resolveOrRejectDeferred(e,t){t.ok?e.complete(t.value):e.error(t.error)}consume(){if(this._unconsumedValues.length>0||this._finalValue){let e=this._unconsumedValues.length>0?this._unconsumedValues.shift():this._finalValue;return e.ok?Promise.resolve(e.value):Promise.reject(e.error)}else{let e=new Jt;return this._unsatisfiedConsumers.push(e),e.p}}},Yi=class r{constructor(e,t){this._onReturn=t;this._producerConsumer=new ur;this._iterator={next:()=>this._producerConsumer.consume(),return:()=>(this._onReturn?.(),Promise.resolve({done:!0,value:void 0})),throw:async e=>(this._finishError(e),{done:!0,value:void 0})};queueMicrotask(async()=>{let n=e({emitOne:i=>this._producerConsumer.produce({ok:!0,value:{done:!1,value:i}}),emitMany:i=>{for(let s of i)this._producerConsumer.produce({ok:!0,value:{done:!1,value:s}})},reject:i=>this._finishError(i)});if(!this._producerConsumer.hasFinalValue)try{await n,this._finishOk()}catch(i){this._finishError(i)}})}static fromArray(e){return new r(t=>{t.emitMany(e)})}static fromPromise(e){return new r(async t=>{t.emitMany(await e)})}static fromPromisesResolveOrder(e){return new r(async t=>{await Promise.all(e.map(async n=>t.emitOne(await n)))})}static merge(e){return new r(async t=>{await Promise.all(e.map(async n=>{for await(let i of n)t.emitOne(i)}))})}static{this.EMPTY=r.fromArray([])}static map(e,t){return new r(async n=>{for await(let i of e)n.emitOne(t(i))})}static tee(e){let t,n,i=new Jt,s=async()=>{if(!(!t||!n))try{for await(let u of e)t.emitOne(u),n.emitOne(u)}catch(u){t.reject(u),n.reject(u)}finally{i.complete()}},a=new r(async u=>(t=u,s(),i.p)),l=new r(async u=>(n=u,s(),i.p));return[a,l]}map(e){return r.map(this,e)}static coalesce(e){return r.filter(e,t=>!!t)}coalesce(){return r.coalesce(this)}static filter(e,t){return new r(async n=>{for await(let i of e)t(i)&&n.emitOne(i)})}filter(e){return r.filter(this,e)}_finishOk(){this._producerConsumer.hasFinalValue||this._producerConsumer.produceFinal({ok:!0,value:{done:!0,value:void 0}})}_finishError(e){this._producerConsumer.hasFinalValue||this._producerConsumer.produceFinal({ok:!1,error:e})}[Symbol.asyncIterator](){return this._iterator}};var Z=class{constructor(e,t,n){this.owner=e;this.debugNameSource=t;this.referenceFn=n}getDebugName(e){return to(e,this)}},Ji=new Map,dr=new WeakMap;function to(r,e){let t=dr.get(r);if(t)return t;let n=Ws(r,e);if(n){let i=Ji.get(n)??0;i++,Ji.set(n,i);let s=i===1?n:`${n}#${i}`;return dr.set(r,s),s}}function Ws(r,e){let t=dr.get(r);if(t)return t;let n=e.owner?qs(e.owner)+".":"",i,s=e.debugNameSource;if(s!==void 0)if(typeof s=="function"){if(i=s(),i!==void 0)return n+i}else return n+s;let a=e.referenceFn;if(a!==void 0&&(i=St(a),i!==void 0))return n+i;if(e.owner!==void 0){let l=Ks(e.owner,r);if(l!==void 0)return n+l}}function Ks(r,e){for(let t in r)if(r[t]===e)return t}var Xi=new Map,eo=new WeakMap;function qs(r){let e=eo.get(r);if(e)return e;let t=cr(r)??"Object",n=Xi.get(t)??0;n++,Xi.set(t,n);let i=n===1?t:`${t}#${n}`;return eo.set(r,i),i}function cr(r){let e=r.constructor;if(e)return e.name==="Object"?void 0:e.name}function St(r){let e=r.toString(),n=/\/\*\*\s*@description\s*([^*]*)\*\//.exec(e);return(n?n[1]:void 0)?.trim()}function ae(r,e){return r===e}function js(){return(r,e)=>r===e}function $s(r,e,t){return Un(r,e,t??ae)}function Hs(r){return(e,t)=>Un(e,t,r??ae)}function Xt(r,e){if(r===e)return!0;if(Array.isArray(r)&&Array.isArray(e)){if(r.length!==e.length)return!1;for(let t=0;t<r.length;t++)if(!Xt(r[t],e[t]))return!1;return!0}if(r&&typeof r=="object"&&e&&typeof e=="object"&&Object.getPrototypeOf(r)===Object.prototype&&Object.getPrototypeOf(e)===Object.prototype){let t=r,n=e,i=Object.keys(t),s=Object.keys(n),a=new Set(s);if(i.length!==s.length)return!1;for(let l of i)if(!a.has(l)||!Xt(t[l],n[l]))return!1;return!0}return!1}function Gs(){return(r,e)=>Xt(r,e)}function Qs(r,e){return JSON.stringify(r)===JSON.stringify(e)}function Ys(){return(r,e)=>JSON.stringify(r)===JSON.stringify(e)}function Zs(){return(r,e)=>r.equals(e)}function Js(r,e,t){return r==null||e===void 0||e===null?e===r:t(r,e)}function Xs(r){return(e,t)=>e==null||t===void 0||t===null?t===e:r(e,t)}var ea;(c=>(c.strict=ae,c.strictC=js,c.array=$s,c.arrayC=Hs,c.structural=Xt,c.structuralC=Gs,c.jsonStringify=Qs,c.jsonStringifyC=Ys,c.thisC=Zs,c.ifDefined=Js,c.ifDefinedC=Xs))(ea||={});function fr(r){let e=new Error("BugIndicatingErrorRecovery: "+r);W(e),console.error("recovered from an error that indicates a bug",e)}var je;function Et(r){je?je instanceof en?je.loggers.push(r):je=new en([je,r]):je=r}function N(){return je}var pr;function no(r){pr=r}function ro(r){pr&&pr(r)}var en=class{constructor(e){this.loggers=e}handleObservableCreated(e,t){for(let n of this.loggers)n.handleObservableCreated(e,t)}handleOnListenerCountChanged(e,t){for(let n of this.loggers)n.handleOnListenerCountChanged(e,t)}handleObservableUpdated(e,t){for(let n of this.loggers)n.handleObservableUpdated(e,t)}handleAutorunCreated(e,t){for(let n of this.loggers)n.handleAutorunCreated(e,t)}handleAutorunDisposed(e){for(let t of this.loggers)t.handleAutorunDisposed(e)}handleAutorunDependencyChanged(e,t,n){for(let i of this.loggers)i.handleAutorunDependencyChanged(e,t,n)}handleAutorunStarted(e){for(let t of this.loggers)t.handleAutorunStarted(e)}handleAutorunFinished(e){for(let t of this.loggers)t.handleAutorunFinished(e)}handleDerivedDependencyChanged(e,t,n){for(let i of this.loggers)i.handleDerivedDependencyChanged(e,t,n)}handleDerivedCleared(e){for(let t of this.loggers)t.handleDerivedCleared(e)}handleBeginTransaction(e){for(let t of this.loggers)t.handleBeginTransaction(e)}handleEndTransaction(e){for(let t of this.loggers)t.handleEndTransaction(e)}};function it(r,e){let t=new $e(r,e);try{r(t)}finally{t.finish()}}function mr(r,e,t){r?e(r):it(e,t)}var $e=class{constructor(e,t){this._fn=e;this._getDebugName=t;this._updatingObservers=[];N()?.handleBeginTransaction(this)}getDebugName(){return this._getDebugName?this._getDebugName():St(this._fn)}updateObserver(e,t){if(!this._updatingObservers){fr("Transaction already finished!"),it(n=>{n.updateObserver(e,t)});return}this._updatingObservers.push({observer:e,observable:t}),e.beginUpdate(t)}finish(){let e=this._updatingObservers;if(!e){fr("transaction.finish() has already been called!");return}for(let t=0;t<e.length;t++){let{observer:n,observable:i}=e[t];n.endUpdate(i)}this._updatingObservers=null,N()?.handleEndTransaction(this)}debugGetUpdatingObservers(){return this._updatingObservers}};var H;(n=>{let r=!1;function e(){r=!0}n.enable=e;function t(){if(!r)return;let i=Error,s=i.stackTraceLimit;i.stackTraceLimit=3;let a=new Error().stack;return i.stackTraceLimit=s,br.fromStack(a,2)}n.ofCaller=t})(H||={});var br=class r{constructor(e,t,n,i){this.fileName=e;this.line=t;this.column=n;this.id=i}static fromStack(e,t){let n=e.split(`
`),i=ta(n[t+1]);if(i)return new r(i.fileName,i.line,i.column,i.id)}};function ta(r){let e=r.match(/\((.*):(\d+):(\d+)\)/);if(e)return{fileName:e[1],line:parseInt(e[2]),column:parseInt(e[3]),id:r};let t=r.match(/at ([^\(\)]*):(\d+):(\d+)/);if(t)return{fileName:t[1],line:parseInt(t[2]),column:parseInt(t[3]),id:r}}var hr;function io(r){hr=r}var oo;function so(r){oo=r}var ao;function lo(r){ao=r}var gr;function uo(r){gr=r}var tn=class{get TChange(){return null}reportChanges(){this.get()}read(e){return e?e.readObservable(this):this.get()}map(e,t,n=H.ofCaller()){let i=t===void 0?void 0:e,s=t===void 0?e:t;return hr({owner:i,debugName:()=>{let a=St(s);if(a!==void 0)return a;let u=/^\s*\(?\s*([a-zA-Z_$][a-zA-Z_$0-9]*)\s*\)?\s*=>\s*\1(?:\??)\.([a-zA-Z_$][a-zA-Z_$0-9]*)\s*$/.exec(s.toString());if(u)return`${this.debugName}.${u[2]}`;if(!i)return`${this.debugName} (mapped)`},debugReferenceFn:s},a=>s(this.read(a),a),n)}flatten(){return hr({owner:void 0,debugName:()=>`${this.debugName} (flattened)`},e=>this.read(e).read(e))}recomputeInitiallyAndOnChange(e,t){return e.add(oo(this,t)),this}keepObserved(e){return e.add(ao(this)),this}get debugValue(){return this.get()}get debug(){return new vr(this)}},vr=class{constructor(e){this.observable=e}getDependencyGraph(){return gr(this.observable,{type:"dependencies"})}getObserverGraph(){return gr(this.observable,{type:"observers"})}},pe=class extends tn{constructor(t){super();this._observers=new Set;N()?.handleObservableCreated(this,t)}addObserver(t){let n=this._observers.size;this._observers.add(t),n===0&&this.onFirstObserverAdded(),n!==this._observers.size&&N()?.handleOnListenerCountChanged(this,this._observers.size)}removeObserver(t){let n=this._observers.delete(t);n&&this._observers.size===0&&this.onLastObserverRemoved(),n&&N()?.handleOnListenerCountChanged(this,this._observers.size)}onFirstObserverAdded(){}onLastObserverRemoved(){}log(){let t=!!N();return ro(this),t||N()?.handleObservableCreated(this,H.ofCaller()),this}debugGetObservers(){return this._observers}};function wt(r,e,t=H.ofCaller()){let n;return typeof r=="string"?n=new Z(void 0,r,void 0):n=new Z(r,void 0,void 0),new Se(n,e,ae,t)}var Se=class extends pe{constructor(t,n,i,s){super(s);this._debugNameData=t;this._equalityComparator=i;this._value=n,N()?.handleObservableUpdated(this,{hadValue:!1,newValue:n,change:void 0,didChange:!0,oldValue:void 0})}get debugName(){return this._debugNameData.getDebugName(this)??"ObservableValue"}get(){return this._value}set(t,n,i){if(i===void 0&&this._equalityComparator(this._value,t))return;let s;n||(n=s=new $e(()=>{},()=>`Setting ${this.debugName}`));try{let a=this._value;this._setValue(t),N()?.handleObservableUpdated(this,{oldValue:a,newValue:t,change:i,didChange:!0,hadValue:!0});for(let l of this._observers)n.updateObserver(l,this),l.handleChange(this,i)}finally{s&&s.finish()}}toString(){return`${this.debugName}: ${this._value}`}_setValue(t){this._value=t}debugGetState(){return{value:this._value}}debugSetValue(t){this._value=t}};function na(r){switch(r){case 1:return"dependenciesMightHaveChanged";case 2:return"stale";case 3:return"upToDate";default:return"<unknown>"}}var Pe=class{constructor(e,t,n,i){this._debugNameData=e;this._runFn=t;this._changeTracker=n;this._state=2;this._updateCount=0;this._disposed=!1;this._dependencies=new Set;this._dependenciesToBeRemoved=new Set;this._isRunning=!1;this._iteration=0;this._store=void 0;this._delayedStore=void 0;this._changeSummary=this._changeTracker?.createChangeSummary(void 0),N()?.handleAutorunCreated(this,i),this._run(),tt(this)}get debugName(){return this._debugNameData.getDebugName(this)??"(anonymous)"}dispose(){if(!this._disposed){this._disposed=!0;for(let e of this._dependencies)e.removeObserver(this);this._dependencies.clear(),this._store!==void 0&&this._store.dispose(),this._delayedStore!==void 0&&this._delayedStore.dispose(),N()?.handleAutorunDisposed(this),nt(this)}}_run(){let e=this._dependenciesToBeRemoved;this._dependenciesToBeRemoved=this._dependencies,this._dependencies=e,this._state=3;try{if(!this._disposed){N()?.handleAutorunStarted(this);let t=this._changeSummary,n=this._delayedStore;n!==void 0&&(this._delayedStore=void 0);try{this._isRunning=!0,this._changeTracker&&(this._changeTracker.beforeUpdate?.(this,t),this._changeSummary=this._changeTracker.createChangeSummary(t)),this._store!==void 0&&(this._store.dispose(),this._store=void 0),this._runFn(this,t)}catch(i){De(i)}finally{this._isRunning=!1,n!==void 0&&n.dispose()}}}finally{this._disposed||N()?.handleAutorunFinished(this);for(let t of this._dependenciesToBeRemoved)t.removeObserver(this);this._dependenciesToBeRemoved.clear()}}toString(){return`Autorun<${this.debugName}>`}beginUpdate(e){this._state===3&&(this._checkIterations(),this._state=1),this._updateCount++}endUpdate(e){try{if(this._updateCount===1){this._iteration=1;do{if(this._checkIterations())return;if(this._state===1){this._state=3;for(let t of this._dependencies)if(t.reportChanges(),this._state===2)break}this._iteration++,this._state!==3&&this._run()}while(this._state!==3)}}finally{this._updateCount--}yt(()=>this._updateCount>=0)}handlePossibleChange(e){this._state===3&&this._isDependency(e)&&(this._checkIterations(),this._state=1)}handleChange(e,t){if(this._isDependency(e)){N()?.handleAutorunDependencyChanged(this,e,t);try{(!this._changeTracker||this._changeTracker.handleChange({changedObservable:e,change:t,didChange:i=>i===e},this._changeSummary))&&(this._checkIterations(),this._state=2)}catch(n){De(n)}}}_isDependency(e){return this._dependencies.has(e)&&!this._dependenciesToBeRemoved.has(e)}_ensureNoRunning(){if(!this._isRunning)throw new w("The reader object cannot be used outside its compute function!")}readObservable(e){if(this._ensureNoRunning(),this._disposed)return e.get();e.addObserver(this);let t=e.get();return this._dependencies.add(e),this._dependenciesToBeRemoved.delete(e),t}get store(){if(this._ensureNoRunning(),this._disposed)throw new w("Cannot access store after dispose");return this._store===void 0&&(this._store=new q),this._store}get delayedStore(){if(this._ensureNoRunning(),this._disposed)throw new w("Cannot access store after dispose");return this._delayedStore===void 0&&(this._delayedStore=new q),this._delayedStore}debugGetState(){return{isRunning:this._isRunning,updateCount:this._updateCount,dependencies:this._dependencies,state:this._state,stateStr:na(this._state)}}debugRerun(){this._isRunning?this._state=2:this._run()}_checkIterations(){return this._iteration>100?(De(new w(`Autorun '${this.debugName}' is stuck in an infinite update loop.`)),!0):!1}};function ra(r){switch(r){case 0:return"initial";case 1:return"dependenciesMightHaveChanged";case 2:return"stale";case 3:return"upToDate";default:return"<unknown>"}}var Q=class extends pe{constructor(t,n,i,s=void 0,a,l){super(l);this._debugNameData=t;this._computeFn=n;this._changeTracker=i;this._handleLastObserverRemoved=s;this._equalityComparator=a;this._state=0;this._value=void 0;this._updateCount=0;this._dependencies=new Set;this._dependenciesToBeRemoved=new Set;this._changeSummary=void 0;this._isUpdating=!1;this._isComputing=!1;this._didReportChange=!1;this._isInBeforeUpdate=!1;this._isReaderValid=!1;this._store=void 0;this._delayedStore=void 0;this._removedObserverToCallEndUpdateOn=null;this._changeSummary=this._changeTracker?.createChangeSummary(void 0)}get debugName(){return this._debugNameData.getDebugName(this)??"(anonymous)"}onLastObserverRemoved(){this._state=0,this._value=void 0,N()?.handleDerivedCleared(this);for(let t of this._dependencies)t.removeObserver(this);this._dependencies.clear(),this._store!==void 0&&(this._store.dispose(),this._store=void 0),this._delayedStore!==void 0&&(this._delayedStore.dispose(),this._delayedStore=void 0),this._handleLastObserverRemoved?.()}get(){if(this._isComputing,this._observers.size===0){let n;try{this._isReaderValid=!0;let i;this._changeTracker&&(i=this._changeTracker.createChangeSummary(void 0),this._changeTracker.beforeUpdate?.(this,i)),n=this._computeFn(this,i)}finally{this._isReaderValid=!1}return this.onLastObserverRemoved(),n}else{do{if(this._state===1){for(let n of this._dependencies)if(n.reportChanges(),this._state===2)break}this._state===1&&(this._state=3),this._state!==3&&this._recompute()}while(this._state!==3);return this._value}}_recompute(){let t=!1;this._isComputing=!0,this._didReportChange=!1;let n=this._dependenciesToBeRemoved;this._dependenciesToBeRemoved=this._dependencies,this._dependencies=n;try{let i=this._changeSummary;this._isReaderValid=!0,this._changeTracker&&(this._isInBeforeUpdate=!0,this._changeTracker.beforeUpdate?.(this,i),this._isInBeforeUpdate=!1,this._changeSummary=this._changeTracker?.createChangeSummary(i));let s=this._state!==0,a=this._value;this._state=3;let l=this._delayedStore;l!==void 0&&(this._delayedStore=void 0);try{this._store!==void 0&&(this._store.dispose(),this._store=void 0),this._value=this._computeFn(this,i)}finally{this._isReaderValid=!1;for(let u of this._dependenciesToBeRemoved)u.removeObserver(this);this._dependenciesToBeRemoved.clear(),l!==void 0&&l.dispose()}t=this._didReportChange||s&&!this._equalityComparator(a,this._value),N()?.handleObservableUpdated(this,{oldValue:a,newValue:this._value,change:void 0,didChange:t,hadValue:s})}catch(i){De(i)}if(this._isComputing=!1,!this._didReportChange&&t)for(let i of this._observers)i.handleChange(this,void 0);else this._didReportChange=!1}toString(){return`LazyDerived<${this.debugName}>`}beginUpdate(t){if(this._isUpdating)throw new w("Cyclic deriveds are not supported yet!");this._updateCount++,this._isUpdating=!0;try{let n=this._updateCount===1;if(this._state===3&&(this._state=1,!n))for(let i of this._observers)i.handlePossibleChange(this);if(n)for(let i of this._observers)i.beginUpdate(this)}finally{this._isUpdating=!1}}endUpdate(t){if(this._updateCount--,this._updateCount===0){let n=[...this._observers];for(let i of n)i.endUpdate(this);if(this._removedObserverToCallEndUpdateOn){let i=[...this._removedObserverToCallEndUpdateOn];this._removedObserverToCallEndUpdateOn=null;for(let s of i)s.endUpdate(this)}}yt(()=>this._updateCount>=0)}handlePossibleChange(t){if(this._state===3&&this._dependencies.has(t)&&!this._dependenciesToBeRemoved.has(t)){this._state=1;for(let n of this._observers)n.handlePossibleChange(this)}}handleChange(t,n){if(this._dependencies.has(t)&&!this._dependenciesToBeRemoved.has(t)||this._isInBeforeUpdate){N()?.handleDerivedDependencyChanged(this,t,n);let i=!1;try{i=this._changeTracker?this._changeTracker.handleChange({changedObservable:t,change:n,didChange:a=>a===t},this._changeSummary):!0}catch(a){De(a)}let s=this._state===3;if(i&&(this._state===1||s)&&(this._state=2,s))for(let a of this._observers)a.handlePossibleChange(this)}}_ensureReaderValid(){if(!this._isReaderValid)throw new w("The reader object cannot be used outside its compute function!")}readObservable(t){this._ensureReaderValid(),t.addObserver(this);let n=t.get();return this._dependencies.add(t),this._dependenciesToBeRemoved.delete(t),n}reportChange(t){this._ensureReaderValid(),this._didReportChange=!0;for(let n of this._observers)n.handleChange(this,t)}get store(){return this._ensureReaderValid(),this._store===void 0&&(this._store=new q),this._store}get delayedStore(){return this._ensureReaderValid(),this._delayedStore===void 0&&(this._delayedStore=new q),this._delayedStore}addObserver(t){let n=!this._observers.has(t)&&this._updateCount>0;super.addObserver(t),n&&(this._removedObserverToCallEndUpdateOn?.delete(t)||t.beginUpdate(this))}removeObserver(t){this._observers.has(t)&&this._updateCount>0&&(this._removedObserverToCallEndUpdateOn||(this._removedObserverToCallEndUpdateOn=new Set),this._removedObserverToCallEndUpdateOn.add(t)),super.removeObserver(t)}debugGetState(){return{state:this._state,stateStr:ra(this._state),updateCount:this._updateCount,isComputing:this._isComputing,dependencies:this._dependencies,value:this._value}}debugSetValue(t){this._value=t}debugRecompute(){this.beginUpdate(this);try{this._isComputing?this._state=2:this._recompute()}finally{this.endUpdate(this)}}setValue(t,n,i){this._value=t;let s=this._observers;n.updateObserver(this,this);for(let a of s)a.handleChange(this,i)}};function Tr(r,e,t=H.ofCaller()){return new Q(new Z(r.owner,r.debugName,r.debugReferenceFn),e,void 0,r.onLastObserverRemoved,r.equalsFn??ae,t)}io(Tr);function ot(...r){let e,t,n,i;return r.length===2?[t,n]=r:[e,t,n,i]=r,new le(new Z(e,void 0,n),t,n,()=>le.globalTransaction,ae,i??H.ofCaller())}var le=class extends pe{constructor(t,n,i,s,a,l){super(l);this._debugNameData=t;this.event=n;this._getValue=i;this._getTransaction=s;this._equalityComparator=a;this._hasValue=!1;this.handleEvent=t=>{let n=this._getValue(t),i=this._value,s=!this._hasValue||!this._equalityComparator(i,n),a=!1;s&&(this._value=n,this._hasValue&&(a=!0,mr(this._getTransaction(),l=>{N()?.handleObservableUpdated(this,{oldValue:i,newValue:n,change:void 0,didChange:s,hadValue:this._hasValue});for(let u of this._observers)l.updateObserver(u,this),u.handleChange(this,void 0)},()=>{let l=this.getDebugName();return"Event fired"+(l?`: ${l}`:"")})),this._hasValue=!0),a||N()?.handleObservableUpdated(this,{oldValue:i,newValue:n,change:void 0,didChange:s,hadValue:this._hasValue})}}getDebugName(){return this._debugNameData.getDebugName(this)}get debugName(){let t=this.getDebugName();return"From Event"+(t?`: ${t}`:"")}onFirstObserverAdded(){this._subscription=this.event(this.handleEvent)}onLastObserverRemoved(){this._subscription.dispose(),this._subscription=void 0,this._hasValue=!1,this._value=void 0}get(){return this._subscription?(this._hasValue||this.handleEvent(void 0),this._value):this._getValue(void 0)}debugSetValue(t){this._value=t}debugGetState(){return{value:this._value,hasValue:this._hasValue}}};(t=>{t.Observer=le;function e(n,i){let s=!1;le.globalTransaction===void 0&&(le.globalTransaction=n,s=!0);try{i()}finally{s&&(le.globalTransaction=void 0)}}t.batchEventsGlobally=e})(ot||={});function rn(r){let e=new nn(!1,void 0);return r.addObserver(e),ie(()=>{r.removeObserver(e)})}lo(rn);function po(r,e){let t=new nn(!0,e);r.addObserver(t);try{t.beginUpdate(r)}finally{t.endUpdate(r)}return ie(()=>{r.removeObserver(t)})}so(po);var nn=class{constructor(e,t){this._forceRecompute=e;this._handleValue=t;this._counter=0}beginUpdate(e){this._counter++}endUpdate(e){this._counter===1&&this._forceRecompute&&(this._handleValue?this._handleValue(e.get()):e.reportChanges()),this._counter--}handlePossibleChange(e){}handleChange(e,t){}};var on;function bo(r){on||(on=new Rt,Et(on)),on.addFilteredObj(r)}var Rt=class{constructor(){this.indentation=0;this.changedObservablesSets=new WeakMap}addFilteredObj(e){this._filteredObjects||(this._filteredObjects=new Set),this._filteredObjects.add(e)}_isIncluded(e){return this._filteredObjects?.has(e)??!0}textToConsoleArgs(e){return ua([st(fa("|  ",this.indentation)),e])}formatInfo(e){return e.hadValue?e.didChange?[st(" "),ue(oe(e.oldValue,70),{color:"red",strikeThrough:!0}),st(" "),ue(oe(e.newValue,60),{color:"green"})]:[st(" (unchanged)")]:[st(" "),ue(oe(e.newValue,60),{color:"green"}),st(" (initial)")]}handleObservableCreated(e){if(e instanceof Q){let t=e;if(this.changedObservablesSets.set(t,new Set),!1){let i=[];t.__debugUpdating=i;let s=t.beginUpdate;t.beginUpdate=l=>(i.push(l),s.apply(t,[l]));let a=t.endUpdate;t.endUpdate=l=>{let u=i.indexOf(l);return u===-1&&console.error("endUpdate called without beginUpdate",t.debugName,l.debugName),i.splice(u,1),a.apply(t,[l])}}}}handleOnListenerCountChanged(e,t){}handleObservableUpdated(e,t){if(this._isIncluded(e)){if(e instanceof Q){this._handleDerivedRecomputed(e,t);return}console.log(...this.textToConsoleArgs([at("observable value changed"),ue(e.debugName,{color:"BlueViolet"}),...this.formatInfo(t)]))}}formatChanges(e){if(e.size!==0)return ue(" (changed deps: "+[...e].map(t=>t.debugName).join(", ")+")",{color:"gray"})}handleDerivedDependencyChanged(e,t,n){this._isIncluded(e)&&this.changedObservablesSets.get(e)?.add(t)}_handleDerivedRecomputed(e,t){if(!this._isIncluded(e))return;let n=this.changedObservablesSets.get(e);n&&(console.log(...this.textToConsoleArgs([at("derived recomputed"),ue(e.debugName,{color:"BlueViolet"}),...this.formatInfo(t),this.formatChanges(n),{data:[{fn:e._debugNameData.referenceFn??e._computeFn}]}])),n.clear())}handleDerivedCleared(e){this._isIncluded(e)&&console.log(...this.textToConsoleArgs([at("derived cleared"),ue(e.debugName,{color:"BlueViolet"})]))}handleFromEventObservableTriggered(e,t){this._isIncluded(e)&&console.log(...this.textToConsoleArgs([at("observable from event triggered"),ue(e.debugName,{color:"BlueViolet"}),...this.formatInfo(t),{data:[{fn:e._getValue}]}]))}handleAutorunCreated(e){this._isIncluded(e)&&this.changedObservablesSets.set(e,new Set)}handleAutorunDisposed(e){}handleAutorunDependencyChanged(e,t,n){this._isIncluded(e)&&this.changedObservablesSets.get(e).add(t)}handleAutorunStarted(e){let t=this.changedObservablesSets.get(e);t&&(this._isIncluded(e)&&console.log(...this.textToConsoleArgs([at("autorun"),ue(e.debugName,{color:"BlueViolet"}),this.formatChanges(t),{data:[{fn:e._debugNameData.referenceFn??e._runFn}]}])),t.clear(),this.indentation++)}handleAutorunFinished(e){this.indentation--}handleBeginTransaction(e){let t=e.getDebugName();t===void 0&&(t=""),this._isIncluded(e)&&console.log(...this.textToConsoleArgs([at("transaction"),ue(t,{color:"BlueViolet"}),{data:[{fn:e._fn}]}])),this.indentation++}handleEndTransaction(){this.indentation--}};function ua(r){let e=new Array,t=[],n="";function i(a){if("length"in a)for(let l of a)l&&i(l);else"text"in a?(n+=`%c${a.text}`,e.push(a.style),a.data&&t.push(...a.data)):"data"in a&&t.push(...a.data)}i(r);let s=[n,...e];return s.push(...t),s}function st(r){return ue(r,{color:"black"})}function at(r){return ue(pa(`${r}: `,10),{color:"black",bold:!0})}function ue(r,e={color:"black"}){function t(i){return Object.entries(i).reduce((s,[a,l])=>`${s}${a}:${l};`,"")}let n={color:e.color};return e.strikeThrough&&(n["text-decoration"]="line-through"),e.bold&&(n["font-weight"]="bold"),{text:r,style:t(n)}}function oe(r,e){switch(typeof r){case"number":return""+r;case"string":return r.length+2<=e?`"${r}"`:`"${r.substr(0,e-7)}"+...`;case"boolean":return r?"true":"false";case"undefined":return"undefined";case"object":return r===null?"null":Array.isArray(r)?da(r,e):ca(r,e);case"symbol":return r.toString();case"function":return`[[Function${r.name?" "+r.name:""}]]`;default:return""+r}}function da(r,e){let t="[ ",n=!0;for(let i of r){if(n||(t+=", "),t.length-5>e){t+="...";break}n=!1,t+=`${oe(i,e-t.length)}`}return t+=" ]",t}function ca(r,e){if(typeof r.toString=="function"&&r.toString!==Object.prototype.toString){let s=r.toString();return s.length<=e?s:s.substring(0,e-3)+"..."}let t=cr(r),n=t?t+"(":"{ ",i=!0;for(let[s,a]of Object.entries(r)){if(i||(n+=", "),n.length-5>e){n+="...";break}i=!1,n+=`${s}: ${oe(a,e-n.length)}`}return n+=t?")":" }",n}function fa(r,e){let t="";for(let n=1;n<=e;n++)t+=r;return t}function pa(r,e){for(;r.length<e;)r+=" ";return r}var sn=class r{constructor(e,t){this._channelFactory=e;this._getHandler=t;this._channel=this._channelFactory({handleNotification:s=>{let a=s,l=this._getHandler().notifications[a[0]];if(!l)throw new Error(`Unknown notification "${a[0]}"!`);l(...a[1])},handleRequest:s=>{let a=s;try{return{type:"result",value:this._getHandler().requests[a[0]](...a[1])}}catch(l){return{type:"error",value:l}}}});let n=new Proxy({},{get:(s,a)=>async(...l)=>{let u=await this._channel.sendRequest([a,l]);if(u.type==="error")throw u.value;return u.value}}),i=new Proxy({},{get:(s,a)=>(...l)=>{this._channel.sendNotification([a,l])}});this.api={notifications:i,requests:n}}static createHost(e,t){return new r(e,t)}static createClient(e,t){return new r(e,t)}};function ho(r,e){let t=globalThis,n=[],i,{channel:s,handler:a}=ma({sendNotification:u=>{i?i.sendNotification(u):n.push(u)}}),l;return(t.$$debugValueEditor_debugChannels??(t.$$debugValueEditor_debugChannels={}))[r]=u=>{l=e(),i=u;for(let d of n)u.sendNotification(d);return n=[],a},sn.createClient(s,()=>{if(!l)throw new Error("Not supported");return l})}function ma(r){let e;return{channel:n=>(e=n,{sendNotification:i=>{r.sendNotification(i)},sendRequest:i=>{throw new Error("not supported")}}),handler:{handleRequest:n=>n.type==="notification"?e?.handleNotification(n.data):e?.handleRequest(n.data)}}}var an=class{constructor(){this._timeout=void 0}throttle(e,t){this._timeout===void 0&&(this._timeout=setTimeout(()=>{this._timeout=void 0,e()},t))}dispose(){this._timeout!==void 0&&clearTimeout(this._timeout)}};function xr(r,e){for(let t in e)r[t]&&typeof r[t]=="object"&&e[t]&&typeof e[t]=="object"?xr(r[t],e[t]):r[t]=e[t]}function yr(r,e){for(let t in e)e[t]===null?delete r[t]:r[t]&&typeof r[t]=="object"&&e[t]&&typeof e[t]=="object"?yr(r[t],e[t]):r[t]=e[t]}var ln=class r{constructor(){this._declarationId=0;this._instanceId=0;this._declarations=new Map;this._instanceInfos=new WeakMap;this._aliveInstances=new Map;this._activeTransactions=new Set;this._channel=ho("observableDevTools",()=>({notifications:{setDeclarationIdFilter:e=>{},logObservableValue:e=>{console.log("logObservableValue",e)},flushUpdates:()=>{this._flushUpdates()},resetUpdates:()=>{this._pendingChanges=null,this._channel.api.notifications.handleChange(this._fullState,!0)}},requests:{getDeclarations:()=>{let e={};for(let t of this._declarations.values())e[t.id]=t;return{decls:e}},getSummarizedInstances:()=>null,getObservableValueInfo:e=>({observers:[...this._aliveInstances.get(e).debugGetObservers()].map(n=>this._formatObserver(n)).filter(Xe)}),getDerivedInfo:e=>{let t=this._aliveInstances.get(e);return{dependencies:[...t.debugGetState().dependencies].map(n=>this._formatObservable(n)).filter(Xe),observers:[...t.debugGetObservers()].map(n=>this._formatObserver(n)).filter(Xe)}},getAutorunInfo:e=>({dependencies:[...this._aliveInstances.get(e).debugGetState().dependencies].map(n=>this._formatObservable(n)).filter(Xe)}),getTransactionState:()=>this.getTransactionState(),setValue:(e,t)=>{let n=this._aliveInstances.get(e);if(n instanceof Q)n.debugSetValue(t);else if(n instanceof Se)n.debugSetValue(t);else if(n instanceof le)n.debugSetValue(t);else throw new w("Observable is not supported");let i=[...n.debugGetObservers()];for(let s of i)s.beginUpdate(n);for(let s of i)s.handleChange(n,void 0);for(let s of i)s.endUpdate(n)},getValue:e=>{let t=this._aliveInstances.get(e);if(t instanceof Q)return oe(t.debugGetState().value,200);if(t instanceof Se)return oe(t.debugGetState().value,200)},logValue:e=>{let t=this._aliveInstances.get(e);if(t&&"get"in t)console.log("Logged Value:",t.get());else throw new w("Observable is not supported")},rerun:e=>{let t=this._aliveInstances.get(e);if(t instanceof Q)t.debugRecompute();else if(t instanceof Pe)t.debugRerun();else throw new w("Observable is not supported")}}}));this._pendingChanges=null;this._changeThrottler=new an;this._fullState={};this._flushUpdates=()=>{this._pendingChanges!==null&&(this._channel.api.notifications.handleChange(this._pendingChanges,!1),this._pendingChanges=null)};H.enable()}static{this._instance=void 0}static getInstance(){return r._instance===void 0&&(r._instance=new r),r._instance}getTransactionState(){let e=[],t=[...this._activeTransactions];if(t.length===0)return;let n=t.flatMap(s=>s.debugGetUpdatingObservers()??[]).map(s=>s.observer),i=new Set;for(;n.length>0;){let s=n.shift();if(i.has(s))continue;i.add(s);let a=this._getInfo(s,l=>{i.has(l)||n.push(l)});a&&e.push(a)}return{names:t.map(s=>s.getDebugName()??"tx"),affected:e}}_getObservableInfo(e){let t=this._instanceInfos.get(e);if(!t){W(new w("No info found"));return}return t}_getAutorunInfo(e){let t=this._instanceInfos.get(e);if(!t){W(new w("No info found"));return}return t}_getInfo(e,t){if(e instanceof Q){let n=[...e.debugGetObservers()];for(let u of n)t(u);let i=this._getObservableInfo(e);if(!i)return;let s=e.debugGetState(),a={name:e.debugName,instanceId:i.instanceId,updateCount:s.updateCount},l=[...i.changedObservables].map(u=>this._instanceInfos.get(u)?.instanceId).filter(Xe);if(s.isComputing)return{...a,type:"observable/derived",state:"updating",changedDependencies:l,initialComputation:!1};switch(s.state){case 0:return{...a,type:"observable/derived",state:"noValue"};case 3:return{...a,type:"observable/derived",state:"upToDate"};case 2:return{...a,type:"observable/derived",state:"stale",changedDependencies:l};case 1:return{...a,type:"observable/derived",state:"possiblyStale"}}}else if(e instanceof Pe){let n=this._getAutorunInfo(e);if(!n)return;let i={name:e.debugName,instanceId:n.instanceId,updateCount:n.updateCount},s=[...n.changedObservables].map(a=>this._instanceInfos.get(a).instanceId);if(e.debugGetState().isRunning)return{...i,type:"autorun",state:"updating",changedDependencies:s};switch(e.debugGetState().state){case 3:return{...i,type:"autorun",state:"upToDate"};case 2:return{...i,type:"autorun",state:"stale",changedDependencies:s};case 1:return{...i,type:"autorun",state:"possiblyStale"}}}}_formatObservable(e){let t=this._getObservableInfo(e);if(t)return{name:e.debugName,instanceId:t.instanceId}}_formatObserver(e){if(e instanceof Q)return{name:e.toString(),instanceId:this._getObservableInfo(e)?.instanceId};let t=this._getAutorunInfo(e);if(t)return{name:e.toString(),instanceId:t.instanceId}}_handleChange(e){yr(this._fullState,e),this._pendingChanges===null?this._pendingChanges=e:xr(this._pendingChanges,e),this._changeThrottler.throttle(this._flushUpdates,10)}_getDeclarationId(e,t){if(!t)return-1;let n=this._declarations.get(t.id);return n===void 0&&(n={id:this._declarationId++,type:e,url:t.fileName,line:t.line,column:t.column},this._declarations.set(t.id,n),this._handleChange({decls:{[n.id]:n}})),n.id}handleObservableCreated(e,t){let i={declarationId:this._getDeclarationId("observable/value",t),instanceId:this._instanceId++,listenerCount:0,lastValue:void 0,updateCount:0,changedObservables:new Set};this._instanceInfos.set(e,i)}handleOnListenerCountChanged(e,t){let n=this._getObservableInfo(e);if(n){if(n.listenerCount===0&&t>0){let i=e instanceof Q?"observable/derived":"observable/value";this._aliveInstances.set(n.instanceId,e),this._handleChange({instances:{[n.instanceId]:{instanceId:n.instanceId,declarationId:n.declarationId,formattedValue:n.lastValue,type:i,name:e.debugName}}})}else n.listenerCount>0&&t===0&&(this._handleChange({instances:{[n.instanceId]:null}}),this._aliveInstances.delete(n.instanceId));n.listenerCount=t}}handleObservableUpdated(e,t){if(e instanceof Q){this._handleDerivedRecomputed(e,t);return}let n=this._getObservableInfo(e);n&&t.didChange&&(n.lastValue=oe(t.newValue,30),n.listenerCount>0&&this._handleChange({instances:{[n.instanceId]:{formattedValue:n.lastValue}}}))}handleAutorunCreated(e,t){let i={declarationId:this._getDeclarationId("autorun",t),instanceId:this._instanceId++,updateCount:0,changedObservables:new Set};this._instanceInfos.set(e,i),this._aliveInstances.set(i.instanceId,e),i&&this._handleChange({instances:{[i.instanceId]:{instanceId:i.instanceId,declarationId:i.declarationId,runCount:0,type:"autorun",name:e.debugName}}})}handleAutorunDisposed(e){let t=this._getAutorunInfo(e);t&&(this._handleChange({instances:{[t.instanceId]:null}}),this._instanceInfos.delete(e),this._aliveInstances.delete(t.instanceId))}handleAutorunDependencyChanged(e,t,n){let i=this._getAutorunInfo(e);i&&i.changedObservables.add(t)}handleAutorunStarted(e){}handleAutorunFinished(e){let t=this._getAutorunInfo(e);t&&(t.changedObservables.clear(),t.updateCount++,this._handleChange({instances:{[t.instanceId]:{runCount:t.updateCount}}}))}handleDerivedDependencyChanged(e,t,n){let i=this._getObservableInfo(e);i&&i.changedObservables.add(t)}_handleDerivedRecomputed(e,t){let n=this._getObservableInfo(e);if(!n)return;let i=oe(t.newValue,30);n.updateCount++,n.changedObservables.clear(),n.lastValue=i,n.listenerCount>0&&this._handleChange({instances:{[n.instanceId]:{formattedValue:i,recomputationCount:n.updateCount}}})}handleDerivedCleared(e){let t=this._getObservableInfo(e);t&&(t.lastValue=void 0,t.changedObservables.clear(),t.listenerCount>0&&this._handleChange({instances:{[t.instanceId]:{formattedValue:void 0}}}))}handleBeginTransaction(e){this._activeTransactions.add(e)}handleEndTransaction(e){this._activeTransactions.delete(e)}};function go(r,e){let t=e?.debugNamePostProcessor??(s=>s),n=He.from(r,t);if(!n)return"";let i=new Set;return e.type==="observers"?To(n,0,i,e).trim():vo(n,0,i,e).trim()}function vo(r,e,t,n){let i="		".repeat(e),s=[];if(t.has(r.sourceObj))return s.push(`${i}* ${r.type} ${r.name} (already listed)`),s.join(`
`);if(t.add(r.sourceObj),s.push(`${i}* ${r.type} ${r.name}:`),s.push(`${i}  value: ${oe(r.value,50)}`),s.push(`${i}  state: ${r.state}`),r.dependencies.length>0){s.push(`${i}  dependencies:`);for(let l of r.dependencies){let u=He.from(l,n.debugNamePostProcessor??(d=>d))??He.unknown(l);s.push(vo(u,e+1,t,n))}}return s.join(`
`)}function To(r,e,t,n){let i="		".repeat(e),s=[];if(t.has(r.sourceObj))return s.push(`${i}* ${r.type} ${r.name} (already listed)`),s.join(`
`);if(t.add(r.sourceObj),s.push(`${i}* ${r.type} ${r.name}:`),s.push(`${i}  value: ${oe(r.value,50)}`),s.push(`${i}  state: ${r.state}`),r.observers.length>0){s.push(`${i}  observers:`);for(let l of r.observers){let u=He.from(l,n.debugNamePostProcessor??(d=>d))??He.unknown(l);s.push(To(u,e+1,t,n))}}return s.join(`
`)}var He=class r{constructor(e,t,n,i,s,a,l){this.sourceObj=e;this.name=t;this.type=n;this.value=i;this.state=s;this.dependencies=a;this.observers=l}static from(e,t){if(e instanceof Pe){let n=e.debugGetState();return new r(e,t(e.debugName),"autorun",void 0,n.stateStr,Array.from(n.dependencies),[])}else if(e instanceof Q){let n=e.debugGetState();return new r(e,t(e.debugName),"derived",n.value,n.stateStr,Array.from(n.dependencies),Array.from(e.debugGetObservers()))}else if(e instanceof Se){let n=e.debugGetState();return new r(e,t(e.debugName),"observableValue",n.value,"upToDate",[],Array.from(e.debugGetObservers()))}else if(e instanceof le){let n=e.debugGetState();return new r(e,t(e.debugName),"fromEvent",n.value,n.hasValue?"upToDate":"initial",[],Array.from(e.debugGetObservers()))}}static unknown(e){return new r(e,"(unknown)","unknown",void 0,"unknown",[],[])}};uo(go);no(bo);var ba=!1;ba&&Et(new Rt);mt&&mt.VSCODE_DEV_DEBUG_OBSERVABLES&&Et(ln.getInstance());var U=class r{constructor(e,t){this.start=e;this.endExclusive=t;if(e>t)throw new w(`Invalid range: ${this.toString()}`)}static fromTo(e,t){return new r(e,t)}static equals(e,t){return e.start===t.start&&e.endExclusive===t.endExclusive}static addRange(e,t){let n=0;for(;n<t.length&&t[n].endExclusive<e.start;)n++;let i=n;for(;i<t.length&&t[i].start<=e.endExclusive;)i++;if(n===i)t.splice(n,0,e);else{let s=Math.min(e.start,t[n].start),a=Math.max(e.endExclusive,t[i-1].endExclusive);t.splice(n,i-n,new r(s,a))}}static tryCreate(e,t){if(!(e>t))return new r(e,t)}static ofLength(e){return new r(0,e)}static ofStartAndLength(e,t){return new r(e,e+t)}static emptyAt(e){return new r(e,e)}get isEmpty(){return this.start===this.endExclusive}delta(e){return new r(this.start+e,this.endExclusive+e)}deltaStart(e){return new r(this.start+e,this.endExclusive)}deltaEnd(e){return new r(this.start,this.endExclusive+e)}get length(){return this.endExclusive-this.start}toString(){return`[${this.start}, ${this.endExclusive})`}equals(e){return this.start===e.start&&this.endExclusive===e.endExclusive}containsRange(e){return this.start<=e.start&&e.endExclusive<=this.endExclusive}contains(e){return this.start<=e&&e<this.endExclusive}join(e){return new r(Math.min(this.start,e.start),Math.max(this.endExclusive,e.endExclusive))}intersect(e){let t=Math.max(this.start,e.start),n=Math.min(this.endExclusive,e.endExclusive);if(t<=n)return new r(t,n)}intersectionLength(e){let t=Math.max(this.start,e.start),n=Math.min(this.endExclusive,e.endExclusive);return Math.max(0,n-t)}intersects(e){let t=Math.max(this.start,e.start),n=Math.min(this.endExclusive,e.endExclusive);return t<n}intersectsOrTouches(e){let t=Math.max(this.start,e.start),n=Math.min(this.endExclusive,e.endExclusive);return t<=n}isBefore(e){return this.endExclusive<=e.start}isAfter(e){return this.start>=e.endExclusive}slice(e){return e.slice(this.start,this.endExclusive)}substring(e){return e.substring(this.start,this.endExclusive)}clip(e){if(this.isEmpty)throw new w(`Invalid clipping range: ${this.toString()}`);return Math.max(this.start,Math.min(this.endExclusive-1,e))}clipCyclic(e){if(this.isEmpty)throw new w(`Invalid clipping range: ${this.toString()}`);return e<this.start?this.endExclusive-(this.start-e)%this.length:e>=this.endExclusive?this.start+(e-this.start)%this.length:e}map(e){let t=[];for(let n=this.start;n<this.endExclusive;n++)t.push(e(n));return t}forEach(e){for(let t=this.start;t<this.endExclusive;t++)e(t)}joinRightTouching(e){if(this.endExclusive!==e.start)throw new w(`Invalid join: ${this.toString()} and ${e.toString()}`);return new r(this.start,e.endExclusive)}withMargin(e,t){return t===void 0&&(t=e),new r(this.start-e,this.endExclusive+t)}};var Ee=class r{constructor(e,t){this.lineNumber=e,this.column=t}with(e=this.lineNumber,t=this.column){return e===this.lineNumber&&t===this.column?this:new r(e,t)}delta(e=0,t=0){return this.with(Math.max(1,this.lineNumber+e),Math.max(1,this.column+t))}equals(e){return r.equals(this,e)}static equals(e,t){return!e&&!t?!0:!!e&&!!t&&e.lineNumber===t.lineNumber&&e.column===t.column}isBefore(e){return r.isBefore(this,e)}static isBefore(e,t){return e.lineNumber<t.lineNumber?!0:t.lineNumber<e.lineNumber?!1:e.column<t.column}isBeforeOrEqual(e){return r.isBeforeOrEqual(this,e)}static isBeforeOrEqual(e,t){return e.lineNumber<t.lineNumber?!0:t.lineNumber<e.lineNumber?!1:e.column<=t.column}static compare(e,t){let n=e.lineNumber|0,i=t.lineNumber|0;if(n===i){let s=e.column|0,a=t.column|0;return s-a}return n-i}clone(){return new r(this.lineNumber,this.column)}toString(){return"("+this.lineNumber+","+this.column+")"}static lift(e){return new r(e.lineNumber,e.column)}static isIPosition(e){return!!e&&typeof e.lineNumber=="number"&&typeof e.column=="number"}toJSON(){return{lineNumber:this.lineNumber,column:this.column}}};var Ne=class r{constructor(e,t,n,i){e>n||e===n&&t>i?(this.startLineNumber=n,this.startColumn=i,this.endLineNumber=e,this.endColumn=t):(this.startLineNumber=e,this.startColumn=t,this.endLineNumber=n,this.endColumn=i)}isEmpty(){return r.isEmpty(this)}static isEmpty(e){return e.startLineNumber===e.endLineNumber&&e.startColumn===e.endColumn}containsPosition(e){return r.containsPosition(this,e)}static containsPosition(e,t){return!(t.lineNumber<e.startLineNumber||t.lineNumber>e.endLineNumber||t.lineNumber===e.startLineNumber&&t.column<e.startColumn||t.lineNumber===e.endLineNumber&&t.column>e.endColumn)}static strictContainsPosition(e,t){return!(t.lineNumber<e.startLineNumber||t.lineNumber>e.endLineNumber||t.lineNumber===e.startLineNumber&&t.column<=e.startColumn||t.lineNumber===e.endLineNumber&&t.column>=e.endColumn)}containsRange(e){return r.containsRange(this,e)}static containsRange(e,t){return!(t.startLineNumber<e.startLineNumber||t.endLineNumber<e.startLineNumber||t.startLineNumber>e.endLineNumber||t.endLineNumber>e.endLineNumber||t.startLineNumber===e.startLineNumber&&t.startColumn<e.startColumn||t.endLineNumber===e.endLineNumber&&t.endColumn>e.endColumn)}strictContainsRange(e){return r.strictContainsRange(this,e)}static strictContainsRange(e,t){return!(t.startLineNumber<e.startLineNumber||t.endLineNumber<e.startLineNumber||t.startLineNumber>e.endLineNumber||t.endLineNumber>e.endLineNumber||t.startLineNumber===e.startLineNumber&&t.startColumn<=e.startColumn||t.endLineNumber===e.endLineNumber&&t.endColumn>=e.endColumn)}plusRange(e){return r.plusRange(this,e)}static plusRange(e,t){let n,i,s,a;return t.startLineNumber<e.startLineNumber?(n=t.startLineNumber,i=t.startColumn):t.startLineNumber===e.startLineNumber?(n=t.startLineNumber,i=Math.min(t.startColumn,e.startColumn)):(n=e.startLineNumber,i=e.startColumn),t.endLineNumber>e.endLineNumber?(s=t.endLineNumber,a=t.endColumn):t.endLineNumber===e.endLineNumber?(s=t.endLineNumber,a=Math.max(t.endColumn,e.endColumn)):(s=e.endLineNumber,a=e.endColumn),new r(n,i,s,a)}intersectRanges(e){return r.intersectRanges(this,e)}static intersectRanges(e,t){let n=e.startLineNumber,i=e.startColumn,s=e.endLineNumber,a=e.endColumn,l=t.startLineNumber,u=t.startColumn,d=t.endLineNumber,f=t.endColumn;return n<l?(n=l,i=u):n===l&&(i=Math.max(i,u)),s>d?(s=d,a=f):s===d&&(a=Math.min(a,f)),n>s||n===s&&i>a?null:new r(n,i,s,a)}equalsRange(e){return r.equalsRange(this,e)}static equalsRange(e,t){return!e&&!t?!0:!!e&&!!t&&e.startLineNumber===t.startLineNumber&&e.startColumn===t.startColumn&&e.endLineNumber===t.endLineNumber&&e.endColumn===t.endColumn}getEndPosition(){return r.getEndPosition(this)}static getEndPosition(e){return new Ee(e.endLineNumber,e.endColumn)}getStartPosition(){return r.getStartPosition(this)}static getStartPosition(e){return new Ee(e.startLineNumber,e.startColumn)}toString(){return"["+this.startLineNumber+","+this.startColumn+" -> "+this.endLineNumber+","+this.endColumn+"]"}setEndPosition(e,t){return new r(this.startLineNumber,this.startColumn,e,t)}setStartPosition(e,t){return new r(e,t,this.endLineNumber,this.endColumn)}collapseToStart(){return r.collapseToStart(this)}static collapseToStart(e){return new r(e.startLineNumber,e.startColumn,e.startLineNumber,e.startColumn)}collapseToEnd(){return r.collapseToEnd(this)}static collapseToEnd(e){return new r(e.endLineNumber,e.endColumn,e.endLineNumber,e.endColumn)}delta(e){return new r(this.startLineNumber+e,this.startColumn,this.endLineNumber+e,this.endColumn)}isSingleLine(){return this.startLineNumber===this.endLineNumber}static fromPositions(e,t=e){return new r(e.lineNumber,e.column,t.lineNumber,t.column)}static lift(e){return e?new r(e.startLineNumber,e.startColumn,e.endLineNumber,e.endColumn):null}static isIRange(e){return!!e&&typeof e.startLineNumber=="number"&&typeof e.startColumn=="number"&&typeof e.endLineNumber=="number"&&typeof e.endColumn=="number"}static areIntersectingOrTouching(e,t){return!(e.endLineNumber<t.startLineNumber||e.endLineNumber===t.startLineNumber&&e.endColumn<t.startColumn||t.endLineNumber<e.startLineNumber||t.endLineNumber===e.startLineNumber&&t.endColumn<e.startColumn)}static areIntersecting(e,t){return!(e.endLineNumber<t.startLineNumber||e.endLineNumber===t.startLineNumber&&e.endColumn<=t.startColumn||t.endLineNumber<e.startLineNumber||t.endLineNumber===e.startLineNumber&&t.endColumn<=e.startColumn)}static areOnlyIntersecting(e,t){return!(e.endLineNumber<t.startLineNumber-1||e.endLineNumber===t.startLineNumber&&e.endColumn<t.startColumn-1||t.endLineNumber<e.startLineNumber-1||t.endLineNumber===e.startLineNumber&&t.endColumn<e.startColumn-1)}static compareRangesUsingStarts(e,t){if(e&&t){let s=e.startLineNumber|0,a=t.startLineNumber|0;if(s===a){let l=e.startColumn|0,u=t.startColumn|0;if(l===u){let d=e.endLineNumber|0,f=t.endLineNumber|0;if(d===f){let c=e.endColumn|0,b=t.endColumn|0;return c-b}return d-f}return l-u}return s-a}return(e?1:0)-(t?1:0)}static compareRangesUsingEnds(e,t){return e.endLineNumber===t.endLineNumber?e.endColumn===t.endColumn?e.startLineNumber===t.startLineNumber?e.startColumn-t.startColumn:e.startLineNumber-t.startLineNumber:e.endColumn-t.endColumn:e.endLineNumber-t.endLineNumber}static spansMultipleLines(e){return e.endLineNumber>e.startLineNumber}toJSON(){return this}};var de=class r{static ofLength(e,t){return new r(e,e+t)}static fromRange(e){return new r(e.startLineNumber,e.endLineNumber)}static fromRangeInclusive(e){return new r(e.startLineNumber,e.endLineNumber+1)}static{this.compareByStart=qt(e=>e.startLineNumber,jt)}static subtract(e,t){return t?e.startLineNumber<t.startLineNumber&&t.endLineNumberExclusive<e.endLineNumberExclusive?[new r(e.startLineNumber,t.startLineNumber),new r(t.endLineNumberExclusive,e.endLineNumberExclusive)]:t.startLineNumber<=e.startLineNumber&&e.endLineNumberExclusive<=t.endLineNumberExclusive?[]:t.endLineNumberExclusive<e.endLineNumberExclusive?[new r(Math.max(t.endLineNumberExclusive,e.startLineNumber),e.endLineNumberExclusive)]:[new r(e.startLineNumber,Math.min(t.startLineNumber,e.endLineNumberExclusive))]:[e]}static joinMany(e){if(e.length===0)return[];let t=new un(e[0].slice());for(let n=1;n<e.length;n++)t=t.getUnion(new un(e[n].slice()));return t.ranges}static join(e){if(e.length===0)throw new w("lineRanges cannot be empty");let t=e[0].startLineNumber,n=e[0].endLineNumberExclusive;for(let i=1;i<e.length;i++)t=Math.min(t,e[i].startLineNumber),n=Math.max(n,e[i].endLineNumberExclusive);return new r(t,n)}static deserialize(e){return new r(e[0],e[1])}constructor(e,t){if(e>t)throw new w(`startLineNumber ${e} cannot be after endLineNumberExclusive ${t}`);this.startLineNumber=e,this.endLineNumberExclusive=t}contains(e){return this.startLineNumber<=e&&e<this.endLineNumberExclusive}containsRange(e){return this.startLineNumber<=e.startLineNumber&&e.endLineNumberExclusive<=this.endLineNumberExclusive}get isEmpty(){return this.startLineNumber===this.endLineNumberExclusive}delta(e){return new r(this.startLineNumber+e,this.endLineNumberExclusive+e)}deltaLength(e){return new r(this.startLineNumber,this.endLineNumberExclusive+e)}get length(){return this.endLineNumberExclusive-this.startLineNumber}join(e){return new r(Math.min(this.startLineNumber,e.startLineNumber),Math.max(this.endLineNumberExclusive,e.endLineNumberExclusive))}toString(){return`[${this.startLineNumber},${this.endLineNumberExclusive})`}intersect(e){let t=Math.max(this.startLineNumber,e.startLineNumber),n=Math.min(this.endLineNumberExclusive,e.endLineNumberExclusive);if(t<=n)return new r(t,n)}intersectsStrict(e){return this.startLineNumber<e.endLineNumberExclusive&&e.startLineNumber<this.endLineNumberExclusive}intersectsOrTouches(e){return this.startLineNumber<=e.endLineNumberExclusive&&e.startLineNumber<=this.endLineNumberExclusive}equals(e){return this.startLineNumber===e.startLineNumber&&this.endLineNumberExclusive===e.endLineNumberExclusive}toInclusiveRange(){return this.isEmpty?null:new Ne(this.startLineNumber,1,this.endLineNumberExclusive-1,Number.MAX_SAFE_INTEGER)}toExclusiveRange(){return new Ne(this.startLineNumber,1,this.endLineNumberExclusive,1)}mapToLineArray(e){let t=[];for(let n=this.startLineNumber;n<this.endLineNumberExclusive;n++)t.push(e(n));return t}forEach(e){for(let t=this.startLineNumber;t<this.endLineNumberExclusive;t++)e(t)}serialize(){return[this.startLineNumber,this.endLineNumberExclusive]}toOffsetRange(){return new U(this.startLineNumber-1,this.endLineNumberExclusive-1)}distanceToRange(e){return this.endLineNumberExclusive<=e.startLineNumber?e.startLineNumber-this.endLineNumberExclusive:e.endLineNumberExclusive<=this.startLineNumber?this.startLineNumber-e.endLineNumberExclusive:0}distanceToLine(e){return this.contains(e)?0:e<this.startLineNumber?this.startLineNumber-e:e-this.endLineNumberExclusive}addMargin(e,t){return new r(this.startLineNumber-e,this.endLineNumberExclusive+t)}},un=class r{constructor(e=[]){this._normalizedRanges=e}get ranges(){return this._normalizedRanges}addRange(e){if(e.length===0)return;let t=Wt(this._normalizedRanges,i=>i.endLineNumberExclusive>=e.startLineNumber),n=gt(this._normalizedRanges,i=>i.startLineNumber<=e.endLineNumberExclusive)+1;if(t===n)this._normalizedRanges.splice(t,0,e);else if(t===n-1){let i=this._normalizedRanges[t];this._normalizedRanges[t]=i.join(e)}else{let i=this._normalizedRanges[t].join(this._normalizedRanges[n-1]).join(e);this._normalizedRanges.splice(t,n-t,i)}}contains(e){let t=Cn(this._normalizedRanges,n=>n.startLineNumber<=e);return!!t&&t.endLineNumberExclusive>e}intersects(e){let t=Cn(this._normalizedRanges,n=>n.startLineNumber<e.endLineNumberExclusive);return!!t&&t.endLineNumberExclusive>e.startLineNumber}getUnion(e){if(this._normalizedRanges.length===0)return e;if(e._normalizedRanges.length===0)return this;let t=[],n=0,i=0,s=null;for(;n<this._normalizedRanges.length||i<e._normalizedRanges.length;){let a=null;if(n<this._normalizedRanges.length&&i<e._normalizedRanges.length){let l=this._normalizedRanges[n],u=e._normalizedRanges[i];l.startLineNumber<u.startLineNumber?(a=l,n++):(a=u,i++)}else n<this._normalizedRanges.length?(a=this._normalizedRanges[n],n++):(a=e._normalizedRanges[i],i++);s===null?s=a:s.endLineNumberExclusive>=a.startLineNumber?s=new de(s.startLineNumber,Math.max(s.endLineNumberExclusive,a.endLineNumberExclusive)):(t.push(s),s=a)}return s!==null&&t.push(s),new r(t)}subtractFrom(e){let t=Wt(this._normalizedRanges,a=>a.endLineNumberExclusive>=e.startLineNumber),n=gt(this._normalizedRanges,a=>a.startLineNumber<=e.endLineNumberExclusive)+1;if(t===n)return new r([e]);let i=[],s=e.startLineNumber;for(let a=t;a<n;a++){let l=this._normalizedRanges[a];l.startLineNumber>s&&i.push(new de(s,l.startLineNumber)),s=l.endLineNumberExclusive}return s<e.endLineNumberExclusive&&i.push(new de(s,e.endLineNumberExclusive)),new r(i)}toString(){return this._normalizedRanges.map(e=>e.toString()).join(", ")}getIntersection(e){let t=[],n=0,i=0;for(;n<this._normalizedRanges.length&&i<e._normalizedRanges.length;){let s=this._normalizedRanges[n],a=e._normalizedRanges[i],l=s.intersect(a);l&&!l.isEmpty&&t.push(l),s.endLineNumberExclusive<a.endLineNumberExclusive?n++:i++}return new r(t)}getWithDelta(e){return new r(this._normalizedRanges.map(t=>t.delta(e)))}};var dn=class{constructor(e){this.values=e,this.prefixSum=new Uint32Array(e.length),this.prefixSumValidIndex=new Int32Array(1),this.prefixSumValidIndex[0]=-1}getCount(){return this.values.length}insertValues(e,t){e=qe(e);let n=this.values,i=this.prefixSum,s=t.length;return s===0?!1:(this.values=new Uint32Array(n.length+s),this.values.set(n.subarray(0,e),0),this.values.set(n.subarray(e),e+s),this.values.set(t,e),e-1<this.prefixSumValidIndex[0]&&(this.prefixSumValidIndex[0]=e-1),this.prefixSum=new Uint32Array(this.values.length),this.prefixSumValidIndex[0]>=0&&this.prefixSum.set(i.subarray(0,this.prefixSumValidIndex[0]+1)),!0)}setValue(e,t){return e=qe(e),t=qe(t),this.values[e]===t?!1:(this.values[e]=t,e-1<this.prefixSumValidIndex[0]&&(this.prefixSumValidIndex[0]=e-1),!0)}removeValues(e,t){e=qe(e),t=qe(t);let n=this.values,i=this.prefixSum;if(e>=n.length)return!1;let s=n.length-e;return t>=s&&(t=s),t===0?!1:(this.values=new Uint32Array(n.length-t),this.values.set(n.subarray(0,e),0),this.values.set(n.subarray(e+t),e),this.prefixSum=new Uint32Array(this.values.length),e-1<this.prefixSumValidIndex[0]&&(this.prefixSumValidIndex[0]=e-1),this.prefixSumValidIndex[0]>=0&&this.prefixSum.set(i.subarray(0,this.prefixSumValidIndex[0]+1)),!0)}getTotalSum(){return this.values.length===0?0:this._getPrefixSum(this.values.length-1)}getPrefixSum(e){return e<0?0:(e=qe(e),this._getPrefixSum(e))}_getPrefixSum(e){if(e<=this.prefixSumValidIndex[0])return this.prefixSum[e];let t=this.prefixSumValidIndex[0]+1;t===0&&(this.prefixSum[0]=this.values[0],t++),e>=this.values.length&&(e=this.values.length-1);for(let n=t;n<=e;n++)this.prefixSum[n]=this.prefixSum[n-1]+this.values[n];return this.prefixSumValidIndex[0]=Math.max(this.prefixSumValidIndex[0],e),this.prefixSum[e]}getIndexOf(e){e=Math.floor(e),this.getTotalSum();let t=0,n=this.values.length-1,i=0,s=0,a=0;for(;t<=n;)if(i=t+(n-t)/2|0,s=this.prefixSum[i],a=s-this.values[i],e<a)n=i-1;else if(e>=s)t=i+1;else break;return new _r(i,e-a)}};var _r=class{constructor(e,t){this.index=e;this.remainder=t;this._prefixSumIndexOfResultBrand=void 0;this.index=e,this.remainder=t}};var cn=class{constructor(e,t,n,i){this._uri=e,this._lines=t,this._eol=n,this._versionId=i,this._lineStarts=null,this._cachedTextValue=null}dispose(){this._lines.length=0}get version(){return this._versionId}getText(){return this._cachedTextValue===null&&(this._cachedTextValue=this._lines.join(this._eol)),this._cachedTextValue}onEvents(e){e.eol&&e.eol!==this._eol&&(this._eol=e.eol,this._lineStarts=null);let t=e.changes;for(let n of t)this._acceptDeleteRange(n.range),this._acceptInsertText(new Ee(n.range.startLineNumber,n.range.startColumn),n.text);this._versionId=e.versionId,this._cachedTextValue=null}_ensureLineStarts(){if(!this._lineStarts){let e=this._eol.length,t=this._lines.length,n=new Uint32Array(t);for(let i=0;i<t;i++)n[i]=this._lines[i].length+e;this._lineStarts=new dn(n)}}_setLineText(e,t){this._lines[e]=t,this._lineStarts&&this._lineStarts.setValue(e,this._lines[e].length+this._eol.length)}_acceptDeleteRange(e){if(e.startLineNumber===e.endLineNumber){if(e.startColumn===e.endColumn)return;this._setLineText(e.startLineNumber-1,this._lines[e.startLineNumber-1].substring(0,e.startColumn-1)+this._lines[e.startLineNumber-1].substring(e.endColumn-1));return}this._setLineText(e.startLineNumber-1,this._lines[e.startLineNumber-1].substring(0,e.startColumn-1)+this._lines[e.endLineNumber-1].substring(e.endColumn-1)),this._lines.splice(e.startLineNumber,e.endLineNumber-e.startLineNumber),this._lineStarts&&this._lineStarts.removeValues(e.startLineNumber,e.endLineNumber-e.startLineNumber)}_acceptInsertText(e,t){if(t.length===0)return;let n=Fi(t);if(n.length===1){this._setLineText(e.lineNumber-1,this._lines[e.lineNumber-1].substring(0,e.column-1)+n[0]+this._lines[e.lineNumber-1].substring(e.column-1));return}n[n.length-1]+=this._lines[e.lineNumber-1].substring(e.column-1),this._setLineText(e.lineNumber-1,this._lines[e.lineNumber-1].substring(0,e.column-1)+n[0]);let i=new Uint32Array(n.length-1);for(let s=1;s<n.length;s++)this._lines.splice(e.lineNumber+s-1,0,n[s]),i[s-1]=n[s].length+this._eol.length;this._lineStarts&&this._lineStarts.insertValues(e.lineNumber,i)}};function Lt(r){let e=0,t=0,n=0,i=0;for(let s=0,a=r.length;s<a;s++){let l=r.charCodeAt(s);l===13?(e===0&&(t=s),e++,s+1<a&&r.charCodeAt(s+1)===10?(i|=2,s++):i|=3,n=s+1):l===10&&(i|=1,e===0&&(t=s),e++,n=s+1)}return e===0&&(t=r.length),[e,t,r.length-n,i]}var me=class{static getLanguageId(e){return(e&255)>>>0}static getTokenType(e){return(e&768)>>>8}static containsBalancedBrackets(e){return(e&1024)!==0}static getFontStyle(e){return(e&30720)>>>11}static getForeground(e){return(e&16744448)>>>15}static getBackground(e){return(e&4278190080)>>>24}static getClassNameFromMetadata(e){let n="mtk"+this.getForeground(e),i=this.getFontStyle(e);return i&1&&(n+=" mtki"),i&2&&(n+=" mtkb"),i&4&&(n+=" mtku"),i&8&&(n+=" mtks"),n}static getInlineStyleFromMetadata(e,t){let n=this.getForeground(e),i=this.getFontStyle(e),s=`color: ${t[n]};`;i&1&&(s+="font-style: italic;"),i&2&&(s+="font-weight: bold;");let a="";return i&4&&(a+=" underline"),i&8&&(a+=" line-through"),a&&(s+=`text-decoration:${a};`),s}static getPresentationFromMetadata(e){let t=this.getForeground(e),n=this.getFontStyle(e);return{foreground:t,italic:!!(n&1),bold:!!(n&2),underline:!!(n&4),strikethrough:!!(n&8)}}};var xo=Object.create(null);function o(r,e){if(Ii(e)){let t=xo[e];if(t===void 0)throw new Error(`${r} references an unknown codicon: ${e}`);e=t}return xo[r]=e,{id:r}}var yo={add:o("add",6e4),plus:o("plus",6e4),gistNew:o("gist-new",6e4),repoCreate:o("repo-create",6e4),lightbulb:o("lightbulb",60001),lightBulb:o("light-bulb",60001),repo:o("repo",60002),repoDelete:o("repo-delete",60002),gistFork:o("gist-fork",60003),repoForked:o("repo-forked",60003),gitPullRequest:o("git-pull-request",60004),gitPullRequestAbandoned:o("git-pull-request-abandoned",60004),recordKeys:o("record-keys",60005),keyboard:o("keyboard",60005),tag:o("tag",60006),gitPullRequestLabel:o("git-pull-request-label",60006),tagAdd:o("tag-add",60006),tagRemove:o("tag-remove",60006),person:o("person",60007),personFollow:o("person-follow",60007),personOutline:o("person-outline",60007),personFilled:o("person-filled",60007),sourceControl:o("source-control",60008),mirror:o("mirror",60009),mirrorPublic:o("mirror-public",60009),star:o("star",60010),starAdd:o("star-add",60010),starDelete:o("star-delete",60010),starEmpty:o("star-empty",60010),comment:o("comment",60011),commentAdd:o("comment-add",60011),alert:o("alert",60012),warning:o("warning",60012),search:o("search",60013),searchSave:o("search-save",60013),logOut:o("log-out",60014),signOut:o("sign-out",60014),logIn:o("log-in",60015),signIn:o("sign-in",60015),eye:o("eye",60016),eyeUnwatch:o("eye-unwatch",60016),eyeWatch:o("eye-watch",60016),circleFilled:o("circle-filled",60017),primitiveDot:o("primitive-dot",60017),closeDirty:o("close-dirty",60017),debugBreakpoint:o("debug-breakpoint",60017),debugBreakpointDisabled:o("debug-breakpoint-disabled",60017),debugHint:o("debug-hint",60017),terminalDecorationSuccess:o("terminal-decoration-success",60017),primitiveSquare:o("primitive-square",60018),edit:o("edit",60019),pencil:o("pencil",60019),info:o("info",60020),issueOpened:o("issue-opened",60020),gistPrivate:o("gist-private",60021),gitForkPrivate:o("git-fork-private",60021),lock:o("lock",60021),mirrorPrivate:o("mirror-private",60021),close:o("close",60022),removeClose:o("remove-close",60022),x:o("x",60022),repoSync:o("repo-sync",60023),sync:o("sync",60023),clone:o("clone",60024),desktopDownload:o("desktop-download",60024),beaker:o("beaker",60025),microscope:o("microscope",60025),vm:o("vm",60026),deviceDesktop:o("device-desktop",60026),file:o("file",60027),more:o("more",60028),ellipsis:o("ellipsis",60028),kebabHorizontal:o("kebab-horizontal",60028),mailReply:o("mail-reply",60029),reply:o("reply",60029),organization:o("organization",60030),organizationFilled:o("organization-filled",60030),organizationOutline:o("organization-outline",60030),newFile:o("new-file",60031),fileAdd:o("file-add",60031),newFolder:o("new-folder",60032),fileDirectoryCreate:o("file-directory-create",60032),trash:o("trash",60033),trashcan:o("trashcan",60033),history:o("history",60034),clock:o("clock",60034),folder:o("folder",60035),fileDirectory:o("file-directory",60035),symbolFolder:o("symbol-folder",60035),logoGithub:o("logo-github",60036),markGithub:o("mark-github",60036),github:o("github",60036),terminal:o("terminal",60037),console:o("console",60037),repl:o("repl",60037),zap:o("zap",60038),symbolEvent:o("symbol-event",60038),error:o("error",60039),stop:o("stop",60039),variable:o("variable",60040),symbolVariable:o("symbol-variable",60040),array:o("array",60042),symbolArray:o("symbol-array",60042),symbolModule:o("symbol-module",60043),symbolPackage:o("symbol-package",60043),symbolNamespace:o("symbol-namespace",60043),symbolObject:o("symbol-object",60043),symbolMethod:o("symbol-method",60044),symbolFunction:o("symbol-function",60044),symbolConstructor:o("symbol-constructor",60044),symbolBoolean:o("symbol-boolean",60047),symbolNull:o("symbol-null",60047),symbolNumeric:o("symbol-numeric",60048),symbolNumber:o("symbol-number",60048),symbolStructure:o("symbol-structure",60049),symbolStruct:o("symbol-struct",60049),symbolParameter:o("symbol-parameter",60050),symbolTypeParameter:o("symbol-type-parameter",60050),symbolKey:o("symbol-key",60051),symbolText:o("symbol-text",60051),symbolReference:o("symbol-reference",60052),goToFile:o("go-to-file",60052),symbolEnum:o("symbol-enum",60053),symbolValue:o("symbol-value",60053),symbolRuler:o("symbol-ruler",60054),symbolUnit:o("symbol-unit",60054),activateBreakpoints:o("activate-breakpoints",60055),archive:o("archive",60056),arrowBoth:o("arrow-both",60057),arrowDown:o("arrow-down",60058),arrowLeft:o("arrow-left",60059),arrowRight:o("arrow-right",60060),arrowSmallDown:o("arrow-small-down",60061),arrowSmallLeft:o("arrow-small-left",60062),arrowSmallRight:o("arrow-small-right",60063),arrowSmallUp:o("arrow-small-up",60064),arrowUp:o("arrow-up",60065),bell:o("bell",60066),bold:o("bold",60067),book:o("book",60068),bookmark:o("bookmark",60069),debugBreakpointConditionalUnverified:o("debug-breakpoint-conditional-unverified",60070),debugBreakpointConditional:o("debug-breakpoint-conditional",60071),debugBreakpointConditionalDisabled:o("debug-breakpoint-conditional-disabled",60071),debugBreakpointDataUnverified:o("debug-breakpoint-data-unverified",60072),debugBreakpointData:o("debug-breakpoint-data",60073),debugBreakpointDataDisabled:o("debug-breakpoint-data-disabled",60073),debugBreakpointLogUnverified:o("debug-breakpoint-log-unverified",60074),debugBreakpointLog:o("debug-breakpoint-log",60075),debugBreakpointLogDisabled:o("debug-breakpoint-log-disabled",60075),briefcase:o("briefcase",60076),broadcast:o("broadcast",60077),browser:o("browser",60078),bug:o("bug",60079),calendar:o("calendar",60080),caseSensitive:o("case-sensitive",60081),check:o("check",60082),checklist:o("checklist",60083),chevronDown:o("chevron-down",60084),chevronLeft:o("chevron-left",60085),chevronRight:o("chevron-right",60086),chevronUp:o("chevron-up",60087),chromeClose:o("chrome-close",60088),chromeMaximize:o("chrome-maximize",60089),chromeMinimize:o("chrome-minimize",60090),chromeRestore:o("chrome-restore",60091),circleOutline:o("circle-outline",60092),circle:o("circle",60092),debugBreakpointUnverified:o("debug-breakpoint-unverified",60092),terminalDecorationIncomplete:o("terminal-decoration-incomplete",60092),circleSlash:o("circle-slash",60093),circuitBoard:o("circuit-board",60094),clearAll:o("clear-all",60095),clippy:o("clippy",60096),closeAll:o("close-all",60097),cloudDownload:o("cloud-download",60098),cloudUpload:o("cloud-upload",60099),code:o("code",60100),collapseAll:o("collapse-all",60101),colorMode:o("color-mode",60102),commentDiscussion:o("comment-discussion",60103),creditCard:o("credit-card",60105),dash:o("dash",60108),dashboard:o("dashboard",60109),database:o("database",60110),debugContinue:o("debug-continue",60111),debugDisconnect:o("debug-disconnect",60112),debugPause:o("debug-pause",60113),debugRestart:o("debug-restart",60114),debugStart:o("debug-start",60115),debugStepInto:o("debug-step-into",60116),debugStepOut:o("debug-step-out",60117),debugStepOver:o("debug-step-over",60118),debugStop:o("debug-stop",60119),debug:o("debug",60120),deviceCameraVideo:o("device-camera-video",60121),deviceCamera:o("device-camera",60122),deviceMobile:o("device-mobile",60123),diffAdded:o("diff-added",60124),diffIgnored:o("diff-ignored",60125),diffModified:o("diff-modified",60126),diffRemoved:o("diff-removed",60127),diffRenamed:o("diff-renamed",60128),diff:o("diff",60129),diffSidebyside:o("diff-sidebyside",60129),discard:o("discard",60130),editorLayout:o("editor-layout",60131),emptyWindow:o("empty-window",60132),exclude:o("exclude",60133),extensions:o("extensions",60134),eyeClosed:o("eye-closed",60135),fileBinary:o("file-binary",60136),fileCode:o("file-code",60137),fileMedia:o("file-media",60138),filePdf:o("file-pdf",60139),fileSubmodule:o("file-submodule",60140),fileSymlinkDirectory:o("file-symlink-directory",60141),fileSymlinkFile:o("file-symlink-file",60142),fileZip:o("file-zip",60143),files:o("files",60144),filter:o("filter",60145),flame:o("flame",60146),foldDown:o("fold-down",60147),foldUp:o("fold-up",60148),fold:o("fold",60149),folderActive:o("folder-active",60150),folderOpened:o("folder-opened",60151),gear:o("gear",60152),gift:o("gift",60153),gistSecret:o("gist-secret",60154),gist:o("gist",60155),gitCommit:o("git-commit",60156),gitCompare:o("git-compare",60157),compareChanges:o("compare-changes",60157),gitMerge:o("git-merge",60158),githubAction:o("github-action",60159),githubAlt:o("github-alt",60160),globe:o("globe",60161),grabber:o("grabber",60162),graph:o("graph",60163),gripper:o("gripper",60164),heart:o("heart",60165),home:o("home",60166),horizontalRule:o("horizontal-rule",60167),hubot:o("hubot",60168),inbox:o("inbox",60169),issueReopened:o("issue-reopened",60171),issues:o("issues",60172),italic:o("italic",60173),jersey:o("jersey",60174),json:o("json",60175),bracket:o("bracket",60175),kebabVertical:o("kebab-vertical",60176),key:o("key",60177),law:o("law",60178),lightbulbAutofix:o("lightbulb-autofix",60179),linkExternal:o("link-external",60180),link:o("link",60181),listOrdered:o("list-ordered",60182),listUnordered:o("list-unordered",60183),liveShare:o("live-share",60184),loading:o("loading",60185),location:o("location",60186),mailRead:o("mail-read",60187),mail:o("mail",60188),markdown:o("markdown",60189),megaphone:o("megaphone",60190),mention:o("mention",60191),milestone:o("milestone",60192),gitPullRequestMilestone:o("git-pull-request-milestone",60192),mortarBoard:o("mortar-board",60193),move:o("move",60194),multipleWindows:o("multiple-windows",60195),mute:o("mute",60196),noNewline:o("no-newline",60197),note:o("note",60198),octoface:o("octoface",60199),openPreview:o("open-preview",60200),package:o("package",60201),paintcan:o("paintcan",60202),pin:o("pin",60203),play:o("play",60204),run:o("run",60204),plug:o("plug",60205),preserveCase:o("preserve-case",60206),preview:o("preview",60207),project:o("project",60208),pulse:o("pulse",60209),question:o("question",60210),quote:o("quote",60211),radioTower:o("radio-tower",60212),reactions:o("reactions",60213),references:o("references",60214),refresh:o("refresh",60215),regex:o("regex",60216),remoteExplorer:o("remote-explorer",60217),remote:o("remote",60218),remove:o("remove",60219),replaceAll:o("replace-all",60220),replace:o("replace",60221),repoClone:o("repo-clone",60222),repoForcePush:o("repo-force-push",60223),repoPull:o("repo-pull",60224),repoPush:o("repo-push",60225),report:o("report",60226),requestChanges:o("request-changes",60227),rocket:o("rocket",60228),rootFolderOpened:o("root-folder-opened",60229),rootFolder:o("root-folder",60230),rss:o("rss",60231),ruby:o("ruby",60232),saveAll:o("save-all",60233),saveAs:o("save-as",60234),save:o("save",60235),screenFull:o("screen-full",60236),screenNormal:o("screen-normal",60237),searchStop:o("search-stop",60238),server:o("server",60240),settingsGear:o("settings-gear",60241),settings:o("settings",60242),shield:o("shield",60243),smiley:o("smiley",60244),sortPrecedence:o("sort-precedence",60245),splitHorizontal:o("split-horizontal",60246),splitVertical:o("split-vertical",60247),squirrel:o("squirrel",60248),starFull:o("star-full",60249),starHalf:o("star-half",60250),symbolClass:o("symbol-class",60251),symbolColor:o("symbol-color",60252),symbolConstant:o("symbol-constant",60253),symbolEnumMember:o("symbol-enum-member",60254),symbolField:o("symbol-field",60255),symbolFile:o("symbol-file",60256),symbolInterface:o("symbol-interface",60257),symbolKeyword:o("symbol-keyword",60258),symbolMisc:o("symbol-misc",60259),symbolOperator:o("symbol-operator",60260),symbolProperty:o("symbol-property",60261),wrench:o("wrench",60261),wrenchSubaction:o("wrench-subaction",60261),symbolSnippet:o("symbol-snippet",60262),tasklist:o("tasklist",60263),telescope:o("telescope",60264),textSize:o("text-size",60265),threeBars:o("three-bars",60266),thumbsdown:o("thumbsdown",60267),thumbsup:o("thumbsup",60268),tools:o("tools",60269),triangleDown:o("triangle-down",60270),triangleLeft:o("triangle-left",60271),triangleRight:o("triangle-right",60272),triangleUp:o("triangle-up",60273),twitter:o("twitter",60274),unfold:o("unfold",60275),unlock:o("unlock",60276),unmute:o("unmute",60277),unverified:o("unverified",60278),verified:o("verified",60279),versions:o("versions",60280),vmActive:o("vm-active",60281),vmOutline:o("vm-outline",60282),vmRunning:o("vm-running",60283),watch:o("watch",60284),whitespace:o("whitespace",60285),wholeWord:o("whole-word",60286),window:o("window",60287),wordWrap:o("word-wrap",60288),zoomIn:o("zoom-in",60289),zoomOut:o("zoom-out",60290),listFilter:o("list-filter",60291),listFlat:o("list-flat",60292),listSelection:o("list-selection",60293),selection:o("selection",60293),listTree:o("list-tree",60294),debugBreakpointFunctionUnverified:o("debug-breakpoint-function-unverified",60295),debugBreakpointFunction:o("debug-breakpoint-function",60296),debugBreakpointFunctionDisabled:o("debug-breakpoint-function-disabled",60296),debugStackframeActive:o("debug-stackframe-active",60297),circleSmallFilled:o("circle-small-filled",60298),debugStackframeDot:o("debug-stackframe-dot",60298),terminalDecorationMark:o("terminal-decoration-mark",60298),debugStackframe:o("debug-stackframe",60299),debugStackframeFocused:o("debug-stackframe-focused",60299),debugBreakpointUnsupported:o("debug-breakpoint-unsupported",60300),symbolString:o("symbol-string",60301),debugReverseContinue:o("debug-reverse-continue",60302),debugStepBack:o("debug-step-back",60303),debugRestartFrame:o("debug-restart-frame",60304),debugAlt:o("debug-alt",60305),callIncoming:o("call-incoming",60306),callOutgoing:o("call-outgoing",60307),menu:o("menu",60308),expandAll:o("expand-all",60309),feedback:o("feedback",60310),gitPullRequestReviewer:o("git-pull-request-reviewer",60310),groupByRefType:o("group-by-ref-type",60311),ungroupByRefType:o("ungroup-by-ref-type",60312),account:o("account",60313),gitPullRequestAssignee:o("git-pull-request-assignee",60313),bellDot:o("bell-dot",60314),debugConsole:o("debug-console",60315),library:o("library",60316),output:o("output",60317),runAll:o("run-all",60318),syncIgnored:o("sync-ignored",60319),pinned:o("pinned",60320),githubInverted:o("github-inverted",60321),serverProcess:o("server-process",60322),serverEnvironment:o("server-environment",60323),pass:o("pass",60324),issueClosed:o("issue-closed",60324),stopCircle:o("stop-circle",60325),playCircle:o("play-circle",60326),record:o("record",60327),debugAltSmall:o("debug-alt-small",60328),vmConnect:o("vm-connect",60329),cloud:o("cloud",60330),merge:o("merge",60331),export:o("export",60332),graphLeft:o("graph-left",60333),magnet:o("magnet",60334),notebook:o("notebook",60335),redo:o("redo",60336),checkAll:o("check-all",60337),pinnedDirty:o("pinned-dirty",60338),passFilled:o("pass-filled",60339),circleLargeFilled:o("circle-large-filled",60340),circleLarge:o("circle-large",60341),circleLargeOutline:o("circle-large-outline",60341),combine:o("combine",60342),gather:o("gather",60342),table:o("table",60343),variableGroup:o("variable-group",60344),typeHierarchy:o("type-hierarchy",60345),typeHierarchySub:o("type-hierarchy-sub",60346),typeHierarchySuper:o("type-hierarchy-super",60347),gitPullRequestCreate:o("git-pull-request-create",60348),runAbove:o("run-above",60349),runBelow:o("run-below",60350),notebookTemplate:o("notebook-template",60351),debugRerun:o("debug-rerun",60352),workspaceTrusted:o("workspace-trusted",60353),workspaceUntrusted:o("workspace-untrusted",60354),workspaceUnknown:o("workspace-unknown",60355),terminalCmd:o("terminal-cmd",60356),terminalDebian:o("terminal-debian",60357),terminalLinux:o("terminal-linux",60358),terminalPowershell:o("terminal-powershell",60359),terminalTmux:o("terminal-tmux",60360),terminalUbuntu:o("terminal-ubuntu",60361),terminalBash:o("terminal-bash",60362),arrowSwap:o("arrow-swap",60363),copy:o("copy",60364),personAdd:o("person-add",60365),filterFilled:o("filter-filled",60366),wand:o("wand",60367),debugLineByLine:o("debug-line-by-line",60368),inspect:o("inspect",60369),layers:o("layers",60370),layersDot:o("layers-dot",60371),layersActive:o("layers-active",60372),compass:o("compass",60373),compassDot:o("compass-dot",60374),compassActive:o("compass-active",60375),azure:o("azure",60376),issueDraft:o("issue-draft",60377),gitPullRequestClosed:o("git-pull-request-closed",60378),gitPullRequestDraft:o("git-pull-request-draft",60379),debugAll:o("debug-all",60380),debugCoverage:o("debug-coverage",60381),runErrors:o("run-errors",60382),folderLibrary:o("folder-library",60383),debugContinueSmall:o("debug-continue-small",60384),beakerStop:o("beaker-stop",60385),graphLine:o("graph-line",60386),graphScatter:o("graph-scatter",60387),pieChart:o("pie-chart",60388),bracketDot:o("bracket-dot",60389),bracketError:o("bracket-error",60390),lockSmall:o("lock-small",60391),azureDevops:o("azure-devops",60392),verifiedFilled:o("verified-filled",60393),newline:o("newline",60394),layout:o("layout",60395),layoutActivitybarLeft:o("layout-activitybar-left",60396),layoutActivitybarRight:o("layout-activitybar-right",60397),layoutPanelLeft:o("layout-panel-left",60398),layoutPanelCenter:o("layout-panel-center",60399),layoutPanelJustify:o("layout-panel-justify",60400),layoutPanelRight:o("layout-panel-right",60401),layoutPanel:o("layout-panel",60402),layoutSidebarLeft:o("layout-sidebar-left",60403),layoutSidebarRight:o("layout-sidebar-right",60404),layoutStatusbar:o("layout-statusbar",60405),layoutMenubar:o("layout-menubar",60406),layoutCentered:o("layout-centered",60407),target:o("target",60408),indent:o("indent",60409),recordSmall:o("record-small",60410),errorSmall:o("error-small",60411),terminalDecorationError:o("terminal-decoration-error",60411),arrowCircleDown:o("arrow-circle-down",60412),arrowCircleLeft:o("arrow-circle-left",60413),arrowCircleRight:o("arrow-circle-right",60414),arrowCircleUp:o("arrow-circle-up",60415),layoutSidebarRightOff:o("layout-sidebar-right-off",60416),layoutPanelOff:o("layout-panel-off",60417),layoutSidebarLeftOff:o("layout-sidebar-left-off",60418),blank:o("blank",60419),heartFilled:o("heart-filled",60420),map:o("map",60421),mapHorizontal:o("map-horizontal",60421),foldHorizontal:o("fold-horizontal",60421),mapFilled:o("map-filled",60422),mapHorizontalFilled:o("map-horizontal-filled",60422),foldHorizontalFilled:o("fold-horizontal-filled",60422),circleSmall:o("circle-small",60423),bellSlash:o("bell-slash",60424),bellSlashDot:o("bell-slash-dot",60425),commentUnresolved:o("comment-unresolved",60426),gitPullRequestGoToChanges:o("git-pull-request-go-to-changes",60427),gitPullRequestNewChanges:o("git-pull-request-new-changes",60428),searchFuzzy:o("search-fuzzy",60429),commentDraft:o("comment-draft",60430),send:o("send",60431),sparkle:o("sparkle",60432),insert:o("insert",60433),mic:o("mic",60434),thumbsdownFilled:o("thumbsdown-filled",60435),thumbsupFilled:o("thumbsup-filled",60436),coffee:o("coffee",60437),snake:o("snake",60438),game:o("game",60439),vr:o("vr",60440),chip:o("chip",60441),piano:o("piano",60442),music:o("music",60443),micFilled:o("mic-filled",60444),repoFetch:o("repo-fetch",60445),copilot:o("copilot",60446),lightbulbSparkle:o("lightbulb-sparkle",60447),robot:o("robot",60448),sparkleFilled:o("sparkle-filled",60449),diffSingle:o("diff-single",60450),diffMultiple:o("diff-multiple",60451),surroundWith:o("surround-with",60452),share:o("share",60453),gitStash:o("git-stash",60454),gitStashApply:o("git-stash-apply",60455),gitStashPop:o("git-stash-pop",60456),vscode:o("vscode",60457),vscodeInsiders:o("vscode-insiders",60458),codeOss:o("code-oss",60459),runCoverage:o("run-coverage",60460),runAllCoverage:o("run-all-coverage",60461),coverage:o("coverage",60462),githubProject:o("github-project",60463),mapVertical:o("map-vertical",60464),foldVertical:o("fold-vertical",60464),mapVerticalFilled:o("map-vertical-filled",60465),foldVerticalFilled:o("fold-vertical-filled",60465),goToSearch:o("go-to-search",60466),percentage:o("percentage",60467),sortPercentage:o("sort-percentage",60467),attach:o("attach",60468),goToEditingSession:o("go-to-editing-session",60469),editSession:o("edit-session",60470),codeReview:o("code-review",60471),copilotWarning:o("copilot-warning",60472),python:o("python",60473),copilotLarge:o("copilot-large",60474),copilotWarningLarge:o("copilot-warning-large",60475),keyboardTab:o("keyboard-tab",60476),copilotBlocked:o("copilot-blocked",60477),copilotNotConnected:o("copilot-not-connected",60478),flag:o("flag",60479),lightbulbEmpty:o("lightbulb-empty",60480),symbolMethodArrow:o("symbol-method-arrow",60481),copilotUnavailable:o("copilot-unavailable",60482),repoPinned:o("repo-pinned",60483),keyboardTabAbove:o("keyboard-tab-above",60484),keyboardTabBelow:o("keyboard-tab-below",60485),gitPullRequestDone:o("git-pull-request-done",60486),mcp:o("mcp",60487),extensionsLarge:o("extensions-large",60488),layoutPanelDock:o("layout-panel-dock",60489),layoutSidebarLeftDock:o("layout-sidebar-left-dock",60490),layoutSidebarRightDock:o("layout-sidebar-right-dock",60491),copilotInProgress:o("copilot-in-progress",60492),copilotError:o("copilot-error",60493),copilotSuccess:o("copilot-success",60494),chatSparkle:o("chat-sparkle",60495),searchSparkle:o("search-sparkle",60496),editSparkle:o("edit-sparkle",60497),copilotSnooze:o("copilot-snooze",60498),sendToRemoteAgent:o("send-to-remote-agent",60499),commentDiscussionSparkle:o("comment-discussion-sparkle",60500),chatSparkleWarning:o("chat-sparkle-warning",60501),chatSparkleError:o("chat-sparkle-error",60502),collection:o("collection",60503),newCollection:o("new-collection",60504),thinking:o("thinking",60505),build:o("build",60506),commentDiscussionQuote:o("comment-discussion-quote",60507),cursor:o("cursor",60508),eraser:o("eraser",60509),fileText:o("file-text",60510),quotes:o("quotes",60512),rename:o("rename",60513),runWithDeps:o("run-with-deps",60514),debugConnected:o("debug-connected",60515),strikethrough:o("strikethrough",60516),openInProduct:o("open-in-product",60517),indexZero:o("index-zero",60518),agent:o("agent",60519),editCode:o("edit-code",60520),repoSelected:o("repo-selected",60521),skip:o("skip",60522),mergeInto:o("merge-into",60523),gitBranchChanges:o("git-branch-changes",60524),gitBranchStagedChanges:o("git-branch-staged-changes",60525),gitBranchConflicts:o("git-branch-conflicts",60526),gitBranch:o("git-branch",60527),gitBranchCreate:o("git-branch-create",60527),gitBranchDelete:o("git-branch-delete",60527),searchLarge:o("search-large",60528),terminalGitBash:o("terminal-git-bash",60529),windowActive:o("window-active",60530),forward:o("forward",60531),download:o("download",60532),clockface:o("clockface",60533),unarchive:o("unarchive",60534),sessionInProgress:o("session-in-progress",60535),collectionSmall:o("collection-small",60536),vmSmall:o("vm-small",60537),cloudSmall:o("cloud-small",60538),addSmall:o("add-small",60539),removeSmall:o("remove-small",60540),worktreeSmall:o("worktree-small",60541),worktree:o("worktree",60542),screenCut:o("screen-cut",60543),ask:o("ask",60544),openai:o("openai",60545),claude:o("claude",60546),openInWindow:o("open-in-window",60547)};var ha={dialogError:o("dialog-error","error"),dialogWarning:o("dialog-warning","warning"),dialogInfo:o("dialog-info","info"),dialogClose:o("dialog-close","close"),treeItemExpanded:o("tree-item-expanded","chevron-down"),treeFilterOnTypeOn:o("tree-filter-on-type-on","list-filter"),treeFilterOnTypeOff:o("tree-filter-on-type-off","list-selection"),treeFilterClear:o("tree-filter-clear","close"),treeItemLoading:o("tree-item-loading","loading"),menuSelection:o("menu-selection","check"),menuSubmenu:o("menu-submenu","chevron-right"),menuBarMore:o("menubar-more","more"),scrollbarButtonLeft:o("scrollbar-button-left","triangle-left"),scrollbarButtonRight:o("scrollbar-button-right","triangle-right"),scrollbarButtonUp:o("scrollbar-button-up","triangle-up"),scrollbarButtonDown:o("scrollbar-button-down","triangle-down"),toolBarMore:o("toolbar-more","more"),quickInputBack:o("quick-input-back","arrow-left"),dropDownButton:o("drop-down-button",60084),symbolCustomColor:o("symbol-customcolor",60252),exportIcon:o("export",60332),workspaceUnspecified:o("workspace-unspecified",60355),newLine:o("newline",60394),thumbsDownFilled:o("thumbsdown-filled",60435),thumbsUpFilled:o("thumbsup-filled",60436),gitFetch:o("git-fetch",60445),lightbulbSparkleAutofix:o("lightbulb-sparkle-autofix",60447),debugBreakpointPending:o("debug-breakpoint-pending",60377)},T={...yo,...ha};var fn=class{constructor(){this._tokenizationSupports=new Map;this._factories=new Map;this._onDidChange=new $;this.onDidChange=this._onDidChange.event;this._colorMap=null}handleChange(e){this._onDidChange.fire({changedLanguages:e,changedColorMap:!1})}register(e,t){return this._tokenizationSupports.set(e,t),this.handleChange([e]),ie(()=>{this._tokenizationSupports.get(e)===t&&(this._tokenizationSupports.delete(e),this.handleChange([e]))})}get(e){return this._tokenizationSupports.get(e)||null}registerFactory(e,t){this._factories.get(e)?.dispose();let n=new Ir(this,e,t);return this._factories.set(e,n),ie(()=>{let i=this._factories.get(e);!i||i!==n||(this._factories.delete(e),i.dispose())})}async getOrCreate(e){let t=this.get(e);if(t)return t;let n=this._factories.get(e);return!n||n.isResolved?null:(await n.resolve(),this.get(e))}isResolved(e){if(this.get(e))return!0;let n=this._factories.get(e);return!!(!n||n.isResolved)}setColorMap(e){this._colorMap=e,this._onDidChange.fire({changedLanguages:Array.from(this._tokenizationSupports.keys()),changedColorMap:!0})}getColorMap(){return this._colorMap}getDefaultBackground(){return this._colorMap&&this._colorMap.length>2?this._colorMap[2]:null}},Ir=class extends K{constructor(t,n,i){super();this._registry=t;this._languageId=n;this._factory=i;this._isDisposed=!1;this._resolvePromise=null;this._isResolved=!1}get isResolved(){return this._isResolved}dispose(){this._isDisposed=!0,super.dispose()}async resolve(){return this._resolvePromise||(this._resolvePromise=this._create()),this._resolvePromise}async _create(){let t=await this._factory.tokenizationSupport;this._isResolved=!0,t&&!this._isDisposed&&this._register(this._registry.register(this._languageId,t))}};var Ge=class{constructor(e,t,n){this.tokens=e;this.fontInfo=t;this.endState=n;this._encodedTokenizationResultBrand=void 0}};var ga;(s=>{let r=new Map;r.set(0,T.symbolMethod),r.set(1,T.symbolFunction),r.set(2,T.symbolConstructor),r.set(3,T.symbolField),r.set(4,T.symbolVariable),r.set(5,T.symbolClass),r.set(6,T.symbolStruct),r.set(7,T.symbolInterface),r.set(8,T.symbolModule),r.set(9,T.symbolProperty),r.set(10,T.symbolEvent),r.set(11,T.symbolOperator),r.set(12,T.symbolUnit),r.set(13,T.symbolValue),r.set(15,T.symbolEnum),r.set(14,T.symbolConstant),r.set(15,T.symbolEnum),r.set(16,T.symbolEnumMember),r.set(17,T.symbolKeyword),r.set(28,T.symbolSnippet),r.set(18,T.symbolText),r.set(19,T.symbolColor),r.set(20,T.symbolFile),r.set(21,T.symbolReference),r.set(22,T.symbolCustomColor),r.set(23,T.symbolFolder),r.set(24,T.symbolTypeParameter),r.set(25,T.account),r.set(26,T.issues),r.set(27,T.tools);function e(a){let l=r.get(a);return l||(console.info("No codicon found for CompletionItemKind "+a),l=T.symbolProperty),l}s.toIcon=e;function t(a){switch(a){case 0:return x(886,null);case 1:return x(882,null);case 2:return x(874,null);case 3:return x(879,null);case 4:return x(899,null);case 5:return x(871,null);case 6:return x(892,null);case 7:return x(883,null);case 8:return x(887,null);case 9:return x(889,null);case 10:return x(878,null);case 11:return x(888,null);case 12:return x(896,null);case 13:return x(898,null);case 14:return x(873,null);case 15:return x(876,null);case 16:return x(877,null);case 17:return x(885,null);case 18:return x(893,null);case 19:return x(872,null);case 20:return x(880,null);case 21:return x(890,null);case 22:return x(875,null);case 23:return x(881,null);case 24:return x(895,null);case 25:return x(897,null);case 26:return x(884,null);case 27:return x(894,null);case 28:return x(891,null);default:return""}}s.toLabel=t;let n=new Map;n.set("method",0),n.set("function",1),n.set("constructor",2),n.set("field",3),n.set("variable",4),n.set("class",5),n.set("struct",6),n.set("interface",7),n.set("module",8),n.set("property",9),n.set("event",10),n.set("operator",11),n.set("unit",12),n.set("value",13),n.set("constant",14),n.set("enum",15),n.set("enum-member",16),n.set("enumMember",16),n.set("keyword",17),n.set("snippet",28),n.set("text",18),n.set("color",19),n.set("file",20),n.set("reference",21),n.set("customcolor",22),n.set("folder",23),n.set("type-parameter",24),n.set("typeParameter",24),n.set("account",25),n.set("issue",26),n.set("tool",27);function i(a,l){let u=n.get(a);return typeof u>"u"&&!l&&(u=9),u}s.fromString=i})(ga||={});var Lm={17:x(847,null),16:x(848,null),4:x(849,null),13:x(850,null),8:x(851,null),9:x(852,null),21:x(853,null),23:x(854,null),7:x(855,null),0:x(856,null),11:x(857,null),10:x(858,null),19:x(859,null),5:x(860,null),1:x(861,null),2:x(862,null),20:x(863,null),15:x(864,null),18:x(865,null),24:x(866,null),3:x(867,null),6:x(868,null),14:x(869,null),22:x(870,null),25:x(901,null),12:x(902,null)};var va;(i=>{let r=new Map;r.set(0,T.symbolFile),r.set(1,T.symbolModule),r.set(2,T.symbolNamespace),r.set(3,T.symbolPackage),r.set(4,T.symbolClass),r.set(5,T.symbolMethod),r.set(6,T.symbolProperty),r.set(7,T.symbolField),r.set(8,T.symbolConstructor),r.set(9,T.symbolEnum),r.set(10,T.symbolInterface),r.set(11,T.symbolFunction),r.set(12,T.symbolVariable),r.set(13,T.symbolConstant),r.set(14,T.symbolString),r.set(15,T.symbolNumber),r.set(16,T.symbolBoolean),r.set(17,T.symbolArray),r.set(18,T.symbolObject),r.set(19,T.symbolKey),r.set(20,T.symbolNull),r.set(21,T.symbolEnumMember),r.set(22,T.symbolStruct),r.set(23,T.symbolEvent),r.set(24,T.symbolOperator),r.set(25,T.symbolTypeParameter);function e(s){let a=r.get(s);return a||(console.info("No codicon found for SymbolKind "+s),a=T.symbolProperty),a}i.toIcon=e;let t=new Map;t.set(0,20),t.set(1,8),t.set(2,8),t.set(3,8),t.set(4,5),t.set(5,0),t.set(6,9),t.set(7,3),t.set(8,2),t.set(9,15),t.set(10,7),t.set(11,1),t.set(12,4),t.set(13,14),t.set(14,18),t.set(15,13),t.set(16,13),t.set(17,13),t.set(18,13),t.set(19,17),t.set(20,13),t.set(21,16),t.set(22,6),t.set(23,10),t.set(24,11),t.set(25,24);function n(s){let a=t.get(s);return a===void 0&&(console.info("No completion kind found for SymbolKind "+s),a=20),a}i.toCompletionKind=n})(va||={});var Io=class r{constructor(e){this.value=e}static{this.Comment=new r("comment")}static{this.Imports=new r("imports")}static{this.Region=new r("region")}static fromValue(e){switch(e){case"comment":return r.Comment;case"imports":return r.Imports;case"region":return r.Region}return new r(e)}};var Ta;(e=>{function r(t){return!t||typeof t!="object"?!1:typeof t.id=="string"&&typeof t.title=="string"}e.is=r})(Ta||={});var Om=new fn;var Ia=new class{clone(){return this}equals(r){return this===r}};function kr(r,e){let t=new Uint32Array(2);return t[0]=0,t[1]=(r<<0|0|0|32768|2<<24)>>>0,new Ge(t,[],e===null?Ia:e)}var pn=class{constructor(e){this._default=e;this._store=[]}get(e){return e<this._store.length?this._store[e]:this._default}set(e,t){for(;e>=this._store.length;)this._store[this._store.length]=this._default;this._store[e]=t}replace(e,t,n){if(e>=this._store.length)return;if(t===0){this.insert(e,n);return}else if(n===0){this.delete(e,t);return}let i=this._store.slice(0,e),s=this._store.slice(e+t),a=ka(n,this._default);this._store=i.concat(a,s)}delete(e,t){t===0||e>=this._store.length||this._store.splice(e,t)}insert(e,t){if(t===0||e>=this._store.length)return;let n=[];for(let i=0;i<t;i++)n[i]=this._default;this._store=Tt(this._store,e,n)}};function ka(r,e){let t=[];for(let n=0;n<r;n++)t[n]=e;return t}var Xm=new Ae(()=>new Uint8Array(256));function lt(r,e){return r[e]*2**24+r[e+1]*2**16+r[e+2]*2**8+r[e+3]}function ut(r,e,t){r[t+3]=e,e=e>>>8,r[t+2]=e,e=e>>>8,r[t+1]=e,e=e>>>8,r[t]=e}var we=class r{constructor(e,t,n){this._lineTokensBrand=void 0;(e.length>1?e[e.length-2]:0)!==t.length&&W(new Error("Token length and text length do not match!")),this._tokens=e,this._tokensCount=this._tokens.length>>>1,this._text=t,this.languageIdCodec=n}static createEmpty(e,t){let n=r.defaultTokenMetadata,i=new Uint32Array(2);return i[0]=e.length,i[1]=n,new r(i,e,t)}static createFromTextAndMetadata(e,t){let n=0,i="",s=new Array;for(let{text:a,metadata:l}of e)s.push(n+a.length,l),n+=a.length,i+=a;return new r(new Uint32Array(s),i,t)}static convertToEndOffset(e,t){let i=(e.length>>>1)-1;for(let s=0;s<i;s++)e[s<<1]=e[s+1<<1];e[i<<1]=t}static findIndexInTokensArray(e,t){if(e.length<=2)return 0;let n=0,i=(e.length>>>1)-1;for(;n<i;){let s=n+Math.floor((i-n)/2),a=e[s<<1];if(a===t)return s+1;a<t?n=s+1:a>t&&(i=s)}return n}static{this.defaultTokenMetadata=(32768|2<<24)>>>0}getTextLength(){return this._text.length}equals(e){return e instanceof r?this.slicedEquals(e,0,this._tokensCount):!1}slicedEquals(e,t,n){if(this._text!==e._text||this._tokensCount!==e._tokensCount)return!1;let i=t<<1,s=i+(n<<1);for(let a=i;a<s;a++)if(this._tokens[a]!==e._tokens[a])return!1;return!0}getLineContent(){return this._text}getCount(){return this._tokensCount}getStartOffset(e){return e>0?this._tokens[e-1<<1]:0}getMetadata(e){return this._tokens[(e<<1)+1]}getLanguageId(e){let t=this._tokens[(e<<1)+1],n=me.getLanguageId(t);return this.languageIdCodec.decodeLanguageId(n)}getStandardTokenType(e){let t=this._tokens[(e<<1)+1];return me.getTokenType(t)}getForeground(e){let t=this._tokens[(e<<1)+1];return me.getForeground(t)}getClassName(e){let t=this._tokens[(e<<1)+1];return me.getClassNameFromMetadata(t)}getInlineStyle(e,t){let n=this._tokens[(e<<1)+1];return me.getInlineStyleFromMetadata(n,t)}getPresentation(e){let t=this._tokens[(e<<1)+1];return me.getPresentationFromMetadata(t)}getEndOffset(e){return this._tokens[e<<1]}findTokenIndexAtOffset(e){return r.findIndexInTokensArray(this._tokens,e)}inflate(){return this}sliceAndInflate(e,t,n){return new Sr(this,e,t,n)}sliceZeroCopy(e){return this.sliceAndInflate(e.start,e.endExclusive,0)}withInserted(e){if(e.length===0)return this;let t=0,n=0,i="",s=new Array,a=0;for(;;){let l=t<this._tokensCount?this._tokens[t<<1]:-1,u=n<e.length?e[n]:null;if(l!==-1&&(u===null||l<=u.offset)){i+=this._text.substring(a,l);let d=this._tokens[(t<<1)+1];s.push(i.length,d),t++,a=l}else if(u){if(u.offset>a){i+=this._text.substring(a,u.offset);let d=this._tokens[(t<<1)+1];s.push(i.length,d),a=u.offset}i+=u.text,s.push(i.length,u.tokenMetadata),n++}else break}return new r(new Uint32Array(s),i,this.languageIdCodec)}getTokensInRange(e){let t=new wr,n=this.findTokenIndexAtOffset(e.start),i=this.findTokenIndexAtOffset(e.endExclusive);for(let s=n;s<=i;s++){let l=new U(this.getStartOffset(s),this.getEndOffset(s)).intersectionLength(e);l>0&&t.add(l,this.getMetadata(s))}return t.build()}getTokenText(e){let t=this.getStartOffset(e),n=this.getEndOffset(e);return this._text.substring(t,n)}forEach(e){let t=this.getCount();for(let n=0;n<t;n++)e(n)}toString(){let e="";return this.forEach(t=>{e+=`[${this.getTokenText(t)}]{${this.getClassName(t)}}`}),e}},Sr=class r{constructor(e,t,n,i){this._source=e,this._startOffset=t,this._endOffset=n,this._deltaOffset=i,this._firstTokenIndex=e.findTokenIndexAtOffset(t),this.languageIdCodec=e.languageIdCodec,this._tokensCount=0;for(let s=this._firstTokenIndex,a=e.getCount();s<a&&!(e.getStartOffset(s)>=n);s++)this._tokensCount++}getMetadata(e){return this._source.getMetadata(this._firstTokenIndex+e)}getLanguageId(e){return this._source.getLanguageId(this._firstTokenIndex+e)}getLineContent(){return this._source.getLineContent().substring(this._startOffset,this._endOffset)}equals(e){return e instanceof r?this._startOffset===e._startOffset&&this._endOffset===e._endOffset&&this._deltaOffset===e._deltaOffset&&this._source.slicedEquals(e._source,this._firstTokenIndex,this._tokensCount):!1}getCount(){return this._tokensCount}getStandardTokenType(e){return this._source.getStandardTokenType(this._firstTokenIndex+e)}getForeground(e){return this._source.getForeground(this._firstTokenIndex+e)}getEndOffset(e){let t=this._source.getEndOffset(this._firstTokenIndex+e);return Math.min(this._endOffset,t)-this._startOffset+this._deltaOffset}getClassName(e){return this._source.getClassName(this._firstTokenIndex+e)}getInlineStyle(e,t){return this._source.getInlineStyle(this._firstTokenIndex+e,t)}getPresentation(e){return this._source.getPresentation(this._firstTokenIndex+e)}findTokenIndexAtOffset(e){return this._source.findTokenIndexAtOffset(e+this._startOffset-this._deltaOffset)-this._firstTokenIndex}getTokenText(e){let t=this._firstTokenIndex+e,n=this._source.getStartOffset(t),i=this._source.getEndOffset(t),s=this._source.getTokenText(t);return n<this._startOffset&&(s=s.substring(this._startOffset-n)),i>this._endOffset&&(s=s.substring(0,s.length-(i-this._endOffset))),s}forEach(e){for(let t=0;t<this.getCount();t++)e(t)}};var Er=class r{constructor(e){this._tokenInfo=e}static fromLineTokens(e){let t=[];for(let n=0;n<e.getCount();n++)t.push(new Ot(e.getEndOffset(n)-e.getStartOffset(n),e.getMetadata(n)));return r.create(t)}static create(e){return new r(e)}toLineTokens(e,t){return we.createFromTextAndMetadata(this.map((n,i)=>({text:n.substring(e),metadata:i.metadata})),t)}forEach(e){let t=0;for(let n of this._tokenInfo){let i=new U(t,t+n.length);e(i,n),t+=n.length}}map(e){let t=[],n=0;for(let i of this._tokenInfo){let s=new U(n,n+i.length);t.push(e(s,i)),n+=i.length}return t}slice(e){let t=[],n=0;for(let i of this._tokenInfo){let s=n,a=s+i.length;if(a>e.start){if(s>=e.endExclusive)break;let l=Math.max(0,e.start-s),u=Math.max(0,a-e.endExclusive);t.push(new Ot(i.length-l-u,i.metadata))}n+=i.length}return r.create(t)}append(e){let t=this._tokenInfo.concat(e._tokenInfo);return r.create(t)}},Ot=class{constructor(e,t){this.length=e;this.metadata=t}},wr=class{constructor(){this._tokens=[]}add(e,t){this._tokens.push(new Ot(e,t))}build(){return Er.create(this._tokens)}};var Qe=new Uint32Array(0).buffer,ce=class r{static deleteBeginning(e,t){return e===null||e===Qe?e:r.delete(e,0,t)}static deleteEnding(e,t){if(e===null||e===Qe)return e;let n=Dt(e),i=n[n.length-2];return r.delete(e,t,i)}static delete(e,t,n){if(e===null||e===Qe||t===n)return e;let i=Dt(e),s=i.length>>>1;if(t===0&&i[i.length-2]===n)return Qe;let a=we.findIndexInTokensArray(i,t),l=a>0?i[a-1<<1]:0,u=i[a<<1];if(n<u){let k=n-t;for(let A=a;A<s;A++)i[A<<1]-=k;return e}let d,f;l!==t?(i[a<<1]=t,d=a+1<<1,f=t):(d=a<<1,f=l);let c=n-t;for(let k=a+1;k<s;k++){let A=i[k<<1]-c;A>f&&(i[d++]=A,i[d++]=i[(k<<1)+1],f=A)}if(d===i.length)return e;let b=new Uint32Array(d);return b.set(i.subarray(0,d),0),b.buffer}static append(e,t){if(t===Qe)return e;if(e===Qe)return t;if(e===null)return e;if(t===null)return null;let n=Dt(e),i=Dt(t),s=i.length>>>1,a=new Uint32Array(n.length+i.length);a.set(n,0);let l=n.length,u=n[n.length-2];for(let d=0;d<s;d++)a[l++]=i[d<<1]+u,a[l++]=i[(d<<1)+1];return a.buffer}static insert(e,t,n){if(e===null||e===Qe)return e;let i=Dt(e),s=i.length>>>1,a=we.findIndexInTokensArray(i,t);a>0&&i[a-1<<1]===t&&a--;for(let l=a;l<s;l++)i[l<<1]+=n;return e}};function Dt(r){return r instanceof Uint32Array?r:new Uint32Array(r)}var At=class r{static deserialize(e,t,n){let i=new Uint32Array(e.buffer),s=lt(e,t);t+=4;let a=lt(e,t);t+=4;let l=[];for(let u=0;u<a;u++){let d=lt(e,t);t+=4,l.push(i.subarray(t/4,t/4+d/4)),t+=d}return n.push(new r(s,l)),t}get startLineNumber(){return this._startLineNumber}get endLineNumber(){return this._startLineNumber+this._tokens.length-1}constructor(e,t){this._startLineNumber=e,this._tokens=t}getLineRange(){return new de(this._startLineNumber,this._startLineNumber+this._tokens.length)}getLineTokens(e){return this._tokens[e-this._startLineNumber]}appendLineTokens(e){this._tokens.push(e)}serializeSize(){let e=0;e+=4,e+=4;for(let t=0;t<this._tokens.length;t++){let n=this._tokens[t];if(!(n instanceof Uint32Array))throw new Error("Not supported!");e+=4,e+=n.byteLength}return e}serialize(e,t){ut(e,this._startLineNumber,t),t+=4,ut(e,this._tokens.length,t),t+=4;for(let n=0;n<this._tokens.length;n++){let i=this._tokens[n];if(!(i instanceof Uint32Array))throw new Error("Not supported!");ut(e,i.byteLength,t),t+=4,e.set(new Uint8Array(i.buffer),t),t+=i.byteLength}return t}applyEdit(e,t){let[n,i]=Lt(t);this._acceptDeleteRange(e),this._acceptInsertText(new Ee(e.startLineNumber,e.startColumn),n,i)}_acceptDeleteRange(e){if(e.startLineNumber===e.endLineNumber&&e.startColumn===e.endColumn)return;let t=e.startLineNumber-this._startLineNumber,n=e.endLineNumber-this._startLineNumber;if(n<0){let i=n-t;this._startLineNumber-=i;return}if(!(t>=this._tokens.length)){if(t<0&&n>=this._tokens.length){this._startLineNumber=0,this._tokens=[];return}if(t===n){this._tokens[t]=ce.delete(this._tokens[t],e.startColumn-1,e.endColumn-1);return}if(t>=0)if(this._tokens[t]=ce.deleteEnding(this._tokens[t],e.startColumn-1),n<this._tokens.length){let i=ce.deleteBeginning(this._tokens[n],e.endColumn-1);this._tokens[t]=ce.append(this._tokens[t],i),this._tokens.splice(t+1,n-t)}else this._tokens[t]=ce.append(this._tokens[t],null),this._tokens=this._tokens.slice(0,t+1);else{let i=-t;this._startLineNumber-=i,this._tokens[n]=ce.deleteBeginning(this._tokens[n],e.endColumn-1),this._tokens=this._tokens.slice(n)}}}_acceptInsertText(e,t,n){if(t===0&&n===0)return;let i=e.lineNumber-this._startLineNumber;if(i<0){this._startLineNumber+=t;return}if(!(i>=this._tokens.length)){if(t===0){this._tokens[i]=ce.insert(this._tokens[i],e.column-1,n);return}this._tokens[i]=ce.deleteEnding(this._tokens[i],e.column-1),this._tokens[i]=ce.insert(this._tokens[i],e.column-1,n),this._insertLines(e.lineNumber,t)}}_insertLines(e,t){if(t===0)return;let n=[];for(let i=0;i<t;i++)n[i]=null;this._tokens=Tt(this._tokens,e,n)}};var Ct=class{static deserialize(e){let t=0,n=lt(e,t);t+=4;let i=[];for(let s=0;s<n;s++)t=At.deserialize(e,t,i);return i}constructor(){this._tokens=[]}add(e,t){if(this._tokens.length>0){let n=this._tokens[this._tokens.length-1];if(n.endLineNumber+1===e){n.appendLineTokens(t);return}}this._tokens.push(new At(e,[t]))}finalize(){return this._tokens}serialize(){let e=this._serializeSize(),t=new Uint8Array(e);return this._serialize(t),t}_serializeSize(){let e=0;e+=4;for(let t=0;t<this._tokens.length;t++)e+=this._tokens[t].serializeSize();return e}_serialize(e){let t=0;ut(e,this._tokens.length,t),t+=4;for(let n=0;n<this._tokens.length;n++)t=this._tokens[n].serialize(e,t)}};var mn=class{constructor(e,t){this.tokenizationSupport=t;this.initialState=this.tokenizationSupport.getInitialState(),this.store=new Rr(e)}getStartState(e){return this.store.getStartState(e,this.initialState)}getFirstInvalidLine(){return this.store.getFirstInvalidLine(this.initialState)}};var Rr=class{constructor(e){this.lineCount=e;this._tokenizationStateStore=new Lr;this._invalidEndStatesLineNumbers=new Or;this._invalidEndStatesLineNumbers.addRange(new U(1,e+1))}getEndState(e){return this._tokenizationStateStore.getEndState(e)}setEndState(e,t){if(!t)throw new w("Cannot set null/undefined state");this._invalidEndStatesLineNumbers.delete(e);let n=this._tokenizationStateStore.setEndState(e,t);return n&&e<this.lineCount&&this._invalidEndStatesLineNumbers.addRange(new U(e+1,e+2)),n}acceptChange(e,t){this.lineCount+=t-e.length,this._tokenizationStateStore.acceptChange(e,t),this._invalidEndStatesLineNumbers.addRangeAndResize(new U(e.startLineNumber,e.endLineNumberExclusive),t)}acceptChanges(e){for(let t of e){let[n]=Lt(t.text);this.acceptChange(new de(t.range.startLineNumber,t.range.endLineNumber+1),n+1)}}invalidateEndStateRange(e){this._invalidEndStatesLineNumbers.addRange(new U(e.startLineNumber,e.endLineNumberExclusive))}getFirstInvalidEndStateLineNumber(){return this._invalidEndStatesLineNumbers.min}getFirstInvalidEndStateLineNumberOrMax(){return this.getFirstInvalidEndStateLineNumber()||Number.MAX_SAFE_INTEGER}allStatesValid(){return this._invalidEndStatesLineNumbers.min===null}getStartState(e,t){return e===1?t:this.getEndState(e-1)}getFirstInvalidLine(e){let t=this.getFirstInvalidEndStateLineNumber();if(t===null)return null;let n=this.getStartState(t,e);if(!n)throw new w("Start state must be defined");return{lineNumber:t,startState:n}}},Lr=class{constructor(){this._lineEndStates=new pn(null)}getEndState(e){return this._lineEndStates.get(e)}setEndState(e,t){let n=this._lineEndStates.get(e);return n&&n.equals(t)?!1:(this._lineEndStates.set(e,t),!0)}acceptChange(e,t){let n=e.length;t>0&&n>0&&(n--,t--),this._lineEndStates.replace(e.startLineNumber,n,t)}acceptChanges(e){for(let t of e){let[n]=Lt(t.text);this.acceptChange(new de(t.range.startLineNumber,t.range.endLineNumber+1),n+1)}}},Or=class{constructor(){this._ranges=[]}getRanges(){return this._ranges}get min(){return this._ranges.length===0?null:this._ranges[0].start}removeMin(){if(this._ranges.length===0)return null;let e=this._ranges[0];return e.start+1===e.endExclusive?this._ranges.shift():this._ranges[0]=new U(e.start+1,e.endExclusive),e.start}delete(e){let t=this._ranges.findIndex(n=>n.contains(e));if(t!==-1){let n=this._ranges[t];n.start===e?n.endExclusive===e+1?this._ranges.splice(t,1):this._ranges[t]=new U(e+1,n.endExclusive):n.endExclusive===e+1?this._ranges[t]=new U(n.start,e):this._ranges.splice(t,1,new U(n.start,e),new U(e+1,n.endExclusive))}}addRange(e){U.addRange(e,this._ranges)}addRangeAndResize(e,t){let n=0;for(;!(n>=this._ranges.length||e.start<=this._ranges[n].endExclusive);)n++;let i=n;for(;!(i>=this._ranges.length||e.endExclusive<this._ranges[i].start);)i++;let s=t-e.length;for(let a=i;a<this._ranges.length;a++)this._ranges[a]=this._ranges[a].delta(s);if(n===i){let a=new U(e.start,e.start+t);a.isEmpty||this._ranges.splice(n,0,a)}else{let a=Math.min(e.start,this._ranges[n].start),l=Math.max(e.endExclusive,this._ranges[i-1].endExclusive),u=new U(a,l+s);u.isEmpty?this._ranges.splice(n,i-n):this._ranges.splice(n,i-n,u)}}toString(){return this._ranges.map(e=>e.toString()).join(" + ")}};var bn=class extends K{constructor(t,n,i,s,a,l,u){super();this._grammar=t;this._initialState=n;this._containsEmbeddedLanguages=i;this._createBackgroundTokenizer=s;this._backgroundTokenizerShouldOnlyVerifyTokens=a;this._reportTokenizationTime=l;this._reportSlowTokenization=u;this._seenLanguages=[];this._onDidEncounterLanguage=this._register(new $)}get onDidEncounterLanguage(){return this._onDidEncounterLanguage.event}get backgroundTokenizerShouldOnlyVerifyTokens(){return this._backgroundTokenizerShouldOnlyVerifyTokens()}getInitialState(){return this._initialState}tokenize(t,n,i){throw new Error("Not supported!")}createBackgroundTokenizer(t,n){if(this._createBackgroundTokenizer)return this._createBackgroundTokenizer(t,n)}tokenizeEncoded(t,n,i){let s=Math.random()*1e4<1,a=this._reportSlowTokenization||s,l=a?new We(!0):void 0,u=this._grammar.tokenizeLine2(t,i,500);if(a){let f=l.elapsed();(s||f>32)&&this._reportTokenizationTime(f,t.length,s)}if(u.stoppedEarly)return console.warn(`Time limit reached when tokenizing line: ${t.substring(0,100)}`),new Ge(u.tokens,u.fonts,i);if(this._containsEmbeddedLanguages){let f=this._seenLanguages,c=u.tokens;for(let b=0,k=c.length>>>1;b<k;b++){let A=c[(b<<1)+1],M=me.getLanguageId(A);f[M]||(f[M]=!0,this._onDidEncounterLanguage.fire(M))}}let d;return i.equals(u.ruleStack)?d=i:d=u.ruleStack,new Ge(u.tokens,u.fonts,d)}};var hn=class extends K{constructor(t,n,i,s){super();this._encodedLanguageId=t;this._actual=n;this._maxTokenizationLineLength=s;this._register(rn(this._maxTokenizationLineLength)),this._register(i)}get backgroundTokenizerShouldOnlyVerifyTokens(){return this._actual.backgroundTokenizerShouldOnlyVerifyTokens}getInitialState(){return this._actual.getInitialState()}tokenize(t,n,i){throw new Error("Not supported!")}tokenizeEncoded(t,n,i){return t.length>=this._maxTokenizationLineLength.get()?kr(this._encodedLanguageId,i):this._actual.tokenizeEncoded(t,n,i)}createBackgroundTokenizer(t,n){if(this._actual.createBackgroundTokenizer)return this._actual.createBackgroundTokenizer(t,n)}};function ko(){return r=>({fontFamily:r.fontFamily??"",fontSizeMultiplier:r.fontSizeMultiplier??0,lineHeightMultiplier:r.lineHeightMultiplier??0})}var Dr=class r{constructor(e=[]){this._annotations=[];this._annotations=e}setAnnotations(e){for(let t of e.annotations){let n=this._getStartIndexOfIntersectingAnnotation(t.range.start),i=this._getEndIndexOfIntersectingAnnotation(t.range.endExclusive);t.annotation!==void 0?this._annotations.splice(n,i-n,{range:t.range,annotation:t.annotation}):this._annotations.splice(n,i-n)}}getAnnotationsIntersecting(e){let t=this._getStartIndexOfIntersectingAnnotation(e.start),n=this._getEndIndexOfIntersectingAnnotation(e.endExclusive);return this._annotations.slice(t,n)}_getStartIndexOfIntersectingAnnotation(e){let t=Mn(this._annotations.length,i=>this._annotations[i].range.start-e),n;if(t>=0){n=t;let i=this._annotations[n]?.range;i&&i.endExclusive===e&&n--}else{let i=this._annotations[-(t+2)]?.range;i&&e>=i.start&&e<i.endExclusive?n=-(t+2):n=-(t+1)}return n}_getEndIndexOfIntersectingAnnotation(e){let t=Mn(this._annotations.length,i=>this._annotations[i].range.endExclusive-e),n;if(t>=0){n=t+1;let i=this._annotations[n]?.range;i&&i.start===e&&n++}else{let i=this._annotations[-(t+1)]?.range;i&&e>=i.start&&e<=i.endExclusive?n=-t:n=-(t+1)}return n}getAllAnnotations(){return this._annotations.slice()}applyEdit(e){let t=this._annotations.slice(),n=[],i=[],s=0;for(let a of e.replacements){for(;;){let u=t[0];if(!u)break;let d=u.range;if(d.endExclusive>=a.replaceRange.start)break;t.shift();let f={range:d.delta(s),annotation:u.annotation};f.range.isEmpty?i.push(f):n.push(f)}let l=[];for(;;){let u=t[0];if(!u||!u.range.intersectsOrTouches(a.replaceRange))break;t.shift(),l.push(u)}for(let u=l.length-1;u>=0;u--){let d=l[u],f=d.range,c=u===0&&a.replaceRange.endExclusive>f.start&&a.replaceRange.start<f.endExclusive,b=f.intersect(a.replaceRange).length;f=f.deltaEnd(-b+(c?a.newText.length:0));let k=f.start-a.replaceRange.start;k>0&&(f=f.delta(-k)),!c&&k>=0&&(f=f.delta(a.newText.length)),f=f.delta(-(a.newText.length-a.replaceRange.length)),t.unshift({annotation:d.annotation,range:f})}s+=a.newText.length-a.replaceRange.length}for(;;){let a=t[0];if(!a)break;t.shift();let l={annotation:a.annotation,range:a.range.delta(s)};l.range.isEmpty?i.push(l):n.push(l)}return this._annotations=n,i}clone(){return new r(this._annotations.slice())}},gn=class r{static create(e){return new r(e)}constructor(e){this._annotations=e}get annotations(){return this._annotations}rebase(e){let t=new Dr(this._annotations);t.applyEdit(e),this._annotations=t.getAllAnnotations()}serialize(e){return this._annotations.map(t=>{let n={start:t.range.start,endExclusive:t.range.endExclusive};return t.annotation?{range:n,annotation:e(t.annotation)}:{range:n,annotation:void 0}})}static deserialize(e,t){let n=e.map(i=>{let s=new U(i.range.start,i.range.endExclusive);return i.annotation?{range:s,annotation:t(i.annotation)}:{range:s,annotation:void 0}});return new r(n)}};var vn=class extends cn{constructor(t,n,i,s,a,l,u,d){super(t,n,i,s);this._host=a;this._languageId=l;this._encodedLanguageId=u;this._tokenizerWithStateStore=null;this._isDisposed=!1;this._maxTokenizationLineLength=wt(this,-1);this._tokenizeDebouncer=new Zt(()=>this._tokenize(),10);this._maxTokenizationLineLength.set(d,void 0),this._resetTokenization()}dispose(){this._isDisposed=!0,this._tokenizeDebouncer.dispose(),super.dispose()}onLanguageId(t,n){this._languageId=t,this._encodedLanguageId=n,this._resetTokenization()}onEvents(t){super.onEvents(t),this._tokenizerWithStateStore?.store.acceptChanges(t.changes),this._tokenizeDebouncer.schedule()}acceptMaxTokenizationLineLength(t){this._maxTokenizationLineLength.set(t,void 0)}retokenize(t,n){this._tokenizerWithStateStore&&(this._tokenizerWithStateStore.store.invalidateEndStateRange(new de(t,n)),this._tokenizeDebouncer.schedule())}async _resetTokenization(){this._tokenizerWithStateStore=null;let t=this._languageId,n=this._encodedLanguageId,i=await this._host.getOrCreateGrammar(t,n);if(!(this._isDisposed||t!==this._languageId||n!==this._encodedLanguageId||!i)){if(i.grammar){let s=new hn(this._encodedLanguageId,new bn(i.grammar,i.initialState,!1,void 0,()=>!1,(a,l,u)=>{this._host.reportTokenizationTime(a,t,i.sourceExtensionId,l,u)},!1),K.None,this._maxTokenizationLineLength);this._tokenizerWithStateStore=new mn(this._lines.length,s)}else this._tokenizerWithStateStore=null;this._tokenize()}}async _tokenize(){if(this._isDisposed||!this._tokenizerWithStateStore)return;if(!this._diffStateStacksRefEqFn){let{diffStateStacksRefEq:n}=await kt("vscode-textmate","release/main.js");this._diffStateStacksRefEqFn=n}let t=new Date().getTime();for(;;){let n=0,i=new Ct,s=new Ar,a=[];for(;;){let c=this._tokenizerWithStateStore.getFirstInvalidLine();if(c===null||n>200)break;n++;let b=this._lines[c.lineNumber-1],k=this._tokenizerWithStateStore.tokenizationSupport.tokenizeEncoded(b,!0,c.startState);if(this._tokenizerWithStateStore.store.setEndState(c.lineNumber,k.endState)){let M=this._diffStateStacksRefEqFn(c.startState,k.endState);s.setState(c.lineNumber,M)}else s.setState(c.lineNumber,null);if(we.convertToEndOffset(k.tokens,b.length),i.add(c.lineNumber,k.tokens),a.push(...this._getFontTokensUpdate(c.lineNumber,k)),new Date().getTime()-t>20)break}if(n===0)break;let u=gn.create(a).serialize(ko()),d=s.getStateDeltas();if(this._host.setTokensAndStates(this._versionId,i.serialize(),u,d),new Date().getTime()-t>20){ft(()=>this._tokenize());return}}}_getFontTokensUpdate(t,n){let i=[],s=this._getOffsetAtLineStart(t),a=this._getOffsetAtLineStart(t+1),l=a>0?a-1:0;if(i.push({range:new U(s,l),annotation:void 0}),n.fontInfo.length)for(let u of n.fontInfo){let d=this._getOffsetAtLineStart(t);i.push({range:new U(d+u.startIndex,d+u.endIndex),annotation:{fontFamily:u.fontFamily??void 0,fontSizeMultiplier:u.fontSizeMultiplier??void 0,lineHeightMultiplier:u.lineHeightMultiplier??void 0}})}return i}_getOffsetAtLineStart(t){return this._ensureLineStarts(),t-1>0?this._lineStarts.getPrefixSum(t-2):0}},Ar=class{constructor(){this._lastStartLineNumber=-1;this._stateDeltas=[]}setState(e,t){e===this._lastStartLineNumber+1?this._stateDeltas[this._stateDeltas.length-1].stateDeltas.push(t):this._stateDeltas.push({startLineNumber:e,stateDeltas:[t]}),this._lastStartLineNumber=e}getStateDeltas(){return this._stateDeltas}};var Tn=class r{static{this.CHANNEL_NAME="textMateWorkerHost"}static getChannel(e){return e.getChannel(r.CHANNEL_NAME)}static setChannel(e,t){e.setChannel(r.CHANNEL_NAME,t)}};function So(r){return new Cr(r)}var Cr=class{constructor(e){this._requestHandlerBrand=void 0;this._models=new Map;this._grammarCache=[];this._grammarFactory=Promise.resolve(null);this._host=Tn.getChannel(e)}async $init(e){let t=e.grammarDefinitions.map(n=>({location:z.revive(n.location),language:n.language,scopeName:n.scopeName,embeddedLanguages:n.embeddedLanguages,tokenTypes:n.tokenTypes,injectTo:n.injectTo,balancedBracketSelectors:n.balancedBracketSelectors,unbalancedBracketSelectors:n.unbalancedBracketSelectors,sourceExtensionId:n.sourceExtensionId}));this._grammarFactory=this._loadTMGrammarFactory(t,e.onigurumaWASMUri)}async _loadTMGrammarFactory(e,t){let n=await kt("vscode-textmate","release/main.js"),i=await kt("vscode-oniguruma","release/main.js"),a=await(await fetch(t)).arrayBuffer();await i.loadWASM(a);let l=Promise.resolve({createOnigScanner:u=>i.createOnigScanner(u),createOnigString:u=>i.createOnigString(u)});return new Yt({logTrace:u=>{},logError:(u,d)=>console.error(u,d),readFile:u=>this._host.$readFile(u)},e,n,l)}$acceptNewModel(e){let t=z.revive(e.uri),n=this;this._models.set(e.controllerId,new vn(t,e.lines,e.EOL,e.versionId,{async getOrCreateGrammar(i,s){let a=await n._grammarFactory;return a?(n._grammarCache[s]||(n._grammarCache[s]=a.createGrammar(i,s)),n._grammarCache[s]):Promise.resolve(null)},setTokensAndStates(i,s,a,l){n._host.$setTokensAndStates(e.controllerId,i,s,a,l)},reportTokenizationTime(i,s,a,l,u){n._host.$reportTokenizationTime(i,s,a,l,u)}},e.languageId,e.encodedLanguageId,e.maxTokenizationLineLength))}$acceptModelChanged(e,t){this._models.get(e).onEvents(t)}$retokenize(e,t,n){this._models.get(e).retokenize(t,n)}$acceptModelLanguageChanged(e,t,n){this._models.get(e).onLanguageId(t,n)}$acceptRemovedModel(e){let t=this._models.get(e);t&&(t.dispose(),this._models.delete(e))}async $acceptTheme(e,t){(await this._grammarFactory)?.setTheme(e,t)}$acceptMaxTokenizationLineLength(e,t){this._models.get(e).acceptMaxTokenizationLineLength(t)}};var Pr="default",Ea="$initialize";var Nr=class{constructor(e,t,n,i,s){this.vsWorker=e;this.req=t;this.channel=n;this.method=i;this.args=s;this.type=0}},xn=class{constructor(e,t,n,i){this.vsWorker=e;this.seq=t;this.res=n;this.err=i;this.type=1}},Ur=class{constructor(e,t,n,i,s){this.vsWorker=e;this.req=t;this.channel=n;this.eventName=i;this.arg=s;this.type=2}},Mr=class{constructor(e,t,n){this.vsWorker=e;this.req=t;this.event=n;this.type=3}},Fr=class{constructor(e,t){this.vsWorker=e;this.req=t;this.type=4}},Vr=class{constructor(e){this._workerId=-1,this._handler=e,this._lastSentReq=0,this._pendingReplies=Object.create(null),this._pendingEmitters=new Map,this._pendingEvents=new Map}setWorkerId(e){this._workerId=e}async sendMessage(e,t,n){let i=String(++this._lastSentReq);return new Promise((s,a)=>{this._pendingReplies[i]={resolve:s,reject:a},this._send(new Nr(this._workerId,i,e,t,n))})}listen(e,t,n){let i=null,s=new $({onWillAddFirstListener:()=>{i=String(++this._lastSentReq),this._pendingEmitters.set(i,s),this._send(new Ur(this._workerId,i,e,t,n))},onDidRemoveLastListener:()=>{this._pendingEmitters.delete(i),this._send(new Fr(this._workerId,i)),i=null}});return s.event}handleMessage(e){!e||!e.vsWorker||this._workerId!==-1&&e.vsWorker!==this._workerId||this._handleMessage(e)}createProxyToRemoteChannel(e,t){let n={get:(i,s)=>(typeof s=="string"&&!i[s]&&(wo(s)?i[s]=a=>this.listen(e,s,a):Eo(s)?i[s]=this.listen(e,s,void 0):s.charCodeAt(0)===36&&(i[s]=async(...a)=>(await t?.(),this.sendMessage(e,s,a)))),i[s])};return new Proxy(Object.create(null),n)}_handleMessage(e){switch(e.type){case 1:return this._handleReplyMessage(e);case 0:return this._handleRequestMessage(e);case 2:return this._handleSubscribeEventMessage(e);case 3:return this._handleEventMessage(e);case 4:return this._handleUnsubscribeEventMessage(e)}}_handleReplyMessage(e){if(!this._pendingReplies[e.seq]){console.warn("Got reply to unknown seq");return}let t=this._pendingReplies[e.seq];if(delete this._pendingReplies[e.seq],e.err){let n=e.err;if(e.err.$isError){let i=new Error;i.name=e.err.name,i.message=e.err.message,i.stack=e.err.stack,n=i}t.reject(n);return}t.resolve(e.res)}_handleRequestMessage(e){let t=e.req;this._handler.handleMessage(e.channel,e.method,e.args).then(i=>{this._send(new xn(this._workerId,t,i,void 0))},i=>{i.detail instanceof Error&&(i.detail=Kt(i.detail)),this._send(new xn(this._workerId,t,void 0,Kt(i)))})}_handleSubscribeEventMessage(e){let t=e.req,n=this._handler.handleEvent(e.channel,e.eventName,e.arg)(i=>{this._send(new Mr(this._workerId,t,i))});this._pendingEvents.set(t,n)}_handleEventMessage(e){let t=this._pendingEmitters.get(e.req);if(t===void 0){console.warn("Got event for unknown req");return}t.fire(e.event)}_handleUnsubscribeEventMessage(e){let t=this._pendingEvents.get(e.req);if(t===void 0){console.warn("Got unsubscribe for unknown req");return}t.dispose(),this._pendingEvents.delete(e.req)}_send(e){let t=[];if(e.type===0)for(let n=0;n<e.args.length;n++){let i=e.args[n];i instanceof ArrayBuffer&&t.push(i)}else e.type===1&&e.res instanceof ArrayBuffer&&t.push(e.res);this._handler.sendMessage(e,t)}};function Eo(r){return r[0]==="o"&&r[1]==="n"&&Yn(r.charCodeAt(2))}function wo(r){return/^onDynamic/.test(r)&&Yn(r.charCodeAt(9))}var yn=class{constructor(e,t){this._localChannels=new Map;this._remoteChannels=new Map;this._protocol=new Vr({sendMessage:(n,i)=>{e(n,i)},handleMessage:(n,i,s)=>this._handleMessage(n,i,s),handleEvent:(n,i,s)=>this._handleEvent(n,i,s)}),this.requestHandler=t(this)}onmessage(e){this._protocol.handleMessage(e)}_handleMessage(e,t,n){if(e===Pr&&t===Ea)return this.initialize(n[0]);let i=e===Pr?this.requestHandler:this._localChannels.get(e);if(!i)return Promise.reject(new Error(`Missing channel ${e} on worker thread`));let s=i[t];if(typeof s!="function")return Promise.reject(new Error(`Missing method ${t} on worker thread channel ${e}`));try{return Promise.resolve(s.apply(i,n))}catch(a){return Promise.reject(a)}}_handleEvent(e,t,n){let i=e===Pr?this.requestHandler:this._localChannels.get(e);if(!i)throw new Error(`Missing channel ${e} on worker thread`);if(wo(t)){let s=i[t];if(typeof s!="function")throw new Error(`Missing dynamic event ${t} on request handler.`);let a=s.call(i,n);if(typeof a!="function")throw new Error(`Missing dynamic event ${t} on request handler.`);return a}if(Eo(t)){let s=i[t];if(typeof s!="function")throw new Error(`Missing event ${t} on request handler.`);return s}throw new Error(`Malformed event name ${t}`)}setChannel(e,t){this._localChannels.set(e,t)}getChannel(e){let t=this._remoteChannels.get(e);return t===void 0&&(t=this._protocol.createProxyToRemoteChannel(e),this._remoteChannels.set(e,t)),t}async initialize(e){this._protocol.setWorkerId(e)}};var Br=!1;function wa(r){if(Br)throw new Error("WebWorker already initialized!");Br=!0;let e=new yn(t=>globalThis.postMessage(t),t=>r(t));return globalThis.onmessage=t=>{e.onmessage(t.data)},e}function Ro(r){globalThis.onmessage=e=>{Br||wa(r)}}Ro(So);
//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/a2860d1c314872c0c8c436647d10856fdd15f2bc/core/vs/workbench/services/textMate/browser/backgroundTokenization/worker/textMateTokenizationWorker.workerMain.js.map
