"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
const index_buffer_1 = require("./index-buffer");
class IndexStream extends stream_1.Transform {
    constructor(requester, index, options) {
        super({
            objectMode: true,
            transform: (chunk, enc, cb) => __awaiter(this, void 0, void 0, function* () { return yield self.process(cb, chunk); }),
            flush: (cb) => __awaiter(this, void 0, void 0, function* () { return yield self.process(cb); }),
        });
        this.requester = requester;
        this.index = index;
        this.options = options;
        this.buffer = new index_buffer_1.IndexBuffer((data) => __awaiter(this, void 0, void 0, function* () {
            const resp = yield this.request({
                method: 'post',
                path: '/docs/index',
                headers: { 'content-type': 'application/json' },
                body: data,
            });
            return resp.result.value;
        }));
        const self = this;
    }
    request(req) {
        req.path = `/indexes/${this.index}${req.path}`;
        return this.requester.request(req, this.options);
    }
    process(cb, document) {
        return __awaiter(this, void 0, void 0, function* () {
            let maybeResults;
            let error = null;
            try {
                maybeResults = document
                    ? yield this.buffer.add(document)
                    : yield this.buffer.flush();
            }
            catch (err) {
                error = err;
            }
            cb(error, maybeResults);
        });
    }
}
exports.IndexStream = IndexStream;
//# sourceMappingURL=index-stream.js.map