import { SearchRequester } from './search-requester';
import { AzureSearchResponse, OptionsOrCallback, SearchCallback, SearchOptions, SearchRequest } from './types';
interface Named {
    name: string;
}
interface OptionalName<T> {
    name?: string;
}
/**
 * Base class for search resources
 */
export declare abstract class SearchResource<T extends Named> {
    protected requester: SearchRequester;
    private type;
    name: string;
    /**
     * Create new instance of the search resource
     * @param requester http handler
     * @param type the type of resource (should match /{resource}/ in the REST url path)
     * @param name the name of the current resource (should match /{resource}/{name} in the REST url path)
     */
    constructor(requester: SearchRequester, type: string, name: string);
    /**
     * Get the current schema
     * @param options optional request options
     */
    get(options?: SearchOptions): Promise<AzureSearchResponse<T>>;
    get(callback: SearchCallback<T>): void;
    get(options: SearchOptions, callback: SearchCallback<T>): void;
    /**
     * Delete this resource
     * @param options optional request options
     */
    delete(options?: SearchOptions): Promise<AzureSearchResponse<void>>;
    delete(callback: SearchCallback<void>): void;
    delete(options: SearchOptions, callback: SearchCallback<void>): void;
    /**
     * Update or create this resource
     * @param resource new definition
     * @param options optional request options
     */
    update(resource: OptionalName<T>, options?: SearchOptions): Promise<AzureSearchResponse<void>>;
    update(resource: OptionalName<T>, callback: SearchCallback<void>): void;
    update(resource: OptionalName<T>, options: SearchOptions, callback: SearchCallback<void>): void;
    protected request<T>(req: SearchRequest<T>, optionsOrCallback?: OptionsOrCallback<T>, callback?: SearchCallback<T>): Promise<AzureSearchResponse<T>>;
}
export {};
