"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const data_sources_1 = require("./data-sources");
const indexers_1 = require("./indexers");
const indexes_1 = require("./indexes");
const search_requester_1 = require("./search-requester");
const skill_sets_1 = require("./skill-sets");
const synonym_maps_1 = require("./synonym-maps");
const DEFAULT_VERSION = '2017-11-11';
var ApiVersion;
(function (ApiVersion) {
    ApiVersion["default"] = "2017-11-11";
    ApiVersion["preview"] = "2017-11-11-preview";
})(ApiVersion = exports.ApiVersion || (exports.ApiVersion = {}));
/** Azure Search service */
class SearchService {
    /**
     * Create a new Azure Search service client
     * @param service name of the service
     * @param adminKey one or both admin keys (currently only the first key is used)
     * @param defaultVersion default API version for each request (default can be overwritten for each request)
     */
    constructor(service, adminKey, defaultVersion = DEFAULT_VERSION) {
        this.service = service;
        this.defaultVersion = defaultVersion;
        this.requester = new search_requester_1.SearchRequester(service, adminKey, defaultVersion);
        this.dataSources = new data_sources_1.DataSources(this.requester);
        this.indexers = new indexers_1.Indexers(this.requester);
        this.indexes = new indexes_1.Indexes(this.requester);
        this.synonymMaps = new synonym_maps_1.SynonymMaps(this.requester);
        this.skillSets = new skill_sets_1.SkillSets(this.requester);
    }
    /**
     * Subscribe to search events
     * @param type event type (may be 'error', 'response', or 'request')
     * @param callback event handler
     */
    on(type, callback) {
        this.requester.events.on(type, callback);
    }
    /**
     * Remove an event listener
     * @param type event type (may be 'error', 'response', or 'request')
     * @param listener event handler to remove
     */
    removeListener(type, listener) {
        this.requester.events.removeListener(type, listener);
    }
    statistics(optionsOrCallback, callback) {
        return this.requester.request({
            method: 'get',
            path: '/servicestats',
        }, optionsOrCallback, callback);
    }
}
exports.SearchService = SearchService;
//# sourceMappingURL=search-service.js.map