"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const search_resource_group_1 = require("../search-resource-group");
const synonym_map_1 = require("./synonym-map");
__export(require("./synonym-map"));
/**
 * Manage Azure Search synonym map resources
 */
class SynonymMaps extends search_resource_group_1.SearchResourceGroup {
    /**
     * Manage Azure Search synonym map resources
     * @param requester http handler
     */
    constructor(requester) {
        super(requester, 'synonymmaps');
    }
    /**
     * Use a named synonym map
     * @param synonymMapName name of the synonym map
     */
    use(synonymMapName) {
        return new synonym_map_1.SynonymMap(this.requester, this.type, synonymMapName);
    }
}
exports.SynonymMaps = SynonymMaps;
//# sourceMappingURL=index.js.map