"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var PrebuiltTokenFilterName;
(function (PrebuiltTokenFilterName) {
    PrebuiltTokenFilterName["arabicNormalization"] = "arabic_normalization";
    PrebuiltTokenFilterName["apostrophe"] = "apostrophe";
    PrebuiltTokenFilterName["asciifolding"] = "asciifolding";
    PrebuiltTokenFilterName["cjkBigram"] = "cjk_bigram";
    PrebuiltTokenFilterName["cjkWidth"] = "cjk_width";
    PrebuiltTokenFilterName["classic"] = "classic";
    PrebuiltTokenFilterName["commonGrams"] = "common_grams";
    PrebuiltTokenFilterName["dictionaryDecompounder"] = "dictionary_decompounder";
    PrebuiltTokenFilterName["edgeNGram"] = "edgeNGram_v2";
    PrebuiltTokenFilterName["elision"] = "elision";
    PrebuiltTokenFilterName["germanNormalization"] = "german_normalization";
    PrebuiltTokenFilterName["hindiNormalization"] = "hindi_normalization";
    PrebuiltTokenFilterName["indicNormalization"] = "indic_normalization";
    PrebuiltTokenFilterName["keep"] = "keep";
    PrebuiltTokenFilterName["keywordMarker"] = "keyword_marker";
    PrebuiltTokenFilterName["keywordRepeat"] = "keyword_repeat";
    PrebuiltTokenFilterName["kstem"] = "kstem";
    PrebuiltTokenFilterName["length"] = "length";
    PrebuiltTokenFilterName["limit"] = "limit";
    PrebuiltTokenFilterName["lowercase"] = "lowercase";
    PrebuiltTokenFilterName["nGram"] = "nGram_v2";
    PrebuiltTokenFilterName["patternCapture"] = "pattern_capture";
    PrebuiltTokenFilterName["patternReplace"] = "pattern_replace";
    PrebuiltTokenFilterName["persianNormalization"] = "persian_normalization";
    PrebuiltTokenFilterName["phonetic"] = "phonetic";
    PrebuiltTokenFilterName["porterStem"] = "porter_stem";
    PrebuiltTokenFilterName["reverse"] = "reverse";
    PrebuiltTokenFilterName["scandinavianNormalization"] = "scandinavian_normalization";
    PrebuiltTokenFilterName["scandinavianFolding"] = "scandinavian_folding";
    PrebuiltTokenFilterName["shingle"] = "shingle";
    PrebuiltTokenFilterName["snowball"] = "snowball";
    PrebuiltTokenFilterName["soraniNormalization"] = "sorani_normalization";
    PrebuiltTokenFilterName["stemmer"] = "stemmer";
    PrebuiltTokenFilterName["stemmerOverride"] = "stemmer_override";
    PrebuiltTokenFilterName["stopwords"] = "stopwords";
    PrebuiltTokenFilterName["synonym"] = "synonym";
    PrebuiltTokenFilterName["trim"] = "trim";
    PrebuiltTokenFilterName["truncate"] = "truncate";
    PrebuiltTokenFilterName["unique"] = "unique";
    PrebuiltTokenFilterName["uppercase"] = "uppercase";
    PrebuiltTokenFilterName["wordDelimiter"] = "word_delimiter";
})(PrebuiltTokenFilterName = exports.PrebuiltTokenFilterName || (exports.PrebuiltTokenFilterName = {}));
var TokenFilterType;
(function (TokenFilterType) {
    TokenFilterType["asciiFolding"] = "#Microsoft.Azure.Search.AsciiFoldingTokenFilter";
    TokenFilterType["cjkBigram"] = "#Microsoft.Azure.Search.CjkBigramTokenFilter";
    TokenFilterType["commonGram"] = "#Microsoft.Azure.Search.CommonGramTokenFilter";
    TokenFilterType["dictionaryDecompounder"] = "#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter";
    TokenFilterType["edgeNGram"] = "#Microsoft.Azure.Search.EdgeNGramTokenFilterV2";
    TokenFilterType["elision"] = "#Microsoft.Azure.Search.ElisionTokenFilter";
    TokenFilterType["indicNormalization"] = "#Microsoft.Azure.Search.IndicNormalizationTokenFilter";
    TokenFilterType["keep"] = "#Microsoft.Azure.Search.KeepTokenFilter";
    TokenFilterType["keywordMarker"] = "#Microsoft.Azure.Search.KeywordMarkerTokenFilter";
    TokenFilterType["length"] = "#Microsoft.Azure.Search.LengthTokenFilter";
    TokenFilterType["limit"] = "#Microsoft.Azure.Search.LimitTokenFilter";
    TokenFilterType["nGram"] = "#Microsoft.Azure.Search.NGramTokenFilterV2";
    TokenFilterType["patternCapture"] = "#Microsoft.Azure.Search.PatternCaptureTokenFilter";
    TokenFilterType["patternReplace"] = "#Microsoft.Azure.Search.PatternReplaceTokenFilter";
    TokenFilterType["phonetic"] = "#Microsoft.Azure.Search.PhoneticTokenFilter";
    TokenFilterType["shingle"] = "#Microsoft.Azure.Search.ShingleTokenFilter";
    TokenFilterType["snowball"] = "#Microsoft.Azure.Search.SnowballTokenFilter";
    TokenFilterType["soraniNormalization"] = "#Microsoft.Azure.Search.SoraniNormalizationTokenFilter";
    TokenFilterType["stemmer"] = "#Microsoft.Azure.Search.StemmerTokenFilter";
    TokenFilterType["stemmerOverride"] = "#Microsoft.Azure.Search.StemmerOverrideTokenFilter";
    TokenFilterType["stopwords"] = "#Microsoft.Azure.Search.StopwordsTokenFilter";
    TokenFilterType["synonym"] = "#Microsoft.Azure.Search.SynonymTokenFilter";
    TokenFilterType["truncate"] = "#Microsoft.Azure.Search.TruncateTokenFilter";
    TokenFilterType["unique"] = "#Microsoft.Azure.Search.UniqueTokenFilter";
    TokenFilterType["wordDelimiter"] = "#Microsoft.Azure.Search.WordDelimiterTokenFilter";
})(TokenFilterType = exports.TokenFilterType || (exports.TokenFilterType = {}));
var CjkScript;
(function (CjkScript) {
    CjkScript["han"] = "han";
    CjkScript["hiragana"] = "hiragana";
    CjkScript["katakana"] = "katakana";
    CjkScript["hangul"] = "hangul";
})(CjkScript = exports.CjkScript || (exports.CjkScript = {}));
var NGramSide;
(function (NGramSide) {
    NGramSide["front"] = "front";
    NGramSide["back"] = "back";
})(NGramSide = exports.NGramSide || (exports.NGramSide = {}));
var PhoneticEncoder;
(function (PhoneticEncoder) {
    PhoneticEncoder["metaphone"] = "metaphone";
    PhoneticEncoder["doubleMetaphone"] = "doubleMetaphone";
    PhoneticEncoder["soundex"] = "soundex";
    PhoneticEncoder["refinedSoundex"] = "refinedSoundex";
    PhoneticEncoder["caverphone1"] = "caverphone1";
    PhoneticEncoder["caverphone2"] = "caverphone2";
    PhoneticEncoder["cologne"] = "cologne";
    PhoneticEncoder["nysiis"] = "nysiis";
    PhoneticEncoder["koelnerPhonetik"] = "koelnerPhonetik";
    PhoneticEncoder["haasePhonetik"] = "haasePhonetik";
    PhoneticEncoder["beiderMorse"] = "beiderMorse";
})(PhoneticEncoder = exports.PhoneticEncoder || (exports.PhoneticEncoder = {}));
var SnowballLanguage;
(function (SnowballLanguage) {
    SnowballLanguage["armenian"] = "armenian";
    SnowballLanguage["basque"] = "basque";
    SnowballLanguage["catalan"] = "catalan";
    SnowballLanguage["danish"] = "danish";
    SnowballLanguage["dutch"] = "dutch";
    SnowballLanguage["english"] = "english";
    SnowballLanguage["finnish"] = "finnish";
    SnowballLanguage["french"] = "french";
    SnowballLanguage["german"] = "german";
    SnowballLanguage["german2"] = "german2";
    SnowballLanguage["hungarian"] = "hungarian";
    SnowballLanguage["italian"] = "italian";
    SnowballLanguage["kp"] = "kp";
    SnowballLanguage["lovins"] = "lovins";
    SnowballLanguage["norwegian"] = "norwegian";
    SnowballLanguage["porter"] = "porter";
    SnowballLanguage["portuguese"] = "portuguese";
    SnowballLanguage["romanian"] = "romanian";
    SnowballLanguage["russian"] = "russian";
    SnowballLanguage["spanish"] = "spanish";
    SnowballLanguage["swedish"] = "swedish";
    SnowballLanguage["turkish"] = "turkish";
})(SnowballLanguage = exports.SnowballLanguage || (exports.SnowballLanguage = {}));
var StemmerLanguage;
(function (StemmerLanguage) {
    StemmerLanguage["arabic"] = "arabic";
    StemmerLanguage["armenian"] = "armenian";
    StemmerLanguage["basque"] = "basque";
    StemmerLanguage["brazilian"] = "brazilian";
    StemmerLanguage["bulgarian"] = "bulgarian";
    StemmerLanguage["catalan"] = "catalan";
    StemmerLanguage["czech"] = "czech";
    StemmerLanguage["danish"] = "danish";
    StemmerLanguage["dutch"] = "dutch";
    StemmerLanguage["dutchKp"] = "dutchKp";
    StemmerLanguage["english"] = "english";
    StemmerLanguage["lightEnglish"] = "lightEnglish";
    StemmerLanguage["minimalEnglish"] = "minimalEnglish";
    StemmerLanguage["possessiveEnglish"] = "possessiveEnglish";
    StemmerLanguage["porter2"] = "porter2";
    StemmerLanguage["lovins"] = "lovins";
    StemmerLanguage["finnish"] = "finnish";
    StemmerLanguage["lightFinnish"] = "lightFinnish";
    StemmerLanguage["french"] = "french";
    StemmerLanguage["lightFrench"] = "lightFrench";
    StemmerLanguage["minimalFrench"] = "minimalFrench";
    StemmerLanguage["galician"] = "galician";
    StemmerLanguage["minimalGalician"] = "minimalGalician";
    StemmerLanguage["german"] = "german";
    StemmerLanguage["german2"] = "german2";
    StemmerLanguage["lightGerman"] = "lightGerman";
    StemmerLanguage["minimalGerman"] = "minimalGerman";
    StemmerLanguage["greek"] = "greek";
    StemmerLanguage["hindi"] = "hindi";
    StemmerLanguage["hungarian"] = "hungarian";
    StemmerLanguage["lightHungarian"] = "lightHungarian";
    StemmerLanguage["indonesian"] = "indonesian";
    StemmerLanguage["irish"] = "irish";
    StemmerLanguage["italian"] = "italian";
    StemmerLanguage["lightItalian"] = "lightItalian";
    StemmerLanguage["sorani"] = "sorani";
    StemmerLanguage["latvian"] = "latvian";
    StemmerLanguage["norwegian"] = "norwegian";
    StemmerLanguage["lightNorwegian"] = "lightNorwegian";
    StemmerLanguage["minimalNorwegian"] = "minimalNorwegian";
    StemmerLanguage["lightNynorsk"] = "lightNynorsk";
    StemmerLanguage["minimalNynorsk"] = "minimalNynorsk";
    StemmerLanguage["portuguese"] = "portuguese";
    StemmerLanguage["lightPortuguese"] = "lightPortuguese";
    StemmerLanguage["minimalPortuguese"] = "minimalPortuguese";
    StemmerLanguage["portugueseRslp"] = "portugueseRslp";
    StemmerLanguage["romanian"] = "romanian";
    StemmerLanguage["russian"] = "russian";
    StemmerLanguage["lightRussian"] = "lightRussian";
    StemmerLanguage["spanish"] = "spanish";
    StemmerLanguage["lightSpanish"] = "lightSpanish";
    StemmerLanguage["swedish"] = "swedish";
    StemmerLanguage["lightSwedish"] = "lightSwedish";
    StemmerLanguage["turkish"] = "turkish";
})(StemmerLanguage = exports.StemmerLanguage || (exports.StemmerLanguage = {}));
var StopwordsList;
(function (StopwordsList) {
    StopwordsList["arabic"] = "arabic";
    StopwordsList["armenian"] = "armenian";
    StopwordsList["basque"] = "basque";
    StopwordsList["brazilian"] = "brazilian";
    StopwordsList["bulgarian"] = "bulgarian";
    StopwordsList["catalan"] = "catalan";
    StopwordsList["czech"] = "czech";
    StopwordsList["danish"] = "danish";
    StopwordsList["dutch"] = "dutch";
    StopwordsList["english"] = "english";
    StopwordsList["finnish"] = "finnish";
    StopwordsList["french"] = "french";
    StopwordsList["galician"] = "galician";
    StopwordsList["german"] = "german";
    StopwordsList["greek"] = "greek";
    StopwordsList["hindi"] = "hindi";
    StopwordsList["hungarian"] = "hungarian";
    StopwordsList["indonesian"] = "indonesian";
    StopwordsList["irish"] = "irish";
    StopwordsList["italian"] = "italian";
    StopwordsList["latvian"] = "latvian";
    StopwordsList["norwegian"] = "norwegian";
    StopwordsList["persian"] = "persian";
    StopwordsList["portuguese"] = "portuguese";
    StopwordsList["romanian"] = "romanian";
    StopwordsList["russian"] = "russian";
    StopwordsList["sorani"] = "sorani";
    StopwordsList["spanish"] = "spanish";
    StopwordsList["swedish"] = "swedish";
    StopwordsList["thai"] = "thai";
    StopwordsList["turkish"] = "turkish";
})(StopwordsList = exports.StopwordsList || (exports.StopwordsList = {}));
//# sourceMappingURL=token-filters.js.map