"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var PrebuiltTokenizerName;
(function (PrebuiltTokenizerName) {
    PrebuiltTokenizerName["classic"] = "classic";
    PrebuiltTokenizerName["edgeNGram"] = "edgeNGram";
    PrebuiltTokenizerName["keyword"] = "keyword_v2";
    PrebuiltTokenizerName["letter"] = "letter";
    PrebuiltTokenizerName["lowercase"] = "lowercase";
    PrebuiltTokenizerName["microsoftLanguage"] = "microsoft_language_tokenizer";
    PrebuiltTokenizerName["microsoftLanguageStemming"] = "microsoft_language_stemming_tokenizer";
    PrebuiltTokenizerName["nGram"] = "nGram";
    PrebuiltTokenizerName["pathHierarchy"] = "path_hierarchy_v2";
    PrebuiltTokenizerName["pattern"] = "pattern";
    PrebuiltTokenizerName["standard"] = "standard_v2";
    PrebuiltTokenizerName["uaxUrlEmail"] = "uax_url_email";
    PrebuiltTokenizerName["whitespace"] = "whitespace";
})(PrebuiltTokenizerName = exports.PrebuiltTokenizerName || (exports.PrebuiltTokenizerName = {}));
var TokenizerType;
(function (TokenizerType) {
    TokenizerType["classic"] = "#Microsoft.Azure.Search.ClassicTokenizer";
    TokenizerType["edgeNGram"] = "#Microsoft.Azure.Search.EdgeNGramTokenizer";
    TokenizerType["keyword"] = "#Microsoft.Azure.Search.KeywordTokenizerV2";
    TokenizerType["microsoftLanguage"] = "#Microsoft.Azure.Search.MicrosoftLanguageTokenizer";
    TokenizerType["microsoftLanguageStemming"] = "#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer";
    TokenizerType["nGram"] = "#Microsoft.Azure.Search.NGramTokenizer";
    TokenizerType["pathHierarchy"] = "#Microsoft.Azure.Search.PathHierarchyTokenizerV2";
    TokenizerType["pattern"] = "#Microsoft.Azure.Search.PatternTokenizer";
    TokenizerType["standard"] = "#Microsoft.Azure.Search.StandardTokenizerV2";
    TokenizerType["uaxUrlEmail"] = "#Microsoft.Azure.Search.UaxUrlEmailTokenizer";
})(TokenizerType = exports.TokenizerType || (exports.TokenizerType = {}));
var TokenChar;
(function (TokenChar) {
    TokenChar["letter"] = "letter";
    TokenChar["digit"] = "digit";
    TokenChar["whitespace"] = "whitespace";
    TokenChar["punctuation"] = "punctuation";
    TokenChar["symbol"] = "symbol";
})(TokenChar = exports.TokenChar || (exports.TokenChar = {}));
var MicrosoftTokenizerLanguage;
(function (MicrosoftTokenizerLanguage) {
    MicrosoftTokenizerLanguage["bangla"] = "bangla";
    MicrosoftTokenizerLanguage["bulgarian"] = "bulgarian";
    MicrosoftTokenizerLanguage["catalan"] = "catalan";
    MicrosoftTokenizerLanguage["chineseSimplified"] = "chineseSimplified";
    MicrosoftTokenizerLanguage["chineseTraditional"] = "chineseTraditional";
    MicrosoftTokenizerLanguage["croatian"] = "croatian";
    MicrosoftTokenizerLanguage["czech"] = "czech";
    MicrosoftTokenizerLanguage["danish"] = "danish";
    MicrosoftTokenizerLanguage["dutch"] = "dutch";
    MicrosoftTokenizerLanguage["english"] = "english";
    MicrosoftTokenizerLanguage["french"] = "french";
    MicrosoftTokenizerLanguage["german"] = "german";
    MicrosoftTokenizerLanguage["greek"] = "greek";
    MicrosoftTokenizerLanguage["gujarati"] = "gujarati";
    MicrosoftTokenizerLanguage["hindi"] = "hindi";
    MicrosoftTokenizerLanguage["icelandic"] = "icelandic";
    MicrosoftTokenizerLanguage["indonesian"] = "indonesian";
    MicrosoftTokenizerLanguage["italian"] = "italian";
    MicrosoftTokenizerLanguage["japanese"] = "japanese";
    MicrosoftTokenizerLanguage["kannada"] = "kannada";
    MicrosoftTokenizerLanguage["korean"] = "korean";
    MicrosoftTokenizerLanguage["malay"] = "malay";
    MicrosoftTokenizerLanguage["malayalam"] = "malayalam";
    MicrosoftTokenizerLanguage["marathi"] = "marathi";
    MicrosoftTokenizerLanguage["norwegianBokmaal"] = "norwegianBokmaal";
    MicrosoftTokenizerLanguage["polish"] = "polish";
    MicrosoftTokenizerLanguage["portuguese"] = "portuguese";
    MicrosoftTokenizerLanguage["portugueseBrazilian"] = "portugueseBrazilian";
    MicrosoftTokenizerLanguage["punjabi"] = "punjabi";
    MicrosoftTokenizerLanguage["romanian"] = "romanian";
    MicrosoftTokenizerLanguage["russian"] = "russian";
    MicrosoftTokenizerLanguage["serbianCyrillic"] = "serbianCyrillic";
    MicrosoftTokenizerLanguage["serbianLatin"] = "serbianLatin";
    MicrosoftTokenizerLanguage["slovenian"] = "slovenian";
    MicrosoftTokenizerLanguage["spanish"] = "spanish";
    MicrosoftTokenizerLanguage["swedish"] = "swedish";
    MicrosoftTokenizerLanguage["tamil"] = "tamil";
    MicrosoftTokenizerLanguage["telugu"] = "telugu";
    MicrosoftTokenizerLanguage["thai"] = "thai";
    MicrosoftTokenizerLanguage["ukrainian"] = "ukrainian";
    MicrosoftTokenizerLanguage["urdu"] = "urdu";
    MicrosoftTokenizerLanguage["vietnamese"] = "vietnamese";
})(MicrosoftTokenizerLanguage = exports.MicrosoftTokenizerLanguage || (exports.MicrosoftTokenizerLanguage = {}));
var MicrosoftStemmingTokenizerLanguage;
(function (MicrosoftStemmingTokenizerLanguage) {
    MicrosoftStemmingTokenizerLanguage["arabic"] = "arabic";
    MicrosoftStemmingTokenizerLanguage["bangla"] = "bangla";
    MicrosoftStemmingTokenizerLanguage["bulgarian"] = "bulgarian";
    MicrosoftStemmingTokenizerLanguage["catalan"] = "catalan";
    MicrosoftStemmingTokenizerLanguage["croatian"] = "croatian";
    MicrosoftStemmingTokenizerLanguage["czech"] = "czech";
    MicrosoftStemmingTokenizerLanguage["danish"] = "danish";
    MicrosoftStemmingTokenizerLanguage["dutch"] = "dutch";
    MicrosoftStemmingTokenizerLanguage["english"] = "english";
    MicrosoftStemmingTokenizerLanguage["estonian"] = "estonian";
    MicrosoftStemmingTokenizerLanguage["finnish"] = "finnish";
    MicrosoftStemmingTokenizerLanguage["french"] = "french";
    MicrosoftStemmingTokenizerLanguage["german"] = "german";
    MicrosoftStemmingTokenizerLanguage["greek"] = "greek";
    MicrosoftStemmingTokenizerLanguage["gujarati"] = "gujarati";
    MicrosoftStemmingTokenizerLanguage["hebrew"] = "hebrew";
    MicrosoftStemmingTokenizerLanguage["hindi"] = "hindi";
    MicrosoftStemmingTokenizerLanguage["hungarian"] = "hungarian";
    MicrosoftStemmingTokenizerLanguage["icelandic"] = "icelandic";
    MicrosoftStemmingTokenizerLanguage["indonesian"] = "indonesian";
    MicrosoftStemmingTokenizerLanguage["italian"] = "italian";
    MicrosoftStemmingTokenizerLanguage["kannada"] = "kannada";
    MicrosoftStemmingTokenizerLanguage["latvian"] = "latvian";
    MicrosoftStemmingTokenizerLanguage["lithuanian"] = "lithuanian";
    MicrosoftStemmingTokenizerLanguage["malay"] = "malay";
    MicrosoftStemmingTokenizerLanguage["malayalam"] = "malayalam";
    MicrosoftStemmingTokenizerLanguage["marathi"] = "marathi";
    MicrosoftStemmingTokenizerLanguage["norwegianBokmaal"] = "norwegianBokmaal";
    MicrosoftStemmingTokenizerLanguage["polish"] = "polish";
    MicrosoftStemmingTokenizerLanguage["portuguese"] = "portuguese";
    MicrosoftStemmingTokenizerLanguage["portugueseBrazilian"] = "portugueseBrazilian";
    MicrosoftStemmingTokenizerLanguage["punjabi"] = "punjabi";
    MicrosoftStemmingTokenizerLanguage["romanian"] = "romanian";
    MicrosoftStemmingTokenizerLanguage["russian"] = "russian";
    MicrosoftStemmingTokenizerLanguage["serbianCyrillic"] = "serbianCyrillic";
    MicrosoftStemmingTokenizerLanguage["serbianLatin"] = "serbianLatin";
    MicrosoftStemmingTokenizerLanguage["slovak"] = "slovak";
    MicrosoftStemmingTokenizerLanguage["slovenian"] = "slovenian";
    MicrosoftStemmingTokenizerLanguage["spanish"] = "spanish";
    MicrosoftStemmingTokenizerLanguage["swedish"] = "swedish";
    MicrosoftStemmingTokenizerLanguage["tamil"] = "tamil";
    MicrosoftStemmingTokenizerLanguage["telugu"] = "telugu";
    MicrosoftStemmingTokenizerLanguage["turkish"] = "turkish";
    MicrosoftStemmingTokenizerLanguage["ukrainian"] = "ukrainian";
    MicrosoftStemmingTokenizerLanguage["urdu"] = "urdu";
})(MicrosoftStemmingTokenizerLanguage = exports.MicrosoftStemmingTokenizerLanguage || (exports.MicrosoftStemmingTokenizerLanguage = {}));
var PatternFlags;
(function (PatternFlags) {
    PatternFlags["canonEq"] = "CANON_EQ";
    PatternFlags["caseInsensitive"] = "CASE_INSENSITIVE";
    PatternFlags["comments"] = "COMMENTS";
    PatternFlags["dotAll"] = "DOTALL";
    PatternFlags["literal"] = "LITERAL";
    PatternFlags["multiline"] = "MULTILINE";
    PatternFlags["unicodeCase"] = "UNICODE_CASE";
    PatternFlags["unixLines"] = "UNIX_LINES";
})(PatternFlags = exports.PatternFlags || (exports.PatternFlags = {}));
//# sourceMappingURL=tokenizers.js.map