export interface List<T> {
  value: T[];
}

export interface OData<T = string> {
  '@odata.type': T;
  name: string;
}

export interface Options {
  [option: string]: any;
}

export interface ServiceCounter {
  usage: number;
  quota: number;
}

export interface ServiceStatisticsResult {
  counters: {
    documentCount: ServiceCounter;
    indexesCount: ServiceCounter;
    indexersCount: ServiceCounter;
    dataSourcesCount: ServiceCounter;
    storageSize: ServiceCounter;
    synonymMaps: ServiceCounter;
  };
  limits: {
    maxFieldsPerIndex: number;
    maxIndexerRunTime: string;
    maxFileExtractionSize: number;
    maxFileContentCharactersToExtract: number;
  };
}

export * from './indexes';
export * from './data-sources';
export * from './indexers';
export * from './synonym-maps';
export * from './skill-sets';
