"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Preferences = void 0;
var config_class_1 = require("./config.class");
var defaultPreferences = {
    align: 'left',
    boldHeaders: true,
    columnHeaderAlign: 'left',
    columnHeaderVAlign: 'bottom',
    headerBorders: true,
    horizontalBorders: false,
    numberAlign: 'right',
    rowHeaderAlign: 'right',
    rowHeaderVAlign: 'top',
    tableBorders: true,
    valign: 'top',
    verticalBorders: false
};
var Preferences = /** @class */ (function () {
    function Preferences(override) {
        this._value = Object.assign({}, defaultPreferences);
        if (override) {
            this.value = override;
        }
    }
    Object.defineProperty(Preferences.prototype, "value", {
        /** Get a copy of preferences */
        get: function () {
            return Object.assign({}, this._value);
        },
        /** sanitze and update */
        set: function (preferences) {
            var sane = {};
            if (preferences && typeof preferences === 'object') {
                for (var _i = 0, _a = ['align', 'columnHeaderAlign', 'rowHeaderAlign']; _i < _a.length; _i++) {
                    var alignKey = _a[_i];
                    if (alignKey in preferences && preferences[alignKey] != null) {
                        sane[alignKey] = config_class_1.CONFIG_ALIGN.includes(preferences[alignKey]) ? preferences[alignKey] : undefined;
                    }
                }
                for (var _b = 0, _c = ['valign', 'columnHeaderVAlign', 'rowHeaderVAlign']; _b < _c.length; _b++) {
                    var valignKey = _c[_b];
                    if (valignKey in preferences && preferences[valignKey] != null) {
                        sane[valignKey] = config_class_1.CONFIG_VALIGN.includes(preferences[valignKey]) ? preferences[valignKey] : undefined;
                    }
                }
                for (var _d = 0, _e = ['boldHeaders', 'headerBorders', 'horizontalBorders', 'tableBorders', 'verticalBorders']; _d < _e.length; _d++) {
                    var booleanKey = _e[_d];
                    if (booleanKey in preferences && preferences[booleanKey] != null) {
                        sane[booleanKey] = !!preferences[booleanKey];
                    }
                }
            }
            Object.assign(this._value, preferences);
        },
        enumerable: false,
        configurable: true
    });
    return Preferences;
}());
exports.Preferences = Preferences;
