"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.outputFormatterCSV = void 0;
var dblQuoteRx = /\"/g;
var nonSimpleRx = /[^a-z_0-9]/i;
function outputFormatterCSV(renderData, options) {
    var cellValueRendered = renderData.cellValueRendered, columns = renderData.columns, rows = renderData.rows, startX = renderData.startX, startY = renderData.startY;
    var out = '';
    var separator = (options === null || options === void 0 ? void 0 : options.tsv) ? '\t' : ',';
    for (var y = startY; y < rows; y++) {
        for (var x = startX; x < columns; x++) {
            var rendered = cellValueRendered[x][y];
            var content = rendered.match(nonSimpleRx) ? "\"".concat(rendered.replace(dblQuoteRx, '""'), "\"") : rendered;
            out += (x > startX ? separator : '') + content;
        }
        out += '\n';
    }
    return out;
}
exports.outputFormatterCSV = outputFormatterCSV;
